@echo off
:: PDumpCtl - ProcDump control front-end
::	      Dump named process/pid or run interactive
::	      OK to exit to shell and update options

:: Copyright (c) 2001, 2006 Steven Levine and Associates, Inc.
:: All rights reserved.

rem $TLIB$: $ &(#) %n - Ver %v, %f $
rem TLIB: $ $

:: 27 Jun 01 SHL Baseline
:: 21 Jan 04 SHL Add -f -x options
:: 14 Jun 05 SHL Add -a option
:: 05 Jul 05 SHL Update usage
:: 08 Jul 05 SHL Support dec/hex pid and quoted name
:: 09 Dec 06 SHL Add sysvm to full mode to allow .m commands

on errormsg pause
setlocal

:: Scan args, I=num A=value X=scratch

set D=		%+ :: Dump directory
set M=a		%+ :: Auto/Interactive (a/i)
set N=		%+ :: Process name
set P=		%+ :: Pid
set T=n		%+ :: Normal/Full/eXtended

:: N and P mutually exclusive

do I = 1 to %[#]
  set A=%[%I]
  set X=%@substr[%A,0,1]
  iff "%X" eq "/" .or. "%X" eq "-" then
    :: Got switch
    set X=%@lower[%@substr[%A,1,1]]
    iff "%X" == "h" .or. "%X" == "?" then
      goto Help
    elseiff "%X" == "a" then
      set T=a
    elseiff "%X" == "f" then
      set T=f
    elseiff "%X" == "i" then
      set M=i
    elseiff "%X" == "x" then
      set T=x
    else
      echo Switch %X unexpected
      goto Usage
    endiff
  else
    :: Got proc/pid - detect/convert decimal to hex
    set P=%A
    iff '%@left[1,%P]' == '%="' then
      set N=%@strip[%=",%P]
      set P=
    elseiff "%@left[2,%A]" == "0x" then
      set P=%@substr[%P,2,100]
      set X=%@convert[16,16,%P]
      if "%P" != "%X" ( echo Bad PID %+ goto usage )
    elseiff "%@left[2, %P]" == "0n" then
      set P=%@substr[%P,2,100]
      set X=%@convert[10,10,%P]
      if "%P" != "%X" ( echo Bad PID %+ goto usage )
      set P=%@convert[10,16,%P]
    else
      :: Try for hext PID
      set X=%@convert[16,16,%P]
      if "%P" != "%X" ( set N=%P %+ set P= )
    endiff
  endiff
enddo

if %M == a if "%P %N" == " " ( echo No process/pid selected %+ goto usage )

:: Set defaults

echo on
pdumpusr reset
@echo off

iff isdir c:\ then
  set D=c:\
elseiff isdir c:\ then
  set D=c:\
elseiff isdir c:\ then
  set D=c:\
else
  echo Dump directory not found - checked i:\Dumps d:\tmp\Dumps and j:\tmp\Dumps
  cancel
endiff

echo.
echo on
procdump on /l:%D
@echo off

:: instance	Instance data referenced by the process.
:: krheaps	Kernel Resident Heaps
:: ksheaps	Kernel Swappable Heaps
:: idt          Interrupt descriptor table
:: laddr	Linear address range(s)
:: mvdm		MVDM instance data for process
:: paddr(all)	Add physical memory
:: private	Private code and data referenced by process
:: sem		Semaphore information for all blocked threads in process
:: shared	Shared code and data referenced by process
:: summ		Summary for dumped threads
:: sysfs	File System data for all processes
:: sysio	IO subsystem structures (AIRQI, DIRQ, PDD eps, PDD chain)
:: sysldr	Loader data for all processes
:: sysmvdm	MVDM data for all VDM and the kernel resident heap
:: syspg	Physical and Page Memory management records (PF, VP, PTE, PDE)
:: syssem	SEM data for all blocked threads in system
:: syssumm	Summary for all threads
:: systk	Task Management related data for all processes
:: sysvm	Virtual Memory data for all processes

iff "%T" == "a" then
  :: All physical memory
  echo on
  pdumpusr paddr(all)
  @echo off
endiff

iff "%T" == "f" then
  :: Full
  echo on
  pdumpusr summ,sysfs,sysldr,private,instance,syssem,sysio
  @echo off
endiff

iff "%T" == "x" then
  :: Extended
  echo on
  pdumpusr summ,sysfs,sysldr,private,instance,syssem,sysio
  pdumpusr shared,update
  @echo off
endiff

echo on
procdump query
@echo off

:: Check forced dump request using current settings
iff %M=a then
  procdump query
  iff "%P" != "" then
    echo Dumping PID %P
    procdump force /pid:%P
  else
    echo Dumping process %N
    procdump force /proc:%N
  endiff
  procdump off
  procdump query
  quit
endiff

:: Interactive

do forever
  iff "%P" != "" then
    :: echo.
    echo PID %P selected
    echo.
  elseiff "%N" != "" then
    :: echo.
    echo Process %N selected
    echo.
  endiff
  inkey /k"adfhorsvq!?[Esc][Enter]" `D)ump F)ull S)hared A)ll R)eset V)iew O)ff H)elp Q)uit ? ` %%Z
  echo.
  iff "%Z" == "q" .or. "%Z" == "" then
    leave
  elseiff "%Z" == "@28" then
    iterate
  elseiff %Z == a then
    :: All physical memory
    echo on
    pdumpusr reset
    pdumpusr paddr(all)
    pdumpusr query
    @echo off
  elseiff %Z == d then
    :: Force dump now
    iff "%P" != "" then
      echo Dumping PID %P
      echo on
      procdump force /pid:%P
      @echo off
    elseiff "%N" != "" then
      echo Dumping process %N
      echo on
      procdump force /proc:%N
      @echo off
    else
      echo No process/pid selected
    endiff
  elseiff %Z == f then
    :: Full
    echo on
    :: pdumpusr reset
    pdumpusr summ,sysfs,private,instance,syssem,sysio,sysldr,sysvm,update
    pdumpusr query
    @echo off
  elseiff %Z == o then
    :: Off
    echo on
    procdump off
    @echo off
  elseiff %Z == r then
    :: Reset to default
    echo on
    procdump reset /pid:all
    procdump on /l:%D
    pdumpusr reset
    procdump query
    @echo off
  elseiff %Z == v then
    :: Status
    echo on
    procdump query
    @echo off
  elseiff %Z == s then
    :: Add shared
    echo on
    pdumpusr shared,update
    pdumpusr query
    @echo off
  elseiff "%Z" == "!" then
    :: Shell
    echo.
    %comspec
  elseiff "%Z" == "h" .or. "%Z" == "?" then
    :: Help
    echo D - Force dump using current settings
    echo F - Set up for full dump - adds summ,sysfs,sysldr,private,instance,syssem,sysio
    echo S - Add shared code/data to current settings
    echo A - Set up to dump all physical memory with paddr(all) - resets other settings
    echo V - View current settings
    echo O - Turn off dump facility
    echo R - Reset to default settings
    echo H - Display this screen
    echo Q - Quit
    echo ? - Display this screen
    echo ! - Shell
  else
    pause Unexpected %Z
    cancel
  endiff
enddo

:: Show exit state
echo on
procdump query
@echo off

quit

::=== Usage: Report usage error ===

:Usage
  beep
  echo Usage: %@lower[%0] `[-?] [-f] [-i] [-x] [procname|hex-pid|dec-pid]`
  cancel

::=== Help: Show usage help ===

:Help
  echo.
  echo Usage: %@lower[%0] `[-?] [-f] [-i] [-x] [procname|hex-pid|dec-pid]`
  echo.
  echo ` -?        This message`
  echo ` -f        Full (default=normal)`
  echo ` -i        Interactive (default=force dump and exit)`
  echo ` -x        Extended, full plus shared (default=normal)`
  echo.
  echo ` hex-pid   hex pid, optionally prefix 0x`
  echo ` dec-pid   decimal pid, prefix with 0n`
  echo ` procname  Process name, quote if name lots like number`
  cancel

:end
