/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20060912
 *
 * Disassembly of (null), Thu Jun  5 23:26:13 2008
 *
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x0000A113 (41235)
 *     Revision         0x01
 *     OEM ID           "HP-MCD"
 *     OEM Table ID     "CJ DSDT "
 *     OEM Revision     0x07130000 (118685696)
 *     Creator ID       "MSFT"
 *     Creator Revision 0x0100000C (16777228)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "HP-MCD", "CJ DSDT ", 0x07130000)
{
    Scope (_PR)
    {
        Processor (CPU0, 0x00, 0x00008010, 0x06) {}
    }

    Name (_S0, Package (0x03)
    {
        0x05, 
        0x05, 
        0x00
    })
    Name (_S1, Package (0x03)
    {
        0x04, 
        0x04, 
        0x00
    })
    Name (_S2, Package (0x03)
    {
        0x03, 
        0x03, 
        0x00
    })
    Name (_S3, Package (0x03)
    {
        0x01, 
        0x01, 
        0x00
    })
    Name (_S4, Package (0x03)
    {
        0x00, 
        0x00, 
        0x00
    })
    Name (_S5, Package (0x03)
    {
        0x00, 
        0x00, 
        0x00
    })
    OperationRegion (KBDP, SystemIO, 0x60, 0x05)
    Field (KBDP, ByteAcc, NoLock, Preserve)
    {
        KP60,   8, 
                Offset (0x04), 
        KP64,   8
    }

    Method (_PTS, 1, NotSerialized)
    {
        If (LLess (Arg0, 0x04))
        {
            If (LGreaterEqual (Arg0, 0x02))
            {
                Store (0x01, \_SB.PCI0.CRST)
            }
            Else
            {
                Store (0x00, \_SB.PCI0.CRST)
            }
        }

        If (LEqual (Arg0, 0x03))
        {
            If (\_SB.PCI0.ISA.ECOK ())
            {
                Store (0x01, \_SB.PCI0.ISA.EC0.VGAQ)
                Sleep (0xC8)
            }

            If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
            {
                Or (Not (\_SB.PCI0.FDS.CEVN), 0x40, \_SB.PCI0.FDS.CEVN)
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    If (\_SB.PCI0.ISA.EC0.EQBF)
                    {
                        Store (0x01, \_SB.QBST)
                        Store (0x00, \_SB.PCI0.ISA.EC0.EQBF)
                        Sleep (0x32)
                    }
                }
            }

            If (LEqual (\_SB.PCI0.OSNT, 0x00))
            {
                And (KP64, 0x02, Local0)
                While (Local0)
                {
                    And (KP64, 0x02, Local0)
                }

                Store (0xD1, KP64)
                And (KP64, 0x02, Local1)
                While (Local1)
                {
                    And (KP64, 0x02, Local1)
                }

                Store (0xDF, KP60)
            }
        }

        If (LEqual (Arg0, 0x04))
        {
            If (LEqual (\_SB.PCI0.ISA.SPR.EJX, 0x04))
            {
                Store (0x00, \_SB.PCI0.ISA.SPR.EJX)
            }
            Else
            {
                \_SB.PCI0.ISA.HPSS (0x0C)
            }

            Store (\_SB.PCI0.ISA.DKTP, \_SB.DCTM)
        }
    }

    Method (_WAK, 1, NotSerialized)
    {
        Store (\_SB.PCI0.ISA.EC0.DCID, \_SB.CUDC)
        If (LEqual (Arg0, 0x04))
        {
            Store (\_SB.DCTM, \_SB.PCI0.ISA.DKTP)
            If (\_SB.PCI0.ISA.EC0.DCWT)
            {
                Or (\_SB.DCKF, 0x08, \_SB.DCKF)
            }

            \_SB.PCI0.ISA.HPSS (0x0D)
        }

        If (LEqual (Arg0, 0x03))
        {
            If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
            {
                If (\_SB.QBST)
                {
                    Store (0x01, \_SB.PCI0.ISA.EC0.EQBF)
                    Store (0x00, \_SB.QBST)
                    Sleep (0x32)
                }

                And (Not (\_SB.PCI0.FDS.CEVN), 0xBF, \_SB.PCI0.FDS.CEVN)
            }
        }

        If (\_SB.CUDC)
        {
            If (\_SB.PCI0.ISA.EC0.EJWK)
            {
                Store (0x00, \_SB.PCI0.ISA.EC0.LDDS)
                Store (0x01, \_SB.PCI0.ISA.EC0.DCWT)
            }

            If (LNotEqual (\_SB.CUDC, \_SB.PCI0.ISA.DKTP))
            {
                If (\_SB.PCI0.ISA.EC0.EJWK)
                {
                    Or (\_SB.DCKF, 0x10, \_SB.DCKF)
                    Store (0x01, \_SB.PCI0.ISA.EC0.UDR0)
                }
                Else
                {
                    \_SB.PCI0.ISA.EC0._Q04 ()
                }
            }
            Else
            {
                If (LEqual (Arg0, 0x04))
                {
                    Store (0x01, \_SB.PCI0.ISA.EC0.LDDS)
                }
            }
        }
        Else
        {
            Store (0x00, \_SB.PCI0.ISA.DKTP)
        }

        Store (0x00, Local2)
        If (LEqual (\_SB.PCI0.ISA.EC0.EXFD, 0x01))
        {
            Or (Local2, 0x01, Local2)
        }

        If (LEqual (\_SB.PCI0.ISA.EC0.FDD, 0x01))
        {
            Or (Local2, 0x02, Local2)
        }
        Else
        {
            If (LEqual (\_SB.PCI0.ISA.EC0.SHDD, 0x01))
            {
                Or (Local2, 0x04, Local2)
            }
        }

        If (LEqual (Arg0, 0x04))
        {
            If (LNotEqual (Local2, \_SB.PCI0.IDE.BAYD))
            {
                Acquire (\_SB.PCI0.ISA.EC0.MUT2, 0xFFFF)
                \_SB.PCI0.ISA.EC0.SWAP ()
                Release (\_SB.PCI0.ISA.EC0.MUT2)
            }
        }

        If (LEqual (Local2, \_SB.PCI0.IDE.BAYD))
        {
            If (LEqual (Local2, 0x04))
            {
                If (LNot (\_SB.PCI0.IDE._PSC))
                {
                    Notify (\_SB.PCI0.IDE, 0x00)
                }
                Else
                {
                    Or (\_SB.PCI0.ISA.EC0.PQ06, 0x04)
                }
            }
        }

        Store (0x00, \_SB.PCI0.ISA.EC0.VGAQ)
        Store (0x00, \_SB.PCI0.ISA.EC0.EJWK)
        Sleep (0x64)
        Store (0x01, \_SB.PCI0.AGP.VGA.VRSM)
    }

    Scope (_SI)
    {
        Name (CRSI, 0x00)
        Method (_SST, 1, NotSerialized)
        {
            Store (Arg0, CRSI)
            If (\_SB.PCI0.ISA.ECOK ())
            {
                If (LEqual (Arg0, 0x00))
                {
                    Store (0x00, \_SB.PCI0.ISA.EC0.S1LD)
                    Store (0x00, \_SB.PCI0.ISA.EC0.S2LD)
                    Store ("SI_SST_0", Debug)
                }

                If (LEqual (Arg0, 0x01))
                {
                    Store (0x01, \_SB.PCI0.ISA.EC0.S1LD)
                    Store (0x00, \_SB.PCI0.ISA.EC0.S2LD)
                    Store ("SI_SST_1", Debug)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x01, \_SB.PCI0.ISA.EC0.S1LD)
                    Store (0x01, \_SB.PCI0.ISA.EC0.S2LD)
                    Store ("SI_SST_2", Debug)
                }

                If (LEqual (Arg0, 0x03))
                {
                    Store (0x00, \_SB.PCI0.ISA.EC0.S1LD)
                    Store (0x01, \_SB.PCI0.ISA.EC0.S2LD)
                    Store ("SI_SST_3", Debug)
                }

                If (LEqual (Arg0, 0x04))
                {
                    Store (0x00, \_SB.PCI0.ISA.EC0.S1LD)
                    Store (0x00, \_SB.PCI0.ISA.EC0.S2LD)
                    Store ("SI_SST_4", Debug)
                }
            }
        }
    }

    Scope (\_TZ)
    {
        Name (THMD, Zero)
        Name (THID, Zero)
        Name (THOK, Zero)
        Name (SKUS, 0x0A)
        Name (NOMV, 0x0C3A)
        Name (ACTV, 0x0CBC)
        Name (PASV, 0x0CF8)
        Name (CRTV, 0x0E06)
        Name (TBLI, Buffer (0x1E)
        {
            /* 0000 */    0x00, 0x13, 0x00, 0x01, 0x13, 0x01, 0x02, 0x12, 
            /* 0008 */    0x02, 0x03, 0x05, 0x03, 0x04, 0x08, 0x04, 0x00, 
            /* 0010 */    0x11, 0x05, 0x01, 0x11, 0x06, 0x04, 0x0A, 0x07, 
            /* 0018 */    0x05, 0x23, 0x08, 0x05, 0xA0, 0x09
        })
        Name (TRPA, Buffer (0x28)
        {
            /* 0000 */    0x46, 0x40, 0x55, 0x5C, 0x46, 0x40, 0x55, 0x5C, 
            /* 0008 */    0x44, 0x3C, 0x55, 0x5C, 0x4A, 0x44, 0x55, 0x5C, 
            /* 0010 */    0x4A, 0x44, 0x55, 0x5C, 0x35, 0x31, 0x55, 0x5C, 
            /* 0018 */    0x4B, 0x45, 0x55, 0x5C, 0x4A, 0x44, 0x55, 0x5C, 
            /* 0020 */    0x44, 0x40, 0x5D, 0x69, 0x50, 0x4A, 0x5D, 0x69
        })
        Name (TRPP, Buffer (0x28)
        {
            /* 0000 */    0x46, 0x40, 0x55, 0x5C, 0x46, 0x40, 0x55, 0x5C, 
            /* 0008 */    0x44, 0x3C, 0x55, 0x5C, 0x4A, 0x44, 0x55, 0x5C, 
            /* 0010 */    0x4A, 0x44, 0x55, 0x5C, 0x35, 0x31, 0x55, 0x5C, 
            /* 0018 */    0x4B, 0x45, 0x55, 0x5C, 0x4A, 0x44, 0x55, 0x5C, 
            /* 0020 */    0x44, 0x40, 0x5D, 0x69, 0x50, 0x4A, 0x5D, 0x69
        })
        Method (GETI, 1, NotSerialized)
        {
            Store ("THERM: GETI - Value:", Debug)
            Store (Arg0, Local1)
            Store (\_SB.PCI0.ISA.EC0.KBID, Local2)
            Store (Zero, Local3)
            Store (Zero, Local4)
            While (LLess (Local3, SKUS))
            {
                \_SB.PCI0.ISA.GBFE (TBLI, Local4, RefOf (Local5))
                If (LEqual (Local5, Local1))
                {
                    \_SB.PCI0.ISA.GBFE (TBLI, Add (Local4, 0x01), RefOf (Local5))
                    If (LEqual (Local5, Local2))
                    {
                        \_SB.PCI0.ISA.GBFE (TBLI, Add (Local4, 0x02), RefOf (Local1))
                        Store (Local1, THID)
                        Store (Ones, THOK)
                        Store (SKUS, Local3)
                        Store (THID, Debug)
                    }
                    Else
                    {
                        Add (Local4, 0x03, Local4)
                        Increment (Local3)
                    }
                }
                Else
                {
                    Add (Local4, 0x03, Local4)
                    Increment (Local3)
                }
            }

            If (LEqual (THOK, Ones))
            {
                Return (THID)
            }
            Else
            {
                Return (Zero)
            }
        }

        Method (TABL, 1, NotSerialized)
        {
            If (LEqual (THMD, Zero))
            {
                \_SB.PCI0.ISA.GBFE (TRPA, Arg0, RefOf (Local0))
            }
            Else
            {
                \_SB.PCI0.ISA.GBFE (TRPP, Arg0, RefOf (Local0))
            }

            Return (Local0)
        }

        Method (KELV, 1, NotSerialized)
        {
            If (And (Arg0, 0x80))
            {
                Store (0xFFFFFF00, Local1)
            }
            Else
            {
                Store (Zero, Local1)
            }

            Or (Local1, Arg0, Local1)
            Add (Local1, 0x0111, Local1)
            Add (ShiftLeft (Local1, 0x01), ShiftLeft (Local1, 0x03), Local0)
            Return (Local0)
        }

        PowerResource (PFAN, 0x00, 0x0000)
        {
            Method (_STA, 0, NotSerialized)
            {
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    Store ("THERM: _STA - Fan Status", Debug)
                    Return (\_SB.PCI0.ISA.EC0.FAN)
                }
                Else
                {
                    Return (0x00)
                }
            }

            Method (_ON, 0, NotSerialized)
            {
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    Store ("THERM: _ON - Fan TurnOn", Debug)
                    Store (One, \_SB.PCI0.ISA.EC0.FAN)
                    Store ("THERM: Notify(THRM,0x81)", Debug)
                    Notify (\_TZ.THRM, 0x81)
                }
            }

            Method (_OFF, 0, NotSerialized)
            {
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    Store ("THERM: _OFF - Fan TurnOff", Debug)
                    Store (Zero, \_SB.PCI0.ISA.EC0.FAN)
                    Store ("THERM: Notify(THRM,0x81)", Debug)
                    Notify (\_TZ.THRM, 0x81)
                }
            }
        }

        Device (FAN)
        {
            Name (_HID, EisaId ("PNP0C0B"))
            Name (_PR0, Package (0x01)
            {
                PFAN
            })
        }

        ThermalZone (THRM)
        {
            Name (_AL0, Package (0x01)
            {
                FAN
            })
            Name (_PSL, Package (0x01)
            {
                \_PR.CPU0
            })
            Method (_TMP, 0, NotSerialized)
            {
                Store ("THERM: _TMP - Value:", Debug)
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    Store (KELV (\_SB.PCI0.ISA.EC0.TMP), Local0)
                }
                Else
                {
                    Store (NOMV, Local0)
                }

                Store (Local0, Debug)
                Return (Local0)
            }

            Method (_AC0, 0, NotSerialized)
            {
                Store ("THERM: _AC0 - Value:", Debug)
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    If (LEqual (THOK, Zero))
                    {
                        Store (GETI (\_SB.BIOS), THID)
                    }

                    ShiftLeft (THID, 0x02, Local1)
                    If (\_SB.PCI0.ISA.EC0.FAN)
                    {
                        Increment (Local1)
                    }

                    Store (KELV (TABL (Local1)), Local0)
                    Store (Local0, ACTV)
                }
                Else
                {
                    Store (ACTV, Local0)
                }

                Store (Local0, Debug)
                Return (Local0)
            }

            Method (_PSV, 0, NotSerialized)
            {
                Store ("THERM: _PSV - Value:", Debug)
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    If (LEqual (THOK, Zero))
                    {
                        Store (GETI (\_SB.BIOS), THID)
                    }

                    ShiftLeft (THID, 0x02, Local1)
                    Add (Local1, 0x02, Local1)
                    Store (KELV (TABL (Local1)), Local0)
                }
                Else
                {
                    Store (PASV, Local0)
                }

                Store (Local0, Debug)
                Return (Local0)
            }

            Method (_CRT, 0, NotSerialized)
            {
                Store ("THERM: _CRT - Value:", Debug)
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    If (LEqual (THOK, Zero))
                    {
                        Store (GETI (\_SB.BIOS), THID)
                    }

                    ShiftLeft (THID, 0x02, Local1)
                    Add (Local1, 0x03, Local1)
                    Store (KELV (TABL (Local1)), Local0)
                }
                Else
                {
                    Store (CRTV, Local0)
                }

                Store (Local0, Debug)
                Return (Local0)
            }

            Method (_SCP, 1, NotSerialized)
            {
                If (LEqual (Arg0, Zero))
                {
                    Store ("THERM: _SCP(Active)", Debug)
                }
                Else
                {
                    Store ("THERM: _SCP(Passive)", Debug)
                }

                Store (Arg0, THMD)
                Store (Zero, THOK)
                Store (Zero, THID)
            }

            Name (_TC1, 0x04)
            Name (_TC2, 0x03)
            Name (_TSP, 0x64)
        }
    }

    OperationRegion (LDS, SystemIO, 0x802B, 0x01)
    Field (LDS, ByteAcc, NoLock, Preserve)
    {
        SMFZ,   1, 
        LPOL,   1
    }

    Scope (_GPE)
    {
        Method (_L0A, 0, NotSerialized)
        {
            If (\_SB.PCI0.ISA.ECOK ())
            {
                If (\_SB.PCI0.ISA.EC0.BWAK)
                {
                    Store (0x00, \_SB.PCI0.ISA.EC0.BWAK)
                    If (\_SB.PCI0.ISA.EC0.B1WS)
                    {
                        Notify (\_SB.PCI0.ISA.BAT1, 0x02)
                    }

                    If (\_SB.PCI0.ISA.EC0.B2WS)
                    {
                        Notify (\_SB.PCI0.ISA.BAT2, 0x02)
                    }
                }
                Else
                {
                    Notify (\_SB.PCI0.ISA.SIO.COM1, 0x02)
                }
            }
            Else
            {
                Notify (\_SB.PCI0.ISA.SIO.COM1, 0x02)
            }
        }

        Method (_L0B, 0, NotSerialized)
        {
            Not (LPOL, LPOL)
            Notify (\_SB.LID, 0x80)
        }
    }

    Scope (_SB)
    {
        Name (BIOS, 0x04)
        Name (QBST, 0x00)
        Name (CUDC, 0x00)
        Name (DCTM, 0x00)
        Name (DCKF, 0x00)
        Name (IRQP, Package (0x10)
        {
            0x00, 
            0x00, 
            0x00, 
            0x08, 
            0x10, 
            0x20, 
            0x40, 
            0x80, 
            0x00, 
            0x0200, 
            0x0400, 
            0x0800, 
            0x1000, 
            0x00, 
            0x4000, 
            0x8000
        })
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x01)
            Method (_STA, 0, NotSerialized)
            {
                If (LLess (\_SB.PCI0.ISA.PIRA, 0x80))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x01)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {10}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Or (\_SB.PCI0.ISA.PIRA, 0x80, \_SB.PCI0.ISA.PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Name (BUFA, ResourceTemplate ()
                {
                    IRQ (Level, ActiveLow, Shared, _Y00)
                        {}
                })
                CreateWordField (BUFA, \_SB.LNKA._CRS._Y00._INT, IRA1)
                And (\_SB.PCI0.ISA.PIRA, 0x8F, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (DerefOf (Index (IRQP, Local0)), Local4)
                    Store (Local4, IRA1)
                }

                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA1)
                Store (IRA1, Local0)
                Store (Match (IRQP, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                And (\_SB.PCI0.ISA.PIRA, 0x70, Local0)
                Or (Local1, Local0, \_SB.PCI0.ISA.PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                If (LLess (\_SB.PCI0.ISA.PIRB, 0x80))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x01)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {10}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Or (\_SB.PCI0.ISA.PIRB, 0x80, \_SB.PCI0.ISA.PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Name (BUFB, ResourceTemplate ()
                {
                    IRQ (Level, ActiveLow, Shared, _Y01)
                        {}
                })
                CreateWordField (BUFB, \_SB.LNKB._CRS._Y01._INT, IRA1)
                And (\_SB.PCI0.ISA.PIRB, 0x8F, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (DerefOf (Index (IRQP, Local0)), Local4)
                    Store (Local4, IRA1)
                }

                Return (BUFB)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA1)
                Store (IRA1, Local0)
                Store (Match (IRQP, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                And (\_SB.PCI0.ISA.PIRB, 0x70, Local0)
                Or (Local1, Local0, \_SB.PCI0.ISA.PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                If (LLess (\_SB.PCI0.ISA.PIRC, 0x80))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x01)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {9}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Or (\_SB.PCI0.ISA.PIRC, 0x80, \_SB.PCI0.ISA.PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Name (BUFC, ResourceTemplate ()
                {
                    IRQ (Level, ActiveLow, Shared, _Y02)
                        {}
                })
                CreateWordField (BUFC, \_SB.LNKC._CRS._Y02._INT, IRA1)
                And (\_SB.PCI0.ISA.PIRC, 0x8F, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (DerefOf (Index (IRQP, Local0)), Local4)
                    Store (Local4, IRA1)
                }

                Return (BUFC)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA1)
                Store (IRA1, Local0)
                Store (Match (IRQP, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                And (\_SB.PCI0.ISA.PIRC, 0x70, Local0)
                Or (Local1, Local0, \_SB.PCI0.ISA.PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                If (LLess (\_SB.PCI0.ISA.PIRD, 0x80))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x01)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {10}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Or (\_SB.PCI0.ISA.PIRD, 0x80, \_SB.PCI0.ISA.PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Name (BUFD, ResourceTemplate ()
                {
                    IRQ (Level, ActiveLow, Shared, _Y03)
                        {}
                })
                CreateWordField (BUFD, \_SB.LNKD._CRS._Y03._INT, IRA1)
                And (\_SB.PCI0.ISA.PIRD, 0x8F, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (DerefOf (Index (IRQP, Local0)), Local4)
                    Store (Local4, IRA1)
                }

                Return (BUFD)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA1)
                Store (IRA1, Local0)
                Store (Match (IRQP, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                And (\_SB.PCI0.ISA.PIRD, 0x70, Local0)
                Or (Local1, Local0, \_SB.PCI0.ISA.PIRD)
            }
        }

        Device (LID)
        {
            Name (_HID, EisaId ("PNP0C0D"))
            Method (_LID, 0, NotSerialized)
            {
                Return (LPOL)
            }

            Method (_PSW, 1, NotSerialized)
            {
                If (\_SB.PCI0.ISA.ECOK ())
                {
                    If (Arg0)
                    {
                        Store (0x01, \_SB.PCI0.ISA.EC0.LWAK)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI0.ISA.EC0.LWAK)
                    }
                }
            }

            Name (_PRW, Package (0x02)
            {
                0x0A, 
                0x03
            })
        }

        Device (XROM)
        {
            Name (_HID, EisaId ("PNP0C02"))
            Name (_UID, 0x01)
            Method (_CRS, 0, NotSerialized)
            {
                Return (\_SB.PCI0.SROM ())
            }

            Method (_STA, 0, NotSerialized)
            {
                If (LEqual (\_SB.PCI0.OSNT, 0x01))
                {
                    Return (0x0F)
                }
                Else
                {
                    Return (0x00)
                }
            }
        }

        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))
            Name (_ADR, 0x00)
            Method (MIN, 2, NotSerialized)
            {
                If (LLess (Arg0, Arg1))
                {
                    Return (Arg0)
                }
                Else
                {
                    Return (Arg1)
                }
            }

            Method (SLEN, 1, NotSerialized)
            {
                Return (SizeOf (Arg0))
            }

            Method (S2BF, 1, Serialized)
            {
                Add (SLEN (Arg0), One, Local0)
                Name (BUFF, Buffer (Local0) {})
                Store (Arg0, BUFF)
                Return (BUFF)
            }

            Method (SCMP, 2, NotSerialized)
            {
                Store (S2BF (Arg0), Local0)
                Store (S2BF (Arg1), Local1)
                Store (Zero, Local4)
                Store (SLEN (Arg0), Local5)
                Store (SLEN (Arg1), Local6)
                Store (MIN (Local5, Local6), Local7)
                While (LLess (Local4, Local7))
                {
                    Store (DerefOf (Index (Local0, Local4)), Local2)
                    Store (DerefOf (Index (Local1, Local4)), Local3)
                    If (LGreater (Local2, Local3))
                    {
                        Return (One)
                    }
                    Else
                    {
                        If (LLess (Local2, Local3))
                        {
                            Return (Ones)
                        }
                    }

                    Increment (Local4)
                }

                If (LLess (Local4, Local5))
                {
                    Return (One)
                }
                Else
                {
                    If (LLess (Local4, Local6))
                    {
                        Return (Ones)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }
            }

            Name (OSNT, 0x00)
            Method (_INI, 0, NotSerialized)
            {
                If (LEqual (SCMP (\_OS, "Microsoft Windows NT"), Zero))
                {
                    Store (0x01, OSNT)
                }

                If (LEqual (SCMP (\_OS, "Microsoft Windows"), Zero))
                {
                    Store (0x00, OSNT)
                }

                Store (\_SB.PCI0.ISA.BDST, \_SB.PCI0.IDE.BAYD)
            }

            Method (_STA, 0, NotSerialized)
            {
                Return (0x0F)
            }

            OperationRegion (REGS, PCI_Config, 0x40, 0xC0)
            Field (REGS, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x19), 
                PAM0,   8, 
                PAM1,   8, 
                PAM2,   8, 
                PAM3,   8, 
                PAM4,   8, 
                PAM5,   8, 
                PAM6,   8, 
                DRB0,   8, 
                DRB1,   8, 
                DRB2,   8, 
                DRB3,   8, 
                DRB4,   8, 
                DRB5,   8, 
                DRB6,   8, 
                DRB7,   8, 
                        Offset (0x33), 
                T_EN,   1, 
                T_SZ,   2, 
                        Offset (0x3A), 
                CRST,   1
            }

            Name (RSRC, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    0x00,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000C3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y06, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C4000,         // Range Minimum
                    0x000C7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y07, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C8000,         // Range Minimum
                    0x000CBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y08, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000CC000,         // Range Minimum
                    0x000CFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y09, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D0000,         // Range Minimum
                    0x000D3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0A, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D4000,         // Range Minimum
                    0x000D7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0B, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D8000,         // Range Minimum
                    0x000DBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0C, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000DC000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0D, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E0000,         // Range Minimum
                    0x000E3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0E, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E4000,         // Range Minimum
                    0x000E7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0F, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E8000,         // Range Minimum
                    0x000EBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y10, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000EC000,         // Range Minimum
                    0x000EFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y11, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    0x00,, _Y04, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    0x00,, _Y05, AddressRangeMemory, TypeStatic)
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                DWordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000CF7,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000CF8,         // Length
                    0x00,, , TypeStatic)
                DWordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x00000000,         // Granularity
                    0x00000D00,         // Range Minimum
                    0x0000FFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x0000F300,         // Length
                    0x00,, , TypeStatic)
            })
            Method (_CRS, 0, Serialized)
            {
                Store (Zero, Local1)
                If (T_EN)
                {
                    ShiftLeft (T_SZ, 0x11, Local1)
                }

                CreateDWordField (RSRC, \_SB.PCI0._Y04._MIN, BTMN)
                CreateDWordField (RSRC, \_SB.PCI0._Y04._MAX, BTMX)
                CreateDWordField (RSRC, \_SB.PCI0._Y04._LEN, BTLN)
                Multiply (DRB7, 0x00800000, Local0)
                If (T_EN)
                {
                    Subtract (Local0, Local1, Local2)
                    Store (Local2, BTMN)
                    Subtract (Add (Local0, 0x10000000), BTMN, BTLN)
                }
                Else
                {
                    Store (Local0, BTMN)
                    Subtract (0xFFE00000, Local0, BTLN)
                    Subtract (Add (BTMN, BTLN), 0x01, BTMX)
                }

                CreateDWordField (RSRC, \_SB.PCI0._Y05._MIN, ATMN)
                CreateDWordField (RSRC, \_SB.PCI0._Y05._MAX, ATMX)
                CreateDWordField (RSRC, \_SB.PCI0._Y05._LEN, ATLN)
                If (T_EN)
                {
                    Add (Add (BTMN, BTLN), Local1, ATMN)
                    Subtract (0xFFE00000, ATMN, ATLN)
                    Subtract (Add (ATMN, ATLN), 0x01, ATMX)
                }
                Else
                {
                    Store (Zero, ATLN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y06._RW, C0RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y06._MIN, C0MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y06._MAX, C0MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y06._LEN, C0LN)
                Store (One, C0RW)
                If (LEqual (And (PAM1, 0x03), 0x01))
                {
                    Store (Zero, C0RW)
                }

                Store (Zero, C0LN)
                If (LNot (And (PAM1, 0x03)))
                {
                    Store (0x4000, C0LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y07._RW, C4RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y07._MIN, C4MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y07._MAX, C4MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y07._LEN, C4LN)
                Store (One, C4RW)
                If (LEqual (And (PAM1, 0x30), 0x10))
                {
                    Store (Zero, C4RW)
                }

                Store (Zero, C4LN)
                If (LNot (And (PAM1, 0x30)))
                {
                    Store (0x4000, C4LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y08._RW, C8RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y08._MIN, C8MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y08._MAX, C8MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y08._LEN, C8LN)
                Store (One, C8RW)
                If (LEqual (And (PAM2, 0x03), 0x01))
                {
                    Store (Zero, C8RW)
                }

                Store (Zero, C8LN)
                If (LNot (And (PAM2, 0x03)))
                {
                    Store (0x4000, C8LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y09._RW, CCRW)
                CreateDWordField (RSRC, \_SB.PCI0._Y09._MIN, CCMN)
                CreateDWordField (RSRC, \_SB.PCI0._Y09._MAX, CCMX)
                CreateDWordField (RSRC, \_SB.PCI0._Y09._LEN, CCLN)
                Store (One, CCRW)
                If (LEqual (And (PAM2, 0x30), 0x10))
                {
                    Store (Zero, CCRW)
                }

                Store (Zero, CCLN)
                If (LNot (And (PAM2, 0x30)))
                {
                    Store (0x4000, CCLN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0A._RW, D0RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y0A._MIN, D0MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y0A._MAX, D0MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y0A._LEN, D0LN)
                Store (One, D0RW)
                If (LEqual (And (PAM3, 0x03), 0x01))
                {
                    Store (Zero, D0RW)
                }

                Store (Zero, D0LN)
                If (LNot (And (PAM3, 0x03)))
                {
                    Store (0x4000, D0LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0B._RW, D4RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y0B._MIN, D4MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y0B._MAX, D4MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y0B._LEN, D4LN)
                Store (One, D4RW)
                If (LEqual (And (PAM3, 0x30), 0x10))
                {
                    Store (Zero, D4RW)
                }

                Store (Zero, D4LN)
                If (LNot (And (PAM3, 0x30)))
                {
                    Store (0x4000, D4LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0C._RW, D8RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y0C._MIN, D8MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y0C._MAX, D8MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y0C._LEN, D8LN)
                Store (One, D8RW)
                If (LEqual (And (PAM4, 0x03), 0x01))
                {
                    Store (Zero, D8RW)
                }

                Store (Zero, D8LN)
                If (LNot (And (PAM4, 0x03)))
                {
                    Store (0x4000, D8LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0D._RW, DCRW)
                CreateDWordField (RSRC, \_SB.PCI0._Y0D._MIN, DCMN)
                CreateDWordField (RSRC, \_SB.PCI0._Y0D._MAX, DCMX)
                CreateDWordField (RSRC, \_SB.PCI0._Y0D._LEN, DCLN)
                Store (One, DCRW)
                If (LEqual (And (PAM4, 0x30), 0x10))
                {
                    Store (Zero, DCRW)
                }

                Store (Zero, DCLN)
                If (LNot (And (PAM4, 0x30)))
                {
                    Store (0x4000, DCLN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0E._RW, E0RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y0E._MIN, E0MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y0E._MAX, E0MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y0E._LEN, E0LN)
                Store (One, E0RW)
                If (LEqual (And (PAM5, 0x03), 0x01))
                {
                    Store (Zero, E0RW)
                }

                Store (Zero, E0LN)
                If (LNot (And (PAM5, 0x03)))
                {
                    Store (0x4000, E0LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0F._RW, E4RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y0F._MIN, E4MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y0F._MAX, E4MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y0F._LEN, E4LN)
                Store (One, E4RW)
                If (LEqual (And (PAM5, 0x30), 0x10))
                {
                    Store (Zero, E4RW)
                }

                Store (Zero, E4LN)
                If (LNot (And (PAM5, 0x30)))
                {
                    Store (0x4000, E4LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y10._RW, E8RW)
                CreateDWordField (RSRC, \_SB.PCI0._Y10._MIN, E8MN)
                CreateDWordField (RSRC, \_SB.PCI0._Y10._MAX, E8MX)
                CreateDWordField (RSRC, \_SB.PCI0._Y10._LEN, E8LN)
                Store (One, E8RW)
                If (LEqual (And (PAM6, 0x03), 0x01))
                {
                    Store (Zero, E8RW)
                }

                Store (Zero, E8LN)
                If (LNot (And (PAM6, 0x03)))
                {
                    Store (0x4000, E8LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y11._RW, ECRW)
                CreateDWordField (RSRC, \_SB.PCI0._Y11._MIN, ECMN)
                CreateDWordField (RSRC, \_SB.PCI0._Y11._MAX, ECMX)
                CreateDWordField (RSRC, \_SB.PCI0._Y11._LEN, ECLN)
                Store (One, ECRW)
                If (LEqual (And (PAM6, 0x30), 0x10))
                {
                    Store (Zero, ECRW)
                }

                Store (Zero, ECLN)
                If (LNot (And (PAM6, 0x30)))
                {
                    Store (0x4000, ECLN)
                }

                Return (RSRC)
            }

            Method (SROM, 0, NotSerialized)
            {
                Name (RSRC, ResourceTemplate ()
                {
                    Memory32 (ReadOnly,
                        0x000C0000,         // Range Minimum
                        0x000C3FFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y12)
                    Memory32 (ReadOnly,
                        0x000C4000,         // Range Minimum
                        0x000C7FFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y13)
                    Memory32 (ReadOnly,
                        0x000C8000,         // Range Minimum
                        0x000CBFFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y14)
                    Memory32 (ReadOnly,
                        0x000CC000,         // Range Minimum
                        0x000CFFFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y15)
                    Memory32 (ReadOnly,
                        0x000D0000,         // Range Minimum
                        0x000D3FFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y16)
                    Memory32 (ReadOnly,
                        0x000D4000,         // Range Minimum
                        0x000D7FFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y17)
                    Memory32 (ReadOnly,
                        0x000D8000,         // Range Minimum
                        0x000DBFFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y18)
                    Memory32 (ReadOnly,
                        0x000DC000,         // Range Minimum
                        0x000DFFFF,         // Range Maximum
                        0x00000000,         // Alignment
                        0x00000000,         // Length
                        _Y19)
                })
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y12._LEN, C0LN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y13._LEN, C4LN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y14._LEN, C8LN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y15._LEN, CCLN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y16._LEN, D0LN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y17._LEN, D4LN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y18._LEN, D8LN)
                CreateDWordField (RSRC, \_SB.PCI0.SROM._Y19._LEN, DCLN)
                If (And (PAM1, 0x03))
                {
                    Store (0x4000, C0LN)
                }

                If (And (PAM1, 0x30))
                {
                    Store (0x4000, C4LN)
                }

                If (And (PAM2, 0x03))
                {
                    Store (0x4000, C8LN)
                }

                If (And (PAM2, 0x30))
                {
                    Store (0x4000, CCLN)
                }

                If (And (PAM3, 0x03))
                {
                    Store (0x4000, D0LN)
                }

                If (And (PAM3, 0x30))
                {
                    Store (0x4000, D4LN)
                }

                If (And (PAM4, 0x03))
                {
                    Store (0x4000, D8LN)
                }

                If (And (PAM4, 0x30))
                {
                    Store (0x4000, DCLN)
                }

                Return (RSRC)
            }

            Name (_PRT, Package (0x0C)
            {
                Package (0x04)
                {
                    0x0007FFFF, 
                    0x00, 
                    \_SB.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x01, 
                    \_SB.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x02, 
                    \_SB.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x03, 
                    \_SB.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    \_SB.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x01, 
                    \_SB.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0012FFFF, 
                    0x00, 
                    \_SB.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0012FFFF, 
                    0x01, 
                    \_SB.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0011FFFF, 
                    0x00, 
                    \_SB.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0011FFFF, 
                    0x01, 
                    \_SB.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0011FFFF, 
                    0x02, 
                    \_SB.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0011FFFF, 
                    0x03, 
                    \_SB.LNKD, 
                    0x00
                }
            })
            Device (ISA)
            {
                Name (_ADR, 0x00070000)
                OperationRegion (PIRX, PCI_Config, 0x60, 0x04)
                Field (PIRX, ByteAcc, NoLock, Preserve)
                {
                    PIRA,   8, 
                    PIRB,   8, 
                    PIRC,   8, 
                    PIRD,   8
                }

                OperationRegion (GEN, PCI_Config, 0xB0, 0x04)
                Field (GEN, ByteAcc, NoLock, Preserve)
                {
                    ISEI,   1, 
                    POSD,   1, 
                        ,   10, 
                    TRIS,   1
                }

                Device (MBRD)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x00)
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0024,             // Range Minimum
                            0x0024,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0028,             // Range Minimum
                            0x0028,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x002C,             // Range Minimum
                            0x002C,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0038,             // Range Minimum
                            0x0038,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x003C,             // Range Minimum
                            0x003C,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x01,               // Alignment
                            0x06,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A4,             // Range Minimum
                            0x00A4,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A8,             // Range Minimum
                            0x00A8,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00AC,             // Range Minimum
                            0x00AC,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00B0,             // Range Minimum
                            0x00B0,             // Range Maximum
                            0x01,               // Alignment
                            0x06,               // Length
                            )
                        IO (Decode16,
                            0x00B8,             // Range Minimum
                            0x00B8,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00BC,             // Range Minimum
                            0x00BC,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0370,             // Range Minimum
                            0x0370,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x03F0,             // Range Minimum
                            0x03F0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x2180,             // Range Minimum
                            0x2180,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x3810,             // Range Minimum
                            0x3810,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x8000,             // Range Minimum
                            0x8000,             // Range Maximum
                            0x00,               // Alignment
                            0x40,               // Length
                            )
                    })
                }

                Device (DMAA)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x01,               // Alignment
                            0x0F,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x01,               // Alignment
                            0x20,               // Length
                            )
                        DMA (Compatibility, NotBusMaster, Transfer16, )
                            {4}
                    })
                }

                Device (RTC)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {2}
                    })
                }

                Device (FPU)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {13}
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (KBC)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Device (MOUE)
                {
                    Name (_HID, EisaId ("PNP0F13"))
                    Name (_PSC, 0x00)
                    Method (_PS0, 0, NotSerialized)
                    {
                        If (_PSC)
                        {
                            Store (0x00, _PSC)
                            \_SB.PCI0.ISA.HPSS (0x10)
                        }
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                }

                Device (MEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.OSNT, 0x00))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x000D8000,         // Address Base
                            0x00024000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x05F00000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0xFFF80000,         // Address Base
                            0x00080000,         // Address Length
                            )
                    })
                }

                Name (LPT1, Package (0x03)
                {
                    0x03BC, 
                    0x0378, 
                    0x0278
                })
                Name (LPT2, Package (0x03)
                {
                    0x03BE, 
                    0x037F, 
                    0x027F
                })
                Name (UAP1, Package (0x08)
                {
                    0x03F8, 
                    0x02F8, 
                    0x0220, 
                    0x0228, 
                    0x0238, 
                    0x02E8, 
                    0x0338, 
                    0x03E8
                })
                Name (UAP2, Package (0x08)
                {
                    0x03FF, 
                    0x02FF, 
                    0x0228, 
                    0x022F, 
                    0x023F, 
                    0x02EF, 
                    0x033F, 
                    0x03EF
                })
                Name (FDC1, Package (0x02)
                {
                    0x03F0, 
                    0x0370
                })
                Name (FDC2, Package (0x02)
                {
                    0x03F7, 
                    0x0377
                })
                Method (DECD, 4, NotSerialized)
                {
                    If (POSD)
                    {
                        DISB (Arg0, Arg1)
                        If (LNotEqual (Arg3, Ones))
                        {
                            ENAB (Arg2, Arg3, Arg0)
                        }
                    }
                }

                Method (DISB, 2, NotSerialized)
                {
                    If (LAnd (^^PX43.LPTE, ^^PX43.LPTM))
                    {
                        If (LGreaterEqual (Arg0, DerefOf (Index (LPT1, ^^PX43.LPTA))))
                        {
                            If (LLessEqual (Add (Arg0, Arg1), DerefOf (Index (LPT2, 
                                ^^PX43.LPTA))))
                            {
                                Store (Zero, ^^PX43.LPTE)
                                Return (Zero)
                            }
                        }
                    }

                    If (LAnd (^^PX43.U1E, ^^PX43.U1M))
                    {
                        If (LGreaterEqual (Arg0, DerefOf (Index (UAP1, ^^PX43.U1A))))
                        {
                            If (LLessEqual (Add (Arg0, Arg1), DerefOf (Index (UAP2, 
                                ^^PX43.U1A))))
                            {
                                Store (Zero, ^^PX43.U1E)
                                Return (Zero)
                            }
                        }
                    }

                    If (LAnd (^^PX43.U2E, ^^PX43.U2M))
                    {
                        If (LGreaterEqual (Arg0, DerefOf (Index (UAP1, ^^PX43.U2A))))
                        {
                            If (LLessEqual (Add (Arg0, Arg1), DerefOf (Index (UAP2, 
                                ^^PX43.U2A))))
                            {
                                Store (Zero, ^^PX43.U2E)
                                Return (Zero)
                            }
                        }
                    }

                    If (LAnd (^^PX43.FDCE, ^^PX43.FDCM))
                    {
                        If (LGreaterEqual (Arg0, DerefOf (Index (FDC1, ^^PX43.FDCA))))
                        {
                            If (LLessEqual (Add (Arg0, Arg1), DerefOf (Index (FDC2, 
                                ^^PX43.FDCA))))
                            {
                                Store (Zero, ^^PX43.FDCE)
                                Return (Zero)
                            }
                        }
                    }

                    Return (Ones)
                }

                Method (ENAB, 3, NotSerialized)
                {
                    Store (Arg0, Local0)
                    Add (Arg0, Arg1, Local1)
                    Store (SizeOf (LPT1), Local2)
                    While (Local2)
                    {
                        Decrement (Local2)
                        If (LGreaterEqual (Local0, DerefOf (Index (LPT1, Local2))))
                        {
                            If (LLessEqual (Local1, DerefOf (Index (LPT2, Local2))))
                            {
                                Store (Local2, ^^PX43.LPTA)
                                Store (One, ^^PX43.LPTE)
                                Store (One, ^^PX43.LPTM)
                                Return (Zero)
                            }
                        }
                    }

                    If (LEqual (Arg2, 0x11))
                    {
                        Store (SizeOf (UAP1), Local2)
                        While (Local2)
                        {
                            Decrement (Local2)
                            If (LGreaterEqual (Local0, DerefOf (Index (UAP1, Local2))))
                            {
                                If (LLessEqual (Local1, DerefOf (Index (UAP2, Local2))))
                                {
                                    Store (Local2, ^^PX43.U1A)
                                    Store (One, ^^PX43.U1E)
                                    Store (One, ^^PX43.U1M)
                                    Return (Zero)
                                }
                            }
                        }
                    }

                    If (LEqual (Arg2, 0x22))
                    {
                        Store (SizeOf (UAP1), Local2)
                        While (Local2)
                        {
                            Decrement (Local2)
                            If (LGreaterEqual (Local0, DerefOf (Index (UAP1, Local2))))
                            {
                                If (LLessEqual (Local1, DerefOf (Index (UAP2, Local2))))
                                {
                                    Store (Local2, ^^PX43.U2A)
                                    Store (One, ^^PX43.U2E)
                                    Store (One, ^^PX43.U2M)
                                    Return (Zero)
                                }
                            }
                        }
                    }

                    Store (SizeOf (FDC1), Local2)
                    While (Local2)
                    {
                        Decrement (Local2)
                        If (LGreaterEqual (Local0, DerefOf (Index (FDC1, Local2))))
                        {
                            If (LLessEqual (Local1, DerefOf (Index (FDC2, Local2))))
                            {
                                Store (Local2, ^^PX43.FDCA)
                                Store (One, ^^PX43.FDCE)
                                Store (One, ^^PX43.FDCM)
                                Return (Zero)
                            }
                        }
                    }
                }

                OperationRegion (SMI0, SystemMemory, 0x040FFB20, 0x00000090)
                Field (SMI0, AnyAcc, NoLock, Preserve)
                {
                    BCMD,   8, 
                    DID,    32, 
                    INFO,   1048
                }

                Field (SMI0, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x05), 
                    STSB,   8
                }

                Field (SMI0, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x89), 
                    MFLG,   8
                }

                Field (SMI0, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x8A), 
                    BDST,   8
                }

                Field (SMI0, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x8B), 
                    DKSN,   32
                }

                Field (SMI0, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x8F), 
                    DKTP,   8
                }

                OperationRegion (SMI2, SystemIO, 0x0000FE00, 0x02)
                Field (SMI2, AnyAcc, NoLock, Preserve)
                {
                    SMIC,   8
                }

                Method (HPSS, 1, NotSerialized)
                {
                    Store (0x80, BCMD)
                    Store (Arg0, DID)
                    Store (Zero, SMIC)
                }

                Device (SIO)
                {
                    Name (_HID, EisaId ("PNP0A05"))
                    OperationRegion (SMC1, SystemIO, 0x0370, 0x02)
                    Field (SMC1, ByteAcc, NoLock, Preserve)
                    {
                        INDX,   8, 
                        DATA,   8
                    }

                    IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                    {
                        CR00,   8, 
                        CR01,   8, 
                        CR02,   8, 
                                Offset (0x04), 
                        CR04,   8, 
                        CR05,   8, 
                                Offset (0x07), 
                        CR07,   8, 
                                Offset (0x0C), 
                        CR0C,   8, 
                                Offset (0x20), 
                        CR20,   8, 
                                Offset (0x23), 
                        CR23,   8, 
                        CR24,   8, 
                        CR25,   8, 
                        CR26,   8, 
                        CR27,   8, 
                        CR28,   8, 
                                Offset (0x2B), 
                        CR2B,   8, 
                        CR2C,   8
                    }

                    Method (ENFG, 0, NotSerialized)
                    {
                        Store (0x0370, \_SB.PCI0.PX43.DEC1)
                        Store (0x11, \_SB.PCI0.PX43.DEEN)
                        Store (0x0D, INDX)
                        While (LNotEqual (DATA, 0x28))
                        {
                            Store (0x0370, \_SB.PCI0.PX43.DEC1)
                            Store (0x11, \_SB.PCI0.PX43.DEEN)
                            Store (0x55, INDX)
                            Store (0x55, INDX)
                            Store (0x0D, INDX)
                        }
                    }

                    Method (EXFG, 0, NotSerialized)
                    {
                        Store (0xAA, INDX)
                        Store (0x01, \_SB.PCI0.PX43.DEEN)
                    }

                    Name (IRQP, Package (0x09)
                    {
                        0x00, 
                        0x20, 
                        0x0800, 
                        0x08, 
                        0x10, 
                        0x80, 
                        0x40, 
                        0x00, 
                        0x0400
                    })
                    Name (DMAP, Package (0x04)
                    {
                        0x00, 
                        0x01, 
                        0x04, 
                        0x08
                    })
                    Name (REGS, Package (0x15)
                    {
                        0x00, 
                        0x01, 
                        0x02, 
                        0x04, 
                        0x05, 
                        0x07, 
                        0x0A, 
                        0x0C, 
                        0x1E, 
                        0x20, 
                        0x21, 
                        0x22, 
                        0x23, 
                        0x24, 
                        0x25, 
                        0x26, 
                        0x27, 
                        0x28, 
                        0x29, 
                        0x2B, 
                        0x2C
                    })
                    Name (SAVE, Package (0x15)
                    {
                        0x00, 
                        0x01, 
                        0x02, 
                        0x04, 
                        0x05, 
                        0x07, 
                        0x0A, 
                        0x0C, 
                        0x1E, 
                        0x20, 
                        0x21, 
                        0x22, 
                        0x23, 
                        0x24, 
                        0x25, 
                        0x26, 
                        0x27, 
                        0x28, 
                        0x29, 
                        0x2B, 
                        0x2C
                    })
                    Name (SIO0, 0x01)
                    Name (SIO1, 0x00)
                    Name (SIO2, 0x01)
                    Name (SIO3, 0x01)
                    Method (_INI, 0, NotSerialized)
                    {
                        ENFG ()
                        And (CR02, 0x80, Local0)
                        If (Local0)
                        {
                            Store (0x01, SIO1)
                            Store (0x00, \_SB.PCI0.ISA.SIO.COM2._PSC)
                            And (CR0C, 0x38, Local1)
                            If (Local1)
                            {
                                And (CR25, 0xC0, Local2)
                                If (Local2)
                                {
                                    HPSS (0x11)
                                    If (LEqual (\_SB.PCI0.ISA.STSB, 0x03))
                                    {
                                        Store (0x03, SIO1)
                                        Store (0x00, \_SB.PCI0.ISA.SIO.FIRA._PSC)
                                        Store (0x03, \_SB.PCI0.ISA.SIO.COM2._PSC)
                                    }
                                    Else
                                    {
                                        Store (0x02, SIO1)
                                        Store (0x00, \_SB.PCI0.ISA.SIO.SIRA._PSC)
                                        Store (0x03, \_SB.PCI0.ISA.SIO.COM2._PSC)
                                    }
                                }
                            }
                        }

                        And (CR02, 0x08, Local3)
                        If (LNot (Local3))
                        {
                            Store (0x00, SIO0)
                            Store (0x03, \_SB.PCI0.ISA.SIO.COM1._PSC)
                        }

                        And (CR23, 0xC0, Local4)
                        If (LNot (Local4))
                        {
                            Store (0x00, SIO2)
                            Store (0x03, \_SB.PCI0.ISA.SIO.LPT._PSC)
                        }

                        And (CR20, 0xC0, Local5)
                        If (LNot (Local5))
                        {
                            Store (0x00, SIO3)
                            Store (0x03, \_SB.PCI0.ISA.SIO.FDC._PSC)
                        }

                        EXFG ()
                    }

                    Name (_S1D, 0x00)
                    Name (_S2D, 0x00)
                    Name (_S3D, 0x03)
                    Name (_PSC, 0x00)
                    Method (_PS0, 0, NotSerialized)
                    {
                        If (LEqual (_PSC, 0x03))
                        {
                            ENFG ()
                            Store (Zero, Local0)
                            While (LLess (Local0, SizeOf (REGS)))
                            {
                                Store (DerefOf (Index (REGS, Local0)), INDX)
                                Store (DerefOf (Index (SAVE, Local0)), DATA)
                                Increment (Local0)
                            }

                            EXFG ()
                        }

                        Store (0x00, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        ENFG ()
                        Store (Zero, Local0)
                        While (LLess (Local0, SizeOf (REGS)))
                        {
                            Store (DerefOf (Index (REGS, Local0)), INDX)
                            Store (DATA, Index (SAVE, Local0))
                            Increment (Local0)
                        }

                        EXFG ()
                        Store (0x03, _PSC)
                    }

                    Device (FDC)
                    {
                        Name (_HID, EisaId ("PNP0700"))
                        Name (STOP, 0x00)
                        Method (_INI, 0, NotSerialized)
                        {
                            If (\_SB.PCI0.ISA.ECOK ())
                            {
                                If (LEqual (\_SB.PCI0.ISA.EC0.FDD, 0x01))
                                {
                                    Store (0x00, \_SB.PCI0.ISA.SIO.FDC.IFDD._PSC)
                                }
                                Else
                                {
                                    Store (0x03, \_SB.PCI0.ISA.SIO.FDC.IFDD._PSC)
                                    Store (0x01, \_SB.PCI0.PX43.ENFD)
                                }
                            }
                            Else
                            {
                                If (And (BDST, 0x02))
                                {
                                    Store (0x00, \_SB.PCI0.ISA.SIO.FDC.IFDD._PSC)
                                }
                                Else
                                {
                                    Store (0x03, \_SB.PCI0.ISA.SIO.FDC.IFDD._PSC)
                                    Store (0x01, \_SB.PCI0.PX43.ENFD)
                                }
                            }

                            If (\_SB.PCI0.ISA.ECOK ())
                            {
                                If (\_SB.PCI0.ISA.EC0.EXFD)
                                {
                                    Store (0x00, \_SB.PCI0.ISA.SIO.FDC.EFDD._PSC)
                                    Store (0x03, \_SB.PCI0.ISA.SIO.FDC.IFDD._PSC)
                                    Store (0x01, \_SB.PCI0.PX43.ENFD)
                                }
                                Else
                                {
                                    Store (0x03, \_SB.PCI0.ISA.SIO.FDC.EFDD._PSC)
                                }
                            }
                            Else
                            {
                                If (And (BDST, 0x01))
                                {
                                    Store (0x00, \_SB.PCI0.ISA.SIO.FDC.EFDD._PSC)
                                    Store (0x03, \_SB.PCI0.ISA.SIO.FDC.IFDD._PSC)
                                    Store (0x01, \_SB.PCI0.PX43.ENFD)
                                }
                                Else
                                {
                                    Store (0x03, \_SB.PCI0.ISA.SIO.FDC.EFDD._PSC)
                                }
                            }
                        }

                        Method (_STA, 0, NotSerialized)
                        {
                            If (SIO3)
                            {
                                ENFG ()
                                And (CR20, 0xC0, Local0)
                                And (CR00, 0x08, Local1)
                                If (LAnd (Local0, Local1))
                                {
                                    Store (0x0F, Local7)
                                }
                                Else
                                {
                                    Store (0x0D, Local7)
                                }

                                EXFG ()
                            }
                            Else
                            {
                                Store (0x00, Local7)
                            }

                            Return (Local7)
                        }

                        Method (_DIS, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR00, 0xF7, CR00)
                            And (CR20, 0x3F, CR20)
                            And (CR26, 0x0F, CR26)
                            And (CR27, 0x0F, CR27)
                            EXFG ()
                        }

                        Method (_CRS, 0, NotSerialized)
                        {
                            Name (RSRC, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x03F2,             // Range Minimum
                                    0x03F2,             // Range Maximum
                                    0x02,               // Alignment
                                    0x04,               // Length
                                    _Y1A)
                                IO (Decode16,
                                    0x03F7,             // Range Minimum
                                    0x03F7,             // Range Maximum
                                    0x01,               // Alignment
                                    0x01,               // Length
                                    )
                                IRQNoFlags (_Y1B)
                                    {6}
                                DMA (Compatibility, NotBusMaster, Transfer8, _Y1C)
                                    {2}
                            })
                            ENFG ()
                            And (CR20, 0xC0, Local0)
                            And (CR00, 0x08, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FDC._CRS._Y1A._MIN, IO1)
                                CreateByteField (RSRC, 0x03, IO2)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FDC._CRS._Y1A._MAX, IO3)
                                CreateByteField (RSRC, 0x05, IO4)
                                CreateWordField (RSRC, \_SB.PCI0.ISA.SIO.FDC._CRS._Y1B._INT, IRQV)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FDC._CRS._Y1C._DMA, DMAV)
                                ShiftLeft (CR20, 0x02, Local2)
                                ShiftRight (CR20, 0x06, Local3)
                                And (IO1, 0x03, IO1)
                                Or (IO1, Local2, IO1)
                                Store (Local3, IO2)
                                And (IO3, 0x03, IO3)
                                Or (IO3, Local2, IO3)
                                Store (Local3, IO4)
                                ShiftRight (CR27, 0x04, Local4)
                                Store (DerefOf (Index (IRQP, Local4)), IRQV)
                                ShiftRight (CR26, 0x04, Local5)
                                And (Local5, 0x03, Local5)
                                Store (DerefOf (Index (DMAP, Local5)), DMAV)
                            }

                            EXFG ()
                            Return (RSRC)
                        }

                        Name (_PRS, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x03F2,             // Range Minimum
                                0x03F2,             // Range Maximum
                                0x02,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {6}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {2}
                        })
                        Method (_SRS, 1, NotSerialized)
                        {
                            CreateByteField (Arg0, 0x02, IO1)
                            CreateByteField (Arg0, 0x03, IO2)
                            CreateWordField (Arg0, 0x11, IRQV)
                            CreateByteField (Arg0, 0x14, DMAV)
                            CreateWordField (Arg0, 0x02, FDIO)
                            ENFG ()
                            ShiftRight (IO1, 0x02, Local0)
                            ShiftLeft (IO2, 0x06, Local1)
                            Or (Local0, Local1, Local0)
                            Store (Local0, CR20)
                            Store (Match (IRQP, MEQ, IRQV, MTR, 0x00, 0x00), Local3)
                            ShiftLeft (Local3, 0x04, Local3)
                            And (CR27, 0x0F, CR27)
                            Or (CR27, Local3, CR27)
                            Store (Match (DMAP, MEQ, DMAV, MTR, 0x00, 0x00), Local4)
                            ShiftLeft (Local4, 0x04, Local4)
                            And (CR26, 0x0F, CR26)
                            Or (CR26, Local4, CR26)
                            Or (CR00, 0x08, CR00)
                            And (CR07, 0x7F, CR07)
                            EXFG ()
                            DECD (0x00, 0x00, FDIO, 0x07)
                        }

                        Name (_PSC, 0x00)
                        Method (_PS0, 0, NotSerialized)
                        {
                            ENFG ()
                            Or (CR00, 0x08, CR00)
                            EXFG ()
                            If (LEqual (\_SB.PCI0.ISA.SIO.FDC.IFDD._STA (), 0x0F))
                            {
                                \_SB.PCI0.IDE.SECN.PIDE._ON ()
                            }

                            Store (0x00, _PSC)
                            If (And (\_SB.PCI0.ISA.EC0.PQ06, 0x01))
                            {
                                Subtract (\_SB.PCI0.ISA.EC0.PQ06, 0x01)
                                Acquire (\_SB.PCI0.ISA.EC0.MUT2, 0xFFFF)
                                \_SB.PCI0.ISA.EC0.SWAP ()
                                Release (\_SB.PCI0.ISA.EC0.MUT2)
                            }
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR00, 0xF7, CR00)
                            EXFG ()
                            If (LEqual (\_SB.PCI0.ISA.SIO.FDC.IFDD._STA (), 0x0F))
                            {
                                \_SB.PCI0.IDE.SECN.PIDE._OFF ()
                            }

                            Store (0x03, _PSC)
                        }

                        Method (_FDE, 0, NotSerialized)
                        {
                            Store (Buffer (0x14)
                                {
                                    /* 0000 */    0x00
                                }, Local0)
                            CreateDWordField (Local0, 0x00, FD0)
                            CreateDWordField (Local0, 0x10, TAPE)
                            If (And (\_SB.PCI0.ISA.SIO.FDC.EFDD._STA (), 0x01))
                            {
                                Store (0x01, FD0)
                            }
                            Else
                            {
                                If (And (\_SB.PCI0.ISA.SIO.FDC.IFDD._STA (), 0x01))
                                {
                                    Store (0x01, FD0)
                                }
                            }

                            Store (0x02, TAPE)
                            Return (Local0)
                        }

                        Device (IFDD)
                        {
                            Method (_ADR, 0, NotSerialized)
                            {
                                If (\_SB.PCI0.ISA.ECOK ())
                                {
                                    If (\_SB.PCI0.ISA.EC0.EXFD)
                                    {
                                        Return (0x01)
                                    }
                                }
                                Else
                                {
                                    If (And (BDST, 0x01))
                                    {
                                        Return (0x01)
                                    }
                                }

                                Return (0x00)
                            }

                            Method (_STA, 0, NotSerialized)
                            {
                                If (\_SB.PCI0.ISA.ECOK ())
                                {
                                    If (\_SB.PCI0.ISA.EC0.EXFD)
                                    {
                                        Return (0x00)
                                    }
                                }
                                Else
                                {
                                    If (And (BDST, 0x01))
                                    {
                                        Return (0x00)
                                    }
                                }

                                If (\_SB.PCI0.ISA.ECOK ())
                                {
                                    If (LAnd (\_SB.PCI0.ISA.EC0.FDD, XOr (^^STOP, 0x01)))
                                    {
                                        If (LEqual (\_SB.PCI0.ISA.SIO.FDC.IFDD._PSC, 0x00))
                                        {
                                            Return (0x0F)
                                        }
                                        Else
                                        {
                                            Return (0x0D)
                                        }
                                    }
                                    Else
                                    {
                                        Return (0x00)
                                    }
                                }
                                Else
                                {
                                    If (And (BDST, 0x02))
                                    {
                                        If (LEqual (\_SB.PCI0.ISA.SIO.FDC.IFDD._PSC, 0x00))
                                        {
                                            Return (0x0F)
                                        }
                                        Else
                                        {
                                            Return (0x0D)
                                        }
                                    }
                                    Else
                                    {
                                        Return (0x00)
                                    }
                                }
                            }

                            Name (_PSC, 0x03)
                            Method (_PS0, 0, NotSerialized)
                            {
                                Store (0x00, _PSC)
                            }

                            Method (_PS3, 0, NotSerialized)
                            {
                                Store (0x03, _PSC)
                            }

                            Name (_PR0, Package (0x01)
                            {
                                \_SB.PCI0.IDE.SECN.PIDE
                            })
                            Method (_EJ0, 1, NotSerialized)
                            {
                                \_SB.PCI0.IDE.SECN.PIDE._OFF ()
                                If (\_SB.PCI0.ISA.EC0.EXFD)
                                {
                                    \_SB.PCI0.ISA.SIO.FDC.EFDD._EJ0 (0x01)
                                }
                                Else
                                {
                                    Store (0x03, _PSC)
                                    Or (\_SB.PCI0.ISA.SIO.FDC.STOP, 0x01, \_SB.PCI0.ISA.SIO.FDC.STOP)
                                }
                            }

                            Name (_FDI, Package (0x10)
                            {
                                0x00, 
                                0x04, 
                                0x4F, 
                                0x12, 
                                0x01, 
                                0xDF, 
                                0x02, 
                                0x25, 
                                0x02, 
                                0x12, 
                                0x1B, 
                                0xFF, 
                                0x6C, 
                                0xF6, 
                                0x0F, 
                                0x05
                            })
                        }

                        Device (EFDD)
                        {
                            Method (_ADR, 0, NotSerialized)
                            {
                                If (\_SB.PCI0.ISA.ECOK ())
                                {
                                    If (LNot (\_SB.PCI0.ISA.EC0.EXFD))
                                    {
                                        Return (0x01)
                                    }
                                }
                                Else
                                {
                                    If (LNot (And (BDST, 0x01)))
                                    {
                                        Return (0x01)
                                    }
                                }

                                Return (0x00)
                            }

                            Method (_STA, 0, NotSerialized)
                            {
                                If (\_SB.PCI0.ISA.ECOK ())
                                {
                                    If (LOr (LNot (\_SB.PCI0.ISA.EC0.EXFD), And (^^STOP, 0x02)))
                                    {
                                        Return (0x00)
                                    }
                                }
                                Else
                                {
                                    If (LNot (And (BDST, 0x01)))
                                    {
                                        Return (0x00)
                                    }
                                }

                                ENFG ()
                                And (CR01, 0xF7, CR01)
                                Or (CR01, 0x04, CR01)
                                And (CR04, 0xF0, CR04)
                                Or (CR04, 0x07, CR04)
                                Or (CR05, 0x20, CR05)
                                EXFG ()
                                If (LEqual (_PSC, 0x00))
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (0x0D)
                                }
                            }

                            Name (_PSC, 0x03)
                            Method (_PS0, 0, NotSerialized)
                            {
                                Store (0x00, _PSC)
                            }

                            Method (_PS3, 0, NotSerialized)
                            {
                                Store (0x03, _PSC)
                            }

                            Name (_EJD, "_SB_.PCI0.ISA_.SPR_")
                            Method (_EJ0, 1, NotSerialized)
                            {
                                Store (0x03, _PSC)
                                Or (\_SB.PCI0.ISA.SIO.FDC.STOP, 0x02, \_SB.PCI0.ISA.SIO.FDC.STOP)
                            }

                            Name (_FDI, Package (0x10)
                            {
                                0x00, 
                                0x04, 
                                0x4F, 
                                0x12, 
                                0x01, 
                                0xDF, 
                                0x02, 
                                0x25, 
                                0x02, 
                                0x12, 
                                0x1B, 
                                0xFF, 
                                0x6C, 
                                0xF6, 
                                0x0F, 
                                0x05
                            })
                        }

                        PowerResource (PFDD, 0x03, 0x0000)
                        {
                            Method (_STA, 0, NotSerialized)
                            {
                                Return (XOr (\_SB.PCI0.PX43.ENFD, 0x01))
                            }

                            Method (_ON, 0, NotSerialized)
                            {
                                Store (0x00, \_SB.PCI0.PX43.ENFD)
                            }

                            Method (_OFF, 0, NotSerialized)
                            {
                                Store (0x01, \_SB.PCI0.PX43.ENFD)
                            }
                        }
                    }

                    Device (LPT)
                    {
                        Method (_HID, 0, NotSerialized)
                        {
                            Store (0x0004D041, Local7)
                            ENFG ()
                            If (SIO2)
                            {
                                And (CR01, 0x08, Local1)
                                If (LNot (Local1))
                                {
                                    And (CR04, 0x02, Local2)
                                    If (Local2)
                                    {
                                        Store (0x0104D041, Local7)
                                    }
                                }
                            }

                            EXFG ()
                            Return (Local7)
                        }

                        Method (_STA, 0, NotSerialized)
                        {
                            ENFG ()
                            If (SIO2)
                            {
                                And (CR23, 0xC0, Local0)
                                And (CR01, 0x04, Local1)
                                If (LAnd (Local0, Local1))
                                {
                                    Store (0x0F, Local7)
                                }
                                Else
                                {
                                    Store (0x0D, Local7)
                                }
                            }
                            Else
                            {
                                Store (0x00, Local7)
                            }

                            EXFG ()
                            Return (Local7)
                        }

                        Method (_DIS, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR23, 0x3F, CR23)
                            And (CR26, 0xF0, CR26)
                            And (CR27, 0xF0, CR27)
                            EXFG ()
                        }

                        Method (_CRS, 0, NotSerialized)
                        {
                            ENFG ()
                            Name (CRSA, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y1D)
                                IRQNoFlags (_Y1E)
                                    {}
                            })
                            And (CR23, 0xC0, Local0)
                            And (CR01, 0x04, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (CRSA, \_SB.PCI0.ISA.SIO.LPT._CRS._Y1D._MIN, IOA1)
                                CreateByteField (CRSA, 0x03, IOA2)
                                CreateByteField (CRSA, \_SB.PCI0.ISA.SIO.LPT._CRS._Y1D._MAX, IOA3)
                                CreateByteField (CRSA, 0x05, IOA4)
                                CreateWordField (CRSA, \_SB.PCI0.ISA.SIO.LPT._CRS._Y1E._INT, IRQA)
                                ShiftLeft (CR23, 0x02, Local2)
                                ShiftRight (CR23, 0x06, Local3)
                                Store (Local2, IOA1)
                                Store (Local3, IOA2)
                                Store (Local2, IOA3)
                                Store (Local3, IOA4)
                                And (CR27, 0x0F, Local4)
                                Store (DerefOf (Index (IRQP, Local4)), IRQA)
                            }

                            Name (CRSB, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y1F)
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y20)
                                IRQNoFlags (_Y21)
                                    {}
                                DMA (Compatibility, NotBusMaster, Transfer8, _Y22)
                                    {}
                            })
                            And (CR23, 0xC0, Local0)
                            And (CR01, 0x04, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y1F._MIN, IOB1)
                                CreateByteField (CRSB, 0x03, IOB2)
                                CreateByteField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y1F._MAX, IOB3)
                                CreateByteField (CRSB, 0x05, IOB4)
                                CreateByteField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y1F._LEN, LNB1)
                                CreateByteField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y20._MIN, IOB5)
                                CreateByteField (CRSB, 0x0B, IOB6)
                                CreateByteField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y20._MAX, IOB7)
                                CreateByteField (CRSB, 0x0D, IOB8)
                                CreateByteField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y20._LEN, LNB2)
                                CreateWordField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y21._INT, IRQB)
                                CreateWordField (CRSB, \_SB.PCI0.ISA.SIO.LPT._CRS._Y22._DMA, DMAV)
                                ShiftLeft (CR23, 0x02, Local2)
                                ShiftRight (CR23, 0x06, Local3)
                                Store (Local2, IOB1)
                                Store (Local3, IOB2)
                                Store (Local2, IOB3)
                                Store (Local3, IOB4)
                                Store (Local2, IOB5)
                                Add (Local3, 0x04, IOB6)
                                Store (Local2, IOB7)
                                Add (Local3, 0x04, IOB8)
                                If (LEqual (Local2, 0x03BC))
                                {
                                    Store (0x03, LNB1)
                                    Store (0x03, LNB2)
                                }

                                And (CR27, 0x0F, Local4)
                                Store (DerefOf (Index (IRQP, Local4)), IRQB)
                                And (CR26, 0x03, Local5)
                                Store (DerefOf (Index (DMAP, Local5)), DMAV)
                            }

                            If (SIO2)
                            {
                                And (CR01, 0x08, Local2)
                                If (LNot (Local2))
                                {
                                    And (CR04, 0x02, Local3)
                                    EXFG ()
                                    If (Local3)
                                    {
                                        Return (CRSB)
                                    }
                                    Else
                                    {
                                        Return (CRSA)
                                    }
                                }
                                Else
                                {
                                    EXFG ()
                                    Return (CRSA)
                                }
                            }
                            Else
                            {
                                EXFG ()
                                Return (CRSA)
                            }
                        }

                        Name (PRSA, ResourceTemplate ()
                        {
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {7}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0278,             // Range Minimum
                                    0x0278,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {7}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0278,             // Range Minimum
                                    0x0278,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03BC,             // Range Minimum
                                    0x03BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IRQNoFlags ()
                                    {7}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03BC,             // Range Minimum
                                    0x03BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IRQNoFlags ()
                                    {5}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5,7,10,11}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0278,             // Range Minimum
                                    0x0278,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5,7,10,11}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03BC,             // Range Minimum
                                    0x03BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IRQNoFlags ()
                                    {5,7,10,11}
                            }
                            EndDependentFn ()
                        })
                        Name (PRSB, ResourceTemplate ()
                        {
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0778,             // Range Minimum
                                    0x0778,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {7}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0778,             // Range Minimum
                                    0x0778,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0278,             // Range Minimum
                                    0x0278,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0678,             // Range Minimum
                                    0x0678,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {7}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0278,             // Range Minimum
                                    0x0278,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0678,             // Range Minimum
                                    0x0678,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03BC,             // Range Minimum
                                    0x03BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IO (Decode16,
                                    0x07BC,             // Range Minimum
                                    0x07BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IRQNoFlags ()
                                    {7}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03BC,             // Range Minimum
                                    0x03BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IO (Decode16,
                                    0x07BC,             // Range Minimum
                                    0x07BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IRQNoFlags ()
                                    {5}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0778,             // Range Minimum
                                    0x0778,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5,7,10,11}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x0278,             // Range Minimum
                                    0x0278,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0678,             // Range Minimum
                                    0x0678,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {5,7,10,11}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03BC,             // Range Minimum
                                    0x03BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IO (Decode16,
                                    0x07BC,             // Range Minimum
                                    0x07BC,             // Range Maximum
                                    0x03,               // Alignment
                                    0x03,               // Length
                                    )
                                IRQNoFlags ()
                                    {5,7,10,11}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            EndDependentFn ()
                        })
                        Method (_PRS, 0, NotSerialized)
                        {
                            ENFG ()
                            If (SIO2)
                            {
                                And (CR01, 0x08, Local2)
                                If (LNot (Local2))
                                {
                                    And (CR04, 0x02, Local3)
                                    EXFG ()
                                    If (Local3)
                                    {
                                        Return (PRSB)
                                    }
                                    Else
                                    {
                                        Return (PRSA)
                                    }
                                }
                                Else
                                {
                                    EXFG ()
                                    Return (PRSA)
                                }
                            }
                            Else
                            {
                                EXFG ()
                                Return (PRSA)
                            }
                        }

                        Method (_SRS, 1, NotSerialized)
                        {
                            ENFG ()
                            CreateByteField (Arg0, 0x02, IO1)
                            CreateByteField (Arg0, 0x03, IO2)
                            CreateByteField (Arg0, 0x04, IO3)
                            CreateByteField (Arg0, 0x05, IO4)
                            CreateWordField (Arg0, 0x02, LPIO)
                            ShiftRight (IO1, 0x02, Local1)
                            ShiftLeft (IO2, 0x06, Local2)
                            Or (Local1, Local2, CR23)
                            Store (0x01, Local5)
                            And (CR01, 0x08, Local6)
                            If (LNot (Local6))
                            {
                                And (CR04, 0x02, Local3)
                                If (Local3)
                                {
                                    Store (0x00, Local5)
                                    CreateWordField (Arg0, 0x11, IRQ1)
                                    Store (Match (IRQP, MEQ, IRQ1, MTR, 0x00, 0x00), Local3)
                                    CreateWordField (Arg0, 0x14, DMAV)
                                    Store (Match (DMAP, MEQ, DMAV, MTR, 0x00, 0x00), Local4)
                                    And (CR26, 0xF0, CR26)
                                    Or (CR26, Local4, CR26)
                                }
                            }

                            If (Local5)
                            {
                                CreateWordField (Arg0, 0x09, IRQ2)
                                Store (Match (IRQP, MEQ, IRQ2, MTR, 0x00, 0x00), Local3)
                            }

                            And (CR27, 0xF0, CR27)
                            Or (CR27, Local3, CR27)
                            And (CR07, 0xEF, CR07)
                            EXFG ()
                            DECD (0x00, 0x00, LPIO, 0x07)
                        }

                        Name (_PSC, 0x00)
                        Method (_PS0, 0, NotSerialized)
                        {
                            ENFG ()
                            Or (CR01, 0x04, CR01)
                            EXFG ()
                            Store (0x00, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR01, 0xFB, CR01)
                            EXFG ()
                            Store (0x03, _PSC)
                        }
                    }

                    Device (COM1)
                    {
                        Name (_HID, EisaId ("PNP0501"))
                        Name (_UID, 0x00)
                        Name (_EJD, "_SB_.PCI0.ISA_.SPR_")
                        Method (_STA, 0, NotSerialized)
                        {
                            If (SIO0)
                            {
                                ENFG ()
                                And (CR24, 0xC0, Local0)
                                And (CR02, 0x08, Local1)
                                If (LAnd (Local0, Local1))
                                {
                                    Store (0x0F, Local7)
                                }
                                Else
                                {
                                    Store (0x0D, Local7)
                                }

                                EXFG ()
                            }
                            Else
                            {
                                Store (0x00, Local7)
                            }

                            Return (Local7)
                        }

                        Method (_DIS, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0xF7, CR02)
                            And (CR24, 0x3F, CR24)
                            And (CR28, 0x0F, CR28)
                            EXFG ()
                        }

                        Method (_CRS, 0, NotSerialized)
                        {
                            Name (RSRC, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y23)
                                IRQNoFlags (_Y24)
                                    {}
                            })
                            ENFG ()
                            And (CR24, 0xC0, Local0)
                            And (CR02, 0x08, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.COM1._CRS._Y23._MIN, IO1)
                                CreateByteField (RSRC, 0x03, IO2)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.COM1._CRS._Y23._MAX, IO3)
                                CreateByteField (RSRC, 0x05, IO4)
                                CreateWordField (RSRC, \_SB.PCI0.ISA.SIO.COM1._CRS._Y24._INT, IRQV)
                                ShiftLeft (CR24, 0x02, Local2)
                                ShiftRight (CR24, 0x06, Local3)
                                Store (Local2, IO1)
                                Store (Local3, IO2)
                                Store (Local2, IO3)
                                Store (Local3, IO4)
                                ShiftRight (CR28, 0x04, Local5)
                                Store (DerefOf (Index (IRQP, Local5)), IRQV)
                            }

                            EXFG ()
                            Return (RSRC)
                        }

                        Name (_PRS, ResourceTemplate ()
                        {
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            EndDependentFn ()
                        })
                        Method (_SRS, 1, NotSerialized)
                        {
                            CreateByteField (Arg0, 0x02, IO1)
                            CreateByteField (Arg0, 0x03, IO2)
                            CreateWordField (Arg0, 0x09, IRQV)
                            CreateWordField (Arg0, 0x02, C1IO)
                            ENFG ()
                            ShiftRight (IO1, 0x02, Local1)
                            ShiftLeft (IO2, 0x06, Local2)
                            Or (Local1, Local2, CR24)
                            Store (Match (IRQP, MEQ, IRQV, MTR, 0x00, 0x00), Local3)
                            ShiftLeft (Local3, 0x04, Local3)
                            And (CR28, 0x0F, CR28)
                            Or (CR28, Local3, CR28)
                            Or (CR02, 0x08, CR02)
                            And (CR07, 0xBF, CR07)
                            EXFG ()
                            DECD (0x11, 0x00, C1IO, 0x07)
                        }

                        Name (_PSC, 0x00)
                        Method (_PS0, 0, NotSerialized)
                        {
                            ENFG ()
                            Or (CR02, 0x08, CR02)
                            EXFG ()
                            Store (0x00, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0xF7, CR02)
                            EXFG ()
                            Store (0x03, _PSC)
                        }

                        Method (_PSW, 1, NotSerialized)
                        {
                            If (\_SB.PCI0.ISA.ECOK ())
                            {
                                If (Arg0)
                                {
                                    Store (0x01, \_SB.PCI0.ISA.EC0.MWAK)
                                }
                                Else
                                {
                                    Store (0x00, \_SB.PCI0.ISA.EC0.MWAK)
                                }
                            }
                        }

                        Name (_PRW, Package (0x02)
                        {
                            0x0A, 
                            0x03
                        })
                    }

                    Device (COM2)
                    {
                        Name (_HID, EisaId ("PNP0501"))
                        Name (_UID, 0x01)
                        Method (_STA, 0, NotSerialized)
                        {
                            If (LEqual (SIO1, 0x01))
                            {
                                ENFG ()
                                And (CR02, 0x80, Local0)
                                If (Local0)
                                {
                                    Store (0x0F, Local7)
                                }
                                Else
                                {
                                    Store (0x0D, Local7)
                                }
                            }
                            Else
                            {
                                Store (0x00, Local7)
                            }

                            Return (Local7)
                        }

                        Method (_DIS, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0x7F, CR02)
                            And (CR25, 0x3F, CR25)
                            And (CR28, 0xF0, CR28)
                            EXFG ()
                        }

                        Method (_CRS, 0, NotSerialized)
                        {
                            Name (RSRC, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y25)
                                IRQNoFlags (_Y26)
                                    {}
                            })
                            ENFG ()
                            And (CR25, 0xC0, Local0)
                            And (CR02, 0x80, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.COM2._CRS._Y25._MIN, IO1)
                                CreateByteField (RSRC, 0x03, IO2)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.COM2._CRS._Y25._MAX, IO3)
                                CreateByteField (RSRC, 0x05, IO4)
                                CreateWordField (RSRC, \_SB.PCI0.ISA.SIO.COM2._CRS._Y26._INT, IRQV)
                                ShiftLeft (CR25, 0x02, Local2)
                                ShiftRight (CR25, 0x06, Local3)
                                Store (Local2, IO1)
                                Store (Local3, IO2)
                                Store (Local2, IO3)
                                Store (Local3, IO4)
                                And (CR28, 0x0F, Local5)
                                Store (DerefOf (Index (IRQP, Local5)), IRQV)
                            }

                            EXFG ()
                            Return (RSRC)
                        }

                        Name (_PRS, ResourceTemplate ()
                        {
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            EndDependentFn ()
                        })
                        Method (_SRS, 1, NotSerialized)
                        {
                            CreateByteField (Arg0, 0x02, IO1)
                            CreateByteField (Arg0, 0x03, IO2)
                            CreateWordField (Arg0, 0x09, IRQV)
                            CreateWordField (Arg0, 0x02, C2IO)
                            ENFG ()
                            ShiftRight (IO1, 0x02, Local1)
                            ShiftLeft (IO2, 0x06, Local2)
                            Or (Local1, Local2, CR25)
                            Store (Match (IRQP, MEQ, IRQV, MTR, 0x00, 0x00), Local3)
                            And (CR28, 0xF0, CR28)
                            Or (CR28, Local3, CR28)
                            Or (CR02, 0x80, CR02)
                            And (CR07, 0xDF, CR07)
                            EXFG ()
                            DECD (0x22, 0x00, C2IO, 0x07)
                        }

                        Name (_PSC, 0x03)
                        Method (_PS0, 0, NotSerialized)
                        {
                            ENFG ()
                            Or (CR02, 0x80, CR02)
                            EXFG ()
                            Store (0x00, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0x7F, CR02)
                            EXFG ()
                            Store (0x03, _PSC)
                        }
                    }

                    Device (SIRA)
                    {
                        Name (_HID, EisaId ("PNP0511"))
                        Method (_STA, 0, NotSerialized)
                        {
                            If (LEqual (SIO1, 0x02))
                            {
                                ENFG ()
                                And (CR25, 0xC0, Local0)
                                And (CR02, 0x80, Local1)
                                If (LAnd (Local0, Local1))
                                {
                                    Store (0x0F, Local7)
                                }
                                Else
                                {
                                    Store (0x0D, Local7)
                                }

                                EXFG ()
                            }
                            Else
                            {
                                Store (0x00, Local7)
                            }

                            Return (Local7)
                        }

                        Method (_DIS, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0x7F, CR02)
                            And (CR25, 0x3F, CR25)
                            And (CR28, 0xF0, CR28)
                            EXFG ()
                        }

                        Method (_CRS, 0, NotSerialized)
                        {
                            Name (RSRC, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y27)
                                IRQNoFlags (_Y28)
                                    {}
                            })
                            ENFG ()
                            And (CR25, 0xC0, Local0)
                            And (CR02, 0x80, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.SIRA._CRS._Y27._MIN, IO1)
                                CreateByteField (RSRC, 0x03, IO2)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.SIRA._CRS._Y27._MAX, IO3)
                                CreateByteField (RSRC, 0x05, IO4)
                                CreateWordField (RSRC, \_SB.PCI0.ISA.SIO.SIRA._CRS._Y28._INT, IRQV)
                                ShiftLeft (CR25, 0x02, Local2)
                                ShiftRight (CR25, 0x06, Local3)
                                Store (Local2, IO1)
                                Store (Local3, IO2)
                                Store (Local2, IO3)
                                Store (Local3, IO4)
                                And (CR28, 0x0F, Local5)
                                Store (DerefOf (Index (IRQP, Local5)), IRQV)
                            }

                            EXFG ()
                            Return (RSRC)
                        }

                        Name (_PRS, ResourceTemplate ()
                        {
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                            }
                            EndDependentFn ()
                        })
                        Method (_SRS, 1, NotSerialized)
                        {
                            CreateByteField (Arg0, 0x02, IO1)
                            CreateByteField (Arg0, 0x03, IO2)
                            CreateWordField (Arg0, 0x09, IRQV)
                            CreateWordField (Arg0, 0x02, SIRO)
                            ENFG ()
                            ShiftRight (IO1, 0x02, Local1)
                            ShiftLeft (IO2, 0x06, Local2)
                            Or (Local1, Local2, CR25)
                            Store (Match (IRQP, MEQ, IRQV, MTR, 0x00, 0x00), Local3)
                            And (CR28, 0xF0, CR28)
                            Or (CR28, Local3, CR28)
                            Or (CR02, 0x80, CR02)
                            And (CR07, 0xDF, CR07)
                            EXFG ()
                            DECD (0x22, 0x00, SIRO, 0x07)
                        }

                        Name (_PSC, 0x03)
                        Method (_PS0, 0, NotSerialized)
                        {
                            ENFG ()
                            Or (CR02, 0x80, CR02)
                            EXFG ()
                            Store (0x00, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0x7F, CR02)
                            EXFG ()
                            Store (0x03, _PSC)
                        }
                    }

                    Device (FIRA)
                    {
                        Name (_HID, EisaId ("SMCF010"))
                        Method (_STA, 0, NotSerialized)
                        {
                            If (LEqual (SIO1, 0x03))
                            {
                                ENFG ()
                                And (CR25, 0xC0, Local0)
                                And (CR02, 0x80, Local1)
                                If (LAnd (Local0, Local1))
                                {
                                    Store (0x0F, Local7)
                                }
                                Else
                                {
                                    Store (0x0D, Local7)
                                }

                                EXFG ()
                            }
                            Else
                            {
                                Store (0x00, Local7)
                            }

                            Return (Local7)
                        }

                        Method (_DIS, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0x7F, CR02)
                            And (CR25, 0x3F, CR25)
                            And (CR28, 0xF0, CR28)
                            Store (0x00, CR2B)
                            And (CR2C, 0xF0, CR2C)
                            EXFG ()
                        }

                        Method (_CRS, 0, NotSerialized)
                        {
                            Name (RSRC, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y29)
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    _Y2A)
                                IRQNoFlags (_Y2B)
                                    {}
                                DMA (Compatibility, NotBusMaster, Transfer8, _Y2C)
                                    {}
                            })
                            ENFG ()
                            And (CR25, 0xC0, Local0)
                            And (CR02, 0x80, Local1)
                            If (LAnd (Local0, Local1))
                            {
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FIRA._CRS._Y29._MIN, IOU1)
                                CreateByteField (RSRC, 0x03, IOU2)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FIRA._CRS._Y29._MAX, IOU3)
                                CreateByteField (RSRC, 0x05, IOU4)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FIRA._CRS._Y2A._MIN, IOF1)
                                CreateByteField (RSRC, 0x0B, IOF2)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FIRA._CRS._Y2A._MAX, IOF3)
                                CreateByteField (RSRC, 0x0D, IOF4)
                                CreateWordField (RSRC, \_SB.PCI0.ISA.SIO.FIRA._CRS._Y2B._INT, IRQV)
                                CreateByteField (RSRC, \_SB.PCI0.ISA.SIO.FIRA._CRS._Y2C._DMA, DMAV)
                                ShiftLeft (CR25, 0x02, Local2)
                                ShiftRight (CR25, 0x06, Local3)
                                Store (Local2, IOU1)
                                Store (Local3, IOU2)
                                Store (Local2, IOU3)
                                Store (Local3, IOU4)
                                ShiftLeft (CR2B, 0x03, Local6)
                                ShiftRight (CR2B, 0x05, Local7)
                                Store (Local6, IOF1)
                                Store (Local7, IOF2)
                                Store (Local6, IOF3)
                                Store (Local7, IOF4)
                                And (CR28, 0x0F, Local5)
                                Store (DerefOf (Index (IRQP, Local5)), IRQV)
                                And (CR2C, 0x03, Local5)
                                Store (DerefOf (Index (DMAP, Local5)), DMAV)
                            }

                            EXFG ()
                            Return (RSRC)
                        }

                        Name (_PRS, ResourceTemplate ()
                        {
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0258,             // Range Minimum
                                    0x0258,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0158,             // Range Minimum
                                    0x0158,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0248,             // Range Minimum
                                    0x0248,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0148,             // Range Minimum
                                    0x0148,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03F8,             // Range Minimum
                                    0x03F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0258,             // Range Minimum
                                    0x0258,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02F8,             // Range Minimum
                                    0x02F8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0158,             // Range Minimum
                                    0x0158,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0248,             // Range Minimum
                                    0x0248,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {3}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            StartDependentFnNoPri ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IO (Decode16,
                                    0x0148,             // Range Minimum
                                    0x0148,             // Range Maximum
                                    0x08,               // Alignment
                                    0x08,               // Length
                                    )
                                IRQNoFlags ()
                                    {4}
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {0,3}
                            }
                            EndDependentFn ()
                        })
                        Method (_SRS, 1, NotSerialized)
                        {
                            CreateByteField (Arg0, 0x02, IOU1)
                            CreateByteField (Arg0, 0x03, IOU2)
                            CreateByteField (Arg0, 0x0A, IOF1)
                            CreateByteField (Arg0, 0x0B, IOF2)
                            CreateWordField (Arg0, 0x11, IRQV)
                            CreateWordField (Arg0, 0x14, DMAV)
                            CreateWordField (Arg0, 0x02, FIRO)
                            ENFG ()
                            ShiftRight (IOU1, 0x02, Local1)
                            ShiftLeft (IOU2, 0x06, Local2)
                            Or (Local1, Local2, CR25)
                            Store (Match (IRQP, MEQ, IRQV, MTR, 0x00, 0x00), Local3)
                            And (CR28, 0xF0, CR28)
                            Or (CR28, Local3, CR28)
                            ShiftRight (IOF1, 0x03, Local1)
                            ShiftLeft (IOF2, 0x05, Local2)
                            Or (Local1, Local2, CR2B)
                            Store (Match (DMAP, MEQ, DMAV, MTR, 0x00, 0x00), Local4)
                            And (CR2C, 0x0F, CR2C)
                            Or (CR2C, Local4, CR2C)
                            Or (CR02, 0x80, CR02)
                            And (CR07, 0xDF, CR07)
                            EXFG ()
                            DECD (0x22, 0x00, FIRO, 0x07)
                        }

                        Name (_PSC, 0x03)
                        Method (_PS0, 0, NotSerialized)
                        {
                            ENFG ()
                            Or (CR02, 0x80, CR02)
                            EXFG ()
                            Store (0x00, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            ENFG ()
                            And (CR02, 0x7F, CR02)
                            EXFG ()
                            Store (0x03, _PSC)
                        }
                    }
                }

                Device (SND)
                {
                    Name (_HID, EisaId ("NMX2210"))
                    Name (RSRC, ResourceTemplate ()
                    {
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {}
                        IRQNoFlags ()
                            {}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        Store (0x04, BCMD)
                        Store (0x11, DID)
                        Store (Zero, SMIC)
                        If (LNotEqual (STSB, Zero))
                        {
                            Or (0x04, STSB, STSB)
                        }

                        Return (STSB)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LNotEqual (_STA (), 0x00))
                        {
                            Store (0x00, BCMD)
                            Store (0x11, DID)
                            Store (Zero, SMIC)
                            Return (INFO)
                        }
                        Else
                        {
                            Return (RSRC)
                        }
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        Store (0x02, BCMD)
                        Store (0x11, DID)
                        Store (Zero, SMIC)
                        Return (INFO)
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        Store (Arg0, INFO)
                        Store (0x01, BCMD)
                        Store (0x11, DID)
                        Store (Zero, SMIC)
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        Store (0x03, BCMD)
                        Store (0x11, DID)
                        Store (Zero, SMIC)
                    }
                }

                Method (VTOB, 1, NotSerialized)
                {
                    Store (0x01, Local0)
                    ShiftLeft (Local0, Arg0, Local0)
                    Return (Local0)
                }

                Method (MKWD, 2, NotSerialized)
                {
                    If (And (Arg1, 0x80))
                    {
                        Store (0xFFFF0000, Local0)
                    }
                    Else
                    {
                        Store (Zero, Local0)
                    }

                    Or (Local0, Arg0, Local0)
                    Or (Local0, ShiftLeft (Arg1, 0x08), Local0)
                    Return (Local0)
                }

                Method (GBFE, 3, NotSerialized)
                {
                    CreateByteField (Arg0, Arg1, TIDX)
                    Store (TIDX, Arg2)
                }

                Method (PBFE, 3, NotSerialized)
                {
                    CreateByteField (Arg0, Arg1, TIDX)
                    Store (Arg2, TIDX)
                }

                Method (ITOS, 1, NotSerialized)
                {
                    Store (Buffer (0x09)
                        {
                            /* 0000 */    0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00
                        }, Local0)
                    Store (Buffer (0x11)
                        {
                            "0123456789ABCDEF"
                        }, Local7)
                    Store (0x08, Local1)
                    Store (0x00, Local2)
                    Store (0x00, Local3)
                    While (Local1)
                    {
                        Decrement (Local1)
                        And (ShiftRight (Arg0, ShiftLeft (Local1, 0x02)), 0x0F, Local4)
                        If (Local4)
                        {
                            Store (Ones, Local3)
                        }

                        If (Local3)
                        {
                            GBFE (Local7, Local4, RefOf (Local5))
                            PBFE (Local0, Local2, Local5)
                            Increment (Local2)
                        }
                    }

                    Return (Local0)
                }

                Method (ECOK, 0, NotSerialized)
                {
                    If (LAnd (And (\_SB.PCI0.ISA.EC0.OPRG, 0x08), And (\_SB.PCI0.ISA.MFLG, 0x01)))
                    {
                        Return (0x01)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Device (EC0)
                {
                    Name (_HID, EisaId ("PNP0C09"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0066,             // Range Minimum
                            0x0066,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    })
                    Name (_GPE, 0x09)
                    Name (OPRG, 0x17)
                    Method (_REG, 2, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            If (LEqual (Arg1, 0x00))
                            {
                                And (OPRG, Not (0x08), OPRG)
                            }
                            Else
                            {
                                Or (OPRG, 0x08, OPRG)
                            }
                        }
                    }

                    OperationRegion (ERAM, EmbeddedControl, 0x00, 0xFF)
                    Field (ERAM, AnyAcc, Lock, Preserve)
                    {
                        SMPR,   8, 
                        SMST,   8, 
                        SMAD,   8, 
                        SMCM,   8, 
                        SMD0,   256, 
                        BCNT,   8, 
                        SMAA,   8, 
                                Offset (0x28), 
                        TMP,    8, 
                        BPD,    8, 
                        HPBP,   8, 
                        TTMP,   8, 
                        DCID,   8, 
                        CHNG,   8, 
                        FAN,    1, 
                        LWAK,   1, 
                        EJWK,   1, 
                        ALRT,   1, 
                        EXFD,   1, 
                        PHDD,   1, 
                        SHDD,   1, 
                        FDD,    1, 
                        DPWR,   1, 
                        UDR0,   1, 
                        UDR5,   1, 
                        EQBF,   1, 
                        LDDS,   1, 
                        CRST,   1, 
                        DCWT,   1, 
                        QVCC,   1, 
                        S1LD,   1, 
                        S2LD,   1, 
                        VGAQ,   1, 
                        PSTS,   1, 
                        PWAK,   1, 
                        MWAK,   1, 
                        ADP,    1, 
                        POLL,   1, 
                        IRTG,   1, 
                        VIDO,   1, 
                        VOLD,   1, 
                        VOLU,   1, 
                        MUTE,   1, 
                        CONT,   1, 
                        BRGT,   1, 
                        MSTS,   1, 
                        KBID,   8, 
                        TCTL,   8, 
                        CHGM,   16, 
                        CHGS,   16, 
                        CHGC,   16, 
                        CHGV,   16, 
                        CHGA,   16, 
                        SELS,   16, 
                        BT1S,   8, 
                        BT1I,   16, 
                        BT1C,   16, 
                        BT1V,   16, 
                        BT2S,   8, 
                        BT2I,   16, 
                        BT2C,   16, 
                        BT2V,   16, 
                        B1WE,   1, 
                        B1WS,   1, 
                        B2WE,   1, 
                        B2WS,   1, 
                        BWAK,   1, 
                        FG45,   1, 
                        FG46,   1, 
                        FG47,   1, 
                        S2DK,   1, 
                        FG51,   1, 
                        FG52,   1, 
                        FG53,   1, 
                        FG54,   1, 
                        FG55,   1, 
                        FG56,   1, 
                        FG57,   1
                    }

                    Field (ERAM, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        SMW0,   16
                    }

                    Field (ERAM, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        SMB0,   8
                    }

                    Field (ERAM, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        FLD0,   64
                    }

                    Field (ERAM, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        FLD1,   128
                    }

                    Field (ERAM, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        FLD2,   192
                    }

                    Field (ERAM, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        FLD3,   256
                    }

                    Mutex (MUT0, 0x00)
                    Mutex (MUT1, 0x00)
                    Method (SMRD, 4, NotSerialized)
                    {
                        If (LNot (ECOK ()))
                        {
                            Return (0xFF)
                        }

                        If (LNotEqual (Arg0, 0x07))
                        {
                            If (LNotEqual (Arg0, 0x09))
                            {
                                If (LNotEqual (Arg0, 0x0B))
                                {
                                    Return (0x19)
                                }
                            }
                        }

                        Acquire (MUT0, 0xFFFF)
                        Store (0x06, Local0)
                        While (LGreater (Local0, 0x01))
                        {
                            And (SMST, 0x40, SMST)
                            Store (Arg2, SMCM)
                            Store (Arg1, SMAD)
                            Store (Arg0, SMPR)
                            While (LNot (And (SMST, 0xBF, Local1)))
                            {
                                Sleep (0x02)
                            }

                            If (LEqual (Local1, 0x80))
                            {
                                Store (0x00, Local0)
                            }
                            Else
                            {
                                Decrement (Local0)
                            }
                        }

                        If (Local0)
                        {
                            Store (And (Local1, 0x1F), Local0)
                        }
                        Else
                        {
                            If (LEqual (Arg0, 0x07))
                            {
                                Store (SMB0, Arg3)
                            }

                            If (LEqual (Arg0, 0x09))
                            {
                                Store (SMW0, Arg3)
                            }

                            If (LEqual (Arg0, 0x0B))
                            {
                                Store (BCNT, Local3)
                                ShiftRight (0x0100, 0x03, Local2)
                                If (LGreater (Local3, Local2))
                                {
                                    Store (Local2, Local3)
                                }

                                If (LLess (Local3, 0x09))
                                {
                                    Store (FLD0, Local2)
                                }
                                Else
                                {
                                    If (LLess (Local3, 0x11))
                                    {
                                        Store (FLD1, Local2)
                                    }
                                    Else
                                    {
                                        If (LLess (Local3, 0x19))
                                        {
                                            Store (FLD2, Local2)
                                        }
                                        Else
                                        {
                                            Store (FLD3, Local2)
                                        }
                                    }
                                }

                                Increment (Local3)
                                Store (Buffer (Local3) {}, Local4)
                                Decrement (Local3)
                                Store (Zero, Local5)
                                While (LGreater (Local3, Local5))
                                {
                                    GBFE (Local2, Local5, RefOf (Local6))
                                    PBFE (Local4, Local5, Local6)
                                    Increment (Local5)
                                }

                                PBFE (Local4, Local5, 0x00)
                                Store (Local4, Arg3)
                            }
                        }

                        Release (MUT0)
                        Return (Local0)
                    }

                    Method (SMWR, 4, NotSerialized)
                    {
                        If (LNot (ECOK ()))
                        {
                            Return (0xFF)
                        }

                        If (LNotEqual (Arg0, 0x06))
                        {
                            If (LNotEqual (Arg0, 0x08))
                            {
                                If (LNotEqual (Arg0, 0x0A))
                                {
                                    Return (0x19)
                                }
                            }
                        }

                        Acquire (MUT0, 0xFFFF)
                        Store (0x06, Local0)
                        While (LGreater (Local0, 0x01))
                        {
                            If (LEqual (Arg0, 0x06))
                            {
                                Store (Arg3, SMB0)
                            }

                            If (LEqual (Arg0, 0x08))
                            {
                                Store (Arg3, SMW0)
                            }

                            If (LEqual (Arg0, 0x0A))
                            {
                                Store (Arg3, SMD0)
                            }

                            And (SMST, 0x40, SMST)
                            Store (Arg2, SMCM)
                            Store (Arg1, SMAD)
                            Store (Arg0, SMPR)
                            While (LNot (And (SMST, 0xBF, Local1)))
                            {
                                Sleep (0x02)
                            }

                            If (LEqual (Local1, 0x80))
                            {
                                Store (0x00, Local0)
                            }
                            Else
                            {
                                Decrement (Local0)
                            }
                        }

                        If (Local0)
                        {
                            Store (And (Local1, 0x1F), Local0)
                        }

                        Release (MUT0)
                        Return (Local0)
                    }

                    Method (DOBP, 1, NotSerialized)
                    {
                        Store (Arg0, HPBP)
                    }

                    Name (SEL0, 0xF0)
                    Method (SMSL, 0, NotSerialized)
                    {
                        Store ("CMBatt - SMSL", Debug)
                        If (LNot (ECOK ()))
                        {
                            Return (0xFF)
                        }

                        Acquire (MUT1, 0xFFFF)
                        If (LNot (SMRD (0x09, 0x14, 0x01, RefOf (Local0))))
                        {
                            Store (Local0, SEL0)
                            Store (SEL0, Debug)
                            If (LEqual (ALRT, 0x01))
                            {
                                \_SB.PCI0.ISA.BAT1.IVBI ()
                                \_SB.PCI0.ISA.BAT1.IVBS ()
                                \_SB.PCI0.ISA.BAT2.IVBI ()
                                \_SB.PCI0.ISA.BAT2.IVBS ()
                                Store (0x00, ALRT)
                            }

                            Store (\_SB.PCI0.ISA.ACAD.CHAC (SEL0), Local1)
                            Store (\_SB.PCI0.ISA.BAT1.CHBP (SEL0), Local2)
                            Store (\_SB.PCI0.ISA.BAT2.CHBP (SEL0), Local3)
                            Or (SEL0, 0x0FFF, Local0)
                            SMWR (0x08, 0x14, 0x01, Local0)
                            If (LAnd (Local1, \_SB.PCI0.ISA.ACAD.ACP))
                            {
                                Store ("CMBatt - Notify(ACAD,0x80): AC_Inserted", Debug)
                                \_SB.PCI0.ISA.HPSS (0x12)
                                Notify (\_SB.PCI0.ISA.ACAD, 0x80)
                            }

                            If (And (0x04, Local2))
                            {
                                \_SB.PCI0.ISA.BAT1.B1CK ()
                            }

                            If (And (0x02, Local2))
                            {
                                \_SB.PCI0.ISA.BAT1.B1ST ()
                            }

                            If (And (0x01, Local2))
                            {
                                \_SB.PCI0.ISA.BAT1.B1IF ()
                            }

                            If (And (0x04, Local3))
                            {
                                \_SB.PCI0.ISA.BAT2.B2CK ()
                            }

                            If (And (0x02, Local3))
                            {
                                \_SB.PCI0.ISA.BAT2.B2ST ()
                            }

                            If (And (0x01, Local3))
                            {
                                \_SB.PCI0.ISA.BAT2.B2IF ()
                            }

                            If (LAnd (Local1, LNot (\_SB.PCI0.ISA.ACAD.ACP)))
                            {
                                Store ("CMBatt - Notify(ACAD, 0x80): AC_Removed", Debug)
                                \_SB.PCI0.ISA.HPSS (0x12)
                                Notify (\_SB.PCI0.ISA.ACAD, 0x80)
                            }
                        }

                        Store (0x3C, Local4)
                        If (\_SB.PCI0.ISA.BAT1.REPT)
                        {
                            Store (0x02, Local4)
                        }

                        If (\_SB.PCI0.ISA.BAT2.REPT)
                        {
                            Store (0x02, Local4)
                        }

                        If (BFLG)
                        {
                            Store (0x01, Local5)
                            While (LNot (And (BFLG, 0x01)))
                            {
                                Increment (Local5)
                                ShiftRight (BFLG, 0x01, BFLG)
                            }

                            ShiftRight (BFLG, 0x01, BFLG)
                            If (LGreater (Local4, Local5))
                            {
                                Store (Local5, Local4)
                            }
                        }

                        Store (Local4, BPD)
                        BPOL ()
                        Release (MUT1)
                    }

                    Name (PSTA, 0x00)
                    Method (CPOL, 0, NotSerialized)
                    {
                        If (LEqual (PSTA, 0x00))
                        {
                            If (ECOK ())
                            {
                                BPOL ()
                                Store (0x01, PSTA)
                            }
                        }
                    }

                    Method (BPOL, 0, NotSerialized)
                    {
                        Store (0x01, POLL)
                    }

                    Name (BFLG, 0x00)
                    Method (_Q02, 0, NotSerialized)
                    {
                        Store ("QUERY_02", Debug)
                        If (And (SMST, 0x40))
                        {
                            Store (SMAA, Local0)
                            If (LEqual (Local0, 0x14))
                            {
                                Store ("CMBatt - PwrEvent", Debug)
                                And (SMST, 0xBF, SMST)
                                Store (0x12, BFLG)
                                Store (0x00, BPD)
                                BPOL ()
                            }
                        }
                    }

                    Method (_Q03, 0, NotSerialized)
                    {
                        Store ("QUERY_03", Debug)
                        Notify (\_TZ.THRM, 0x80)
                    }

                    Method (RDSN, 0, NotSerialized)
                    {
                        Name (CNT1, 0x00)
                        While (LLessEqual (CNT1, 0x03))
                        {
                            If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0xAC, 0x07, RefOf (Local0))))
                            {
                                Store (0xFFFF, CNT1)
                            }
                            Else
                            {
                                Increment (CNT1)
                                Sleep (0x14)
                            }
                        }

                        Store (Zero, Local1)
                        Or (Local1, Local0, Local1)
                        Store (Zero, CNT1)
                        While (LLessEqual (CNT1, 0x03))
                        {
                            If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0xAC, 0x09, RefOf (Local0))))
                            {
                                Store (0xFFFF, CNT1)
                            }
                            Else
                            {
                                Increment (CNT1)
                                Sleep (0x14)
                            }
                        }

                        Or (Local1, ShiftLeft (Local0, 0x10), Local1)
                        Store (Local1, \_SB.PCI0.ISA.DKSN)
                    }

                    Method (_Q04, 0, NotSerialized)
                    {
                        Store ("QUERY_04", Debug)
                        Store (\_SB.PCI0.ISA.EC0.DCID, \_SB.PCI0.ISA.DKTP)
                        Store (0x01, \_SB.PCI0.ISA.EC0.DCWT)
                        Store (0x01, \_SB.PCI0.ISA.EC0.DPWR)
                        If (And (DCKF, 0x02))
                        {
                            And (DCKF, Not (0x02), DCKF)
                            Store (\_SB.PCI0.ISA.DKTP, Local1)
                            Store (0x00, \_SB.PCI0.ISA.DKTP)
                            Signal (\_SB.PCI0.ISA.SPR.EJVT)
                            Sleep (0x1388)
                            Store (Local1, \_SB.PCI0.ISA.DKTP)
                            Notify (\_SB.PCI0.ISA.SIO.COM1, 0x00)
                            Notify (\_SB.PCI0.ISA.SIO.LPT, 0x00)
                            Notify (\_SB.PCI0.ISA.SPR, 0x00)
                        }
                        Else
                        {
                            RDSN ()
                            Notify (\_SB.PCI0.ISA.SIO.COM1, 0x00)
                            Notify (\_SB.PCI0.ISA.SIO.LPT, 0x00)
                            Notify (\_SB.PCI0.ISA.SPR, 0x00)
                            HPSS (0x00)
                        }

                        Return (Zero)
                    }

                    Method (_Q05, 0, NotSerialized)
                    {
                        Store ("QUERY_05", Debug)
                        If (And (DCKF, 0x02))
                        {
                            And (DCKF, Not (0x02), DCKF)
                            Store (\_SB.PCI0.ISA.DKTP, Local2)
                            Store (0x00, \_SB.PCI0.ISA.DKTP)
                            HPSS (0x00)
                            Signal (\_SB.PCI0.ISA.SPR.EJVT)
                            Name (CNT1, 0x00)
                            Name (NVRS, 0x00)
                            Name (CLSD, 0x00)
                            While (LLessEqual (CNT1, 0x03))
                            {
                                If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0xB0, 0x80, RefOf (Local0))))
                                {
                                    Store (And (Local0, 0x04), NVRS)
                                    Store (And (Local0, 0x02), CLSD)
                                    If (LOr (LAnd (LNot (NVRS), LNot (CLSD)), LAnd (CLSD, LNot (
                                        LPOL))))
                                    {
                                        Notify (\_SB.PCI0.ISA.HPCI, 0x87)
                                    }

                                    Store (0xFFFF, CNT1)
                                }
                                Else
                                {
                                    Increment (CNT1)
                                    Sleep (0x14)
                                }
                            }

                            Return (Zero)
                        }

                        Store (\_SB.PCI0.ISA.EC0.DCID, Local1)
                        If (LEqual (Local1, 0x00))
                        {
                            Store (\_SB.PCI0.ISA.DKTP, Local2)
                            If (And (DCKF, 0x10))
                            {
                                Store (0x00, \_SB.PCI0.ISA.EC0.DCWT)
                                And (DCKF, Not (0x10), DCKF)
                                Return (Zero)
                            }

                            Or (DCKF, 0x04, DCKF)
                            Notify (\_SB.PCI0.ISA.SPR, 0x01)
                        }
                        Else
                        {
                            If (LAnd (\_SB.PCI0.ISA.HPCI.Z000, LNot (And (\_SB.PCI0.ISA.HPCI.Z000, 0x02))))
                            {
                                Notify (\_SB.PCI0.ISA.HPCI, 0x85)
                            }
                            Else
                            {
                                Notify (\_SB.PCI0.ISA.SPR, 0x01)
                            }
                        }
                    }

                    Method (_Q06, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT2, 0xFFFF)
                        \_SB.PCI0.ISA.EC0.SWAP ()
                        Release (\_SB.PCI0.ISA.EC0.MUT2)
                    }

                    Name (PQ06, 0x00)
                    Mutex (MUT2, 0x00)
                    Method (SWAP, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.OSNT, 0x00))
                        {
                            HPSS (0x0A)
                        }

                        If (LEqual (\_SB.PCI0.OSNT, 0x01))
                        {
                            Store (\_SB.PCI0.IDE.BAYD, Local0)
                            If (LNot (\_SB.PCI0.ISA.EC0.SHDD))
                            {
                                If (And (Local0, 0x04))
                                {
                                    If (LNot (\_SB.PCI0.IDE._PSC))
                                    {
                                        If (And (LEqual (\_SB.PCI0.IDE.TSEC, 0x8000), \_SB.PCI0.IDE.SECN.MAST.STOP))
                                        {
                                            Notify (\_SB.PCI0.IDE.SECN.MAST, 0x01)
                                            Store (0x00, \_SB.PCI0.IDE.SECN.MAST.STOP)
                                        }
                                        Else
                                        {
                                            \_SB.PCI0.IDE.SECN.PIDE._OFF ()
                                            Notify (\_SB.PCI0.IDE.SECN, 0x01)
                                        }

                                        And (\_SB.PCI0.IDE.BAYD, Not (0x04), \_SB.PCI0.IDE.BAYD)
                                    }
                                    Else
                                    {
                                        Or (PQ06, 0x02, PQ06)
                                    }
                                }
                            }

                            If (LNot (\_SB.PCI0.ISA.EC0.FDD))
                            {
                                If (And (Local0, 0x02))
                                {
                                    If (LNot (\_SB.PCI0.ISA.SIO.FDC._PSC))
                                    {
                                        If (LNot (\_SB.PCI0.ISA.EC0.EXFD))
                                        {
                                            Store (0x01, \_SB.PCI0.ISA.TRIS)
                                            Store (0x01, \_SB.PCI0.PX43.SDPW)
                                            \_SB.PCI0.ISA.SIO.FDC.IFDD._PS3 ()
                                            Notify (\_SB.PCI0.ISA.SIO.FDC, 0x01)
                                        }

                                        And (\_SB.PCI0.ISA.SIO.FDC.STOP, Not (0x01), \_SB.PCI0.ISA.SIO.FDC.STOP)
                                        And (\_SB.PCI0.IDE.BAYD, Not (0x02), \_SB.PCI0.IDE.BAYD)
                                    }
                                    Else
                                    {
                                        Or (PQ06, 0x01, PQ06)
                                    }
                                }
                            }

                            If (\_SB.PCI0.ISA.EC0.SHDD)
                            {
                                If (LNot (And (Local0, 0x04)))
                                {
                                    If (LNot (\_SB.PCI0.IDE._PSC))
                                    {
                                        Store (0x01, \_SB.PCI0.ISA.TRIS)
                                        Store (0x00, \_SB.PCI0.PX43.SDPW)
                                        Store (0x01, \_SB.PCI0.PX43.SRST)
                                        Sleep (0x64)
                                        Store (0x00, \_SB.PCI0.PX43.SRST)
                                        Sleep (0xC8)
                                        Store (0x00, \_SB.PCI0.ISA.TRIS)
                                        Store (0xC057, \_SB.PCI0.IDE.TSEC)
                                        Store (0x00, \_SB.PCI0.IDE.SECN.MAST.STOP)
                                        Notify (\_SB.PCI0.IDE.SECN, 0x01)
                                        Or (\_SB.PCI0.IDE.BAYD, 0x04, \_SB.PCI0.IDE.BAYD)
                                    }
                                    Else
                                    {
                                        Or (PQ06, 0x02, PQ06)
                                    }
                                }
                            }

                            If (\_SB.PCI0.ISA.EC0.FDD)
                            {
                                If (LNot (And (Local0, 0x02)))
                                {
                                    If (LNot (\_SB.PCI0.ISA.SIO.FDC._PSC))
                                    {
                                        If (LNot (\_SB.PCI0.ISA.EC0.EXFD))
                                        {
                                            \_SB.PCI0.ISA.SIO.FDC.IFDD._PS0 ()
                                            Store (0x01, \_SB.PCI0.ISA.TRIS)
                                            Store (0x00, \_SB.PCI0.PX43.SDPW)
                                            Store (0x00, \_SB.PCI0.ISA.TRIS)
                                            Notify (\_SB.PCI0.ISA.SIO.FDC, 0x01)
                                        }

                                        Or (\_SB.PCI0.IDE.BAYD, 0x02, \_SB.PCI0.IDE.BAYD)
                                    }
                                    Else
                                    {
                                        Or (PQ06, 0x01, PQ06)
                                    }
                                }
                            }

                            If (\_SB.PCI0.ISA.EC0.EXFD)
                            {
                                If (LNot (And (Local0, 0x01)))
                                {
                                    If (LNot (\_SB.PCI0.ISA.SIO.FDC._PSC))
                                    {
                                        \_SB.PCI0.ISA.SIO.FDC.EFDD._PS0 ()
                                        Notify (\_SB.PCI0.ISA.SIO, 0x01)
                                        Or (\_SB.PCI0.IDE.BAYD, 0x01, \_SB.PCI0.IDE.BAYD)
                                    }
                                    Else
                                    {
                                        Or (PQ06, 0x01, PQ06)
                                    }
                                }
                            }

                            If (LNot (\_SB.PCI0.ISA.EC0.EXFD))
                            {
                                If (And (Local0, 0x01))
                                {
                                    If (LNot (\_SB.PCI0.ISA.SIO.FDC._PSC))
                                    {
                                        Store (0x0370, \_SB.PCI0.PX43.DEC1)
                                        Store (0x11, \_SB.PCI0.PX43.DEEN)
                                        HPSS (0x05)
                                        Store (0x01, \_SB.PCI0.PX43.DEEN)
                                        \_SB.PCI0.ISA.SIO.FDC.EFDD._PS3 ()
                                        And (\_SB.PCI0.IDE.BAYD, Not (0x01), \_SB.PCI0.IDE.BAYD)
                                        And (\_SB.PCI0.ISA.SIO.FDC.STOP, Not (0x02), \_SB.PCI0.ISA.SIO.FDC.STOP)
                                        If (And (Local0, 0x02))
                                        {
                                            If (LNot (And (\_SB.PCI0.ISA.SIO.FDC.STOP, 0x01)))
                                            {
                                                \_SB.PCI0.ISA.SIO.FDC.IFDD._PS0 ()
                                                Store (0x01, \_SB.PCI0.ISA.TRIS)
                                                Store (0x00, \_SB.PCI0.PX43.SDPW)
                                                Store (0x00, \_SB.PCI0.ISA.TRIS)
                                            }
                                        }

                                        Notify (\_SB.PCI0.ISA.SIO, 0x00)
                                    }
                                    Else
                                    {
                                        Or (PQ06, 0x01, PQ06)
                                    }
                                }
                            }
                        }
                    }

                    Method (_Q09, 0, NotSerialized)
                    {
                        Store ("QUERY_09", Debug)
                        SMSL ()
                    }

                    Method (_Q0A, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.ISA.EC0.VOLD)
                        {
                            If (\_SB.PCI0.ISA.HPCI.Z000)
                            {
                                Notify (\_SB.PCI0.ISA.HPCI, 0x82)
                            }
                            Else
                            {
                                HPSS (0x03)
                            }

                            Store (0x00, \_SB.PCI0.ISA.EC0.VOLD)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.VOLU)
                        {
                            If (\_SB.PCI0.ISA.HPCI.Z000)
                            {
                                Notify (\_SB.PCI0.ISA.HPCI, 0x83)
                            }
                            Else
                            {
                                HPSS (0x02)
                            }

                            Store (0x00, \_SB.PCI0.ISA.EC0.VOLU)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.CONT)
                        {
                            HPSS (0x07)
                            Store (0x00, \_SB.PCI0.ISA.EC0.CONT)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.BRGT)
                        {
                            HPSS (0x08)
                            Store (0x00, \_SB.PCI0.ISA.EC0.BRGT)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.VIDO)
                        {
                            If (LEqual (\_SB.PCI0.AGP.VGA.DISW, 0x00))
                            {
                                \_SB.PCI0.AGP.VGA.DRUL (0x01)
                            }
                            Else
                            {
                                If (LEqual (\_SB.PCI0.AGP.VGA.DISW, 0x01))
                                {
                                    Store (0x00, \_SB.PCI0.ISA.STSB)
                                    HPSS (0x01)
                                }
                            }

                            Store (0x00, \_SB.PCI0.ISA.EC0.VIDO)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.MUTE)
                        {
                            If (\_SB.PCI0.ISA.HPCI.Z000)
                            {
                                Notify (\_SB.PCI0.ISA.HPCI, 0x84)
                            }
                            Else
                            {
                                HPSS (0x06)
                            }

                            Store (0x00, \_SB.PCI0.ISA.EC0.MUTE)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.IRTG)
                        {
                            HPSS (0x09)
                            Store (0x00, \_SB.PCI0.ISA.EC0.IRTG)
                            Return (Zero)
                        }

                        If (\_SB.PCI0.ISA.EC0.S2DK)
                        {
                            Notify (\_SB.PCI0.ISA.HPCI, 0x86)
                            Store (0x00, \_SB.PCI0.ISA.EC0.S2DK)
                            Return (Zero)
                        }
                    }
                }

                Device (ACAD)
                {
                    Name (_HID, "ACPI0003")
                    Name (_PCL, Package (0x01)
                    {
                        \_SB
                    })
                    Name (ACP, Ones)
                    Method (_PSR, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _PSR", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        Store (ACP, Local0)
                        If (Local0)
                        {
                            Store (0x01, Local1)
                        }
                        Else
                        {
                            Store (0x00, Local1)
                        }

                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (Local1)
                    }

                    Method (CHAC, 1, NotSerialized)
                    {
                        Store (LGreater (And (Arg0, 0xF0), 0x80), Local0)
                        If (LNotEqual (Local0, ACP))
                        {
                            Store (Local0, ACP)
                            Return (Ones)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }
                }

                Device (BAT1)
                {
                    Name (_HID, EisaId ("PNP0C0A"))
                    Name (_UID, 0x01)
                    Name (_PCL, Package (0x01)
                    {
                        \_SB
                    })
                    Name (PBIF, Package (0x0D)
                    {
                        0x01, 
                        0x09C4, 
                        0x09C4, 
                        0x01, 
                        0x3840, 
                        0x012C, 
                        0xC8, 
                        0x20, 
                        0x20, 
                        "BAT1", 
                        " ", 
                        " ", 
                        " "
                    })
                    Name (PBST, Package (0x04)
                    {
                        0x00, 
                        0xFFFFFFFF, 
                        0xFFFFFFFF, 
                        0x3840
                    })
                    Name (UBIF, 0x01E9)
                    Name (BP, 0x00)
                    Name (REPT, 0x00)
                    Name (ERRC, 0x00)
                    Method (_PSW, 1, NotSerialized)
                    {
                        If (\_SB.PCI0.ISA.ECOK ())
                        {
                            If (Arg0)
                            {
                                Store (0x01, \_SB.PCI0.ISA.EC0.B1WE)
                            }
                            Else
                            {
                                Store (0x00, \_SB.PCI0.ISA.EC0.B1WE)
                            }
                        }
                    }

                    Name (_PRW, Package (0x02)
                    {
                        0x0A, 
                        0x03
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _STA.BAT1", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        If (BP)
                        {
                            Store (0x1F, Local1)
                        }
                        Else
                        {
                            Store (0x0F, Local1)
                        }

                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (Local1)
                    }

                    Method (_BIF, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _BIF.BAT1", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (PBIF)
                    }

                    Method (_BST, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _BST.BAT1", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (PBST)
                    }

                    Method (B1CK, 0, NotSerialized)
                    {
                        Store ("CMBatt - Notify(BAT1,0x81): B1CK", Debug)
                        Notify (\_SB.PCI0.ISA.BAT1, 0x81)
                    }

                    Method (B1ST, 0, NotSerialized)
                    {
                        Store ("CMBatt - Notify(BAT1,0x80): B1ST", Debug)
                        Notify (\_SB.PCI0.ISA.BAT1, 0x80)
                    }

                    Method (B1IF, 0, NotSerialized)
                    {
                        Store ("CMBatt - Notify(BAT1,0x81): B1IF", Debug)
                        Notify (\_SB.PCI0.ISA.BAT1, 0x81)
                    }

                    Method (UPBI, 0, NotSerialized)
                    {
                        Store ("CMBatt - UPBI.BAT1", Debug)
                        Store (Zero, Local0)
                        If (LNot (ECOK ()))
                        {
                            Return (Local0)
                        }

                        Store (0x0C, Local1)
                        Store (Buffer (0x0D)
                            {
                                /* 0000 */    0x00, 0x18, 0x10, 0x00, 0x19, 0x00, 0x00, 0x00, 
                                /* 0008 */    0x00, 0x21, 0x00, 0x22, 0x20
                            }, Local2)
                        While (LGreater (Local1, 0x08))
                        {
                            If (LNot (And (UBIF, VTOB (Local1))))
                            {
                                GBFE (Local2, Local1, RefOf (Local3))
                                If (Local3)
                                {
                                    If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x0B, 0x16, Local3, RefOf (Local4))))
                                    {
                                        Store (\_SB.PCI0.ISA.EC0.BCNT, Local5)
                                        Store (Zero, Local3)
                                        Store (Zero, ERRC)
                                        While (LGreater (Local5, Local3))
                                        {
                                            GBFE (Local4, Local3, RefOf (Local6))
                                            Increment (Local3)
                                            If (And (Local6, 0x80))
                                            {
                                                Increment (ERRC)
                                            }
                                        }

                                        If (LEqual (ERRC, 0x00))
                                        {
                                            Store (Local4, Index (PBIF, Local1))
                                            Or (UBIF, VTOB (Local1), UBIF)
                                            Store (Ones, Local0)
                                        }
                                    }
                                }
                            }

                            Decrement (Local1)
                        }

                        While (LGreater (Local1, 0x00))
                        {
                            If (LNot (And (UBIF, VTOB (Local1))))
                            {
                                GBFE (Local2, Local1, RefOf (Local3))
                                If (Local3)
                                {
                                    If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0x16, Local3, RefOf (Local5))))
                                    {
                                        If (LAnd (Local5, LNot (And (Local5, 0x8000))))
                                        {
                                            Store (Local5, Index (PBIF, Local1))
                                            Or (UBIF, VTOB (Local1), UBIF)
                                            Store (Ones, Local0)
                                        }
                                    }
                                }
                            }

                            Decrement (Local1)
                        }

                        Store (0x0A, Local1)
                        If (LNot (And (UBIF, VTOB (Local1))))
                        {
                            If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0x16, 0x1C, RefOf (Local5))))
                            {
                                Store (ITOS (ToBCD (Local5)), Index (PBIF, Local1))
                                Or (UBIF, VTOB (Local1), UBIF)
                                Store (Ones, Local0)
                            }
                        }

                        Store (PBIF, Debug)
                        Return (Local0)
                    }

                    Method (UPBS, 0, NotSerialized)
                    {
                        Store ("CMBatt - UPBS.BAT1", Debug)
                        Store (Zero, Local0)
                        If (LNot (ECOK ()))
                        {
                            Return (Local0)
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT1S, Local5)
                        Store (Local5, Local1)
                        And (Local5, 0x07, Local5)
                        If (LNotEqual (Local5, DerefOf (Index (PBST, 0x00))))
                        {
                            Store ("CMBatt - BAT1 STATE CHANGE", Debug)
                            Store (Local1, Debug)
                            Store (Local5, Index (PBST, 0x00))
                            Store (Ones, Local0)
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT1I, Local5)
                        If (And (Local1, 0x01))
                        {
                            If (And (Local5, 0x8000))
                            {
                                Or (Local5, 0xFFFF0000, Local5)
                                Add (Not (Local5), 0x01, Local5)
                                If (LGreater (0x0398, Local5))
                                {
                                    Store (0x0398, Local5)
                                }
                            }
                            Else
                            {
                                Store (0x0398, Local5)
                            }
                        }

                        If (And (Local1, 0x02))
                        {
                            If (And (Local5, 0x8000))
                            {
                                Store (0x00, Local5)
                            }

                            If (LGreater (0x64, Local5))
                            {
                                Store (0x64, Local5)
                            }
                        }

                        If (LEqual (And (Local1, 0x03), 0x00))
                        {
                            Store (0x00, Local5)
                        }

                        ShiftRight (Local5, 0x05, Local5)
                        ShiftLeft (Local5, 0x05, Local5)
                        If (LNotEqual (Local5, DerefOf (Index (PBST, 0x01))))
                        {
                            Store (Local5, Index (PBST, 0x01))
                            Store (Ones, Local0)
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT1C, Local5)
                        If (LNot (And (Local5, 0x8000)))
                        {
                            ShiftRight (Local5, 0x05, Local5)
                            ShiftLeft (Local5, 0x05, Local5)
                            If (LNotEqual (Local5, DerefOf (Index (PBST, 0x02))))
                            {
                                Store (Local5, Index (PBST, 0x02))
                                Store (Ones, Local0)
                            }
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT1V, Local5)
                        If (LNot (And (Local5, 0x8000)))
                        {
                            ShiftRight (Local5, 0x05, Local5)
                            ShiftLeft (Local5, 0x05, Local5)
                            If (LNotEqual (Local5, DerefOf (Index (PBST, 0x03))))
                            {
                                Store (Local5, Index (PBST, 0x03))
                                Store (Ones, Local0)
                            }
                        }

                        If (Local0)
                        {
                            Store ("CMBATT - PBST Changed", Debug)
                        }

                        Store (PBST, Debug)
                        Return (Local0)
                    }

                    Method (IVBI, 0, NotSerialized)
                    {
                        Store (0x01E9, UBIF)
                        Store (0x09C4, Index (PBIF, 0x01))
                        Store (0x09C4, Index (PBIF, 0x02))
                        Store (0x3840, Index (PBIF, 0x04))
                        Store ("Bad", Index (PBIF, 0x09))
                        Store ("Bad", Index (PBIF, 0x0A))
                        Store ("Bad", Index (PBIF, 0x0B))
                        Store ("Bad", Index (PBIF, 0x0C))
                    }

                    Method (IVBS, 0, NotSerialized)
                    {
                        Store (0x00, Index (PBST, 0x00))
                        Store (0xFFFFFFFF, Index (PBST, 0x01))
                        Store (0xFFFFFFFF, Index (PBST, 0x02))
                        Store (0x3840, Index (PBST, 0x03))
                    }

                    Method (CHBP, 1, NotSerialized)
                    {
                        Store ("CMBatt - CHBP.BAT1", Debug)
                        Store (Zero, Local0)
                        If (LNot (ECOK ()))
                        {
                            Return (Local0)
                        }

                        Store (VTOB (Subtract (_UID, 0x01)), Local1)
                        Or (ShiftLeft (Local1, 0x0C), 0x0FFF, Local2)
                        Store (Zero, Local3)
                        If (And (Arg0, Local1))
                        {
                            If (BP)
                            {
                                Store ("CMBatt - BAT1 still present", Debug)
                                \_SB.PCI0.ISA.EC0.SMWR (0x08, 0x14, 0x01, Local2)
                                \_SB.PCI0.ISA.EC0.SMRD (0x09, 0x14, 0x01, RefOf (Local3))
                                If (LEqual (Local2, Or (Local3, 0x0FFF)))
                                {
                                    If (UPBI ())
                                    {
                                        Or (0x01, Local0, Local0)
                                    }

                                    If (UPBS ())
                                    {
                                        Or (0x02, Local0, Local0)
                                    }
                                }
                            }
                            Else
                            {
                                Store ("CMBatt - BAT1 connected", Debug)
                                \_SB.PCI0.ISA.EC0.SMWR (0x08, 0x14, 0x01, Local2)
                                \_SB.PCI0.ISA.EC0.SMRD (0x09, 0x14, 0x01, RefOf (Local3))
                                If (LEqual (Local2, Or (Local3, 0x0FFF)))
                                {
                                    UPBI ()
                                    UPBS ()
                                }

                                Store (0x01, BP)
                                Or (0x05, Local0, Local0)
                            }
                        }
                        Else
                        {
                            If (BP)
                            {
                                Store ("CMBatt - BAT1 disconnected", Debug)
                                Store (0x00, BP)
                                IVBI ()
                                IVBS ()
                                Or (0x04, Local0, Local0)
                            }
                        }

                        If (LAnd (And (Arg0, Local1), LNotEqual (UBIF, 0x1FFF)))
                        {
                            Store (0x01, REPT)
                        }
                        Else
                        {
                            Store (0x00, REPT)
                        }

                        Return (Local0)
                    }
                }

                Device (BAT2)
                {
                    Name (_HID, EisaId ("PNP0C0A"))
                    Name (_UID, 0x02)
                    Name (_PCL, Package (0x01)
                    {
                        \_SB
                    })
                    Name (PBIF, Package (0x0D)
                    {
                        0x01, 
                        0x09C4, 
                        0x09C4, 
                        0x01, 
                        0x3840, 
                        0x012C, 
                        0xC8, 
                        0x20, 
                        0x20, 
                        "BAT2", 
                        " ", 
                        " ", 
                        " "
                    })
                    Name (PBST, Package (0x04)
                    {
                        0x00, 
                        0xFFFFFFFF, 
                        0xFFFFFFFF, 
                        0x3840
                    })
                    Name (UBIF, 0x01E9)
                    Name (BP, 0x00)
                    Name (REPT, 0x00)
                    Name (ERRC, 0x00)
                    Method (_PSW, 1, NotSerialized)
                    {
                        If (\_SB.PCI0.ISA.ECOK ())
                        {
                            If (Arg0)
                            {
                                Store (0x01, \_SB.PCI0.ISA.EC0.B2WE)
                            }
                            Else
                            {
                                Store (0x00, \_SB.PCI0.ISA.EC0.B2WE)
                            }
                        }
                    }

                    Name (_PRW, Package (0x02)
                    {
                        0x0A, 
                        0x03
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _STA.BAT2", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        If (BP)
                        {
                            Store (0x1F, Local1)
                        }
                        Else
                        {
                            Store (0x0F, Local1)
                        }

                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (Local1)
                    }

                    Method (_BIF, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _BIF.BAT2", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (PBIF)
                    }

                    Method (_BST, 0, NotSerialized)
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT1, 0xFFFF)
                        Store ("CMBatt - _BST.BAT2", Debug)
                        \_SB.PCI0.ISA.EC0.CPOL ()
                        Release (\_SB.PCI0.ISA.EC0.MUT1)
                        Return (PBST)
                    }

                    Method (B2CK, 0, NotSerialized)
                    {
                        Store ("CMBatt - Notify(BAT2,0x81): B2CK", Debug)
                        Notify (\_SB.PCI0.ISA.BAT2, 0x81)
                    }

                    Method (B2ST, 0, NotSerialized)
                    {
                        Store ("CMBatt - Notify(BAT2,0x80): B2ST", Debug)
                        Notify (\_SB.PCI0.ISA.BAT2, 0x80)
                    }

                    Method (B2IF, 0, NotSerialized)
                    {
                        Store ("CMBatt - Notify(BAT2,0x81): B2IF", Debug)
                        Notify (\_SB.PCI0.ISA.BAT2, 0x81)
                    }

                    Method (UPBI, 0, NotSerialized)
                    {
                        Store ("CMBatt - UPBI.BAT2", Debug)
                        Store (Zero, Local0)
                        If (LNot (ECOK ()))
                        {
                            Return (Local0)
                        }

                        Store (0x0C, Local1)
                        Store (Buffer (0x0D)
                            {
                                /* 0000 */    0x00, 0x18, 0x10, 0x00, 0x19, 0x00, 0x00, 0x00, 
                                /* 0008 */    0x00, 0x21, 0x00, 0x22, 0x20
                            }, Local2)
                        While (LGreater (Local1, 0x08))
                        {
                            If (LNot (And (UBIF, VTOB (Local1))))
                            {
                                GBFE (Local2, Local1, RefOf (Local3))
                                If (Local3)
                                {
                                    If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x0B, 0x16, Local3, RefOf (Local4))))
                                    {
                                        Store (\_SB.PCI0.ISA.EC0.BCNT, Local5)
                                        Store (Zero, Local3)
                                        Store (Zero, ERRC)
                                        While (LGreater (Local5, Local3))
                                        {
                                            GBFE (Local4, Local3, RefOf (Local6))
                                            Increment (Local3)
                                            If (And (Local6, 0x80))
                                            {
                                                Increment (ERRC)
                                            }
                                        }

                                        If (LEqual (ERRC, 0x00))
                                        {
                                            Store (Local4, Index (PBIF, Local1))
                                            Or (UBIF, VTOB (Local1), UBIF)
                                            Store (Ones, Local0)
                                        }
                                    }
                                }
                            }

                            Decrement (Local1)
                        }

                        While (LGreater (Local1, 0x00))
                        {
                            If (LNot (And (UBIF, VTOB (Local1))))
                            {
                                GBFE (Local2, Local1, RefOf (Local3))
                                If (Local3)
                                {
                                    If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0x16, Local3, RefOf (Local5))))
                                    {
                                        If (LAnd (Local5, LNot (And (Local5, 0x8000))))
                                        {
                                            Store (Local5, Index (PBIF, Local1))
                                            Or (UBIF, VTOB (Local1), UBIF)
                                            Store (Ones, Local0)
                                        }
                                    }
                                }
                            }

                            Decrement (Local1)
                        }

                        Store (0x0A, Local1)
                        If (LNot (And (UBIF, VTOB (Local1))))
                        {
                            If (LNot (\_SB.PCI0.ISA.EC0.SMRD (0x09, 0x16, 0x1C, RefOf (Local5))))
                            {
                                Store (ITOS (ToBCD (Local5)), Index (PBIF, Local1))
                                Or (UBIF, VTOB (Local1), UBIF)
                                Store (Ones, Local0)
                            }
                        }

                        Store (PBIF, Debug)
                        Return (Local0)
                    }

                    Method (UPBS, 0, NotSerialized)
                    {
                        Store ("CMBatt - UPBS.BAT2", Debug)
                        Store (Zero, Local0)
                        If (LNot (ECOK ()))
                        {
                            Return (Local0)
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT2S, Local5)
                        Store (Local5, Local1)
                        And (Local5, 0x07, Local5)
                        If (LNotEqual (Local5, DerefOf (Index (PBST, 0x00))))
                        {
                            Store ("CMBatt - BAT2 STATE CHANGE", Debug)
                            Store (Local1, Debug)
                            Store (Local5, Index (PBST, 0x00))
                            Store (Ones, Local0)
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT2I, Local5)
                        If (And (Local1, 0x01))
                        {
                            If (And (Local5, 0x8000))
                            {
                                Or (Local5, 0xFFFF0000, Local5)
                                Add (Not (Local5), 0x01, Local5)
                                If (LGreater (0x0398, Local5))
                                {
                                    Store (0x0398, Local5)
                                }
                            }
                            Else
                            {
                                Store (0x0398, Local5)
                            }
                        }

                        If (And (Local1, 0x02))
                        {
                            If (And (Local5, 0x8000))
                            {
                                Store (0x00, Local5)
                            }

                            If (LGreater (0x64, Local5))
                            {
                                Store (0x64, Local5)
                            }
                        }

                        If (LEqual (And (Local1, 0x03), 0x00))
                        {
                            Store (0x00, Local5)
                        }

                        ShiftRight (Local5, 0x05, Local5)
                        ShiftLeft (Local5, 0x05, Local5)
                        If (LNotEqual (Local5, DerefOf (Index (PBST, 0x01))))
                        {
                            Store (Local5, Index (PBST, 0x01))
                            Store (Ones, Local0)
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT2C, Local5)
                        If (LNot (And (Local5, 0x8000)))
                        {
                            ShiftRight (Local5, 0x05, Local5)
                            ShiftLeft (Local5, 0x05, Local5)
                            If (LNotEqual (Local5, DerefOf (Index (PBST, 0x02))))
                            {
                                Store (Local5, Index (PBST, 0x02))
                                Store (Ones, Local0)
                            }
                        }

                        Store (\_SB.PCI0.ISA.EC0.BT2V, Local5)
                        If (LNot (And (Local5, 0x8000)))
                        {
                            ShiftRight (Local5, 0x05, Local5)
                            ShiftLeft (Local5, 0x05, Local5)
                            If (LNotEqual (Local5, DerefOf (Index (PBST, 0x03))))
                            {
                                Store (Local5, Index (PBST, 0x03))
                                Store (Ones, Local0)
                            }
                        }

                        If (Local0)
                        {
                            Store ("CMBATT - PBST Changed", Debug)
                        }

                        Store (PBST, Debug)
                        Return (Local0)
                    }

                    Method (IVBI, 0, NotSerialized)
                    {
                        Store (0x01E9, UBIF)
                        Store (0x09C4, Index (PBIF, 0x01))
                        Store (0x09C4, Index (PBIF, 0x02))
                        Store (0x3840, Index (PBIF, 0x04))
                        Store ("Bad", Index (PBIF, 0x09))
                        Store ("Bad", Index (PBIF, 0x0A))
                        Store ("Bad", Index (PBIF, 0x0B))
                        Store ("Bad", Index (PBIF, 0x0C))
                    }

                    Method (IVBS, 0, NotSerialized)
                    {
                        Store (0x00, Index (PBST, 0x00))
                        Store (0xFFFFFFFF, Index (PBST, 0x01))
                        Store (0xFFFFFFFF, Index (PBST, 0x02))
                        Store (0x3840, Index (PBST, 0x03))
                    }

                    Method (CHBP, 1, NotSerialized)
                    {
                        Store ("CMBatt - CHBP.BAT2", Debug)
                        Store (Zero, Local0)
                        If (LNot (ECOK ()))
                        {
                            Return (Local0)
                        }

                        Store (VTOB (Subtract (_UID, 0x01)), Local1)
                        Or (ShiftLeft (Local1, 0x0C), 0x0FFF, Local2)
                        Store (Zero, Local3)
                        If (And (Arg0, Local1))
                        {
                            If (BP)
                            {
                                Store ("CMBatt - BAT2 still present", Debug)
                                \_SB.PCI0.ISA.EC0.SMWR (0x08, 0x14, 0x01, Local2)
                                \_SB.PCI0.ISA.EC0.SMRD (0x09, 0x14, 0x01, RefOf (Local3))
                                If (LEqual (Local2, Or (Local3, 0x0FFF)))
                                {
                                    If (UPBI ())
                                    {
                                        Or (0x01, Local0, Local0)
                                    }

                                    If (UPBS ())
                                    {
                                        Or (0x02, Local0, Local0)
                                    }
                                }
                            }
                            Else
                            {
                                Store ("CMBatt - BAT2 connected", Debug)
                                \_SB.PCI0.ISA.EC0.SMWR (0x08, 0x14, 0x01, Local2)
                                \_SB.PCI0.ISA.EC0.SMRD (0x09, 0x14, 0x01, RefOf (Local3))
                                If (LEqual (Local2, Or (Local3, 0x0FFF)))
                                {
                                    UPBI ()
                                    UPBS ()
                                }

                                Store (0x01, BP)
                                Or (0x05, Local0, Local0)
                            }
                        }
                        Else
                        {
                            If (BP)
                            {
                                Store ("CMBatt - BAT2 disconnected", Debug)
                                Store (0x00, BP)
                                IVBI ()
                                IVBS ()
                                Or (0x04, Local0, Local0)
                            }
                        }

                        If (LAnd (And (Arg0, Local1), LNotEqual (UBIF, 0x1FFF)))
                        {
                            Store (0x01, REPT)
                        }
                        Else
                        {
                            Store (0x00, REPT)
                        }

                        Return (Local0)
                    }
                }

                Device (SPR)
                {
                    Name (_HID, EisaId ("PNP0C15"))
                    Method (_UID, 0, NotSerialized)
                    {
                        If (LNotEqual (\_SB.PCI0.ISA.DKTP, 0x00))
                        {
                            Return (\_SB.PCI0.ISA.DKSN)
                        }
                        Else
                        {
                            Return (Ones)
                        }
                    }

                    Method (_BDN, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x01))
                        {
                            Return (0x8022F022)
                        }

                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x02))
                        {
                            Return (0x8122F022)
                        }

                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                        {
                            Return (0x8222F022)
                        }

                        Return (Ones)
                    }

                    Event (EJVT)
                    Method (_INI, 0, NotSerialized)
                    {
                        If (LNotEqual (\_SB.PCI0.ISA.DKTP, 0x00))
                        {
                            Store (0x00, _PSC)
                        }
                        Else
                        {
                            Store (0x03, _PSC)
                        }
                    }

                    Name (_PSC, 0x03)
                    Method (_PS0, 0, NotSerialized)
                    {
                        Store (0x00, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }

                    Method (_EJ0, 1, NotSerialized)
                    {
                        Store (0x00, \_SB.PCI0.ISA.EC0.DCWT)
                        If (And (DCKF, 0x04))
                        {
                            And (DCKF, Not (0x04), DCKF)
                            Store (0x00, \_SB.PCI0.ISA.EC0.DPWR)
                            And (DCKF, Not (0x02), DCKF)
                            Store (0x00, \_SB.PCI0.ISA.DKTP)
                            \_SB.PCI0.AGP.VGA.DRUL (0x02)
                            HPSS (0x00)
                            Return (0x00)
                        }

                        Store (0x01, \_SB.PCI0.ISA.EC0.UDR0)
                        Or (DCKF, 0x02, DCKF)
                        Reset (EJVT)
                        Wait (EJVT, 0xFFFF)
                        Store (0x00, \_SB.PCI0.ISA.EC0.DPWR)
                        \_SB.PCI0.AGP.VGA.DRUL (0x02)
                    }

                    Name (EJX, 0x00)
                    Method (_EJ4, 1, NotSerialized)
                    {
                        Store (0x04, EJX)
                        Store (0x01, \_SB.PCI0.ISA.EC0.UDR5)
                    }

                    Method (_DCK, 1, NotSerialized)
                    {
                        If (Arg0)
                        {
                            Store (0x01, \_SB.PCI0.ISA.EC0.DPWR)
                            And (DCKF, Not (0x02), DCKF)
                            If (LEqual (\_SB.PCI0.ISA.DKTP, 0x01))
                            {
                                Store (0x00, \_SB.PCI0.ISA.EC0.DCWT)
                                Store (0x01, \_SB.PCI0.ISA.EC0.LDDS)
                                Store (0x01, Local1)
                            }
                            Else
                            {
                                Store (\_SB.PCI0.EPR.ENQB (), Local1)
                                If (Local1)
                                {
                                    If (LEqual (\_SB.PCI0.ISA.DKTP, 0x02))
                                    {
                                        Notify (\_SB.PCI0.EPR, 0x00)
                                    }
                                    Else
                                    {
                                        Notify (\_SB.PCI0.FDS, 0x00)
                                    }
                                }
                            }

                            \_SB.PCI0.AGP.VGA.DRUL (0x02)
                            Return (Local1)
                        }
                        Else
                        {
                            Store (0x00, \_SB.PCI0.ISA.EC0.EQBF)
                            Store (0x00, \_SB.PCI0.ISA.EC0.LDDS)
                            Store (0x01, \_SB.PCI0.ISA.EC0.DCWT)
                            Return (0x01)
                        }
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.ISA.ECOK ())
                        {
                            If (And (DCKF, 0x08))
                            {
                                And (DCKF, Not (0x08), DCKF)
                                \_SB.PCI0.ISA.EC0._Q05 ()
                                Return (0x0B)
                            }

                            If (LNotEqual (\_SB.PCI0.ISA.DKTP, 0x00))
                            {
                                Return (0x0B)
                            }
                            Else
                            {
                                Return (0x00)
                            }
                        }
                        Else
                        {
                            If (LNotEqual (\_SB.PCI0.ISA.DKTP, 0x00))
                            {
                                Return (0x0B)
                            }
                            Else
                            {
                                Return (0x00)
                            }
                        }
                    }
                }

                Device (HPCI)
                {
                    Name (_HID, EisaId ("HWPC209"))
                    Name (Z000, 0x00)
                    Method (STAT, 1, NotSerialized)
                    {
                        Store (Arg0, Z000)
                    }
                }
            }

            Device (IDE)
            {
                Name (_ADR, 0x00070001)
                OperationRegion (PCI, PCI_Config, 0x40, 0x04)
                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                            Offset (0x03), 
                        ,   7, 
                    SIDE,   1
                }

                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                    R40,    32
                }

                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                    ITM0,   16, 
                    ITM1,   16
                }

                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                            Offset (0x02), 
                    TSEC,   16
                }

                OperationRegion (PC2, PCI_Config, 0x20, 0x04)
                Field (PC2, DWordAcc, NoLock, Preserve)
                {
                    R20,    32
                }

                OperationRegion (PC3, PCI_Config, 0x04, 0x04)
                Field (PC3, DWordAcc, NoLock, Preserve)
                {
                    R04,    32
                }

                OperationRegion (REGS, PCI_Config, 0x44, 0x08)
                Field (REGS, DWordAcc, NoLock, Preserve)
                {
                    SIT0,   4, 
                    SIT1,   4, 
                            Offset (0x04), 
                    UDC0,   2, 
                    UDC1,   2, 
                            Offset (0x06), 
                    UDT0,   8, 
                    UDT1,   8
                }

                Name (BAYD, 0x00)
                Method (_INI, 0, NotSerialized)
                {
                    Store (0x03, \_SB.PCI0.IDE.SECN._PSC)
                    Store (0x01, \_SB.PCI0.IDE.SECN.MAST.STOP)
                    If (\_SB.PCI0.ISA.ECOK ())
                    {
                        If (\_SB.PCI0.ISA.EC0.SHDD)
                        {
                            Store (0x00, \_SB.PCI0.IDE.SECN._PSC)
                            Store (0x00, \_SB.PCI0.IDE.SECN.MAST.STOP)
                        }
                    }
                    Else
                    {
                        If (And (\_SB.PCI0.ISA.BDST, 0x04))
                        {
                            Store (0x00, \_SB.PCI0.IDE.SECN._PSC)
                            Store (0x00, \_SB.PCI0.IDE.SECN.MAST.STOP)
                        }
                    }
                }

                Method (_STA, 0, NotSerialized)
                {
                    Return (0x0F)
                }

                Name (GMBU, Buffer (0x14)
                {
                    /* 0000 */    0x00
                })
                Method (GTM, 4, NotSerialized)
                {
                    Store (Buffer (0x14) {}, Local0)
                    CreateDWordField (Local0, 0x00, PIO0)
                    CreateDWordField (Local0, 0x04, DMA0)
                    CreateDWordField (Local0, 0x08, PIO1)
                    CreateDWordField (Local0, 0x0C, DMA1)
                    CreateDWordField (Local0, 0x10, FLAG)
                    If (LOr (And (Arg0, 0x08), LNot (And (Arg0, 0x01
                        ))))
                    {
                        Store (0x0384, PIO0)
                    }
                    Else
                    {
                        Subtract (0x09, ShiftRight (And (Arg0, 0x0300), 0x08), Local1)
                        Subtract (Local1, ShiftRight (And (Arg0, 0x3000), 0x0C), Local1)
                        Multiply (Local1, 0x1E, PIO0)
                    }

                    If (And (Arg2, 0x01))
                    {
                        Subtract (0x04, And (Arg3, 0x03), Local1)
                        Multiply (Local1, 0x1E, DMA0)
                    }
                    Else
                    {
                        Subtract (0x09, ShiftRight (And (Arg0, 0x0300), 0x08), Local1)
                        Subtract (Local1, ShiftRight (And (Arg0, 0x3000), 0x0C), Local1)
                        Multiply (Local1, 0x1E, DMA0)
                    }

                    If (And (Arg0, 0x4000))
                    {
                        If (LOr (And (Arg0, 0x80), LNot (And (Arg0, 0x10
                            ))))
                        {
                            Store (0x0384, PIO1)
                        }
                        Else
                        {
                            Subtract (0x09, And (Arg1, 0x03), Local1)
                            Subtract (Local1, ShiftRight (And (Arg1, 0x0C), 0x02), Local1)
                            Multiply (Local1, 0x1E, PIO1)
                        }
                    }
                    Else
                    {
                        Store (PIO0, PIO1)
                    }

                    If (And (Arg0, 0x4000))
                    {
                        If (And (Arg2, 0x02))
                        {
                            Subtract (0x04, ShiftRight (And (Arg3, 0x30), 0x04), Local1)
                            Multiply (Local1, 0x1E, DMA1)
                        }
                        Else
                        {
                            Subtract (0x09, And (Arg1, 0x03), Local1)
                            Subtract (Local1, ShiftRight (And (Arg1, 0x0C), 0x02), Local1)
                            Multiply (Local1, 0x1E, DMA1)
                        }
                    }
                    Else
                    {
                        Store (DMA0, DMA1)
                    }

                    Store (0x10, FLAG)
                    If (And (Arg2, 0x01))
                    {
                        Or (FLAG, 0x01, FLAG)
                    }

                    If (And (Arg0, 0x02))
                    {
                        Or (FLAG, 0x02, FLAG)
                    }

                    If (And (Arg2, 0x02))
                    {
                        Or (FLAG, 0x04, FLAG)
                    }

                    If (And (Arg0, 0x20))
                    {
                        Or (FLAG, 0x08, FLAG)
                    }

                    Return (Local0)
                }

                Method (STMS, 1, NotSerialized)
                {
                    CreateDWordField (Arg0, 0x00, PIO0)
                    CreateDWordField (Arg0, 0x04, DMA0)
                    CreateDWordField (Arg0, 0x08, PIO1)
                    CreateDWordField (Arg0, 0x0C, DMA1)
                    CreateDWordField (Arg0, 0x10, FLAG)
                    Store (Buffer (0x10) {}, Local7)
                    CreateDWordField (Local7, 0x00, ITM)
                    CreateDWordField (Local7, 0x04, SIT)
                    CreateDWordField (Local7, 0x08, UDC)
                    CreateDWordField (Local7, 0x0C, UDT)
                    Store (Or (Or (0x4000, 0x04), 0x40), Local0)
                    If (And (FLAG, 0x02))
                    {
                        Or (Local0, 0x02, Local0)
                    }

                    If (And (FLAG, 0x08))
                    {
                        Or (Local0, 0x20, Local0)
                    }

                    If (LLess (DMA0, PIO0))
                    {
                        Or (Local0, 0x08, Local0)
                    }

                    If (LLess (DMA1, PIO1))
                    {
                        Or (Local0, 0x80, Local0)
                    }

                    If (LLess (PIO0, 0x0384))
                    {
                        Or (Local0, 0x01, Local0)
                    }

                    If (LLess (PIO1, 0x0384))
                    {
                        Or (Local0, 0x10, Local0)
                    }

                    If (And (FLAG, 0x01))
                    {
                        Store (PIO0, Local1)
                    }
                    Else
                    {
                        Store (DMA0, Local1)
                    }

                    If (LLessEqual (Local1, 0x78))
                    {
                        Or (Local0, 0x2300, Local0)
                    }
                    Else
                    {
                        If (LLessEqual (Local1, 0xB4))
                        {
                            Or (Local0, 0x2100, Local0)
                        }
                        Else
                        {
                            If (LLessEqual (Local1, 0xF0))
                            {
                                Or (Local0, 0x1000, Local0)
                            }
                        }
                    }

                    Store (Local0, ITM)
                    Store (Zero, Local0)
                    If (And (FLAG, 0x04))
                    {
                        Store (PIO1, Local1)
                    }
                    Else
                    {
                        Store (DMA1, Local1)
                    }

                    If (LLessEqual (Local1, 0x78))
                    {
                        Store (0x0B, Local0)
                    }
                    Else
                    {
                        If (LLessEqual (Local1, 0xB4))
                        {
                            Store (0x09, Local0)
                        }
                        Else
                        {
                            If (LLessEqual (Local1, 0xF0))
                            {
                                Store (0x04, Local0)
                            }
                        }
                    }

                    Store (Local0, SIT)
                    Store (0x00, Local0)
                    If (And (FLAG, 0x01))
                    {
                        Or (Local0, 0x01, Local0)
                    }

                    If (And (FLAG, 0x04))
                    {
                        Or (Local0, 0x02, Local0)
                    }

                    Store (Local0, UDC)
                    Store (0x00, Local0)
                    If (And (FLAG, 0x01))
                    {
                        Divide (DMA0, 0x1E, Local1)
                        And (Local1, 0x03, Local1)
                        Subtract (0x04, Local1, Local0)
                    }

                    If (And (FLAG, 0x04))
                    {
                        Divide (DMA1, 0x1E, Local1)
                        And (Local1, 0x03, Local1)
                        Subtract (0x04, Local1, Local1)
                        ShiftLeft (Local1, 0x04, Local1)
                        Or (Local0, Local1, Local0)
                    }

                    Store (Local0, UDT)
                    Return (Local7)
                }

                Method (H15P, 1, NotSerialized)
                {
                    Concatenate (Arg0, Buffer (0x08)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        }, Local7)
                    CreateWordField (Local7, 0x02, CYL)
                    CreateWordField (Local7, 0x06, HEAD)
                    CreateWordField (Local7, 0x0C, SPT)
                    If (LAnd (LGreaterEqual (HEAD, 0x10), LGreaterEqual (CYL, 0x2000)))
                    {
                        Return (SPT)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                Method (GTF0, 5, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        }, Local6)
                    Store (Buffer (0x07)
                        {
                            /* 0000 */    0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                        }, Local7)
                    CreateByteField (Local7, 0x01, MODE)
                    If (And (Arg2, 0x01))
                    {
                        And (Arg3, 0x03, Local0)
                        Or (Local0, 0x40, MODE)
                    }
                    Else
                    {
                        Add (ShiftRight (And (Arg0, 0x0300), 0x08), ShiftRight (And (
                            Arg0, 0x3000), 0x0C), Local0)
                        If (LGreaterEqual (Local0, 0x05))
                        {
                            Store (0x22, MODE)
                        }
                        Else
                        {
                            If (LGreaterEqual (Local0, 0x03))
                            {
                                Store (0x21, MODE)
                            }
                            Else
                            {
                                Store (0x20, MODE)
                            }
                        }
                    }

                    Concatenate (Local7, Local7, Local6)
                    Store (Zero, MODE)
                    If (LOr (And (Arg0, 0x08), LNot (And (Arg0, 0x01
                        ))))
                    {
                        If (And (Arg0, 0x02))
                        {
                            Store (0x00, MODE)
                        }
                        Else
                        {
                            Store (0x01, MODE)
                        }
                    }
                    Else
                    {
                        Add (ShiftRight (And (Arg0, 0x0300), 0x08), ShiftRight (And (
                            Arg0, 0x3000), 0x0C), Local0)
                        If (LGreaterEqual (Local0, 0x05))
                        {
                            Store (0x0C, MODE)
                        }
                        Else
                        {
                            If (LGreaterEqual (Local0, 0x03))
                            {
                                Store (0x0B, MODE)
                            }
                            Else
                            {
                                Store (0x0A, MODE)
                            }
                        }
                    }

                    Concatenate (Local6, Local7, Local5)
                    If (Arg4)
                    {
                        Store (Buffer (0x07)
                            {
                                /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0xAE, 0x91
                            }, Local4)
                        CreateByteField (Local4, 0x01, SPT)
                        Store (Arg4, SPT)
                        Concatenate (Local5, Local4, Local6)
                        Return (Local6)
                    }
                    Else
                    {
                        Return (Local5)
                    }
                }

                Name (B04, Buffer (0x04) {})
                Name (B20, Buffer (0x04) {})
                Name (B40, Buffer (0x04) {})
                Device (PRIM)
                {
                    Name (_ADR, 0x00)
                    Name (_PSC, 0x00)
                    Method (_PS0, 0, NotSerialized)
                    {
                        Store (0x00, \_SB.PCI0.PX43.HDPW)
                        If (_PSC)
                        {
                            \_SB.PCI0.ISA.HPSS (0x0B)
                        }

                        Store (0x00, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x01, \_SB.PCI0.PX43.HDPW)
                        Store (0x03, _PSC)
                    }

                    Method (_GTM, 0, NotSerialized)
                    {
                        Store (Buffer (0x14)
                            {
                                /* 0000 */    0x00
                            }, Local0)
                        Store (^^GTM (^^ITM0, ^^SIT0, ^^UDC0, ^^UDT0), Local0)
                        Return (Local0)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (^^STMS (Arg0), Local0)
                        CreateWordField (Local0, 0x00, ITM)
                        CreateWordField (Local0, 0x04, SIT)
                        CreateWordField (Local0, 0x08, UDC)
                        CreateWordField (Local0, 0x0C, UDT)
                        And (ITM0, 0x8000, Local1)
                        Or (ITM, Local1, ITM0)
                        Store (SIT, SIT0)
                        Store (UDC, UDC0)
                        Store (UDT, UDT0)
                        Store (^^H15P (Arg1), ^MAST.H15F)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)
                        Name (H15F, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (^^^GTF0 (^^^ITM0, ^^^SIT0, ^^^UDC0, ^^^UDT0, ^H15F))
                        }
                    }
                }

                Device (SECN)
                {
                    Name (_ADR, 0x01)
                    Method (_STA, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.ISA.ECOK ())
                        {
                            If (LEqual (\_SB.PCI0.ISA.EC0.SHDD, 0x00))
                            {
                                Store (0x8000, \_SB.PCI0.IDE.TSEC)
                                Return (0x0D)
                            }
                        }
                        Else
                        {
                            If (LNot (And (\_SB.PCI0.ISA.BDST, 0x04)))
                            {
                                Store (0x8000, \_SB.PCI0.IDE.TSEC)
                                Return (0x0D)
                            }
                        }

                        If (_PSC)
                        {
                            Return (0x0D)
                        }
                        Else
                        {
                            If (LEqual (\_SB.PCI0.IDE.TSEC, 0x8000))
                            {
                                Return (0x0D)
                            }
                            Else
                            {
                                Return (0x0F)
                            }
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        If (LAnd (LNot (^PIDE._STA ()), ^MAST._STA ()))
                        {
                            ^PIDE._ON ()
                        }

                        Store (0x00, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }

                    Name (_PSC, 0x00)
                    PowerResource (PIDE, 0x03, 0x0000)
                    {
                        Method (_STA, 0, NotSerialized)
                        {
                            Return (XOr (\_SB.PCI0.PX43.SDPW, 0x01))
                        }

                        Method (_ON, 0, NotSerialized)
                        {
                            If (\_SB.PCI0.PX43.SDPW)
                            {
                                Store (0x01, \_SB.PCI0.ISA.TRIS)
                                Store (0x00, \_SB.PCI0.PX43.SDPW)
                                If (\_SB.PCI0.ISA.EC0.SHDD)
                                {
                                    Store (0x01, \_SB.PCI0.PX43.SRST)
                                    Sleep (0x64)
                                    Store (0x00, \_SB.PCI0.PX43.SRST)
                                    Sleep (0xC8)
                                }

                                Store (0x00, \_SB.PCI0.ISA.TRIS)
                            }
                        }

                        Method (_OFF, 0, NotSerialized)
                        {
                            Store (0x01, \_SB.PCI0.ISA.TRIS)
                            Store (0x01, \_SB.PCI0.PX43.SDPW)
                            Store (0x8000, \_SB.PCI0.IDE.TSEC)
                        }
                    }

                    Method (_GTM, 0, NotSerialized)
                    {
                        Store (Buffer (0x14)
                            {
                                /* 0000 */    0x00
                            }, Local0)
                        Store (^^GTM (^^ITM1, ^^SIT1, ^^UDC1, ^^UDT1), Local0)
                        If (\_SB.PCI0.ISA.ECOK ())
                        {
                            If (Or (LEqual (\_SB.PCI0.ISA.EC0.KBID, 0x0A), LEqual (\_SB.PCI0.ISA.EC0.KBID, 0xA0)))
                            {
                                CreateDWordField (Local0, 0x04, DMA0)
                                CreateDWordField (Local0, 0x0C, DMA1)
                                CreateDWordField (Local0, 0x10, FLAG)
                                Store (0xFFFFFFFF, DMA0)
                                Store (0xFFFFFFFF, DMA1)
                                And (FLAG, 0xFFFFFFFA, FLAG)
                            }
                        }

                        Return (Local0)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        If (\_SB.PCI0.ISA.ECOK ())
                        {
                            If (Or (LEqual (\_SB.PCI0.ISA.EC0.KBID, 0x0A), LEqual (\_SB.PCI0.ISA.EC0.KBID, 0xA0)))
                            {
                                CreateDWordField (Arg0, 0x04, DMA0)
                                CreateDWordField (Arg0, 0x0C, DMA1)
                                CreateDWordField (Arg0, 0x10, FLAG)
                                Store (0xFFFFFFFF, DMA0)
                                Store (0xFFFFFFFF, DMA1)
                                And (FLAG, 0xFFFFFFFA, FLAG)
                            }
                        }

                        Store (^^STMS (Arg0), Local0)
                        CreateWordField (Local0, 0x00, ITM)
                        CreateWordField (Local0, 0x04, SIT)
                        CreateWordField (Local0, 0x08, UDC)
                        CreateWordField (Local0, 0x0C, UDT)
                        And (ITM1, 0x8000, Local1)
                        Or (ITM, Local1, ITM1)
                        Store (SIT, SIT1)
                        Store (UDC, UDC1)
                        Store (UDT, UDT1)
                        Store (^^H15P (Arg1), ^MAST.H15F)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)
                        Name (STOP, 0x00)
                        Name (H15F, Zero)
                        Method (_STA, 0, NotSerialized)
                        {
                            If (\_SB.PCI0.ISA.ECOK ())
                            {
                                If (LEqual (\_SB.PCI0.ISA.EC0.SHDD, 0x00))
                                {
                                    Return (0x00)
                                }
                            }
                            Else
                            {
                                If (LNot (And (\_SB.PCI0.ISA.BDST, 0x04)))
                                {
                                    Return (0x00)
                                }
                            }

                            If (LNot (STOP))
                            {
                                If (LEqual (\_SB.PCI0.IDE.TSEC, 0x8000))
                                {
                                    Return (0x0D)
                                }
                                Else
                                {
                                    Return (0x0F)
                                }
                            }
                            Else
                            {
                                Store (0x8000, \_SB.PCI0.IDE.TSEC)
                                Return (0x0D)
                            }
                        }

                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (^^^GTF0 (^^^ITM1, ^^^SIT1, ^^^UDC1, ^^^UDT1, ^H15F))
                        }

                        Method (_EJ0, 1, NotSerialized)
                        {
                            Store (0x8000, \_SB.PCI0.IDE.TSEC)
                            Store (0x01, STOP)
                        }

                        Name (_PR0, Package (0x01)
                        {
                            PIDE
                        })
                    }
                }

                Name (PSX, 0x00)
                Method (_PS0, 0, NotSerialized)
                {
                    Store (0x00, _PSC)
                    If (And (\_SB.PCI0.ISA.EC0.PQ06, 0x04))
                    {
                        And (\_SB.PCI0.ISA.EC0.PQ06, Not (0x04), \_SB.PCI0.ISA.EC0.PQ06)
                        Notify (\_SB.PCI0.IDE, 0x00)
                    }

                    If (And (\_SB.PCI0.ISA.EC0.PQ06, 0x02))
                    {
                        Acquire (\_SB.PCI0.ISA.EC0.MUT2, 0xFFFF)
                        \_SB.PCI0.ISA.EC0.SWAP ()
                        Release (\_SB.PCI0.ISA.EC0.MUT2)
                        And (\_SB.PCI0.ISA.EC0.PQ06, Not (0x02), \_SB.PCI0.ISA.EC0.PQ06)
                    }
                }

                Method (_PS3, 0, NotSerialized)
                {
                    Store (0x03, _PSC)
                }

                Name (_PSC, 0x00)
            }

            Device (CB1)
            {
                Name (_ADR, 0x00040000)
                OperationRegion (CBE0, PCI_Config, 0x3E, 0x02)
                Field (CBE0, WordAcc, NoLock, Preserve)
                {
                    CBX0,   16
                }

                Method (_INI, 0, NotSerialized)
                {
                    Store (0x0340, CBX0)
                }

                Method (_STA, 0, NotSerialized)
                {
                    Return (0x0F)
                }
            }

            Device (CB2)
            {
                Name (_ADR, 0x00040001)
                OperationRegion (CBE1, PCI_Config, 0x3E, 0x02)
                Field (CBE1, WordAcc, NoLock, Preserve)
                {
                    CBX1,   16
                }

                Method (_INI, 0, NotSerialized)
                {
                    Store (0x0340, CBX1)
                }

                Method (_STA, 0, NotSerialized)
                {
                    Return (0x0F)
                }
            }

            Device (FDS)
            {
                Name (_ADR, 0x00110000)
                OperationRegion (MOON, PCI_Config, 0x41, 0x05)
                Field (MOON, ByteAcc, NoLock, Preserve)
                {
                    CEVN,   8, 
                            Offset (0x04), 
                    WRPE,   8
                }

                Name (FDOK, 0x00)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        If (LEqual (Arg1, 0x01))
                        {
                            Store (0x01, FDOK)
                            \_SB.PCI0.ISA.HPSS (0x0E)
                            \_SB.PCI0.FDS.FCB1.CSID ()
                        }
                        Else
                        {
                            Store (0x00, FDOK)
                        }
                    }
                }

                Name (_PSC, 0x03)
                Method (_INI, 0, NotSerialized)
                {
                    If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                    {
                        Store (0x00, _PSC)
                        Store (0x00, \_SB.PCI0.FDS.FIDE._PSC)
                        Store (0x00, \_SB.PCI0.FDS.FCB1._PSC)
                        Store (0x00, \_SB.PCI0.FDS.FCB2._PSC)
                        Store (0x00, \_SB.PCI0.FDS.SCSI._PSC)
                    }
                    Else
                    {
                        Store (0x03, _PSC)
                    }
                }

                Method (_PS0, 0, NotSerialized)
                {
                    If (LEqual (\_SB.PCI0.FDS.FIDE._PSC, 0x03))
                    {
                        If (LNot (\_SB.PCI0.OSNT))
                        {
                            \_SB.PCI0.FDS.FIDE._PS0 ()
                            Notify (\_SB.PCI0.FDS.FIDE, 0x00)
                        }
                    }

                    Store (0x02, WRPE)
                    Store (0x00, _PSC)
                }

                Method (_PS3, 0, NotSerialized)
                {
                    Store (0x03, _PSC)
                }

                Name (_EJD, "_SB_.PCI0.ISA_.SPR_")
                Method (_STA, 0, NotSerialized)
                {
                    If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Device (FCB1)
                {
                    Name (_ADR, 0x00080000)
                    OperationRegion (CBE4, PCI_Config, 0x00, 0x44)
                    Field (CBE4, WordAcc, NoLock, Preserve)
                    {
                                Offset (0x02), 
                        CBID,   16, 
                                Offset (0x3E), 
                        CBX4,   16, 
                        VDID,   16, 
                        SBID,   16
                    }

                    OperationRegion (C4IN, PCI_Config, 0x80, 0x14)
                    Field (C4IN, ByteAcc, NoLock, Preserve)
                    {
                        CR80,   5, 
                        SBRW,   1, 
                        CR81,   2, 
                                Offset (0x03), 
                        CR83,   8, 
                                Offset (0x0C), 
                        CR8C,   8, 
                        CR8D,   8, 
                        CR8E,   8, 
                        CR8F,   8, 
                                Offset (0x13), 
                        CR93,   8
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (^^_STA ())
                    }

                    Name (_PSC, 0x03)
                    Method (_INI, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                        {
                            Store (0x00, _PSC)
                        }
                        Else
                        {
                            Store (0x03, _PSC)
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        Store (0x08, CR83)
                        Store (0x02, CR8C)
                        Store (0x1C, CR8D)
                        Store (0x02, CR8E)
                        Store (0x01, CR8F)
                        If (LEqual (CBID, 0xAC1C))
                        {
                            Store (0x41, CR93)
                        }

                        Store (0x00, _PSC)
                    }

                    Method (CSID, 0, NotSerialized)
                    {
                        Store (0x00, SBRW)
                        Store (0x103C, VDID)
                        Store (0x05, SBID)
                        Store (0x01, SBRW)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }
                }

                Device (FCB2)
                {
                    Name (_ADR, 0x00080001)
                    OperationRegion (CBE5, PCI_Config, 0x3E, 0x02)
                    Field (CBE5, WordAcc, NoLock, Preserve)
                    {
                        CBX5,   16
                    }

                    OperationRegion (CB5I, PCI_Config, 0x93, 0x01)
                    Field (CB5I, ByteAcc, NoLock, Preserve)
                    {
                        CR93,   8
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (^^_STA ())
                    }

                    Name (_PSC, 0x03)
                    Method (_INI, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                        {
                            Store (0x00, _PSC)
                        }
                        Else
                        {
                            Store (0x03, _PSC)
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        If (LEqual (^^FCB1.CBID, 0xAC1C))
                        {
                            Store (0x41, CR93)
                        }

                        Store (0x00, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }
                }

                Device (FIDE)
                {
                    Name (_ADR, 0x000C0000)
                    OperationRegion (FIDR, PCI_Config, 0x00, 0x80)
                    Field (FIDR, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x07), 
                        R7X1,   7, 
                        R7B7,   1, 
                                Offset (0x0D), 
                        RDX2,   5, 
                        RDB5,   1, 
                        RDX1,   2, 
                                Offset (0x10), 
                        RR10,   8, 
                        RR11,   8, 
                                Offset (0x14), 
                        RR14,   8, 
                        RR15,   8, 
                                Offset (0x18), 
                        RR18,   8, 
                        RR19,   8, 
                                Offset (0x1C), 
                        RR1C,   8, 
                        RR1D,   8, 
                                Offset (0x20), 
                        RR20,   8, 
                        RR21,   8, 
                        RR22,   8, 
                        RR23,   8, 
                                Offset (0x2C), 
                        RR2C,   8, 
                        RR2D,   8, 
                        RR2E,   8, 
                        RR2F,   8, 
                                Offset (0x3C), 
                        RR3C,   8, 
                                Offset (0x4F), 
                        R4F1,   1, 
                        R4FX,   7, 
                                Offset (0x51), 
                        RR51,   8, 
                        RR52,   8, 
                        RR53,   8, 
                        RR54,   8, 
                        RR55,   8, 
                        RR56,   8, 
                        RR57,   8, 
                        RR58,   8, 
                                Offset (0x72), 
                        RR72,   8, 
                        RR73,   8, 
                        RR74,   8, 
                        RR75,   8, 
                        RR76,   8, 
                        RR77,   8, 
                                Offset (0x7A), 
                        RR7A,   8, 
                        RR7B,   8, 
                        RR7C,   8, 
                        RR7D,   8, 
                        RR7E,   8, 
                        RR7F,   8
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (^^_STA ())
                    }

                    Name (_PSC, 0x03)
                    Method (_INI, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                        {
                            Store (0x00, _PSC)
                        }
                        Else
                        {
                            Store (0x03, _PSC)
                        }
                    }

                    Method (DGTM, 3, NotSerialized)
                    {
                        Store (Buffer (0x14)
                            {
                                /* 0000 */    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
                                /* 0008 */    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
                                /* 0010 */    0x00, 0x00, 0x00, 0x00
                            }, Local0)
                        CreateDWordField (Local0, 0x00, PIO0)
                        CreateDWordField (Local0, 0x04, DMA0)
                        CreateDWordField (Local0, 0x08, PIO1)
                        CreateDWordField (Local0, 0x0C, DMA1)
                        CreateDWordField (Local0, 0x10, FLAG)
                        Store (0x10, FLAG)
                        If (LEqual (RR52, 0x3F))
                        {
                            Store (0x78, PIO0)
                        }
                        Else
                        {
                            If (LEqual (RR52, 0x32))
                            {
                                Store (0xB4, PIO0)
                            }
                            Else
                            {
                                If (LEqual (RR52, 0xA2))
                                {
                                    Store (0xF0, PIO0)
                                }
                                Else
                                {
                                    If (LEqual (RR52, 0xA3))
                                    {
                                        Store (0x017F, PIO0)
                                    }
                                    Else
                                    {
                                        Store (0x0258, PIO0)
                                    }
                                }
                            }
                        }

                        Or (FLAG, 0x02, FLAG)
                        Return (Local0)
                    }

                    Method (DSTM, 7, NotSerialized)
                    {
                        CreateDWordField (Arg0, 0x00, PIO0)
                        CreateDWordField (Arg0, 0x04, DMA0)
                        CreateDWordField (Arg0, 0x08, PIO1)
                        CreateDWordField (Arg0, 0x0C, DMA1)
                        CreateDWordField (Arg0, 0x10, FLAG)
                        Store (Buffer (0x05) {}, Local7)
                        CreateByteField (Local7, 0x00, TMP1)
                        CreateByteField (Local7, 0x01, TMP2)
                        CreateByteField (Local7, 0x02, TMP3)
                        CreateByteField (Local7, 0x03, TMP4)
                        CreateByteField (Local7, 0x04, TMP5)
                        Store (Arg1, TMP1)
                        Store (Arg2, TMP2)
                        Store (Arg3, TMP3)
                        Store (Arg4, TMP4)
                        Store (Arg5, TMP5)
                        And (TMP2, 0xDF, TMP2)
                        If (Not (LOr (And (FLAG, 0x01), Arg6)))
                        {
                            And (TMP2, 0xDF, TMP2)
                            If (LLessEqual (PIO0, 0x78))
                            {
                                Store (0x3F, RR52)
                                Store (0x3F, TMP1)
                                And (TMP4, 0x3F, TMP4)
                                Or (TMP4, 0x40, TMP4)
                                And (TMP5, 0x3F, TMP5)
                                Or (TMP5, 0x40, TMP5)
                            }
                            Else
                            {
                                If (LLessEqual (PIO0, 0xB4))
                                {
                                    Store (0x32, RR52)
                                    Store (0x32, TMP1)
                                    And (TMP4, 0x3F, TMP4)
                                    Or (TMP4, 0x40, TMP4)
                                    And (TMP5, 0x3F, TMP5)
                                    Or (TMP5, 0x40, TMP5)
                                }
                                Else
                                {
                                    If (LLessEqual (PIO0, 0xF0))
                                    {
                                        Store (0xA2, RR52)
                                        Store (0x43, TMP1)
                                        And (TMP4, 0x3F, TMP4)
                                        Or (TMP4, 0x40, TMP4)
                                        And (TMP5, 0x3F, TMP5)
                                        Or (TMP5, 0x40, TMP5)
                                    }
                                    Else
                                    {
                                        If (LLessEqual (PIO0, 0x017F))
                                        {
                                            Store (0xA3, RR52)
                                            Store (0x57, TMP1)
                                            And (TMP4, 0x3F, TMP4)
                                            Or (TMP4, 0x40, TMP4)
                                            And (TMP5, 0x3F, TMP5)
                                            Or (TMP5, 0x40, TMP5)
                                        }
                                        Else
                                        {
                                            Store (0xAF, RR52)
                                            Store (0x6D, TMP1)
                                            And (TMP4, 0x3F, TMP4)
                                            Or (TMP4, 0x80, TMP4)
                                            And (TMP5, 0x3F, TMP5)
                                            Or (TMP5, 0x80, TMP5)
                                        }
                                    }
                                }
                            }
                        }

                        Return (Local7)
                    }

                    Method (DGTF, 3, NotSerialized)
                    {
                        Store (Buffer (0x07)
                            {
                                /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                            }, Local6)
                        Store (Buffer (0x07)
                            {
                                /* 0000 */    0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                            }, Local7)
                        CreateByteField (Local7, 0x01, MODE)
                        If (LEqual (RR52, 0x3F))
                        {
                            Store (0x0C, MODE)
                        }
                        Else
                        {
                            If (LEqual (RR52, 0x32))
                            {
                                Store (0x0B, MODE)
                            }
                            Else
                            {
                                If (LEqual (RR52, 0xA2))
                                {
                                    Store (0x0A, MODE)
                                }
                                Else
                                {
                                    If (LEqual (RR52, 0xA3))
                                    {
                                        Store (0x09, MODE)
                                    }
                                    Else
                                    {
                                        Store (0x08, MODE)
                                    }
                                }
                            }
                        }

                        Return (Local7)
                    }

                    Device (PRIM)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTM, 0, NotSerialized)
                        {
                            Return (^^DGTM (RR54, RR72, RR73))
                        }

                        Method (_STM, 3, NotSerialized)
                        {
                            CreateWordField (Arg1, 0x7E, MDFL)
                            Store (MDFL, Local0)
                            Store (0x00, Local0)
                            Store (^^DSTM (Arg0, RR54, RR72, RR73, RR53, RR55, Local0), Local1)
                            CreateByteField (Local1, 0x00, TMP1)
                            CreateByteField (Local1, 0x01, TMP2)
                            CreateByteField (Local1, 0x02, TMP3)
                            CreateByteField (Local1, 0x03, TMP4)
                            CreateByteField (Local1, 0x04, TMP5)
                            Store (TMP1, RR54)
                            Store (TMP2, RR72)
                            Store (TMP3, RR73)
                            Store (TMP4, RR53)
                            Store (TMP5, RR55)
                        }

                        Device (MAST)
                        {
                            Name (_ADR, 0x00)
                            Method (_GTF, 0, NotSerialized)
                            {
                                Return (^^^DGTF (RR54, RR72, RR73))
                            }
                        }
                    }

                    Device (SECN)
                    {
                        Name (_ADR, 0x01)
                        Method (_GTM, 0, NotSerialized)
                        {
                            Return (^^DGTM (RR58, RR7A, RR7B))
                        }

                        Method (_STM, 3, NotSerialized)
                        {
                            CreateWordField (Arg1, 0x7E, MDFL)
                            Store (MDFL, Local0)
                            Store (0x00, Local0)
                            Store (^^DSTM (Arg0, RR58, RR7A, RR7B, RR57, RR57, Local0), Local1)
                            CreateByteField (Local1, 0x00, TMP1)
                            CreateByteField (Local1, 0x01, TMP2)
                            CreateByteField (Local1, 0x02, TMP3)
                            CreateByteField (Local1, 0x03, TMP4)
                            CreateByteField (Local1, 0x04, TMP5)
                            Store (TMP1, RR58)
                            Store (TMP2, RR7A)
                            Store (TMP3, RR7B)
                            Store (TMP4, RR57)
                        }

                        Device (MAST)
                        {
                            Name (_ADR, 0x00)
                            Method (_GTF, 0, NotSerialized)
                            {
                                Return (^^^DGTF (RR58, RR7A, RR7B))
                            }
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        If (LNot (RR54))
                        {
                            Store (0xAF, RR52)
                            And (RR53, 0x3F, RR53)
                            Or (RR53, 0x80, RR53)
                            Store (0x6D, RR54)
                            And (RR55, 0x3F, RR55)
                            Or (RR55, 0x80, RR55)
                            And (RR72, 0xDF, RR72)
                            And (RR57, 0x3F, RR57)
                            Or (RR57, 0x80, RR57)
                            Store (0x6D, RR58)
                            And (RR7A, 0xDF, RR7A)
                        }

                        If (_PSC)
                        {
                            Store (0x00, _PSC)
                            If (LNot (\_SB.PCI0.OSNT))
                            {
                                Store (0x01, R7B7)
                                Store (0x01, RDB5)
                                Store (0xF9, RR10)
                                Store (0x1C, RR11)
                                Store (0xF1, RR14)
                                Store (0x1C, RR15)
                                Store (0xE1, RR18)
                                Store (0x1C, RR19)
                                Store (0xD9, RR1C)
                                Store (0x1C, RR1D)
                                Store (0xC1, RR20)
                                Store (0x1C, RR21)
                                Store (0x00, RR22)
                                Store (0x00, RR23)
                                Store (0x0A, RR3C)
                                Store (0x01, R4F1)
                                Store (0x3C, RR2C)
                                Store (0x10, RR2D)
                                Store (0x05, RR2E)
                                Store (0x00, RR2F)
                                Store (0x00, R4F1)
                            }
                            Else
                            {
                                \_SB.PCI0.ISA.HPSS (0x0E)
                            }

                            Store (0xEC, RR51)
                            Store (0xA9, RR52)
                            Store (0x31, RR56)
                            Store (0x40, RR72)
                            Store (0x04, RR74)
                            Store (0x0D, RR75)
                            Store (0xFB, RR76)
                            Store (0x00, RR77)
                            Store (0xDC, RR7C)
                            Store (0xDC, RR7D)
                            Store (0x7F, RR7E)
                            Store (0xD5, RR7F)
                        }
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }
                }

                Device (SCSI)
                {
                    Name (_ADR, 0x000D0000)
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (^^_STA ())
                    }

                    Name (_PSC, 0x03)
                    Method (_INI, 0, NotSerialized)
                    {
                        If (LEqual (\_SB.PCI0.ISA.DKTP, 0x03))
                        {
                            Store (0x00, _PSC)
                        }
                        Else
                        {
                            Store (0x03, _PSC)
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        Store (0x00, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }
                }
            }

            Device (EPR)
            {
                Name (_ADR, 0x00120000)
                OperationRegion (CBE2, PCI_Config, 0x00, 0x44)
                Field (CBE2, WordAcc, NoLock, Preserve)
                {
                            Offset (0x02), 
                    CBID,   16, 
                            Offset (0x3E), 
                    CBX2,   16, 
                    VDID,   16, 
                    SBID,   16
                }

                OperationRegion (C2IN, PCI_Config, 0x80, 0x14)
                Field (C2IN, ByteAcc, NoLock, Preserve)
                {
                    CR80,   5, 
                    SBRW,   1, 
                    CR81,   2, 
                            Offset (0x03), 
                    CR83,   8, 
                            Offset (0x0C), 
                    CR8C,   8, 
                    CR8D,   8, 
                    CR8E,   8, 
                    CR8F,   8, 
                            Offset (0x13), 
                    CR93,   8
                }

                Method (ENQB, 0, NotSerialized)
                {
                    Name (CNT1, 0x00)
                    Store (0x01, \_SB.PCI0.ISA.EC0.CRST)
                    Store (0x00, CNT1)
                    While (LLessEqual (CNT1, 0x14))
                    {
                        If (LEqual (\_SB.PCI0.ISA.EC0.QVCC, 0x01))
                        {
                            Store (0xFFFF, CNT1)
                        }
                        Else
                        {
                            Increment (CNT1)
                            Sleep (0x14)
                        }
                    }

                    If (LEqual (CNT1, 0xFFFF))
                    {
                        Store (0x01, \_SB.PCI0.ISA.EC0.EQBF)
                        Store (0x00, \_SB.PCI0.ISA.EC0.CRST)
                        Store (0x00, \_SB.PCI0.ISA.EC0.DCWT)
                        Store (0x01, \_SB.PCI0.ISA.EC0.LDDS)
                        Return (0x01)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI0.ISA.EC0.CRST)
                        Store (0x00, \_SB.PCI0.ISA.EC0.DPWR)
                        Store (0x00, \_SB.PCI0.ISA.EC0.DCWT)
                        Return (0x00)
                    }
                }

                Method (_INI, 0, NotSerialized)
                {
                    If (LEqual (\_SB.PCI0.ISA.DKTP, 0x02))
                    {
                        Store (0x00, _PSC)
                    }
                    Else
                    {
                        Store (0x03, _PSC)
                    }
                }

                Name (_PSC, 0x03)
                Method (_PS0, 0, NotSerialized)
                {
                    Store (0x08, CR83)
                    Store (0x02, CR8C)
                    Store (0x1C, CR8D)
                    Store (0x02, CR8E)
                    Store (0x01, CR8F)
                    If (LEqual (CBID, 0xAC1C))
                    {
                        Store (0x41, CR93)
                    }

                    Store (0x00, SBRW)
                    Store (0x103C, VDID)
                    Store (0x04, SBID)
                    Store (0x01, SBRW)
                    Store (0x00, _PSC)
                }

                Method (_PS3, 0, NotSerialized)
                {
                    Store (0x03, _PSC)
                }

                Name (_EJD, "_SB_.PCI0.ISA_.SPR_")
                Method (_STA, 0, NotSerialized)
                {
                    If (LEqual (\_SB.PCI0.ISA.DKTP, 0x02))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }
            }

            Device (CB4)
            {
                Name (_ADR, 0x00120001)
                OperationRegion (ECB4, PCI_Config, 0x02, 0x02)
                Field (ECB4, WordAcc, NoLock, Preserve)
                {
                    CBID,   16
                }

                OperationRegion (CB4I, PCI_Config, 0x93, 0x01)
                Field (CB4I, ByteAcc, NoLock, Preserve)
                {
                    CR93,   8
                }

                Method (_INI, 0, NotSerialized)
                {
                    If (LEqual (\_SB.PCI0.ISA.DKTP, 0x02))
                    {
                        Store (0x00, _PSC)
                    }
                    Else
                    {
                        Store (0x03, _PSC)
                    }
                }

                Name (_PSC, 0x03)
                Method (_PS0, 0, NotSerialized)
                {
                    If (LEqual (CBID, 0xAC1C))
                    {
                        Store (0x41, CR93)
                    }

                    Store (0x00, _PSC)
                }

                Method (_PS3, 0, NotSerialized)
                {
                    Store (0x03, _PSC)
                }

                Name (_EJD, "_SB_.PCI0.ISA_.SPR_")
                Method (_STA, 0, NotSerialized)
                {
                    Return (\_SB.PCI0.EPR._STA ())
                }
            }

            Device (PX42)
            {
                Name (_ADR, 0x00070002)
                Method (_PS0, 0, NotSerialized)
                {
                    Store (0x00, \_SB.PCI0.PX43.UBPW)
                }

                Method (_PS3, 0, NotSerialized)
                {
                    Store (0x01, \_SB.PCI0.PX43.UBPW)
                }

                Method (_PSC, 0, NotSerialized)
                {
                    If (\_SB.PCI0.PX43.UBPW)
                    {
                        Return (0x03)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Method (_STA, 0, NotSerialized)
                {
                    If (\_SB.PCI0.PX43.UBPW)
                    {
                        Return (0x0D)
                    }
                    Else
                    {
                        Return (0x0F)
                    }
                }

                Name (_S1D, 0x00)
                Name (_S2D, 0x00)
                Name (_S3D, 0x03)
                Name (_PRW, Package (0x02)
                {
                    0x08, 
                    0x02
                })
                Device (USB1)
                {
                    Name (_ADR, 0x00)
                    Name (_STA, 0x0F)
                    Name (_EJD, "_SB_.PCI0.ISA_.SPR_")
                }
            }

            Device (PX43)
            {
                Name (_ADR, 0x00070003)
                OperationRegion (PPM, PCI_Config, 0x50, 0x30)
                Field (PPM, DWordAcc, NoLock, Preserve)
                {
                            Offset (0x01), 
                        ,   4, 
                    FDCM,   1, 
                        ,   1, 
                    U1M,    1, 
                            Offset (0x02), 
                    U2M,    1, 
                        ,   1, 
                    LPTM,   1, 
                            Offset (0x0C), 
                    MDIE,   1, 
                    MDIA,   2, 
                    SBE,    1, 
                        ,   1, 
                    SBA,    2, 
                    MSSE,   1, 
                    MSSA,   2, 
                            Offset (0x0F), 
                        ,   1, 
                    AUDM,   1, 
                        ,   3, 
                    G12M,   1, 
                    G13M,   1, 
                    LPTE,   1, 
                    G09A,   16, 
                    G09L,   4, 
                        ,   1, 
                    G09M,   1, 
                    G09E,   1, 
                            Offset (0x13), 
                        ,   1, 
                    LPTA,   2, 
                        ,   1, 
                    FDCA,   1, 
                    FDCE,   1, 
                        ,   1, 
                            Offset (0x14), 
                    G10A,   16, 
                    G10L,   4, 
                        ,   1, 
                    G10M,   1, 
                    G10E,   1, 
                            Offset (0x17), 
                    U1A,    3, 
                    U1E,    1, 
                    U2A,    3, 
                    U2E,    1, 
                    G12A,   16, 
                    G12L,   4, 
                    G12E,   1, 
                            Offset (0x20), 
                    G13A,   16, 
                    G13L,   4, 
                    G13E,   1, 
                            Offset (0x2C), 
                    DEC1,   16, 
                    DEEN,   8
                }

                OperationRegion (SMBP, PCI_Config, 0xD2, 0x05)
                Field (SMBP, DWordAcc, NoLock, Preserve)
                {
                    RD20,   8, 
                    RD30,   8, 
                    RD40,   8, 
                    RD50,   8, 
                    RD60,   8
                }

                OperationRegion (SMBI, SystemIO, 0x2180, 0x0D)
                Field (SMBI, ByteAcc, NoLock, Preserve)
                {
                    S000,   1, 
                    S001,   1, 
                    S002,   1, 
                    S003,   1, 
                    S004,   1, 
                            Offset (0x01), 
                    S010,   1, 
                        ,   1, 
                    S012,   1, 
                    S013,   1, 
                    S014,   1, 
                    S015,   1, 
                            Offset (0x02), 
                    S020,   1, 
                    S021,   1, 
                    S022,   3, 
                        ,   1, 
                    S025,   1, 
                            Offset (0x03), 
                    S030,   8, 
                    S040,   8, 
                    S050,   8, 
                    S060,   8, 
                    S070,   8, 
                    S080,   1, 
                    S081,   1, 
                    S082,   1, 
                    S083,   1, 
                            Offset (0x09), 
                    S090,   8, 
                    S0A0,   8, 
                            Offset (0x0C), 
                    S0C0,   8
                }

                OperationRegion (GPOS, SystemIO, 0x8034, 0x04)
                Field (GPOS, ByteAcc, NoLock, Preserve)
                {
                    UBPW,   1, 
                    HDPW,   1, 
                    SDPW,   1, 
                        ,   3, 
                    PRST,   1, 
                    SRST,   1, 
                    ENFD,   1, 
                            Offset (0x02), 
                            Offset (0x03), 
                        ,   6, 
                    DKPW,   1
                }
            }

            Device (AGP)
            {
                Name (_ADR, 0x00010000)
                Name (_PRT, Package (0x02)
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.LNKC, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.LNKB, 
                        0x00
                    }
                })
                Device (VGA)
                {
                    Name (_ADR, 0x00)
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (0x0F)
                    }

                    Name (_PSC, 0x00)
                    Method (_PS0, 0, NotSerialized)
                    {
                        Store (0x00, _PSC)
                    }

                    Method (_PS1, 0, NotSerialized)
                    {
                        Store (0x01, _PSC)
                    }

                    Method (_PS2, 0, NotSerialized)
                    {
                        Store (0x02, _PSC)
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        Store (0x03, _PSC)
                    }

                    Name (DISW, 0x01)
                    Name (NDSP, 0x00)
                    Name (VRSM, 0x00)
                    Method (NDGS, 0, NotSerialized)
                    {
                        Store (^CRT._DGS, Local1)
                        Or (XOr (^CRT._DGS, 0x01), XOr (^LCD._DGS, 0x01), ^CRT._DGS)
                        Store (Local1, ^LCD._DGS)
                    }

                    Method (_INI, 0, NotSerialized)
                    {
                        Store (0x00, \_SB.PCI0.ISA.STSB)
                        \_SB.PCI0.ISA.HPSS (0x0F)
                        Store (\_SB.PCI0.ISA.STSB, Local1)
                        Or (ShiftRight (And (Local1, 0x10), 0x03), 0x1D, ^LCD._DCS)
                        Or (Or (ShiftLeft (And (Local1, 0x02), 0x03), ShiftRight (
                            And (Local1, 0x20), 0x04)), 0x0D, ^CRT._DCS)
                        Or (ShiftRight (And (^LCD._DCS, 0x02), 0x01), And (^CRT._DCS, 
                            0x02), NDSP)
                        Store (ShiftRight (And (^LCD._DCS, 0x02), 0x01), ^LCD._DGS)
                        Store (ShiftRight (And (^CRT._DCS, 0x02), 0x01), ^CRT._DGS)
                        NDGS ()
                    }

                    Method (_DOS, 1, NotSerialized)
                    {
                        Store (Arg0, DISW)
                    }

                    Method (_DOD, 0, NotSerialized)
                    {
                        Return (Package (0x02)
                        {
                            0x00010100, 
                            0x00010110
                        })
                    }

                    Method (DRUL, 1, NotSerialized)
                    {
                        \_SB.PCI0.ISA.HPSS (0x0F)
                        Store (^CRT._DCS, Local1)
                        Or (ShiftLeft (And (\_SB.PCI0.ISA.STSB, 0x02), 0x03), And (^CRT._DCS, 
                            0x0F), ^CRT._DCS)
                        If (LEqual (Arg0, 0x01))
                        {
                            If (LAnd (^CRT._DGS, LNot (And (^CRT._DCS, 0x10))))
                            {
                                NDGS ()
                                Return (0x00)
                            }
                            Else
                            {
                                Notify (VGA, 0x80)
                                Return (0x00)
                            }
                        }

                        If (LEqual (Arg0, 0x02))
                        {
                            If (And (\_SB.PCI0.ISA.STSB, 0x02))
                            {
                                Store (0x01, ^CRT._DGS)
                                If (And (\_SB.PCI0.ISA.MFLG, 0x02))
                                {
                                    Store (0x01, ^LCD._DGS)
                                }
                                Else
                                {
                                    Store (0x00, ^LCD._DGS)
                                }
                            }
                            Else
                            {
                                Store (0x00, ^CRT._DGS)
                                Store (0x01, ^LCD._DGS)
                            }

                            Notify (VGA, 0x80)
                        }

                        If (LEqual (Arg0, 0x03))
                        {
                            If (LNotEqual (ShiftRight (And (Local1, 0x10), 0x03), 
                                And (\_SB.PCI0.ISA.STSB, 0x02)))
                            {
                                If (And (\_SB.PCI0.ISA.STSB, 0x02))
                                {
                                    Store (0x01, ^CRT._DGS)
                                    If (And (\_SB.PCI0.ISA.MFLG, 0x02))
                                    {
                                        Store (0x01, ^LCD._DGS)
                                    }
                                    Else
                                    {
                                        Store (0x00, ^LCD._DGS)
                                    }
                                }
                                Else
                                {
                                    Store (0x00, ^CRT._DGS)
                                    Store (0x01, ^LCD._DGS)
                                }

                                Notify (VGA, 0x80)
                            }
                        }
                    }

                    Device (LCD)
                    {
                        Name (_ADR, 0x0110)
                        Name (_PSC, 0x00)
                        Name (_S3D, 0x03)
                        Method (_PS0, 0, NotSerialized)
                        {
                            If (LAnd (_PSC, VRSM))
                            {
                                If (LNot (^^CRT._PSC))
                                {
                                    Store (0x00, VRSM)
                                    DRUL (0x03)
                                }
                            }

                            Store (0x00, _PSC)
                        }

                        Method (_PS1, 0, NotSerialized)
                        {
                            Store (0x01, _PSC)
                        }

                        Method (_PS2, 0, NotSerialized)
                        {
                            Store (0x02, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            Store (0x03, _PSC)
                        }

                        Name (_DCS, 0x1B)
                        Method (_DSS, 1, NotSerialized)
                        {
                            Store (Arg0, Local0)
                            If (And (Local0, 0x01))
                            {
                                Store ("LCD._DSS(1) called", Debug)
                                Or (NDSP, 0x01, NDSP)
                            }
                            Else
                            {
                                Store ("LCD._DSS(0) called", Debug)
                                And (NDSP, 0xFE, NDSP)
                            }

                            And (Local0, 0xC0000000, Local0)
                            If (LEqual (Local0, 0x80000000))
                            {
                                Store ("LCD._DSS(8000000x) called", Debug)
                                Store (NDSP, \_SB.PCI0.ISA.STSB)
                                \_SB.PCI0.ISA.HPSS (0x01)
                            }

                            And (Local0, 0x80000000, Local0)
                            If (LNotEqual (Local0, 0x00))
                            {
                                Or (And (^^LCD._DCS, 0xFD), ShiftLeft (And (NDSP, 0x01), 
                                    0x01), ^^LCD._DCS)
                                Or (And (^^CRT._DCS, 0xFD), And (NDSP, 0x02), ^^CRT._DCS)
                                NDGS ()
                            }
                        }

                        Name (_DGS, 0x00)
                    }

                    Device (CRT)
                    {
                        Name (_ADR, 0x0100)
                        Name (_PSC, 0x00)
                        Method (_PS0, 0, NotSerialized)
                        {
                            If (LAnd (_PSC, VRSM))
                            {
                                If (LNot (^^LCD._PSC))
                                {
                                    Store (0x00, VRSM)
                                    DRUL (0x03)
                                }
                            }

                            Store (0x00, _PSC)
                        }

                        Method (_PS1, 0, NotSerialized)
                        {
                            Store (0x01, _PSC)
                        }

                        Method (_PS2, 0, NotSerialized)
                        {
                            Store (0x02, _PSC)
                        }

                        Method (_PS3, 0, NotSerialized)
                        {
                            Store (0x03, _PSC)
                        }

                        Name (_DCS, 0x1B)
                        Method (_DSS, 1, NotSerialized)
                        {
                            Store (Arg0, Local0)
                            If (And (Local0, 0x01))
                            {
                                Store ("CRT._DSS(1) called", Debug)
                                Or (NDSP, 0x02, NDSP)
                            }
                            Else
                            {
                                Store ("CRT._DSS(0) called", Debug)
                                And (NDSP, 0xFD, NDSP)
                            }

                            And (Local0, 0xC0000000, Local0)
                            If (LEqual (Local0, 0x80000000))
                            {
                                Store ("CRT._DSS(8000000x) called", Debug)
                                Store (NDSP, \_SB.PCI0.ISA.STSB)
                                \_SB.PCI0.ISA.HPSS (0x01)
                            }

                            And (Local0, 0x80000000, Local0)
                            If (LNotEqual (Local0, 0x00))
                            {
                                Store ("CRT._DSS, update next _DGS", Debug)
                                Or (And (^^LCD._DCS, 0xFD), ShiftLeft (And (NDSP, 0x01), 
                                    0x01), ^^LCD._DCS)
                                Or (And (^^CRT._DCS, 0xFD), And (NDSP, 0x02), ^^CRT._DCS)
                                NDGS ()
                            }
                        }

                        Name (_DGS, 0x00)
                    }
                }
            }
        }
    }
}

