/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20060912
 *
 * Disassembly of (null), Sat Feb 23 15:53:28 2008
 *
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x0000391B (14619)
 *     Revision         0x01
 *     OEM ID           "A0277"
 *     OEM Table ID     "A0277001"
 *     OEM Revision     0x00000001 (1)
 *     Creator ID       "MSFT"
 *     Creator Revision 0x0100000D (16777229)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "A0277", "A0277001", 0x00000001)
{
    OperationRegion (BIOS, SystemMemory, 0x7FFC0064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32
    }

    Name (IO1B, 0x0680)
    Name (IO1L, 0x80)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (PM28, 0x0828)
    Name (GPBS, 0x00)
    Name (GPLN, 0x00)
    Name (SMBS, 0x0400)
    Name (SMBL, 0x20)
    Name (SPIO, 0x2E)
    Name (APCB, 0xFEC00000)
    Name (APCL, 0x1000)
    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, 0x00)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, 0x00))
        {
            Store (0xAC, DBG8)
        }

        Store (0x01, OSVR)
        If (MCTH (\_OS, "Microsoft Windows NT"))
        {
            Store (0x00, OSVR)
        }
        Else
        {
            If (MCTH (\_OS, "Microsoft WindowsME: Millennium Edition"))
            {
                Store (0x02, OSVR)
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), 0x01, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Method (GPRW, 2, NotSerialized)
    {
        Name (PRWP, Package (0x02)
        {
            0x00, 
            0x00
        })
        Store (Arg0, Index (PRWP, 0x00))
        Store (Arg1, Index (PRWP, 0x01))
        Store (0x00, Local0)
        Or (Local0, ShiftLeft (SS1, 0x01), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (0x01, Arg1), Local0)) {}
        Else
        {
            ShiftRight (Local0, 0x01, Local0)
            If (LOr (LEqual (OSFL (), 0x01), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, 0x01))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, 0x01))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        0x00, 
        0x00
    })
    OperationRegion (DEB0, SystemIO, 0x80, 0x01)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, 0x90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Scope (\_SB)
    {
        Name (PR00, Package (0x20)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0011FFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x03, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x03, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x03, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x00, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x01, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x02, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x03, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x00, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x01, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x02, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x03, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x00, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x01, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x02, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x03, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x00, 
                LNKB, 
                0x00
            }
        })
        Name (AR00, Package (0x20)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                0x00, 
                0x00, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x01, 
                0x00, 
                0x11
            }, 

            Package (0x04)
            {
                0x0011FFFF, 
                0x02, 
                0x00, 
                0x16
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x00, 
                0x00, 
                0x14
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x01, 
                0x00, 
                0x14
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x02, 
                0x00, 
                0x14
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                0x03, 
                0x00, 
                0x14
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x00, 
                0x00, 
                0x15
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x01, 
                0x00, 
                0x15
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x02, 
                0x00, 
                0x15
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x03, 
                0x00, 
                0x15
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x00, 
                0x00, 
                0x10
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x01, 
                0x00, 
                0x11
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x02, 
                0x00, 
                0x12
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x03, 
                0x00, 
                0x13
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x00, 
                0x00, 
                0x11
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x01, 
                0x00, 
                0x12
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x02, 
                0x00, 
                0x13
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x03, 
                0x00, 
                0x10
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x00, 
                0x00, 
                0x12
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x01, 
                0x00, 
                0x13
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x02, 
                0x00, 
                0x10
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x03, 
                0x00, 
                0x11
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x00, 
                0x00, 
                0x13
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x01, 
                0x00, 
                0x10
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x02, 
                0x00, 
                0x11
            }, 

            Package (0x04)
            {
                0x000EFFFF, 
                0x03, 
                0x00, 
                0x12
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x00, 
                0x00, 
                0x10
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x01, 
                0x00, 
                0x11
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                0x00, 
                0x12
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                0x00, 
                0x13
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x00, 
                0x00, 
                0x11
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,7,10,11,14,15}
        })
        Alias (PRSA, PRSB)
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))
            Name (_ADR, 0x00180000)
            Name (_BBN, 0x00)
            Name (_UID, 0x00)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_PRW, 0, NotSerialized)
            {
                Return (GPRW (0x0B, 0x04))
            }

            Device (VIAN)
            {
                Name (_ADR, 0x00)
            }

            Device (NBF1)
            {
                Name (_ADR, 0x01)
            }

            Device (NBF2)
            {
                Name (_ADR, 0x02)
            }

            Device (NBF3)
            {
                Name (_ADR, 0x03)
            }

            Device (NBF4)
            {
                Name (_ADR, 0x04)
            }

            Device (NBF7)
            {
                Name (_ADR, 0x07)
            }

            Device (P0P1)
            {
                Name (_ADR, 0x00010000)
            }

            Device (SBRG)
            {
                Name (_ADR, 0x00110000)
                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, 0x0B03D041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (0x01, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (0x00)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Method (PS2K._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x02, 0x04))
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))
                    Name (_CID, 0x130FD041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (0x01, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (0x00)
                    }

                    Name (CRS1, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (CRS2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        ShiftLeft (0x01, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (CRS1)
                        }
                        Else
                        {
                            Return (CRS2)
                        }
                    }
                }

                Method (PS2M._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (FDC)
                {
                    Name (_HID, EisaId ("PNP0700"))
                    Name (_FDE, Package (0x05)
                    {
                        0x01, 
                        0x00, 
                        0x02, 
                        0x02, 
                        0x02
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x03))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x03, 0x00)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x03)
                        Store (IRQM, IRQE)
                        Store (DMAM, DMAE)
                        Store (IO11, IO21)
                        Store (IO12, IO22)
                        Store (0x06, LEN2)
                        Add (IO21, 0x07, IO31)
                        Store (IO31, IO32)
                        Store (0x01, LEN3)
                        Return (CRS2)
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x03)
                    }

                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IRQNoFlags ()
                                {6}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {2}
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                        }
                        StartDependentFnNoPri ()
                        {
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,2,3}
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                        }
                        StartDependentFnNoPri ()
                        {
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,2,3}
                            IO (Decode16,
                                0x0370,             // Range Minimum
                                0x0370,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x0377,             // Range Minimum
                                0x0377,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                        }
                        EndDependentFn ()
                    })
                }

                Device (LPTE)
                {
                    Name (_UID, 0x01)
                    Method (_HID, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (0x0104D041)
                        }
                        Else
                        {
                            Return (0x0004D041)
                        }
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x02))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x02, 0x00)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (ECRS (0x02))
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        ESRS (Arg0, 0x02)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (EPPR)
                        }
                        Else
                        {
                            Return (LPPR)
                        }
                    }

                    Name (LPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        EndDependentFn ()
                    })
                    Name (EPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {7}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,3}
                        }
                        EndDependentFn ()
                    })
                    Name (EBUF, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0378,             // Range Minimum
                            0x0378,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y00)
                        IO (Decode16,
                            0x0778,             // Range Minimum
                            0x0778,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            _Y01)
                        IRQNoFlags (_Y02)
                            {7}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y03)
                            {}
                    })
                    CreateByteField (EBUF, \_SB.PCI0.SBRG.LPTE._Y00._MIN, EPLO)
                    CreateByteField (EBUF, 0x03, EPHI)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y00._MIN, EPHL)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y00._MAX, EPRL)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y00._ALN, ALM1)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y01._MIN, E4LO)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y01._MAX, E4RL)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y01._ALN, ELNG)
                    CreateWordField (EBUF, \_SB.PCI0.SBRG.LPTE._Y02._INT, EIRQ)
                    CreateByteField (EBUF, \_SB.PCI0.SBRG.LPTE._Y03._DMA, EDMA)
                    Name (PBUF, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0378,             // Range Minimum
                            0x0378,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y04)
                        IRQNoFlags (_Y05)
                            {7}
                    })
                    CreateByteField (PBUF, \_SB.PCI0.SBRG.LPTE._Y04._MIN, PPLO)
                    CreateByteField (PBUF, 0x03, PPHI)
                    CreateWordField (PBUF, \_SB.PCI0.SBRG.LPTE._Y04._MIN, PPHL)
                    CreateWordField (PBUF, \_SB.PCI0.SBRG.LPTE._Y04._MAX, PPRL)
                    CreateWordField (PBUF, \_SB.PCI0.SBRG.LPTE._Y04._ALN, ALM0)
                    CreateWordField (PBUF, \_SB.PCI0.SBRG.LPTE._Y05._INT, PIRQ)
                    Method (ECRS, 1, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        Store (IOAH, EPHI)
                        Store (IOAL, EPLO)
                        Store (IOAH, PPHI)
                        Store (IOAL, PPLO)
                        Store (EPHL, EPRL)
                        Store (PPHL, PPRL)
                        And (OPT0, 0x02, Local0)
                        If (Local0)
                        {
                            Add (EPHL, 0x0400, E4LO)
                            Store (E4LO, E4RL)
                        }

                        If (LEqual (EPHL, 0x03BC))
                        {
                            Store (0x0401, ALM1)
                            Store (0x0401, ALM0)
                        }
                        Else
                        {
                            Store (0x0801, ALM1)
                            Store (0x0801, ALM0)
                        }

                        Store (One, Local0)
                        Store (INTR, Local1)
                        ShiftLeft (Local0, Local1, EIRQ)
                        ShiftLeft (Local0, Local1, PIRQ)
                        Store (DMCH, Local1)
                        If (LGreater (Local1, 0x03))
                        {
                            Store (0x00, EDMA)
                        }
                        Else
                        {
                            Store (One, Local0)
                            ShiftLeft (Local0, Local1, EDMA)
                        }

                        And (OPT0, 0x02, Local0)
                        EXFG ()
                        If (Local0)
                        {
                            Return (EBUF)
                        }
                        Else
                        {
                            Return (PBUF)
                        }
                    }

                    Method (ESRS, 2, NotSerialized)
                    {
                        ENFG (CGLD (Arg1))
                        CreateByteField (Arg0, 0x02, LOEP)
                        CreateByteField (Arg0, 0x03, HIEP)
                        And (OPT0, 0x02, Local0)
                        If (Local0)
                        {
                            CreateWordField (Arg0, 0x11, IRQE)
                            CreateByteField (Arg0, 0x14, DMAE)
                        }
                        Else
                        {
                            CreateWordField (Arg0, 0x09, IRQP)
                        }

                        Store (LOEP, IOAL)
                        Store (HIEP, IOAH)
                        And (OPT0, 0x02, Local0)
                        If (Local0)
                        {
                            If (IRQE)
                            {
                                FindSetRightBit (IRQE, Local0)
                                Subtract (Local0, 0x01, INTR)
                            }
                            Else
                            {
                                Store (0x00, INTR)
                            }
                        }
                        Else
                        {
                            If (IRQP)
                            {
                                FindSetRightBit (IRQP, Local0)
                                Subtract (Local0, 0x01, INTR)
                            }
                            Else
                            {
                                Store (0x00, INTR)
                            }
                        }

                        And (OPT0, 0x02, Local0)
                        If (Local0)
                        {
                            If (DMAE)
                            {
                                FindSetRightBit (DMAE, Local0)
                                Subtract (Local0, 0x01, DMCH)
                            }
                            Else
                            {
                                Store (0x04, DMCH)
                            }
                        }

                        Store (One, ACTR)
                        EXFG ()
                    }
                }

                Device (SIOR)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Method (_UID, 0, NotSerialized)
                    {
                        Return (SPIO)
                    }

                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y06)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y07)
                        IO (Decode16,
                            0x0290,             // Range Minimum
                            0x0290,             // Range Maximum
                            0x00,               // Alignment
                            0x08,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LAnd (LNotEqual (SPIO, 0x03F0), LGreater (SPIO, 0xF0)))
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y06._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y06._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y06._LEN, GPL1)
                            Store (SPIO, GP10)
                            Store (SPIO, GP11)
                            Store (0x02, GPL1)
                        }

                        If (IO1B)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y07._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y07._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y07._LEN, GPL2)
                            Store (IO1B, GP20)
                            Store (IO1B, GP21)
                            Store (IO1L, GPL2)
                        }

                        Return (CRS)
                    }
                }

                Name (DCAT, Package (0x15)
                {
                    0x02, 
                    0x03, 
                    0x01, 
                    0x00, 
                    0xFF, 
                    0x07, 
                    0xFF, 
                    0xFF, 
                    0x07, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0x07, 
                    0x08, 
                    0x09, 
                    0xFF, 
                    0xFF
                })
                Method (ENFG, 1, NotSerialized)
                {
                    Store (0x87, INDX)
                    Store (0x87, INDX)
                    Store (Arg0, LDN)
                }

                Method (EXFG, 0, NotSerialized)
                {
                    Store (0xAA, INDX)
                }

                Method (LPTM, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    And (OPT0, 0x02, Local0)
                    EXFG ()
                    Return (Local0)
                }

                Method (UHID, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x01))
                    {
                        ENFG (CGLD (Arg0))
                        And (OPT1, 0x38, Local0)
                        EXFG ()
                        If (Local0)
                        {
                            Return (0x1005D041)
                        }
                    }

                    Return (0x0105D041)
                }

                Method (SIOK, 1, NotSerialized)
                {
                    ENFG (0x0A)
                    If (LGreater (Arg0, 0x01))
                    {
                        Or (CRE4, 0x10, CRE4)
                    }

                    Store (CRE3, Local0)
                    EXFG ()
                }

                Method (SIOS, 1, NotSerialized)
                {
                    Store ("SIOS", Debug)
                    SIOK (Arg0)
                }

                Method (SIOW, 1, NotSerialized)
                {
                    Store ("SIOW", Debug)
                    SIOK (0x00)
                }

                Method (SIOH, 0, NotSerialized)
                {
                    Store ("SIOH", Debug)
                    ENFG (0x0A)
                    If (And (OPT3, 0x10))
                    {
                        Notify (PS2K, 0x02)
                    }

                    If (And (OPT3, 0x20))
                    {
                        Notify (PS2M, 0x02)
                    }

                    SIOK (Zero)
                }

                OperationRegion (IOID, SystemIO, SPIO, 0x02)
                Field (IOID, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x07), 
                    LDN,    8, 
                            Offset (0x22), 
                    FDCP,   1, 
                        ,   2, 
                    LPTP,   1, 
                    URAP,   1, 
                    URBP,   1, 
                            Offset (0x30), 
                    ACTR,   8, 
                            Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IOH2,   8, 
                    IOL2,   8, 
                            Offset (0x70), 
                    INTR,   4, 
                            Offset (0x74), 
                    DMCH,   3, 
                            Offset (0xE0), 
                    CRE0,   8, 
                    CRE1,   8, 
                    CRE2,   8, 
                    CRE3,   8, 
                    CRE4,   8, 
                    CRE5,   8, 
                    CRE6,   8, 
                            Offset (0xF0), 
                    OPT0,   8, 
                    OPT1,   8, 
                    OPT2,   8, 
                    OPT3,   8, 
                            Offset (0xF5), 
                    OPT5,   8, 
                    OPT6,   8, 
                            Offset (0xF9), 
                    OPT9,   8
                }

                Method (CGLD, 1, NotSerialized)
                {
                    Return (DerefOf (Index (DCAT, Arg0)))
                }

                Method (DSTA, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    Store (ACTR, Local0)
                    EXFG ()
                    If (LEqual (Local0, 0xFF))
                    {
                        Return (0x00)
                    }

                    If (LEqual (Arg0, 0x05))
                    {
                        ShiftRight (Local0, 0x02, Local0)
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        ShiftRight (Local0, 0x01, Local0)
                    }

                    And (Local0, 0x01, Local0)
                    Or (IOST, ShiftLeft (Local0, Arg0), IOST)
                    If (Local0)
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        If (And (ShiftLeft (0x01, Arg0), IOST))
                        {
                            Return (0x0D)
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }
                }

                Method (DCNT, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    If (LEqual (Arg0, 0x05))
                    {
                        ShiftLeft (IOH2, 0x08, Local1)
                        Or (IOL2, Local1, Local1)
                    }
                    Else
                    {
                        ShiftLeft (IOAH, 0x08, Local1)
                        Or (IOAL, Local1, Local1)
                    }

                    RRIO (Arg0, Arg1, Local1, 0x08)
                    If (LAnd (LLess (DMCH, 0x04), LNotEqual (And (DMCH, 0x03, 
                        Local1), 0x00)))
                    {
                        RDMA (Arg0, Arg1, Increment (Local1))
                    }

                    Store (Arg1, Local1)
                    Store (0x01, Local2)
                    If (LEqual (Arg0, 0x05))
                    {
                        ShiftLeft (Arg1, 0x02, Local1)
                        ShiftLeft (Local2, 0x02, Local2)
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        ShiftLeft (Arg1, 0x01, Local1)
                        ShiftLeft (Local2, 0x01, Local2)
                    }

                    Store (ACTR, Local0)
                    Not (Local2, Local3)
                    And (Local0, Local3, Local0)
                    Or (Local0, Local1, Local0)
                    Store (Local0, ACTR)
                    EXFG ()
                }

                Name (CRS1, ResourceTemplate ()
                {
                    IRQNoFlags (_Y08)
                        {}
                    DMA (Compatibility, NotBusMaster, Transfer8, _Y09)
                        {}
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y0A)
                })
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y08._INT, IRQM)
                CreateByteField (CRS1, \_SB.PCI0.SBRG._Y09._DMA, DMAM)
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y0A._MIN, IO11)
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y0A._MAX, IO12)
                CreateByteField (CRS1, \_SB.PCI0.SBRG._Y0A._LEN, LEN1)
                Name (CRS2, ResourceTemplate ()
                {
                    IRQNoFlags (_Y0B)
                        {6}
                    DMA (Compatibility, NotBusMaster, Transfer8, _Y0C)
                        {2}
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y0D)
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y0E)
                })
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y0B._INT, IRQE)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y0C._DMA, DMAE)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y0D._MIN, IO21)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y0D._MAX, IO22)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y0D._LEN, LEN2)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y0E._MIN, IO31)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y0E._MAX, IO32)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y0E._LEN, LEN3)
                Method (DCRS, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, IO11)
                    Or (IOAL, IO11, IO11)
                    Store (IO11, IO12)
                    Subtract (FindSetRightBit (IO11), 0x01, Local0)
                    ShiftLeft (0x01, Local0, LEN1)
                    If (INTR)
                    {
                        ShiftLeft (0x01, INTR, IRQM)
                    }
                    Else
                    {
                        Store (0x00, IRQM)
                    }

                    If (LOr (LGreater (DMCH, 0x03), LEqual (Arg0, 0x00)))
                    {
                        Store (0x00, DMAM)
                    }
                    Else
                    {
                        And (DMCH, 0x03, Local1)
                        ShiftLeft (0x01, Local1, DMAM)
                    }

                    EXFG ()
                    Return (CRS1)
                }

                Method (DSRS, 2, NotSerialized)
                {
                    CreateWordField (Arg0, 0x01, IRQM)
                    CreateByteField (Arg0, 0x04, DMAM)
                    CreateWordField (Arg0, 0x08, IO11)
                    ENFG (CGLD (Arg1))
                    And (IO11, 0xFF, IOAL)
                    ShiftRight (IO11, 0x08, IOAH)
                    If (IRQM)
                    {
                        FindSetRightBit (IRQM, Local0)
                        Subtract (Local0, 0x01, INTR)
                    }
                    Else
                    {
                        Store (0x00, INTR)
                    }

                    If (DMAM)
                    {
                        FindSetRightBit (DMAM, Local0)
                        Subtract (Local0, 0x01, DMCH)
                    }
                    Else
                    {
                        Store (0x07, DMCH)
                    }

                    EXFG ()
                    DCNT (Arg1, 0x01)
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x0B,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x03E1,             // Range Minimum
                            0x03E1,             // Range Maximum
                            0x00,               // Alignment
                            0x07,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y0F)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y10)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y11)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0F._MIN, GP00)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y0F._MAX, GP01)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y0F._LEN, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y10._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y10._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y10._LEN, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y11._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y11._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y11._LEN, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }

                        Return (CRS)
                    }
                }

                Scope (\_PR)
                {
                    Processor (CPU1, 0x01, 0x00005010, 0x06)
                    {
                        Name (_PCT, Package (0x02)
                        {
                            ResourceTemplate ()
                            {
                                Register (FFixedHW, 
                                    0x00,               // Bit Width
                                    0x00,               // Bit Offset
                                    0x0000000000000000, // Address
                                    ,)
                            }, 

                            ResourceTemplate ()
                            {
                                Register (FFixedHW, 
                                    0x00,               // Bit Width
                                    0x00,               // Bit Offset
                                    0x0000000000000000, // Address
                                    ,)
                            }
                        })
                        Name (_PSS, Package (0x04)
                        {
                            Package (0x06)
                            {
                                0x00000898, 
                                0x00015BA8, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202A0E, 
                                0x0000020E
                            }, 

                            Package (0x06)
                            {
                                0x000007D0, 
                                0x00014A78, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202A8C, 
                                0x0000028C
                            }, 

                            Package (0x06)
                            {
                                0x00000708, 
                                0x000114F4, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202B0A, 
                                0x0000030A
                            }, 

                            Package (0x06)
                            {
                                0x000003E8, 
                                0x000092E0, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202C82, 
                                0x00000482
                            }
                        })
                        Name (PSXG, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXF, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXE, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXD, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXC, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXB, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Method (_PPC, 0, NotSerialized)
                        {
                            Return (0x00)
                        }
                    }

                    Processor (CPU2, 0x02, 0x00000000, 0x00)
                    {
                        Name (_PCT, Package (0x02)
                        {
                            ResourceTemplate ()
                            {
                                Register (FFixedHW, 
                                    0x00,               // Bit Width
                                    0x00,               // Bit Offset
                                    0x0000000000000000, // Address
                                    ,)
                            }, 

                            ResourceTemplate ()
                            {
                                Register (FFixedHW, 
                                    0x00,               // Bit Width
                                    0x00,               // Bit Offset
                                    0x0000000000000000, // Address
                                    ,)
                            }
                        })
                        Name (_PSS, Package (0x04)
                        {
                            Package (0x06)
                            {
                                0x00000898, 
                                0x00015BA8, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202A0E, 
                                0x0000020E
                            }, 

                            Package (0x06)
                            {
                                0x000007D0, 
                                0x00014A78, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202A8C, 
                                0x0000028C
                            }, 

                            Package (0x06)
                            {
                                0x00000708, 
                                0x000114F4, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202B0A, 
                                0x0000030A
                            }, 

                            Package (0x06)
                            {
                                0x000003E8, 
                                0x000092E0, 
                                0x00000064, 
                                0x00000007, 
                                0xE0202C82, 
                                0x00000482
                            }
                        })
                        Name (PSXG, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXF, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXE, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXD, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXC, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Name (PSXB, Buffer (0x18)
                        {
                            /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0010 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        Method (_PPC, 0, NotSerialized)
                        {
                            Return (0x00)
                        }
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x00)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y12)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y13)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y14)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APCB)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y12._LEN, ML01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y12._BAS, MB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y13._LEN, ML02)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y13._BAS, MB02)
                            Store (APCB, MB01)
                            Store (APCL, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                        }

                        CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y14._LEN, ML03)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y14._BAS, MB03)
                        Store (0xFFF80000, MB03)
                        Store (0x00080000, ML03)
                        Return (CRS)
                    }
                }

                Device (\_SB.RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, 0x01)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y15)
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            _Y16)
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            _Y17)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y18)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.RMEM._Y15._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.RMEM._Y15._LEN, LEN1)
                        CreateDWordField (CRS, \_SB.RMEM._Y16._BAS, BAS2)
                        CreateDWordField (CRS, \_SB.RMEM._Y16._LEN, LEN2)
                        CreateDWordField (CRS, \_SB.RMEM._Y17._LEN, LEN3)
                        CreateDWordField (CRS, \_SB.RMEM._Y18._BAS, BAS4)
                        CreateDWordField (CRS, \_SB.RMEM._Y18._LEN, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Add (MG2B, MG2L, BAS4)
                        Subtract (0x00, BAS4, LEN4)
                        Return (CRS)
                    }
                }

                Device (UAR1)
                {
                    Name (_UID, 0x01)
                    Name (_HID, EisaId ("PNP0501"))
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x00))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x00, 0x00)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (PCRS (0x00, 0x01, 0x08))
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        PSRS (Arg0, 0x00)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        Return (CMPR)
                    }

                    Name (CMPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x04,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                        }
                        EndDependentFn ()
                    })
                    Name (PBUF, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y19)
                        IRQNoFlags (_Y1A)
                            {0}
                    })
                    Method (PCRS, 3, NotSerialized)
                    {
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.UAR1._Y19._MIN, IOLO)
                        CreateByteField (PBUF, 0x03, IOHI)
                        CreateWordField (PBUF, \_SB.PCI0.SBRG.UAR1._Y19._MIN, IOHL)
                        CreateWordField (PBUF, \_SB.PCI0.SBRG.UAR1._Y19._MAX, IORL)
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.UAR1._Y19._ALN, ALMN)
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.UAR1._Y19._LEN, LENG)
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.UAR1._Y1A._INT, IRQL)
                        ENFG (CGLD (Arg0))
                        Store (IOAH, IOHI)
                        Store (IOAL, IOLO)
                        Store (IOHL, IORL)
                        Store (Arg1, ALMN)
                        If (LEqual (IOLO, 0xBC))
                        {
                            Store (0x04, LENG)
                        }
                        Else
                        {
                            Store (Arg2, LENG)
                        }

                        Store (One, Local0)
                        ShiftLeft (Local0, INTR, IRQL)
                        EXFG ()
                        Return (PBUF)
                    }

                    Method (PSRS, 2, NotSerialized)
                    {
                        CreateByteField (Arg0, 0x02, POLB)
                        CreateByteField (Arg0, 0x03, POHB)
                        CreateWordField (Arg0, 0x09, PIRQ)
                        ENFG (CGLD (Arg1))
                        Store (POLB, IOAL)
                        Store (POHB, IOAH)
                        FindSetRightBit (PIRQ, Local0)
                        Subtract (Local0, 0x01, INTR)
                        Store (One, ACTR)
                        EXFG ()
                    }
                }

                Method (UAR1._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x08, 0x04))
                }

                Device (GAME)
                {
                    Name (_HID, EisaId ("PNPB02F"))
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x08))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x08, 0x00)
                    }

                    Name (GMCR, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0200,             // Range Minimum
                            0x0200,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y1B)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateByteField (GMCR, \_SB.PCI0.SBRG.GAME._Y1B._MIN, IOLO)
                        CreateByteField (GMCR, 0x03, IOHI)
                        CreateWordField (GMCR, \_SB.PCI0.SBRG.GAME._Y1B._MIN, IOHL)
                        CreateWordField (GMCR, \_SB.PCI0.SBRG.GAME._Y1B._MAX, IORL)
                        ENFG (CGLD (0x08))
                        Store (IOAH, IOHI)
                        Store (IOAL, IOLO)
                        Store (IOHL, IORL)
                        EXFG ()
                        Return (GMCR)
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        CreateByteField (Arg0, 0x02, POLB)
                        CreateByteField (Arg0, 0x03, POHB)
                        ENFG (CGLD (0x08))
                        Store (POLB, IOAL)
                        Store (POHB, IOAH)
                        DCNT (0x08, 0x01)
                        EXFG ()
                    }

                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0200,             // Range Minimum
                                0x0200,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0208,             // Range Minimum
                                0x0208,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                        }
                        EndDependentFn ()
                    })
                }

                Device (MIDI)
                {
                    Name (_HID, EisaId ("PNPB006"))
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x05))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x05, 0x00)
                    }

                    Name (MDCR, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0300,             // Range Minimum
                            0x0300,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            _Y1C)
                        IRQNoFlags (_Y1D)
                            {5}
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateByteField (MDCR, \_SB.PCI0.SBRG.MIDI._Y1C._MIN, IOLO)
                        CreateByteField (MDCR, 0x03, IOHI)
                        CreateWordField (MDCR, \_SB.PCI0.SBRG.MIDI._Y1C._MIN, IOHL)
                        CreateWordField (MDCR, \_SB.PCI0.SBRG.MIDI._Y1C._MAX, IORL)
                        CreateWordField (MDCR, \_SB.PCI0.SBRG.MIDI._Y1D._INT, MIRQ)
                        ENFG (CGLD (0x05))
                        Store (IOH2, IOHI)
                        Store (IOL2, IOLO)
                        Store (IOHL, IORL)
                        ShiftLeft (0x01, INTR, MIRQ)
                        EXFG ()
                        Return (MDCR)
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        CreateByteField (Arg0, 0x02, POLB)
                        CreateByteField (Arg0, 0x03, POHB)
                        CreateWordField (Arg0, 0x09, MIRQ)
                        ENFG (CGLD (0x05))
                        Store (POLB, IOL2)
                        Store (POHB, IOH2)
                        FindSetRightBit (MIRQ, Local0)
                        Subtract (Local0, 0x01, INTR)
                        DCNT (0x05, 0x01)
                        EXFG ()
                    }

                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0300,             // Range Minimum
                                0x0300,             // Range Maximum
                                0x01,               // Alignment
                                0x02,               // Length
                                )
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0330,             // Range Minimum
                                0x0330,             // Range Maximum
                                0x01,               // Alignment
                                0x02,               // Length
                                )
                        }
                        EndDependentFn ()
                        IRQNoFlags ()
                            {5,9,10,11}
                    })
                }
            }

            Device (AC97)
            {
                Name (_ADR, 0x00110005)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }

            Device (MC97)
            {
                Name (_ADR, 0x00110006)
                OperationRegion (ACLK, PCI_Config, 0x41, 0x01)
                Field (ACLK, ByteAcc, NoLock, Preserve)
                {
                        ,   6, 
                    MC9P,   2
                }
            }

            Device (IDEC)
            {
                Name (_ADR, 0x000F0001)
                Name (REGF, 0x01)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Name (TIM0, Package (0x0A)
                {
                    Package (0x05)
                    {
                        0x3C, 
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x05)
                    {
                        0x11, 
                        0x20, 
                        0x31, 
                        0x65, 
                        0xA8
                    }, 

                    Package (0x08)
                    {
                        0x05, 
                        0x04, 
                        0x03, 
                        0x02, 
                        0x02, 
                        0x01, 
                        0x01, 
                        0x00
                    }, 

                    Package (0x07)
                    {
                        0x70, 
                        0x49, 
                        0x36, 
                        0x27, 
                        0x19, 
                        0x11, 
                        0x0C
                    }, 

                    Package (0x06)
                    {
                        0x07, 
                        0x06, 
                        0x04, 
                        0x02, 
                        0x01, 
                        0x00
                    }, 

                    Package (0x07)
                    {
                        0x00, 
                        0x00, 
                        0x00, 
                        0x01, 
                        0x01, 
                        0x01, 
                        0x01
                    }, 

                    Package (0x05)
                    {
                        0x05, 
                        0x04, 
                        0x03, 
                        0x02, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        0x01, 
                        0x00, 
                        0x00
                    }, 

                    Package (0x0F)
                    {
                        0x06, 
                        0x05, 
                        0x04, 
                        0x04, 
                        0x03, 
                        0x03, 
                        0x02, 
                        0x02, 
                        0x01, 
                        0x01, 
                        0x01, 
                        0x01, 
                        0x00, 
                        0x00, 
                        0x00
                    }, 

                    Package (0x07)
                    {
                        0x0E, 
                        0x08, 
                        0x06, 
                        0x04, 
                        0x02, 
                        0x01, 
                        0x00
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, 0x00, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                            Offset (0x08), 
                    SSPT,   8, 
                    SMPT,   8, 
                    PSPT,   8, 
                    PMPT,   8, 
                            Offset (0x10), 
                    SSUT,   3, 
                        ,   1, 
                    SSCR,   1, 
                    SSUE,   3, 
                    SMUT,   3, 
                        ,   1, 
                    SMCR,   1, 
                    SMUE,   3, 
                    PSUT,   3, 
                        ,   1, 
                    PSCR,   1, 
                    PSUE,   3, 
                    PMUT,   3, 
                        ,   1, 
                    PMCR,   1, 
                    PMUE,   3
                }

                Name (GMPT, 0x00)
                Name (GMUE, 0x00)
                Name (GMUT, 0x00)
                Name (GMCR, 0x00)
                Name (GSPT, 0x00)
                Name (GSUE, 0x00)
                Name (GSUT, 0x00)
                Name (GSCR, 0x00)
                Device (CHN0)
                {
                    Name (_ADR, 0x00)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, 0x01, Local1)
                        Or (PMCR, Local1, Local0)
                        Return (GTM (PMPT, PMUE, PMUT, PSPT, PSUE, PSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (PMPT, GMPT)
                        Store (PMUE, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSPT, GSPT)
                        Store (PSUE, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMPT)
                        Store (GMUE, PMUE)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSPT, PSPT)
                        Store (GSUE, PSUE)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        Store (GTF (0x00, Arg1), ATA0)
                        Store (GTF (0x01, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, 0x01)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, 0x01)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, 0x01, Local1)
                        Or (SMCR, Local1, Local0)
                        Return (GTM (SMPT, SMUE, SMUT, SSPT, SSUE, SSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (SMPT, GMPT)
                        Store (SMUE, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSPT, GSPT)
                        Store (SSUE, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMPT)
                        Store (GMUE, SMUE)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSPT, SSPT)
                        Store (GSUE, SSUE)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        Store (GTF (0x00, Arg1), ATA2)
                        Store (GTF (0x01, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, 0x01)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    Store (Match (DerefOf (Index (TIM0, 0x01)), MEQ, Arg0, MTR, 
                        0x00, 0x00), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x00)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    Store (Match (DerefOf (Index (TIM0, 0x01)), MEQ, Arg3, MTR, 
                        0x00, 0x00), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x00)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (Arg1)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x08)), Arg2)), 
                            Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, 0x01, CHNF)
                    }

                    If (Arg4)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x08)), Arg5)), 
                            Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    Store (0x00, GMUE)
                    Store (0x07, GMUT)
                    Store (0x00, GSUE)
                    Store (0x07, GSUT)
                    If (And (CHNF, 0x01))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                            0x00, 0x00), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x09)), Local0)), 
                            GMUT)
                        Or (GMUE, 0x07, GMUE)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO0, Ones), LEqual (PIO0, 0x00)))
                        {
                            If (And (LLess (DMA0, Ones), LGreater (DMA0, 0x00)))
                            {
                                Store (DMA0, PIO0)
                            }
                        }
                    }

                    If (And (CHNF, 0x04))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                            0x00, 0x00), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x09)), Local0)), 
                            GSUT)
                        Or (GSUE, 0x07, GSUE)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO1, Ones), LEqual (PIO1, 0x00)))
                        {
                            If (And (LLess (DMA1, Ones), LGreater (DMA1, 0x00)))
                            {
                                Store (DMA1, PIO1)
                            }
                        }
                    }

                    And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIO0, MTR, 
                        0x00, 0x00), 0x07, Local0)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x01)), Local0)), 
                        Local1)
                    Store (Local1, GMPT)
                    And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIO1, MTR, 
                        0x00, 0x00), 0x07, Local0)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x01)), Local0)), 
                        Local1)
                    Store (Local1, GSPT)
                }

                Name (AT01, Buffer (0x07)
                {
                    /* 0000 */    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, 0x00, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (0x00, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, 0x00)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, 0x01)
                    Name (PIOT, 0x00)
                    Name (DMAT, 0x00)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, 0x01))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            0x00, 0x00), Local1)
                        If (LGreater (Local1, 0x06))
                        {
                            Store (0x06, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIOT, MTR, 
                                0x00, 0x00), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIOT, MTR, 
                            0x00, 0x00), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, 0x01, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, 0x00, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (RETB)
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x00100000)
                OperationRegion (WAU1, PCI_Config, 0x84, 0x01)
                Field (WAU1, WordAcc, NoLock, Preserve)
                {
                    U184,   8
                }

                OperationRegion (U1D3, PCI_Config, 0x49, 0x01)
                Field (U1D3, WordAcc, NoLock, Preserve)
                {
                    UR49,   3
                }

                OperationRegion (UBP1, PCI_Config, 0x85, 0x01)
                Field (UBP1, WordAcc, NoLock, Preserve)
                {
                    U1PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (OSFL ())
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x00100001)
                OperationRegion (WAU2, PCI_Config, 0x84, 0x01)
                Field (WAU2, WordAcc, NoLock, Preserve)
                {
                    U284,   8
                }

                OperationRegion (UBP2, PCI_Config, 0x85, 0x01)
                Field (UBP2, WordAcc, NoLock, Preserve)
                {
                    U2PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (OSFL ())
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x00100002)
                OperationRegion (WAU3, PCI_Config, 0x84, 0x01)
                Field (WAU3, WordAcc, NoLock, Preserve)
                {
                    U384,   8
                }

                OperationRegion (UBP3, PCI_Config, 0x85, 0x01)
                Field (UBP3, WordAcc, NoLock, Preserve)
                {
                    U3PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (OSFL ())
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB4)
            {
                Name (_ADR, 0x00100003)
                OperationRegion (WAU4, PCI_Config, 0x84, 0x01)
                Field (WAU4, WordAcc, NoLock, Preserve)
                {
                    U484,   8
                }

                OperationRegion (UBP4, PCI_Config, 0x85, 0x01)
                Field (UBP4, WordAcc, NoLock, Preserve)
                {
                    U4PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (OSFL ())
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (EHCI)
            {
                Name (_ADR, 0x00100004)
                OperationRegion (WAU5, PCI_Config, 0x84, 0x01)
                Field (WAU5, WordAcc, NoLock, Preserve)
                {
                    U584,   8
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L0B, 0, NotSerialized)
            {
                Notify (\_SB.PCI0, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L02, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L09, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L08, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L0D, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.AC97, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0E, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB1, 0x02)
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PCI0.USB4, 0x02)
                Notify (\_SB.PCI0.EHCI, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
            Method (_PRW, 0, NotSerialized)
            {
                Return (GPRW (0x09, 0x04))
            }
        }
    }

    Scope (\_SB)
    {
        OperationRegion (\_SB.PCI0.SBRG.PIX0, PCI_Config, 0x55, 0x04)
        OperationRegion (\_SB.PCI0.SBRG.PIX1, PCI_Config, 0x50, 0x02)
        OperationRegion (\_SB.PCI0.SBRG.PIX2, PCI_Config, 0x44, 0x02)
        OperationRegion (\_SB.PCI0.SBRG.PIX3, PCI_Config, 0x67, 0x03)
        OperationRegion (\_SB.PCI0.SBRG.PIX4, PCI_Config, 0x6C, 0x04)
        Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
        {
                ,   4, 
            PIRA,   4, 
            PIRB,   4, 
            PIRC,   4, 
                ,   4, 
            PIRD,   4, 
                ,   4
        }

        Field (\_SB.PCI0.SBRG.PIX1, ByteAcc, NoLock, Preserve)
        {
                ,   1, 
            EP3C,   1, 
            EN3C,   1, 
                ,   6, 
            KBFG,   1
        }

        Field (\_SB.PCI0.SBRG.PIX2, ByteAcc, NoLock, Preserve)
        {
            PIRE,   4, 
            PIRF,   4, 
            PIRG,   4, 
            PIRH,   4
        }

        Field (\_SB.PCI0.SBRG.PIX3, ByteAcc, NoLock, Preserve)
        {
            ENIR,   1, 
            IRSD,   1, 
                    Offset (0x02), 
            IRBA,   8
        }

        Field (\_SB.PCI0.SBRG.PIX4, ByteAcc, NoLock, Preserve)
        {
            PS0E,   1, 
            PS1E,   1, 
            ROME,   1, 
            APCE,   1, 
            LPMS,   2, 
            MSEN,   1, 
            IXEN,   1, 
            LPMD,   2, 
            MDEN,   1, 
            GMEN,   1, 
            LPLP,   2, 
            LPEN,   1, 
            FDEN,   1, 
            LPCA,   3, 
            CAEN,   1, 
            LPCB,   3, 
            CBEN,   1, 
            LPSB,   2, 
            SBEN,   1, 
            FDSE,   1, 
                    Offset (0x04)
        }

        Name (IRQA, 0x00)
        Name (IRQB, 0x00)
        Name (IRQC, 0x00)
        Name (IRQD, 0x00)
        Name (IRQE, 0x00)
        Name (IRQF, 0x00)
        Name (IRQG, 0x00)
        Name (IRQH, 0x00)
        Name (ICRS, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, _Y1E)
                {15}
        })
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x01)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRA, IRQA)
                If (PIRA)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQA, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
                Store (PIRA, IRQA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRB, IRQB)
                If (PIRB)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQB, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
                Store (PIRB, IRQB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRC, IRQC)
                If (PIRC)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQC, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
                Store (PIRC, IRQC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRD, IRQD)
                If (PIRD)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQD, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
                Store (PIRD, IRQD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x01)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRE, IRQE)
                If (PIRE)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRE)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQE, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
                Store (PIRE, IRQE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRF, IRQF)
                If (PIRF)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRF)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQF, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
                Store (PIRF, IRQF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRG, IRQG)
                If (PIRG)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRG)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQG, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
                Store (PIRG, IRQG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRH, IRQH)
                If (PIRH)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRH)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, \_SB._Y1E._INT, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQH, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
                Store (PIRH, IRQH)
            }
        }
    }

    Scope (\_SB)
    {
        Name (SLPS, 0x00)
        Device (SLPB)
        {
            Name (_HID, EisaId ("PNP0C0E"))
            Method (SBEV, 0, NotSerialized)
            {
                If (SLPS)
                {
                    Notify (SLPB, 0x02)
                }
                Else
                {
                    Notify (SLPB, 0x80)
                }
            }

            Scope (\_GPE)
            {
                Method (_L04, 0, NotSerialized)
                {
                    \_SB.SLPB.SBEV ()
                }
            }

            Name (_PRW, Package (0x02)
            {
                0x04, 
                0x04
            })
        }

        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y1F, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y20, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y1F._MIN, MIN5)
            CreateDWordField (CRS, \_SB.PCI0._Y1F._MAX, MAX5)
            CreateDWordField (CRS, \_SB.PCI0._Y1F._LEN, LEN5)
            CreateDWordField (CRS, \_SB.PCI0._Y20._MIN, MIN6)
            CreateDWordField (CRS, \_SB.PCI0._Y20._MAX, MAX6)
            CreateDWordField (CRS, \_SB.PCI0._Y20._LEN, LEN6)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1B, MIN5)
                Store (MG1L, LEN5)
                Store (MG1L, Local0)
                If (Local0)
                {
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Add (MIN6, 0x00010000, MIN6)
                Store (MG2L, LEN6)
                Subtract (LEN6, 0x00010000, LEN6)
                Store (LEN6, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Return (CRS)
            }

            Method (_S3D, 0, NotSerialized)
            {
                If (LOr (LEqual (OSFL (), 0x01), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }
        }
    }

    Method (_PTS, 1, NotSerialized)
    {
        Store (Arg0, DBG8)
        Store (0x01, PLED)
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        If (LEqual (Arg0, 0x01))
        {
            While (WAKS)
            {
                Stall (0x50)
                Store (0x01, WAKS)
            }
        }
        Else
        {
            Store (0x00, SUST)
        }

        Store (\_SB.PCI0.MC97.MC9P, PTB0)
        Store (0x00, \_SB.PCI0.MC97.MC9P)
        Store (OSFL (), W2FG)
        Store (0x00, RTCX)
        Store (0x01, \_SB.SLPS)
        PTS (Arg0)
        Store (0x00, Index (WAKP, 0x00))
        Store (0x00, Index (WAKP, 0x01))
        Store (Arg0, SPLV)
        While (PS1S)
        {
            Stall (0x50)
            Store (0x01, PS1S)
        }

        Store (0x01, PS1E)
    }

    Method (_WAK, 1, NotSerialized)
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        Store (0x00, PLED)
        If (LEqual (Arg0, 0x03))
        {
            If (RTCX)
            {
                Notify (\_SB.PWRB, 0x02)
            }
        }
        Else
        {
            If (RTCX)
            {
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Store (0x01, PWBT)
        Store (PTB0, \_SB.PCI0.MC97.MC9P)
        Store (0x00, PS1E)
        Store (0x00, W2FG)
        Store (0x00, RTCX)
        Store (Zero, \_SB.PCI0.USB1.U184)
        Store (Zero, \_SB.PCI0.USB2.U284)
        Store (Zero, \_SB.PCI0.USB3.U384)
        Store (Zero, \_SB.PCI0.USB4.U484)
        Store (Zero, \_SB.PCI0.EHCI.U584)
        Store (0x00, \_SB.SLPS)
        WAK (Arg0)
        If (DerefOf (Index (WAKP, 0x00)))
        {
            Store (0x00, Index (WAKP, 0x01))
        }
        Else
        {
            Store (Arg0, Index (WAKP, 0x01))
        }

        Return (WAKP)
    }

    OperationRegion (PMS0, SystemIO, PMBS, 0x04)
    Field (PMS0, ByteAcc, NoLock, Preserve)
    {
            ,   10, 
        RTCS,   1, 
                Offset (0x03), 
        PWBT,   1, 
                Offset (0x04)
    }

    OperationRegion (IOTP, SystemIO, PM28, 0x04)
    Field (IOTP, ByteAcc, NoLock, Preserve)
    {
            ,   7, 
        WAKS,   1, 
            ,   7, 
        PS1S,   1, 
            ,   15, 
        PS1E,   1
    }

    OperationRegion (\_SB.PCI0.SBRG.PWCR, PCI_Config, 0x94, 0x04)
    Field (\_SB.PCI0.SBRG.PWCR, ByteAcc, NoLock, Preserve)
    {
        PLED,   2, 
            ,   2, 
        SUST,   1, 
                Offset (0x01)
    }

    OperationRegion (\_SB.PCI0.NBF4.BSR0, PCI_Config, 0xF4, 0x01)
    Field (\_SB.PCI0.NBF4.BSR0, ByteAcc, NoLock, Preserve)
    {
        SPLV,   3, 
        W2FG,   2, 
            ,   2, 
        RTCX,   1
    }

    Name (PTBF, Buffer (0x03)
    {
        /* 0000 */    0x00, 0x00, 0x00
    })
    CreateByteField (PTBF, 0x00, PTB0)
    CreateByteField (PTBF, 0x01, PTB1)
    CreateByteField (PTBF, 0x02, PTB2)
    Name (_S0, Package (0x04)
    {
        0x07, 
        0x00, 
        0x00, 
        0x00
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)
        {
            0x07, 
            0x00, 
            0x00, 
            0x00
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            0x07, 
            0x00, 
            0x00, 
            0x00
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x07, 
            0x00, 
            0x00, 
            0x00
        })
    }

    Name (_S5, Package (0x04)
    {
        0x07, 
        0x00, 
        0x00, 
        0x00
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.SBRG.SIOS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.SBRG.SIOW (Arg0)
    }
}

