/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20050902
 *
 * Disassembly of , Sun Jan 13 11:51:39 2008
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "A0498", "A0498000", 0)
{
    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (SPIO, 0x2E)
    Name (IOPB, 0x0C00)
    Name (IOPL, 0x10)
    Name (IOEB, 0x0D00)
    Name (IOEL, 0x10)
    Name (IOGB, 0x0A20)
    Name (IOGL, 0x10)
    Name (IODB, 0x0A30)
    Name (IODL, 0x10)
    Name (IO1B, 0x0A20)
    Name (IO1L, 0x08)
    Name (IO3B, 0x0D00)
    Name (IO3L, 0x80)
    Name (APIC, One)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (PM28, 0x0828)
    Name (PM5C, 0x085C)
    Name (GPBS, Zero)
    Name (GPLN, Zero)
    Name (SMBS, 0x0400)
    Name (SMBL, 0x20)
    Name (SUSW, 0x10)
    Name (PIHH, Zero)
    Name (PCIB, 0xE0000000)
    Name (PCIL, 0x10000000)
    OperationRegion (BIOS, SystemMemory, 0x3FFBE064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
        Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
        Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32, 
        SMIF,   8, 
        DTSE,   8, 
        DTS1,   8, 
        DTS2,   8, 
        MPEN,   8
    }

    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNot (LEqual (OSVR, Ones)))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, Zero))
        {
            Store (0xAC, DBG8)
        }

        Store (One, OSVR)
        If (CondRefOf (_OSI, Local1))
        {
            If (_OSI ("Windows 2001"))
            {
                Store (Zero, OSVR)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (0x04, OSVR)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x02, OSVR)
                }

                If (MCTH (_OS, "Linux"))
                {
                    Store (0x03, OSVR)
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNot (LEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (BUF1, Local0)))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, DP80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Scope (_PR)
    {
        Processor (P001, 0x01, 0x00000810, 0x06) {}
        Processor (P002, 0x02, 0x00000000, 0x00) {}
        Alias (P001, CPU1)
        Alias (P002, CPU2)
    }

    Scope (_SB)
    {
        Name (PR00, Package (0x15)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR00, Package (0x15)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x1B
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                Zero, 
                0x1B
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                Zero, 
                0x1B
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                Zero, 
                0x1B
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                Zero, 
                0x1F
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                Zero, 
                0x23
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                Zero, 
                0x27
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                Zero, 
                0x2B
            }, 

            Package (0x04)
            {
                0x000FFFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                Zero, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                One, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                0x02, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                0x03, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                Zero, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                One, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x02, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0010FFFF, 
                0x03, 
                Zero, 
                0x17
            }
        })
        Name (PR01, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR01, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR02, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR02, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x18
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x19
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x1A
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x1B
            }
        })
        Name (PR03, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR03, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x1C
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x1D
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x1E
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x1F
            }
        })
        Name (PR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x20
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x21
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x22
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x23
            }
        })
        Name (PR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x24
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x25
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x26
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x27
            }
        })
        Name (PR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x28
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x29
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x2A
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x2B
            }
        })
        Name (PR09, Package (0x01)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKB, 
                Zero
            }
        })
        Name (AR09, Package (0x01)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x11
            }
        })
        Name (PR0A, Package (0x10)
        {
            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                0x03, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x03, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR0A, Package (0x10)
        {
            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                0x03, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x03, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11,12,14,15}
        })
        Alias (PRSA, PRSB)
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))
            Name (_ADR, 0x00180000)
            Method (BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_PRW, 0, NotSerialized)
            {
                Return (GPRW (0x05, 0x04))
            }

            Method (_S3D, 0, NotSerialized)
            {
                If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (VIAN)
            {
                Name (_ADR, Zero)
            }

            Device (NBF1)
            {
                Name (_ADR, One)
            }

            Device (NBF2)
            {
                Name (_ADR, 0x02)
            }

            Device (NBF3)
            {
                Name (_ADR, 0x03)
            }

            Device (NBF4)
            {
                Name (_ADR, 0x04)
            }

            Device (NBF5)
            {
                Name (_ADR, 0x05)
            }

            Device (NBF6)
            {
                Name (_ADR, 0x06)
            }

            Device (NBF7)
            {
                Name (_ADR, 0x07)
            }

            Device (P0P1)
            {
                Name (_ADR, 0x00010000)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR01)
                    }

                    Return (PR01)
                }
            }

            Device (NBPG)
            {
                Name (_ADR, 0x00020000)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR02)
                    }

                    Return (PR02)
                }
            }

            Device (NBP0)
            {
                Name (_ADR, 0x00030000)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR03)
                    }

                    Return (PR03)
                }
            }

            Device (NBP1)
            {
                Name (_ADR, 0x00030001)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR04)
                    }

                    Return (PR04)
                }
            }

            Device (NBP2)
            {
                Name (_ADR, 0x00030002)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR05)
                    }

                    Return (PR05)
                }
            }

            Device (NBP3)
            {
                Name (_ADR, 0x00030003)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }

                    Return (PR06)
                }
            }

            Device (SATA)
            {
                Name (_ADR, 0x000F0000)
                Name (REGF, One)
                Name (TIM0, Package (0x04)
                {
                    Package (0x05)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x017F, 
                        0x0258
                    }, 

                    Package (0x05)
                    {
                        0x20, 
                        0x22, 
                        0x33, 
                        0x47, 
                        0x5D
                    }, 

                    Package (0x07)
                    {
                        0x78, 
                        0x50, 
                        0x3C, 
                        0x2D, 
                        0x1E, 
                        0x14, 
                        0x0F
                    }, 

                    Package (0x0F)
                    {
                        0x06, 
                        0x05, 
                        0x04, 
                        0x04, 
                        0x03, 
                        0x03, 
                        0x02, 
                        0x02, 
                        One, 
                        One, 
                        One, 
                        One, 
                        One, 
                        One, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                Name (PMPT, 0x20)
                Name (PMUE, 0x07)
                Name (PMUT, Zero)
                Name (PSPT, 0x20)
                Name (PSUE, 0x07)
                Name (PSUT, Zero)
                Name (SMPT, 0x20)
                Name (SMUE, 0x07)
                Name (SMUT, Zero)
                Name (SSPT, 0x20)
                Name (SSUE, 0x07)
                Name (SSUT, Zero)
                OperationRegion (SAPR, PCI_Config, Zero, 0x3C)
                Field (SAPR, ByteAcc, NoLock, Preserve)
                {
                    VID,    16, 
                    DID,    16, 
                    CMD,    3, 
                    Offset (0x0A), 
                    SCC,    8
                }

                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Method (_STA, 0, NotSerialized)
                {
                    If (LEqual (CMD, Zero))
                    {
                        Return (0x0D)
                    }
                    Else
                    {
                        Return (0x0F)
                    }
                }

                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (SCC, One))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (_GTM, 0, NotSerialized)
                    {
                        FZHD ()
                        Return (GTM (PMPT, PMUE, PMUT, PSPT, PSUE, PSUT))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (Zero)
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (Zero)
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (SCC, One))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (_GTM, 0, NotSerialized)
                    {
                        FZHD ()
                        Return (GTM (SMPT, SMUE, SMUT, SSPT, SSUE, SSUT))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (Zero)
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (Zero)
                        }
                    }
                }

                Method (GTM, 6, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg3, MTR, Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (Arg1)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Arg2)), Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local5)), DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (Arg4)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Arg5)), Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local5)), DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Return (TMD0)
                }
            }

            Device (PATA)
            {
                Name (_ADR, 0x000F0001)
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Name (TIM0, Package (0x08)
                {
                    Package (0x05)
                    {
                        0x3C, 
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x05)
                    {
                        0x11, 
                        0x20, 
                        0x31, 
                        0x65, 
                        0xA8
                    }, 

                    Package (0x10)
                    {
                        0x06, 
                        0x05, 
                        0x04, 
                        0x04, 
                        0x03, 
                        0x03, 
                        0x02, 
                        0x02, 
                        One, 
                        One, 
                        One, 
                        One, 
                        One, 
                        One, 
                        Zero, 
                        Zero
                    }, 

                    Package (0x07)
                    {
                        0x78, 
                        0x5A, 
                        0x3C, 
                        0x2D, 
                        0x1E, 
                        0x14, 
                        0x0F
                    }, 

                    Package (0x07)
                    {
                        0x0E, 
                        0x08, 
                        0x06, 
                        0x04, 
                        0x02, 
                        One, 
                        Zero
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x05)
                    {
                        0x05, 
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    Offset (0x08), 
                    SSPT,   8, 
                    SMPT,   8, 
                    PSPT,   8, 
                    PMPT,   8, 
                    Offset (0x10), 
                    SSUT,   4, 
                    SSCR,   1, 
                    SSUE,   3, 
                    SMUT,   4, 
                    SMCR,   1, 
                    SMUE,   3, 
                    PSUT,   4, 
                    PSCR,   1, 
                    PSUE,   3, 
                    PMUT,   4, 
                    PMCR,   1, 
                    PMUE,   3
                }

                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        FZHD ()
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        Return (GTM (PMPT, PMUE, PMUT, PSPT, PSUE, PSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (PMPT, GMPT)
                        Store (PMUE, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSPT, GSPT)
                        Store (PSUE, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMPT)
                        Store (GMUE, PMUE)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSPT, PSPT)
                        Store (GSUE, PSUE)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        FZHD ()
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        Return (GTM (SMPT, SMUE, SMUT, SSPT, SSUE, SSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (SMPT, GMPT)
                        Store (SMUE, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSPT, GSPT)
                        Store (SSUE, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMPT)
                        Store (GMUE, SMUE)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSPT, SSPT)
                        Store (GSUE, SSUE)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg3, MTR, Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (Arg1)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Arg2)), Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (Arg4)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Arg5)), Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF)
                    {
                        Store (Zero, GMUE)
                        Store (0x07, GMUT)
                        Store (Zero, GSUE)
                        Store (0x07, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, Zero, Zero), Local0)
                            If (LGreater (Local0, 0x06))
                            {
                                Store (0x06, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), GMUT)
                            Or (GMUE, 0x07, GMUE)
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                }
                            }
                        }

                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, Zero, Zero), Local0)
                            If (LGreater (Local0, 0x06))
                            {
                                Store (0x06, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), GSUT)
                            Or (GSUE, 0x07, GSUE)
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                }
                            }
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), Local1)
                        Store (Local1, GMPT)
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), Local1)
                        Store (Local1, GSPT)
                    }
                }

                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00)), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, Zero, Zero), Local1)
                        If (LGreater (Local1, 0x06))
                        {
                            Store (0x06, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0)), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0)), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (RETB)
                }
            }

            Device (SBRG)
            {
                Name (_ADR, 0x00110000)
                Method (SPTS, 1, NotSerialized)
                {
                    If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
                    {
                        Sleep (0x0BB8)
                    }

                    If (LEqual (Arg0, One))
                    {
                        While (WAKS)
                        {
                            Stall (0x50)
                            Store (One, WAKS)
                        }

                        While (LNot (LEqual (PADS, Zero)))
                        {
                            Store (PADS, PADS)
                        }

                        Store (One, IRQR)
                        Store (One, SUST)
                    }

                    If (LEqual (Arg0, 0x03))
                    {
                        Store (Zero, SUST)
                    }

                    Store (One, SLPS)
                    While (SLES)
                    {
                        Stall (0x50)
                        Store (One, SLES)
                    }

                    Store (One, SLEE)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    If (LAnd (LEqual (Arg0, 0x03), PM5D)) {}
                    Else
                    {
                        If (LAnd (LEqual (Arg0, One), PM5D)) {}
                        Else
                        {
                            Notify (PWRB, 0x02)
                        }
                    }

                    Store (Zero, PM5D)
                    Store (One, PWBT)
                    Store (Zero, SLEE)
                    Store (Zero, ^^USB1.U184)
                    Store (Zero, ^^USB2.U284)
                    Store (Zero, ^^USB3.U384)
                    Store (Zero, ^^USB4.U484)
                    Store (Zero, ^^EHCI.U584)
                    Store (Zero, SLPS)
                }

                OperationRegion (PMSR, SystemIO, PM5C, 0x02)
                Field (PMSR, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x01), 
                    PM5D,   1
                }

                OperationRegion (PMS0, SystemIO, PMBS, 0x04)
                Field (PMS0, ByteAcc, NoLock, Preserve)
                {
                        ,   10, 
                    RTCS,   1, 
                    Offset (0x03), 
                    PWBT,   1, 
                    Offset (0x04)
                }

                OperationRegion (IOTP, SystemIO, PM28, 0x04)
                Field (IOTP, ByteAcc, NoLock, Preserve)
                {
                        ,   7, 
                    WAKS,   1, 
                        ,   2, 
                    SLES,   1, 
                        ,   4, 
                    PS1S,   1, 
                        ,   10, 
                    SLEE,   1, 
                        ,   4, 
                    PS1E,   1
                }

                OperationRegion (PMGE, SystemIO, PMBS, 0x30)
                Field (PMGE, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x2A), 
                        ,   7, 
                    IRQR,   1
                }

                OperationRegion (PMPS, SystemIO, PMBS, 0x40)
                Field (PMPS, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x30), 
                        ,   1, 
                    PADS,   7
                }

                OperationRegion (HPRG, PCI_Config, 0x68, 0x04)
                Field (HPRG, ByteAcc, NoLock, Preserve)
                {
                        ,   7, 
                    HPTE,   1, 
                    HPTM,   24
                }

                OperationRegion (BSR0, PCI_Config, 0x6F, One)
                Field (BSR0, ByteAcc, NoLock, Preserve)
                {
                        ,   7, 
                    RTCX,   1
                }

                Name (PTBF, Buffer (0x03)
                {
                    0x00, 0x00, 0x00
                })
                CreateByteField (PTBF, One, PTB1)
                CreateByteField (PTBF, 0x02, PTB2)
                Scope (_SB)
                {
                    Name (SLPS, Zero)
                    Device (SLPB)
                    {
                        Name (_HID, EisaId ("PNP0C0E"))
                        Method (_STA, 0, NotSerialized)
                        {
                            If (LNot (LEqual (SUSW, 0xFF)))
                            {
                                Return (0x0F)
                            }

                            Return (Zero)
                        }

                        Method (SBEV, 0, NotSerialized)
                        {
                            If (SLPS)
                            {
                                Notify (SLPB, 0x02)
                            }
                            Else
                            {
                                Notify (SLPB, 0x80)
                            }
                        }

                        Method (_L04, 0, NotSerialized)
                        {
                            \_SB.SLPB.SBEV ()
                        }

                        Method (_PRW, 0, NotSerialized)
                        {
                            Return (Package (0x02)
                            {
                                0x04, 
                                0x04
                            })
                        }
                    }
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0020, 0x0020, 0x00, 0x02)
                        IO (Decode16, 0x00A0, 0x00A0, 0x00, 0x02)
                        IRQNoFlags () {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8) {4}
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x10)
                        IO (Decode16, 0x0081, 0x0081, 0x00, 0x03)
                        IO (Decode16, 0x0087, 0x0087, 0x00, 0x01)
                        IO (Decode16, 0x0089, 0x0089, 0x00, 0x03)
                        IO (Decode16, 0x008F, 0x008F, 0x00, 0x01)
                        IO (Decode16, 0x00C0, 0x00C0, 0x00, 0x20)
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0061, 0x0061, 0x00, 0x01)
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x00F0, 0x00F0, 0x00, 0x10)
                        IRQNoFlags () {13}
                    })
                }

                Device (FDC)
                {
                    Name (_HID, EisaId ("PNP0700"))
                    Method (_FDE, 0, NotSerialized)
                    {
                        Name (FDEP, Package (0x05)
                        {
                            Zero, 
                            Zero, 
                            0x02, 
                            0x02, 
                            0x02
                        })
                        If (_STA ())
                        {
                            Store (One, Index (FDEP, Zero))
                        }

                        Return (FDEP)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x03))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x03, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x03, One)
                        Store (IRQM, IRQE)
                        Store (DMAM, DMAE)
                        Store (IO11, IO21)
                        Store (IO12, IO22)
                        Store (0x06, LEN2)
                        Add (IO21, 0x07, IO31)
                        Store (IO31, IO32)
                        Store (One, LEN3)
                        Return (CRS2)
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x03)
                        CreateWordField (Arg0, 0x11, IRQE)
                        CreateByteField (Arg0, 0x14, DMAE)
                        ENFG (CGLD (0x03))
                        If (IRQE)
                        {
                            FindSetRightBit (IRQE, Local0)
                            Subtract (Local0, One, INTR)
                        }
                        Else
                        {
                            Store (Zero, INTR)
                        }

                        If (DMAE)
                        {
                            FindSetRightBit (DMAE, Local0)
                            Subtract (Local0, One, DMCH)
                        }
                        Else
                        {
                            Store (0x04, DMCH)
                        }

                        EXFG ()
                    }

                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16, 0x03F0, 0x03F0, 0x01, 0x06)
                            IO (Decode16, 0x03F7, 0x03F7, 0x01, 0x01)
                            IRQNoFlags () {6}
                            DMA (Compatibility, NotBusMaster, Transfer8) {2}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03F0, 0x03F0, 0x01, 0x06)
                            IO (Decode16, 0x03F7, 0x03F7, 0x01, 0x01)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0370, 0x0370, 0x01, 0x06)
                            IO (Decode16, 0x0377, 0x0377, 0x01, 0x01)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }

                Device (LPTE)
                {
                    Method (_HID, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (0x0104D041)
                        }
                        Else
                        {
                            Return (0x0004D041)
                        }
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x02))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x02, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x02, One)
                        If (LPTM (0x02))
                        {
                            Store (IRQM, IRQE)
                            Store (DMAM, DMAE)
                            Store (IO11, IO21)
                            Store (IO12, IO22)
                            Store (LEN1, LEN2)
                            Add (IO21, 0x0400, IO31)
                            Store (IO31, IO32)
                            Store (LEN2, LEN3)
                            Return (CRS2)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x02)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (EPPR)
                        }
                        Else
                        {
                            Return (LPPR)
                        }
                    }

                    Name (LPPR, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03BC, 0x03BC, 0x01, 0x04)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        EndDependentFn ()
                    })
                    Name (EPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IO (Decode16, 0x0778, 0x0778, 0x01, 0x08)
                            IRQNoFlags () {7}
                            DMA (Compatibility, NotBusMaster, Transfer8) {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IO (Decode16, 0x0778, 0x0778, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IO (Decode16, 0x0678, 0x0678, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03BC, 0x03BC, 0x01, 0x04)
                            IO (Decode16, 0x07BC, 0x07BC, 0x01, 0x04)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }

                Device (SIOR)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Method (_UID, 0, NotSerialized)
                    {
                        Return (SPIO)
                    }

                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LAnd (LNot (LEqual (SPIO, 0x03F0)), LGreater (SPIO, 0xF0)))
                        {
                            CreateWordField (CRS, 0x02, GP10)
                            CreateWordField (CRS, 0x04, GP11)
                            CreateByteField (CRS, 0x07, GPL1)
                            Store (SPIO, GP10)
                            Store (SPIO, GP11)
                            Store (0x02, GPL1)
                        }

                        If (IOPB)
                        {
                            CreateWordField (CRS, 0x0A, GP20)
                            CreateWordField (CRS, 0x0C, GP21)
                            CreateByteField (CRS, 0x0F, GPL2)
                            Store (IOPB, GP20)
                            Store (IOPB, GP21)
                            Store (IOPL, GPL2)
                        }

                        If (IOEB)
                        {
                            CreateWordField (CRS, 0x12, GP30)
                            CreateWordField (CRS, 0x14, GP31)
                            CreateByteField (CRS, 0x17, GPL3)
                            Store (IOEB, GP30)
                            Store (IOEB, GP31)
                            Store (IOEL, GPL3)
                        }

                        If (IOGB)
                        {
                            CreateWordField (CRS, 0x1A, GP40)
                            CreateWordField (CRS, 0x1C, GP41)
                            CreateByteField (CRS, 0x1F, GPL4)
                            Store (IOGB, GP40)
                            Store (IOGB, GP41)
                            Store (IOGL, GPL4)
                        }

                        If (IODB)
                        {
                            CreateWordField (CRS, 0x22, GP50)
                            CreateWordField (CRS, 0x24, GP51)
                            CreateByteField (CRS, 0x27, GPL5)
                            Store (IODB, GP50)
                            Store (IODB, GP51)
                            Store (IODL, GPL5)
                        }

                        Return (CRS)
                    }
                }

                Name (DCAT, Package (0x16)
                {
                    One, 
                    0x02, 
                    0x03, 
                    Zero, 
                    0xFF, 
                    0x08, 
                    0xFF, 
                    0xFF, 
                    0x09, 
                    0xFF, 
                    0x05, 
                    0x04, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0x0A, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF
                })
                Name (IKEY, Package (0x02)
                {
                    Package (0x04)
                    {
                        0x87, 
                        One, 
                        0x55, 
                        0x55
                    }, 

                    Package (0x04)
                    {
                        0x87, 
                        One, 
                        0x55, 
                        0xAA
                    }
                })
                Name (KBFG, One)
                Name (MSFG, One)
                Name (UR1F, One)
                Method (ENFG, 1, NotSerialized)
                {
                    Store (Zero, Local1)
                    If (LEqual (SPIO, 0x2E))
                    {
                        Store (Zero, Local1)
                    }

                    If (LEqual (SPIO, 0x4E))
                    {
                        Store (One, Local1)
                    }

                    Store (Zero, Local0)
                    While (LNot (LEqual (Local0, 0x04)))
                    {
                        Store (DerefOf (Index (DerefOf (Index (IKEY, Local1)), Local0)), INDX)
                        Increment (Local0)
                    }

                    Store (Arg0, LDN)
                }

                Method (ENTR, 0, NotSerialized)
                {
                    Store (0x87, INDX)
                    Store (One, INDX)
                    Store (0x55, INDX)
                    If (LEqual (SPIO, 0x2E))
                    {
                        Store (0x55, INDX)
                    }
                    Else
                    {
                        Store (0xAA, INDX)
                    }
                }

                Method (EXFG, 0, NotSerialized)
                {
                    Store (0x02, INDX)
                    Store (0x02, DATA)
                }

                Method (LPTM, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    And (OPT0, 0x02, Local0)
                    EXFG ()
                    Return (Local0)
                }

                Method (UHID, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    And (OPT0, 0x70, Local0)
                    EXFG ()
                    If (Local0)
                    {
                        Return (0x1005D041)
                    }

                    Return (0x0105D041)
                }

                Method (ORF0, 1, NotSerialized)
                {
                    ENTR ()
                    Or (OPT0, Arg0, OPT0)
                    EXFG ()
                }

                Method (ORF1, 1, NotSerialized)
                {
                    ENTR ()
                    Or (OPT1, Arg0, OPT1)
                    EXFG ()
                }

                Method (ORF2, 1, NotSerialized)
                {
                    ENTR ()
                    Or (OPT2, Arg0, OPT2)
                    EXFG ()
                }

                Method (ANF0, 1, NotSerialized)
                {
                    ENTR ()
                    And (OPT0, Arg0, OPT0)
                    EXFG ()
                }

                Method (ANF2, 1, NotSerialized)
                {
                    ENTR ()
                    And (OPT2, Arg0, OPT2)
                    EXFG ()
                }

                Method (ANF4, 1, NotSerialized)
                {
                    ENTR ()
                    And (OPT4, Arg0, OPT4)
                    EXFG ()
                }

                Method (STF0, 1, NotSerialized)
                {
                    ENTR ()
                    Store (Arg0, OPT0)
                    EXFG ()
                }

                Method (STF1, 1, NotSerialized)
                {
                    ENTR ()
                    Store (Arg0, OPT1)
                    EXFG ()
                }

                Method (SIOS, 1, NotSerialized)
                {
                    Store ("SIOS", Debug)
                    Store (Zero, GP10)
                    If (LLess (Arg0, 0x05))
                    {
                        ENFG (0x04)
                        Store (One, ACTR)
                        EXFG ()
                        ANF4 (0xFC)
                        ORF1 (0x18)
                        If (KBFG)
                        {
                            ORF0 (0x08)
                        }
                        Else
                        {
                            ANF0 (0xF7)
                        }

                        If (MSFG)
                        {
                            ORF0 (0x10)
                        }
                        Else
                        {
                            ANF0 (0xEF)
                            ENFG (0x06)
                            Store (Zero, ACTR)
                            EXFG ()
                        }

                        ENFG (0x04)
                        ANF2 (0xF0)
                        ENFG (0x07)
                        And (OPF9, 0xFE, OPF9)
                        And (OPC0, 0xFE, OPC0)
                        And (OPC3, 0xFE, OPC3)
                        And (OP29, 0xEF, OP29)
                        EXFG ()
                    }
                    Else
                    {
                        ENFG (0x07)
                        And (OPC0, Zero, OPC0)
                        Or (OPC0, One, OPC0)
                        And (OPC3, Zero, OPC3)
                        Or (OPC3, One, OPC3)
                        Or (OPF9, One, OPF9)
                        And (OP29, 0xEF, OP29)
                        EXFG ()
                    }
                }

                Method (SIOW, 1, NotSerialized)
                {
                    Store (One, GP10)
                    Store (One, GP40)
                    Store ("SIOW", Debug)
                    ENFG (0x04)
                    Store (Zero, ACTR)
                    EXFG ()
                    STF0 (Zero)
                    STF1 (0xFF)
                    ENFG (0x07)
                    Or (OP29, 0x10, OP29)
                    Or (OPC0, One, OPC0)
                    Or (OPC3, One, OPC3)
                    EXFG ()
                    ENFG (0x05)
                    Or (ACTR, One, ACTR)
                    EXFG ()
                    ENFG (0x06)
                    Or (ACTR, One, ACTR)
                    EXFG ()
                    ENFG (0x04)
                    Store (One, ACTR)
                    EXFG ()
                }

                Method (SIOH, 0, NotSerialized)
                {
                    Store ("SIOH", Debug)
                }

                OperationRegion (IOID, SystemIO, SPIO, 0x02)
                Field (IOID, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x07), 
                    LDN,    8, 
                    Offset (0x29), 
                    OP29,   8, 
                    Offset (0x30), 
                    ACTR,   8, 
                    Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IOH2,   8, 
                    IOL2,   8, 
                    Offset (0x70), 
                    INTR,   8, 
                    Offset (0x74), 
                    DMCH,   8, 
                    Offset (0xC0), 
                    OPC0,   8, 
                    OPC1,   8, 
                    OPC2,   8, 
                    OPC3,   8, 
                    Offset (0xF0), 
                    OPT0,   8, 
                    OPT1,   8, 
                    OPT2,   8, 
                    OPT3,   8, 
                    OPT4,   8, 
                    Offset (0xF8), 
                    OPF8,   8, 
                    OPF9,   8, 
                    OPFA,   8, 
                    OPFB,   8
                }

                Method (CGLD, 1, NotSerialized)
                {
                    Return (DerefOf (Index (DCAT, Arg0)))
                }

                Method (DSTA, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    Store (ACTR, Local0)
                    EXFG ()
                    If (LEqual (Local0, 0xFF))
                    {
                        Return (Zero)
                    }

                    And (Local0, One, Local0)
                    Or (IOST, ShiftLeft (Local0, Arg0), IOST)
                    If (Local0)
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        If (And (ShiftLeft (One, Arg0), IOST))
                        {
                            Return (0x0D)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }
                }

                Method (DCNT, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, Local1)
                    Or (IOAL, Local1, Local1)
                    RRIO (Arg0, Arg1, Local1, 0x08)
                    If (LAnd (LLess (DMCH, 0x04), LNot (LEqual (And (DMCH, 0x03, Local1), Zero))))
                    {
                        RDMA (Arg0, Arg1, Increment (Local1))
                    }

                    Store (Arg1, ACTR)
                    EXFG ()
                }

                Name (CRS1, ResourceTemplate ()
                {
                    IO (Decode16, 0x0000, 0x0000, 0x01, 0x00)
                    IRQNoFlags () {}
                    DMA (Compatibility, NotBusMaster, Transfer8) {}
                })
                CreateWordField (CRS1, 0x09, IRQM)
                CreateByteField (CRS1, 0x0C, DMAM)
                CreateWordField (CRS1, 0x02, IO11)
                CreateWordField (CRS1, 0x04, IO12)
                CreateByteField (CRS1, 0x07, LEN1)
                Name (CRS2, ResourceTemplate ()
                {
                    IO (Decode16, 0x0000, 0x0000, 0x01, 0x00)
                    IO (Decode16, 0x0000, 0x0000, 0x01, 0x00)
                    IRQNoFlags () {6}
                    DMA (Compatibility, NotBusMaster, Transfer8) {2}
                })
                CreateWordField (CRS2, 0x11, IRQE)
                CreateByteField (CRS2, 0x14, DMAE)
                CreateWordField (CRS2, 0x02, IO21)
                CreateWordField (CRS2, 0x04, IO22)
                CreateByteField (CRS2, 0x07, LEN2)
                CreateWordField (CRS2, 0x0A, IO31)
                CreateWordField (CRS2, 0x0C, IO32)
                CreateByteField (CRS2, 0x0F, LEN3)
                Method (DCRS, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, IO11)
                    Or (IOAL, IO11, IO11)
                    Store (IO11, IO12)
                    Subtract (FindSetRightBit (IO11), One, Local0)
                    ShiftLeft (One, Local0, LEN1)
                    If (INTR)
                    {
                        ShiftLeft (One, INTR, IRQM)
                    }
                    Else
                    {
                        Store (Zero, IRQM)
                    }

                    If (LOr (LGreater (DMCH, 0x03), LEqual (Arg1, Zero)))
                    {
                        Store (Zero, DMAM)
                    }
                    Else
                    {
                        And (DMCH, 0x03, Local1)
                        ShiftLeft (One, Local1, DMAM)
                    }

                    EXFG ()
                    Return (CRS1)
                }

                Method (DSRS, 2, NotSerialized)
                {
                    CreateWordField (Arg0, 0x09, IRQM)
                    CreateByteField (Arg0, 0x0C, DMAM)
                    CreateWordField (Arg0, 0x02, IO11)
                    ENFG (CGLD (Arg1))
                    And (IO11, 0xFF, IOAL)
                    ShiftRight (IO11, 0x08, IOAH)
                    If (IRQM)
                    {
                        FindSetRightBit (IRQM, Local0)
                        Subtract (Local0, One, INTR)
                    }
                    Else
                    {
                        Store (Zero, INTR)
                    }

                    If (DMAM)
                    {
                        FindSetRightBit (DMAM, Local0)
                        Subtract (Local0, One, DMCH)
                    }
                    Else
                    {
                        Store (0x04, DMCH)
                    }

                    EXFG ()
                    DCNT (Arg1, One)
                }

                OperationRegion (GPIO, SystemIO, IO1B, 0x04)
                Field (GPIO, ByteAcc, NoLock, Preserve)
                {
                    GP10,   1, 
                    GP11,   1, 
                    GP12,   1, 
                    GP13,   1, 
                    GO14,   1, 
                    GO15,   1, 
                    GO16,   1, 
                    GO17,   1, 
                    GP20,   1, 
                    GP21,   1, 
                    GP22,   1, 
                    GP23,   1, 
                    GO24,   1, 
                    GO25,   1, 
                    GO26,   1, 
                    GO27,   1, 
                    GP30,   1, 
                    GP31,   1, 
                    GP32,   1, 
                    GP33,   1, 
                    GO34,   1, 
                    GO35,   1, 
                    GO36,   1, 
                    GO37,   1, 
                    GP40,   1, 
                    GP41,   1, 
                    GP42,   1, 
                    GP43,   1, 
                    GO44,   1, 
                    GO45,   1, 
                    GO46,   1, 
                    GO47,   1
                }

                Device (NBRM)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x99)
                    Name (CRS, ResourceTemplate ()
                    {
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (CRS)
                    }
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0010, 0x0010, 0x00, 0x10)
                        IO (Decode16, 0x0022, 0x0022, 0x00, 0x1E)
                        IO (Decode16, 0x0044, 0x0044, 0x00, 0x1C)
                        IO (Decode16, 0x0062, 0x0062, 0x00, 0x02)
                        IO (Decode16, 0x0065, 0x0065, 0x00, 0x0B)
                        IO (Decode16, 0x0072, 0x0072, 0x00, 0x0E)
                        IO (Decode16, 0x0080, 0x0080, 0x00, 0x01)
                        IO (Decode16, 0x0084, 0x0084, 0x00, 0x03)
                        IO (Decode16, 0x0088, 0x0088, 0x00, 0x01)
                        IO (Decode16, 0x008C, 0x008C, 0x00, 0x03)
                        IO (Decode16, 0x0090, 0x0090, 0x00, 0x10)
                        IO (Decode16, 0x00A2, 0x00A2, 0x00, 0x1E)
                        IO (Decode16, 0x00E0, 0x00E0, 0x00, 0x10)
                        IO (Decode16, 0x03E0, 0x03E0, 0x00, 0x08)
                        IO (Decode16, 0x04D0, 0x04D0, 0x00, 0x02)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x00, 0x00)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, 0x7A, GP00)
                        CreateWordField (CRS, 0x7C, GP01)
                        CreateByteField (CRS, 0x7F, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, 0x82, GP10)
                            CreateWordField (CRS, 0x84, GP11)
                            CreateByteField (CRS, 0x87, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, 0x8A, GP20)
                            CreateWordField (CRS, 0x8C, GP21)
                            CreateByteField (CRS, 0x8F, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }

                        Return (CRS)
                    }
                }

                Scope (SBRG)
                {
                    Device (ASOC)
                    {
                        Name (_HID, "ATK0110")
                        Name (_UID, 0x01010110)
                        Method (_STA, 0, NotSerialized)
                        {
                            Return (0x0F)
                        }

                        Name (MBIF, Package (0x08)
                        {
                            One, 
                            "M2V", 
                            One, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Method (ASIF, 0, NotSerialized)
                        {
                            Return (MBIF)
                        }
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (_UID, Zero)
                    Name (CRS0, ResourceTemplate ()
                    {
                    })
                    Name (CRS1, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly, 0x00000000, 0x00000000)
                        IRQNoFlags () {0}
                        IRQNoFlags () {8}
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LNot (LEqual (HPTE, One)))
                        {
                            Return (Zero)
                        }
                        Else
                        {
                            Return (0x0F)
                        }
                    }

                    OperationRegion (DBHP, SystemIO, 0x98, 0x04)
                    Field (DBHP, DWordAcc, NoLock, Preserve)
                    {
                        DB98,   32
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS1, 0x04, BAS1)
                        CreateDWordField (CRS1, 0x08, LEN1)
                        If (LNot (LEqual (HPTE, One)))
                        {
                            Return (CRS0)
                        }
                        Else
                        {
                            ShiftLeft (HPTM, 0x08, DB98)
                            ShiftLeft (HPTM, 0x08, BAS1)
                            Store (0x0400, LEN1)
                            Return (CRS1)
                        }
                    }
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (CRS0, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0040, 0x0040, 0x00, 0x04)
                        IRQNoFlags () {0}
                    })
                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0040, 0x0040, 0x00, 0x04)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LNot (LEqual (HPTE, One)))
                        {
                            Return (CRS0)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (CRS0, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0070, 0x0070, 0x00, 0x02)
                        IRQNoFlags () {8}
                    })
                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0070, 0x0070, 0x00, 0x02)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LNot (LEqual (HPTE, One)))
                        {
                            Return (CRS0)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }
                }

                Scope (\)
                {
                    OperationRegion (RAMW, SystemMemory, Subtract (TOPM, 0x00010000), 0x00010000)
                    Field (RAMW, ByteAcc, NoLock, Preserve)
                    {
                        PAR0,   32, 
                        PAR1,   32
                    }

                    OperationRegion (IOB2, SystemIO, 0x082F, 0x02)
                    Field (IOB2, ByteAcc, NoLock, Preserve)
                    {
                        SMIC,   8, 
                        SMIS,   8
                    }

                    Method (ISMI, 1, Serialized)
                    {
                        Store (Arg0, SMIC)
                    }

                    Method (GNVS, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x70)
                        Return (PAR1)
                    }

                    Method (SNVS, 2, Serialized)
                    {
                        Store (Arg0, PAR0)
                        Store (Arg1, PAR1)
                        ISMI (0x71)
                    }
                }

                Scope (\)
                {
                    Field (RAMW, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0x28), 
                        AWEN,   1
                    }
                }

                Scope (_SB)
                {
                    Device (AWY)
                    {
                        Name (_HID, "AWY0001")
                        Method (SMOD, 1, NotSerialized)
                        {
                        }

                        Method (_STA, 0, NotSerialized)
                        {
                            If (AWEN)
                            {
                                Return (0x0F)
                            }

                            Return (Zero)
                        }
                    }
                }

                Device (PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly, 0xE0000000, 0x10000000)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, 0x04, BAS1)
                        CreateDWordField (CRS, 0x08, LEN1)
                        Store (PCIB, BAS1)
                        Store (PCIL, LEN1)
                        Return (CRS)
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, Zero)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly, 0x00000000, 0x00000000)
                        Memory32Fixed (ReadOnly, 0x00000000, 0x00000000)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, 0x08, ML01)
                            CreateDWordField (CRS, 0x04, MB01)
                            CreateDWordField (CRS, 0x14, ML02)
                            CreateDWordField (CRS, 0x10, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                        }

                        Return (CRS)
                    }
                }

                Device (RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, One)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite, 0x00000000, 0x000A0000)
                        Memory32Fixed (ReadOnly, 0x00000000, 0x00000000)
                        Memory32Fixed (ReadOnly, 0x000E0000, 0x00020000)
                        Memory32Fixed (ReadWrite, 0x00100000, 0x00000000)
                        Memory32Fixed (ReadOnly, 0x00000000, 0x00000000)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, 0x10, BAS1)
                        CreateDWordField (CRS, 0x14, LEN1)
                        CreateDWordField (CRS, 0x1C, BAS2)
                        CreateDWordField (CRS, 0x20, LEN2)
                        CreateDWordField (CRS, 0x2C, LEN3)
                        CreateDWordField (CRS, 0x34, BAS4)
                        CreateDWordField (CRS, 0x38, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Add (MG2B, MG2L, BAS4)
                        Subtract (Zero, BAS4, LEN4)
                        Return (CRS)
                    }
                }

                Device (UAR1)
                {
                    Name (_UID, One)
                    Method (_HID, 0, NotSerialized)
                    {
                        Return (UHID (Zero))
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (Zero))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (Zero, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (DCRS (Zero, One))
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, Zero)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        Return (CMPR)
                    }

                    Name (CMPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16, 0x03F8, 0x03F8, 0x01, 0x08)
                            IRQNoFlags () {4}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03F8, 0x03F8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x02F8, 0x02F8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03E8, 0x03E8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x02E8, 0x02E8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03F8, 0x03F8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x02F8, 0x02F8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03E8, 0x03E8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x02E8, 0x02E8, 0x01, 0x08)
                            IRQNoFlags () {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x08, 0x04))
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, 0x0B03D041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0060, 0x0060, 0x00, 0x01)
                        IO (Decode16, 0x0064, 0x0064, 0x00, 0x01)
                        IRQNoFlags () {1}
                    })
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x02, 0x04))
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))
                    Name (_CID, 0x130FD041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IRQNoFlags () {12}
                    })
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }

            Device (SVLK)
            {
                Name (_ADR, 0x00110007)
            }

            Device (P0P9)
            {
                Name (_ADR, 0x00130000)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR09)
                    }

                    Return (PR09)
                }

                Device (HDAC)
                {
                    Name (_ADR, 0x00010000)
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x00100000)
                OperationRegion (WAU1, PCI_Config, 0x84, One)
                Field (WAU1, ByteAcc, NoLock, Preserve)
                {
                    U184,   8
                }

                OperationRegion (U1D3, PCI_Config, 0x49, One)
                Field (U1D3, ByteAcc, NoLock, Preserve)
                {
                    UR49,   3
                }

                OperationRegion (UBP1, PCI_Config, 0x85, One)
                Field (UBP1, ByteAcc, NoLock, Preserve)
                {
                    U1PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x00100001)
                OperationRegion (WAU2, PCI_Config, 0x84, One)
                Field (WAU2, ByteAcc, NoLock, Preserve)
                {
                    U284,   8
                }

                OperationRegion (UBP2, PCI_Config, 0x85, One)
                Field (UBP2, ByteAcc, NoLock, Preserve)
                {
                    U2PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x00100002)
                OperationRegion (WAU3, PCI_Config, 0x84, One)
                Field (WAU3, ByteAcc, NoLock, Preserve)
                {
                    U384,   8
                }

                OperationRegion (UBP3, PCI_Config, 0x85, One)
                Field (UBP3, ByteAcc, NoLock, Preserve)
                {
                    U3PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB4)
            {
                Name (_ADR, 0x00100003)
                OperationRegion (WAU4, PCI_Config, 0x84, One)
                Field (WAU4, ByteAcc, NoLock, Preserve)
                {
                    U484,   8
                }

                OperationRegion (UBP4, PCI_Config, 0x85, One)
                Field (UBP4, ByteAcc, NoLock, Preserve)
                {
                    U4PE,   1
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (EHCI)
            {
                Name (_ADR, 0x00100004)
                OperationRegion (WAU5, PCI_Config, 0x84, One)
                Field (WAU5, ByteAcc, NoLock, Preserve)
                {
                    U584,   8
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (P0PA)
            {
                Name (_ADR, 0x00130001)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x05, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR0A)
                    }

                    Return (PR0A)
                }

                Device (PCI1)
                {
                    Name (_ADR, 0x00060000)
                    Method (_PRW, 0, NotSerialized)
                    {
                        Return (GPRW (0x05, 0x04))
                    }
                }

                Device (PCI2)
                {
                    Name (_ADR, 0x00070000)
                    Method (_PRW, 0, NotSerialized)
                    {
                        Return (GPRW (0x05, 0x04))
                    }
                }

                Device (PCI3)
                {
                    Name (_ADR, 0x00080000)
                    Method (_PRW, 0, NotSerialized)
                    {
                        Return (GPRW (0x05, 0x04))
                    }
                }

                Device (PCI4)
                {
                    Name (_ADR, 0x00090000)
                    Method (_PRW, 0, NotSerialized)
                    {
                        Return (GPRW (0x05, 0x04))
                    }
                }
            }
        }

        Scope (_GPE)
        {
            Method (_L05, 0, NotSerialized)
            {
                Notify (\_SB.PCI0, 0x02)
                Notify (\_SB.PCI0.P0PA, 0x02)
                Notify (\_SB.PCI0.P0PA.PCI1, 0x02)
                Notify (\_SB.PCI0.P0PA.PCI2, 0x02)
                Notify (\_SB.PCI0.P0PA.PCI3, 0x02)
                Notify (\_SB.PCI0.P0PA.PCI4, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L08, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L02, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L09, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L0E, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB1, 0x02)
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PCI0.USB4, 0x02)
                Notify (\_SB.PCI0.EHCI, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
        }
    }

    Scope (_SB)
    {
        OperationRegion (PIX0, PCI_Config, 0x55, 0x04)
        OperationRegion (PIX1, PCI_Config, 0x50, 0x02)
        OperationRegion (PIX2, PCI_Config, 0x44, 0x02)
        OperationRegion (PIX3, PCI_Config, 0x67, 0x03)
        OperationRegion (PIX4, PCI_Config, 0x6C, 0x04)
        Field (PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
        {
                ,   4, 
            PIRA,   4, 
            PIRB,   4, 
            PIRC,   4, 
                ,   4, 
            PIRD,   4, 
                ,   4
        }

        Field (PCI0.SBRG.PIX1, ByteAcc, NoLock, Preserve)
        {
                ,   1, 
            EP3C,   1, 
            EN3C,   1, 
                ,   6, 
            KBFG,   1
        }

        Field (PCI0.SBRG.PIX2, ByteAcc, NoLock, Preserve)
        {
            PIRE,   4, 
            PIRF,   4, 
            PIRG,   4, 
            PIRH,   4
        }

        Field (PCI0.SBRG.PIX3, ByteAcc, NoLock, Preserve)
        {
            ENIR,   1, 
            IRSD,   1, 
            Offset (0x02), 
            IRBA,   8
        }

        Field (PCI0.SBRG.PIX4, ByteAcc, NoLock, Preserve)
        {
            PS0E,   1, 
            PS1E,   1, 
            ROME,   1, 
            APCE,   1, 
            LPMS,   2, 
            MSEN,   1, 
            IXEN,   1, 
            LPMD,   2, 
            MDEN,   1, 
            GMEN,   1, 
            LPLP,   2, 
            LPEN,   1, 
            FDEN,   1, 
            LPCA,   3, 
            CAEN,   1, 
            LPCB,   3, 
            CBEN,   1, 
            LPSB,   2, 
            SBEN,   1, 
            FDSE,   1, 
            Offset (0x04)
        }

        OperationRegion (PIEF, PCI_Config, 0x46, One)
        Field (PCI0.SBRG.PIEF, ByteAcc, NoLock, Preserve)
        {
            POLE,   1, 
            POLF,   1, 
            POLG,   1, 
            POLH,   1, 
            ENR8,   1
        }

        Name (IRQA, Zero)
        Name (IRQB, Zero)
        Name (IRQC, Zero)
        Name (IRQD, Zero)
        Name (IRQE, Zero)
        Name (IRQF, Zero)
        Name (IRQG, Zero)
        Name (IRQH, Zero)
        Name (ICRS, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared) {15}
        })
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRA, IRQA)
                If (PIRA)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQA, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
                Store (PIRA, IRQA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRB, IRQB)
                If (PIRB)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQB, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
                Store (PIRB, IRQB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRC, IRQC)
                If (PIRC)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQC, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
                Store (PIRC, IRQC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRD, IRQD)
                If (PIRD)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQD, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
                Store (PIRD, IRQD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRE, IRQE)
                If (PIRE)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRE)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQE, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
                Store (PIRE, IRQE)
                Store (One, ENR8)
                Store (Zero, POLE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRF, IRQF)
                If (PIRF)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRF)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQF, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
                Store (PIRF, IRQF)
                Store (One, ENR8)
                Store (Zero, POLF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRG, IRQG)
                If (PIRG)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRG)
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQG, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
                Store (PIRG, IRQG)
                Store (One, ENR8)
                Store (Zero, POLG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                Store (PIRH, IRQH)
                If (PIRH)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (Zero, PIRH)
                If (LEqual (PIHH, One))
                {
                    Store (Zero, POLH)
                }
            }

            Method (_CRS, 0, NotSerialized)
            {
                CreateWordField (ICRS, One, IRA0)
                Store (One, Local1)
                ShiftLeft (Local1, IRQH, IRA0)
                Return (ICRS)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
                Store (PIRH, IRQH)
                Store (One, ENR8)
                If (LEqual (PIHH, One))
                {
                    Store (One, POLH)
                }
                Else
                {
                    Store (Zero, POLH)
                }
            }
        }
    }

    Scope (_SB)
    {
        Name (XCPD, Zero)
        Name (XNPT, One)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x0FFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }

        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (RDPE (Local0), Local1)
            If (LEqual (Local1, Ones))
            {
                Return (Zero)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    WDPE (Local0, And (Local1, 0x00010000))
                    Return (One)
                }

                Return (Zero)
            }
        }
    }

    Name (HBAS, Zero)
    Name (HLBA, Zero)
    Name (HDEV, Zero)
    OperationRegion (REFP, SystemIO, 0x61, One)
    Field (REFP, ByteAcc, NoLock, Preserve)
    {
        P061,   8
    }

    Method (FZHD, 0, NotSerialized)
    {
        Store (0x80, Local0)
        Store (DMAX, Local1)
        While (LNot (LGreater (Local0, Local1)))
        {
            And (Local0, 0x7F, Local3)
            Store (One, Local2)
            ShiftLeft (Local2, Local3, Local2)
            If (LNot (And (\_SB.PCI0.HFZF, Local2)))
            {
                If (FZOD (Local0))
                {
                    Or (\_SB.PCI0.HFZF, Local2, \_SB.PCI0.HFZF)
                }
            }

            Increment (Local0)
        }
    }

    Method (FZOD, 1, NotSerialized)
    {
        GHET (Arg0)
        If (LEqual (HBAS, Zero))
        {
            Return (One)
        }

        If (LEqual (HDEV, Zero))
        {
            Return (One)
        }

        Store (HDEV, Local1)
        And (Local1, 0x10, Local1)
        If (LEqual (Local1, Zero))
        {
            Return (One)
        }

        WFCF ()
        SDRV ()
        Add (HBAS, 0x07, Local1)
        OperationRegion (HRGS, SystemIO, Local1, One)
        Field (HRGS, ByteAcc, NoLock, Preserve)
        {
            SREG,   8
        }

        Store (SREG, Local1)
        And (Local1, 0x80, Local1)
        If (Local1)
        {
            Return (Zero)
        }

        Add (HBAS, 0x07, Local1)
        OperationRegion (HRGC, SystemIO, Local1, One)
        Field (HRGC, ByteAcc, NoLock, Preserve)
        {
            CREG,   8
        }

        Store (0xF5, CREG)
        If (WFCF ())
        {
            Add (HBAS, 0x07, Local0)
            Store (SREG, Local1)
            Return (LNot (And (Local1, One)))
        }
        Else
        {
            Return (Zero)
        }
    }

    OperationRegion (DBGA, SystemIO, 0x80, 0x04)
    Field (DBGA, DWordAcc, NoLock, Preserve)
    {
        DB32,   32
    }

    Method (GHET, 1, NotSerialized)
    {
        And (Arg0, 0x7F, Local0)
        ShiftLeft (Local0, 0x05, Local0)
        Add (Local0, HPTA, Local0)
        OperationRegion (HDPT, SystemMemory, Local0, 0x20)
        Field (HDPT, ByteAcc, NoLock, Preserve)
        {
            HP00,   16, 
            Offset (0x04), 
            HP04,   8, 
            Offset (0x12), 
            HP0C,   8
        }

        Store (HP00, HBAS)
        Store (HP04, HLBA)
        Store (HP0C, HDEV)
    }

    Method (SDRV, 0, NotSerialized)
    {
        Add (HBAS, 0x06, Local0)
        OperationRegion (HRGH, SystemIO, Local0, One)
        Field (HRGH, ByteAcc, NoLock, Preserve)
        {
            HREG,   8
        }

        Store (HLBA, HREG)
    }

    Method (WFCF, 0, NotSerialized)
    {
        SDRV ()
        Add (HBAS, One, Local0)
        OperationRegion (HRGE, SystemIO, Local0, One)
        Field (HRGE, ByteAcc, NoLock, Preserve)
        {
            EREG,   8
        }

        Store (Zero, EREG)
        Add (HBAS, 0x07, Local1)
        OperationRegion (HRGC, SystemIO, Local1, One)
        Field (HRGC, ByteAcc, NoLock, Preserve)
        {
            CREG,   8
        }

        Store (0x28, Local0)
        While (Local0)
        {
            And (CREG, One, Local2)
            If (Local2)
            {
                Return (Zero)
            }

            WFZF (Local1)
            And (CREG, 0x80, Local2)
            If (LEqual (Local2, Zero))
            {
                Return (One)
            }

            Decrement (Local0)
        }

        Return (Zero)
    }

    Method (WFZF, 1, NotSerialized)
    {
        OperationRegion (HRGC, SystemIO, Arg0, One)
        Field (HRGC, ByteAcc, NoLock, Preserve)
        {
            CREG,   8
        }

        Store (0xFFFF, Local1)
        Store (CREG, Local2)
        And (Local2, 0x80, Local2)
        If (LEqual (Local2, Zero))
        {
            Return (Zero)
        }

        While (Local1)
        {
            Stall (0x0F)
            Decrement (Local1)
            If (LEqual (Local1, Zero))
            {
                Return (Zero)
            }

            Store (CREG, Local2)
            And (Local2, 0x80, Local2)
            If (LEqual (Local2, Zero))
            {
                Return (Zero)
            }

            Decrement (Local1)
        }
    }

    Scope (PCI0)
    {
        Name (HFZF, 0xFFFF)
        Method (HWAK, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x03))
            {
                Store (Zero, HFZF)
            }
        }
    }

    Scope (SIOR)
    {
        Method (HWV0, 0, NotSerialized)
        {
            Return (Multiply (VIV0, 0x10))
        }

        Method (HWV1, 0, NotSerialized)
        {
            Return (Multiply (VIV1, 0x10))
        }

        Method (HWV2, 0, NotSerialized)
        {
            Return (Multiply (VIV2, 0x10))
        }

        Method (HWV3, 0, NotSerialized)
        {
            Return (Multiply (VIV3, 0x10))
        }

        Method (HWV4, 0, NotSerialized)
        {
            Add (VIV4, 0x0C, VIV4)
            Return (Multiply (VIV4, 0x10))
        }

        Method (HWV5, 0, NotSerialized)
        {
            Return (Multiply (VIV5, 0x10))
        }

        Method (HWV6, 0, NotSerialized)
        {
            Return (Multiply (VIV6, 0x10))
        }

        Method (HWV7, 0, NotSerialized)
        {
            Return (Multiply (VIV7, 0x10))
        }

        Method (HWT1, 0, NotSerialized)
        {
            Store (TPI1, Local0)
            If (LGreater (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
            }

            Return (Multiply (Local0, 0x0A))
        }

        Method (HWT2, 0, NotSerialized)
        {
            Store (TPI2, Local0)
            If (LGreater (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
            }

            Subtract (Local0, 0x05, Local0)
            Return (Multiply (Local0, 0x0A))
        }

        Method (HWT3, 0, NotSerialized)
        {
            Store (TPI3, Local0)
            If (LGreater (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
            }

            Return (Multiply (Local0, 0x0A))
        }

        Method (HWF1, 0, NotSerialized)
        {
            Store (FTC1, Local0)
            Store (One, Local2)
            While (LAnd (LOr (LNot (LGreater (Local0, FHMT)), LNot (LLess (Local0, FLMT))), LEqual (Local2, One)))
            {
                If (LNot (LGreater (Local0, FHMT)))
                {
                    Store (FTD1, Local1)
                    If (LGreater (Local1, Zero))
                    {
                        Decrement (Local1)
                        Store (Local1, FTD1)
                    }
                    Else
                    {
                        Store (Zero, Local2)
                    }
                }
                Else
                {
                    Store (FTD1, Local1)
                    If (LLess (Local1, 0x07))
                    {
                        Increment (Local1)
                        Store (Local1, FTD1)
                    }
                    Else
                    {
                        Store (Zero, Local2)
                    }
                }

                Sleep (0x012C)
                Store (FTC1, Local0)
            }

            If (LOr (LEqual (Local0, Zero), LEqual (Local0, 0xFF)))
            {
                Return (Zero)
            }
            Else
            {
                Divide (FTFR, Multiply (Local0, DerefOf (Index (DTB1, FTD1))), , Local1)
                Return (Local1)
            }
        }

        Method (HWF2, 0, NotSerialized)
        {
            Store (FTC2, Local0)
            Store (One, Local2)
            While (LAnd (LOr (LNot (LGreater (Local0, FHMT)), LNot (LLess (Local0, FLMT))), LEqual (Local2, One)))
            {
                If (LNot (LGreater (Local0, FHMT)))
                {
                    Store (FTD2, Local1)
                    If (LGreater (Local1, Zero))
                    {
                        Decrement (Local1)
                        Store (Local1, FTD2)
                    }
                    Else
                    {
                        Store (Zero, Local2)
                    }
                }
                Else
                {
                    Store (FTD2, Local1)
                    If (LLess (Local1, 0x07))
                    {
                        Increment (Local1)
                        Store (Local1, FTD2)
                    }
                    Else
                    {
                        Store (Zero, Local2)
                    }
                }

                Sleep (0x012C)
                Store (FTC2, Local0)
            }

            If (LOr (LEqual (Local0, Zero), LEqual (Local0, 0xFF)))
            {
                Return (Zero)
            }
            Else
            {
                Divide (FTFR, Multiply (Local0, DerefOf (Index (DTB1, FTD2))), , Local1)
                Return (Local1)
            }
        }

        Method (HWF3, 0, NotSerialized)
        {
            Store (FTC3, Local0)
            If (LNot (LGreater (Local0, FHMT)))
            {
                Store (FTD3, Local1)
                If (LGreater (Local1, Zero))
                {
                    Decrement (Local1)
                    Store (Local1, FTD3)
                    Sleep (0x012C)
                    Store (FTC3, Local0)
                }
            }
            Else
            {
                If (LNot (LLess (Local0, FLMT)))
                {
                    Store (FTD3, Local1)
                    If (LLess (Local1, One))
                    {
                        Increment (Local1)
                        Store (Local1, FTD3)
                        Sleep (0x012C)
                        Store (FTC3, Local0)
                    }
                }
            }

            If (LOr (LEqual (Local0, Zero), LEqual (Local0, 0xFF)))
            {
                Return (Zero)
            }
            Else
            {
                Divide (FTFR, Multiply (Local0, DerefOf (Index (DTB2, FTD3))), , Local1)
                Return (Local1)
            }
        }

        Name (FTFR, 0x00149970)
        Name (FHMT, 0x78)
        Name (FLMT, 0xFE)
        Name (DTB1, Package (0x08)
        {
            One, 
            0x02, 
            0x04, 
            0x08, 
            0x10, 
            0x20, 
            0x40, 
            0x80
        })
        Name (DTB2, Package (0x02)
        {
            0x02, 
            0x08
        })
        OperationRegion (ECRE, SystemIO, IOEB, 0x20)
        Field (ECRE, ByteAcc, NoLock, Preserve)
        {
            Offset (0x05), 
            HIDX,   8, 
            HDAT,   8
        }

        IndexField (HIDX, HDAT, ByteAcc, NoLock, Preserve)
        {
            Offset (0x0B), 
            FTD1,   3, 
            FTD2,   3, 
            FTD3,   1, 
            Offset (0x0C), 
            ETDE,   8, 
            FTC1,   8, 
            FTC2,   8, 
            FTC3,   8, 
            Offset (0x18), 
            EFN1,   8, 
            EFN2,   8, 
            EFN3,   8, 
            Offset (0x20), 
            VIV0,   8, 
            VIV1,   8, 
            VIV2,   8, 
            VIV3,   8, 
            VIV4,   8, 
            VIV5,   8, 
            VIV6,   8, 
            VIV7,   8, 
            Offset (0x29), 
            TPI1,   8, 
            TPI2,   8, 
            TPI3,   8
        }
    }

    Scope (\)
    {
        Field (RAMW, ByteAcc, NoLock, Preserve)
        {
            Offset (0x20), 
            CPUQ,   8, 
            CPVL,   16, 
            CPVH,   16, 
            CPVC,   1
        }
    }

    Scope (ASOC)
    {
        Name (CORV, Package (0x05)
        {
            0x06020000, 
            "Vcore Voltage", 
            0x0352, 
            0x0640, 
            One
        })
        Name (V3VV, Package (0x05)
        {
            0x06020001, 
            " +3.3 Voltage", 
            0x0B9A, 
            0x0E2E, 
            One
        })
        Name (V5VV, Package (0x05)
        {
            0x06020002, 
            " +5 Voltage", 
            0x1194, 
            0x157C, 
            One
        })
        Name (VV12, Package (0x05)
        {
            0x06020003, 
            " +12 Voltage", 
            0x27D8, 
            0x35E8, 
            One
        })
        Name (VPAR, Package (0x04)
        {
            Package (0x03)
            {
                Zero, 
                One, 
                Zero
            }, 

            Package (0x03)
            {
                Zero, 
                One, 
                Zero
            }, 

            Package (0x03)
            {
                0x22, 
                0x32, 
                Zero
            }, 

            Package (0x03)
            {
                0x1C, 
                0x0A, 
                Zero
            }
        })
        Name (VBUF, Package (0x05)
        {
            0x04, 
            CORV, 
            V3VV, 
            V5VV, 
            VV12
        })
        Method (VGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (^^SIOR.HWV0 ())
            }

            If (LEqual (Arg0, One))
            {
                Return (^^SIOR.HWV2 ())
            }

            If (LEqual (Arg0, 0x02))
            {
                Return (^^SIOR.HWV3 ())
            }

            If (LEqual (Arg0, 0x03))
            {
                Return (^^SIOR.HWV4 ())
            }
        }

        Name (CPUT, Package (0x05)
        {
            0x06030000, 
            "CPU Temperature", 
            0x0258, 
            0x03B6, 
            0x00010001
        })
        Name (MBTP, Package (0x05)
        {
            0x06030001, 
            "MB Temperature", 
            0x01C2, 
            0x03B6, 
            0x00010001
        })
        Name (TBUF, Package (0x03)
        {
            0x02, 
            CPUT, 
            MBTP
        })
        Method (TGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (^^SIOR.HWT1 ())
            }

            If (LEqual (Arg0, One))
            {
                Return (^^SIOR.HWT2 ())
            }
        }

        Name (CPUF, Package (0x05)
        {
            0x06040000, 
            "CPU FAN Speed", 
            0x0320, 
            0x1C20, 
            0x00010001
        })
        Name (CHAF, Package (0x05)
        {
            0x06040001, 
            "CHASSIS FAN Speed", 
            0x0320, 
            0x1C20, 
            0x00010001
        })
        Name (PWRF, Package (0x05)
        {
            0x06040002, 
            "CHASSIS2 FAN Speed", 
            0x0320, 
            0x1C20, 
            0x00010001
        })
        Name (FBUF, Package (0x04)
        {
            0x03, 
            CPUF, 
            CHAF, 
            PWRF
        })
        Method (FGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (^^SIOR.HWF1 ())
            }

            If (LEqual (Arg0, One))
            {
                Return (^^SIOR.HWF2 ())
            }

            If (LEqual (Arg0, 0x02))
            {
                Return (^^SIOR.HWF3 ())
            }
        }

        Name (QCFN, Package (0x06)
        {
            0x04060003, 
            "CPU Q-Fan Control", 
            Zero, 
            One, 
            0x02, 
            0x00010000
        })
        Name (QBUF, Package (0x02)
        {
            One, 
            QCFN
        })
        Method (VSIF, 0, NotSerialized)
        {
            Return (VBUF)
        }

        Method (RVLT, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (VGET (Local0), Local1)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), Zero)), Local2)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), One)), Local3)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), 0x02)), Local4)
            Multiply (Local1, Add (Local2, Local3), Local5)
            Divide (Local5, Local3, , Local5)
            Add (Local5, Local4, Local5)
            Return (Local5)
        }

        Method (SVLT, 1, NotSerialized)
        {
            And (DerefOf (Index (Arg0, Zero)), 0xFFFF, Local0)
            Store (DerefOf (Index (VBUF, Zero)), Local1)
            If (LNot (LLess (Local0, Local1)))
            {
                Return (Zero)
            }

            Increment (Local0)
            Store (DerefOf (Index (Arg0, One)), Index (DerefOf (Index (VBUF, Local0)), One))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (VBUF, Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (VBUF, Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (VBUF, Local0)), 0x04))
            Return (One)
        }

        Method (TSIF, 0, NotSerialized)
        {
            Return (TBUF)
        }

        Method (RTMP, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (TGET (Local0), Local1)
            Return (Local1)
        }

        Method (STMP, 1, NotSerialized)
        {
            Store (And (DerefOf (Index (Arg0, Zero)), 0xFFFF), Local0)
            Store (DerefOf (Index (TBUF, Zero)), Local1)
            If (LNot (LLess (Local0, Local1)))
            {
                Return (Zero)
            }

            Increment (Local0)
            Store (DerefOf (Index (Arg0, One)), Index (DerefOf (Index (TBUF, Local0)), One))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (TBUF, Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (TBUF, Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (TBUF, Local0)), 0x04))
            Return (One)
        }

        Method (FSIF, 0, NotSerialized)
        {
            Return (FBUF)
        }

        Method (RFAN, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (FGET (Local0), Local1)
            Return (Local1)
        }

        Method (SFAN, 1, NotSerialized)
        {
            And (DerefOf (Index (Arg0, Zero)), 0xFFFF, Local0)
            Store (DerefOf (Index (FBUF, Zero)), Local1)
            If (LNot (LLess (Local0, Local1)))
            {
                Return (Zero)
            }

            Increment (Local0)
            Store (DerefOf (Index (Arg0, One)), Index (DerefOf (Index (FBUF, Local0)), One))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (FBUF, Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (FBUF, Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (FBUF, Local0)), 0x04))
            Return (One)
        }

        Method (QFIF, 0, NotSerialized)
        {
            If (LEqual (CPUQ, Zero))
            {
                And (DerefOf (Index (QCFN, 0x05)), 0xFFFDFFFF, Local0)
                Store (Local0, Index (QCFN, 0x05))
            }
            Else
            {
                Or (DerefOf (Index (QCFN, 0x05)), 0x00020000, Local0)
                Store (Local0, Index (QCFN, 0x05))
            }

            Return (QBUF)
        }

        Method (GCQV, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (CPVL)
            }

            If (LEqual (Arg0, One))
            {
                Return (CPVH)
            }

            If (LEqual (Arg0, 0x02))
            {
                Return (CPVC)
            }

            Return (Zero)
        }
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000, // Address Space Granularity
                    0x0000, // Address Range Minimum
                    0x00FF, // Address Range Maximum
                    0x0000, // Address Translation Offset
                    0x0100,,,)
                IO (Decode16, 0x0CF8, 0x0CF8, 0x01, 0x08)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000, // Address Space Granularity
                    0x0000, // Address Range Minimum
                    0x0CF7, // Address Range Maximum
                    0x0000, // Address Translation Offset
                    0x0CF8,,,
                    , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000, // Address Space Granularity
                    0x0D00, // Address Range Minimum
                    0xFFFF, // Address Range Maximum
                    0x0000, // Address Translation Offset
                    0xF300,,,
                    , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000A0000, // Address Range Minimum
                    0x000BFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00020000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000C0000, // Address Range Minimum
                    0x000DFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00020000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x00000000, // Address Range Minimum
                    0x00000000, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00000000,,,
                    , AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, 0x5C, MIN5)
            CreateDWordField (CRS, 0x60, MAX5)
            CreateDWordField (CRS, 0x68, LEN5)
            CreateDWordField (CRS, 0x76, MIN6)
            CreateDWordField (CRS, 0x7A, MAX6)
            CreateDWordField (CRS, 0x82, LEN6)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Return (CRS)
            }
        }
    }

    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)
    {
        Store (Arg0, DBG8)
        Store (One, PLED)
        PTS (Arg0)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
    }

    Method (_WAK, 1, NotSerialized)
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        Store (Zero, PLED)
        WAK (Arg0)
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        Return (WAKP)
    }

    OperationRegion (PWCR, PCI_Config, 0x94, One)
    Field (\_SB.PCI0.SBRG.PWCR, ByteAcc, NoLock, Preserve)
    {
        PLED,   2, 
            ,   2, 
        SUST,   1, 
        Offset (0x01)
    }

    Name (_S0, Package (0x04)
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)
        {
            0x04, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x02, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)
    {
        0x02, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.SBRG.SIOS (Arg0)
            \_SB.PCI0.NPTS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.SBRG.SIOW (Arg0)
        \_SB.PCI0.HWAK (Arg0)
        \_SB.PCI0.NWAK (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
    }
}

