/*
 * Filename: $Id: MIGRATE.CMD,v 1.32 2005/08/05 18:24:14 tjb Exp $
 *  Created: 2003-07-23 AT
 *  Purpose: Do some stuff to smooth migration
 *  Changes: Added removal of CONFIG.* from installdrive (JB 2004-07-07)
 *           Added cleanup of MMOS2 classes and objects  (JB 2004-07-08)
 *           Added creation of new 'backupdir' on subsequent invocation (JB 2004-07-15)
 *           Added extra-strong Destroy function for SysObjects (JB 2004-07-19)
 *           Added removal of existing eCS tree on instdrv (JB 2004-07-19)
 *           Added removal of MultiMedia Template folder (if found) (JB 2004-07-20)
 *           Corrected check on syslevel files (ProductPathForSyslevel) (JB 2004-07-22)
 *           Moved a lot of code to MIGRATE0.CMD (JB 2004-07-25)
 *           Added removal of READONLY attribute in directories before move (JB 2004-08-01)
 * Last editor: $Author: tjb $
 * Last edited: $Date: 2005/08/05 18:24:14 $
 * Changes: $Log: MIGRATE.CMD,v $
 * Changes: Revision 1.32  2005/08/05 18:24:14  tjb
 * Changes: joachim@mensys.nl: updated migration scripts with improved logging and removal of 'locked'
 * Changes: directories to improve WPS migration (File and Print Resource Browser) preventing popunder window in phase 2.
 * Changes: Added text to GPS file to clarify meaning of 'USB disks' -> USBMSD.ADD
 * Changes:
 * Changes: Revision 1.31  2005/08/03 16:13:13  tjb
 * Changes: joachim@mensys.nl: changed responsfilename MIGRATION.RSP to MIGRATE.RSP (due to 8.3 compliance)
 * Changes:
 * Changes: Revision 1.30  2005/08/03 11:59:59  tjb
 * Changes: *** empty log message ***
 * Changes:
 * Changes: Revision 1.29  2005/08/02 16:08:38  tjb
 * Changes: joachim@mensys.nl: migratefile function now moves file to directory structure under backupdir, instead of backupdir root
 * Changes:
 * Changes: Revision 1.28  2005/06/25 23:58:04  tjb
 * Changes: joachim@mensys.nl: now also delete syslevel files from bootdrive, if available
 * Changes:
 * Changes: Revision 1.27  2005/06/25 23:40:14  tjb
 * Changes: joachim@mensys.nl: fixed bug 988 (remove syslevel files so IBM installer doesn't fail on 'too high service level')
 * Changes:
 * Changes: Revision 1.26  2005/06/17 16:25:04  dve
 * Changes: Added copyfile.cmd as a wrapper around eCSCopy to provided for standardized
 * Changes: logging and updated command files to use copyfile instead of eCSCopy directly
 * Changes:
 */

/* load the REXX libraries */
IF LoadRexxUtil() THEN RETURN 1

PARSE ARG phase
phase = STRIP( TRANSLATE( phase ))

instdrv  = 'H:'
netwdrv  = 'H:'
rspfiles = 'H:\ECS\INSTALL\RSP'
logpath  = 'H:\VAR\LOG'

IF STREAM( rspfiles'\MIGRATE.RSP', 'C', 'QUERY EXISTS') = '' THEN return 0

SELECT
    WHEN phase  = 'PHASE1' THEN DO
        CALL PreparePhase1
        retcode = 0
    END
    WHEN phase  = 'PHASE2' THEN DO
        CALL PreparePhase2
        retcode = 0
    END
    WHEN phase  = 'NETWORK' THEN DO
        CALL PrepareNetwork
        retcode = 0
    END
    OTHERWISE retcode = 1
END

RETURN retcode


/*****************************************************************************
 * PreparePhase1                                                             *
 *                                                                           *
 *****************************************************************************/
PreparePhase1: PROCEDURE EXPOSE instdrv netwdrv rspfiles logpath

log   = STRIP( GetValue(rspfiles'\MIGRATE.RSP', 'MIGRATE_LOG')) /* this is against our rules but improves usefulness of logfile for enduser */
log2  = logpath'\1_MIGRT.L2'

rc = stream(log, 'c', 'open write')

CALL LINEOUT log,  '*** [Phase 1] Running migrate tasks'
CALL LINEOUT log2, '*** [Phase 1] Running migrate tasks'

/* migrated is on any drive */
migrated = GetValue( rspfiles'\MIGRATE.RSP', 'PREVIOUS_DIR')

os2ini    = instdrv'\OS2\OS2.INI'
os2sysini = instdrv'\OS2\OS2SYS.INI'
syslevel1 = instdrv'\OS2\INSTALL\SYSLEVEL.OS2'
syslevel2 = instdrv'\OS2\INSTALL\SYSLEVEL.FPK'
configsys = instdrv'\CONFIG.SYS'
startcmd  = instdrv'\STARTUP.CMD'
userdat   = instdrv'\OS2\SYSTEM\USER.DAT'
systemdat = instdrv'\OS2\SYSTEM\SYSTEM.DAT'
dhcpc     = netwdrv'\MPTN\ETC\DHCPCD.CFG'
dhcps     = netwdrv'\MPTN\ETC\DHCPSD.CFG'
setup     = netwdrv'\MPTN\BIN\SETUP.CMD'
protini   = netwdrv'\IBMCOM\PROTOCOL.INI'
lanini    = netwdrv'\IBMLAN\IBMLAN.INI'
tvoice    = instdrv'\TVOICE'
ecsdir    = instdrv'\ECS'
mmos2     = instdrv'\MMOS2'
ibminst   = instdrv'\IBMINST'
locinstu  = instdrv'\LOCINSTU'
sdd       = instdrv'\SDD'
snap      = instdrv'\SNAP'
dmisl     = instdrv'\DMISL'
etcpath   = instdrv'\ETC' /* only on eCS 1.2 after eFDS */

/* Files to delete */
securit2  = instdrv'\OS2\DLL\SECURIT2.DLL'
rxsi2     = instdrv'\OS2\DLL\RXSI2.DLL'
emx       = instdrv'\OS2\DLL\EMX.DLL'
vprexx    = instdrv'\OS2\DLL\VPREXX.DLL'
vrobj     = instdrv'\OS2\DLL\VROBJ.DLL'
/* */
netscrsp  = instdrv'\ECS\INSTALL\RSP\NETSCAPE.RSP'
netsysl   = 'SYSLEVEL.NN2'
walsysl1  = 'SYSLEVEL.LDR'
walsysl2  = 'SYSLEVEL.ART'

/* directories that need to have reset of RO attribute */
/* the subroutine RemoveROAttrib is fast, so we'll just 'do them all' */

dirs.1    = 'MPTN'
dirs.2    = 'IBMCOM'
dirs.3    = 'IBMGSK'
dirs.4    = 'IBMGSK40'
dirs.5    = 'IBMGSK50'
dirs.6    = 'TCPIP'
dirs.7    = 'MMOS2'
dirs.8    = 'ETC'
dirs.9    = 'MUGLIB'
dirs.10   = 'IBMLAN'
dirs.0    = 10

DO i = 1 TO dirs.0
 rotree = instdrv||'\'||dirs.i
 rc = RemoveROAttrib( rotree )
 if rc = 0 THEN
  DO
   rotree = netwdrv||'\'||dirs.i
   rc = RemoveROAttrib( rotree )
  END
 CALL LINEOUT log2, 'Removed' rc 'readonly attributes in directory' rotree
END

/* CALL LINEOUT log, 'Migrating several systemfiles to 'migrated */

/* CALL MigrateFile configsys, 'D' */
CALL MigrateFile startcmd, 'D'
CALL MigrateFile os2ini
CALL MigrateFile os2sysini
CALL MigrateFile syslevel1, 'D'
CALL MigrateFile syslevel2, 'D'
CALL MigrateFile userdat
CALL MigrateFile systemdat
CALL MigrateFile dhcpc
CALL MigrateFile dhcps
CALL MigrateFile setup, 'D'
/* Move IBMLAN.INI and PROTOCOL.INI to backup to avoid problems with IPX */
CALL MigrateFile lanini, 'D'
CALL MigrateFile protini, 'D'
/* Move these directories out of the way */
CALL MigrateDirectory tvoice, 'D'
CALL MigrateDirectory mmos2, 'D'
CALL MigrateDirectory ibminst, 'D'
CALL MigrateDirectory locinstu, 'D'
CALL MigrateDirectory sdd, 'D'
CALL MigrateDirectory snap, 'D'
CALL MigrateDirectory dmisl, 'D'
CALL MigrateDirectory etcpath, 'D'

/* DvE:
   If the user previously had PEER on his installation drive,
   but now installs networking on a different drive, move
   PEER from the installation drive to backup
*/
if instdrv<>netwdrv then
do
  CALL MigrateDirectory instdrv||'\IBMLAN', 'D'
  CALL MigrateDirectory instdrv||'\MUGLIB', 'D'
end

/* Delete files that have moved in eCS 1.2 */
CALL DeleteFile securit2
CALL DeleteFile rxsi2
CALL DeleteFile emx
CALL DeleteFile vprexx
CALL DeleteFile vrobj

CALL LINEOUT log, 'Check existence of Netscape...'

/* Check for Netscape */
netdir=ProductPathForSyslevel(netsysl)
/* Netscape syslevel is in program directory */
if netdir<>'' then
do
    netscape=strip(filespec('drive', netdir)||filespec('path', netdir), 'B', '\')
    if netscape<>'' then
    do
        i=0
        do while lines(netscrsp)
            i=i+1
            rsp.i=linein(netscrsp)
        end
        rsp.0=i
        call stream netscrsp, 'C', 'CLOSE'
        rc = ecsdelete(netscrsp)
        do i=1 to rsp.0
            if pos('FILE', translate(rsp.i)) >< 0 then
            do
                call lineout netscrsp, 'FILE='netscape
            end
            else
            do
                call lineout netscrsp, rsp.i
            end
        end
        call stream netscrsp, 'C', 'CLOSE'
        CALL LINEOUT log, 'Redirected Netscape install to ' netscape '.'
    end
end
ELSE CALL LINEOUT log, 'Netscape not found.' /* netdir = '' */

CALL LINEOUT log, 'Check existence of LAN Distance Remote...'

/* LAN Distance Remote */
waldir=ProductPathForSyslevel(walsysl1)
if waldir<>'' then
do
    '@ren 'waldir'\'walsysl1' syslevel.ld!'
    '@ren 'waldir'\'walsysl2' syslevel.ar!'
    CALL LINEOUT log, 'Detected LAN Distance Remote in ' waldir '.'
end
ELSE CALL LINEOUT log, 'LAN Distance Remote not found.'

/* query the use of IBM1S506.ADD driver in existing system */

/* after some consideration, this feature is disabled since the user
 should be able to boot with the DANI driver, as he got here in the
first place! */

/*
configsys = instdrv'\CONFIG.SYS'
IF ( stream(configsys,'c','query exists') <> '' ) THEN
 DO
  CALL LINEOUT log, 'Existing CONFIG.SYS found, query for IDE driver'
  ibmdriver = 0
  rc = stream(configsys, 'c', 'open read')
  DO while lines(configsys)
   line = strip(translate(linein(configsys)))
   if pos('IBM1S506.ADD', line) >< 0 & pos('BASEDEV', line) = 1 THEN
    DO
     ibmdriver = 1
     CALL LINEOUT log, 'Existing CONFIG.SYS uses IBM1S506.ADD driver'
    END
  END
  rc = stream(configsys, 'c', 'close')

 hardware_rsp = rspfiles'\HARDWARE.RSP'
  i = 0
  rc = stream(hardware_rsp, 'c', 'open read')
  DO while lines(hardware_rsp)
   i = i + 1
   line.i = strip(translate(linein(hardware_rsp)))
   if pos('DANIS506.ADD', line.i) >< 0 & pos('BASEDEV', line.i) = 1 & ibmdriver = 1 THEN
    DO
     line.i = 'BASEDEV=IBM1S506.ADD'
     changed = 1
    END
  END
  rc = stream(hardware_rsp, 'c', 'close')
  lines.0 = i

 /* rewrite responsefile */

 IF changed = 1 THEN
  DO
   CALL LINEOUT log, 'Updating 'hardware_rsp' to correct IDE driver'
   rc = eCSDelete(hardware_rsp, 'F')
   rc = stream(hardware_rsp, 'c', 'open write')
    DO i = 1 TO lines.0
     call lineout hardware_rsp, line.i
    END
   rc = stream(hardware_rsp, 'c', 'close')
  END

END /* config.sys existed */

 --- disabled hardware.rsp rewrite code --- */

/* migrate/remove old config.sys */

CALL LINEOUT log, 'Check and remove existing CONFIG.SYS files...'

configlist.1=instdrv||'\CONFIG.*'
configlist.2=instdrv||'\OS2\INSTALL\CONFIG.*'
configlist.3=instdrv||'\OS2\BOOT\CONFIG.*'
configlist.0=3

backupdir=instdrv||migrated
DO t1=1 TO configlist.0
    /* Search for files only, report only filename */
    IF SysFileTree(configlist.t1, 'files.', 'FO')=0 THEN
     DO
        /* Create a subdirectory under the backupdir */
        dir=strip(backupdir||FileSpec('PATH', configlist.t1), 'T', '\')
        if files.0 > 0 THEN
        DO
         rc=ecsmakepath(dir) /* create directory */
         DO t2=1 TO files.0
            /* IF Translate(FileSpec('NAME', files.t2))<>'CONFIG.SYS' THEN */
            DO
              rc=CopyFile(files.t2, dir, log2)
              msgtxt = ' could not be deleted.'
              IF eCSDelete(files.t2, 'F') THEN msgtxt = ' successfully deleted.'
              call lineout log2, files.t2||msgtxt
            END
         END
        END
       ELSE /* files.0 = 0 */
        DO
         CALL LINEOUT log, 'No CONFIG.* files found in 'filespec('PATH', configlist.t1)
        END
     END
END

/* Close open files */
rc = stream(log, 'c', 'close')

RETURN 0


/*****************************************************************************
 * PreparePhase2                                                             *
 *                                                                           *
 *****************************************************************************/
PreparePhase2: PROCEDURE EXPOSE instdrv netwdrv rspfiles logpath

/* log = logpath'\2_MIGRT.L1' */
log  = STRIP( GetValue(rspfiles'\MIGRATE.RSP', 'MIGRATE_LOG')) /* this is against our rules but improves usefulness of logfile for enduser */
log2     = logpath'\2_MIGRT.L2'

/* migrated is on any drive */
migrated = GetValue( rspfiles'\MIGRATE.RSP', 'PREVIOUS_DIR')

rc = stream(log, 'c', 'open write')

CALL LINEOUT log, '*** [Phase 2] Running migrate tasks'

/* remove MultiMedia Classes (desktop has to run) */

CALL LINEOUT log,  'Removing existing MultiMedia classes...'
CALL LINEOUT log2, 'Removing existing MultiMedia classes...'

classlist = rspfiles'\MMCLASS.LST'
rc = stream(classlist, 'c', 'open read')
i = 0
DO while lines(classlist)
 i = i + 1
 class.i = strip(linein(classlist))
 if class.i = '' THEN i = i - 1
 if pos('#', class.i) <> 0 THEN i = i - 1
END
class.0 = i
rc = stream(classlist, 'c', 'close')

j = 0
DO i = 1 TO Class.0
 rc = SysDeregisterObjectClass(Class.i)
 IF rc = 1 THEN
  DO
   CALL LINEOUT log2, 'Class 'class.i' succesfully deregistered.'
   j = j + 1
  END
END

CALL LINEOUT log,  'Removed 'j' existing MultiMedia classes (out of 'class.0' listed)'
CALL LINEOUT log2, 'Removed 'j' existing MultiMedia classes (out of 'class.0' listed)'

/* remove MultiMedia Objects (desktop has to run) */

CALL LINEOUT log,  'Removing existing MultiMedia objects...'
CALL LINEOUT log2, 'Removing existing MultiMedia objects...'

objlist = rspfiles'\MMOBJ.LST'
rc = stream(objlist, 'c', 'open read')
i = 0
DO while lines(objlist)
 i = i + 1
 obj.i = strip(linein(objlist))
 if class.i = '' THEN i = i - 1
 if pos('#', obj.i) <> 0 THEN i = i - 1
END
obj.0 = i
rc = stream(objlist, 'c', 'close')

j = 0
DO i = 1 TO obj.0
 if (Destroy('<'obj.i'>') <> 0) then
   DO
    call lineout log2, 'Removed '||obj.i
    j = j + 1
   END
END

CALL LINEOUT log,  'Removed 'j' existing MultiMedia objects (out of 'obj.0' listed)'
CALL LINEOUT log2, 'Removed 'j' existing MultiMedia objects (out of 'obj.0' listed)'

/* copy back previous USER.DAT and SYSTEM.DAT */

CALL LINEOUT log,  'Restoring USER.DAT and SYSTEM.DAT'

file.1 = instdrv||migrated'\OS2\SYSTEM\USER.DAT'
file.2 = instdrv||migrated'\OS2\SYSTEM\SYSTEM.DAT'
file.0 = 2

DO i = 1 TO file.0
 rc=CopyFile(file.i, instdrv'\OS2\SYSTEM\', log2)
END

/* Close open files */
rc = stream(log, 'c', 'close')

RETURN 0

/*****************************************************************************
 * PrepareNetwork                                                            *
 *                                                                           *
 *****************************************************************************/
PrepareNetwork: PROCEDURE EXPOSE instdrv netwdrv rspfiles logpath

/* log   = logpath'\NETWORK.L1' */
log   = STRIP( GetValue(rspfiles'\MIGRATE.RSP', 'MIGRATE_LOG')) /* this is against our rules but improves usefulness of logfile for enduser */
log2  = logpath'\NETWORK.L2'

rc = stream(log, 'c', 'open write')
CALL LINEOUT log, '*** [Network] Running migrate tasks'

/* migrated is on any drive */
migrated = GetValue( rspfiles'\MIGRATE.RSP', 'PREVIOUS_DIR')

dhcpc     = netwdrv'\MPTN\ETC\DHCPCD.CFG'
dhcps     = netwdrv'\MPTN\ETC\DHCPSD.CFG'
setup     = netwdrv'\MPTN\BIN\SETUP.CMD'
protini   = netwdrv'\IBMCOM\PROTOCOL.INI'
lanini    = netwdrv'\IBMLAN\IBMLAN.INI'

/* CALL LINEOUT log, 'Migrating several systemfiles to 'migrated */

/* CALL MigrateFile configsys, 'D' */
CALL MigrateFile dhcpc
CALL MigrateFile dhcps
CALL MigrateFile setup
/* Move IBMLAN.INI and PROTOCOL.INI to backup to avoid problems with IPX */
CALL MigrateFile lanini, 'D'
CALL MigrateFile protini, 'D'
/* remove syslevelfiles to make sure IBM installer doesn't choke */
deletefiles = (netwdrv'\IBMLAN\SYSLEVEL.PER' netwdrv'\IBMLAN\SYSLEVEL.REQ' instdrv'\IBMLAN\SYSLEVEL.PER' instdrv'\IBMLAN\SYSLEVEL.REQ')
DO i = 1 TO words(deletefiles)
target = word(deletefiles, i)
IF STREAM( target, 'C', 'QUERY EXISTS') <> '' THEN CALL DeleteFile target
END


RETURN 0

/***********************************************************/
MigrateFile: PROCEDURE EXPOSE migrated log log2
    ARG target, flag

    IF STREAM( target, 'C', 'QUERY EXISTS') <> '' THEN
    DO
        dirok = CheckBackupDir( filespec('drive', target)||migrated )
        IF dirok=0 THEN
        DO
                targetdir=strip(filespec('drive', target)||migrated||FileSpec('PATH', target), 'T', '\')
                rc=ecsmakepath(targetdir) /* create directory under backup directory */
            retcode = CopyFile( target, targetdir, log2)
            IF flag = 'D' THEN
            DO
                CALL DeleteFile target
            END
        END
    END

RETURN

/***********************************************************/
MigrateDirectory: PROCEDURE EXPOSE migrated log log2
    ARG target, flag

    retcode = SysFileTree( target, 'dirs.', 'DO')
    IF ( retcode = 0 ) & ( dirs.0 > 0 ) THEN DO
        dirok = CheckBackupDir( filespec('drive', target)||migrated )
        IF dirok = 0 THEN
        DO
            SELECT
                WHEN flag = 'D' THEN '@MOVE' target migrated ' >NUL 2>&1'
                OTHERWISE '@XCOPY' target'\*' filespec('drive', target)||migrated||filespec('path', target'\') '/S /E >NUL 2>&1'
            END
           IF rc = 0 then msgtxt = 'succesful.'; else msgtxt = 'unsuccesful.'
           IF flag = 'D' then msgtxt = 'Move of directory' target' 'msgtxt; ELSE msgtxt = 'Copy of directory' target' 'msgtxt
            CALL LINEOUT log2, msgtxt
        END
    END

RETURN

/***********************************************************/
CheckBackupDir: PROCEDURE EXPOSE log
    ARG backdir

    retcode = SysFileTree( backdir, 'dirs.', 'DO')
    IF ( retcode = 0 ) & ( dirs.0 > 0 ) THEN
    DO
        retcode = 0
    END
    ELSE
    DO
        retcode = SysMkDir( backdir )
        IF retcode = 0 THEN
        DO
            CALL LINEOUT log, 'Created directory' backdir 'for migration backup.'
        END
    END

RETURN retcode

/***********************************************************/
DeleteFile: PROCEDURE EXPOSE log log2
    ARG target

    rc = eCSDelete(target, 'F')
    msgtxt = ' could not be deleted.'
    IF rc = 1 THEN msgtxt = ' successfully deleted.'
    call lineout log2, target||msgtxt

RETURN rc

/***********************************************************/
ProductPathForSyslevel: PROCEDURE expose log instdrv netwdrv
    ARG target
    returnstring = ''
    if (filespec('drive', target)) = '' THEN target = instdrv'\'target
    retcode = SysFileTree( target, 'syslevel.', 'FOS' )
    if ( retcode = 0 ) & ( syslevel.0 > 0 ) then returnstring = strip(filespec('drive', syslevel.1)||filespec('path', syslevel.1), 'B', '\')
    if returnstring = '' & instdrv >< netwdrv & (filespec('drive', target)) = '' THEN
     DO
      target = netwdrv'\'target
      retcode = SysFileTree( target, 'syslevel.', 'FOS' )
      if ( retcode = 0 ) & ( syslevel.0 > 0 ) then returnstring = strip(filespec('drive', syslevel.1)||filespec('path', syslevel.1), 'B', '\')
     END
RETURN returnstring

/***********************************************************/
VerifyBackupDir: PROCEDURE EXPOSE log log2
    ARG backdir

    retcode = SysFileTree( backdir'*', 'stem.', 'DO')
    IF ( retcode \= 0 ) | ( stem.0 > 0 ) THEN
      DO
        test = stem.0; dummy = stem.test
        if pos('.', dummy) = 0 THEN
        DO
         extension = 0
        END
       ELSE
        DO
         extension = right(dummy, 3)
        END
        extension = extension + 1
        backdir = backdir||'.'||right(extension, 3, '0')
      END

/* weird stuff to make sure the driveletter is stripped */
backdir = strip(backdir,'t','\')
backdir = backdir||'\'
backdir = filespec( 'path', backdir )
backdir = strip(backdir,'t','\')

RETURN backdir

/***********************************************************/
/* Destroy(): sneaky little subproc which first sets the NODELETE=NO style
   to make sure we can really delete the object and then does a SysDestroyObject
   on it.

   from DEINST.CMD (U. Moeller - eWPS)
 */

Destroy: PROCEDURE
parse arg objid

rc = SysSetObjectData(objid, "NODELETE=NO;");
if (rc \= 0) then do
    /* got that: */
    rc = SysDestroyObject(objid);
end

return rc

/***********************************************************/
/* remove readonly attribute on tree */
RemoveROAttrib: PROCEDURE
PARSE ARG tree

tree = strip(tree,'t','\')
call SysFileTree tree'\*.*', 'file.', 'FSO', '***+*'

DO i = 1 TO file.0
 CALL SysFileTree file.i, 'stem.', 'FSO',, '***-*'
 DROP stem.
END

RETURN file.0

/***********************************************************/
/* is_file_on_disk - provides a more solid way to find a file location than SysFileTree */
is_file_on_disk: Procedure
Parse Arg cmd_line,.
cmd_line = Strip(cmd_line)
new_queue = Rxqueue('create')
old_queue = Rxqueue('set',new_queue)
Address cmd '@dir 'cmd_line '/s 2>&1|RXQUEUE' new_queue
frc = 1
Do Queued()
   Parse Pull temp
   path_pos = pos(translate(cmd_line), translate(temp))
   if path_pos >< 0 then do
    location = left(temp, path_pos)
    frc = 0
    leave
   end
End
Call Rxqueue 'delete',new_queue
Call Rxqueue 'set',old_queue
Return frc


LoadRexxUtil:

IF RxFuncQuery('SysLoadFuncs') <> 0 THEN
    DO
        IF RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs') THEN RETURN 1
        CALL SysLoadFuncs
    END
IF RxFuncQuery('eCSLoadFuncs') <> 0 THEN
    DO
        IF RxFuncAdd('eCSLoadFuncs','ECSRXLIB','eCSLoadFuncs') THEN RETURN 1
        CALL eCSLoadFuncs
    END
RETURN 0
