/*
 * Filename: $Id: DEFRSP.CMD,v 1.59 2007/12/25 15:20:46 tjb Exp $
 *  Purpose: Check and update the product response files
 */

SIGNAL ON SYNTAX

CALL RxFuncAdd 'eCSLoadFuncs', 'ECSRXLIB', 'eCSLoadFuncs'
CALL eCSLoadFuncs

PARSE ARG phase
phase = STRIP( TRANSLATE( phase ))

instdrv     = 'H:'
srcdrv      = 'S:'
responsedir = 'H:\ECS\INSTALL\RSP'
templatedir = 'S:\ECS\INSTALL\DEFAULT'
logdir      = 'H:\VAR\LOG'
/* Not used anymore
ramdrv      = VALUE('MEMDRIVE',, 'OS2ENVIRONMENT') || ':'
medialang   = STRIP(TRANSLATE(WORD(LINEIN(srcdrv||'\ECS\ECS_INST.FLG'),3)))
*/
log1         = logdir'\defrsp.l1'
log2         = logdir'\defrsp.l2'

paths_sed    = responsedir'\paths.sed'
mode_rsp     = responsedir'\instmode.rsp'
locale_rsp   = responsedir'\locale.rsp'

/* Response files used by SEINST */
base_rsp     = responsedir'\base.rsp'
package_rsp  = responsedir'\package.rsp'
hwopt_rsp    = responsedir'\hwopt.rsp'

/* Default product response files for Easy Install */
ecsprod_rsp  = responsedir'\ecsprod.rsp'
ecsprod_tmp  = templatedir'\ecsprod.rsp'
ecsprod1_rsp = responsedir'\ecsprod1.rsp'
netscape_rsp = responsedir'\netscape.rsp'
netscape_tmp = templatedir'\netscape.rsp'
tcpip_rsp    = responsedir'\tcpip.rsp'
tcpip_tmp    = templatedir'\tcpip.rsp'
ffst_rsp     = responsedir'\ffst.rsp'
ffst_tmp     = templatedir'\ffst.rsp'
book_rsp     = responsedir'\books.rsp'
book_tmp     = templatedir'\books.rsp'
package_rsp  = responsedir'\package.rsp'
package_tmp  = templatedir'\package.rsp'
ibmweb_rsp   = responsedir'\browser.rsp'
ibmweb_tmp   = templatedir'\browser.rsp'
java_rsp     = responsedir'\java142.rsp'
java_tmp     = templatedir'\java142.rsp'
rsj_rsp      = responsedir'\cdwecs.rsp'
rsj_tmp      = templatedir'\cdwecs.rsp'
warpin_rsp   = responsedir'\warpin.xcd'
warpin_tmp   = templatedir'\warpin.xcd'
ewps_rsp     = responsedir'\ewps.xcd'
ewps_tmp     = templatedir'\ewps.xcd'
ewps_reg     = responsedir'\ewps.reg'
ewps_src     = templatedir'\ewps.reg'
ecsmt_rsp    = responsedir'\ecsmt.xcd'
ecsmt_tmp    = templatedir'\ecsmt.xcd'

/* eStyler & xShutdown */
estyler_rsp  = responsedir'\estyler.reg'
estyler_tmp  = templatedir'\estyler.reg'
xshutdwn_rsp = responsedir'\xshutdwn.reg'
xshutdwn_tmp = templatedir'\xshutdwn.reg'

/* eSchemes */
eschemes_rsp = responsedir'\eschemes.xcd'
eschemes_tmp = templatedir'\eschemes.xcd'
'@sed -f' paths_sed eschemes_tmp     '>' eschemes_rsp
CALL LINEOUT log1, 'SED return code for eSchemes:' rc
IF rc><0 THEN RETURN rc

/* Psi/2 */
psios2_rsp = responsedir'\psios2.xcd'
psios2_tmp = templatedir'\psios2.xcd'
'@sed -f' paths_sed psios2_tmp     '>' psios2_rsp
CALL LINEOUT log1, 'SED return code for Psi/2:' rc
IF rc><0 THEN RETURN rc

/* eSambaClient */
esambac_rsp = responsedir'\esambac.xcd'
esambac_tmp = templatedir'\esambac.xcd'
'@sed -f' paths_sed esambac_tmp     '>' esambac_rsp
CALL LINEOUT log1, 'SED return code for eSambaClient:' rc
IF rc><0 THEN RETURN rc

/* GenMac */
genmac_rsp = responsedir'\genmac2.xcd'
genmac_tmp = templatedir'\genmac2.xcd'
'@sed -f' paths_sed genmac_tmp     '>' genmac_rsp
CALL LINEOUT log1, 'SED return code for GenMac:' rc
IF rc><0 THEN RETURN rc

/* OpenSSH */
openssh_rsp = responsedir'\openssh.xcd'
openssh_tmp = templatedir'\openssh.xcd'
'@sed -f' paths_sed openssh_tmp     '>' openssh_rsp
CALL LINEOUT log1, 'SED return code for OpenSSH:' rc
IF rc><0 THEN RETURN rc

/* FAT32 */
fat32_rsp = responsedir'\fat32ifs.xcd'
fat32_tmp = templatedir'\fat32ifs.xcd'
'@sed -f' paths_sed fat32_tmp     '>' fat32_rsp
CALL LINEOUT log1, 'SED return code for FAT32:' rc
IF rc><0 THEN RETURN rc

/* USBDock */
usbdock_rsp = responsedir'\usbdock.xcd'
usbdock_tmp = templatedir'\usbdock.xcd'
'@sed -f' paths_sed usbdock_tmp     '>' usbdock_rsp
CALL LINEOUT log1, 'SED return code for USBDock:' rc
IF rc><0 THEN RETURN rc

/* FaxWorks */
faxworks_rsp = responsedir'\faxworks.xcd'
faxworks_tmp = templatedir'\faxworks.xcd'
'@sed -f' paths_sed faxworks_tmp     '>' faxworks_rsp
CALL LINEOUT log1, 'SED return code for FaxWorks:' rc
IF rc><0 THEN RETURN rc

/* Doodles Screen Saver */
dssaver_tmp      = templatedir'\dssaver.xcd'
dssaver_rsp      = responsedir'\dssaver.xcd'
'@sed -f' paths_sed dssaver_tmp     '>' dssaver_rsp
CALL LINEOUT log1, 'SED return code for DSSaver:' rc
IF rc><0 THEN RETURN rc

/* Cairo library (required by DSSaver) */
cairo_tmp    = templatedir'\cairo.xcd'
cairo_rsp    = responsedir'\cairo.xcd'
'@sed -f' paths_sed cairo_tmp     '>' cairo_rsp
CALL LINEOUT log1, 'SED return code for Cairo (DSSaver):' rc
IF rc><0 THEN RETURN rc

/* Lucide document viewer */
lucide_tmp    = templatedir'\lucide.xcd'
lucide_rsp    = responsedir'\lucide.xcd'
'@sed -f' paths_sed lucide_tmp     '>' lucide_rsp
CALL LINEOUT log1, 'SED return code for Lucide:' rc
IF rc><0 THEN RETURN rc

/* Tame Scanning application */
tame_tmp    = templatedir'\tame.xcd'
tame_rsp    = responsedir'\tame.xcd'
'@sed -f' paths_sed tame_tmp     '>' tame_rsp
CALL LINEOUT log1, 'SED return code for Tame:' rc
IF rc><0 THEN RETURN rc

/* 4OS2 alternative commandshell */
forostwo_tmp    = templatedir'\4os2.xcd'
forostwo_rsp    = responsedir'\4os2.xcd'
'@sed -f' paths_sed forostwo_tmp     '>' forostwo_rsp
CALL LINEOUT log1, 'SED return code for 4OS2:' rc
IF rc><0 THEN RETURN rc

klibc_tmp    = templatedir'\klibc.xcd'
klibc_rsp    = responsedir'\klibc.xcd'
'@sed -f' paths_sed klibc_tmp     '>' klibc_rsp
CALL LINEOUT log1, 'SED return code for KLIBC:' rc
IF rc><0 THEN RETURN rc

klibccfg_tmp    = templatedir'\klibccfg.xcd'
klibccfg_rsp    = responsedir'\klibccfg.xcd'
'@sed -f' paths_sed klibccfg_tmp     '>' klibccfg_rsp
CALL LINEOUT log1, 'SED return code for KLIBCCFG:' rc
IF rc><0 THEN RETURN rc

innolibc_tmp   = templatedir'\innolibc.xcd'
innolibc_rsp   = responsedir'\innolibc.xcd'
'@sed -f' paths_sed innolibc_tmp     '>' innolibc_rsp
CALL LINEOUT log1, 'SED return code for INNOLIBC:' rc
IF rc><0 THEN RETURN rc

emxrt_tmp      = templatedir'\emxrt.xcd'
emxrt_rsp      = responsedir'\emxrt.xcd'
'@sed -f' paths_sed emxrt_tmp     '>' emxrt_rsp
CALL LINEOUT log1, 'SED return code for EMXRT:' rc
IF rc><0 THEN RETURN rc

coreutils_tmp  = templatedir'\coreutil.xcd'
coreutils_rsp  = responsedir'\coreutil.xcd'
'@sed -f' paths_sed coreutils_tmp     '>' coreutils_rsp
CALL LINEOUT log1, 'SED return code for coreutils:' rc
IF rc><0 THEN RETURN rc

uclip_tmp     = templatedir'\uclip.xcd'
uclip_rsp     = responsedir'\uclip.xcd'
'@sed -f' paths_sed uclip_tmp     '>' uclip_rsp
CALL LINEOUT log1, 'SED return code for UniClip:' rc
IF rc><0 THEN RETURN rc

ecif_tmp      = templatedir'\ecif.xcd'
ecif_rsp      = responsedir'\ecif.xcd'
'@sed -f' paths_sed ecif_tmp     '>' ecif_rsp
CALL LINEOUT log1, 'SED return code for ECIF:' rc
IF rc><0 THEN RETURN rc

/* AMOUSE */
amouse_tmp    = templatedir'\amouse.xcd'
amouse_rsp    = responsedir'\amouse.xcd'
'@sed -f' paths_sed amouse_tmp     '>' amouse_rsp
CALL LINEOUT log1, 'SED return code for AMouse:' rc
IF rc><0 THEN RETURN rc

mptswrap_tmp   = templatedir'\mptswrap.xcd'
mptswrap_rsp   = responsedir'\mptswrap.xcd'
'@sed -f' paths_sed mptswrap_tmp     '>' mptswrap_rsp
CALL LINEOUT log1, 'SED return code for MPTSWRAP:' rc
IF rc><0 THEN RETURN rc

ecort_rsp    = responsedir'\ecort.xcd'
ecort_tmp    = templatedir'\ecort.xcd'
'@sed -f' paths_sed ecort_tmp     '>' ecort_rsp
CALL LINEOUT log1, 'SED return code for ECORT:' rc
IF rc><0 THEN RETURN rc

jvmtcp_rsp   = responsedir'\jvmtcp.xcd'
jvmtcp_tmp   = templatedir'\jvmtcp.xcd'
'@sed -f' paths_sed jvmtcp_tmp     '>' jvmtcp_rsp
CALL LINEOUT log1, 'SED return code for JVMTCP:' rc
IF rc><0 THEN RETURN rc

/* create empty response file to force MPTS to run a sanity check */
mptsclean_rsp = responsedir'\MPTSCLN.RSP'
call lineout mptsclean_rsp, '  '
call lineout mptsclean_rsp

/* Multimedia default response file */
mmecs_rsp    = responsedir'\mmedia.rsp'
mmecs_tmp    = templatedir'\mmedia.rsp'
'@sed -f' paths_sed mmecs_tmp     '>' mmecs_rsp
CALL LINEOUT log1, 'SED return code for MMECS:' rc
IF rc><0 THEN RETURN rc

/* copy object and class migration lists */

mmobj_tmp  = templatedir'\MMOBJ.LST'
mmobj_rsp  = responsedir'\MMOBJ.LST'
'@COPY' mmobj_tmp mmobj_rsp
CALL LINEOUT log1, 'COPY return code:' rc
IF rc><0 THEN RETURN rc

mmclass_tmp  = templatedir'\MMCLASS.LST'
mmclass_rsp  = responsedir'\MMCLASS.LST'
'@COPY' mmclass_tmp mmclass_rsp
CALL LINEOUT log1, 'COPY return code:' rc
IF rc><0 THEN RETURN rc

/* Other response files we need to look at */
peer_rsp     = responsedir'\peer.rsp'

/* Always copy the books response file (should check PEER.RSP first?) */
'@COPY' book_tmp book_rsp
CALL LINEOUT log1, 'COPY return code:' rc
IF rc><0 THEN RETURN rc

/* copy seinst to harddisk for compatibility issues */
call eCSMakePath instdrv||'\var\cid'
'@copy '||srcdrv||'\cid\exe\os2\*.* '||instdrv||'\var\cid /v >>'||log2
CALL LINEOUT log1, 'COPY return code:' rc
IF rc><0 THEN RETURN rc

/* create REG file to switch off eShutdown (always) */
    '@sed -f' paths_sed estyler_tmp  '>' estyler_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc

/* copy XShutDown enabling reg file to rspfile dir */
'@COPY' xshutdwn_tmp xshutdwn_rsp
CALL LINEOUT log1, 'COPY return code:' rc
IF rc><0 THEN RETURN rc

/* create installation XML file for WarpIn (always) */
    '@sed -f' paths_sed warpin_tmp  '>' warpin_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc

/* create installation XML file for eWorkPlace (always) */
    '@sed -f' paths_sed ewps_tmp  '>' ewps_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc

/* create eCS MT installation XML file for WarpIn (always) */
    '@sed -f' paths_sed ecsmt_tmp  '>' ecsmt_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc

/*
 * Delete GUIDPROC comments from PEER.RSP so LANINSTR doesn't complain.
 */
IF STREAM( peer_rsp, 'C', 'QUERY EXISTS') \= '' THEN
    '@CALL CUBE { DELLINE "*" ( ALL }' peer_rsp '2>&1 >>' log2


IF CheckKey( mode_rsp, 'INSTALLMETHOD', 'EASY') THEN DO
    /* This is an Easy Install, so copy the default response files */
    '@sed -f' paths_sed ecsprod_tmp  '>' ecsprod_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc
/*
    '@sed -f' paths_sed netscape_tmp '>' netscape_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc
*/
    '@sed -f' paths_sed ffst_tmp     '>' ffst_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc
    '@sed -f' paths_sed package_tmp  '>' package_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc
    '@sed -f' paths_sed ibmweb_tmp   '>' ibmweb_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc
    '@sed -f' paths_sed java_tmp     '>' java_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc
    '@sed -f' paths_sed rsj_tmp      '>' rsj_rsp
     CALL LINEOUT log1, 'SED return code:' rc
     IF rc><0 THEN RETURN rc

    IF CheckKey( responsedir'\MPTS.RSP', '* NETGEN_install', '1') = 1 THEN DO
        '@sed -f' paths_sed tcpip_tmp    '>' tcpip_rsp
        CALL LINEOUT log1, 'SED return code:' rc
        IF rc><0 THEN RETURN rc
    END

    /*
     * WORKAROUND FOR INSTALLER: In PEER.RSP, InstallGUI must == INSTALL if
     * Peer service is installed, otherwise 'Sharing and Connecting' etc.
     * will not get created.  Applies to Easy Install only.
     */
    IF CheckKey( peer_rsp, 'InstallPeerService', 'INSTALL') THEN DO
        '@CALL CUBE { REPSTRING "REMOVE" WITH "INSTALL" IN "InstallGUI" ( ALL *ID }' peer_rsp '2>&1 >>' log2
    END

END
ELSE IF CheckKey( responsedir'\MPTS.RSP', '* NETGEN_LAN', '0') == 1 THEN DO
    /* Tell Peer not to install if the user deselected it (Advanced only). */
    '@CALL CUBE { REPSTRING "INSTALL" WITH "REMOVE" IN "InstallRequester" ( ALL *ID }' peer_rsp '2>&1 >>' log2
    '@CALL CUBE { REPSTRING "INSTALL" WITH "REMOVE" IN "InstallPeerService" ( ALL *ID }' peer_rsp '2>&1 >>' log2
END

/* the code from this part on should run only once (@@fixes 1625) */

IF PHASE >< 'PHASE2' THEN DO

/* Add keyword for no COM.SYS if serial support was not selected */
IF GetValue( hwopt_rsp, 'SerialDeviceSupport') == '' THEN DO
    CALL LINEOUT hwopt_rsp, 'SerialDeviceSupport=0'
    CALL STREAM  hwopt_rsp, 'C', 'CLOSE'
END

/* Check APM availability and correct HWOPT.RSP accordingly */
IF GetValue( hwopt_rsp, 'APM') == '2' & CheckKey( responsedir||'\hardware.rsp', 'ACPI.PSD', '?') = 0 THEN DO
 rc = 0 /* returncode will be changed by the [VK] APMPRES.EXE check (0 or 1) */
 '@cmd /c apmpres.exe'
 resultcode = rc
 '@CALL CUBE { REPLINE "APM=" WITH "APM='resultcode'" ( ADDTOP *ID }' hwopt_rsp '2>&1 >>' log2
END

/* Add keyword for default mouse installation in phase 1 if Amouse is selected, AMouse will be installed in phase 2 */
IF GetValue( ecsprod1_rsp, 'AMOUSE') == '1' THEN DO
    CALL LINEOUT hwopt_rsp, 'Mouse=1'
    CALL STREAM  hwopt_rsp, 'C', 'CLOSE'
END

/* fix install path for Mozilla in browser.rsp */
/* mozilla zip has mozilla as root already */
/*
IF STREAM( ibmweb_rsp, 'C', 'QUERY EXISTS' ) \= '' THEN DO
    webdir   = STRIP( GetValue( ibmweb_rsp, 'TARGET'))
    IF ( webdir = '') THEN webdir = instdrv'\PROGRAMS'
    IF lastpos('\', webdir) = length(webdir) THEN webdir = left(webdir, length(webdir) - 1)
    IF translate( right(webdir, length(webdir) - lastpos('\', webdir))) = 'MOZILLA' THEN webdir = left(webdir, lastpos('\', webdir) - 1)
    webdir=strip(webdir)
    '@CALL CUBE { REPLINE "TARGET" WITH "TARGET   = 'webdir'" ( *ID }' ibmweb_rsp '2>&1 >>' log2
END
*/
/* Read LOCALE.RSP (generate it if it doesn't exist) */
IF STREAM( locale_rsp, 'C', 'QUERY EXISTS' )= '' THEN DO
    country  = VALUE('COUNTRY',,  'OS2ENVIRONMENT')
    locale   = VALUE('LOCALE',,   'OS2ENVIRONMENT')
    keyboard = VALUE('KEYBOARD',, 'OS2ENVIRONMENT')
    codepage = VALUE('CODEPAGE',, 'OS2ENVIRONMENT')
    timezone = VALUE('TZ',,       'OS2ENVIRONMENT')
    CALL LINEOUT locale_rsp, country
    CALL LINEOUT locale_rsp, locale
    CALL LINEOUT locale_rsp, keyboard
    CALL LINEOUT locale_rsp, codepage
    CALL LINEOUT locale_rsp, timezone
    CALL LINEOUT locale_rsp, '0'
    CALL STREAM  locale_rsp, 'C', 'CLOSE'
END
ELSE DO
    country  = STRIP( LINEIN( locale_rsp ))
    locale   = STRIP( LINEIN( locale_rsp ))
    keyboard = STRIP( LINEIN( locale_rsp ))
    codepage = STRIP( LINEIN( locale_rsp ))
    timezone = STRIP( LINEIN( locale_rsp ))
    CALL STREAM locale_rsp, 'C', 'CLOSE'
END

IF STREAM( base_rsp, 'C', 'QUERY EXISTS') = '' THEN DO
    CALL LINEOUT base_rsp, '* SEINST Response File - Common Keywords'
    CALL LINEOUT base_rsp, '* '
    CALL LINEOUT base_rsp, '* AUTOMATICALLY GENERATED FILE - DO NOT EDIT!'
    CALL LINEOUT base_rsp, 'TargetDrive=' || SUBSTR( instdrv, 1, 1 )
    CALL LINEOUT base_rsp, 'ExitOnError=1'
    CALL LINEOUT base_rsp, 'RebootRequired=0'
    CALL LINEOUT base_rsp, 'ProgressIndication=0'
    CALL LINEOUT base_rsp, 'MultimediaSupport=0'
    CALL LINEOUT base_rsp, 'DisplayAdapter=4'
    CALL LINEOUT base_rsp, 'CountryCode='country
    CALL LINEOUT base_rsp, 'Locale='locale

    seinst_keyboard=kbdmap(keyboard)
    CALL LINEOUT log1, 'Keyboard mapping for SEINST: '||keyboard||'->'||seinst_keyboard
    CALL LINEOUT base_rsp,seinst_keyboard
    /* (No need for Codepage, CONFSED will adjust it as needed after install.) */

    IF STREAM( package_rsp, 'C', 'QUERY EXISTS') <> '' THEN DO
        CALL LINEOUT base_rsp, 'Include='package_rsp
    END

    IF STREAM( hwopt_rsp, 'C', 'QUERY EXISTS') <> '' THEN DO
        CALL LINEOUT base_rsp, 'Include='hwopt_rsp
    END

    CALL STREAM base_rsp, 'C', 'CLOSE'
END

CALL PCMAdditionalDriver

/* Append ECSPROD1.RSP (created by eiHardwr.gps) to ECSPROD.RSP */
DO WHILE LINES( ecsprod1_rsp )
   ib = LINEIN( ecsprod1_rsp )
   CALL LINEOUT ecsprod_rsp, ib
END
CALL LINEOUT ecsprod_rsp
CALL LINEOUT ecsprod1_rsp
'@attrib -r' ecsprod1_rsp
'@erase' ecsprod1_rsp

IF CheckKey( responsedir'\BROWSER.RSP', 'INSTALL', '1') THEN
DO
    /* Determine MOZ_PLUG_PATH and MOZILLA_HOME and add it to the config.sys */
    mozhome = ''
    mozplug = ''

    /* check if this is a migration -> query old config */
    mig_rsp = responsedir'\MIGRATE.RSP'
    IF STREAM( mig_rsp, 'C', 'QUERY EXISTS') \= '' THEN
    DO
        mozhome = STRIP( GetValue( mig_rsp, 'MOZILLA_HOME'))
        mozplug = STRIP( GetValue( mig_rsp, 'MOZ_PLUGIN_PATH'))
    END

    /* Query HOME_DIR in ecsprod.rsp */
    IF mozhome = '' THEN
    DO
        mozhome = GetValue( responsedir'\ECSPROD.RSP', 'HOME_DIR')
        IF mozhome = '' THEN mozhome = instdrv'\HOME\DEFAULT'
    END

    IF mozplug = '' THEN
    DO
        mozplug = GetValue( responsedir'\ECSPROD.RSP', 'PROGRAMS_DIR')
        IF mozplug = '' THEN mozplug = instdrv'\PROGRAMS'
        mozplug=mozplug||'\MOZ_PLUG'
    END

    CALL LINEOUT log1, 'Setting Mozilla home directory to' mozhome '...'
    '@CALL CUBE { ADDLINE "MOZILLA_HOME='mozhome'" ( IFNEW *ID }' responsedir'\ECSPROD.RSP >>' log2' 2>&1'
    '@CALL CUBE { ADDLINE "MOZ_PLUGIN_PATH='mozplug'" ( IFNEW *ID }' responsedir'\ECSPROD.RSP >>' log2' 2>&1'

END

END /* code runs only in first phase (@@fixes 1625) */

RETURN 0


/*
 * If any non-SEINST PCMCIA drivers were selected, then install PCMCIA
 * support; we will put the driver into CONFIG.SYS later (HWMERGE.CMD)
 */
PCMAdditionalDriver: PROCEDURE EXPOSE responsedir

    pcmcia_rsp = responsedir'\PCMCIA.RSP'
    hwopt_rsp  = responsedir'\HWOPT.RSP'
    optionline = 'PCMCIA=19'

    IF CheckKey( pcmcia_rsp, 'TYPE', 'DRIVER') THEN
        '@CALL CUBE { ADDLINE "'optionline'" ( BEFORE "PCMCIAOptions" *ID }' hwopt_rsp

RETURN


/*
 * Condition handlers
 */
SYNTAX:
    SAY 'DEFRSP.CMD: a syntax error was encountered on line' sigl':'
    SAY SOURCELINE( sigl )
EXIT sigl
