/*
 * Filename: $Id: LCUINST.CMD,v 1.80 2007/10/25 17:45:39 tjb Exp $
 *  Purpose: Invoke individual CID installers in a controlled environment
 */

CALL ON FAILURE

/*---------------------------------------------------*/
/*         DO NOT MODIFY THE NEXT EIGHT LINES        */
/*---------------------------------------------------*/
PARSE ARG client logfile additional

QUEUE_REBOOT = 0
CALL_AGAIN   = 0

CALL AddDLLFunctions

x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'CAS_STATE'
x.0.default  = ''


/*---------------------------------------------------*/
/*             MODIFICATIONS START HERE              */
/*---------------------------------------------------*/

/*****************************************************/
/*                 VARIABLES SECTION                 */
/*****************************************************/

/*
 * Determine the current phase of installation.
 */
phasevar = VALUE( x.0.statevar,, 'OS2ENVIRONMENT')
IF phasevar = '' THEN phasevar = '0'
SELECT
    WHEN phasevar = '0' THEN phase = 1
    WHEN phasevar = '1' THEN phase = 2
    WHEN phasevar = '2' THEN phase = 3
    OTHERWISE                phase = 4
END

/*
 * Set the location variables.
 */
ramdrive  = VALUE( 'MEMDRIVE',,'OS2ENVIRONMENT') || ':'  /* Obtain memory disk */
instdrive = 'G:'                                  /* Installation drive for base OS       */
logpath   = 'G:\VAR\LOG'                                  /* Log file directory                   */
rsppath   = 'G:\ECS\INSTALL\RSP'                                  /* Response file directory              */
netdrive  = 'G:'                                  /* Installation drive for networking    */
configsys = instdrive || '\CONFIG.SYS'                   /* Fully qualified path to CONFIG.SYS   */
logprefix = logpath   || '\' || phase || '_'             /* Phase-specific log file prefix       */
userini   = instdrive || '\OS2\OS2.INI'                  /* User INI file                        */
systemini = instdrive || '\OS2\OS2SYS.INI'               /* System INI file                      */
mmbase    = instdrive || '\MMOS2'                        /* Multimedia install target            */
warpin_dir= 'G:\ECS\INSTALL\WARPIN'

srcdrive  = 'S:'                                   /* Source drive (e.g. installation CD)  */
templates = 'S:\ECS\INSTALL\DEFAULT'                                  /* Location of SED templates            */
cid_dll   = srcdrive || '\cid\dll\os2'                   /* Path to IBM CID DLL files            */
cid_exe   = instdrive || '\var\cid'                      /* Path to IBM CID EXE files            */
prodpath  = srcdrive || '\cid\server'                    /* Location of CID product images       */
os2image  = srcdrive || '\os2image'                      /* OS/2 product image directory         */
lcufiles  = srcdrive || '\cid\locinstu'                  /* Location of LCU files                */
srvifs    = srcdrive || '\cid\srvifs'                    /* Location of SRVIFS files             */

nwcontext = ''                                /* Name of Netware contect (if set)     */
nwprefsrv = ''                                /* Name of Netware preferred server     */

cidserver = 'CIDECS'                                /* Name of CID server (if applicable)   */
cdlabel   = 'ECS_CDRUN'                                  /* Volume label of source medium        */
langcode  = 'en'                                     /* NLV language code                    */

/* The next two must be specified without drive letter */
ecs_inst = '\ecs\install'                                /* Path to eCS installer files          */
ecs_nls  = ecs_inst'\nls\'langcode                       /* Path to installer language files     */

IF phase = 1 THEN DO
    ecs_dll = srcdrive || ecs_inst                       /* Path to eCS installer DLLs           */
    ecs_exe = srcdrive || ecs_inst                       /* Path to eCS installer EXEs           */
    ecs_cmd = srcdrive || ecs_inst                       /* Path to eCS installer CMD scripts    */
END
ELSE DO
    ecs_dll = instdrive || ecs_inst                      /* Path to eCS installer DLLs           */
    ecs_exe = instdrive || ecs_inst                      /* Path to eCS installer EXEs           */
    ecs_cmd = instdrive || ecs_inst                      /* Path to eCS installer CMD scripts    */
END


/*
 * Save the Drive/Path/File variables to the environment,
 * as the various product installers will require them.
 */
CALL VALUE 'DPF_INSTDRIVE', instdrive, 'OS2ENVIRONMENT'
CALL VALUE 'DPF_NETDRIVE',  netdrive,  'OS2ENVIRONMENT'
CALL VALUE 'DPF_SRCDRIVE',  srcdrive,  'OS2ENVIRONMENT'
CALL VALUE 'DPF_CONFIGSYS', configsys, 'OS2ENVIRONMENT'
CALL VALUE 'DPF_LOGPATH',   logpath,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_LOGPREFIX', logprefix, 'OS2ENVIRONMENT'
CALL VALUE 'DPF_RSPFILES',  rsppath,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_ECSINST',   ecs_inst,  'OS2ENVIRONMENT'
CALL VALUE 'DPF_ECSDLL',    ecs_dll,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_ECSEXE',    ecs_exe,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_ECSCMD',    ecs_cmd,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_ECSNLS',    ecs_nls,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_PRODUCTS',  prodpath,  'OS2ENVIRONMENT'
CALL VALUE 'DPF_CIDDLL',    cid_dll,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_CIDEXE',    cid_exe,   'OS2ENVIRONMENT'
CALL VALUE 'DPF_OS2IMAGE',  os2image,  'OS2ENVIRONMENT'
CALL VALUE 'DPF_TEMPLATES', templates, 'OS2ENVIRONMENT'
CALL VALUE 'DPF_MEDIALANG', langcode,  'OS2ENVIRONMENT'
CALL VALUE 'DPF_MMBASE',    mmbase,    'OS2ENVIRONMENT'
CALL VALUE 'DPF_WARPIN',    warpin_dir,'OS2ENVIRONMENT'
CALL VALUE 'HOMEOS2INI',    userini,   'OS2ENVIRONMENT'
CALL VALUE 'HOMEOS2SYSINI', systemini, 'OS2ENVIRONMENT'

/*
 * Set the INSTALLDRIVE variable for SEINST
 */
CALL VALUE 'INSTALLDRIVE', instdrive, 'OS2ENVIRONMENT'

/* make sure SNAP will detect the correct language (of the CD) */

media_lang = ''
media_lang = strip(translate(word(linein(srcdrive'\ecs\ecs_inst.flg'),3)))
if media_lang = '' THEN media_lang = 'EN_US'
CALL VALUE 'LANG', media_lang, 'OS2ENVIRONMENT'

/*
 * Generate the installable products list.
 */

catalogue = rsppath || '\PRODUCTS.CAT'
products_to_install = ''

rc = stream( catalogue, 'C', 'OPEN READ' )
DO WHILE LINES( catalogue )
    line = LINEIN( catalogue )
    products_to_install = products_to_install line
END
rc = stream( catalogue, 'C', 'CLOSE' )

/*****************************************************/
/*               PRODUCT DATA SECTION                */
/*****************************************************/
/*  Note: any change to the product index numbers    */
/*  will require a corresponding change to the       */
/*  ECS_LCU.MSG message file.                        */
/*****************************************************/

x.seinst     = 1                                         /* structure index                      */
x.1.message  = GetNLSMessage( x.seinst )                 /* user message (shown during install)  */
x.1.name     = 'SEINST'                                  /* product name (appears in logfile)    */
x.1.statevar = 'CAS_SEINST'                              /* state variable name                  */
x.1.instprog = cid_exe || '\SEINST.EXE',                 /* fully qualified install program name */
               ' /B:'  || instdrive,                     /*  - bootdrive                         */
               ' /S:'  || os2image,                      /*  - source directory                  */
               ' /T:'  || cid_exe,                       /*  - service directory                 */
               ' /L1:' || logprefix || 'BASE.L1',        /*  - log file                          */
               ' /R:'  || rsppath || '\BASE.RSP',        /*  - response file (no auto-selection) */
               ' 2>&1 >NUL'                              /* suppress console messages            */
x.1.rspdir   = ''                                        /* response path (only for auto-select) */
x.1.default  = ''                                        /* default file (only for auto-select)  */

x.mpts       = 2                                         /* structure index                      */
x.2.message  = GetNLSMessage( x.mpts )                   /* user message                         */
x.2.name     = 'MPTS'                                    /* product name                         */
x.2.statevar = 'CAS_MPTS'                                /* state variable name                  */
x.2.instprog = ecs_cmd  || '\MPTS.CMD',                  /* wrapper script for installer         */
               prodpath || '\mpts\MPTS.EXE',             /* fully qualified install program      */
               ' /E:MAINT',                              /*  - maintenance installation          */
               ' /S:'  || prodpath  || '\mpts',          /*  - source directory                  */
               ' /T:'  || netdrive  || '\',              /*  - target directory                  */
               ' /TU:' || instdrive || '\',              /*  - location of config.sys to update  */
               ' /L1:' || logprefix || 'MPTS.L1',        /*  - log file                          */
               ' /R:'  || rsppath   || '\MPTS.RSP'       /*  - response file (no auto)           */
x.2.rspdir   = ''
x.2.default  = ''

x.hwmerge    = 3                                         /* structure index                      */
x.3.message  = GetNLSMessage( x.hwmerge )                /* user message                         */
x.3.name     = 'HWMERGE'                                 /* product name                         */
x.3.statevar = 'CAS_HWMERGE'                             /* state variable name                  */
x.3.instprog = ecs_cmd || '\HWMERGE.CMD',                /* fully qualified install program name */
               ' ' || logprefix || 'HWMERG.L1',          /*  - message log file                  */
               ' ' || logprefix || 'HWMERG.L2'           /*  - output log file                   */
x.3.rspdir   = ''
x.3.default  = ''

x.confsed    = 4                                         /* structure index                      */
x.4.message  = GetNLSMessage( x.confsed )                /* user message                         */
x.4.name     = 'CONFSED'                                 /* product name                         */
x.4.statevar = 'CAS_CONFSED'                             /* state variable name                  */
x.4.instprog = ecs_cmd || '\CONFSED.CMD'                 /* fully qualified install program name */
x.4.rspdir   = ''
x.4.default  = ''

x.ecsprod    = 5                                         /* structure index                      */
x.5.message  = GetNLSMessage( x.ecsprod )                /* user message                         */
x.5.name     = 'ECSPROD'                                 /* product name                         */
x.5.statevar = 'CAS_ECSPROD'                             /* state variable name                  */
x.5.instprog = ecs_cmd || '\ECSPROD.CMD',                /* fully qualified install program name */
               ' ' || logprefix || 'ECSPRD.L1',          /*  - message log file                  */
               ' ' || logprefix || 'ECSPRD.L2'           /*  - output log file                   */
x.5.rspdir   = ''
x.5.default  = ''

x.warpin      = 6                                        /* structure index                      */
x.6.message   = GetNLSMessage( x.warpin )                /* user message                         */
x.6.name      = 'WARPIN'                                 /* product name                         */
x.6.statevar  = 'CAS_WARPIN'                             /* state variable name                  */
x.6.instprog  = srcdrive || '\ECS\INSTALL\WARPIN.CMD'    /* fully qualified install program name */
x.6.rspdir    = ''
x.6.default   = ''

x.cairo       = 7                                        /* structure index                      */
x.7.message   = GetNLSMessage( x.cairo )                 /* user message                         */
x.7.name      = 'CAIRO'                                  /* product name                         */
x.7.statevar  = 'CAS_CAIRO'                              /* state variable name                  */
x.7.instprog  = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\CAIRO.XCD',       /*  - response file                     */
                ' >' || logprefix || 'CAIRO.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'CAIRO.L2'
x.7.rspdir    = ''
x.7.default   = ''

x.dlgbase    = 8                                         /* structure index                      */
x.8.message  = GetNLSMessage( x.dlgbase )                /* user message                         */
x.8.name     = 'DIALOG BASE'                             /* product name                         */
x.8.statevar = 'CAS_DLGBASE'                             /* state variable name                  */
x.8.instprog = ecs_cmd || '\DLGINST.CMD',                /* fully qualified install program name */
                ' BASE',                                 /*  - product flag (base OS)            */
                ' ' || instdrive,                        /*  - installation drive                */
                ' 1>'logpath'\DIALOG.L1',                /*  - overview log file                 */
                ' 2>'logpath'\DIALOG.L2'                 /*  - detailed log file                 */

x.8.rspdir   = ''
x.8.default  = ''

x.dlgprint   = 9                                         /* structure index                      */
x.9.message  = GetNLSMessage( x.dlgprint )               /* user message                        */
x.9.name     = 'DIALOG PRINT'                            /* product name                         */
x.9.statevar = 'CAS_DLGPRINT'                            /* state variable name                  */
x.9.instprog = ecs_cmd || '\DLGINST.CMD',                /* fully qualified install program name */
                ' PRINT',                                /*  - product flag (print drivers)      */
                ' ' || instdrive,                        /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.9.rspdir   = ''
x.9.default  = ''

x.dlgmpts     = 10                                       /* structure index                      */
x.10.message  = GetNLSMessage( x.dlgmpts )               /* user message                         */
x.10.name     = 'DIALOG MPTS'                            /* product name                         */
x.10.statevar = 'CAS_DLGMPTS'                            /* state variable name                  */
x.10.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' MPTS',                                 /*  - product flag (MPTS)               */
                ' ' || netdrive,                         /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.10.rspdir   = ''
x.10.default  = ''

x.blddesk     = 11                                       /* structure index                      */
x.11.message  = GetNLSMessage( x.blddesk )               /* user message                         */
x.11.name     = 'BLDDESK'                                /* product name                         */
x.11.statevar = 'CAS_BLDDESK'                            /* state variable name                  */
x.11.instprog = ecs_cmd || '\BLDDESK.CMD',               /* fully qualified install program name */
                ' ' || instdrive,                        /*  - installation drive                */
                ' ' || logprefix || 'DESK.L2'            /*  - log file                          */
x.11.rspdir   = ''
x.11.default  = ''

x.previous    = 12                                       /* structure index                      */
x.12.message  = GetNLSMessage( x.previous )              /* user message                         */
x.12.name     = 'PREVIOUS.GPS'                           /* product name                         */
x.12.statevar = 'CAS_PREVIOUS'                           /* state variable name                  */
x.12.instprog = ecs_cmd || '\PREVIOUS.CMD',              /* fully qualified install program name */
                '""',                                    /*  -                                   */
                ' ' || cdlabel,                          /*  - volume label of source drive      */
                ' ' || langcode,                         /*  - language code of current version  */
                ' ' || instdrive,                        /*  -                                   */
                ' ' || netdrive,                         /*  -                                   */
                ' ' || srcdrive                          /*  -                                   */
x.12.rspdir   = ''
x.12.default  = ''

x.thinifs     = 13                                       /* structure index                      */
x.13.message  = GetNLSMessage( x.thinifs )               /* user message                         */
x.13.name     = 'THINIFS'                                /* product name                         */
x.13.statevar = 'CAS_THINIFS'                            /* state variable name                  */
x.13.instprog = ecs_cmd'\SRVIFS.CMD',                    /* install wrapper script               */
                srvifs'\THINIFS.EXE ',                   /* fully qualified install program name */
                ' /S:'   || srvifs,                      /*  - source directory                  */
                ' /T:'   || instdrive'\SRVIFSRQ',        /*  - target directory                  */
                ' /TU:'  || instdrive || '\',            /*  - location of CONFIG.SYS            */
                ' /L1:'  || logprefix || 'SRVIFS.L1',    /*  - log file                          */
                ' /REQ:*',                               /*  - client requester name (random)    */
                ' /SRV:' || cidserver,                   /*  - code server name                  */
                ' /D:'   || srcdrive                     /*  - drive letter to assign to server  */
x.13.rspdir   = ''
x.13.default  = ''

x.ifsdel      = 14                                       /* structure index                      */
x.14.message  = GetNLSMessage( x.ifsdel )                /* user message                         */
x.14.name     = 'IFSDEL'                                 /* product name                         */
x.14.statevar = 'CAS_IFSDEL'                             /* state variable name                  */
x.14.instprog = srvifs'\IFSDEL.EXE',                     /* fully qualified install program name */
                ' /T:'  || instdrive || '\SRVIFSRQ',     /*  - target directory                  */
                ' /TU:' || instdrive || '\'              /*  - location of CONFIG.SYS            */
x.14.rspdir   = ''
x.14.default  = ''

x.finish      = 15                                       /* structure index                      */
x.15.message  = GetNLSMessage( x.finish, phase )         /* user message                         */
x.15.name     = 'FINISH' phase                           /* product name                         */
x.15.statevar = 'CAS_FINISH'                             /* state variable name                  */
x.15.instprog = ecs_cmd || '\FINISH.CMD',                /* fully qualified install program name */
                ' PHASE' || phase                        /*  - current phase of installation     */
x.15.rspdir   = ''
x.15.default  = ''

x.initphase   = 16                                       /* structure index                      */
x.16.message  = GetNLSMessage( x.initphase, phase )      /* user message                         */
x.16.name     = 'INITPHASE' phase                        /* product name                         */
x.16.statevar = 'CAS_INITPH'                             /* state variable name                  */
x.16.instprog = ecs_cmd || '\INITPH.CMD',                /* fully qualified install program name */
                ' PHASE' || phase                        /*  - current phase of installation     */
x.16.rspdir   = ''
x.16.default  = ''

x.chkjava     = 17                                       /* structure index                      */
x.17.message  = GetNLSMessage( x.chkjava )               /* user message                         */
x.17.name     = 'CHK4JAVA'                               /* product name                         */
x.17.statevar = 'CAS_CHKJAVA'                            /* state variable name                  */
x.17.instprog = ecs_cmd || '\CHK4JAVA.CMD'               /* fully qualified install program name */
x.17.rspdir   = ''
x.17.default  = ''

x.netscape    = 18                                       /* structure index                      */
x.18.message  = GetNLSMessage( x.netscape )              /* user message                         */
x.18.name     = 'NETSCAPE'                               /* product name                         */
x.18.statevar = 'CAS_NETSCAPE'                           /* state variable name                  */
x.18.instprog = ecs_cmd || '\NETSCAPE.CMD ',             /* wrapper script for installer         */
                prodpath || '\NETSCAPE\INSTALL.EXE',     /* fully qualified install program name */
                ' /X',                                   /*  - interactive flag                  */
                ' /NMSG',                                /*  - ?                                 */
                ' /O:DRIVE',                             /*  - type of installation              */
                ' /R:'  || rsppath || '\NETSCAPE.RSP',   /*  - response file                     */
                ' /L2:' || logprefix || 'NS46.L2'        /*  - log file                          */
x.18.rspdir   = ''
x.18.default  = ''

x.npfi        = 19                                              /* structure index               */
x.19.message  = GetNLSMessage( x.npfi )                         /* user message                  */
x.19.name     = 'FISETUP'                                       /* product name                  */
x.19.statevar = 'CAS_NPFI'                                      /* state variable name           */
x.19.instprog = ecs_cmd   || '\NPFI.CMD',                       /* wrapper script for installer  */
                instdrive || '\os2\install\wsfi\FISETUP.EXE',   /* fully qualified program name  */
                ' /B:'    || instdrive,                         /*  - boot drive                 */
                ' /S:'    || instdrive || '\os2\install\wsfi',  /*  - source path                */
                ' /NORESTARTSHELL',                             /*  - do not restart WPS         */
                ' /U',                                          /*  - unattended mode            */
                ' /L1:'   || logprefix || 'NPFI.L1'             /*  - log file                   */
x.19.rspdir   = ''
x.19.default  = ''

x.fibase      = 20                                            /* structure index                 */
x.20.message  = GetNLSMessage( x.fibase )                     /* user message                    */
x.20.name     = 'FIBASE'                                      /* product name                    */
x.20.statevar = 'CAS_FIBASE'                                  /* state variable name             */
x.20.instprog = instdrive || '\os2\install\CLIFI.EXE',        /* fully qualified install program */
                ' /A:C',                                      /*  - action flag                  */
                ' /S:'  || os2image || '\FI',                 /*  - source directory             */
                ' /B:'  || instdrive,                         /*  - boot drive                   */
                ' /L1:' || logprefix || 'CLIFI.L1',           /*  - error log file               */
                ' /L2:' || logprefix || 'CLIFI.L2',           /*  - history log file             */
                ' /R:'||instdrive||'\os2\install\FIBASE.RSP', /*  - definitions response file    */
                ' /R2:' || rsppath || '\BASE.RSP'             /*  - options response file        */
x.20.rspdir   = ''
x.20.default  = ''

x.peer        = 21                                       /* structure index                      */
x.21.message  = GetNLSMessage( x.peer )                  /* user message                         */
x.21.name     = 'PEER'                                   /* product name                         */
x.21.statevar = 'CAS_PEER'                               /* state variable name                  */
x.21.instprog = ecs_cmd || '\PEER.CMD ',                 /* wrapper script for installer         */
                prodpath || '\IBMLS\LANINSTR.EXE',       /* fully qualified install program name */
                ' /REQ',                                 /*  - install as client                 */
                ' /L1:' || logprefix || 'PEER.L1',       /*  - error log file                    */
                ' /L2:' || logprefix || 'PEER.L2',       /*  - history log file                  */
                ' /R:' || rsppath || '\PEER.RSP'         /*  - response file (no auto-selection) */
x.21.rspdir   = ''
x.21.default  = ''

x.dlgpeer     = 22                                       /* structure index                      */
x.22.message  = GetNLSMessage( x.dlgpeer )               /* user message                         */
x.22.name     = 'DIALOG PEER'                            /* product name                         */
x.22.statevar = 'CAS_DLGPEER'                            /* state variable name                  */
x.22.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' PEER',                                 /*  - product flag (LAN files)          */
                ' ' || netdrive,                         /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.22.rspdir   = ''
x.22.default  = ''

x.dlgpeerlk   = 23                                       /* structure index                      */
x.23.message  = GetNLSMessage( x.dlgpeerlk )             /* user message                         */
x.23.name     = 'DIALOG PEER (LOCKED)'                   /* product name                         */
x.23.statevar = 'CAS_DLGPEERLK'                          /* state variable name                  */
x.23.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' PEER',                                 /*  - product flag (LAN files)          */
                ' ' || instdrive || '\IBMLANLK',         /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.23.rspdir   = ''
x.23.default  = ''

x.dlgupm      = 24                                       /* structure index                      */
x.24.message  = GetNLSMessage( x.dlgupm )                /* user message                         */
x.24.name     = 'DIALOG UPM'                             /* product name                         */
x.24.statevar = 'CAS_DLGUPM'                             /* state variable name                  */
x.24.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' UPM',                                  /*  - product flag (UPM files)          */
                ' ' || netdrive,                         /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.24.rspdir   = ''
x.24.default  = ''

x.dlgupmlk    = 25                                       /* structure index                      */
x.25.message  = GetNLSMessage( x.dlgupmlk )              /* user message                         */
x.25.name     = 'DIALOG UPM (LOCKED)'                    /* product name                         */
x.25.statevar = 'CAS_DLGUPMLK'                           /* state variable name                  */
x.25.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' UPM',                                  /*  - product flag (UPM files)          */
                ' ' || instdrive || '\IBMLANLK',         /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.25.rspdir   = ''
x.25.default  = ''

x.books       = 26                                       /* structure index                      */
x.26.message  = GetNLSMessage( x.books )                 /* user message                         */
x.26.name     = 'BOOKS'                                  /* product name                         */
x.26.statevar = 'CAS_BOOKS'                              /* state variable name                  */
x.26.instprog = ecs_cmd || '\BOOKS.CMD'                  /* fully qualified install program name */
x.26.rspdir   = ''
x.26.default  = ''

x.browser     = 27                                       /* structure index                      */
x.27.message  = GetNLSMessage( x.browser )               /* user message                         */
x.27.name     = 'MOZILLA'                                /* product name                         */
x.27.statevar = 'CAS_BROWSER'                            /* state variable name                  */
x.27.instprog = ecs_cmd || '\MOZWEB.CMD ',               /* wrapper script for installer         */
                ' /R:'  || rsppath || '\BROWSER.RSP',    /*  - response file                     */
                ' /L2:' || logprefix || 'MOZWEB.L2'      /*  - log file                          */
x.27.rspdir   = ''
x.27.default  = ''

x.java142     = 28                                       /* structure index                      */
x.28.message  = GetNLSMessage( x.java142 )               /* user message                         */
x.28.name     = 'JAVA142'                                /* product name                         */
x.28.statevar = 'CAS_JAVA142'                            /* state variable name                  */
x.28.instprog = ecs_cmd || '\JAVA142.CMD'                /* fully qualified install program name */
x.28.rspdir   = ''
x.28.default  = ''

x.tcpapps     = 29                                       /* structure index                      */
x.29.message  = GetNLSMessage( x.tcpapps )               /* user message                         */
x.29.name     = 'TCP/IP'                                 /* product name                         */
x.29.statevar = 'CAS_TCPAPPS'                            /* state variable name                  */
x.29.instprog = ecs_cmd || '\TCPIP.CMD ',                /* wrapper script for installer         */
                prodpath || '\TCPAPPS\INSTALL.CMD',      /* fully qualified install program name */
                ' /A-',                                  /*  - action flag                       */
                ' /T:'  || netdrive,                     /*  - source directory                  */
                ' /TU:' || instdrive,                    /*  - boot drive                        */
                ' /L1:' || logprefix || 'TCPIP.L1',      /*  - log file                          */
                ' /LR:' || rsppath   || '\MPTS.RSP',     /*  - MPTS response file (no auto)      */
                ' /R:'  || rsppath   || '\TCPIP.RSP'     /*  - response file (no auto-selection) */
x.29.rspdir   = ''
x.29.default  = ''

x.dlgtcpip    = 30                                       /* structure index                      */
x.30.message  = GetNLSMessage( x.dlgtcpip )              /* user message                         */
x.30.name     = 'DIALOG TCP/IP'                          /* product name                         */
x.30.statevar = 'CAS_DLGTCPIP'                           /* state variable name                  */
x.30.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' TCPIP',                                /*  - product flag (TCP/IP apps)        */
                ' ' || netdrive,                         /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.30.rspdir   = ''
x.30.default  = ''

x.lcfagent    = 31                                       /* structure index                      */
x.31.message  = GetNLSMessage( x.lcfagent )              /* user message                         */
x.31.name     = 'TIVOLI'                                 /* product name                         */
x.31.statevar = 'CAS_LCFAGENT'                           /* state variable name                  */
x.31.instprog = prodpath || '\lcfagent\INSTALL',         /* fully qualified install program name */
                ' /A:I',                                 /* - action flag                        */
                ' /X',                                   /* - interactive flag                   */
                ' /S:'  || prodpath  || '\lcfagent',     /* - source directory                   */
                ' /L1:' || logprefix || 'TIVOLI.L1',     /* - error log file                     */
                ' /R:'  || rsppath   || '\LCFAGENT.RSP'  /* - response file (no auto-selection)  */
x.31.rspdir   = ''
x.31.default  = ''

x.ffst        = 32                                       /* structure index                      */
x.32.message  = GetNLSMessage( x.ffst )                  /* user message                         */
x.32.name     = 'FFST'                                   /* product name                         */
x.32.statevar = 'CAS_FFST'                               /* state variable name                  */
x.32.instprog = ecs_cmd  || '\FFST.CMD',                 /* wrapper script for installer         */
                prodpath || '\ffst\FFSTINST.EXE',        /* fully qualified install program      */
                ' /S:'   || prodpath  || '\ffst',        /*  - source directory                  */
                ' /L1:'  || logprefix || 'FFST.L1',      /*  - error log file                    */
                ' /ROUT:1'                               /*  - rout parameter                    */
x.32.rspdir   = ''
x.32.default  = ''

x.estyler     = 33                                       /* structure index                      */
x.33.message  = GetNLSMessage( x.estyler )               /* user message                         */
x.33.name     = 'ECSGUI'                                 /* product name                         */
x.33.statevar = 'CAS_ESTYLER'                            /* state variable name                  */
x.33.instprog = ecs_cmd || '\estyler.cmd',               /* fully qualified install program name */
                ' ' || cdlabel,                          /*  - volume label of source drive      */
                ' ' || langcode,                         /*  - language code of current version  */
                ' 2>&1 >' || logprefix || 'ESTLR.L2'     /*  - log file                          */
x.33.rspdir   = ''
x.33.default  = ''

x.gengradd    = 34                                       /* structure index                      */
x.34.message  = GetNLSMessage( x.gengradd )              /* user message                         */
x.34.name     = 'GENGRADD'                               /* product name                         */
x.34.statevar = 'CAS_GENGRADD'                           /* state variable name                  */
x.34.instprog = prodpath || '\snap\SETUP.CMD',           /* fully qualified install program name */
                ' GEN',                                  /*  - video driver flag                 */
                ' ' || prodpath || '\snap',              /*  - source path                       */
                ' ' || instdrive,                        /*  - target drive                      */
                ' /U',                                   /*  - unattended                        */
                ' 2>&1 >' || logprefix || 'GRADD.L2'     /*  - log file                          */
x.34.rspdir   = ''
x.34.default  = ''

x.sddgradd    = 35                                       /* structure index                      */
x.35.message  = GetNLSMessage( x.sddgradd )              /* user message                         */
x.35.name     = 'SNAP/SE'                                /* product name                         */
x.35.statevar = 'CAS_SDDGRADD'                           /* state variable name                  */
x.35.instprog = prodpath || '\snap\SETUP.CMD',           /* fully qualified install program name */
                ' SDD',                                  /*  - video driver flag                 */
                ' ' || prodpath || '\snap',              /*  - source path                       */
                ' ' || instdrive,                        /*  - boot drive                        */
                ' /U',                                   /*  - unattended                        */
                ' 2>&1 >' || logprefix || 'SNAP.L2'      /*  - log file                          */
x.35.rspdir   = ''
x.35.default  = ''

x.sddcfg      = 36                                       /* structure index                      */
x.36.message  = GetNLSMessage( x.sddcfg )                /* user message                         */
x.36.name     = 'SDDVCFG'                                /* product name                         */
x.36.statevar = 'CAS_SDDCFG'                             /* state variable name                  */
x.36.instprog = instdrive || '\snap\SDDVCFG.CMD',        /* fully qualified install program name */
                ' 2>&1 >' || logprefix || 'SDDCFG.L2'    /*  - log file                          */
x.36.rspdir   = ''
x.36.default  = ''

x.shuffle     = 37                                       /* structure index                      */
x.37.message  = GetNLSMessage( x.shuffle )               /* user message                         */
x.37.name     = 'CLNDESK'                                /* product name                         */
x.37.statevar = 'CAS_SHUFFLE'                            /* state variable name                  */
x.37.instprog = ecs_cmd || '\SHUFFLE.CMD',               /* fully qualified install program name */
                ' ' || cdlabel,                          /*  - volume label of source drive      */
                ' ' || langcode,                         /*  - language code of current version  */
                ' 2>&1 >' || logprefix || 'SHUFL.L2'     /*  - log file                          */
x.37.rspdir   = ''
x.37.default  = ''

x.videores    = 38                                       /* structure index                      */
x.38.message  = GetNLSMessage( x.videores )              /* user message                         */
x.38.name     = 'VCFGCID'                                /* product name                         */
x.38.statevar = 'CAS_VIDEORES'                           /* state variable name                  */
x.38.instprog = instdrive || '\os2\install\VCFGCID.CMD', /* fully qualified install program name */
                ' /L1:' || logprefix || 'VCFG.L1',       /*  - error log file                    */
                ' /L2:' || logprefix || 'VCFG.L2',       /*  - history log file                  */
                ' /RES:800x600x65536'                    /*  - resolution to switch to           */
x.38.rspdir   = ''
x.38.default  = ''

x.ecsmt       = 39                                       /* structure index                      */
x.39.message  = GetNLSMessage( x.ecsmt )                 /* user message                         */
x.39.name     = 'ECSMT'                                  /* product name                         */
x.39.statevar = 'CAS_ECSMT'                              /* state variable name                  */
x.39.instprog = ecs_cmd || '\ECSMT_UP.CMD',              /* fully qualified install program name */
                instdrive '2.0' logprefix'ECSMT.L1'      /*  - required parameters               */
x.39.rspdir   = ''
x.39.default  = ''

x.sguide      = 40                                       /* structure index                      */
x.40.message  = GetNLSMessage( x.sguide )                /* user message                         */
x.40.name     = 'SGUIDE'                                 /* product name                         */
x.40.statevar = 'CAS_SGUIDE'                             /* state variable name                  */
x.40.instprog = ecs_cmd || '\SGUIDE.CMD'                 /* fully qualified install program name */
x.40.rspdir   = ''
x.40.default  = ''

x.floppycmd   = 41                                       /* structure index                      */
x.41.message  = GetNLSMessage( x.floppycmd )             /* user message                         */
x.41.name     = 'FLOPPYCMD'                              /* product name                         */
x.41.statevar = 'CAS_FLOPPYCMD'                          /* state variable name                  */
x.41.instprog = ecs_cmd || '\FLOPPY.CMD',                /* fully qualified install program name */
                ' PHASE' || phase,                       /*  - current phase of installation     */
                ' ' || cdlabel,                          /*  - volume label of source drive      */
                ' ' || langcode,                         /*  - language code of current version  */
                ' ' || instdrive,                        /*  - installation drive                */
                ' ' || netdrive,                         /*  - network products drive            */
                ' ' || srcdrive                          /*  - source drive                      */
x.41.rspdir   = ''
x.41.default  = ''

x.mmpm        = 42
x.42.message  = GetNLSMessage( x.mmpm )
x.42.name     = 'MMPM/2'
x.42.statevar = 'CAS_MMEDIA'
x.42.instprog = ecs_cmd || '\MMECS.CMD'                   /* fully qualified install program name */
x.42.rspdir   = ''
x.42.default  = ''

x.ft2lib      = 43                                       /* structure index                      */
x.43.message  = GetNLSMessage( x.ft2lib )                /* user message                         */
x.43.name     = 'FT2LIB'                                 /* product name                         */
x.43.statevar = 'CAS_FT2LIB'                             /* state variable name                  */
x.43.instprog = ecs_cmd || '\FT2LIB.CMD'                 /* fully qualified install program name */
x.43.rspdir   = ''
x.43.default  = ''

x.acro405     = 44                                       /* structure index                      */
x.44.message  = GetNLSMessage( x.acro405 )               /* user message                         */
x.44.name     = 'ACROREAD4'                              /* product name                         */
x.44.statevar = 'CAS_ACROREAD4'                          /* state variable name                  */
x.44.instprog = ecs_cmd || '\ACRO405.CMD'                /* fully qualified install program name */
x.44.rspdir   = ''
x.44.default  = ''

x.cdwecs      = 45                                       /* structure index                      */
x.45.message  = GetNLSMessage( x.cdwecs )                /* user message                         */
x.45.name     = 'CDWECS'                                 /* product name                         */
x.45.statevar = 'CAS_CDWECS'                             /* state variable name                  */
x.45.instprog = ecs_cmd || '\CDWECS.CMD'                 /* fully qualified install program name */
x.45.rspdir   = ''
x.45.default  = ''

x.innort      = 46                                       /* structure index                      */
x.46.message  = GetNLSMessage( x.innort )                /* user message                         */
x.46.name     = 'INNORT'                                 /* product name                         */
x.46.statevar = 'CAS_INNORT'                             /* state variable name                  */
x.46.instprog = ecs_cmd || '\INNORT.CMD'                 /* fully qualified install program name */
x.46.rspdir   = ''
x.46.default  = ''

x.dlgmmpm     = 47                                       /* structure index                      */
x.47.message  = GetNLSMessage( x.dlgmmpm )               /* user message                         */
x.47.name     = 'DIALOG MMPM'                            /* product name                         */
x.47.statevar = 'CAS_DLGMMPM'                            /* state variable name                  */
x.47.instprog = ecs_cmd || '\DLGINST.CMD',               /* fully qualified install program name */
                ' MMPM',                                 /*  - product flag (multimedia)         */
                ' ' || instdrive,                        /*  - installation drive                */
                ' 1>>'logpath'\DIALOG.L1',               /*  - overview log file                 */
                ' 2>>'logpath'\DIALOG.L2'                /*  - detailed log file                 */
x.47.rspdir   = ''
x.47.default  = ''

x.efds        = 48                                       /* structure index                      */
x.48.message  = GetNLSMessage( x.efds )                  /* user message                         */
x.48.name     = 'EFDS'                                   /* product name                         */
x.48.statevar = 'CAS_EFDS'                               /* state variable name                  */
x.48.instprog = ecs_cmd || '\EFDS.CMD'                   /* fully qualified install program name */
x.48.rspdir   = ''
x.48.default  = ''

x.ecsconet    = 49                                       /* structure index                      */
x.49.message  = GetNLSMessage( x.ecsconet )              /* user message                         */
x.49.name     = 'ECSCONET'                               /* product name                         */
x.49.statevar = 'CAS_ECSCONET'                           /* state variable name                  */
x.49.instprog = ecs_cmd || '\ECSCONET.CMD'               /* fully qualified install program name */
x.49.rspdir   = ''
x.49.default  = ''

x.dssaver     = 50                                       /* structure index                      */
x.50.message  = GetNLSMessage( x.dssaver )               /* user message                         */
x.50.name     = 'DSSAVER'                                /* product name                         */
x.50.statevar = 'CAS_DSSAVER'                            /* state variable name                  */
x.50.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\DSSAVER.XCD',     /*  - response file                     */
                ' >' || logprefix || 'DSSVR.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'DSSVR.L2'
x.50.rspdir   = ''
x.50.default  = ''

x.pmvnc       = 51                                       /* structure index                      */
x.51.message  = GetNLSMessage( x.pmvnc )                 /* user message                         */
x.51.name     = 'PMVNC'                                  /* product name                         */
x.51.statevar = 'CAS_PMVNC'                              /* state variable name                  */
x.51.instprog = ecs_cmd || '\PMVNC.CMD'                  /* fully qualified install program name */
x.51.rspdir   = ''
x.51.default  = ''

x.prndrv      = 52                                       /* structure index                      */
x.52.message  = GetNLSMessage( x.prndrv )                /* user message                         */
x.52.name     = 'PRNDRV'                                 /* product name                         */
x.52.statevar = 'CAS_PRNDRV'                             /* state variable name                  */
x.52.instprog = ecs_cmd || '\PRNDRV.CMD'                 /* fully qualified install program name */
x.52.rspdir   = ''
x.52.default  = ''

x.maintdsk    = 53                                       /* structure index                      */
x.53.message  = GetNLSMessage( x.maintdsk )              /* user message                         */
x.53.name     = 'MAINTDSK'                               /* product name                         */
x.53.statevar = 'CAS_MAINTDSK'                           /* state variable name                  */
x.53.instprog = ecs_cmd || '\MAINTDSK.CMD'               /* fully qualified install program name */
x.53.rspdir   = ''
x.53.default  = ''

x.eclock      = 54                                       /* structure index                      */
x.54.message  = GetNLSMessage( x.ecsprod )               /* user message                         */
x.54.name     = 'ECLOCK'                                 /* product name                         */
x.54.statevar = 'CAS_ECLOCK'                             /* state variable name                  */
x.54.instprog = ecs_cmd || '\ECLOCK.CMD',                /* fully qualified install program name */
               ' ' || logprefix || 'ECLOCK.L1',          /*  - message log file                  */
               ' ' || logprefix || 'ECLOCK.L2'           /*  - output log file                   */
x.54.rspdir   = ''
x.54.default  = ''

x.screenrs    = 55                                       /* structure index                      */
x.55.message  = GetNLSMessage( x.screenrs )              /* user message                         */
x.55.name     = 'SCREENRS'                               /* product name                         */
x.55.statevar = 'CAS_SCREENRS'                           /* state variable name                  */
x.55.instprog = srcdrive || '\ECS\BOOT\SNAP\SCREENRS.EXE',   /* fully qualified install program name */
               instdrive||'\os2\os2.ini 800 600 16',          /*  - message log file                  */
               ' >' || logprefix || 'SCRNRS.L2'           /*  - output log file                   */
x.55.rspdir   = ''
x.55.default  = ''

x.diaginfo    = 56                                       /* structure index                      */
x.56.message  = GetNLSMessage( x.diaginfo )              /* user message                         */
x.56.name     = 'DIAGINFO'                               /* product name                         */
x.56.statevar = 'CAS_DIAGINFO'                           /* state variable name                  */
x.56.instprog = srcdrive || '\ECS\INSTALL\DIAGINFO.CMD', /* fully qualified install program name */
               logpath,                                  /*  - message log file                  */
               ' >' || logprefix || 'DIAG.L2'            /*  - output log file                   */
x.56.rspdir   = ''
x.56.default  = ''

x.lucide      = 57                                       /* structure index                      */
x.57.message  = GetNLSMessage( x.lucide )                /* user message                         */
x.57.name     = 'LUCIDE'                                 /* product name                         */
x.57.statevar = 'CAS_LUCIDE'                             /* state variable name                  */
x.57.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i -R ' || rsppath || '\LUCIDE.XCD',    /*  - response file                     */
                ' >' || logprefix || 'LUCIDE.L1',        /*  - output log file                   */
                ' 2>' || logprefix || 'LUCIDE.L2'
x.57.rspdir   = ''
x.57.default  = ''

x.tame        = 58                                       /* structure index                      */
x.58.message  = GetNLSMessage( x.tame )                  /* user message                         */
x.58.name     = 'TAME'                                   /* product name                         */
x.58.statevar = 'CAS_TAME'                               /* state variable name                  */
x.58.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\TAME.XCD',        /*  - response file                     */
                ' >' || logprefix || 'TAME.L1',          /*  - output log file                   */
                ' 2>' || logprefix || 'TAME.L2'
x.58.rspdir   = ''
x.58.default  = ''

x.eschemes    = 59                                       /* structure index                      */
x.59.message  = GetNLSMessage( x.eschemes )              /* user message                         */
x.59.name     = 'ESCHEMES'                               /* product name                         */
x.59.statevar = 'CAS_ESCHEMES'                           /* state variable name                  */
x.59.instprog = ecs_cmd || '\ESCHEMES.CMD'               /* fully qualified install program name */
x.59.rspdir   = ''
x.59.default  = ''

x.forostwo    = 60                                       /* structure index                      */
x.60.message  = GetNLSMessage( x.forostwo )              /* user message                         */
x.60.name     = '4OS2'                                   /* product name                         */
x.60.statevar = 'CAS_4OS2'                               /* state variable name                  */
x.60.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\4OS2.XCD',        /*  - response file                     */
                ' >' || logprefix || '4OS2.L1',          /*  - output log file                   */
                ' 2>' || logprefix || '4OS2.L2'
x.60.rspdir   = ''
x.60.default  = ''

x.firefox     = 61
x.61.message  = GetNLSMessage( x.firefox )
x.61.name     = 'FIREFOX'
x.61.statevar = 'CAS_FIREFOX'
x.61.instprog = ecs_cmd || '\FIREFOX.CMD ',
                ' /R:'  || rsppath || '\BROWSER.RSP',
                ' /L2:' || logprefix || 'FFOX.L2'
x.61.rspdir   = ''
x.61.default  = ''

x.thunderb    = 62
x.62.message  = GetNLSMessage( x.thunderb )
x.62.name     = 'THUNDERB'
x.62.statevar = 'CAS_THUNDERB'
x.62.instprog = ecs_cmd || '\THUNDERB.CMD ',
                ' /R:'  || rsppath || '\BROWSER.RSP',
                ' /L2:' || logprefix || 'TBIRD.L2'
x.62.rspdir   = ''
x.62.default  = ''

x.fat32       = 63
x.63.message  = GetNLSMessage( x.fat32 )
x.63.name     = 'FAT32'
x.63.statevar = 'CAS_FAT32'
x.63.instprog = warpin_dir || '\WIC.EXE',
                ' -i ' || rsppath || '\FAT32IFS.XCD',
                ' -R >' || logprefix || 'FAT32.L1',
                ' 2>' || logprefix || 'FAT32.L2'
x.63.rspdir   = ''
x.63.default  = ''

x.security    = 64
x.64.message  = GetNLSMessage( x.security )
x.64.name     = 'SECURITY'
x.64.statevar = 'CAS_SECURITY'
x.64.instprog = ecs_cmd || '\SECURITY.CMD'
x.64.rspdir   = ''
x.64.default  = ''

x.psios2      = 65                                       /* structure index                      */
x.65.message  = GetNLSMessage( x.psios2 )                /* user message                         */
x.65.name     = 'PSIOS2'                                 /* product name                         */
x.65.statevar = 'CAS_PSIOS2'                             /* state variable name                  */
x.65.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i -R ' || rsppath || '\PSIOS2.XCD',   /*  - response file                     */
                ' >' || logprefix || 'PSIOS2.L1',        /*  - output log file                   */
                ' 2>' || logprefix || 'PSIOS2.L2'
x.65.rspdir   = ''
x.65.default  = ''

x.esambac     = 66                                       /* structure index                      */
x.66.message  = GetNLSMessage( x.esambac )               /* user message                         */
x.66.name     = 'ESAMBAC'                                /* product name                         */
x.66.statevar = 'CAS_ESAMBAC'                            /* state variable name                  */
x.66.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\ESAMBAC.XCD',     /*  - response file                     */
                ' >' || logprefix || 'ESAMBAC.L1',       /*  - output log file                   */
                ' 2>' || logprefix || 'ESAMBAC.L2'
x.66.rspdir   = ''
x.66.default  = ''


x.faxworks    = 67                                            /* structure index                 */
x.67.message  = GetNLSMessage( x.faxworks )                   /* user message                    */
x.67.name     = 'FAXWORKS'                                    /* product name                    */
x.67.statevar = 'CAS_FAXWORKS'                                /* state variable name             */
x.67.instprog = warpin_dir || '\WIC.EXE',
                ' -i ' || rsppath || '\FAXWORKS.XCD',
                ' -R >' || logprefix || 'FAXW.L1',
                ' 2>' || logprefix || 'FAXW.L2'
x.67.rspdir   = ''
x.67.default  = ''


x.genmac      = 68                                       /* structure index                      */
x.68.message  = GetNLSMessage( x.genmac )                /* user message                         */
x.68.name     = 'GENMAC'                                 /* product name                         */
x.68.statevar = 'CAS_GENMAC'                             /* state variable name                  */
x.68.instprog = ecs_cmd || '\GENMAC.CMD',                /* fully qualified install program name */
               ' ' || logprefix || 'GENMAC.L1',          /*  - message log file                  */
               ' ' || logprefix || 'GENMAC.L2'           /*  - output log file                   */
x.68.rspdir   = ''
x.68.default  = ''

x.xwlan       = 69                                       /* structure index                      */
x.69.message  = GetNLSMessage( x.xwlan )                 /* user message                         */
x.69.name     = 'XWLAN'                                  /* product name                         */
x.69.statevar = 'CAS_XWLAN'                              /* state variable name                  */
x.69.instprog = ecs_cmd || '\XWLAN.CMD',                 /* fully qualified install program name */
               ' ' || logprefix || 'XWLAN.L1',           /*  - message log file                  */
               ' ' || logprefix || 'XWLAN.L2'            /*  - output log file                   */
x.69.rspdir   = ''
x.69.default  = ''

x.openssh     = 70                                       /* structure index                      */
x.70.message  = GetNLSMessage( x.openssh )               /* user message                         */
x.70.name     = 'OPENSSH'                                /* product name                         */
x.70.statevar = 'CAS_OPENSSH'                            /* state variable name                  */
x.70.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\OPENSSH.XCD',     /*  - response file                     */
                ' >' || logprefix || 'OPNSSH.L1',        /*  - output log file                   */
                ' 2>' || logprefix || 'OPNSSH.L2'
x.70.rspdir   = ''
x.70.default  = ''

x.dejavu      = 71                                       /* structure index                      */
x.71.message  = GetNLSMessage( x.dejavu )                /* user message                         */
x.71.name     = 'DEJAVU'                                 /* product name                         */
x.71.statevar = 'CAS_DEJAVU'                             /* state variable name                  */
x.71.instprog = ecs_cmd || '\DEJAVU.CMD',                /* fully qualified install program name */
               ' ' || logprefix || 'DEJAVU.L1',          /*  - message log file                  */
               ' ' || logprefix || 'DEJAVU.L2'           /*  - output log file                   */
x.71.rspdir   = ''
x.71.default  = ''

x.usbdock     = 72                                       /* structure index                      */
x.72.message  = GetNLSMessage( x.usbdock )               /* user message                         */
x.72.name     = 'USBDOCK'                                /* product name                         */
x.72.statevar = 'CAS_USBDOCK'                            /* state variable name                  */
x.72.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\USBDOCK.XCD',     /*  - response file                     */
                ' >' || logprefix || 'USBDCK.L1',        /*  - output log file                   */
                ' 2>' || logprefix || 'USBDCK.L2'
x.72.rspdir   = ''
x.72.default  = ''

x.klibc       = 73                                       /* structure index                      */
x.73.message  = GetNLSMessage( x.klibc )                 /* user message                         */
x.73.name     = 'KLIBC'                                  /* product name                         */
x.73.statevar = 'CAS_KLIBC'                              /* state variable name                  */
x.73.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i -R ' || rsppath || '\KLIBC.XCD',    /*  - response file                     */
                ' >' || logprefix || 'KLIBC.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'KLIBC.L2'
x.73.rspdir   = ''
x.73.default  = ''

x.emxrt       = 74                                       /* structure index                      */
x.74.message  = GetNLSMessage( x.emxrt )                 /* user message                         */
x.74.name     = 'EMXRT'                                  /* product name                         */
x.74.statevar = 'CAS_EMXRT'                              /* state variable name                  */
x.74.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i ' || rsppath || '\EMXRT.XCD',       /*  - response file                     */
                ' >' || logprefix || 'EMXRT.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'EMXRT.L2'
x.74.rspdir   = ''
x.74.default  = ''

x.coreutils   = 75                                        /* structure index                      */
x.75.message  = GetNLSMessage( x.coreutils )              /* user message                         */
x.75.name     = 'COREUTILS'                               /* product name                         */
x.75.statevar = 'CAS_COREUTILS'                           /* state variable name                  */
x.75.instprog = warpin_dir || '\WIC.EXE',                 /* fully qualified install program name */
                ' -i ' || rsppath || '\COREUTIL.XCD',     /*  - response file                     */
                ' >' || logprefix || 'COREUT.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'COREUT.L2'
x.75.rspdir   = ''
x.75.default  = ''

x.klibccfg   = 76                                         /* structure index                      */
x.76.message  = GetNLSMessage( x.klibccfg )               /* user message                         */
x.76.name     = 'KLIBCCFG'                                /* product name                         */
x.76.statevar = 'CAS_KLIBCCFG'                            /* state variable name                  */
x.76.instprog = warpin_dir || '\WIC.EXE',                 /* fully qualified install program name */
                ' -i ' || rsppath || '\KLIBCCFG.XCD',     /*  - response file                     */
                ' >' || logprefix || 'KLIBC.L1',          /*  - output log file                   */
                ' 2>' || logprefix || 'KLIBC.L2'
x.76.rspdir   = ''
x.76.default  = ''

x.uclip       = 77                                        /* structure index                      */
x.77.message  = GetNLSMessage( x.uclip )                  /* user message                         */
x.77.name     = 'UCLIP'                                   /* product name                         */
x.77.statevar = 'CAS_UCLIP'                               /* state variable name                  */
x.77.instprog = warpin_dir || '\WIC.EXE',                 /* fully qualified install program name */
                ' -i ' || rsppath || '\UCLIP.XCD',        /*  - response file                     */
                ' >' || logprefix || 'UCLIP.L1',          /*  - output log file                   */
                ' 2>' || logprefix || 'UCLIP.L2'
x.77.rspdir   = ''
x.77.default  = ''

x.innolibc    = 78                                        /* structure index                      */
x.78.message  = GetNLSMessage( x.klibc )                  /* user message                         */
x.78.name     = 'INNOLIBC'                                /* product name                         */
x.78.statevar = 'CAS_INNOLIBC'                            /* state variable name                  */
x.78.instprog = warpin_dir || '\WIC.EXE',                 /* fully qualified install program name */
                ' -i ' || rsppath || '\INNOLIBC.XCD',     /*  - response file                     */
                ' >' || logprefix || 'INLIBC.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'INLIBC.L2'
x.78.rspdir   = ''
x.78.default  = ''

x.ecif        = 79                                       /* structure index                      */
x.79.message  = GetNLSMessage( x.ecif )                  /* user message                         */
x.79.name     = 'ECIF'                                   /* product name                         */
x.79.statevar = 'CAS_ECIF'                               /* state variable name                  */
x.79.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i -R ' || rsppath || '\ECIF.XCD',     /*  - response file                     */
                ' >' || logprefix || 'ECIF.L1',          /*  - output log file                   */
                ' 2>' || logprefix || 'ECIF.L2'
x.79.rspdir   = ''
x.79.default  = ''

x.acpiwzrd    = 80                                       /* structure index                      */
x.80.message  = GetNLSMessage( x.acpiwzrd )              /* user message                         */
x.80.name     = 'ACPIWZRD'                               /* product name                         */
x.80.statevar = 'CAS_ACPIWZRD'                           /* state variable name                  */
x.80.instprog = ecs_cmd || '\ACPIWZRD.EXE',              /* fully qualified install program name */
                ' /RSP ',                                /*  - write responsefile                */
                ' /L1:' || logprefix || 'ACPI.L1',       /*  - output log file                   */
                ' /L2:' || logprefix || 'ACPI.L2'        /*  - output log file                   */
x.80.rspdir   = ''
x.80.default  = ''

x.nwinst      = 81
x.81.message  = GetNLSMessage( x.nwinst )                /* user message                         */
x.81.name     = 'NetWare Requester'
x.81.statevar = 'CAS_NETWARE'
x.81.instprog = prodpath || '\mpts\npnwinst.exe ',
                ' /L1:'|| logprefix || 'NWREQ.L1',
                ' /L2:'|| logprefix || 'NWREQ.L2',
                ' /NC:'|| nwcontext,
                ' /P:' || nwprefsrv,
                ' /T:' || left(netdrive,1),
                ' /V:4',      /* netware version */
                ' /TR:FALSE', /* tokenring */
                ' /S:' || left(prodpath,1)
x.81.rspdir   = ''
x.81.default  = ''

x.nwaddress   = 82
x.82.message  = GetNLSMessage( x.nwaddress )              /* user message                         */
x.82.name     = 'Add ODI2NDI Address'
x.82.statevar = 'CAS_ODI2NDI'
x.82.instprog = ecs_cmd   || '\MACADDR.CMD ',
                logprefix || 'ODINDI.ERR ',
                rsppath   || '\NWMPTS.RSP'
x.82.rspdir   = ''
x.82.default  = ''

x.nwmpts      = 83
x.83.message  = GetNLSMessage( x.nwmpts )                /* user message                         */
x.83.name     = 'MPTS for NetWare'
x.83.statevar = 'CAS_MPTS_NETWARE'
x.83.instprog = prodpath || '\mpts\MPTS.EXE',            /* fully qualified install program      */
                ' /E:PROD',
                ' /S:'  || prodpath  || '\mpts ',
                ' /T:'  || netdrive  || '\',
                ' /TU:' || instdrive || '\',
                ' /L1:' || logprefix || 'NWMPTS.L1',
                ' /R:'  || rsppath   || '\NWMPTS.RSP'
x.83.rspdir   = ''
x.83.default  = ''

x.mptswrap    = 84                                       /* structure index                      */
x.84.message  = GetNLSMessage( x.mptswrap )              /* user message                         */
x.84.name     = 'MPTSWRAP'                               /* product name                         */
x.84.statevar = 'CAS_MPTSWRAP'                           /* state variable name                  */
x.84.instprog = warpin_dir || '\WIC.EXE',                /* fully qualified install program name */
                ' -i -R ' || rsppath || '\MPTSWRAP.XCD', /*  - response file                     */
                ' >' || logprefix || 'MPTSW.L1',          /*  - output log file                   */
                ' 2>' || logprefix || 'MPTSW.L2'
x.84.rspdir   = ''
x.84.default  = ''

x.mptsclean   = 85
x.85.message  = GetNLSMessage( x.mptsclean )             /* user message                         */
x.85.name     = 'MPTS Cleanup'
x.85.statevar = 'CAS_MPTS_CLEANUP'
x.85.instprog = prodpath || '\mpts\MPTS.EXE',            /* fully qualified install program      */
                ' /E:PROD',
                ' /S:'  || prodpath  || '\mpts ',
                ' /T:'  || netdrive  || '\',
                ' /TU:' || instdrive || '\',
                ' /L1:' || logprefix || 'MPTSC.L1',
                ' /R:'  || rsppath   || '\MPTSCLN.RSP'
x.85.rspdir   = ''
x.85.default  = ''

x.amouse      = 86                                        /* structure index                      */
x.86.message  = GetNLSMessage( x.amouse )                 /* user message                         */
x.86.name     = 'AMOUSE'                                  /* product name                         */
x.86.statevar = 'CAS_AMOUSE'                              /* state variable name                  */
x.86.instprog = warpin_dir || '\WIC.EXE',                 /* fully qualified install program name */
                ' -i -R ' || rsppath || '\AMOUSE.XCD',    /*  - response file                     */
                ' >' || logprefix || 'AMOUSE.L1',         /*  - output log file                   */
                ' 2>' || logprefix || 'AMOUSE.L2'
x.86.rspdir   = ''
x.86.default  = ''

x.ecoruntime  = 87                                        /* structure index                      */
x.87.message  = GetNLSMessage( x.ecoruntime )             /* user message                         */
x.87.name     = 'ECORUNTIME'                              /* product name                         */
x.87.statevar = 'CAS_ECORUNTIME'                          /* state variable name                  */
x.87.instprog = warpin_dir || '\WIC.EXE',                 /* fully qualified install program name */
                ' -i ' || rsppath || '\ECORT.XCD',        /*  - response file                     */
                ' >' || logprefix || 'ECORT.L1',          /*  - output log file                   */
                ' 2>' || logprefix || 'ECORT.L2'
x.87.rspdir   = ''
x.87.default  = ''

x.panorama    = 88                                       /* structure index                      */
x.88.message  = GetNLSMessage( x.panorama )              /* user message                         */
x.88.name     = 'PANORAMA'                               /* product name                         */
x.88.statevar = 'CAS_PANORAMA'                           /* state variable name                  */
x.88.instprog = prodpath || '\panorama\SETUP.CMD',       /* fully qualified install program name */
                ' GEN',                                  /*  - video driver flag                 */
                ' ' || prodpath || '\panorama',          /*  - source path                       */
                ' ' || instdrive,                        /*  - target drive                      */
                ' /U',                                   /*  - unattended                        */
                ' 2>&1 >' || logprefix || 'GRADD.L2'     /*  - log file                          */
x.88.rspdir   = ''
x.88.default  = ''


/*---------------------------------------------------*/
/*         NUMBER OF PROGRAMS SET UP IN THE          */
/*               PRODUCT DATA SECTION                */
/*---------------------------------------------------*/

NUM_INSTALL_PROGS = 88


/*---------------------------------------------------*/
/*       DO NOT MODIFY OR REMOVE THE NEXT LINE       */
/*---------------------------------------------------*/

OVERALL_STATE = GetEnvironmentVars()


/*****************************************************/
/*                  INSTALL SECTION                  */
/*****************************************************/

SELECT

    /* PHASE 1: OVERALL_STATE = 0 */
    WHEN OVERALL_STATE = 0 THEN DO


        IF POS('DIAGINFO', products_to_install ) > 0 THEN
            IF RunInstall( x.diaginfo ) == BAD_RC THEN          /* Install base system          */
                AbortInstall( x.diaginfo )

        IF POS('BASEINST', products_to_install ) > 0 THEN
            IF RunInstall( x.seinst ) == BAD_RC THEN            /* Install base system          */
                AbortInstall( x.seinst )

        IF POS('MPTS', products_to_install ) > 0 THEN
            IF RunInstall( x.mpts ) == BAD_RC THEN              /* Install networking           */
                AbortInstall( x.mpts )

        IF POS('ACPIWZRD', products_to_install ) > 0 THEN
            IF RunInstall( x.acpiwzrd ) == BAD_RC THEN          /* Create ACPI RSP config file  */
                AbortInstall( x.acpiwzrd )

        IF POS('HWMERGE', products_to_install ) > 0 THEN
            IF RunInstall( x.hwmerge ) == BAD_RC THEN           /* Install additional drivers   */
                AbortInstall( x.hwmerge )

        IF POS('CONFSED', products_to_install ) > 0 THEN
            IF RunInstall( x.confsed ) == BAD_RC THEN           /* Update CONFIG.SYS            */
                AbortInstall( x.confsed )

        IF POS('PRNDRV', products_to_install ) > 0 THEN
            IF RunInstall( x.prndrv ) == BAD_RC THEN            /* Extract printerdrivers to HD */
                AbortInstall( x.prndrv )

        IF POS('ECSPROD', products_to_install ) > 0 THEN
            IF RunInstall( x.ecsprod ) == BAD_RC THEN           /* Install utilities            */
                AbortInstall( x.ecsprod )

        IF POS('ECLOCK', products_to_install ) > 0 THEN
            IF RunInstall( x.eclock ) == BAD_RC THEN            /* Install eClock               */
                AbortInstall( x.eclock )

        IF POS('SMOUSE', products_to_install ) > 0 THEN
            IF RunInstall( x.smouse ) == BAD_RC THEN            /* Install single mouse driver  */
                AbortInstall( x.smouse )

        IF POS('DLGBASE', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgbase ) == BAD_RC THEN           /* Update OS resources          */
                AbortInstall( x.dlgbase )

        IF POS('DLGPRINT', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgprint ) == BAD_RC THEN          /* Update OS resources          */
                AbortInstall( x.dlgprint )

        IF POS('DLGMPTS', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgmpts ) == BAD_RC THEN           /* Update MPTS resources        */
                AbortInstall( x.dlgmpts )

        IF POS('SRVIFS', products_to_install ) > 0 THEN
            IF RunInstall( x.thinifs ) == BAD_RC THEN           /* Install the CID requester    */
                AbortInstall( x.thinifs )

        IF POS('BLDDESK', products_to_install ) > 0 THEN
            IF RunInstall( x.blddesk ) == BAD_RC THEN           /* Create the desktop           */
                AbortInstall( x.blddesk )

        IF POS('MAINTDSK', products_to_install ) > 0 THEN
            IF RunInstall( x.maintdsk ) == BAD_RC THEN           /* Create the Maintenance desktop */
                AbortInstall( x.maintdsk )

        IF POS('PREVIOUS', products_to_install ) > 0 THEN
            IF RunInstall( x.previous ) == BAD_RC THEN          /* Run final tasks for Phase 1  */
                AbortInstall( x.previous )

        IF POS('SDD', products_to_install ) > 0 THEN DO
            IF RunInstall( x.sddgradd ) == BAD_RC THEN          /* Install SDD video            */
                AbortInstall( x.sddgradd )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('GENGRADD', products_to_install ) > 0 THEN DO
            IF RunInstall( x.gengradd ) == BAD_RC THEN          /* Install GENGRADD video       */
                AbortInstall( x.gengradd )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('PANORAMA', products_to_install ) > 0 THEN DO
            IF RunInstall( x.panorama ) == BAD_RC THEN          /* Install PANORAMA video       */
                AbortInstall( x.panorama )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('VCFGCID', products_to_install ) > 0 THEN
            IF RunInstall( x.videores ) == BAD_RC THEN          /* Set video display resolution */
                AbortInstall( x.videores )

        IF POS('FINISH', products_to_install ) > 0 THEN
            IF RunInstall( x.finish ) == BAD_RC THEN            /* Run final tasks for Phase 1  */
                AbortInstall( x.finish )

        IF POS('FLOPPYCMD', products_to_install ) > 0 THEN
            IF RunInstall( x.floppycmd ) == BAD_RC THEN         /* Update STARTUP.CMD           */
                AbortInstall( x.floppycmd )

        SAY GetNLSMessage( 100 )
        retcode = SetState( OVERALL_STATE + 1 )
        CALL SaveStates
    END


    /* PHASE 2: OVERALL_STATE = 1 */
    WHEN OVERALL_STATE = 1 THEN DO

        IF POS('INITPH', products_to_install ) > 0 THEN
            IF RunInstall( x.initphase ) == BAD_RC THEN          /* Save CONFIG.SYS from Phase 1 */
                AbortInstall( x.initphase )

        IF POS('MPTS', products_to_install ) > 0 THEN
            IF RunInstall( x.mptsclean ) == BAD_RC THEN              /* Run MPTS to cleanup       */
                AbortInstall( x.mptsclean )

        IF POS('WARPIN', products_to_install ) > 0 THEN
            IF RunInstall( x.warpin ) == BAD_RC THEN             /* Verify Java selections       */
                AbortInstall( x.warpin )

        IF POS('KLIBC', products_to_install ) > 0 THEN
            IF RunInstall( x.klibc ) == BAD_RC THEN          /* Install Libc ( innotek & klibc ) */
                AbortInstall( x.klibc )

        IF POS('INNOLIBC', products_to_install ) > 0 THEN
            IF RunInstall( x.innolibc ) == BAD_RC THEN        /* Install Libc ( innotek & klibc ) */
                AbortInstall( x.innolibc )

        IF POS('ECIF', products_to_install ) > 0 THEN
            IF RunInstall( x.ecif ) == BAD_RC THEN            /* Install Libc ( innotek & klibc ) */
                AbortInstall( x.ecif )

        IF POS('EMXRT', products_to_install ) > 0 THEN
            IF RunInstall( x.emxrt ) == BAD_RC THEN             /* Install libc ( emx )            */
                AbortInstall( x.emxrt )

        IF POS('COREUTILS', products_to_install ) > 0 THEN
            IF RunInstall( x.coreutils ) == BAD_RC THEN            /* Install coreutils            */
                AbortInstall( x.coreutils )

        IF POS('KLIBCCFG', products_to_install ) > 0 THEN
            IF RunInstall( x.klibccfg ) == BAD_RC THEN         /* Install Libc ( innotek & klibc ) */
                AbortInstall( x.klibccfg )

        IF POS('UCLIP', products_to_install ) > 0 THEN
            IF RunInstall( x.uclip ) == BAD_RC THEN                /* Install UniClipboard         */
                AbortInstall( x.uclip )

        IF POS('ECORT', products_to_install ) > 0 THEN
            IF RunInstall( x.ecoruntime ) == BAD_RC THEN            /* Install eCosoft Runtime     */
                AbortInstall( x.ecoruntime )

        IF POS('AMOUSE', products_to_install ) > 0 THEN
            IF RunInstall( x.amouse ) == BAD_RC THEN             /* Install AMouse driver          */
                AbortInstall( x.amouse )

        IF POS('CHK4JAVA', products_to_install ) > 0 THEN
            IF RunInstall( x.chkjava ) == BAD_RC THEN              /* Verify Java selections       */
                AbortInstall( x.chkjava )

        IF POS('MPTS', products_to_install ) > 0 THEN
            IF RunInstall( x.mptswrap ) == BAD_RC THEN              /* Install MPTS wrapper        */
                AbortInstall( x.mptswrap )

        IF POS('NETSCAPE', products_to_install ) > 0 THEN DO
            IF RunInstall( x.netscape ) == BAD_RC THEN          /* Install Netscape 4.61        */
                AbortInstall( x.netscape )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('FIINST', products_to_install ) > 0 THEN DO
            IF RunInstall( x.fibase ) == BAD_RC THEN            /* Install base features        */
                AbortInstall( x.fibase )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('WSFI', products_to_install ) > 0 THEN
            IF RunInstall( x.npfi ) == BAD_RC THEN              /* Install FI browser plugin    */
                AbortInstall( x.npfi )

        IF POS('PEER', products_to_install ) > 0 THEN DO
            IF RunInstall( x.peer ) == BAD_RC THEN              /* Install Netscape 4.61        */
                AbortInstall( x.peer )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('DLGPEER', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgpeer ) == BAD_RC THEN           /* Update Peer resources        */
                AbortInstall( x.dlgpeer )

        IF POS('DLGPEERLK', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgpeerlk ) == BAD_RC THEN         /* Update locked Peer resources */
                AbortInstall( x.dlgpeerlk )

        IF POS('DLGUPM', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgupm ) == BAD_RC THEN            /* Update UPM resources         */
                AbortInstall( x.dlgupm )

        IF POS('DLGUPMLK', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgupmlk ) == BAD_RC THEN          /* Update locked UPM resources  */
                AbortInstall( x.dlgupmlk )

        IF POS('BOOKS', products_to_install ) > 0 THEN
            IF RunInstall( x.books ) == BAD_RC THEN             /* Install networking books     */
                AbortInstall( x.books )

      if pos('NETWARE', products_to_install) > 0 then do           /* Install netware stuff     */
         if RunInstall(x.nwinst) = BAD_RC then
           AbortInstall(x.nwinst)
         if RunInstall(x.nwaddress) = BAD_RC then
           AbortInstall(x.nwinst)
         if RunInstall(x.nwmpts) = BAD_RC then
           AbortInstall(x.nwinst)
      end


        IF POS('DEJAVU', products_to_install ) > 0 THEN
            IF RunInstall( x.dejavu ) == BAD_RC THEN             /* Install DejaVu font     */
                AbortInstall( x.dejavu )

        IF POS('BROWSER', products_to_install ) > 0 THEN
            IF RunInstall( x.browser ) == BAD_RC THEN           /* Install IBM Web Browser      */
                AbortInstall( x.browser )

        IF POS('FIREFOX', products_to_install ) > 0 THEN
            IF RunInstall( x.firefox ) == BAD_RC THEN
                AbortInstall( x.firefox )

        IF POS('THUNDERB', products_to_install ) > 0 THEN
            IF RunInstall( x.thunderb ) == BAD_RC THEN
                AbortInstall( x.thunderb )

        IF POS('INNORT', products_to_install ) > 0 THEN
            IF RunInstall( x.innort ) == BAD_RC THEN            /* Install Innotek Runtime      */
                AbortInstall( x.innort )

        IF POS('JAVA142', products_to_install ) > 0 THEN
            IF RunInstall( x.java142 ) == BAD_RC THEN           /* Install Java 1.4.2           */
                AbortInstall( x.java142 )

        IF POS('TCPIP', products_to_install ) > 0 THEN DO
            IF RunInstall( x.tcpapps ) == BAD_RC THEN           /* Install TCP/IP applications  */
                AbortInstall( x.tcpapps )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('DLGTCPIP', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgtcpip ) == BAD_RC THEN          /* Update TCP/IP resources      */
                AbortInstall( x.dlgtcpip )

        IF POS('LCFAGENT', products_to_install ) > 0 THEN DO
            IF RunInstall( x.lcfagent ) == BAD_RC THEN          /* Install Tivoli Endpoint      */
                AbortInstall( x.lcfagent )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('FFST', products_to_install ) > 0 THEN DO
            IF RunInstall( x.ffst ) == BAD_RC THEN              /* Install FFST/2               */
                AbortInstall( x.ffst )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('ECSCONET', products_to_install ) > 0 THEN
            IF RunInstall( x.ecsconet ) == BAD_RC THEN          /* Install eCSCoNet and IAeCS   */
                AbortInstall( x.ecsconet )

        IF POS('ESTYLER', products_to_install ) > 0 THEN
            IF RunInstall( x.estyler ) == BAD_RC THEN           /* Install UI enhancements      */
                AbortInstall( x.estyler )

        IF POS('FT2LIB', products_to_install ) > 0 THEN
            IF RunInstall( x.ft2lib ) == BAD_RC THEN            /* Install Innotek FontEngine   */
                AbortInstall( x.ft2lib )

        IF POS('ACRO405', products_to_install ) > 0 THEN
            IF RunInstall( x.acro405 ) == BAD_RC THEN           /* Install Acrobat Reader 4.05  */
                AbortInstall( x.acro405 )

        IF POS('CDWECS', products_to_install ) > 0 THEN
            IF RunInstall( x.cdwecs ) == BAD_RC THEN            /* Install RSJ CD writer        */
                AbortInstall( x.cdwecs )

        IF POS('MMECS', products_to_install ) > 0 THEN DO
            IF RunInstall( x.mmpm ) == BAD_RC THEN              /* Install MultiMedia           */
                AbortInstall( x.mmpm )
            '@CALL' ecs_cmd'\SAVLANLK.CMD' instdrive logpath'\SAVLANLK.LOG'
        END

        IF POS('SDDVCFG', products_to_install ) > 0 THEN
            IF RunInstall( x.sddcfg ) == BAD_RC THEN           /* Update screen pages for SNAP */
                AbortInstall( x.sddcfg )

        IF POS('DLGMMPM', products_to_install ) > 0 THEN
            IF RunInstall( x.dlgmmpm ) == BAD_RC THEN          /* Install MultiMedia resources */
                AbortInstall( x.dlgmmpm )

        IF POS('CAIRO', products_to_install ) > 0 THEN
            IF RunInstall( x.cairo ) == BAD_RC THEN            /* Install Cairo libraries*/
                AbortInstall( x.cairo )

        IF POS('DSSAVER', products_to_install ) > 0 THEN
            IF RunInstall( x.dssaver ) == BAD_RC THEN          /* Install Doodle's screensaver */
                AbortInstall( x.dssaver )

        IF POS('TAME', products_to_install ) > 0 THEN
            IF RunInstall( x.tame ) == BAD_RC THEN             /* Install Tame scanner support */
                AbortInstall( x.tame )

        IF POS('4OS2', products_to_install ) > 0 THEN
            IF RunInstall( x.forostwo ) == BAD_RC THEN             /* Install 4OS/2 commandline shell */
                AbortInstall( x.forostwo )

        IF POS('LUCIDE', products_to_install ) > 0 THEN
            IF RunInstall( x.lucide ) == BAD_RC THEN           /* Install Lucide Document viewer */
                AbortInstall( x.lucide )

        IF POS('ESCHEMES', products_to_install ) > 0 THEN
            IF RunInstall( x.eschemes ) == BAD_RC THEN         /* Install eSchemes Desktop schemes */
                AbortInstall( x.eschemes )

        IF POS('PSIOS2', products_to_install ) > 0 THEN
            IF RunInstall( x.psios2 ) == BAD_RC THEN           /* Install Psi/2 Instant Messenger */
                AbortInstall( x.psios2 )

        IF POS('ESAMBAC', products_to_install ) > 0 THEN
            IF RunInstall( x.esambac ) == BAD_RC THEN          /* Install eComStation Samba Client */
                AbortInstall( x.esambac )

        IF POS('GENMAC', products_to_install ) > 0 THEN
            IF RunInstall( x.genmac ) == BAD_RC THEN           /* Install GenMac support         */
                AbortInstall( x.genmac )

        IF POS('XWLAN', products_to_install ) > 0 THEN         /* Install XWLAN widget/standalone */
            IF RunInstall( x.xwlan ) == BAD_RC THEN
                AbortInstall( x.xwlan )

        IF POS('FAXWORKS', products_to_install ) > 0 THEN
            IF RunInstall( x.faxworks ) == BAD_RC THEN         /* Install FaxWorks (using warpin) */
                AbortInstall( x.faxworks )

        IF POS('FAT32', products_to_install ) > 0 THEN
            IF RunInstall( x.FAT32 ) == BAD_RC THEN
                AbortInstall( x.FAT32 )

        IF POS('PMVNC', products_to_install ) > 0 THEN
            IF RunInstall( x.pmvnc ) == BAD_RC THEN             /* Install PMVNC server         */
                AbortInstall( x.pmvnc )

        IF POS('SECURITY', products_to_install ) > 0 THEN
            IF RunInstall( x.security ) == BAD_RC THEN
                AbortInstall( x.security )

        IF POS('OPENSSH', products_to_install ) > 0 THEN        /* install OpenSSH client       */
            IF RunInstall( x.openssh ) == BAD_RC THEN
                AbortInstall( x.openssh )

        IF POS('USBDOCK', products_to_install ) > 0 THEN        /* install USBDock              */
            IF RunInstall( x.usbdock ) == BAD_RC THEN
                AbortInstall( x.usbdock )

        IF POS('SHUFFLE', products_to_install ) > 0 THEN
            IF RunInstall( x.shuffle ) == BAD_RC THEN           /* Run the desktop shuffler     */
                AbortInstall( x.shuffle )

        IF POS('SGUIDE', products_to_install ) > 0 THEN
            IF RunInstall( x.sguide ) == BAD_RC THEN            /* Install SmartGuides          */
                AbortInstall( x.sguide )

        IF POS('EFDS', products_to_install ) > 0 THEN
            IF RunInstall( x.efds ) == BAD_RC THEN              /* Conform to eFDS requirements */
                AbortInstall( x.efds )

        IF POS('SRVIFS', products_to_install ) > 0 THEN
            IF RunInstall( x.ifsdel ) == BAD_RC THEN            /* Remove the CID requester     */
                AbortInstall( x.ifsdel )

        IF POS('ECSMT', products_to_install ) > 0 THEN
            IF RunInstall( x.ecsmt ) == BAD_RC THEN             /* Install ECSMT                */
                AbortInstall( x.ecsmt )

        IF POS('FINISH', products_to_install ) > 0 THEN
            IF RunInstall( x.finish ) == BAD_RC THEN            /* Run final tasks for Phase 2  */
                AbortInstall( x.finish )

        IF POS('FLOPPYCMD', products_to_install ) > 0 THEN
            IF RunInstall( x.floppycmd ) == BAD_RC THEN         /* Update STARTUP.CMD           */
                AbortInstall( x.floppycmd )

        '@CALL' ecs_cmd'\RSTLANLK.CMD'                          /* Restore locked file list     */

        SAY GetNLSMessage( 101 )
        CALL ClearEnvironmentVars
    END

    OTHERWISE NOP

END
EXIT


/*************************************************************/
/*         DO NOT MODIFY ANY CODE BELOW THIS LINE !!!        */
/*************************************************************/
RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do

    state = value('REMOTE_INSTALL_STATE',,'OS2ENVIRONMENT')     /* check   REMOTE_INSTALL_STATE */
    if state <> 0 then
      rc2 = LogMessage(75, x.index.name, state, logfile)        /* log an install starting msg  */
    else
      rc2 = LogMessage(72, x.index.name, '', logfile)           /* log an install starting msg  */

    install_prog = '@CMD /C ' || strip(x.index.instprog)        /* build the command string     */

                                                /* If automatic response file selection was     */
                                                /* indicated, then get the response file name   */
                                                /* and append it to the command string.         */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
                                            , x.index.default, x.index.name,
                                            , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end

/*    say '['date() time()'] ' x.index.message '...' */
    say x.index.message '...'
    install_prog                                                /* Execute the install program  */

    state = value(x.index.statevar,,'OS2ENVIRONMENT')           /* Get the current install state*/
                                                                /* for this install program from*/
                                                                /* the environment.             */

                                                /* Check the return code and set the global     */
                                                /* variables accordingly.                       */

    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
           with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN

    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')      /* Set the new install state for*/
                                                                /* this install program.        */

                                                /* Put the install state into the CONFIG.SYS,   */
                                                /* if this action was unsuccessful, then exit.  */

    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit x2d(1604)

    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then     /* If the install program was   */
        Call PreserveStartupCmd(install_prog)                   /* SEMAINT, then make sure      */
                                                                /* STARTUP.CMD won't be copied  */
                                                                /* over when SEINST runs.       */

      rc2 = LogMessage(70, x.index.name, '', logfile)           /* log an install successful msg*/
      return GOOD_RC                                            /* return a good return code    */
    end

    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)           /* log an install failed msg    */
      if (new_state <> '') then                                 /* If a new state was requested,*/
                                                                /* then set OVERALL_STATE to the*/
        rc2 = SetState(new_state, 'RunInstall', 2)              /* new state.                   */

      return BAD_RC                                             /* return a bad return code     */
    end
  end
  else say x.index.name 'not processed.'
  return GOOD_RC


/*************************************************************/
PreserveStartupCmd: procedure

  parse upper arg string, other

  if pos('/T:', string) <> 0 then                               /* Determine if there is a      */
    findvalue = '/T:'                                           /* target parameter.  If there  */
  else                                                          /* is none, return.             */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0

  remain = substr(string, pos(findvalue, string) + 3)           /* Get the value of the target  */
                                                                /* parameter.                   */
  blank = pos(' ', remain)

  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain
                                                /* Erase startup.lcu in the target directory,  */
                                                /* then rename startup.s13 to startup.lcu      */

  'if exist ' param || '\startup.lcu erase  ' param || '\startup.lcu'
  'if exist ' param || '\startup.s13 rename ' param || '\startup.s13 *.lcu'

  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS


  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')         /* Get the overall install state */
                                                                /* from the environment.         */

  if OVERALL_STATE == '' then do                                /* If the overall install state  */
    OVERALL_STATE = 0                                           /* has not been set yet, reset   */
    do I=0 to NUM_INSTALL_PROGS by 1                            /* all the state vars to 0.      */
      if x.I.statevar <> '' then
        rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end

  return OVERALL_STATE


/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do                                   /* If the install program has   */
                                                                /* no state variable, then ...  */

    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')     /* Set the REMOTE_INSTALL_STATE */
                                                                /* to 0 so that the program     */
                                                                /* being run can know that is   */
                                                                /* being run in an unattended   */
                                                                /* environment.                 */

    return YES                                                  /* return install=yes           */

  end

  state = value(env_string,,'OS2ENVIRONMENT')                   /* Otherwise, get the value of  */
                                                                /* the state variable from the  */
                                                                /* environment.                 */

  if state <> '' then do                                        /* If the state variable exists */

    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')   /* Set the REMOTE_INSTALL_STATE */
                                                                /* environment variable to the  */
                                                                /* value of the state variable. */

    return YES                                                  /* return install=yes           */
  end
  else                                                          /* Otherwise,                   */
    return NO                                                   /* return install=no            */


/*************************************************************/
BootDriveIsDiskette:

  if IsBootDriveRemovable() == 1 then do                        /* If the drive booted from is  */
                                                                /* a diskette drive, then set   */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from the hardfile.           */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:

  if IsBootDriveRemovable() == 0 then do                        /* If the drive booted from is  */
                                                                /* a fixed disk, then set       */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from a diskette.             */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other

    if datatype(new_state, number) <> 1 then do                 /* If the new state requested is*/
                                                                /* not numeric, then log an     */
      if proc_name <> '' then                                   /* error.                       */
        LogMessage(63, proc_name, param_num, logfile)
      else
        LogMessage(63, 'SetState', 1, logfile)

      exit
    end

    OVERALL_STATE = new_state                                   /* Set the OVERALL_STATE to the */
                                                                /* new state requested.         */

    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')       /* Save the OVERALL_STATE in the*/
                                                                /* environment.                 */
    return 'NO_ERROR'


/*************************************************************/
SaveStates:

  do I=0 to NUM_INSTALL_PROGS by 1            /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                /* if this action was unsuccessful, then exit.  */

      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
                     , configsys, logfile) <> 0 then exit
  end

  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other

  rc2 = SetState(new_state, 'RebootAndGotoState', 1)           /* Set the state to go to in    */
                                                               /* OVERALL_STATE.               */

  Call SaveStates                                              /* Save the environment vars    */

  Call Reboot                                                  /* Reboot the machine           */

  return


/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do                                  /* If a reboot has been queued  */
                                                                /* by an install program ...    */

    if CALL_AGAIN == 0 then                                     /* If no install programs want  */
                                                                /* to be recalled ...           */

      rc = SetState(OVERALL_STATE+1)                            /* Increment the overall state  */
                                                                /* variable.                    */

    Call SaveStates                                             /* Save the environment vars    */

    Call Reboot                                                 /* Reboot the machine           */

  end

  else                                                          /* Otherwise, increment the     */
    rc = SetState(OVERALL_STATE+1)                              /* state variable and go on.    */

  return


/*************************************************************/
Reboot:
  bootdrive

  rc = value('OS2_SHELL', bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')

  'cls'
  rc = AskRemoveDiskIfFloppy()

  pathlen = length(cid_exe)                                     /* Get length of exepath        */
  posslash = lastpos("\",strip(cid_exe))                        /* Determine the last occurcnce */
                                                                /*   of '\' in exepath          */

  if posslash = pathlen then                                    /* If '\' is the last character */

    cmdline = cid_exe || 'SETBOOT /IBD:' || bootdrive           /* Then append 'SETBOOT'        */

  else

    cmdline = cid_exe || '\SETBOOT /IBD:' || bootdrive          /* Else append '\SETBOOT'       */

  LogMessage(74, '', '', logfile)                               /* Log a message indicating     */
                                                                /* reboot.                      */
  cmdline

  LogMessage(73, 'SETBOOT', '', logfile)                        /* If the code gets to here, the*/
                                                                /* reboot failed.  Log a message*/
  exit                                                          /* and exit.                    */

  return


/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'
  Call RxFuncAdd 'GetOS2Version',         'CASAGENT', 'GETOS2VERSION'
  Call RxFuncAdd 'SetCIDType',            'CASAGENT', 'SETCIDTYPE'

  return


/*************************************************************/
GetNLSMessage: PROCEDURE EXPOSE ecs_nls
    PARSE ARG msgnumber, substitution

    msgfile = ecs_nls'\ECS_LCU.MSG'

    IF msgnumber = '' THEN RETURN ''

    IF RxFuncQuery('SysGetMessage') \= 0 THEN
        CALL RxFuncAdd 'SysGetMessage', 'REXXUTIL', 'SysGetMessage'

    IF substitution \= '' THEN
        msgtext = SysGetMessage( msgnumber, msgfile, substitution )
    ELSE
        msgtext = SysGetMessage( msgnumber, msgfile )

    msgtext = STRIP( msgtext, 'T', '0A'x )
    msgtext = STRIP( msgtext, 'T', '0D'x )

RETURN msgtext


/*************************************************************/
ClearEnvironmentVars:

    /* Delete all state variables that are still defined */
    DO I=0 to NUM_INSTALL_PROGS by 1
        st = VALUE( x.I.statevar,, 'OS2ENVIRONMENT')
        IF st <> '' THEN
            CALL PutStateVar x.I.statevar,, configsys, logfile
    END

RETURN


/*************************************************************/
AbortInstall:
    ARG product

    /* Dump all current LCU variables to a file */
    recovery_file = rsppath'\recovery.var'
    IF STREAM( recovery_file, 'C', 'QUERY EXISTS') \= '' THEN
        '@ERASE' recovery_file ' >NUL 2>&1'
    CALL LINEOUT recovery_file,,1

    DO I=0 TO NUM_INSTALL_PROGS
        st = VALUE( x.I.statevar,, 'OS2ENVIRONMENT')
        CALL LINEOUT recovery_file, x.I.statevar '=' st
    END
    CALL STREAM recovery_file, 'C', 'CLOSE'

    '@ZIP 'logpath'\instlog.zip 'logpath'\*.* >NUL 2>&1'
    '@ZIP 'logpath'\instlog.zip 'instdrive||'\config.sys >NUL 2>&1'
    '@ZIP 'logpath'\instlog.zip 'instdrive||ecs_inst||'\rsp\*.* >NUL 2>&1'

    /* Now exit with the number of the failing installer */
EXIT product


/*************************************************************/
/*                    CONDITION HANDLERS                     */
/*************************************************************/
FAILURE:
    SAY 'LCUINST.CMD: line' sigl 'returned a failure code:'
    SAY SOURCELINE( sigl )
RETURN

/*
SYNTAX:
    SAY 'LCUINST.CMD: a syntax error was encountered on line' sigl':'
    SAY SOURCELINE( sigl )
    EXIT sigl
RETURN
*/
