/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20060912
 *
 * Disassembly of (null), Sun Nov  4 15:38:27 2007
 *
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x000051BF (20927)
 *     Revision         0x01
 *     OEM ID           "A0626"
 *     OEM Table ID     "A0626000"
 *     OEM Revision     0x00000000 (0)
 *     Creator ID       "INTL"
 *     Creator Revision 0x02002026 (33562662)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "A0626", "A0626000", 0x00000000)
{
    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (SPIO, 0x2E)
    Name (IOPB, 0x0230)
    Name (IOPL, 0x10)
    Name (IOEB, 0x0290)
    Name (IOEL, 0x10)
    Name (IOGB, 0x0A00)
    Name (IOGL, 0x10)
    Name (IODB, 0x0A10)
    Name (IODL, 0x10)
    Name (IO1B, 0x0A00)
    Name (IO1L, 0x08)
    Name (IO3B, 0x0290)
    Name (IO3L, 0x80)
    Name (SSMI, 0x082E)
    Name (SSEP, 0x99)
    Name (SSEN, 0x01)
    Name (APIC, 0x01)
    Name (SHPB, 0xFED00000)
    Name (SHPL, 0x1000)
    Name (PMBS, 0x0500)
    Name (PMLN, 0x0100)
    Name (SCBS, 0x0800)
    Name (SCLN, 0x0100)
    Name (ACBS, 0x0D00)
    Name (ACLN, 0x0100)
    Name (IGPB, 0x2000)
    Name (IGLN, 0x0100)
    Name (ACA4, 0x05A4)
    Name (SCIO, 0x0800)
    Name (SCTL, 0x0590)
    Name (EXTS, 0x00)
    Name (SGPS, 0x01)
    Name (SGPM, 0xFEFE0000)
    Name (SGPL, 0x0200)
    Name (SNAS, 0x01)
    Name (SNAM, 0xFEFE1000)
    Name (SNAL, 0x1000)
    Name (CQST, 0x3C)
    Name (PCIB, 0xE0000000)
    Name (PCIL, 0x10000000)
    Name (WKTP, 0x01)
    OperationRegion (BIOS, SystemMemory, 0x3FFCE064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
                Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32, 
        SMIF,   8, 
        DTSE,   8, 
        DTS1,   8, 
        DTS2,   8, 
        MPEN,   8
    }

    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, 0x00)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, 0x00))
        {
            Store (0xAC, DBG8)
        }

        Store (0x01, OSVR)
        If (CondRefOf (\_OSI, Local1))
        {
            If (\_OSI ("Windows 2001"))
            {
                Store (0x00, OSVR)
            }
        }
        Else
        {
            If (MCTH (\_OS, "Microsoft Windows NT"))
            {
                Store (0x04, OSVR)
            }
            Else
            {
                If (MCTH (\_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x02, OSVR)
                }

                If (MCTH (\_OS, "Linux"))
                {
                    Store (0x03, OSVR)
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), 0x01, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, 0x00))
        Store (ShiftLeft (SS1, 0x01), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (0x01, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, 0x01))
        }
        Else
        {
            ShiftRight (Local0, 0x01, Local0)
            If (LOr (LEqual (OSFL (), 0x01), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, 0x01))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, 0x01))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, DP80, 0x01)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Scope (\_PR)
    {
        Processor (CPU1, 0x01, 0x00000510, 0x06) {}
        Processor (CPU2, 0x02, 0x00000000, 0x00) {}
    }

    Scope (\_SB)
    {
        Name (PR00, Package (0x14)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                0x01, 
                LPMU, 
                0x00
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x00, 
                LUB0, 
                0x00
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x01, 
                LUB2, 
                0x00
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x01, 
                LAZA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x00, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x01, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x00, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x01, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x02, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x03, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x00, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x01, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x02, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x03, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                0x00, 
                LMAC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x00, 
                LSMB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x00, 
                LSA0, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x01, 
                LSA1, 
                0x00
            }
        })
        Name (AR00, Package (0x14)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                0x01, 
                LPMU, 
                0x00
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x00, 
                LUB0, 
                0x00
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x01, 
                LUB2, 
                0x00
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x01, 
                LAZA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x00, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x01, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x00, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x01, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x02, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x03, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x00, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x01, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x02, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000CFFFF, 
                0x03, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0x0007FFFF, 
                0x00, 
                LMAC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x00, 
                LSMB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x00, 
                LSA0, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x01, 
                LSA1, 
                0x00
            }
        })
        Name (PR11, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                0x00, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x01, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNEA, 
                0x00
            }
        })
        Name (AR11, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                0x00, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x01, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNEA, 
                0x00
            }
        })
        Name (PR12, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                0x00, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x01, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNED, 
                0x00
            }
        })
        Name (AR12, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                0x00, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x01, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNEC, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNED, 
                0x00
            }
        })
        Name (PR01, Package (0x0C)
        {
            Package (0x04)
            {
                0x000AFFFF, 
                0x00, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x01, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x02, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x03, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x00, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x01, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x03, 
                LNKD, 
                0x00
            }
        })
        Name (AR01, Package (0x0C)
        {
            Package (0x04)
            {
                0x000AFFFF, 
                0x00, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x01, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x02, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x03, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x00, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x01, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNKD, 
                0x00
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x00, 
                LNKA, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x01, 
                LNKB, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x02, 
                LNKC, 
                0x00
            }, 

            Package (0x04)
            {
                0x0008FFFF, 
                0x03, 
                LNKD, 
                0x00
            }
        })
        Name (PR02, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                0x00, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x01, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNEC, 
                0x00
            }
        })
        Name (AR02, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                0x00, 
                LNED, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x01, 
                LNEA, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNEB, 
                0x00
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNEC, 
                0x00
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {7,10,11,14}
        })
        Alias (PRSA, PRSB)
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, RSEA)
        Alias (PRSA, RSEB)
        Alias (PRSA, RSEC)
        Alias (PRSA, RSED)
        Alias (PRSA, RSMB)
        Alias (PRSA, RSB2)
        Alias (PRSA, RSMU)
        Name (RSA1, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5}
        })
        Name (RSA0, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        Alias (PRSA, RSB0)
        Alias (PRSA, RSAC)
        Alias (PRSA, RSZA)
        Alias (PRSA, RSCI)
        Alias (PRSA, RSC9)
        Alias (PRSA, RSTA)
        Name (RSIR, ResourceTemplate ()
        {
            Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
            {
                0x00000010,
                0x00000011,
                0x00000012,
                0x00000013,
            }
        })
        Name (RSII, ResourceTemplate ()
        {
            Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
            {
                0x00000014,
                0x00000015,
                0x00000016,
                0x00000017,
            }
        })
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))
            Name (_ADR, 0x00180000)
            Method (^BN00, 0, NotSerialized)
            {
                Return (0x00)
            }

            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }

            Name (_UID, 0x00)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (SBRG)
            {
                Name (_ADR, 0x00010000)
                Method (SPTS, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x03))
                    {
                        Store (0x00, LCTM)
                        Store (0x00, LCNM)
                    }

                    Store (Arg0, \_SB.PCI0.IDE0.PTS0)
                    Store (\_SB.PCI0.IDE0.ID20, \_SB.PCI0.IDE0.SID0)
                    Store (\_SB.PCI0.IDE0.IDTS, \_SB.PCI0.IDE0.SID1)
                    Store (\_SB.PCI0.IDE0.IDTP, \_SB.PCI0.IDE0.SID2)
                    Store (\_SB.PCI0.IDE0.ID22, \_SB.PCI0.IDE0.SID3)
                    Store (\_SB.PCI0.IDE0.UMSS, \_SB.PCI0.IDE0.SID4)
                    Store (\_SB.PCI0.IDE0.UMSP, \_SB.PCI0.IDE0.SID5)
                    Store (One, PS1S)
                    Store (One, PS1E)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, PS1E)
                    Store (0x02, S1CT)
                    Store (0x02, S3CT)
                    Store (0x02, S4CT)
                    Store (0x02, S5CT)
                }

                OperationRegion (SMIE, SystemIO, SCIO, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   15, 
                    PS1S,   1, 
                        ,   31, 
                    PS1E,   1, 
                            Offset (0x08)
                }

                OperationRegion (SXCT, SystemIO, SCTL, 0x10)
                Field (SXCT, ByteAcc, NoLock, Preserve)
                {
                    S1CT,   2, 
                            Offset (0x04), 
                    S3CT,   2, 
                            Offset (0x08), 
                    S4CT,   2, 
                            Offset (0x0C), 
                    S5CT,   2, 
                            Offset (0x10)
                }

                Scope (\_SB)
                {
                    OperationRegion (\SCPP, SystemIO, SSMI, 0x01)
                    Field (\SCPP, ByteAcc, NoLock, Preserve)
                    {
                        SMIP,   8
                    }

                    OperationRegion (\APA4, SystemIO, ACA4, 0x04)
                    Field (\APA4, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x02), 
                        LCTM,   1, 
                        LCNM,   1
                    }

                    Scope (PCI0)
                    {
                        Method (_S3D, 0, NotSerialized)
                        {
                            If (LEqual (OSFL (), 0x02))
                            {
                                Return (0x02)
                            }
                            Else
                            {
                                Return (0x03)
                            }
                        }

                        Name (_S1D, 0x01)
                        Name (NATA, Package (0x01)
                        {
                            0x00100000
                        })
                        Device (NVRB)
                        {
                            Name (_HID, "NVRAIDBUS")
                            Method (_STA, 0, NotSerialized)
                            {
                                If (And (CPB0, 0x01))
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (0x00)
                                }
                            }

                            Name (_CRS, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x04D2,             // Range Minimum
                                    0x04D2,             // Range Maximum
                                    0x01,               // Alignment
                                    0x01,               // Length
                                    )
                            })
                        }
                    }
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (FDC)
                {
                    Name (_HID, EisaId ("PNP0700"))
                    Method (_FDE, 0, NotSerialized)
                    {
                        Name (FDEP, Package (0x05)
                        {
                            0x00, 
                            0x00, 
                            0x02, 
                            0x02, 
                            0x02
                        })
                        If (_STA ())
                        {
                            Store (0x01, Index (FDEP, 0x00))
                        }

                        Return (FDEP)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x03))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x03, 0x00)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x03, 0x01)
                        Store (IRQM, IRQE)
                        Store (DMAM, DMAE)
                        Store (IO11, IO21)
                        Store (IO12, IO22)
                        Store (0x06, LEN2)
                        Add (IO21, 0x07, IO31)
                        Store (IO31, IO32)
                        Store (0x01, LEN3)
                        Return (CRS2)
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x03)
                        CreateWordField (Arg0, 0x11, IRQE)
                        CreateByteField (Arg0, 0x14, DMAE)
                        ENFG (CGLD (0x03))
                        If (IRQE)
                        {
                            FindSetRightBit (IRQE, Local0)
                            Subtract (Local0, 0x01, INTR)
                        }
                        Else
                        {
                            Store (0x00, INTR)
                        }

                        If (DMAE)
                        {
                            FindSetRightBit (DMAE, Local0)
                            Subtract (Local0, 0x01, DMCH)
                        }
                        Else
                        {
                            Store (0x04, DMCH)
                        }

                        EXFG ()
                    }

                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {6}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {2}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0370,             // Range Minimum
                                0x0370,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x0377,             // Range Minimum
                                0x0377,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }

                Device (LPTE)
                {
                    Method (_HID, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (0x0104D041)
                        }
                        Else
                        {
                            Return (0x0004D041)
                        }
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x02))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x02, 0x00)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        DCRS (0x02, 0x01)
                        If (LPTM (0x02))
                        {
                            Store (IRQM, IRQE)
                            Store (DMAM, DMAE)
                            Store (IO11, IO21)
                            Store (IO12, IO22)
                            Store (LEN1, LEN2)
                            Add (IO21, 0x0400, IO31)
                            Store (IO31, IO32)
                            Store (LEN2, LEN3)
                            Return (CRS2)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x02)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        If (LPTM (0x02))
                        {
                            Return (EPPR)
                        }
                        Else
                        {
                            Return (LPPR)
                        }
                    }

                    Name (LPPR, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                    Name (EPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {7}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {0,1,2,3}
                        }
                        EndDependentFn ()
                    })
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                            0x00000000,         // Granularity
                            0x000D0000,         // Range Minimum
                            0x000D3FFF,         // Range Maximum
                            0x00000000,         // Translation Offset
                            0x00004000,         // Length
                            ,, , AddressRangeMemory, TypeStatic)
                        DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                            0x00000000,         // Granularity
                            0x000D4000,         // Range Minimum
                            0x000D7FFF,         // Range Maximum
                            0x00000000,         // Translation Offset
                            0x00004000,         // Length
                            ,, , AddressRangeMemory, TypeStatic)
                        DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                            0x00000000,         // Granularity
                            0x000DE000,         // Range Minimum
                            0x000DFFFF,         // Range Maximum
                            0x00000000,         // Translation Offset
                            0x00002000,         // Length
                            ,, , AddressRangeMemory, TypeStatic)
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x0A,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x0B,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0800,             // Range Minimum
                            0x0800,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y00)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y01)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y02)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y03)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y04)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y05)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y06)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y07)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y08)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y09)
                        Memory32Fixed (ReadOnly,
                            0xFEE01000,         // Address Base
                            0x000FF000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0xFFB80000,         // Address Base
                            0x00480000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0xFF300000,         // Address Base
                            0x00100000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MIN, GP00)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MAX, GP01)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._LEN, GP0L)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MIN, GP10)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MAX, GP11)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._LEN, GP1L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        If (LGreaterEqual (PMLN, 0x0100))
                        {
                            ShiftRight (PMLN, 0x01, GP0L)
                            Add (GP00, GP0L, GP10)
                            Add (GP01, GP0L, GP11)
                            Subtract (PMLN, GP0L, GP1L)
                        }
                        Else
                        {
                            Store (PMLN, GP0L)
                        }

                        If (SCBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MIN, SC00)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MAX, SC01)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._LEN, SC0L)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y03._MIN, SC10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y03._MAX, SC11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y03._LEN, SC1L)
                            Store (SCBS, SC00)
                            Store (SCBS, SC01)
                            If (LGreaterEqual (SCLN, 0x0100))
                            {
                                ShiftRight (SCLN, 0x01, SC0L)
                                Add (SC00, SC0L, SC10)
                                Add (SC01, SC0L, SC11)
                                Subtract (SCLN, SC0L, SC1L)
                            }
                            Else
                            {
                                Store (SCLN, SC0L)
                            }
                        }

                        If (ACBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y04._MIN, AC00)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y04._MAX, AC01)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y04._LEN, AC0L)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y05._MIN, AC10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y05._MAX, AC11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y05._LEN, AC1L)
                            Store (ACBS, AC00)
                            Store (ACBS, AC01)
                            If (LGreaterEqual (ACLN, 0x0100))
                            {
                                ShiftRight (ACLN, 0x01, AC0L)
                                Add (AC00, AC0L, AC10)
                                Add (AC01, AC0L, AC11)
                                Subtract (ACLN, AC0L, AC1L)
                            }
                            Else
                            {
                                Store (ACLN, AC0L)
                            }
                        }

                        If (IGPB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y06._MIN, IC00)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y06._MAX, IC01)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y06._LEN, IC0L)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y07._MIN, IC10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y07._MAX, IC11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y07._LEN, IC1L)
                            Store (IGPB, IC00)
                            Store (IGPB, IC01)
                            If (LGreaterEqual (IGLN, 0x0100))
                            {
                                ShiftRight (IGLN, 0x01, IC0L)
                                Add (IC00, IC0L, IC10)
                                Add (IC01, IC0L, IC11)
                                Subtract (IGLN, IC0L, IC1L)
                            }
                            Else
                            {
                                Store (IGLN, IC0L)
                            }
                        }

                        If (SGPS)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y08._BAS, SB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y08._LEN, SL01)
                            Store (SGPM, SB01)
                            Store (SGPL, SL01)
                        }

                        If (SNAS)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y09._BAS, AB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y09._LEN, AL01)
                            Store (SNAM, AB01)
                            Store (SNAL, AL01)
                        }

                        Return (CRS)
                    }
                }

                Scope (\_SB.PCI0.SBRG)
                {
                    Device (ASOC)
                    {
                        Name (_HID, "ATK0110")
                        Name (_UID, 0x01010110)
                        Method (_STA, 0, NotSerialized)
                        {
                            Return (0x0F)
                        }
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (_UID, 0x00)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0A)
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (OSFL (), 0x00))
                        {
                            If (LEqual (NVID, 0x10DE))
                            {
                                Return (0x0F)
                            }
                            Else
                            {
                                Return (0x00)
                            }
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.HPET._Y0A._BAS, HPX1)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.HPET._Y0A._LEN, HPX2)
                        Store (SHPB, HPX1)
                        Store (SHPL, HPX2)
                        Return (CRS)
                    }

                    OperationRegion (HPTE, SystemMemory, SHPB, 0x04)
                    Field (HPTE, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x02), 
                        NVID,   16
                    }
                }

                OperationRegion (\_SB.PCI0.SBRG.LPDC, PCI_Config, 0xA0, 0x06)
                Field (\_SB.PCI0.SBRG.LPDC, ByteAcc, NoLock, Preserve)
                {
                    S3F8,   1, 
                    S2F8,   1, 
                        ,   3, 
                    S2E8,   1, 
                        ,   1, 
                    S3E8,   1, 
                        ,   4, 
                    M300,   1, 
                        ,   2, 
                    M330,   1, 
                        ,   4, 
                    FDC0,   1, 
                            Offset (0x03), 
                    P378,   1, 
                    P278,   1, 
                    P3BC,   1, 
                            Offset (0x04), 
                    G200,   8, 
                    G208,   8
                }

                Method (RRIO, 4, NotSerialized)
                {
                    If (LOr (LEqual (Arg0, 0x00), LEqual (Arg0, 0x01)))
                    {
                        If (LEqual (Arg2, 0x03F8))
                        {
                            Store (Arg1, S3F8)
                        }

                        If (LEqual (Arg2, 0x02F8))
                        {
                            Store (Arg1, S2F8)
                        }

                        If (LEqual (Arg2, 0x03E8))
                        {
                            Store (Arg1, S3E8)
                        }

                        If (LEqual (Arg2, 0x02E8))
                        {
                            Store (Arg1, S2E8)
                        }
                    }

                    If (LEqual (Arg0, 0x02))
                    {
                        If (LEqual (Arg2, 0x0378))
                        {
                            Store (Arg1, P378)
                        }

                        If (LEqual (Arg2, 0x0278))
                        {
                            Store (Arg1, P278)
                        }

                        If (LEqual (Arg2, 0x03BC))
                        {
                            Store (Arg1, P3BC)
                        }
                    }

                    If (LEqual (Arg0, 0x03))
                    {
                        Store (Arg1, FDC0)
                    }

                    If (LEqual (Arg0, 0x05))
                    {
                        If (LEqual (Arg2, 0x0330))
                        {
                            Store (Arg1, M330)
                        }

                        If (LEqual (Arg2, 0x0300))
                        {
                            Store (Arg1, M300)
                        }
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        Store (Zero, Local0)
                        If (Arg1)
                        {
                            Store (0xFF, Local0)
                        }

                        If (LEqual (Arg2, 0x0200))
                        {
                            Store (Local0, G200)
                        }

                        If (LEqual (Arg2, 0x0208))
                        {
                            Store (Local0, G208)
                        }
                    }
                }

                Method (RDMA, 3, NotSerialized)
                {
                }

                Scope (\)
                {
                    OperationRegion (\RAMW, SystemMemory, Subtract (TOPM, 0x00010000), 0x00010000)
                    Field (\RAMW, ByteAcc, NoLock, Preserve)
                    {
                        PAR0,   32, 
                        PAR1,   32, 
                        PAR2,   32, 
                                Offset (0x12), 
                        TOP1,   32, 
                        UMAS,   32
                    }

                    OperationRegion (IOB2, SystemIO, 0x082E, 0x02)
                    Field (IOB2, ByteAcc, NoLock, Preserve)
                    {
                        SMIC,   8, 
                        SMIS,   8
                    }

                    Method (ISMI, 1, Serialized)
                    {
                        Store (Arg0, SMIC)
                    }

                    Method (GNVS, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x70)
                        Return (PAR1)
                    }

                    Method (SNVS, 2, Serialized)
                    {
                        Store (Arg0, PAR0)
                        Store (Arg1, PAR1)
                        ISMI (0x71)
                    }
                }

                Scope (\)
                {
                    Field (\RAMW, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x28), 
                        AWEN,   1
                    }
                }

                Scope (\_SB)
                {
                    Device (\AWY)
                    {
                        Name (_HID, "AWY0001")
                        Method (SMOD, 1, NotSerialized)
                        {
                        }

                        Method (_STA, 0, NotSerialized)
                        {
                            If (AWEN)
                            {
                                Return (0x0F)
                            }

                            Return (0x00)
                        }
                    }
                }

                Device (\_SB.PCI0.PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xE0000000,         // Address Base
                            0x10000000,         // Address Length
                            _Y0B)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y0B._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y0B._LEN, LEN1)
                        Store (\PCIB, BAS1)
                        Store (\PCIL, LEN1)
                        Return (CRS)
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x00)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0C)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0D)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0E)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y0C._LEN, ML01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y0C._BAS, MB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y0D._LEN, ML02)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y0D._BAS, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                        }

                        CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y0E._BAS, BAS5)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y0E._LEN, LEN5)
                        Store (TOP1, BAS5)
                        Store (UMAS, LEN5)
                        Return (CRS)
                    }
                }

                Device (\_SB.RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, 0x01)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0F)
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            _Y10)
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            _Y11)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y12)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.RMEM._Y0F._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.RMEM._Y0F._LEN, LEN1)
                        CreateDWordField (CRS, \_SB.RMEM._Y10._BAS, BAS2)
                        CreateDWordField (CRS, \_SB.RMEM._Y10._LEN, LEN2)
                        CreateDWordField (CRS, \_SB.RMEM._Y11._LEN, LEN3)
                        CreateDWordField (CRS, \_SB.RMEM._Y12._BAS, BAS4)
                        CreateDWordField (CRS, \_SB.RMEM._Y12._LEN, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Add (MG2B, MG2L, BAS4)
                        Subtract (0x00, BAS4, LEN4)
                        Return (CRS)
                    }
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, 0x0B03D041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (0x01, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (0x00)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Method (PS2K._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x10, 0x04))
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))
                    Name (_CID, 0x130FD041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (0x01, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (0x00)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                }

                Method (PS2M._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x10, 0x04))
                }

                Device (SIOR)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Method (_UID, 0, NotSerialized)
                    {
                        Return (SPIO)
                    }

                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y13)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y14)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y15)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y16)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y17)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LAnd (LNotEqual (SPIO, 0x03F0), LGreater (SPIO, 0xF0)))
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y13._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y13._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y13._LEN, GPL1)
                            Store (SPIO, GP10)
                            Store (SPIO, GP11)
                            Store (0x02, GPL1)
                        }

                        If (IOPB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y14._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y14._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y14._LEN, GPL2)
                            Store (IOPB, GP20)
                            Store (IOPB, GP21)
                            Store (IOPL, GPL2)
                        }

                        If (IOEB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y15._MIN, GP30)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y15._MAX, GP31)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y15._LEN, GPL3)
                            Store (IOEB, GP30)
                            Store (IOEB, GP31)
                            Store (IOEL, GPL3)
                        }

                        If (IOGB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y16._MIN, GP40)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y16._MAX, GP41)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y16._LEN, GPL4)
                            Store (IOGB, GP40)
                            Store (IOGB, GP41)
                            Store (IOGL, GPL4)
                        }

                        If (IODB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y17._MIN, GP50)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIOR._Y17._MAX, GP51)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIOR._Y17._LEN, GPL5)
                            Store (IODB, GP50)
                            Store (IODB, GP51)
                            Store (IODL, GPL5)
                        }

                        Return (CRS)
                    }
                }

                Name (DCAT, Package (0x16)
                {
                    0x01, 
                    0x02, 
                    0x03, 
                    0x00, 
                    0xFF, 
                    0x08, 
                    0xFF, 
                    0xFF, 
                    0x09, 
                    0xFF, 
                    0x05, 
                    0x04, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0x0A, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF, 
                    0xFF
                })
                Name (IKEY, Package (0x02)
                {
                    Package (0x04)
                    {
                        0x87, 
                        0x01, 
                        0x55, 
                        0x55
                    }, 

                    Package (0x04)
                    {
                        0x87, 
                        0x01, 
                        0x55, 
                        0xAA
                    }
                })
                Name (KBFG, 0x01)
                Name (MSFG, 0x01)
                Name (UR1F, 0x01)
                Method (ENFG, 1, NotSerialized)
                {
                    Store (0x00, Local1)
                    If (LEqual (SPIO, 0x2E))
                    {
                        Store (0x00, Local1)
                    }

                    If (LEqual (SPIO, 0x4E))
                    {
                        Store (0x01, Local1)
                    }

                    Store (0x00, Local0)
                    While (LNotEqual (Local0, 0x04))
                    {
                        Store (DerefOf (Index (DerefOf (Index (IKEY, Local1)), Local0)), 
                            INDX)
                        Increment (Local0)
                    }

                    Store (Arg0, LDN)
                }

                Method (ENTR, 0, NotSerialized)
                {
                    Store (0x87, INDX)
                    Store (0x01, INDX)
                    Store (0x55, INDX)
                    If (LEqual (SPIO, 0x2E))
                    {
                        Store (0x55, INDX)
                    }
                    Else
                    {
                        Store (0xAA, INDX)
                    }
                }

                Method (EXFG, 0, NotSerialized)
                {
                    Store (0x02, INDX)
                    Store (0x02, DATA)
                }

                Method (LPTM, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    And (OPT0, 0x02, Local0)
                    EXFG ()
                    Return (Local0)
                }

                Method (UHID, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    And (OPT0, 0x70, Local0)
                    EXFG ()
                    If (Local0)
                    {
                        Return (0x1005D041)
                    }

                    Return (0x0105D041)
                }

                Method (ORF0, 1, NotSerialized)
                {
                    ENTR ()
                    Or (OPT0, Arg0, OPT0)
                    EXFG ()
                }

                Method (ORF1, 1, NotSerialized)
                {
                    ENTR ()
                    Or (OPT1, Arg0, OPT1)
                    EXFG ()
                }

                Method (ORF2, 1, NotSerialized)
                {
                    ENTR ()
                    Or (OPT2, Arg0, OPT2)
                    EXFG ()
                }

                Method (ANF0, 1, NotSerialized)
                {
                    ENTR ()
                    And (OPT0, Arg0, OPT0)
                    EXFG ()
                }

                Method (ANF2, 1, NotSerialized)
                {
                    ENTR ()
                    And (OPT2, Arg0, OPT2)
                    EXFG ()
                }

                Method (ANF4, 1, NotSerialized)
                {
                    ENTR ()
                    And (OPT4, Arg0, OPT4)
                    EXFG ()
                }

                Method (STF0, 1, NotSerialized)
                {
                    ENTR ()
                    Store (Arg0, OPT0)
                    EXFG ()
                }

                Method (STF1, 1, NotSerialized)
                {
                    ENTR ()
                    Store (Arg0, OPT1)
                    EXFG ()
                }

                Method (SIOS, 1, NotSerialized)
                {
                    Store ("SIOS", Debug)
                    Store (0x00, GP10)
                    If (LLess (Arg0, 0x05))
                    {
                        ENFG (0x04)
                        Store (0x01, ACTR)
                        EXFG ()
                        ANF4 (0xFC)
                        ORF1 (0x18)
                        If (KBFG)
                        {
                            ORF0 (0x08)
                        }
                        Else
                        {
                            ANF0 (0xF7)
                        }

                        If (MSFG)
                        {
                            ORF0 (0x10)
                        }
                        Else
                        {
                            ANF0 (0xEF)
                            EXFG ()
                        }

                        ENFG (0x04)
                        ANF2 (0xF0)
                        ENFG (0x07)
                        If (LLess (Arg0, 0x04))
                        {
                            And (OPF9, 0xFE, OPF9)
                            And (OPC0, 0xFE, OPC0)
                        }

                        And (OP29, 0xEF, OP29)
                        EXFG ()
                    }
                    Else
                    {
                        ENFG (0x07)
                        And (OPC0, 0x00, OPC0)
                        Or (OPC0, 0x01, OPC0)
                        Or (OPF9, 0x01, OPF9)
                        And (OP29, 0xEF, OP29)
                        EXFG ()
                    }
                }

                Method (SIOW, 1, NotSerialized)
                {
                    Store (0x01, GP10)
                    Store ("SIOW", Debug)
                    ENFG (0x04)
                    Store (0x00, ACTR)
                    EXFG ()
                    STF0 (0x00)
                    STF1 (0xFF)
                    ENFG (0x07)
                    Or (OP29, 0x10, OP29)
                    Or (OPC0, 0x01, OPC0)
                    EXFG ()
                    ENFG (0x05)
                    Or (ACTR, 0x01, ACTR)
                    EXFG ()
                    ENFG (0x06)
                    Or (ACTR, 0x01, ACTR)
                    EXFG ()
                    ENFG (0x04)
                    Store (0x01, ACTR)
                    EXFG ()
                }

                Method (SIOH, 0, NotSerialized)
                {
                    Store ("SIOH", Debug)
                }

                OperationRegion (IOID, SystemIO, SPIO, 0x02)
                Field (IOID, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x07), 
                    LDN,    8, 
                            Offset (0x29), 
                    OP29,   8, 
                            Offset (0x30), 
                    ACTR,   8, 
                            Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IOH2,   8, 
                    IOL2,   8, 
                            Offset (0x70), 
                    INTR,   8, 
                            Offset (0x74), 
                    DMCH,   8, 
                            Offset (0xC0), 
                    OPC0,   8, 
                    OPC1,   8, 
                    OPC2,   8, 
                    OPC3,   8, 
                            Offset (0xF0), 
                    OPT0,   8, 
                    OPT1,   8, 
                    OPT2,   8, 
                    OPT3,   8, 
                    OPT4,   8, 
                            Offset (0xF8), 
                    OPF8,   8, 
                    OPF9,   8, 
                    OPFA,   8, 
                    OPFB,   8
                }

                Method (PS2K._PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x01, KBFG)
                    }
                    Else
                    {
                        Store (0x00, KBFG)
                    }
                }

                Method (PS2M._PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x01, MSFG)
                    }
                    Else
                    {
                        Store (0x00, MSFG)
                    }
                }

                Method (CGLD, 1, NotSerialized)
                {
                    Return (DerefOf (Index (DCAT, Arg0)))
                }

                Method (DSTA, 1, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    Store (ACTR, Local0)
                    EXFG ()
                    If (LEqual (Local0, 0xFF))
                    {
                        Return (0x00)
                    }

                    And (Local0, 0x01, Local0)
                    Or (IOST, ShiftLeft (Local0, Arg0), IOST)
                    If (Local0)
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        If (And (ShiftLeft (0x01, Arg0), IOST))
                        {
                            Return (0x0D)
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }
                }

                Method (DCNT, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, Local1)
                    Or (IOAL, Local1, Local1)
                    RRIO (Arg0, Arg1, Local1, 0x08)
                    If (LAnd (LLess (DMCH, 0x04), LNotEqual (And (DMCH, 0x03, 
                        Local1), 0x00)))
                    {
                        RDMA (Arg0, Arg1, Increment (Local1))
                    }

                    Store (Arg1, ACTR)
                    EXFG ()
                }

                Name (CRS1, ResourceTemplate ()
                {
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y1A)
                    IRQNoFlags (_Y18)
                        {}
                    DMA (Compatibility, NotBusMaster, Transfer8, _Y19)
                        {}
                })
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y18._INT, IRQM)
                CreateByteField (CRS1, \_SB.PCI0.SBRG._Y19._DMA, DMAM)
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y1A._MIN, IO11)
                CreateWordField (CRS1, \_SB.PCI0.SBRG._Y1A._MAX, IO12)
                CreateByteField (CRS1, \_SB.PCI0.SBRG._Y1A._LEN, LEN1)
                Name (CRS2, ResourceTemplate ()
                {
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y1D)
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x00,               // Length
                        _Y1E)
                    IRQNoFlags (_Y1B)
                        {6}
                    DMA (Compatibility, NotBusMaster, Transfer8, _Y1C)
                        {2}
                })
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y1B._INT, IRQE)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y1C._DMA, DMAE)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y1D._MIN, IO21)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y1D._MAX, IO22)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y1D._LEN, LEN2)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y1E._MIN, IO31)
                CreateWordField (CRS2, \_SB.PCI0.SBRG._Y1E._MAX, IO32)
                CreateByteField (CRS2, \_SB.PCI0.SBRG._Y1E._LEN, LEN3)
                Method (DCRS, 2, NotSerialized)
                {
                    ENFG (CGLD (Arg0))
                    ShiftLeft (IOAH, 0x08, IO11)
                    Or (IOAL, IO11, IO11)
                    Store (IO11, IO12)
                    Subtract (FindSetRightBit (IO11), 0x01, Local0)
                    ShiftLeft (0x01, Local0, LEN1)
                    If (INTR)
                    {
                        ShiftLeft (0x01, INTR, IRQM)
                    }
                    Else
                    {
                        Store (0x00, IRQM)
                    }

                    If (LOr (LGreater (DMCH, 0x03), LEqual (Arg1, 0x00)))
                    {
                        Store (0x00, DMAM)
                    }
                    Else
                    {
                        And (DMCH, 0x03, Local1)
                        ShiftLeft (0x01, Local1, DMAM)
                    }

                    EXFG ()
                    Return (CRS1)
                }

                Method (DSRS, 2, NotSerialized)
                {
                    CreateWordField (Arg0, 0x09, IRQM)
                    CreateByteField (Arg0, 0x0C, DMAM)
                    CreateWordField (Arg0, 0x02, IO11)
                    ENFG (CGLD (Arg1))
                    And (IO11, 0xFF, IOAL)
                    ShiftRight (IO11, 0x08, IOAH)
                    If (IRQM)
                    {
                        FindSetRightBit (IRQM, Local0)
                        Subtract (Local0, 0x01, INTR)
                    }
                    Else
                    {
                        Store (0x00, INTR)
                    }

                    If (DMAM)
                    {
                        FindSetRightBit (DMAM, Local0)
                        Subtract (Local0, 0x01, DMCH)
                    }
                    Else
                    {
                        Store (0x04, DMCH)
                    }

                    EXFG ()
                    DCNT (Arg1, 0x01)
                }

                OperationRegion (GPIO, SystemIO, IO1B, 0x04)
                Field (GPIO, ByteAcc, NoLock, Preserve)
                {
                    GP10,   1, 
                    GP11,   1, 
                    GP12,   1, 
                    GP13,   1, 
                    GO14,   1, 
                    GO15,   1, 
                    GO16,   1, 
                    GO17,   1, 
                    GP20,   1, 
                    GP21,   1, 
                    GP22,   1, 
                    GP23,   1, 
                    GO24,   1, 
                    GO25,   1, 
                    GO26,   1, 
                    GO27,   1, 
                    GP30,   1, 
                    GP31,   1, 
                    GP32,   1, 
                    GP33,   1, 
                    GO34,   1, 
                    GO35,   1, 
                    GO36,   1, 
                    GO37,   1, 
                    GP40,   1, 
                    GP41,   1, 
                    GP42,   1, 
                    GP43,   1, 
                    GO44,   1, 
                    GO45,   1, 
                    GO46,   1, 
                    GO47,   1
                }

                Scope (\)
                {
                    Method (LVVB, 0, NotSerialized)
                    {
                        ISMI (0x72)
                    }

                    Method (LNVB, 0, NotSerialized)
                    {
                        ISMI (0x73)
                    }
                }

                Device (UAR1)
                {
                    Name (_UID, 0x01)
                    Name (_HID, EisaId ("PNP0501"))
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (DSTA (0x00))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x00, 0x00)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (DCRS (0x00, 0x00))
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        DSRS (Arg0, 0x00)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        Return (CMPR)
                    }

                    Name (CMPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                }

                Method (UAR1._PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x03, 0x04))
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x00020000)
                Name (_S1D, 0x01)
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), 0x01), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x00020001)
                Name (_S1D, 0x01)
                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), 0x01), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x05, 0x03))
                }
            }

            Device (IDE0)
            {
                Name (_ADR, 0x00060000)
                Name (PTS0, 0x00)
                Name (SID0, 0x00)
                Name (SID1, 0x00)
                Name (SID2, 0x00)
                Name (SID3, 0x00)
                Name (SID4, 0x00)
                Name (SID5, 0x00)
                Name (\FZTF, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
                OperationRegion (IRQM, SystemIO, 0x21, 0x01)
                Field (IRQM, ByteAcc, NoLock, Preserve)
                {
                    IR0M,   1
                }

                Name (REGF, 0x01)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                OperationRegion (A090, PCI_Config, 0x50, 0x18)
                Field (A090, DWordAcc, NoLock, Preserve)
                {
                    ID20,   16, 
                            Offset (0x08), 
                    IDTS,   16, 
                    IDTP,   16, 
                    ID22,   32, 
                    UMSS,   16, 
                    UMSP,   16
                }

                Name (TIM0, Package (0x07)
                {
                    Package (0x05)
                    {
                        0x3C, 
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x05)
                    {
                        0x11, 
                        0x20, 
                        0x22, 
                        0x47, 
                        0xA8
                    }, 

                    Package (0x07)
                    {
                        0x78, 
                        0x5A, 
                        0x3C, 
                        0x2D, 
                        0x1E, 
                        0x14, 
                        0x0F
                    }, 

                    Package (0x05)
                    {
                        0x05, 
                        0x04, 
                        0x03, 
                        0x02, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        0x01, 
                        0x00, 
                        0x00
                    }, 

                    Package (0x08)
                    {
                        0x02, 
                        0x01, 
                        0x00, 
                        0x00, 
                        0x03, 
                        0x04, 
                        0x05, 
                        0x06
                    }, 

                    Package (0x07)
                    {
                        0x02, 
                        0x01, 
                        0x00, 
                        0x04, 
                        0x05, 
                        0x06, 
                        0x07
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, 0x00, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x58, 0x0C)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    SSPT,   8, 
                    SMPT,   8, 
                    PSPT,   8, 
                    PMPT,   8, 
                    SSAS,   2, 
                    SMAS,   2, 
                    PSAS,   2, 
                    PMAS,   2, 
                            Offset (0x06), 
                    SDDR,   4, 
                    SDDA,   4, 
                    PDDR,   4, 
                    PDDA,   4, 
                    SSUT,   3, 
                        ,   3, 
                    SSUE,   2, 
                    SMUT,   3, 
                        ,   3, 
                    SMUE,   2, 
                    PSUT,   3, 
                        ,   3, 
                    PSUE,   2, 
                    PMUT,   3, 
                        ,   3, 
                    PMUE,   2
                }

                Name (GMPT, 0x00)
                Name (GMUE, 0x00)
                Name (GMUT, 0x00)
                Name (GSPT, 0x00)
                Name (GSUE, 0x00)
                Name (GSUT, 0x00)
                Device (CHN0)
                {
                    Name (_ADR, 0x00)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Store ("GTM_CHN0", Debug)
                        Return (GTM (PMPT, PMUE, PMUT, PSPT, PSUE, PSUT))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store ("STM_CHN0", Debug)
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (PMPT, GMPT)
                        Store (PMUE, GMUE)
                        Store (PMUT, GMUT)
                        Store (PSPT, GSPT)
                        Store (PSUE, GSUE)
                        Store (PSUT, GSUT)
                        STM ()
                        Store (GMPT, PMPT)
                        Store (GMUE, PMUE)
                        Store (GMUT, PMUT)
                        Store (GSPT, PSPT)
                        Store (GSUE, PSUE)
                        Store (GSUT, PSUT)
                        Store (GTF (0x00, Arg1), ATA0)
                        Store (GTF (0x01, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Store ("_GTF_CHN0_DRV0", Debug)
                            Return (Concatenate (RATA (ATA0), FZTF))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, 0x01)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Store ("_GTF_CHN0_DRV1", Debug)
                            Return (Concatenate (RATA (ATA1), FZTF))
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    ShiftRight (CPB0, 0x04, Local1)
                    And (Local1, 0x0F, Local0)
                    Return (Local0)
                }

                Method (GTM, 6, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (LEqual (PTS0, 0x01))
                    {
                        If (OSFL ())
                        {
                            Store (0x01, IR0M)
                        }
                    }

                    Store (Match (DerefOf (Index (TIM0, 0x01)), MEQ, Arg0, MTR, 
                        0x00, 0x00), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x00)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    Store (Match (DerefOf (Index (TIM0, 0x01)), MEQ, Arg3, MTR, 
                        0x00, 0x00), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x00)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (Arg1)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x05)), Arg2)), 
                            Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local5)), 
                            DMA0)
                        Or (CHNF, 0x01, CHNF)
                    }

                    If (Arg4)
                    {
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x05)), Arg5)), 
                            Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF) {}
                    Else
                    {
                        Return (0x00)
                    }

                    If (PTS0)
                    {
                        Store (SID0, ID20)
                        Store (SID1, IDTS)
                        Store (SID2, IDTP)
                        Store (SID3, ID22)
                        Store (SID4, UMSS)
                        Store (SID5, UMSP)
                    }
                    Else
                    {
                        Store (ID20, SID0)
                        Store (IDTS, SID1)
                        Store (IDTP, SID2)
                        Store (ID22, SID3)
                        Store (UMSS, SID4)
                        Store (UMSP, SID5)
                    }

                    Store (0x00, PTS0)
                    Store (0x00, GMUE)
                    Store (0x00, GMUT)
                    Store (0x00, GSUE)
                    Store (0x00, GSUT)
                    If (And (CHNF, 0x01))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x02)), MLE, DMA0, MTR, 
                            0x00, 0x00), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0)), 
                            GMUT)
                        Or (GMUE, 0x03, GMUE)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO0, Ones), LEqual (PIO0, 0x00)))
                        {
                            If (And (LLess (DMA0, Ones), LGreater (DMA0, 0x00)))
                            {
                                Store (DMA0, PIO0)
                            }
                        }
                    }

                    If (And (CHNF, 0x04))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x02)), MLE, DMA1, MTR, 
                            0x00, 0x00), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0)), 
                            GSUT)
                        Or (GSUE, 0x03, GSUE)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO1, Ones), LEqual (PIO1, 0x00)))
                        {
                            If (And (LLess (DMA1, Ones), LGreater (DMA1, 0x00)))
                            {
                                Store (DMA1, PIO1)
                            }
                        }
                    }

                    And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIO0, MTR, 
                        0x00, 0x00), 0x07, Local0)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x01)), Local0)), 
                        Local1)
                    Store (Local1, GMPT)
                    And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIO1, MTR, 
                        0x00, 0x00), 0x07, Local0)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, 0x01)), Local0)), 
                        Local1)
                    Store (Local1, GSPT)
                    Return (0x00)
                }

                Name (AT01, Buffer (0x07)
                {
                    /* 0000 */    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, 0x00, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store ("GTF_Entry", Debug)
                    Store (Arg1, Debug)
                    Store (0x00, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, 0x00)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, 0x01)
                    Name (PIOT, 0x00)
                    Name (DMAT, 0x00)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, 0x01))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x02)), MLE, DMAT, MTR, 
                            0x00, 0x00), Local1)
                        If (LGreater (Local1, 0x06))
                        {
                            Store (0x06, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIOT, MTR, 
                                0x00, 0x00), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, 0x00)), MGE, PIOT, MTR, 
                            0x00, 0x00), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, 0x01, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store ("ATAB_GTF", Debug)
                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, 0x00, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (RETB)
                }
            }

            Device (P0P1)
            {
                Name (_ADR, 0x00040000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x00, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR01)
                    }

                    Return (PR01)
                }
            }

            Device (HDAC)
            {
                Name (_ADR, 0x00050000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x15, 0x04))
                }
            }

            Device (P0P2)
            {
                Name (_ADR, 0x00090000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x11, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR02)
                    }

                    Return (PR02)
                }
            }

            Device (BR11)
            {
                Name (_ADR, 0x000B0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x11, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR11)
                    }

                    Return (PR11)
                }
            }

            Device (BR12)
            {
                Name (_ADR, 0x000C0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x11, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR12)
                    }

                    Return (PR12)
                }
            }

            Device (NMAC)
            {
                Name (_ADR, 0x00070000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (NSMB)
            {
                Name (_ADR, 0x00010001)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }

            Device (ATA0)
            {
                Name (_ADR, 0x00080000)
                Device (PRI0)
                {
                    Name (_ADR, 0x00)
                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */    0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
                        /* 0008 */    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
                        /* 0010 */    0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (SPTM)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, SPTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            If (SSEN)
                            {
                                Store (SSEP, SMIP)
                            }

                            Store (Buffer (0x07)
                                {
                                    /* 0000 */    0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Concatenate (Local0, FZTF))
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)
                    Name (SSTM, Buffer (0x14)
                    {
                        /* 0000 */    0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
                        /* 0008 */    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
                        /* 0010 */    0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (SSTM)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, SSTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            If (SSEN)
                            {
                                Store (SSEP, SMIP)
                            }

                            Store (Buffer (0x07)
                                {
                                    /* 0000 */    0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Concatenate (Local0, FZTF))
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Store (0x0C, Local0)
                    If (LEqual (_ADR, 0x00100001))
                    {
                        Store (0x0C, Local0)
                    }

                    If (LEqual (_ADR, 0x00080001))
                    {
                        Store (0x0C, Local0)
                    }

                    If (LEqual (_ADR, 0x00100000))
                    {
                        Store (0x08, Local0)
                    }

                    If (LEqual (_ADR, 0x00080000))
                    {
                        Store (0x08, Local0)
                    }

                    ShiftRight (CPB0, Local0, Local1)
                    And (Local1, 0x0F, Local0)
                    Return (Local0)
                }
            }

            Device (ATA1)
            {
                Name (_ADR, 0x00080001)
                Device (PRI0)
                {
                    Name (_ADR, 0x00)
                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */    0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
                        /* 0008 */    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
                        /* 0010 */    0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (SPTM)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, SPTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            If (SSEN)
                            {
                                Store (SSEP, SMIP)
                            }

                            Store (Buffer (0x07)
                                {
                                    /* 0000 */    0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Concatenate (Local0, FZTF))
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)
                    Name (SSTM, Buffer (0x14)
                    {
                        /* 0000 */    0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
                        /* 0008 */    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
                        /* 0010 */    0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (SSTM)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, SSTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            If (SSEN)
                            {
                                Store (SSEP, SMIP)
                            }

                            Store (Buffer (0x07)
                                {
                                    /* 0000 */    0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Concatenate (Local0, FZTF))
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Store (0x0C, Local0)
                    If (LEqual (_ADR, 0x00100001))
                    {
                        Store (0x0C, Local0)
                    }

                    If (LEqual (_ADR, 0x00080001))
                    {
                        Store (0x0C, Local0)
                    }

                    If (LEqual (_ADR, 0x00100000))
                    {
                        Store (0x08, Local0)
                    }

                    If (LEqual (_ADR, 0x00080000))
                    {
                        Store (0x08, Local0)
                    }

                    ShiftRight (CPB0, Local0, Local1)
                    And (Local1, 0x0F, Local0)
                    Return (Local0)
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L10, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L03, 0, NotSerialized)
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L0D, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB0, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L05, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L00, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L15, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.HDAC, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L11, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P2, 0x02)
                Notify (\_SB.PCI0.BR11, 0x02)
                Notify (\_SB.PCI0.BR12, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0B, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.NMAC, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L09, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.NSMB, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
            Method (_PRW, 0, NotSerialized)
            {
                Return (GPRW (0x10, 0x04))
            }
        }
    }

    OperationRegion (\_SB.PCI0.SBRG.PIMC, PCI_Config, 0x7C, 0x0C)
    Field (\_SB.PCI0.SBRG.PIMC, ByteAcc, NoLock, Preserve)
    {
        PIRA,   4, 
        PIRB,   4, 
        PIRC,   4, 
        PIRD,   4, 
        PREA,   4, 
        PREB,   4, 
        PREC,   4, 
        PRED,   4, 
            ,   4, 
                Offset (0x05), 
        PIRM,   4, 
        PIU2,   4, 
            ,   4, 
        PMUD,   4, 
        SIID,   4, 
        PIID,   4, 
        PIU0,   4, 
        PIU1,   4, 
        PILN,   4, 
        PAZA,   4, 
        PAUI,   4, 
        PIMO,   4, 
        PR0E,   4
    }

    Scope (\_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, _Y1F)
                {15}
        })
        CreateWordField (BUFA, \_SB._Y1F._INT, ICRS)
        Method (LSTA, 1, NotSerialized)
        {
            If (Arg0)
            {
                Return (0x0B)
            }
            Else
            {
                Return (0x09)
            }
        }

        Method (LPRS, 2, NotSerialized)
        {
            If (PICM)
            {
                Return (Arg1)
            }
            Else
            {
                Return (Arg0)
            }
        }

        Method (LCRS, 1, NotSerialized)
        {
            If (PICM)
            {
                Name (BUFB, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, _Y20)
                    {
                        0x00000011,
                    }
                })
                CreateByteField (BUFB, \_SB.LCRS._Y20._INT, AIRQ)
                Store (Arg0, AIRQ)
                If (LEqual (Arg0, 0x01))
                {
                    Store (0x17, AIRQ)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x16, AIRQ)
                }

                If (LEqual (Arg0, 0x03))
                {
                    Store (0x10, AIRQ)
                }

                If (LEqual (Arg0, 0x04))
                {
                    Store (0x11, AIRQ)
                }

                If (LEqual (Arg0, 0x06))
                {
                    Store (0x12, AIRQ)
                }

                If (LEqual (Arg0, 0x08))
                {
                    Store (0x14, AIRQ)
                }

                If (LEqual (Arg0, 0x0C))
                {
                    Store (0x13, AIRQ)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x15, AIRQ)
                }

                Return (BUFB)
            }
            Else
            {
                ShiftLeft (0x01, Arg0, ICRS)
                Return (BUFA)
            }
        }

        Method (LCRO, 1, NotSerialized)
        {
            If (PICM)
            {
                Name (BUFB, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, _Y21)
                    {
                        0x00000014,
                    }
                })
                CreateByteField (BUFB, \_SB.LCRO._Y21._INT, AIRQ)
                Store (Arg0, AIRQ)
                If (LEqual (Arg0, 0x01))
                {
                    Store (0x17, AIRQ)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x16, AIRQ)
                }

                If (LEqual (Arg0, 0x03))
                {
                    Store (0x10, AIRQ)
                }

                If (LEqual (Arg0, 0x04))
                {
                    Store (0x11, AIRQ)
                }

                If (LEqual (Arg0, 0x06))
                {
                    Store (0x12, AIRQ)
                }

                If (LEqual (Arg0, 0x08))
                {
                    Store (0x14, AIRQ)
                }

                If (LEqual (Arg0, 0x0C))
                {
                    Store (0x13, AIRQ)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x15, AIRQ)
                }

                Return (BUFB)
            }
            Else
            {
                ShiftLeft (0x01, Arg0, ICRS)
                Return (BUFA)
            }
        }

        Method (LSRS, 1, NotSerialized)
        {
            If (PICM)
            {
                CreateByteField (Arg0, 0x05, SAIR)
                Store (SAIR, Local0)
                If (LEqual (Local0, 0x17))
                {
                    Store (0x01, Local0)
                }

                If (LEqual (Local0, 0x16))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (Local0, 0x10))
                {
                    Store (0x03, Local0)
                }

                If (LEqual (Local0, 0x11))
                {
                    Store (0x04, Local0)
                }

                If (LEqual (Local0, 0x12))
                {
                    Store (0x06, Local0)
                }

                If (LEqual (Local0, 0x14))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (Local0, 0x13))
                {
                    Store (0x0C, Local0)
                }

                If (LEqual (Local0, 0x15))
                {
                    Store (0x0D, Local0)
                }

                Return (Local0)
            }
            Else
            {
                CreateWordField (Arg0, 0x01, ISRS)
                FindSetRightBit (ISRS, Local0)
                Return (Decrement (Local0))
            }
        }

        Method (LSRO, 1, NotSerialized)
        {
            If (PICM)
            {
                CreateByteField (Arg0, 0x05, SAIR)
                Store (SAIR, Local0)
                If (LEqual (Local0, 0x14))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (Local0, 0x15))
                {
                    Store (0x0D, Local0)
                }

                If (LEqual (Local0, 0x16))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (Local0, 0x17))
                {
                    Store (0x01, Local0)
                }

                Return (Local0)
            }
            Else
            {
                CreateWordField (Arg0, 0x01, ISRS)
                FindSetRightBit (ISRS, Local0)
                Return (Decrement (Local0))
            }
        }

        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x01)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIRA))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSA, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PIRA))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIRB))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSB, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PIRB))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIRC))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSC, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PIRC))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIRD))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSD, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PIRD))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PIRD)
            }
        }

        Device (LNEA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PREA))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSA, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PREA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PREA))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PREA)
            }
        }

        Device (LNEB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x06)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PREB))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSB, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PREB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PREB))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PREB)
            }
        }

        Device (LNEC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PREC))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSC, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PREC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PREC))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PREC)
            }
        }

        Device (LNED)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PRED))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (PRSD, RSIR))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PRED)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRS (PRED))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRS (Arg0), PRED)
            }
        }

        Device (LUB0)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x09)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIU0))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSB0, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIU0)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PIU0))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PIU0)
            }
        }

        Device (LUB2)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x0A)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIU2))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSB2, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIU2)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PIU2))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PIU2)
            }
        }

        Device (LMAC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x0B)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PILN))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSAC, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PILN)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PILN))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PILN)
            }
        }

        Device (LAZA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x0C)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PAZA))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSZA, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PAZA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PAZA))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PAZA)
            }
        }

        Device (LACI)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x0D)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PAUI))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSCI, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PAUI)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PAUI))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PAUI)
            }
        }

        Device (LMC9)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x0E)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIMO))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSC9, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIMO)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PIMO))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PIMO)
            }
        }

        Device (LSMB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x0F)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIRM))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSMB, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIRM)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PIRM))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PIRM)
            }
        }

        Device (LPMU)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x10)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PMUD))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSMU, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PMUD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PMUD))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PMUD)
            }
        }

        Device (LSA0)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x11)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PIID))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSA0, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PIID)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (PIID))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), Local0)
                Store (Local0, PIID)
            }
        }

        Device (LSA1)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x12)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (SIID))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSA1, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, SIID)
            }

            Method (_CRS, 0, NotSerialized)
            {
                Return (LCRO (SIID))
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), Local0)
                Store (Local0, SIID)
            }
        }

        Device (LATA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x13)
            Method (_STA, 0, NotSerialized)
            {
                Return (LSTA (PR0E))
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (LPRS (RSTA, RSII))
            }

            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, PR0E)
            }

            Method (_CRS, 0, NotSerialized)
            {
                If (OSFL ())
                {
                    Return (0x00)
                }
                Else
                {
                    Return (LCRO (PR0E))
                }
            }

            Method (_SRS, 1, NotSerialized)
            {
                Store (LSRO (Arg0), PR0E)
            }
        }
    }

    Scope (\_SB)
    {
        Name (XCPD, 0x00)
        Name (XNPT, 0x01)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x01)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x0FFF)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x01)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, \PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }

        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (\_SB.RDPE (Local0), Local1)
            If (LEqual (Local1, 0xFFFFFFFF))
            {
                Return (0x00)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    \_SB.WDPE (Local0, And (Local1, 0x00010000))
                    Return (0x01)
                }

                Return (0x00)
            }
        }
    }

    Scope (\_SB.PCI0.SBRG.SIOR)
    {
        Method (HWV0, 0, NotSerialized)
        {
            Return (Multiply (VIV0, 0x10))
        }

        Method (HWV1, 0, NotSerialized)
        {
            Return (Multiply (VIV1, 0x10))
        }

        Method (HWV2, 0, NotSerialized)
        {
            Return (Multiply (VIV2, 0x10))
        }

        Method (HWV3, 0, NotSerialized)
        {
            Return (Multiply (VIV3, 0x10))
        }

        Method (HWV4, 0, NotSerialized)
        {
            Return (Multiply (VIV4, 0x10))
        }

        Method (HWV5, 0, NotSerialized)
        {
            Return (Multiply (VIV5, 0x10))
        }

        Method (HWV6, 0, NotSerialized)
        {
            Return (Multiply (VIV6, 0x10))
        }

        Method (HWV7, 0, NotSerialized)
        {
            Return (Multiply (VIV7, 0x10))
        }

        Method (HWT1, 0, NotSerialized)
        {
            Store (TPI1, Local0)
            If (LGreater (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
            }

            Return (Multiply (Local0, 0x0A))
        }

        Method (HWT2, 0, NotSerialized)
        {
            Store (TPI2, Local0)
            Subtract (Local0, 0x07, Local0)
            If (LGreater (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
            }

            Return (Multiply (Local0, 0x0A))
        }

        Method (HWT3, 0, NotSerialized)
        {
            Store (TPI3, Local0)
            If (LGreater (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
            }

            Return (Multiply (Local0, 0x0A))
        }

        Method (HWF1, 0, NotSerialized)
        {
            If (LEqual (ETD1, 0x01))
            {
                Or (ShiftLeft (EFN1, 0x08), FTC1, Local0)
                Return (CF16 (Local0))
            }

            Store (FTC1, Local0)
            Store (0x01, Local2)
            While (LAnd (LOr (LLessEqual (Local0, FHMT), LGreaterEqual (Local0, 
                FLMT)), LEqual (Local2, 0x01)))
            {
                If (LLessEqual (Local0, FHMT))
                {
                    Store (FTD1, Local1)
                    If (LGreater (Local1, 0x00))
                    {
                        Decrement (Local1)
                        Store (Local1, FTD1)
                    }
                    Else
                    {
                        Store (0x00, Local2)
                    }
                }
                Else
                {
                    Store (FTD1, Local1)
                    If (LLess (Local1, 0x07))
                    {
                        Increment (Local1)
                        Store (Local1, FTD1)
                    }
                    Else
                    {
                        Store (0x00, Local2)
                    }
                }

                Sleep (0x012C)
                Store (FTC1, Local0)
            }

            Return (CF08 (Local0, DerefOf (Index (DTB1, FTD1))))
        }

        Method (HWF2, 0, NotSerialized)
        {
            If (LEqual (ETD2, 0x01))
            {
                Or (ShiftLeft (EFN2, 0x08), FTC2, Local0)
                Return (CF16 (Local0))
            }

            Store (FTC2, Local0)
            Store (0x01, Local2)
            While (LAnd (LOr (LLessEqual (Local0, FHMT), LGreaterEqual (Local0, 
                FLMT)), LEqual (Local2, 0x01)))
            {
                If (LLessEqual (Local0, FHMT))
                {
                    Store (FTD2, Local1)
                    If (LGreater (Local1, 0x00))
                    {
                        Decrement (Local1)
                        Store (Local1, FTD2)
                    }
                    Else
                    {
                        Store (0x00, Local2)
                    }
                }
                Else
                {
                    Store (FTD2, Local1)
                    If (LLess (Local1, 0x07))
                    {
                        Increment (Local1)
                        Store (Local1, FTD2)
                    }
                    Else
                    {
                        Store (0x00, Local2)
                    }
                }

                Sleep (0x012C)
                Store (FTC2, Local0)
            }

            Return (CF08 (Local0, DerefOf (Index (DTB1, FTD2))))
        }

        Method (HWF3, 0, NotSerialized)
        {
            If (LEqual (ETD3, 0x01))
            {
                Or (ShiftLeft (EFN3, 0x08), FTC3, Local0)
                Return (CF16 (Local0))
            }

            Store (FTC3, Local0)
            If (LLessEqual (Local0, FHM3))
            {
                Store (FTD3, Local1)
                If (LGreater (Local1, 0x00))
                {
                    Decrement (Local1)
                    Store (Local1, FTD3)
                    Sleep (0x012C)
                    Store (FTC3, Local0)
                }
            }
            Else
            {
                If (LGreaterEqual (Local0, FLMT))
                {
                    Store (FTD3, Local1)
                    If (LLess (Local1, 0x01))
                    {
                        Increment (Local1)
                        Store (Local1, FTD3)
                        Sleep (0x012C)
                        Store (FTC3, Local0)
                    }
                }
            }

            Return (CF08 (Local0, DerefOf (Index (DTB1, FTD3))))
        }

        Method (HWF4, 0, NotSerialized)
        {
            Or (ShiftLeft (EFN4, 0x08), FTC4, Local0)
            Return (CF16 (Local0))
        }

        Method (HWF5, 0, NotSerialized)
        {
            Or (ShiftLeft (EFN5, 0x08), FTC5, Local0)
            Return (CF16 (Local0))
        }

        Method (CF08, 2, NotSerialized)
        {
            If (LOr (LEqual (Arg0, 0x00), LEqual (Arg0, 0xFF)))
            {
                Return (0x00)
            }

            Divide (FTFR, Multiply (Arg0, Arg1), , Local0)
            Return (Local0)
        }

        Method (CF16, 1, NotSerialized)
        {
            If (LOr (LEqual (Arg0, 0x00), LEqual (Arg0, 0xFFFF)))
            {
                Return (0x00)
            }

            Divide (FTFR, Multiply (Arg0, 0x02), , Local0)
            Return (Local0)
        }

        Name (FTFR, 0x00149970)
        Name (FHMT, 0x78)
        Name (FHM3, 0x3C)
        Name (FLMT, 0xFE)
        Name (DTB1, Package (0x08)
        {
            0x01, 
            0x02, 
            0x04, 
            0x08, 
            0x10, 
            0x20, 
            0x40, 
            0x80
        })
        Name (DTB2, Package (0x02)
        {
            0x02, 
            0x08
        })
        OperationRegion (ECRE, SystemIO, IOEB, 0x20)
        Field (ECRE, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x05), 
            HIDX,   8, 
            HDAT,   8
        }

        IndexField (HIDX, HDAT, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x0B), 
            FTD1,   3, 
            FTD2,   3, 
            FTD3,   1, 
                    Offset (0x0C), 
            ETD1,   1, 
            ETD2,   1, 
            ETD3,   1, 
                    Offset (0x0D), 
            FTC1,   8, 
            FTC2,   8, 
            FTC3,   8, 
                    Offset (0x18), 
            EFN1,   8, 
            EFN2,   8, 
            EFN3,   8, 
                    Offset (0x20), 
            VIV0,   8, 
            VIV1,   8, 
            VIV2,   8, 
            VIV3,   8, 
            VIV4,   8, 
            VIV5,   8, 
            VIV6,   8, 
            VIV7,   8, 
                    Offset (0x29), 
            TPI1,   8, 
            TPI2,   8, 
            TPI3,   8, 
                    Offset (0x80), 
            FTC4,   8, 
            EFN4,   8, 
            FTC5,   8, 
            EFN5,   8
        }
    }

    Scope (\)
    {
        Field (\RAMW, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x20), 
            CPUQ,   8, 
            CPVL,   16, 
            CPVH,   16, 
            CPVC,   1
        }
    }

    Scope (\_SB.PCI0.SBRG.ASOC)
    {
        Name (CORV, Package (0x05)
        {
            0x06020000, 
            "Vcore Voltage", 
            0x0352, 
            0x0640, 
            0x01
        })
        Name (V3VV, Package (0x05)
        {
            0x06020001, 
            " +3.3 Voltage", 
            0x0B9A, 
            0x0E2E, 
            0x01
        })
        Name (V5VV, Package (0x05)
        {
            0x06020002, 
            " +5 Voltage", 
            0x1194, 
            0x157C, 
            0x01
        })
        Name (VV12, Package (0x05)
        {
            0x06020003, 
            " +12 Voltage", 
            0x27D8, 
            0x35E8, 
            0x01
        })
        Name (VPAR, Package (0x04)
        {
            Package (0x03)
            {
                0x00, 
                0x01, 
                0x00
            }, 

            Package (0x03)
            {
                0x00, 
                0x01, 
                0x00
            }, 

            Package (0x03)
            {
                0x0A, 
                0x1B, 
                0x00
            }, 

            Package (0x03)
            {
                0x32, 
                0x11, 
                0x00
            }
        })
        Name (VBUF, Package (0x05)
        {
            0x04, 
            CORV, 
            V3VV, 
            V5VV, 
            VV12
        })
        Method (VGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x00))
            {
                Return (^^SIOR.HWV0 ())
            }

            If (LEqual (Arg0, 0x01))
            {
                Return (^^SIOR.HWV2 ())
            }

            If (LEqual (Arg0, 0x02))
            {
                Return (^^SIOR.HWV5 ())
            }

            If (LEqual (Arg0, 0x03))
            {
                Return (^^SIOR.HWV4 ())
            }
        }

        Name (CPUT, Package (0x05)
        {
            0x06030000, 
            "CPU Temperature", 
            0x0258, 
            0x03B6, 
            0x00010001
        })
        Name (MBTP, Package (0x05)
        {
            0x06030001, 
            "MB Temperature", 
            0x01C2, 
            0x03B6, 
            0x00010001
        })
        Name (TBUF, Package (0x03)
        {
            0x02, 
            CPUT, 
            MBTP
        })
        Method (TGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x00))
            {
                Return (^^SIOR.HWT1 ())
            }

            If (LEqual (Arg0, 0x01))
            {
                Return (^^SIOR.HWT2 ())
            }
        }

        Name (CPUF, Package (0x05)
        {
            0x06040000, 
            "CPU FAN Speed", 
            0x0320, 
            0x1C20, 
            0x00010001
        })
        Name (CHAF, Package (0x05)
        {
            0x06040001, 
            "CHASSIS FAN Speed", 
            0x0320, 
            0x1C20, 
            0x00010001
        })
        Name (PWRF, Package (0x05)
        {
            0x06040002, 
            "POWER FAN Speed", 
            0x0708, 
            0x1C20, 
            0x00010001
        })
        Name (FBUF, Package (0x04)
        {
            0x03, 
            CPUF, 
            CHAF, 
            PWRF
        })
        Method (FGET, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x00))
            {
                Return (^^SIOR.HWF1 ())
            }

            If (LEqual (Arg0, 0x01))
            {
                Return (^^SIOR.HWF3 ())
            }

            If (LEqual (Arg0, 0x02))
            {
                Return (^^SIOR.HWF2 ())
            }
        }

        Name (QCFN, Package (0x06)
        {
            0x04060003, 
            "CPU Q-Fan Control", 
            0x00, 
            0x01, 
            0x02, 
            0x00010000
        })
        Name (QBUF, Package (0x02)
        {
            0x01, 
            QCFN
        })
        Method (VSIF, 0, NotSerialized)
        {
            Return (VBUF)
        }

        Method (RVLT, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (VGET (Local0), Local1)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), 0x00)), 
                Local2)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), 0x01)), 
                Local3)
            Store (DerefOf (Index (DerefOf (Index (VPAR, Local0)), 0x02)), 
                Local4)
            Multiply (Local1, Add (Local2, Local3), Local5)
            Divide (Local5, Local3, , Local5)
            Add (Local5, Local4, Local5)
            Return (Local5)
        }

        Method (SVLT, 1, NotSerialized)
        {
            And (DerefOf (Index (Arg0, 0x00)), 0xFFFF, Local0)
            Store (DerefOf (Index (VBUF, 0x00)), Local1)
            If (LGreaterEqual (Local0, Local1))
            {
                Return (0x00)
            }

            Increment (Local0)
            Store (DerefOf (Index (Arg0, 0x01)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x01))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (VBUF, 
                Local0)), 0x04))
            Return (0x01)
        }

        Method (TSIF, 0, NotSerialized)
        {
            Return (TBUF)
        }

        Method (RTMP, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (TGET (Local0), Local1)
            Return (Local1)
        }

        Method (STMP, 1, NotSerialized)
        {
            Store (And (DerefOf (Index (Arg0, 0x00)), 0xFFFF), Local0)
            Store (DerefOf (Index (TBUF, 0x00)), Local1)
            If (LGreaterEqual (Local0, Local1))
            {
                Return (0x00)
            }

            Increment (Local0)
            Store (DerefOf (Index (Arg0, 0x01)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x01))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (TBUF, 
                Local0)), 0x04))
            Return (0x01)
        }

        Method (FSIF, 0, NotSerialized)
        {
            Return (FBUF)
        }

        Method (RFAN, 1, NotSerialized)
        {
            And (Arg0, 0xFFFF, Local0)
            Store (FGET (Local0), Local1)
            Return (Local1)
        }

        Method (SFAN, 1, NotSerialized)
        {
            And (DerefOf (Index (Arg0, 0x00)), 0xFFFF, Local0)
            Store (DerefOf (Index (FBUF, 0x00)), Local1)
            If (LGreaterEqual (Local0, Local1))
            {
                Return (0x00)
            }

            Increment (Local0)
            Store (DerefOf (Index (Arg0, 0x01)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x01))
            Store (DerefOf (Index (Arg0, 0x02)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x02))
            Store (DerefOf (Index (Arg0, 0x03)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x03))
            Store (DerefOf (Index (Arg0, 0x04)), Index (DerefOf (Index (FBUF, 
                Local0)), 0x04))
            Return (0x01)
        }

        Method (QFIF, 0, NotSerialized)
        {
        }

        Method (GCQV, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x00))
            {
                Return (CPVL)
            }

            If (LEqual (Arg0, 0x01))
            {
                Return (CPVH)
            }

            If (LEqual (Arg0, 0x02))
            {
                Return (CPVC)
            }

            Return (0x00)
        }

        Method (QFST, 1, NotSerialized)
        {
        }
    }

    Scope (\_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, _Y22, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y23, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y22._MIN, MIN5)
            CreateDWordField (CRS, \_SB.PCI0._Y22._MAX, MAX5)
            CreateDWordField (CRS, \_SB.PCI0._Y22._LEN, LEN5)
            CreateDWordField (CRS, \_SB.PCI0._Y23._MIN, MIN6)
            CreateDWordField (CRS, \_SB.PCI0._Y23._MAX, MAX6)
            CreateDWordField (CRS, \_SB.PCI0._Y23._LEN, LEN6)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Return (CRS)
            }
        }
    }

    Name (WOTB, 0x00)
    Name (WSSB, 0x00)
    Name (WAXB, 0x00)
    Method (_PTS, 1, NotSerialized)
    {
        Store (Arg0, DBG8)
        PTS (Arg0)
        Store (0x00, Index (WAKP, 0x00))
        Store (0x00, Index (WAKP, 0x01))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
    }

    Method (_WAK, 1, NotSerialized)
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (RTCS) {}
        Else
        {
            Notify (\_SB.PWRB, 0x02)
        }

        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, 0x00)))
        {
            Store (0x00, Index (WAKP, 0x01))
        }
        Else
        {
            Store (Arg0, Index (WAKP, 0x01))
        }

        Return (WAKP)
    }

    OperationRegion (GPEB, SystemIO, PMBS, 0x80)
    Field (GPEB, ByteAcc, NoLock, Preserve)
    {
            ,   10, 
        RTCS,   1
    }

    Name (\_S0, Package (0x04)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00
    })
    If (SS1)
    {
        Name (\_S1, Package (0x04)
        {
            0x01, 
            0x00, 
            0x00, 
            0x00
        })
    }

    If (SS3)
    {
        Name (\_S3, Package (0x04)
        {
            0x05, 
            0x00, 
            0x00, 
            0x00
        })
    }

    If (SS4)
    {
        Name (\_S4, Package (0x04)
        {
            0x06, 
            0x00, 
            0x00, 
            0x00
        })
    }

    Name (\_S5, Package (0x04)
    {
        0x07, 
        0x00, 
        0x00, 
        0x00
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.SBRG.SIOS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
            \_SB.PCI0.NPTS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.SBRG.SIOW (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
        \_SB.PCI0.NWAK (Arg0)
    }
}

