.. ***************************** Module Header *******************************
..
.. Module Name: xwlaneng.inc
..
.. Wireless LAN Monitor help source include file
.. Requires HyperText/2 package to compile
..
.. Copyright (c) WLan Project 2003
..
.. $Id: xwlaneng.inc,v 1.194 2009-11-13 12:50:03 cla Exp $
..
.. ===========================================================================
..
.. This file is part of the WLan Project and is free software.  You can
.. redistribute it and/or modify it under the terms of the GNU General
.. Public License as published by the Free Software Foundation, in version 2
.. as it comes in the "COPYING" file of the WLan Project CVS tree.
.. This program is distributed in the hope that it will be useful, but WITHOUT
.. ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
.. FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
.. for more details.
..
.. ***************************************************************************
.an IDPNL_MAIN
.res 1
.
sta es la ayuda en lnea para el [=TITLE]. Este programa proporciona las
siguientes funcionalidades:
.ul compact
- vigilar el estado de su conexin de red inalmbrica
- permitir el uso de diferentes perfiles de conexin, que se pueden exportar e importar
- configurar opcionalmente la interfaz TCP/IP del dispositivo de red inalmbrica
- [.IDPNL_CONFIGURE_PROFILESCAN bsqueda de conexiones] automtica al inicio
- soporte de [.IDPNL_CONFIGURE_SECURITY cifrado] WEP
- soporte de [.IDPNL_CONFIGURE_SECURITY cifrado] WPA y WPA2 utilizando el
  [http://hostap.epitest.fi agente WPA], para dispositivos de red inalmbrica
  compatibles con [.IDPNL_PREREQUISITES GenMac]
- generacin automtica de claves WEP
- [.IDPNL_HOTSPOT deteccin] de redes inalmbricas pblicas
- ejecucin de [.IDPNL_CONFIGURE_SCRIPT archivos por lotes] al (des)conectar

El [=TITLE] est disponible como herramienta del XCenter y como programa
independiente. Si *XWorkplace* o su versin OEM *EWorkplace* (contenida en
*eComStation v1.1* o mejor) se encuentran instalados, se recomienda utilizarlo como
herramienta del XCenter ya que proporciona mejor integracin con la interfaz de
usuario.

[=TOPICS]
.su 1

.. ################
.include copyright.esp
.. ################

.. ----------------------------------------
.2 Requisitos previos
.. ----------------------------------------
.an IDPNL_PREREQUISITES
.
Para la versin actual del [=TITLE] se necesita:
.ul
- *OS/2 Warp 4* o mejor
- *XWorkplace* o *EWorkplace* (versin OEM incluida en *eComStation*)
- Cliente DHCP ISC (dhclient.exe) en un directorio de la va de acceso PATH. Se puede
  instalar con 'yum install dhcpclient' (http://rpm.netlabs.org/release/00/i386/i386/dhclient-3.1-2.oc00.i386.rpm.
  Puede que http://download.smedley.info/Dhcp-client-preview2.zip tambin funcione, pero no se ha probado).

Para el uso de [.IDPNL_CONFIGURE_SECURITY cifrado WPA y WPA2] con el
[http://hostap.epitest.fi agente WPA], que es parte del paquete [=TITLE],
se necesita:
.ul
- WPA Supplicant 2.0. La versin incluida es del paquete de Paul Smedley http://os2ports.smedley.id.au/index.php?page=wpa-supplicant
  wpa__supplicant.exe debe residir en el directorio donde estn instalados los archivos **.dim de xwlan, normalmente
  \xworkplace\plugins\xcenter\xwlan\ relativo al directorio donde est instalado wlanstat.exe.
- GenMac [=__WPA_GENMAC_MINVERSION_LIT__]
- Biblioteca de ejecucin LibC [=__WPA_REQUIRED_LIBC_VERSION__]
.
  Esta biblioteca est instalada automticamente en eComStation
  [=__WPA_REQUIRED_LIBC_ECSINST__] o mejor.
  Para OS/2 o versiones anteriores de eComStation instale la
  [ftp://ftp.netlabs.org/pub/libc/libc-0.6.5-csd5.zip DLL de apoyo]
  en uno de los directorios de la va de acceso LIBPATH del config.sys
  o desde el repositorio RPM de Netlabs con 'yum install libc'.

.. ----------------------------------------
.2 Instalacin
.. ----------------------------------------
.an IDPNL_INSTALL
.
[=TOPICS]
.su V30 u 1

.. ----------------------------------------
.3 Instalar [=BASETITLE]
.. ----------------------------------------
.an IDPNL_INSTALL_WIDGET
.
El paquete incluye los siguientes archivos
.pl compact break=none tsize=15 bold
- instwgt.cmd
= programa de instalacin como herramienta del XCenter
- instexe.cmd
= instalacin del programa independiente
- setlang.cmd
= programa para [.IDPNL_INSTALL_NLS determinar qu idioma usar]
- readme.cmd
= archivo por lotes para abrir los archivos de ayuda en lnea
- file__id.diz
= archivo de descripcin del paquete
- xcenter\**
= subdirectorio con los archivos de programa, proceso por lotes y ayuda

Descomprima este paquete en un directorio vaco y ejecute bien
*instwgt.cmd*, bien *instexe.cmd* para instalar el [=TITLE]
como herramienta del XCenter y/o como programa independiente.

Si *XWorkplace* o su versin OEM *EWorkplace* (contenida en *eComStation
v1.1* o mejor) se encuentran instalados, se recomienda utilizarlo como
herramienta del XCenter ya que sta se integra mejor con la interfaz
de usuario.

.at fc=red
[=NOTE]
.ul compact
- Se recomienda encarecidamente no establecer valores para la interfaz TCP/IP
  de los dispositivos de red inalmbrica desde el *programa de configuracin
  TCP/IP*, sino utilizar para ello slo el
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP cuaderno de propiedades de los perfiles de conexin].
.at

.. ----------------------------------------
.3 Soporte de idiomas
.. ----------------------------------------
.an IDPNL_INSTALL_NLS
.
Este paquete incluye soporte para los siguientes idiomas:
alemn, espaol, ingls, italiano, neerlands y sueco.

El idioma que se utilizar se elige de acuerdo con el del sistema
operativo. Si el idioma del sistema operativo an no est soportado
por el [=TITLE], se utilizar el ingls como idioma por omisin.

Si el idioma del sistema operativo an no est soportado por el
[=TITLE] o no le resulta conveniente, puede establecer el idioma que
se utilizar mediante el programa *setlang.cmd*. Ejectelo con los
siguientes parmetros:
.pl bold tsize=3
- <sin parmetros>
= muestra el idioma utilizado actualmente
- **
= establece que el [=TITLE] utilice el idioma por omisin (ingls)
- #xxx#
= especifica el identificador del idioma que se usar.
.
 Los identificadores vlidos son: deu eng esp ita nld sve

.. ----------------------------------------
.2 Uso
.. ----------------------------------------
.an IDPNL_USAGE
.
[=TOPICS]
.su V30 u 1

.. ----------------------------------------
.3 Iconos de estado del monitor
.. ----------------------------------------
.an IDPNL_STATUS
.
Estos son los iconos de estado que muestra el
[=TITLE] (dependiendo de la resolucin de pantalla
los smbolos mostrados pueden diferir de los
ilustrados aqu). Estas imgenes se pueden
[.IDPNL_CHANGEBITMAPS sustituir] por otras personalizadas.
.pl break=none tsize=5
-
.bi wlan-nocard.bmp
= no se detecta el adaptador inalmbrico
-
.bi wlan-nodriver.bmp
= no hay instalado un controlador inalmbrico
-
.bi wlan-disabled.bmp
= la antena de radio est inactiva
-
.bi wlan-ipdisabled.bmp
= la interfaz TCP/IP est inactiva
-
.bi wlan-nonet.bmp
= conectado, pero fuera de alcance
-
.bi wlan-searching.bmp
= buscando conexin con el perfil actual
-
.bi wlan-scanning.bmp
= buscando conexin con el perfil actual, cambiando al siguiente perfil
  de conexin (incluido en la bsqueda) despus del intervalo establecido
-
.bi wlan-configuring.bmp
= configurando la interfaz IP
.
 (puede tardar ms usando DHCP)
-
.bi wlan-script.bmp
= ejecutando archivo por lotes al (des)conectar
-
.bi wlan-100.bmp
= conectado, seal del 81 al 100%
-
.bi wlan-80.bmp
= conectado, seal del 61 al 80%
-
.bi wlan-60.bmp
= conectado, seal del 41 al 60%
-
.bi wlan-40.bmp
= conectado, seal del 21 al 40%
-
.bi wlan-20.bmp
= conectado, seal del 1 al 20%
-
.bi wlan-nodataaccess.bmp
= Aceso denegado porque el [=TITLE] ya est activo

.. ----------------------------------------
.3 Acciones del ratn
.. ----------------------------------------
.an IDPNL_MOUSEACTIONS
.
El [=TITLE] soporta las siguientes acciones del ratn:
.ul
- pulsar sobre l con el segundo botn del ratn
  desplegar su men de contexto
- una doble pulsacin del primer botn del ratn sobre
  l ejecutar la accin definida en la pgina
  [.IDPNL_PROPERTIES_PAGEMOUSE] del
  [.IDPNL_PROPERTIES cuaderno de propiedades].
- mover el cursor del ratn sobre l mostrar un texto emergente
  de ayuda, que incluyendo el estado actual y el dispositivo
  inalmbrico seleccionado.
  El dispositivo inalmbrico se puede seleccionar en la
  pgina [.IDPNL_PROPERTIES_PAGEDEVSELECT] del
  [.IDPNL_PROPERTIES cuaderno de propiedades]
  del [=TITLE]

Adems, la ventana del [.IDPNL_EXEOPTIONS programa independiente]
se puede mover con el primer botn del ratn.

.. ----------------------------------------
.3 Propiedades del monitor
.. ----------------------------------------
.an IDPNL_PROPERTIES
.res 100
.
El cuaderno de propiedades del [=TITLE]
contiene las siguientes pginas:
.su 1 H50

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGERADIO]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGERADIO
.res 99
.
Esta pgina del cuaderno de propiedades de [=TITLE]
determina las propiedades de la antena de radio:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_RADIOSTARTUP]
= selecciona la accin llevada a cabo al iniciar el programa
.. ------------------
.pl [=PARMLIST_PARMS]
  - [=IDT_IDSTR_RADIOPROFILE]
  = seleccione esta opcin para que el [=TITLE] active la antena slo si
    ya lo estaba la ltima vez que se concluy el programa. Esto ignora
    una posible desactivacin por la opcin *[=IDT_IDCHB_RADIOSHUTDOWN]*.
  - [=IDT_IDSTR_RADIOON]
  = seleccione esta opcin para que el [=TITLE] siempre active la antena
    de radio durante el inicio del programa
  - [=IDT_IDSTR_RADIOOFF]
  = seleccione esta opcin para que el [=TITLE] siempre desactive la antena
    de radio durante el inicio del programa
.el
.. ------------------
- [=IDT_IDCHB_RADIOSHUTDOWN]
= seleccione esta opcin para desactivar la antena al cerrar el programa
.. ------------------
- [=IDT_IDCHB_RADIOSTOP]
= seleccione esta opcin para desactivar la radio si la conexin se pierde
  o no puede establecerse al iniciar el programa
.. ------------------
- [=IDT_IDTXT_RADIOSTOPWAIT]
= esta propiedad determina cuntos minutos debera esperarse sin conexin
  antes de desactivar la antena

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGESCAN]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGESCAN
.res 101
.
Esta pgina del cuaderno de propiedades del [=TITLE] determina las
siguientes propiedades de conexin para todos los perfiles:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_SCANONSTARTUP]
= seleccione esta opcin si quiere que el [=TITLE] explore sus
  perfiles para establecer una conexin al inicio
- [=IDT_IDCHB_SCANONREINSERT]
= seleccione esta opcin si quiere que el [=TITLE] explore sus
  perfiles para establecer una conexin al (re)conectar un
  dispositivo de red inalmbrica al sistema.
  Esta opcin slo tiene sentido con dispositivos de red inalmbrica
  extrables tales como tarjetas PCMCIA o conectados por USB.
- [=IDT_IDTXT_SCANINTERVAL]
= Esta propiedad determina cuntos segundos debe esperarse para
  establecer conexin durante la [.IDPNL_CONFIGURE_PROFILESCAN bsqueda]
  antes de probar el siguiente perfil de conexin
- [=IDT_IDTXT_SCANRETRIES]
= Esta propiedad determina cuntos intentos hacer al buscar conexiones.
  En cada pase, el [=TITLE] probar cada perfil que tenga establecido el
  atributo *[=IDT_IDCHB_INCLUDEINSCAN]*.

.at fc=red
[=NOTE]
.ul compact
- Para usar las funciones de bsqueda, al menos un perfil de conexin
  debe tener establecido el atributo *[=IDT_IDCHB_INCLUDEINSCAN]*.
.at

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEDEVSELECT]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEDEVSELECT
.res 102
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina el dispositivo que se usar y muestra la versin
del controlador as como sus capacidades:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_DRVSELECT]
= seleccione entre los controladores instalados que
  gestionan los dispositivos de red inalmbrica del
  sistema

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGETCPIP] 1/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGETCPIP
.res 103
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina las propiedades de configuracin de la
interfaz TCP/IP del dispositivo de red inalmbrica:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_TRIGGERWAN]
= seleccione esta opcin para que el [=TITLE], tras la conexin
  inalmbrica, establezca inmediatamente una conexin hasta un
  puerto WAN (Internet) ms all del enrutador de red inalmbrica.
  Esto se hace enviando una solicitud DNS.
.
  As puede establecerse una conexin telefnica/DSL que no se
  establecera antes de que se realizase una primera solicitud
  TCP/IP desde el lado del cliente. Esto slo se recomienda si una
  conexin telefnica/DSL tras el enrutador inalmbrico no va
  a causar cobros adicionales, porque la conexin se cobre slo
  una vez o est cubierta por una tarifa plana.
- [=IDT_IDCHB_EXECSETUP]
= seleccione esta opcin para ejecutar parte de la *configuracin TCP/IP
  de red local* (setup.cmd) al desconectarse de la red inalmbrica.
.
  Esto restablecer la configuracin de las interfaces y rutas TCP/IP
  al estado en que estuvieran al inicio del sistema y es particularmente
  til para
  [.IDPNL_CONFIGURE_SWITCH alternar entre conexiones inalmbricas y por cable].
.
.
  Puesto que la configuracin automatizada de red local normalmente elimina
  la ruta por omisin, puede ser necesario reconfigurar la interfaz TCP/IP
  para reconectar, incluso si el evento de desconexin slo se ha disparado
  al desactivar la antena de radio (normalmente esto slo desactiva la
  interfaz TPC/IP temporalmente y por tanto no requiere volver a configurar).
..
- [=IDT_IDTXT_CONFLRESOLVE]
= seleccione qu hacer cuando haya un conflicto de rango de direcciones TCP/IP
  entre la interfaz inalmbrica y otra(s)
.ul compact
  - [=IDT_IDSTR_CONFLRESOLVE_PROMPT]
  - [=IDT_IDSTR_CONFLRESOLVE_KEEPWLAN]
  - [=IDT_IDSTR_CONFLRESOLVE_KEEPOTHER]
  - [=IDT_IDSTR_CONFLRESOLVE_AUTO]
.el
..
- [=IDT_IDCHB_GATEWAYNAME]
= seleccione esta opcin para que se aada la direccin TCP/IP del enrutador
  inalmbrico al archivo %ETC%\hosts al establecer la conexin.
- [=IDT_IDTXT_GATEWAYNAME]
= introduzca el nombre que se utilizar para aadir la direccin TCP/IP del
  enrutador inalmbrico al archivo %ETC%\hosts.
- [=IDT_IDCHB_SETLLAADDRESS]
= seleccione esta opcin para establecer una direccin LLA (169.254/16) para
  la interfaz TCP/IP de la red inalmbrica al desconectarse.

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGETCPIP2] 2/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGETCPIP2
.res 1031
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina las propiedades de configuracin del
cliente DHCP:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_DHCPCONFIGURE]
= seleccione esta opcin para que el [=TITLE] configure
  el cliente DHCP. Esto reescribe el
  [.IDPNL_CONFIGURE_DHCP archivo de configuracin del cliente DHCP]
  antes de cada solicitud de cesin DHCP
- [=IDT_IDCHB_DHCPRESETCLIENTDB]
= seleccione esta opcin para reiniciar la base de datos del cliente
  DHCP antes de una solicitud de cesin. En algunos casos esto ayuda
  a prevenir problemas cuando no se puede renovar una cesin DHCP y
  slo una nueva solicitud funciona
- [=IDT_IDCHB_DHCPLOG]
= seleccione esta opcin para que el cliente DHCP cree un archivo de
  registro. Normalmente debera elegir esta opcin para que se ejecute
  el cliente DHCP en segundo plano (desconectado de entrada y salida).
  Si prefiere ver mensajes del cliente DHCP en una ventana separada en
  vez de crear un archivo de registro, deje sin marcar esta opcin.
- [=IDT_IDTXT_DHCPLOGFILE]
= seleccione esta opcin para especificar el archivo de registro
- [=IDT_IDCHB_DHCPRESETLOG]
= seleccione esta opcin para reiniciar el archivo de registro antes
  de emitir una nueva solicitud de cesin DHCP
.an IDT_IDCHB_DHCLIENTBEEP
- [=IDT_IDCHB_DHCLIENTBEEP]
= seleccione esta opcin para que se emita un pitido cuando se establezca
  la conexin y para activar la recepcin de seales audibles
  desde el cliente DHCP
.an IDT_IDCHB_DHIFOVERRIDE
- [=IDT_IDCHB_DHIFOVERRIDE]
= seleccione esta opcin para establecer manualmente el nmero de interfaz
  que debera usar dhclient. Puede ser necesario cuando GENMAC devuelve un nmero
  equivocado.
  Se ha observado este fallo de GENMAC con algunas configuraciones con Injoy
  Firewall y el controlador de conmutacin de VirtualPC. Esta opcin puede
  soslayarlo.
.an IDT_IDTXT_DHIFOVERRIDENR
- [=IDT_IDTXT_DHIFOVERRIDENR]
= seleccione esta opcin para establecer manualmente el nmero de interfaz
  que debera usar dhclient. Puede ser necesario cuando GENMAC devuelve un nmero
  equivocado.
  Se ha observado este fallo de GENMAC con algunas configuraciones con Injoy
  Firewall y el controlador de conmutacin de VirtualPC. Esta opcin puede
  soslayarlo.

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEWPASUPP]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEWPASUPP
.res 104
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina las propiedades de configuracin del
agente WPA.
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_WPASHOW]
= seleccione esta opcin para que el [=TITLE] abra o
  vuelva visible una instancia oculta del agente WPA
- [=IDT_IDTXT_WPADEBLEVEL]
= seleccione el nivel de mensajes de salida del
  agente WPA para depuracin
.ul compact
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_MSGDUMP]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_DEBUG]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_INFO]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_WARNING]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_ERROR]
.el

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGESCRIPT]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGESCRIPT
.res 105
.
Esta pgina del cuaderno de propiedades del [=TITLE]
gobierna la automatizacin de tareas desde la
la ventana o herramienta del XCenter del [=TITLE]
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_ENABLESCRIPTS]
= seleccione esta opcin para que el [=TITLE] ejecute
  un archivo de proceso por lotes
  [.IDPNL_CONFIGURE_SCRIPT_CMD CMD] o
  [.IDPNL_CONFIGURE_SCRIPT_REXX REXX] al conectar
  y desconectar (tras configurar o anular la configuracin
  de la interfaz TCP/IP).
  El archivo por lotes debe llamarse [.IDPNL_CONFIGURE_SCRIPT_FILES xwlan.cmd].
- [=IDT_IDTXT_SCRIPTPATH]
= especifica la va de acceso del
  [.IDPNL_CONFIGURE_SCRIPT_FILES archivo por lotes, su entrada y archivo(s) de registro].
  El directorio especificado debe existir; su existencia no se comprueba.
- [=IDT_IDPBS_BROWSE]
= permite seleccionar el directorio del archivo por lotes
- [=IDT_IDPBS_OPEN]
= abre el directorio del archivo por lotes
- [=IDT_IDCHB_WAITFORSCRIPTS]
= seleccione esta opcin para que el [=TITLE] ejecute el archivo por lotes
  y espere a que termine. Se recomienda encarecidamente deseleccionar esta
  opcin slo bajo [.IDPNL_CONFIGURE_SCRIPT_ASYNC circunstancias especficas].
- [=IDT_IDPBS_EDITSCRIPT]
= carga el archivo por lotes en el editor del sistema.
.
  Si el archivo por lotes no existe, este botn permanece desactivado.
- [=IDT_IDPBS_VIEWLOG]
= carga el archivo de registro en el editor del sistema.
.
  Si el archivo de registro no existe, este botn permanece desactivado.

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEMOUSE]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEMOUSE
.res 106
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina la accin de los siguientes eventos de ratn:
.ul compact
- *[=IDT_IDTXT_MB1DBLCLICK]*
- *[=IDT_IDTXT_SMB1DBLCLICK]*
- *[=IDT_IDTXT_CMB1DBLCLICK]*
- *[=IDT_IDTXT_AMB1DBLCLICK]*

Se pueden seleccionar las siguientes acciones:
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_MB1DBL_NEXTPRFSCAN]
= esto permite:
.ul compact
  - cambiar al siguiente perfil de conexin si hay una conexin activa, o bien
  - activar la [.IDPNL_CONFIGURE_PROFILESCAN bsqueda de conexiones], si an no
    se ha podido establecer una conexin con el perfil actual
.el
- [=IDT_IDSTR_MB1DBL_NEXTPRF]
= cambiar al siguiente perfil de conexin.
- [=IDT_IDSTR_MB1DBL_ENABLERADIO]
= activar o desactivar la antena de radio
- [=IDT_IDSTR_MB1DBL_DISABLETCPIP]
= activar o desactivar la interfaz TCP/IP
...
..  Esto es til cuando se quiere alternar entre la interfaz de conexin inalmbrica
..  o una por cable.
- [=IDT_IDSTR_MB1DBL_DLGPROPERTIES]
= abrir el [.IDPNL_PROPERTIES cuaderno de propiedades]
- [=IDT_IDSTR_MB1DBL_DLGHOTSPOTSCAN]
= abrir el [.IDPNL_HOTSPOT_SCAN dilogo de bsqueda]. Este dilogo
  no est disponible para los controladores tipo GenPrism.
- [=IDT_IDSTR_MB1DBL_DLGEDITPROFILE]
= abrir el [.IDPNL_PROFILE dilogo de perfiles]
.el
.at fc=red
[=NOTE]
.ul compact
- Si la antena no est activa, no se puede iniciar la bsqueda de conexiones o
  cambiar entre perfiles con el ratn. En su lugar se produce un pitido de error.
.at fc

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEERROR]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEERROR
.res 107
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina cmo se notifican errores al usuario:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_BEEPPROFILEERR]
= seleccione esta opcin para que el [=TITLE]
  produzca un pitido de error si no se puede activar un perfil
  de conexin seleccionado
- [=IDT_IDCHB_BEEPCONFIGERR]
= seleccione esta opcin para que el [=TITLE]
  produzca un pitido de error si se ha seleccionado la configuracin
  TPC/IP para el perfil de conexin actual y esta configuracin no
  ha tenido xito
- [=IDT_IDCHB_BEEPRANGE]
= seleccione esta opcin para que el [=TITLE]
  produzca un pitido de error cuando se sale o entra en el alcance
  de la seal

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEDISPLAY] 1/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEDISPLAY
.res 108
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina los iconos que muestra:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_BITMAPSIZE]
= determina el tamao de los iconos de estado
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_DISPLAY_DEFAULT_16] o
.
  *[=IDT_IDSTR_DISPLAY_DEFAULT_20]*
= hace que el icono de estado sea del tamao de los iconos de sistema
  pequeos. ste se determina a partir de la resolucin de pantalla y
  el tamao del tipo de letra estndar. Con algunos controladores de
  vdeo el tamao del tipo de letra estndar (y con l el de los
  iconos de sistema normales y pequeos) se puede cambiar alternando
  entre fuentes pequeas y grandes.
- [=IDT_IDSTR_DISPLAY_FORCE_16]
= fuerza el tamao de los iconos de estado a 16 pxeles
- [=IDT_IDSTR_DISPLAY_FORCE_20]
= fuerza el tamao de los iconos de estado a 20 pxeles
.el
.. -----------------
- [=IDT_IDTXT_BITMAPROTATION]
= determina la rotacin de los iconos de estado
.. -----------------
.sl compact
- *[=IDT_IDSTR_ROTATION_0]*
- *[=IDT_IDSTR_ROTATION_90]*
- *[=IDT_IDSTR_ROTATION_180]*
- *[=IDT_IDSTR_ROTATION_270]*
.el
.. -----------------

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEDISPLAY] 2/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEDISPLAY2
.res 109
.
Esta pgina del cuaderno de propiedades del [=TITLE]
determina los iconos de estado que mostrar la herramienta.

En este dilogo
.ul
- se pueden cargar nuevos iconos de estado pulsando el botn *[=IDT_IDPBS_LOADSET]*.
  Para ello se debe selecionar en el siguiente dilogo un directorio que contenga
  los [.IDPNL_APPENDIXOWNBITMAPS archivos de imagen respectivos].
..
- todos los smbolos de estado se pueden restablecer a sus valores por omisin
  pulsando el botn *[=IDT_IDPBS_DEFAULT]*.

[=NOTE]
.ul compact
- tambin se puede cargar un juego de archivos de imagen de estado
  [.IDPNL_CHANGEBITMAPS arrastrando] la carpeta que las contiene hasta
  el [=TITLE]

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEINFO]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEINFO
.res 110
.
Esta pgina del cuaderno de propiedades del [=TITLE]
muestra informacin sobre el programa.

.. ----------------------------------------
.3 [=IDT_IDDLG_SELECTPRF]
.. ----------------------------------------
.an IDPNL_PROFILE
.res 200
.
Este dilogo le permite mantener los perfiles disponibles.

Pulse uno de los botones para llevar a cabo la accin correspondiente:
.pl compact break=none tsize=15
.
- *[=IDT_IDPBS_SELECTPROFILE]*
= activar el perfil seleccionado.
  Si el perfil seleccionado est activo actualmente, este botn permanecer desactivado.
.
- *[=IDT_IDPBS_CREATEPROFILE]*
= crear un perfil nuevo
.
- *[=IDT_IDPBS_COPYPROFILE]*
= crear un perfil nuevo a partir del seleccionado
.
- *[=IDT_IDPBS_EDITPROFILE]*
= editar el perfil seleccionado
.
- *[=IDT_IDPBS_DELETEPROFILE]*
= borrar el perfil seleccionado.
  Si el perfil seleccionado est activo actualmente, este botn permanecer desactivado.
.
- *[=IDT_IDPBS_IMPORTPROFILE]*
= importar un perfil exportado previamente con *[=IDT_IDPBS_EXPORTPROFILE]*
.
- *[=IDT_IDPBS_EXPORTPROFILE]*
= exportar el perfil seleccionado

.. ----------------------------------------
.3 Propiedades del perfil
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES
.res 300

Esta pgina del cuaderno de propiedades de un perfil de
conexin del [=TITLE] contiene las siguientes pginas:
.su H50 1

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGECONNECTION] 1/2
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGECONNECTION
.res 301
.
Esta pgina del cuaderno de propiedades de un
perfil de conexin del [=TITLE]
determina las siguientes propiedades de la conexin:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_NAMECAPTION]
= determina el nombre del perfil
- [=IDT_IDTXT_MODECAPTION]
= el tipo de red o modo de conexin en que el dispositivo
  de red inalmbrica debera conectarse a otros:
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_STATIONMODE_BSS]
= el dispositivo de red inalmbrico se conectar a otros que provean un
  conjunto bsico (o extendido) de servicios. Principalmente son los
  llamados puntos de comunicacin, que constituyen puertas de enlace
  a redes cableadas convencionales (p.e. puntos de acceso pblico).
- [=IDT_IDSTR_STATIONMODE_ADHOC]
= el dispositivo inalmbrico se conectar directamente a otros clientes
  de red inalmbrica, constituyendo una red mvil.
.el
.. -----------------
- [=IDT_IDTXT_SSIDCAPTION]
= especifica el nombre de la red inalmbrica. Esto hace que el dispositivo
  establezca conexiones slo con otros que utilicen el mismo nombre de red.
.
  Si no especifica un nombre de red, el dispositivo de red inalmbrica se
  conectar a cualquier sistema que utilice el mismo tipo de conexin
  (ya sea BSS/ESS o ADHOC).
- [=IDT_IDCHB_CREATEIBSS]
= Esta opcin es til si el dispositivo opera en modo *entre iguales* y
  nadie ha establecido an una red inalmbrica de iguales que corresponda a
  este perfil de conexin. Seleccionar esta opcin har que el dispositivo
  de red inalmbrica de este sistema la establezca, una vez que se active
  el perfil de conexin.
.
  Esta opcin se ignora para los dispositivos soportados por el controlador
  GenMac, puesto que los controladores para Windows siempre crean una red
  entre iguales si no existe una.
- [=IDT_IDCHB_INCLUDEINSCAN]
= seleccione esta opcin si quiere que se incluya este perfil de conexin
  en la [.IDPNL_CONFIGURE_PROFILESCAN bsqueda de conexiones].

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGECONNECTION2] 2/2
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGECONNECTION2
.res 302
.
Esta pgina del cuaderno de propiedades de un
perfil de conexin del [=TITLE]
determina las siguientes propiedades de la conexin:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_SELNETWORK]
= determina el tipo de red
.ul compact
  - [=IDT_IDSTR_NETWORK_ANY]
  - [=IDT_IDSTR_NETWORK_80211B_11MBIT]
  - [=IDT_IDSTR_NETWORK_80211G_54MBIT]
  - [=IDT_IDSTR_NETWORK_80211A_54MBIT]
.el
.
.at fc=red
  Esta propiedad es experimental actualmente y por tanto
  est desactivada
.at

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGESECURITY]
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGESECURITY
.res 303
.
Esta pgina del cuaderno de propiedades de un
perfil de conexin del [=TITLE]
determina las propiedades de seguridad:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_WEPCAPTION]
= esta propiedad determina el modo de cifrado que el dispositivo de red
  inalmbrica debera utilizar para conectarse a otros. Los protocolos de
  la lista estn ordenados de menos a ms seguro.
.
  Los otros dispositivos, puntos de acceso u otros dispositivos de red
  inalmbrica en otros ordenadores, deben utilizar la misma opcin. Se
  recomienda
  [.IDPNL_CONFIGURE_SECURITY utilizar cifrado WPA o WPA2]
  siempre que sea posible.
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_WEPMODE_DISABLED]
= desactiva el cifrado. No utilice esta opcin para redes inalmbricas privadas;
  de lo contrario podra verse comprometido su sistema y accederse a sus datos
  privados desde el exterior. No utilizar cifrado slo tiene sentido cuando su
  sistema vaya a formar parte de una
  [.IDPNL_CONFIGURE_SECURITY red inalmbrica pblica].
.
- [=IDT_IDSTR_WEPMODE_WEP64]
= hace que el dispositivo cifre todos los datos con una clave WEP de 64 bits.
.
  Seleccione esta opcin para redes inalmbricas privadas slo si no hay un
  estndar de cifrado mejor disponible para todas las estaciones de la red, ya
  que este nivel puede ser forzado con ms facilidad que los ms fuertes. An
  as, en todo momento este nivel de cifrado proporciona una seguridad mejor
  que no utilizar ningn cifrado en absoluto. Para ms detalles lea la seccin
  [.IDPNL_CONFIGURE_SECURITY].
- [=IDT_IDSTR_WEPMODE_WEP128]
= hace que el dispositivo cifre todos los datos con una clave WEP de 128 bits.
.
  Seleccione esta opcin para todas las redes inalmbricas privadas si no hay
  disponible cifrado WPA. Para ms detalles lea la seccin
  [.IDPNL_CONFIGURE_SECURITY].
.
.
  El *cifrado WEP* se configura con las siguientes opciones:
.. ---------
.sl
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_TXKEYCAPTION]
= esta propiedad determina la clave que se utilizar para cifrar los datos
  transmitidos por su dispositivo de red inalmbrica. El receptor debe tener
  la misma clave configurada en cualquiera de sus cuatro entradas para claves
  para poder descifrar sus datos. Si el receptor tiene configuradas las mismas
  cuatro claves que su dispositivo, puede elegir cualquiera de estas claves
  para la transmisin.
- ##1 a ##4
= Claves WEP especificadas como
.ul compact
  - caracteres y nmeros, o
  - un valor hexadecimal (precediendo el valor con *0x*)
.el
.el
  Para [.IDPNL_KEYGEN generar automticamente las claves WEP de cifrado], pulse
  el botn *[=IDT_IDPBS_GENERATE]*. Esto le evita la molestia de introducir
  a mano nmeros hexadecimales largos.
.el
.
- [=IDT_IDSTR_WEPMODE_WPA_PSK]
= hace que los dispositivos de red inalmbrica compatibles con
  [.IDPNL_PREREQUISITES GenMac] cifren todos los datos con WPA, utilizando el
  sistema de cifrado de flujo RC4. La clave precompartida se utiliza para
  calcular una clave maestra. sta se utiliza en el protocolo TKIP para crear
  claves de trabajo, que se cambian tras un perodo de tiempo dado.
.
  Seleccione esta opcin para todas las redes inalmbricas privadas si no hay
  disponible cifrado WPA2. Para ms detalles lea la seccin
  [.IDPNL_CONFIGURE_SECURITY].
- [=IDT_IDSTR_WEPMODE_WPA2_PSK]
= hace que los dispositivos de red inalmbrica compatibles con
  [.IDPNL_PREREQUISITES GenMac] cifren todos los datos con WPA2, utilizando el
  cifrado de bloques AES, ms seguro. La clave precompartida se utiliza para
  calcular una clave maestra. sta se utiliza en el protocolo CCMP para crear
  claves de trabajo, que se cambian tras un perodo de tiempo dado.
  Seleccione esta opcin para todas las redes inalmbricas privadas en que est
  disponible el cifrado WPA2, ya que es el protocolo ms seguro. Para ms
  detalles lea la seccin [.IDPNL_CONFIGURE_SECURITY].
.el
.
.. ---------
  Para el *cifrado WPA* estn disponibles los siguientes controles:
.sl
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_WPAPSK]
= determina la clave precompartida. Puede tener una longitud de entre 8 y 63
  caracteres.

.. ----------------------------------------
.5 Generar claves WEP
.. ----------------------------------------
.an IDPNL_KEYGEN
.res 400
.
Este dilogo le permita generar automticamente las claves WEP necesarias
para el cifrado de los datos transmitidos en la red inalmbrica y que se
almacenarn en las [.IDPNL_PROFILEPROPERTIES_PAGESECURITY propiedades de
seguridad]:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_KEYGENTYPE]
= Seleccione el algoritmo que se utilizar para generar las claves WEP
- [=IDT_IDTXT_PASSPHRASE]
= Introduzca una cadena de caracteres de cualquier longitud

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGETCPIP]
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGETCPIP
.res 304
.
Esta pgina del cuaderno de propiedades de un
perfil de conexin del [=TITLE]
determina los parmetros de configuracin de
TPC/IP:
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_CONFIGTYPE_NONE]
= seleccione esta opcin para que el [=TITLE] no configure la
  interfaz TCP/IP de su dispositivo de red inalmbrica
- [=IDT_IDSTR_CONFIGTYPE_DHCP]
= seleccione esta opcin para que el [=TITLE] configure la
  interfaz TCP/IP de su dispositivo de red inalmbrica
  automticamente utilizando DHCP.
  Para ello debe haber un servidor DHCP disponible a travs de
  la red inalmbrica.
.
  Si la interfaz TCP/IP ya tiene la misma direccin que tras la
  ltima configuracin por DHCP, se salta este paso. Se puede forzar la
  la configuracin DHCP ejecutando *ifconfig #lanx# down* en un indicador
  de mandatos anter de seleccionar el perfil de conexin preparado para
  configurar por DHCP.
.
.
  Seleccione las siguientes opciones para establecer las
  [.IDPNL_CONFIGURE_DHCP_OPTIONS opciones DHCP] respectivas:
.. ---------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_OPTIONDNS]
= solicita del servidor DHCP los valores relacionados con el
  servidor de nombres de dominio (DNS). Si se desmarca esta opcin,
  se ignoran los valores devueltos para el DNS.
- [=IDT_IDCHB_OPTIONSTATICROUTES]
= solicita las rutas estticas proporcionadas por el servidor DHCP.
  Si se desmarca esta opcin, se ignoran las rutas estticas que devuelva.
- [=IDT_IDCHB_OPTIONHOSTNAME]
= enva al servidor DHCP el nombre de red de su equipo.
.el
.. ---------------
- [=IDT_IDSTR_CONFIGTYPE_MANUALLY]
= seleccione esta opcin para establecer aqu manualmente la direccin TCP/IP y
  mscara de red para la interfaz TCP/IP de su dispositivo de red inalmbrica
.. ---------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_TCPIPADDRESS]
= especifica la direccin de la interfaz TCP/IP de su dispositivo de red
  inalmbrica si se configura manualmente
- [=IDT_IDTXT_NETMASK]
= especifica la mscara de red de la interfaz TCP/IP de su dispositivo de red
  inalmbrica si se configura manualmente.
  Si no se especifica un valor, se utiliza la mscara de red estndar para
  la direccin TCP/IP especificada.
- [=IDT_IDPBS_CONFIGMORETCPIP]
= permite la [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP]
.el
.. ---------------

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGEAUTOSTART]
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGEAUTOSTART
.res 305
.
Esta pgina del cuaderno de propiedades de un
perfil de conexin del [=TITLE]
determina las propiedades de inicio automtico:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_LAUNCHBROWSER]
= seleccione esta opcin para que el [=TITLE]
  inicie automticamente el navegador estndar
  configurado en su sistema.

.. ----------------------------------------
.5 Configuracin de ms opciones TCP/IP
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP
.res 401
.
Este dilogo permite configurar ms opciones de configuracin TCP/IP
para un perfil de conexin:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_GATEWAY]
= especifica la direccin TCP/IP de la puerta de enlace por omisin
.
  Si no se especifica puerta de enlace por omisin, no se eliminar
  una ruta por omisin que ya exista.
- [=IDT_IDCHB_CONFIGDNS]
= seleccione esta opcin para que el [=TITLE] configure el Servicio
  de Nombres de Dominio para la red inalmbrica
- [=IDT_IDTXT_DOMAIN]
= especifica el nombre del dominio TCP/IP de la red inalmbrica
- [=IDT_IDTXT_DNS]
= especifica la direccin TCP/IP del servidor de nombres de dominio
- [=IDT_IDTXT_MTU]
= determina el tamao de la Unidad Mxima de Transmisin (MTU)
.. ------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_MTUTYPE_ETHERNETMAX]
= seleccione esta opcin para establecer la MTU en el valor por omisin de 1500
  bytes para redes Ethernet
- [=IDT_IDSTR_MTUTYPE_DSL]
= seleccione esta opcin para establecer la MTU en el valor optimizado de 1492
  bytes para el protocolo de red *PPP over Ethernet*, que se utiliza para
  conexiones DSL
- [=IDT_IDSTR_MTUTYPE_USERDEFINED]
= seleccione esta opcin para establecer un valor personalizado para la MTU
  entre 128 y 1500 bytes
.. ------------

.. ----------------------------------------
.3 Detectar redes inalmbricas pblicas
.. ----------------------------------------
.an IDPNL_HOTSPOT
.res 150
.
Para detectar puntos de acceso a una red inalmbrica pblica (puntos calientes
o hotspots), seleccione el men *[=IDT_IDMEN_HOTSPOT]*.

Dependiendo del tipo de controlador de dispositivo (GenPrism o GenMac) que
gestione su dispositivo de red inalmbrica actual, este men contiene una
o las dos siguientes entradas:
.pl [=PARMLIST_PARMS]
- [=IDT_IDMEN_HOTSPOT_SCAN]
= el controlador GenMac soporta la bsqueda de todos los puntos de acceso
  que se encuentren al alcance de la antena. El [=TITLE] abre un
  [.IDPNL_HOTSPOT_SCAN dilogo] que muestra todas las redes inalmbricas
  pblicas (y opcionalmente las privadas) que se detecten y permite conectarse
  a cualquier punto de acceso pblico que se encuentre al alcance. Esta entrada
  del men no est disponible para los controladores GenPrism.
- [=IDT_IDMEN_HOTSPOT_CONNECT]
= el controlador GenPrism y algunos otros compatibles con l no ofrecen la
  funcin de bsqueda de puntos de acceso, sino slo la de conectar a cualquier
  red inalmbrica pblica dentro del alcance.
.
  Si hay ms de un punto de acceso disponible, no podr influir en con cul se
  establece la conexin. El punto utilizado depende del dispositivo de red
  inalmbrica (bien por intensidad de seal, o por el canal de radio).
  Esta entrada est disponible para ambos tipos de controlador.

Para averiguar a qu red inalmbrica est conectado actualmente con un perfil,
mueva el puntero del ratn sobre el [=TITLE]. Se muestra el *SSID* de la red
inalmbrica conectada en la tercera lnea del texto emergente.

Si el [=TITLE] estableciera una conexin con un punto de acceso pblico, se
puede [.IDPNL_HOTSPOT_NEWPROFILE crear un perfil de conexin nuevo] a partir
de esta conexin seleccionando el men
*[=IDT_IDMEN_HOTSPOT]* - *[=IDT_IDMEN_HOTSPOT_COPYPRF]*.

Para facilitar el abrir un navegador, lo cual puede ser necesario para
registrarse en un punto de acceso pblico por el que se cobre, este men
contiene la entrada *[=IDT_IDMEN_HOTSPOT_BROWSER]*. Inicia el navegador
estndar configurado en su sistema.

.. ----------------------------------------
.4 [=IDT_IDDLG_NEWPROFILE]
.. ----------------------------------------
.an IDPNL_HOTSPOT_NEWPROFILE
.res 151
.
Este dilogo permite asignar un nombre al perfil que se crear para la
conexin actual a una red inalmbrica pblica.

El nuevo perfil se activar una vez creado con xito.

.. ----------------------------------------
.4 [=IDT_IDDLG_SCANHOTSPOT]
.. ----------------------------------------
.an IDPNL_HOTSPOT_SCAN
.res 152
.
Este dilogo muestra todos los puntos de acceso de redes inalmbricas pblicas
y/o privadas dentro del alcance de la antena y permite conectar a todos los
puntos de acceso pblicos (tambin llamados calientes o hotspots) o de acceso
privado conocidos. Puede existir ms de un punto de acceso para una red dada.

Para conectarse, seleccione una red/punto de acceso de la lista y pulse
*[=IDT_IDPBS_CONNECT]* o haga una pulsacin doble con el ratn sobre una red
.ul compact
- pblica y por tanto de acceso no restringido
- privada y por tanto de acceso restringido para la que ya exista al menos un
  perfil de conexin

El botn *[=IDT_IDPBS_CONNECT]* permanecer inactivo si selecciona una red
.ul compact
- a la que su sistema ya est conectado, incluyendo todas las entradas
  con el mismo nombre de red (SSID)
- oculta

La lista de redes muestra la siguiente informacin en columnas:
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_TITLE_TYPE]
= El identificador de tipo de red:
.pl break=none tsize=3
..-
...bi 80211a11.bmp
..= red de 11 MBit a 5 Ghz segn el estndar IEEE 802.11a
-
.bi 80211a54.bmp
= red de 54 MBit a 5 Ghz segn el estndar IEEE 802.11a
-
.bi 80211b11.bmp
= red de 11 MBit a 2.4 Ghz segn el estndar IEEE 802.11b
-
.bi 80211g54.bmp
= red de 54 MBit a 2.4 Ghz segn el estndar IEEE 802.11g
.el
- [=IDT_IDSTR_TITLE_SSID]
= Nombre de la red (IDentificador de Servicio del Sistema/SSID).
.
  Aqu se pueden mostrar los siguientes tipos de entradas (utilizando como
  nombre de red el ejemplo *MiRed*):
.pl [=PARMLIST_PARMS]
- *MiRed*
= sta es una red visible (se transmite el SSID).
  Si la red no est protegida, se puede establecer la conexin.
- *MiRed (**)*
= ste es el punto de acceso al que est conectado el sistema.
- *MiRed <**>*
= ste es un punto de acceso que utiliza el mismo SSID que
  el punto de acceso al que est conectado el sistema.
- *[=IDT_IDSTR_ITEM_HIDDEN]*
= Esta red est oculta (el SSID no se transmite).
  Puesto que el sistema nunca se ha conectado a este punto de acceso,
  el [=TITLE] no puede mostrar el nombre de red.
- *(MiRed)*
= Esta red est oculta (el SSID no se transmite).
  Puesto que se guard el nombre al conectarse por ltima vez,
  se muestra el nombre de red.
.el
- [=IDT_IDSTR_TITLE_PROFILES]
= muestra todos los perfiles de conexin que corresponden al SSID y los ajustes
  de privacidad de la red
- [=IDT_IDSTR_TITLE_ACCESSTYPE]
= muestra el tipo de acceso de la red, ya sea
  *[=IDT_IDSTR_ITEM_PUBLIC]* o *[=IDT_IDSTR_ITEM_PRIVATE]*
- [=IDT_IDSTR_TITLE_SIGNAL]
= muestra la intensidad de seal en porcentaje
- [=IDT_IDSTR_TITLE_CHANNEL]
= muestra el canal de transmisin que utiliza el punto de acceso de la red
- [=IDT_IDSTR_TITLE_MACADDRESS]
= muestra la direccin MAC del punto de acceso

.. ----------------------------------------
.5 Seleccin de perfil
.. ----------------------------------------
.an IDPNL_HOSTPOT_SELPROFILE
.res 153
.
Este dilogo le permite seleccionar entre los perfiles de conexin que
existan para la red inalmbrica que se seleccione en el
[.IDPNL_HOTSPOT_SCAN dilogo de bsqueda].

.. ----------------------------------------
.3 Cambiar los iconos de estado
.. ----------------------------------------
.an IDPNL_CHANGEBITMAPS
.
El [=TITLE] permite modificar los [.IDPNL_STATUS iconos de estado].

Para ello es necesario colocar uno o ms
[.IDPNL_APPENDIXOWNBITMAPS archivos de imagen con ciertos nombres]
en una carpeta.

Para cargar los archivos de imagen de esta carpeta
.ul
- arrastre la carpeta al [=TITLE]
..
- cargue la carpeta mediante la
[.IDPNL_PROPERTIES_PAGEDISPLAY2 segunda pgina Estado de las propiedades]

Ambas acciones abren el [.IDPNL_CHANGEBITMAPS_DIALOG].

.. ----------------------------------------
.4 Dilogo Iconos de estado
.. ----------------------------------------
.an IDPNL_CHANGEBITMAPS_DIALOG
.res 402
.
El dilogo Iconos de estado muestra dos contenedores, con el conjunto actual de
iconos de estado en el lado izquierda, y los iconos de estado disponibles en la
carpeta arrastrada sobre la ventana del [=TITLE] en el lado derecho. Todos los
iconos del lado derecho que an no estn activos se seleccionan automticamente.

Se pueden llevar a cabo las siguientes acciones:
.ul
- los iconos de estado del lado izquierdo se activan al cerrar el dilogo
- todos los iconos de estado seleccionados en el contenedor derecho se pueden
  aplicar al lado derecho pulsando el botn *[=IDT_IDPBS_APPLY]*
- los iconos de estado del lado izquierdo pueden restablecerse a los valores
  por omisin internos pulsando el botn *[=IDT_IDPBS_DEFAULT]*
- ambos contenedores pueden restablecerse al estado actual del programa
  pulsando el botn *[=IDT_IDPBS_UNDO]*

.. ----------------------------------------
.3 Opciones adicionales para el [=BASETITLE] independiente
.. ----------------------------------------
.an IDPNL_EXEOPTIONS
.in __standalone
.
El [=TITLE] est disponible tanto como herramienta del XCenter como en forma de
programa independiente. El programa independiente tiene en su men de contexto
la entrada *[=IDT_IDMEN_WINDOWCFG]*, a travs de la cual estn disponibles las
siguientes opciones, que no son necesarias como herramienta del XCenter:
.pl [=PARMLIST_PARMS]
- [=IDT_IDMEN_STAYONTOP]
= seleccione esta opcin si la ventana del [=TITLE] debe flotar sobre todas las
  dems, de forma que no quede oculta por ninguna
- [=IDT_IDMEN_HIDETLENTRY]
= seleccione esta opcin si la entrada del [=TITLE] debe ocultarse de la lista
  de ventanas del sistema
- [=IDT_IDMEN_LARGESIZE]
= seleccione esta opcin si la ventana del [=TITLE] debe mostrarse con un
  tamao mayor

Adems, la ventana del programa independiente se puede arrastrar con el primer
botn del ratn.

.. ----------------------------------------
.2 Configuracin
.. ----------------------------------------
.an IDPNL_CONFIG
.
[=TOPICS]
.su V30 u 1

.. ----------------------------------------
.3 Configurar el [=BASETITLE]
.. ----------------------------------------
.an IDPNL_CONFIG_CONFIGURE
.
La configuracin del [=TITLE] comprende dos partes, a saber: la conexin de
red inalmbrica, que provee la conexin fsica (comparable a un cable de red),
y la interfaz TCP/IP del dispositivo de red inalmbrica, que proporciona la
conexin lgica.

_*Configurar la conexin de red inalmbrica*_

Para empezar, puede conectarse a redes inalmbricas fijas con un punto de
acceso y a redes mviles *ad-hoc* o *entre iguales*. Las redes fijas cableadas
proporcionan los llamados puntos de acceso a los clientes de red inalmbrica,
estableciendo un as llamado conjunto bsico o extendido de servicios de red
inalmbrica. Por contra, una red mvil *ad-hoc* consiste slo en dos o ms
clientes de red inalmbrica y slo los conecta entre s, sin necesidad de un
punto de acceso.

Hay que establecer otra distincin entre
.ul compact
- redes [.IDPNL_HOTSPOT pblicas] (y por tanto no seguras), cuyos puntos de
  acceso tambin se denominan [.IDPNL_HOTSPOT puntos calientes o hotspots]
- redes privadas (con [.IDPNL_CONFIGURE_SECURITY seguridad])

Dentro de este programa se utilizan [.IDPNL_PROFILEPROPERTIES perfiles de conexin]
para establecer conexiones de red inalmbrica. Pulse en la ventana/herramienta
[=TITLE] con el segundo botn del ratn y seleccione una de las siguientes
acciones
.ul compact
- buscar o conectarse a un [.IDPNL_HOTSPOT punto caliente/de acceso pblico]
  mediante el submen *[=IDT_IDMEN_HOTSPOT]*, utilizando un perfil de conexin
  interno por omisin
- crear y utilizar tantos [.IDPNL_PROFILEPROPERTIES perfiles de conexin] como
  quiera, para acceder a redes inalmbricas especficas, seleccionando las
  acciones siguientes del men:
.ul compact
  - crear o modificar un perfil de conexin seleccionando
    *[=IDT_IDMEN_EDITPROFILE]*
  - activar un perfil de conexin desde el submen *[=IDT_IDMEN_SELECTPROFILE]*
  - incluir (opcionalmente) perfiles de conexin ya definidos en la
    [.IDPNL_CONFIGURE_PROFILESCAN]
.el

_*Configurar la interfaz TCP/IP*_

Una vez establecida una conexin de red inalmbrica, es necesario configurar
los protocolos de red correspondientes.
Actualmente, el [=TITLE] soporta la configuracin de la interfaz *TCP/IP*
vinculada al dispositivo de red inalmbrica. Cualquier otra configuracin
se puede [.IDPNL_CONFIGURE_SCRIPT ejecutar] mediante un archivo de proceso
por lotes que puede invocar al (des)conectarse y que el propio usuario puede
editar.

Aunque el controlador de dispositivo NDIS proporciona una interfaz de red
de *rea local* (LAN, Local Area Network), a pesar de todo debe configurarse
como una interfaz de red de *rea extensa* (WAN, Wide Area Network), por
ejemplo una conexin mediante mdem o llamada telefnica.

Por consiguiente, se recomienda encarecidamente no configurarla desde el
*programa de configuracin TCP/IP* sino en su lugar slo a traves de un
programa que establezca o cierre conexiones WAN (en este caso el [=TITLE]).

Dentro de cada [.IDPNL_PROFILEPROPERTIES perfil de conexin] que se defina,
se pueden seleccionar tres tipos de
[.IDPNL_PROFILEPROPERTIES_PAGETCPIP configuracin TCP/IP]:
.ul compact
- [=IDT_IDSTR_CONFIGTYPE_NONE]
- [=IDT_IDSTR_CONFIGTYPE_DHCP]
- [=IDT_IDSTR_CONFIGTYPE_MANUALLY]

Al conectarse a un punto de acceso pblico, se utiliza un perfil de conexin
interno, que asume que la red no es segura (sin cifrado) y se proporciona una
configuracin de TCP/IP automtica mediante DHCP.

Cuando las redes domsticas incorporan puntos de acceso inalmbricos, a menudo
surge la cuestin de cmo [.IDPNL_CONFIGURE_SWITCH alternar entre conexiones
por cable e inalmbricas a la misma red].

.. ----------------------------------------
.3 Utilizar cifrado en redes inalmbricas
.. ----------------------------------------
.an IDPNL_CONFIGURE_SECURITY
.
Al conectarse a redes inalmbricas, debe adoptar contramedidas contra ataques
desde el exterior, o de lo contrario podra accederse con facilidad a su
sistema.

Esto es especialmente importante si aade un punto de acceso inalmbrico a su
propia red y sta est conectada a Internet.
.at fc=red
Es un error ampliamente extendido pensar que un sistema que no contiene datos
importantes no necesita ser protegido. Cualquier sistema que tenga una conexin
a internet puede ser utilizado para actividades criminales en ella, dejando
su direccin TCP/IP particular como nico rastro visible y con l a vd. bajo
sospecha de haber realizado esas actividades. Lo que es ms, si no dispone de
una tarifa plana de acceso a internet, ello puede acarrearle costes extra si
alguien utiliza su conexin a internet.
.at

Adems, los clientes (porttiles) conectados a una red inalmbrica necesitan
proteccin extra. Dependiendo de si la red es pblica o no, se recomiendan
las siguientes acciones:

_*Conectarse a redes inalmbricas pblicas*_

A las redes inalmbricas pblicas se accede mediante los denominados puntos
calientes, que no son ms que puntos de acceso pblicos y por tanto no seguros.
Al acceder a un punto caliente, obviamente no tiene sentido cifrar los datos,
pues cualquier clave de cifrado sera accesible pblicamente de todas formas.
.
En este caso se recomienda encarecidamente tener un programa cortafuegos en
su sistema, para evitar posibles ataques, configurado para prevenir cualquier
acceso a los siguientes programas en ejecucin
.ul compact
- Servicios de Archivo e Impresin a travs del protocolo de red *NetBIOS sobre
 TCP/IP*
- cualesquiera servicios TCP/IP en su sistema, como servidores Web, Telnet o
FTP.

Como alternativa a utilizar un programa cortafuegos, antes de activar una
conexin de red inalmbrica, se puede detener los servicios o programas
respectivos para eliminar posibles objetivos de ataque.

_*Conectarse a redes inalmbricas privadas*_

Al establecer una red inalmbrica privada, no importa si se utiliza un punto de
acceso o se trata de una denominada red ad hoc sin punto de acceso, se recomienda
encarecidamente utilizar el mejor estndar de cifrado que est disponible para
todas las estaciones que se conecten. Esto es importante, pues
.ul compact
- actualmente una red inalmbrica cifrada mediante WPA, o mejor an WPA2, es
  segura frente los ataques conocidos que pueden triunfar contra redes
  inalmbricas cifradas usando WEP. El cifrado WPA/WPA2 slo est disponible con
  el [.IDPNL_PREREQUISITES controlador GenMac].
- una red inalmbrica cifrada mediante WEP es un objetivo menos interesante
  para posibles atacantes comparada con una sin cifrar, especialmente para
  aquellos que slo quieran un rpido acceso gratuito a internet. A pesar de
  ello puede ser forzada.
- en algunos pases/estados es como mnimo ilegal espiar una red inalmbrica
  protegida mediante cifrado.

.. ----------------------------------------
.3 Bsqueda de perfiles de conexin
.. ----------------------------------------
.an IDPNL_CONFIGURE_PROFILESCAN
.
Los [.IDPNL_PROFILEPROPERTIES perfiles de conexin] que se definan pueden
incluirse en la bsqueda de conexiones. Al iniciarla, el [=TITLE] va
cargando cada perfil incluido hasta que logra establecer una conexin.

Esto slo tiene sentido para redes privadas, pues para acceder a redes pblicas
sera ms til buscar manualmente o conectarse a un
[.IDPNL_HOTSPOT punto caliente/de acceso pblico]; por
[.IDPNL_CONFIGURE_SECURITY razones de seguridad] uno slo debera conectarse a
un punto caliente a propsito, no de forma accidental o automtica.

En la pgina [.IDPNL_PROPERTIES_PAGESCAN] del cuaderno de propiedades, se puede
configurar la bsqueda de conexiones para iniciarse automticamente al inicio
del programa y/o al reinsertar una tarjeta PCMCIA.

Un caso de uso comn para la bsqueda de perfiles de conexin es crear al menos
dos de ellos, por ejemplo uno para la red inalmbrica del trabajo y la de casa.
Cuando el [=TITLE] se configura para buscar los perfiles de conexin al
iniciarse, siempre establecer automticamente, posiblemente tras unos segundos,
conexin con una de las redes privadas en cuestin, toda vez que el sistema se
inicie dentro del alcance de una de stas.

.. ----------------------------------------
.3 Archivos por lotes en eventos de (des)conexin
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT
.
El [=TITLE] puede ejecutar archivos de proceso por lotes (archivos CMD
simples o en REXX) al (des)conectarse para procesar los mandatos de
usuario que defina para su red inalmbrica.

Este archivo por lotes se ejecuta
.ul compact
- tras configurarse la interfaz TCP/IP, o
- antes de anular su configuracin

[=TOPICS]
.su H50

.. ----------------------------------------
.4 Nombres de los archivos por lotes y de registro
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_FILES
.
El [=TITLE] utiliza los siguientes archivos cuando existen en la
[.IDPNL_PROPERTIES_PAGESCRIPT va de acceso del archivo por lotes]:
.pl [=PARMLIST_PARMS]
- xwlan.cmd
= un archivo [.IDPNL_CONFIGURE_SCRIPT_CMD CMD] o
  [.IDPNL_CONFIGURE_SCRIPT_REXX REXX]
- xwlan.in
= archivo de texto con datos para
  [.IDPNL_CONFIGURE_SCRIPT_REDIRINPUT emular la entrada por teclado mediante redireccin]

El [=TITLE] escribe los siguientes archivos en la
[.IDPNL_PROPERTIES_PAGESCRIPT va de acceso del archivo por lotes]:
.pl [=PARMLIST_PARMS]
- xwlan.log
= archivo de registro acumulativo de las salidas estndar y de errores del
  archivo por lotes xwlan.cmd
- xwlan.#xxx#
= donde #xxx# es un nmero aleatorio de tres cifras: archivo de registro
  temporal con la salida de una invocacin del archivo por lotes xwlan.cmd.
  En caso de que este archivo temporal no pueda anexarse al registro
  acumulativo, este archivo de registro temporal no se elimina

.. ----------------------------------------
.4 Utilizar un archivo por lotes CMD
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_CMD
.
Al utilizar un [.IDPNL_APPENDIXSCRIPT_CMD archivo CMD simple] para los eventos
de (des)conexin, se le pasan las siguientes variables de entorno para que se
puedan emprender las acciones apropiadas dentro del archivo:
.ul compact
- [.FN_VAR_EVENT WLAN__EVENT]
- [.FN_VAR_PROFILENAME WLAN__PROFILENAME]
- [.FN_VAR_SSID WLAN__SSID]
- [.FN_VAR_IPCONFIG WLAN__IPCONFIG]
- [.FN_VAR_IPINTERFACE WLAN__IPINTERFACE]
- [.FN_VAR_IPADDRESS WLAN__IPADDRESS]
- [.FN_VAR_IPNETMASK WLAN__IPNETMASK]
- [.FN_VAR_DRIVERNAME WLAN__DRIVERNAME]
- [.FN_VAR_DRIVERTITLE WLAN__DRIVERTITLE]
- [.FN_VAR_SCRIPTDIR WLAN__SCRIPTDIR]

.. ----------------------------------------
.4 Utilizar un programa REXX
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_REXX
.
Al utilizar un [.IDPNL_APPENDIXSCRIPT_REXX programa REXX] para los eventos
de (des)conexin, se le pasan las siguientes variables para que se
puedan emprender las acciones apropiadas dentro del programa:
.ul compact
- [.FN_VAR_EVENT WLan.__EVENT]
- [.FN_VAR_PROFILENAME WLan.__PROFILENAME]
- [.FN_VAR_SSID WLan.__SSID]
- [.FN_VAR_IPCONFIG WLan.__IPCONFIG]
- [.FN_VAR_IPINTERFACE WLan.__IPINTERFACE]
- [.FN_VAR_IPADDRESS WLan.__IPADDRESS]
- [.FN_VAR_IPNETMASK WLan.__IPNETMASK]
- [.FN_VAR_DRIVERNAME WLan.__DRIVERNAME]
- [.FN_VAR_DRIVERTITLE WLan.__DRIVERTITLE]
- [.FN_VAR_SCRIPTDIR WLan.__SCRIPTDIR]

.. ----------------------------------------
.4 Ejecutar el archivo por lotes asncronamente
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_ASYNC
.
Por omisin, el [=TITLE] espera a que concluya la ejecucin del archivo por
lotes antes de continuar procesando el procedimiento de conexin o desconexin,
para que cualesquiera otras acciones slo puedan tener lugar despus.

Cuando un archivo por lotes necesita mucho tiempo para procesar un evento y por
tanto bloquea el [=TITLE] demasiado tiempo, se puede deseleccionar la opcin
*[=IDT_IDCHB_WAITFORSCRIPTS]* en la pgina de propiedades
[.IDPNL_PROPERTIES_PAGESCRIPT].

En estos casos procesar un evento ya no bloquea el [=TITLE]. Slo puede
ejecutarse un archivo por lotes cada vez en todos los casos. Para ello, cada
invocacin del archivo, iniciada en un hilo separado, espera a que termine el
archivo por lotes que est en ejecucin actualmente.

Puede presentarse un problema si a base de interaccin repetida con el usuario
el archivo por lotes es llamdo ms de una vez y estas instancias esperan juntas
a que termine la ejecucin actual del archivo por lotes. En tal caso, no se
puede garantizar el orden de las llamadas.

Para evitar este problema:
.ul compact
- haga que el [=TITLE] vuelva a llamar al archivo por lotes sncronamente
- coloque los mandatos ms largos en un archivo por lotes separado que se
  inicie mediante el mandato [inf:cmdref START] desde el archivo por lotes del
  [=TITLE].

.. ----------------------------------------
.4 Emular entrada de teclado mediante redireccin
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_REDIRINPUT
.
En caso de que cualquier mandato ejecutado desde el archivo por lotes necesite
entrada por teclado, puede utilizar el contenido del archivo
[.IDPNL_CONFIGURE_SCRIPT_FILES xwlan.in] en el
[.IDPNL_PROPERTIES_PAGESCRIPT directorio del archivo por lotes]
en su lugar. De otro modo, el archivo por lotes puede bloquearse y no terminar
si ejecuta mandatos que quedan a la espera de entrada por el teclado.

.at fc=red
[=NOTE]
.ul compact
- Esto slo funcionar para mandatos *que no vacen el bfer de teclado*
  antes de aceptar entrada por el teclado. No se pueden utilizar mandatos
  que vacen el bfer de teclado en el archivo por lotes xwlan.cmd.
.at

.. ----------------------------------------
.4 Consideraciones importantes sobre el directorio de trabajo
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_WORKINGDIR
.
Cuando el [=TITLE] ejecuta un archivo por lotes,
su directorio actual es el directorio raz de la unidad de arranque del
sistema operativo.

.at fc=red
[=NOTE]
.ul compact
- El archivo por lotes no puede cambiar el directorio actual o al menos
  restablecerlo al directorio anterior antes de que finalice su archivo por
  lotes; de lo contrario se cambia el directorio de trabajo para el
  Escritorio (el *Workplace Shell*) al completo, lo que puede llevar a
  resultados impredecibles.
- Para restablecer el directorio actual se pueden utilizar los siguientes
  mtodos:
.ul
  - En un [.IDPNL_APPENDIXSCRIPT_CMD archivo por lotes CMD]
.ul compact
    - al principio, ejecute el mandato [inf:cmdref SETLOCAL] y
    - al final, ejecute el mandato [inf:cmdref ENDLOCAL]
.el
.
    Tenga en cuenta, sin embargo, que no se puede anidar estos mandatos.
  - En un [.IDPNL_APPENDIXSCRIPT_REXX programa REXX]
.ul compact
    - al principio, invoque la funcin [inf:rexx SETLOCAL] y
    - al final, invoque la funcin [inf:rex ENDLOCAL]
.el
.el
.at

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_EVENT
.
variable de archivo por lotes CMD: WLAN__EVENT
.
variable para programas REXX: WLan.__EVENT

Esta variable especifica el evento que invoca el archivo por lotes,
y tiene uno de los siguientes valores:
.ul compact
- CONNECT
- DISCONNECT
.el

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_PROFILENAME
.
variable de archivo por lotes CMD: WLAN__PROFILENAME
.
variable para programas REXX: WLan.__PROFILENAME

Esta variable especifica el nombre del perfil
tal como se ha introducido en la pgina
[.IDPNL_PROFILEPROPERTIES_PAGECONNECTION] de las
propiedades del perfil.

Si hay activa una conexin a un [.IDPNL_HOTSPOT punto caliente],
esta variable est vaca.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_SSID
.
variable de archivo por lotes CMD: WLAN__SSID
.
variable para programas REXX: WLan.__SSID

Esta variable especifica el [=IDT_IDTXT_SSIDCAPTION] del
punto de acceso con el que hay conexin.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPCONFIG
.
variable de archivo por lotes CMD: WLAN__IPCONFIG
.
variable para programas REXX: WLan.__IPCONFIG

Esta variable especifica el tipo de configuracin TCP/IP que se realiza,
tal como se establece en la pgina [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]
de propiedades del perfil,
y tiene uno de los siguientes valores:
.ul compact
- NONE
- MANUALLY
- DHCP
.el

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPINTERFACE
.
variable de archivo por lotes CMD: WLAN__IPINTERFACE
.
variable para programas REXX: WLan.__IPINTERFACE

Esta variable especifica la interfaz TCP/IP a la que
est vinculado el dispositivo de red inalmbrica.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPADDRESS
.
variable de archivo por lotes CMD: WLAN__IPADDRESS
.
variable para programas REXX: WLan.__IPADDRESS

Esta variable especifica la direccin TCP/IP configurada
para la interfaz del dispositivo de red inalmbrica.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPNETMASK
.
variable de archivo por lotes CMD: WLAN__IPNETMASK
.
variable para programas REXX: WLan.__IPNETMASK

Esta variable especifica la mscara de red configurada
para la interfaz del dispositivo de red inalmbrica.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_DRIVERNAME
.
variable de archivo por lotes CMD: WLAN__DRIVERNAME
.
variable para programas REXX: WLan.__DRIVERNAME

Esta variable especifica el nombre del controlador de su
dispositivo de red inalmbrica, como p.e.: *PRISMC$*

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_DRIVERTITLE
.
variable de archivo por lotes CMD: WLAN__DRIVERTITLE
.
variable para programas REXX: WLan.__DRIVERTITLE

Esta variable especifica el ttulo del controlador de su
dispositivo de red inalmbrica, como p.e.:
*Generic PRISM driver for PCMCIA/PLX cards*

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_SCRIPTDIR
.
variable de archivo por lotes CMD: WLAN__SCRIPTDIR
.
variable para programas REXX: WLan.__SCRIPTDIR

Esta variable especifica el directorio en el que
se encuentra el archivo por lotes, tal como se
introduce en la pgina de propiedades
[.IDPNL_PROPERTIES_PAGESCRIPT].

.. ----------------------------------------
.3 Conexin inalmbrica y por cable a la misma red
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID
.
Se pregunta con frecuencia cmo conectarse desde un porttil a
la misma red (domstica) dos veces, desde una conexin por
cable y otra inalmbrica simultneamente. La expectativa sera
que el sistema detecte por su cuenta cul de las conexiones
est disponible, y cambie sobre la marcha de una a otra. Si las
dos conexiones estuviesen disponibles, el sistema elegira
automticamente la ms rpida.

*Desgraciadamente esto no es posible.*

.
[=TOPICS]
.su 1 H50

.. ----------------------------------------
.4 Ejemplo de conexin a red
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_SCENARIO
.
Tomemos una configuracin de red muy frecuente, consistente en
.ul compact
- Un enrutador (A)DSL, que tambin sirve como punto de acceso de red inalmbrica
  y servidor DHCP
- Un ordenador porttil con un dispositivo de red inalmbrica instalado y funcional

Notas:
.ul compact
- El ejemplo tambin servira sin servidor DHCP si se utilizaran direcciones
  TCP/IP estticas.
- En vez de un enrutador DSL, o adems de ste, puede haber uno o ms PCs de
  sobremesa en el escenario. Tambin, en tal caso, el problema ser que
  _cualquiera_ de los otros componentes de la red (sea un enrutador o cualquier
  otro PC) debera estar accesible por cable o conexin inalmbrica en
  todo momento.

En nuestro escenario de ejemplo la configuracin TCP/IP sera:

_*Enrutador/punto de acceso/servidor DHCP*_
.fo off
lan0 192.168.1.1/255.255.255.0
.fo on

_*Porttil*_
.fo off
cable lan0 192.168.1.2/255.255.255.0
radio lan1 192.168.1.3/255.255.255.0
ruta por omisin a 192.168.1.1/255.255.255.0
.fo on

[=NOTE]
.ul
- En el porttil las interfaces TCP/IP inalmbrica y por cable estn
  configuradas para la misma subred TCP/IP (192.168.1.1), pues establecen su
  configuracin desde el mismo servidor DHCP. ste tendra que ser tambin el
  caso si estas interfaces se configurasen con direcciones TCP/IP, puesto
  que se pretende que ambas puedan acceder a todos los dems componentes de
  la subred TCP/IP (en este caso: el enrutador).
- Aunque el cliente DHCP de OS/2 y eComStation se restringe a una sola
  interfaz LAN configurada, an es posible configurar una segunda interfaz por
  DHCP. Esto puede hacerse deteniendo primero dhcpcd.exe (dhcpmon /t o matar el
  proceso) antes de ejecutar *dhcpstrt* para solicitar otra cesin DHCP.
.
  sta es exactamente la accin que lleva a cabo el [=TITLE].

.. ----------------------------------------
.4 Conflicto de rango de direcciones TCP/IP
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT
.
Una limitacin del protocolo de red TCP/IP es que un sistema slo puede tener
una interfaz de red configurada para una subred TCP/IP (en nuestro escenario de
ejemplo: 192.168.1).
En otro caso, la pila TCP/IP ya no puede decidir de forma nica por la
configuracin dada qu interfaz usar para enviar paquetes TCPIP a los sistemas
conectados a esa misma red TCP/IP (como por ejemplo, el enrutador,
configurado como _192.168.1_.1).

Si hay ms de una interfaz configurada para la misma subred, o mejor, el rango
de direcciones de la subred, estas interfaces estn en conflicto entre s. En
tal caso la pila TCP/IP decidir por s misma qu interfaz utilizar para la
subred. Se prefiere la interfaz con la direccin ms baja, y todas las
interfaces en conflicto se ignoran. La conexin a la red dada funcionar
mientras la interfaz preferida est fsicamente conectada.

En nuestro [.IDPNL_CONFIGURE_HYBRID_SCENARIO ejemplo] del porttil todos los
paquetes a la red 192.168.1 se enviaran por la interfaz lan0 mientras que la
lan1 sera ignorada por completo. Si el usuario retirase el cable de red, el
equipo quedara desconectado. No importara que la conexin inalmbrica an
estuviese disponible, puesto que la interfaz correspondiente seguira siendo
ignorada.

Aparecera el mismo problema si la interfaz inalmbrica se configurase con la
direccin ms baja. El equipo quedara desconectado si fallara la conexin
inalmbrica, sin importar que el interfaz cableado siguiera disponible.

.. ----------------------------------------
.4 Deteccin automtica de conflictos de rango de direcciones TCP/IP
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_DETECTCONFLICT
.
El posible [.IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT conflicto de rangos de
direcciones] aqu descrito se detectara automticamente si la configuracin
de la interfaz TCP/IP del dispositivo de red inalmbrica se realiza a travs
del [=TITLE] o por DHCP. Para resolver el conflicto, se pide al usuario que
decida retirar la configuracin de cualquiera de los interfaces, el cableado
o el inalmbrico.

Tambin se hace esto al [.IDPNL_CONFIGURE_HYBRID_SOLUTION] a peticin del
usuario.

.. ----------------------------------------
.4 Alternar entre interfaces TCP/IP
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_SOLUTION
.
Para evitar el [.IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT] y posiblemente el quedar
sin conexin, es necesario alternar explcitamente entre las interfaces con
cable e inalmbrica.

En trminos de la pila TPC/IP esto se conseguira eliminando una interfaz y
configurando la otra, de tal modo que cada vez haya una sola interfaz
configurada para la misma subred TCP/IP a la vez.

Al cambiar de una a otra, tambin sera necesario eliminar la ruta por omisin
antes de hacer el cambio, ya que esta definicin est vinculada a la interfaz
actualmente activa. Tambin debe vaciarse el cach ARP para reconstruir toda la
informacin de conexin, utilizando ahora la ruta por omisin sobre la nueva
interfaz configurada.

Este mecanismo de cambio est soportado hasta cierto punto por el [=TITLE].
Si necesita esta funcin, configure este programa de acuerdo con las
instrucciones en:
.sl compact
- [.IDPNL_CONFIGURE_SWITCH]

.. ----------------------------------------
.3 Alternar entre conexiones por cable e inalmbrica
.. ----------------------------------------
.an IDPNL_CONFIGURE_SWITCH
.
Para poder alternar entre conexin inalmbrica y por cable a una misma red,
siga los siguientes pasos de configuracin:
.ul
- Dentro del *programa de configuracin TCP/IP*
.ul compact
  - Configure la interfaz TCP/IP de la tarjeta de red con la interfaz por cable.
  - _No_ configure la interfaz TCP/IP para el dispositivo de red inalmbrica.
..
- Cree un perfil de conexin para la red inalmbrica
  (consulte [.IDPNL_CONFIG_CONFIGURE] para ms detalles)
.ul compact
  - En el cuaderno de propiedades [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]
    seleccione para este perfil de conexin bien:
    - *[=IDT_IDSTR_CONFIGTYPE_DHCP]* o
    - *[=IDT_IDSTR_CONFIGTYPE_MANUALLY]*
    para la interfaz TCP/IP del dispositivo de red inalmbrica. Si elige
    configurarlo manualmente, no olvide configurar la direccin TPC/IP del
    componente enrutador de su red que proporcione acceso a internet como
    direccin de puerta de enlace por omisin.
..
- En la pgina [.IDPNL_PROPERTIES_PAGETCPIP] del cuaderno de propiedades,
  seleccione la opcin *[=IDT_IDCHB_EXECSETUP]*, que ejecuta parte de la
  *configuracin TCP/IP de la red local* (setup.cmd) cuando se desconecta
  el sistema de una red inalmbrica. Esto restablecer la configuracin de sus
  interfaces y rutas TCP/IP al mismo estado que al inicio del sistema, de tal
  modo que la interfaz TCP/IP correspondiente a la conexin por cable quede
  correctamente reconfigurada.

Cuando el sistema se configura as, al iniciarse configurar primero la
conexin por cable. La alternancia entre las interfaces con cable e inalmbrica
tiene lugar como se detalla a continuacin:

_*Cambiar a conexin inalmbrica*_

Cuando el [=TITLE] establece conexin con el punto de acceso de su red
inalmbrica, automticamente configurar la interfaz TCP/IP de su dispositivo
de red inalmbrica. A continuacion detectar el
[.IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT] y le mostrar un dilogo. Aqu puede
seleccionarse si debera mantenerse la configuracin de la interfaz TCP/IP del
dispositivo de red inalmbrica o por cable.
Pulse *S* para mantener la configuracin de la interfaz inalmbrica y
descartar la configuracin de la interfaz por cable. Con esto termina el
cambio a la interfaz inalmbrica.

[=NOTE]
.ul
- Para asegurarse de que el [=TITLE] no configura la interfaz de red
  inalmbrica accidentalmente, y con ello posiblemente interrumpir
  transferencias de datos que estn en marcha (p.e. descargas por FTP, etc.),
  puede querer desactivar la antena de radio desmarcando
  *[=IDT_IDMEN_ENABLERADIO]* en el men de contexto de la herramienta del
  XCenter o ventana del [=TITLE].
.
  Tambin puede configurar el programa para que apague la antena de radio al
  iniciarse: en la pgina [.IDPNL_PROPERTIES_PAGERADIO] del cuaderno de
  propiedades, seleccione la opcin *[=IDT_IDRBT_RADIOOFF]*.
..
- Para evitar que el [=TITLE] le pregunte cada vez si cambiar al dispositivo
  de red inalmbrica, en la pgina [.IDPNL_PROPERTIES_PAGETCPIP] del cuaderno
  de propiedades establezca en *[=IDT_IDSTR_CONFLRESOLVE_AUTO]* la opcin
  *[=IDT_IDTXT_CONFLRESOLVE]*.

_*Cambiar a conexin por cable*_

Para volver a cambiar a conexin por cable, desde el men de contexto del
[=TITLE], bien:
.ul compact
- seleccione *[=IDT_IDMEN_ENABLERADIO]* para activar la antena de radio, o
- seleccione *[=IDT_IDMEN_IPCFG]* - *[=IDT_IDMEN_IPCFG_UNCONFIG]*

Si despus quiere volver a cambiar a la conexin inalmbrica, en el mismo
men:
.ul compact
- desmarque *[=IDT_IDMEN_ENABLERADIO]* para desactivar la antena, y
- seleccione *[=IDT_IDMEN_IPCFG]* - *[=IDT_IDMEN_IPCFG_CONFIG]*

Para facilitar este paso, en la pgina [.IDPNL_PROPERTIES_PAGEMOUSE] del
cuaderno de propiedades establezca la opcin *[=IDT_IDTXT_MB1DBLCLICK]*
a uno de los siguientes valores:
.ul compact
- *[=IDT_IDSTR_MB1DBL_ENABLERADIO]*
- *[=IDT_IDSTR_MB1DBL_DISABLETCPIP]*

Despus de esto podr alternar entre la conexin por cable y la inalmbrica
con una simple pulsacin doble del ratn sobre el [=TITLE].

[=NOTE]
.ul compact
- Asegrese de seguir un mismo sistema, bien (des)activar la antena de radio,
  bien desactivar y reconfigurar la interfaz TCP/IP. Si los mezcla, la
  alternancia repetida puede no funcionar en todos los casos.

.. ----------------------------------------
.3 Configurar el cliente DHCP
.. ----------------------------------------
.an IDPNL_CONFIGURE_DHCP
.
El [=TITLE] configura el cliente DHCP cuando
.ol compact
- se activa configurar el cliente DHCP en las
  [.IDPNL_PROPERTIES_PAGETCPIP2 propiedades] del programa y
- se han seleccionado las opciones correspondientes en el
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP perfil de conexin]

[=TOPICS]
.su H50

.. ----------------------------------------
.4 Opciones de DHCP
.. ----------------------------------------
.an IDPNL_CONFIGURE_DHCP_OPTIONS
.
El [=TITLE] configura las siguientes opciones de DHCP cuando se activa la
configuracin del cliente DHCP en las
[.IDPNL_PROPERTIES_PAGETCPIP2 Propiedades de TCP/IP].

Se solicitan siempre las siguientes opciones:
.fo off
option 1          ## solicitar mscara de red
option 3          ## solicitar puerta de acceso (enrutador)
option 26         ## solicitar tamao MTU
option 28         ## solicitar direccin de broadcast
.fo on

Las siguientes opciones se solicitan con el mandato *option*, o bien se
rechazan con *reject*, dependiendo del valor de las propiedades de TCP/IP
respectivas del [.IDPNL_PROFILEPROPERTIES_PAGETCPIP perfil de conexin]:

*[=IDT_IDCHB_OPTIONDNS]*
.fo off
option 6          ## solicitar servidor de nombres de dominio
option 15         ## solicitar nombre de dominio
.fo on
..
*[=IDT_IDCHB_OPTIONSTATICROUTES]*
.fo off
option 33         ## solicitar rutas estticas
.fo on

*[=IDT_IDCHB_OPTIONHOSTNAME]*
.fo off
option 12 "nombre" ## proporcionar nombre de sistema
.fo on
donde se sustituye #nombre# por el valor de la variable de entorno
HOSTNAME. Ya que esta opcin slo se enva al servidor DHCP, y nunca es
devuelta al cliente, bien es solicitada o no aparece en absoluto en
el archivo de configuracin.

.. ----------------------------------------
.4 Escribir el archivo de configuracin del cliente DHCP
.. ----------------------------------------
.an IDPNL_CONFIGURE_DHCP_WRITE
.
Antes de cada solicitud de una cesin DHCP, el [=TITLE] reinicia
dhcpd, o DHCP Client Daemon (cliente de DHCP en segundo plano).

Antes de eso, y si la configuracin del cliente DHCP est activada
en las propiedades del [=TITLE], se comprueba el archivo de configuracin
*%etc%\dhcpcd.cfg* y, si no contiene exactamente la informacin necesaria,
se sobreescribe. Eso hace que se pierdan todos los posibles cambios
realizados manualmente.

Al escribir el archivo, el [=TITLE] le asigna un atributo extendido llamado
*XWLAN.DHCPCFG* para poder determinar si es necesario crear una copia de
respaldo antes de sobreescribirlo.
.
Al ser escrito por primera vez, el archivo no tendr este atributo
extendido. Entonces se archiva una copia de respaldo con el nombre
*%etc%\dhcpcd.bak*, sobreescribiendo el archivo que ya pueda existir.

.at fc=red
[=NOTE]
.ul compact
- Si no se activa configurar el cliente DHCP,
  se utiliza con el archivo de configuracin que ya exista.
- La copia de seguridad no se restaura automticamente si
  configurar el cliente estaba activo en el [=TITLE] y se
  desactiva.
.at

.... ----------------------------------------
...2 Limitaciones
.... ----------------------------------------
...an IDPNL_LIMITATIONS
...
..La versin actual del [=TITLE] tiene las siguientes limitaciones:
...ul

.. ################
.include history.esp
.. ################

.. ################
.. #.. ----------------------------------------
.. #.3 Unverffentlichte Version
.. #.. ----------------------------------------
.. #.an IDPNL_REVISION_UNRELEASED
.. #.
.. ################

.. ----------------------------------------
.3 Versin 3.13
.. ----------------------------------------
.an IDPNL_REVISION_313
.
_*Nuevo:*_
.ul

_*Solucionado:*_
.ul
- Tickets ##46, ##37, ##34
- Ticket ##31

.. ----------------------------------------
.3 Versin 3.12
.. ----------------------------------------
.an IDPNL_REVISION_312
.
_*Nuevo:*_
.ul
- Ahora se utiliza el cliente dhcp 'Internet Systems Consortium DHCP Distribution Version 3.1-ESV-R3'
  en vez del proceso de DHCP en segundo plano de OS/2 (yum install dhclient)
- Probado con el agente WPA v2.0 y v2.2 (wpa__supplicant v2.2 (eCS-v1) incluido)
- Comprobacin de la versin instalada de dhclient.exe y wpa__supplicant.exe. Tambin
  se muestran en las pginas correspondientes del dilogo de opciones
- Se puede suprimir el pitido al establecer conexin o problemas de DHCP ([.IDT_IDCHB_DHCLIENTBEEP Alertas audibles de DHCLIENT])
- Puede seleccionarse que dhclient.exe pueda escribir a un archivo de registro
  en vez de slo a su ventana VIO ([.IDPNL_PROPERTIES_PAGETCPIP2])
- Desbloqueo de archivos durante la instalacin (se incluye un unlock.exe corregido)
- Aadidos readme.txt y archivo por lotes ifc2.cmd
- La va de acceso a wpa__supplicant ahora se muestra en el cuaderno de propiedades (##23)
- Opcin para establecer manualmente el nmero de interfaz lan para dhclient
  (fallo de Genmac cuando estn instalados fxwrap.sys y switch.os2)
- 'Reasociar wpa__supplicant' tras desconexin (funcin experimental)

_*Solucionado:*_
.ul
- Lista de conexiones vaca por haber demasiadas disponibles
- Suprimir rutas y aadir otras despus al alternar entre conexiones WLAN y LAN
  funciona de forma fiable y es independiente de sincronizacin con el proceso
  dhcp en segundo plano
- Bloqueo espordico al suprimir rutas
- Bloqueo con datos de perfil ilegibles (al nombre del perfil daado se aadir daado)
- DHCP ahora funciona con ms de un servidor DHCP (gracias a dhclient de ISC)
- Bloqueo del XCenter/WPS por el proceso dhclient.exe en algunas situaciones
- Los archivos bloqueados se desbloquean automticamente durante la instalacin
- No se guardaba la configuracin de registro para dhclient (##14)
- Se han hecho ms grandes varios dilogos para evitar cortes del texto en
  sistemas que usan fuentes grandes por omisin
- wpa__supplicant se inicia en una ventana ms ancha

.. ----------------------------------------
.3 Versin 3.11 (grupo de usuarios limitado)
.. ----------------------------------------
.an IDPNL_REVISION_311
.
_*Nuevo:*_
.ul
- Modificado el cdigo para no comprobar conflictos de rangos de direcciones
  TCP/IP mientras la interfaz del dispositivo inalmbrico tiene una direccin
  de enlace local (LLA, 169.254/16)
- Aadido [.IDPNL_MOUSEACTIONS acciones del ratn] para abrir el cuaderno de
  propiedades, la bsqueda o el dilogo de perfiles.
- Aadido [.IDPNL_PROPERTIES_PAGEMOUSE propiedades del ratn], que determina
  las acciones del ratn para la doble pulsacin con las teclas modificadoras
  Maysculas, Control o Alt pulsadas tambin
- Aadidas nuevas propiedades [.IDPNL_PROPERTIES_PAGETCPIP2 global] y
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP perfil] para la configuracin del
  [.IDPNL_CONFIGURE_DHCP cliente DHCP]
- Solucionado error en el mdulo GenMac que impeda utilizar cifrado WPA con
  algunos controladores
- Aadida nueva pgina [.IDPNL_PROFILEPROPERTIES_PAGEAUTOSTART] para el perfil
  de conexin
- Solucionado fallo que haca tardar mucho al aadir el nombre del enrutador
  a archivos hosts largos

_*Ayuda en lnea:*_
.ul compact
- [.IDPNL_PROPERTIES_PAGEMOUSE]: aadida informacin sobre nuevas propiedades
  y acciones del ratn
- [.IDPNL_PROPERTIES_PAGETCPIP2]: aadido nuevo panel de propiedades de DHCP
- [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]: aadido nuevo panel para propiedades
  de DHCP
- [.IDPNL_CONFIGURE_DHCP]: aadido panel de configuracin DHCP
- [.IDPNL_PROFILEPROPERTIES_PAGEAUTOSTART]: aadido panel para las nuevas
  propiedades de inicio automtico del perfil de conexin
- [.IDPNL_CONFIGURE_SCRIPT_CMD]: ya no falta el enlace a [.FN_VAR_IPADDRESS WLAN__IPADDRESS]
- [.IDPNL_CONFIGURE_SCRIPT_REXX]: ya no falta el enlace a [.FN_VAR_IPADDRESS WLan.__IPADDRESS]

.. ----------------------------------------
.3 Versin 3.10
.. ----------------------------------------
.an IDPNL_REVISION_310
.
_*New:*_
.ul
- Aadido cdigo para establecer una direccin de conexin local (169.254/16)
  para la interfaz TCP/IP del dispositivo de red inalmbrica al desconectarse.
  Esto evita problemas cuando se utiliza el protocolo *NetBIOS sobre TCP/IP*.
  Esta caracterstica puede desactivarse en la pgina de propiedades
  [.IDPNL_PROPERTIES_PAGETCPIP].
- Aadidas nuevas [.IDPNL_MOUSEACTIONS]; pulsar una o ms teclas modificadoras
  mientras se hace una doble pulsacin con el primer botn del ratn abre ciertos
  dilogos o lleva a cabo determinadas acciones.
- Aadida nueva pgina de propiedades [.IDPNL_PROPERTIES_PAGEWPASUPP] y el
  correspondiente submen *[=IDT_IDMEN_WPASUPP]*, permitiendo hacer
  visible el agente WPA y determinar su nivel de salida para depuracin.
- Se aumenta la prioridad del Agente WPA a Servidor de Primer Plano para que
  el intercambio de claves WPA funcione en la mayora de los casos incluso
  cuando hay activas aplicaciones intensivas de CPU.
  El elemento *[=IDT_IDMEN_WPASUPP_RECFG]* del men *[=IDT_IDMEN_WPASUPP]*
  permite al agente WPA reconectar en caso de que el intercambio de claves siga
  fallando.
- Aadida entrada *[=IDT_IDMEN_IPCFG_PING]* al men *[=IDT_IDMEN_IPCFG]*.
- Aadidas [.IDPNL_PROPERTIES_PAGETCPIP Propiedades de TCP/IP]
  *[=IDT_IDCHB_GATEWAYNAME]* y *[=IDT_IDTXT_GATEWAYNAME]* para permitir la
  adicin del enturador LAN inalmbrico al archivo %ETC%\hosts de forma que
  siempre se pueda acceder a l con el mismo nombre.
- Dilogo [.IDPNL_PROFILE] renombrado y rehecho, ahora se puede seleccionar
  un perfil de conexin desde l.
- [.IDPNL_HOTSPOT_SCAN Dilogo de bsqueda] extendido para poder cerrarlo
  pulsando la tecla Escape.

_*Solucionado:*_
.ul
- Error del Mdulo de Interfaz con el Controlador GenMac, a veces devolva un
  indicador de intensidad de seal mayor del 100%.
- Error del agente WPA que podra retrasar la conexin con un punto de acceso
  al utilizar determinados controladores GenMac.
- Error que impeda conectarse a un punto de acceso con el controlador GenPrism
  al no utilizar cifrado.
- Ahora se detiene el proceso en segundo plano del cliente DHCP cuando se
  desconecta la antena de radio si se configuraba mediante DHCP la interfaz
  TCP/IP del dispositivo inalmbrico. Esto permite [.IDPNL_CONFIGURE_SWITCH]
  adecuadamente.
- Las [.IDPNL_PROFILEPROPERTIES_PAGESECURITY claves WEP] introducidas en
  formato hexadecimal ahora tambin pueden empezar con *0X* (x mayscula).
- El [=TITLE] ya no abortar si la propiedad [=IDT_IDTXT_WPAPSK] especificada
  para *[=IDT_IDSTR_WEPMODE_WPA_PSK]* o *[=IDT_IDSTR_WEPMODE_WPA2_PSK]* en la
  pgina [.IDPNL_PROFILEPROPERTIES_PAGESECURITY] tiene ms de 43 caracteres
  (el mximo permitido es de 63).
- Manejo de DHCP rehecho, impidiendo que se realicen las solicitudes DHCP dos
  veces.
- Error que impeda conectarse a un punto de acceso con el controlador GenPrism
  al no utilizar cifrado bajo determinadas circunstancias.

_*Ayuda en lnea:*_
.ul compact
- [.IDPNL_MOUSEACTIONS]: aadida informacin sobre las nuevas acciones del
  ratn.
- [.IDPNL_PROPERTIES_PAGETCPIP]: aadida informacin sobre las nuevas
  propiedades *[=IDT_IDCHB_GATEWAYNAME]* y *[=IDT_IDTXT_GATEWAYNAME]*.
- [.IDPNL_PROPERTIES_PAGEWPASUPP]: aadida nueva pgina de propiedades.
- [.IDPNL_PROFILE]: panel rehecho, y aadida informacin sobre el nuevo
  botn *[=IDT_IDPBS_SELECTPROFILE]*.

.. ----------------------------------------
.3 Versin 3.00
.. ----------------------------------------
.an IDPNL_REVISION_300
.
_*Nuevo:*_
.ul
- Ahora se soporta cifrado WPA y WPA2 con los dispositivos inalmbricos
  compatibles con [.IDPNL_PREREQUISITES GenMac].
- Ahora se desconfigura la interfaz TCP/IP del dispositivo inalmbrico al
  inicio si se desactiva la antena de radio al inicio y se configura la interfaz
  TCP/IP en ese momento.
- Cuando la interfaz TCP/IP del dispositivo de red inalmbrico se determina
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP manualmente], desde el dilogo de
  [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP ms opciones TCP/IP] se puede
  configurar el tamao MTU, especialmente para conexiones DSL.
- Aadida nueva [.IDPNL_PROPERTIES_PAGETCPIP propiedad TCP/IP]
  *[=IDT_IDCHB_TRIGGERWAN]*.
- Aadido nuevo valor *[=IDT_IDSTR_CONFLRESOLVE_AUTO]* a la
  [.IDPNL_PROPERTIES_PAGETCPIP propiedad TCP/IP] *[=IDT_IDTXT_CONFLRESOLVE]*.
  Necesario para [.IDPNL_CONFIGURE_SWITCH].

_*Solucionado:*_
.ul
- Ahora se restablece correctamente la interfaz TCP/IP del dispositivo de red
  inalmbrica para configuraciones estticas al reactivar la antena de radio.
- [.IDPNL_CONFIGURE_SCRIPT Ejecutar archivo de proceso por lotes al
  conectar] ahora se realiza cuando la interfaz TCP/IP queda disponible.
- Se ha corregido el esquema original de clculo de la intensidad de seal
  en porcentaje en el Mdulo de Interfaz con el Controlador GenMac (Driver
  Interface Module, DIM).
- Cuando ocurre un conflicto de rangos de direccin TCP/IP durante un
  [.IDPNL_CONFIGURE_HYBRID cambio de conexin por cable a inalmbrica a
  la misma red o viceversa], las rutas existentes para la interfaz TCP/IP
  que se vayan a desconfigurar ahora se suprimen y se redefinen despus para
  la interfaz TCP/IP que quede.

_*Ayuda en lnea:*_
.ul compact
- [.IDPNL_MAIN]: aadida nota sobre el agente WPA.
- [.IDPNL_PREREQUISITES]: aadida informacin sobre los requisitos para el
  cifrado WPA.
- [.IDPNL_PROFILEPROPERTIES_PAGESECURITY]: aadida informacin sobre el
  cifrado WPA.
- [.IDPNL_PROPERTIES_PAGETCPIP]: aadida informacin sobre la nueva propiedad
  *[=IDT_IDCHB_TRIGGERWAN]*.
- [.IDPNL_PROPERTIES_PAGETCPIP]: aadida informacin sobre la nueva propiedad
  *[=IDT_IDTXT_CONFLRESOLVE]*.
- [.IDPNL_CONFIGURE_SECURITY]: aadida informacin sobre el cifrado WPA
- [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]: aadida informacin sobre la
  configuracin de la MTU.
- [.IDPNL_CONFIGURE_SCRIPT]: corregida la informacin sobre la ejecucin de los
  archivos de proceso por lotes.
- [.IDPNL_CONFIGURE_SWITCH]: cambiada la recomendacin de establecer la
  propiedad *[=IDT_IDTXT_CONFLRESOLVE]* de
  *[=IDT_IDSTR_CONFLRESOLVE_KEEPOTHER]* a *[=IDT_IDSTR_CONFLRESOLVE_AUTO]*.
- [.IDPNL_LIMITATIONS]: rehecho.
- [.IDPNL_CREDITS_GENERAL]: aadidos varios agradecimientos ms.

.. ----------------------------------------
.3 Versiones anteriores
.. ----------------------------------------
.an IDPNL_REVISION_214
.
La informacin referente a los cambios entre versiones anteriores a la 3.00
slo se encuentra disponible en las versiones alemana o inglesa de esta ayuda.

.. ################
.include trademarks.esp
.. ################

.. =============================================================================
.2 Agradecimientos
.. =============================================================================
.an IDPNL_CREDITS
.
[=TOPICS]
.su V30

.. ----------------------------------------
.3 Agradecimientos generales
.. ----------------------------------------
.an IDPNL_CREDITS_GENERAL
.
Nuestro agradecimiento a:
.ul
- Jouni Malinen [mailto:jkmaline@cc.hut.fi] por crear el
.sl
  - [http://hostap.epitest.fi agente WPA].
.el
- Jonas Buys por probar el funcionamiento del [=TITLE].
- Robert Lalla por su ayuda con el esquema de clculo de intensidad de seal en
  porcentaje en el mdulo de interfaz del controlador (Driver Interface Module,
  DIM) de GenMac.
- Hermann Ulrichsktter por probar el DIM de GenMac y solucionar un fallo en l,
  as como sus sugerencias para extender la ayuda en lnea.
- Thorolf Godawa por probar el DIM y sus informes de errores.

.. ----------------------------------------
.3 Traduccin
.. ----------------------------------------
.an IDPNL_CREDITS_TRANSLATORS
.
Las siguientes personas han apoyado el proyecto [=TITLE]
traduciendo sus fuentes a los idiomas respectivos:

.pl tsize=15 break=none
- *Idioma*
= *Traductor*
- Alemn
= Christian Langanke [mailto:cla@clanganke.de]
- Espaol
= Alfredo Fernndez Daz [mailto:mrwarper@yahoo.es]
.. - Francs
.. = Guillaume Gay [mailto:guillaume.gay@bigfoot.com]
- Italiano
= Gabriele Gamba [mailto:ggamba@tiscali.it]
- Neerlands
= Jan van der Heide [mailto:j.van.der.heide@hccnet.nl]
- Sueco
= Bjrn Sderstrm [mailto:bjorso@bjorso.com]

.. =============================================================================
.2 Apndice: ejemplos de archivo por lotes
.. =============================================================================
.an IDPNL_APPENDIXSCRIPT
.
[=TOPICS]
.su V30

.. ----------------------------------------
.3 Ejemplo de archivo por lotes CMD
.. ----------------------------------------
.an IDPNL_APPENDIXSCRIPT_CMD
.fo off
.textinclude xwlancmd.cmd
.fo on

.. ----------------------------------------
.3 Ejemplo de programa REXX
.. ----------------------------------------
.an IDPNL_APPENDIXSCRIPT_REXX
.fo off
.textinclude xwlanrx.cmd
.fo on

.. =============================================================================
.2 Apndice: utilizar iconos de estado propios
.. =============================================================================
.an IDPNL_APPENDIXOWNBITMAPS
.in __dragdrop
.
Los iconos de estado personalizados deben ser proporcionados como archivos de
imagen dentro de una carpeta, en la que estos archivos deben llamarse de cierta
forma. En estas condiciones, el juego de iconos de esta carpeta puede
[.IDPNL_CHANGEBITMAPS cargarse] en el [=TITLE].

No es absolutamente necesario proporcionar un archivo de imagen para todos los
iconos de estado en este directorio. En este caso los iconos correspondientes a
los archivos que falten no se modificarn.

Los archivos de la carpeta deben incluir mapas de bits de 1616 y/o 2020
pxeles, donde la imagen utilizada para mostrar cada smbolo se determina por
.ul compact
- la(s) imgen(es) que contenga el archivo y
- el [.IDPNL_PROPERTIES_PAGEDISPLAY tamao configurado] (1616 o 2020 pxeles)

Cuando un archivo personalizado para uno de los iconos de estado no contenga
una imagen del tamao configurado, se reescalar otra imagen existente hasta el
tamao configurado. Ya que para ello se utiliza una funcin interna del
Presentation Manager, el resultado puede no ser muy esttico, de modo que
probablemente sea mejor opcin proporcionar una imagen del tamao deseado.

Adems, los archivos de imagen deben tener los siguientes nombres para que
se utilicen
.
(para facilitar la orientacin, se muestran aqu los iconos estndar):
.pl break=none tsize=5
-
.bi wlan-nocard.bmp
= NoCard.bmp
-
.bi wlan-nodriver.bmp
= NoDriver.bmp
-
.bi wlan-disabled.bmp
= Disabled.bmp
-
.bi wlan-ipdisabled.bmp
= IpDisabled.bmp
-
.bi wlan-nonet.bmp
= NotConnected.bmp
-
.bi wlan-searching.bmp
= Searching.bmp
-
.bi wlan-scanning.bmp
= Scanning.bmp
-
.bi wlan-configuring.bmp
= Configuring.bmp
-
.bi wlan-script.bmp
= Script.bmp
-
.bi wlan-100.bmp
= Connected100.bmp
-
.bi wlan-80.bmp
= Connected80.bmp
-
.bi wlan-60.bmp
= Connected60.bmp
-
.bi wlan-40.bmp
= Connected40.bmp
-
.bi wlan-20.bmp
= Connected20.bmp
-
.bi wlan-nodataaccess.bmp
= NoDataAccess.bmp
