#define INCL_BASE
#include <os2.h>

#include <stdio.h>
#include <process.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>

/*
   PASCAL string: the string is preceded by 1 byte identifying the string length
   there is NO zero terminator terminating the string !
*/
typedef struct _pascal_string
{
   unsigned char len;
   char string[255];
} pascal_string;
#pragma pack()

#define HF_STDOUT 1UL
#define BUFLEN    4192UL

char pipe[BUFLEN];
char keyword[64];
char value[256];

unsigned long _Pascal GetDescription(pascal_string *out, pascal_string *in)
{
   HFILE hw=NULLHANDLE,hr=NULLHANDLE,hscr = HF_STDOUT,hsav = -1;
   APIRET apiRC;
   ULONG ulRead;
   char *line = NULL;
   char buf[256], *p=buf;
   unsigned long rc = 1;
   struct stat s;
  
   /* check pointer arguments */
   if (out == NULL) {
      return rc;
   }
   if (in == NULL) {
      return rc;
   }

   /* check the passed in string: */
   /* check if it's the name of an ordinary file and if that file exists */
   /* if not, quit with error */
   sprintf(p,"%.*s",in->len,in->string);
   memset(&s,0,sizeof(s));
   if (-1 == stat(p,&s) || !(s.st_mode & S_IFREG)) {
      return rc;
   }

   /* create a pipe to redirect stdout */
   apiRC = DosCreatePipe( &hr, &hw,BUFLEN);

   /* save original stdout and redirect stdout to the pipe's write handle */
   apiRC = DosDupHandle(HF_STDOUT,&hsav);
   apiRC = DosDupHandle(hw,&hscr);

   /* run bldlevel.exe app, wait for it to finish and capture its output */
   _spawnlp(P_WAIT,"bldlevel.exe","bldlevel.exe",p,NULL);

   /* close the pipe's write handle, restore stdout handle */
   apiRC = DosClose(hw);
   apiRC = DosDupHandle(hsav,&hscr);
   apiRC = DosClose(hsav);

   /* read from pipe */
   ulRead = 0UL;
   apiRC = DosRead(hr,pipe,sizeof(pipe)-1,&ulRead);
   if ((apiRC == NO_ERROR) && ulRead) {
      /* get a line out of the output */
      line = strtok(pipe,"\r\n");
      while (line) {
         /* separate first word from rest of line */
         if (2 == sscanf(line,"%s%*[ \t]%255[^\r\n]",keyword,value))
         {
            /* if first word is keyword "Signature:" we have found
               the line we are interested in, return back the rest
               of the line as the description string
               and leave the loop
            */
            if (0 == strcmp(keyword,"Signature:")) {
               out->len = sprintf(out->string,"%.255s",value);
               rc = 0;
               break;
            }
         }
         line = strtok(NULL,"\r\n");
      }
   }

   /* close the pipe's read handle */
   apiRC = DosClose(hr);

   return rc;
}
