# ArcaMapper GUI for OS/2 systems.
#
%define _topdir x:/Home/rpm/arcamapper
%define _unpackaged_files_terminate_build 0
%define version 0.9.6
%define release 0
%define src_ver %{version}-%{release}
%define prefix %{_prefix}
%define repo_ver 263

%define __requires_exclude ^ndcalls\\\.dll$


###### Base package info ######

Summary: ArcaMapper LAN client user interface
Name: arcamapper-ui
Version: %{version}
Release: %{release}
License: Various
Group: Networking/Other
#Source: %{name}-%{version}.zip
%scm_source svn https://svn.arcanoae.com/arcamapper/trunk %{repo_ver}
Requires: libc libgcc-fwd libgcc libcx libstdc++
Requires: heimdal heimdal-libs
BuildRequires: gcc
BuildRequires: libc-devel
BuildRoot: %{_topdir}/BUILDROOT/%{name}-%{version}-%{release}
BuildArch: i686

%define help_dir %{_datadir}/os2/help
%define data_dir %{_datadir}/arcamapper
%define lang_dir %{_datadir}/os2/lang
%define doc_dir %{_defaultdocdir}/%{name}-%{version}


%description
ArcaMapper UI is a set of user interface tools for the ArcaOS LAN client
based on NetDrive and the NDPSMB plugin.


###### Qt UI package info ######

%package qt

Requires: arcamapper-ui >= %{version}
Requires: libqt4-gui
BuildRequires: qt4-devel-kit
Summary: ArcaMapper LAN client user interface, Qt based
Group: Networking/Other

%description qt
A Qt-based graphical user interface for ArcaMapper UI, the ArcaOS LAN
client based on NetDrive and the NDPSMB plugin.



###### Common setup ######

%prep
%scm_setup


%build
make all


%install
rm -rf $RPM_BUILD_ROOT
echo Copying files to $RPM_BUILD_ROOT ...
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{doc_dir}
mkdir -p $RPM_BUILD_ROOT%{lang_dir}
mkdir -p $RPM_BUILD_ROOT%{help_dir}
mkdir -p $RPM_BUILD_ROOT%{data_dir}/debug
mkdir -p $RPM_BUILD_ROOT%{data_dir}/gui
mkdir -p $RPM_BUILD_ROOT%{data_dir}/locale
cp install/*.ico $RPM_BUILD_ROOT%{data_dir}/gui
cp browse/browse.exe $RPM_BUILD_ROOT%{_bindir}
cp browse/browse.map $RPM_BUILD_ROOT%{data_dir}/debug
cp browse/browse.sym $RPM_BUILD_ROOT%{data_dir}/debug
cp browse/language/*.qm $RPM_BUILD_ROOT%{data_dir}/locale
cp browse/help/browse*.hlp $RPM_BUILD_ROOT%{help_dir}
cp connect/connect.exe $RPM_BUILD_ROOT%{_bindir}
cp connect/connect.map $RPM_BUILD_ROOT%{data_dir}/debug
cp connect/connect.sym $RPM_BUILD_ROOT%{data_dir}/debug
cp connect/language/*.qm $RPM_BUILD_ROOT%{data_dir}/locale
cp connect/help/connect*.hlp $RPM_BUILD_ROOT%{help_dir}
cp credman/credman.exe $RPM_BUILD_ROOT%{_bindir}
cp credman/credman.map $RPM_BUILD_ROOT%{data_dir}/debug
cp credman/credman.sym $RPM_BUILD_ROOT%{data_dir}/debug
cp credman/language/*.qm $RPM_BUILD_ROOT%{data_dir}/locale
cp credman/help/credman*.hlp $RPM_BUILD_ROOT%{help_dir}
cp ntlmcred/ntlmcrsv.exe $RPM_BUILD_ROOT%{_bindir}
cp ntlmcred/ntlmcrsv.map $RPM_BUILD_ROOT%{data_dir}/debug
cp ntlmcred/ntlmcrsv.sym $RPM_BUILD_ROOT%{data_dir}/debug
cp ntlmcred/LICENSE.ntlmcrsv $RPM_BUILD_ROOT%{doc_dir}/LICENSE.ntlmcrsv
cp pmcred/pmcred.exe $RPM_BUILD_ROOT%{_bindir}
cp pmcred/pmcred.map $RPM_BUILD_ROOT%{data_dir}/debug
cp pmcred/pmcred.sym $RPM_BUILD_ROOT%{data_dir}/debug
cp pmcred/credmmri.dll $RPM_BUILD_ROOT%{_libdir}
cp pmcred/credmmri.map $RPM_BUILD_ROOT%{data_dir}/debug
cp net/net.cmd $RPM_BUILD_ROOT%{_bindir}
cp net/net_nd.exe $RPM_BUILD_ROOT%{_bindir}
cp net/net_s.exe $RPM_BUILD_ROOT%{_bindir}
cp net/net_*.msg $RPM_BUILD_ROOT%{lang_dir}
cp net/net_nd.map $RPM_BUILD_ROOT%{data_dir}/debug
cp net/net_s.map $RPM_BUILD_ROOT%{data_dir}/debug
cp LICENSE.txt $RPM_BUILD_ROOT%{doc_dir}/LICENSE.txt
cp common/GPL.txt $RPM_BUILD_ROOT%{doc_dir}/GPL.txt
cp common/LGPL.txt $RPM_BUILD_ROOT%{doc_dir}/LGPL.txt


%files
%defattr(-,root,root,-)
%dir %{doc_dir}
%dir %{data_dir}
%dir %{lang_dir}
%dir %{data_dir}/debug
%{_bindir}/net.cmd
%{_bindir}/net_nd.exe
%{_bindir}/net_s.exe
%{_bindir}/ntlmcrsv.exe
%{_bindir}/pmcred.exe
%{_libdir}/credmmri.dll
%{data_dir}/debug/ntlmcrsv.*
%{data_dir}/debug/net_nd.*
%{data_dir}/debug/net_s.*
%{data_dir}/debug/pmcred.*
%{data_dir}/debug/credmmri.*
%{lang_dir}/net_*.msg
%license %{doc_dir}/LICENSE.ntlmcrsv
%license %{doc_dir}/GPL.txt
%license %{doc_dir}/LGPL.txt
%license %{doc_dir}/LICENSE.txt


%files qt
%dir %{doc_dir}
%dir %{data_dir}
%dir %{data_dir}/gui
%dir %{data_dir}/locale
%dir %{data_dir}/debug
%{_bindir}/browse.exe
%{_bindir}/connect.exe
%{_bindir}/credman.exe
%{data_dir}/gui/*
%{data_dir}/locale/*
%{data_dir}/debug/browse.*
%{data_dir}/debug/connect.*
%{data_dir}/debug/credman.*
%doc %{help_dir}/browse*.hlp
%doc %{help_dir}/connect*.hlp
%doc %{help_dir}/credman*.hlp


%clean
rm -rf $RPM_BUILD_ROOT


###### Base package post-install ######

%post -e
if [ "$1" -ge 1 ]; then # (upon update)
    %wps_object_delete_all
fi
%wps_object_create_begin
ARCAMAP_FOLDER:WPFolder|ArcaMapper^Network Connections|<WP_CONNECTIONSFOLDER>|ICONVIEW=FLOWED,VISIBLE,NORMAL;TREEVIEW=LINES,VISIBLE,MINI;DEFAULTSORT=-2;ALWAYSSORT=NO;ICONFILE=((%{data_dir}/gui/folder1.ico));ICONNFILE=((%{data_dir}/gui/folder2.ico));
ARCAMAP_LOGON:WPProgram|Manage Credentials|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/pmcred.exe));PROGTYPE=PM;
%wps_object_create_end

# Update CONFIG.SYS
#
m1=$(md5sum "%%{os2_config_sys}")
%cube {ADDLINE "RUN=%%{os2_unixroot_path}\usr\bin\ntlmcrsv.exe" (AFTER} %%{os2_config_sys} >nul
%cube {ADDSTRING "%%{os2_unixroot_path}\usr\share\os2\help;" IN "SET HELP=" (ALL AFTER} %%{os2_config_sys} >nul
%cube {ADDSTRING "%%{os2_unixroot_path}\usr\share\os2\lang;" IN "SET DPATH=" (ALL AFTER} %%{os2_config_sys} >nul
m2=$(md5sum "%%{os2_config_sys}")
if [ "$m2" != "$m1" ]; then
    echo; echo "NOTE:"
    echo; echo "CONFIG.SYS has been updated. You will need to reboot your computer"
    echo "in order to activate these changes."
    echo
fi
# Start the credential daemon
cmd /c detach ntlmcrsv.exe


###### Qt UI package post-install ######

%post qt -e
if [ "$1" -ge 1 ]; then # (upon update)
    %wps_object_delete_all -n %{name}-qt
fi
%wps_object_create_begin
ARCAMAP_LOGON:WPProgram|Logon^(New Credentials)|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/credman.exe));PROGTYPE=PM;
ARCAMAP_LOGOFF:WPProgram|Active Credentials^(Manage)|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/credman.exe));PROGTYPE=PM;PARAMETERS=/manage;ICONFILE=((%{data_dir}/gui/logoff.ico));
ARCAMAP_CONNECT:WPProgram|New Connection|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/connect.exe));PROGTYPE=PM;
ARCAMAP_MANAGE:WPProgram|Manage Connections|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/connect.exe));PROGTYPE=PM;PARAMETERS=/manage;ICONFILE=((%{data_dir}/gui/manage.ico));
ARCAMAP_RESTORE:WPProgram|Restore Connections|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/connect.exe));PROGTYPE=PM;PARAMETERS=/restore;ICONFILE=((%{data_dir}/gui/restore.ico));
ARCAMAP_PREFS:WPProgram|Preferences|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/connect.exe));PROGTYPE=PM;PARAMETERS=/pref;ICONFILE=((%{data_dir}/gui/manage.ico));
ARCAMAP_BROWSER:WPProgram|Network Browser|<ARCAMAP_FOLDER>|EXENAME=((%{_bindir}/browse.exe));PROGTYPE=PM;
%wps_object_create_end


###### Base package post-uninstall ######

%postun
if [ "$1" -eq 0 ]; then # (upon removal)
    %wps_object_delete_all -n %{name}
fi
m1=$(md5sum "%%{os2_config_sys}")
%cube {DELLINE "RUN=%%{os2_unixroot_path}\usr\bin\ntlmcrsv.exe" (ALL} %%{os2_config_sys} >nul
# No need to delete the HELP and DPATH entries from CONFIG.SYS
m2=$(md5sum "%%{os2_config_sys}")
if [ "$m2" != "$m1" ]; then
    echo; echo "NOTE:"
    echo; echo "CONFIG.SYS has been updated. You will need to reboot your computer"
    echo "in order to activate these changes."
    echo
fi


###### Qt UI package post-uninstall ######

%postun qt
if [ "$1" -eq 0 ]; then # (upon removal)
    %wps_object_delete_all -n %{name}-qt
fi


