#include <QFile>
#include <QDebug>
#include <QProcess>

int main( int argc, char *argv[] )
{
    qint64 bytes;
    QProcess tool;
    QByteArray data;

    QFile f( "test.ui" );
    if( f.open( QIODevice::ReadOnly ) ) {
        data = f.readAll();
        f.close();
    }
    qDebug() << data.size() << "bytes read from file.";

    tool.start("7ZA.EXE", 
	       QStringList() << "a" << "test.7z" << "-simyfile.ui", 
	       QIODevice::ReadWrite);

    tool.waitForStarted();
    qDebug() << "started";

    for( int i = 0; i < 10; i++ )
    {
      tool.waitForBytesWritten(-1);
      bytes = tool.write(data);
      qDebug() << bytes << "bytes written to child process.";
    }

    tool.closeWriteChannel();
    qDebug() << "waiting...";

    if (tool.waitForFinished()) {
        qDebug() << "finished";

        data = tool.readAllStandardOutput();
        qDebug() << "done.\n";
	qDebug() << data;

        qDebug() << "\nstderr";
	qDebug() << tool.readAllStandardError();

    } else {
        qDebug() << "failed:" << tool.errorString();
        tool.kill();
    }

    return 0;
}

