//----------------------------------------------------------------------//
//                                                                      //
//                                                                      //
//                                                                      //
//                                                                      //
//----------------------------------------------------------------------//

#ifndef FILECRYPTER_H
#define FILECRYPTER_H

#include <QProcess>


class FileCrypter
{
    QString     m_tool;
    QString     m_pswd;
    int         m_exitCode;

public:
    FileCrypter( const QString &tool = QString() );

    void    setPassword( const QString &pswd );

    bool    getToolVersion( QString &version );

    bool    listFiles( const QString &archiveName,
                       const QStringList &suffixes,
                       QStringList &fileList );

    bool    open( const QString &archiveName, const QString &fileName,
                  bool bExtract, bool bBinary, QProcess &worker );

    void    close( QProcess &worker );

    int     exitCode() const    { return m_exitCode; };
};


#endif // FILECRYPTER_H
