/*
 *   Testcase to show getsockname, getpeername not working high memory
 *
 *   The example will work when conn is allocated below 512MB. It will
 *   fail with error "Bad address" when compiling with -Zhigh-mem
 */


#include	<stdio.h>
#include	<stdlib.h>

#include	<io.h>
#include	<net/if.h>
#include	<sys/socket.h>



typedef struct
{
   int			fd;
   struct sockaddr_in	dstAddr, srcAddr;
   int			dalen, salen;

} CONNECTION;



int main(void)
{
    CONNECTION	*conn;
    int		a1, a2;

    conn = (CONNECTION *)malloc(sizeof(CONNECTION));
    memset(conn, 0, sizeof(CONNECTION));

    conn->fd = socket(PF_INET, SOCK_STREAM, 0);
    if( conn->fd != -1 )
    {
	printf("socket created, conn @0x%08lx\n", conn);


	// insert a valid IP address and port (i.e. soemthing we
	// can connect to) here ...
	conn->dstAddr.sin_addr.s_addr = htonl((192 << 24) | (168 << 16) | (62 << 8) | 228);
	conn->dstAddr.sin_port        = htons(5432);
	conn->dstAddr.sin_family      = AF_INET;


	if( connect(conn->fd, (struct sockaddr *)&conn->dstAddr, sizeof(conn->dstAddr)) != -1 )
	{
	    conn->salen = sizeof(conn->srcAddr);
	    if( getsockname(conn->fd, (struct sockaddr *)&conn->srcAddr, &conn->salen) < 0 )
	    {
		perror("getsockname failed");
		memset(&conn->srcAddr, 0, sizeof(conn->srcAddr));
	    }

	    conn->dalen = sizeof(conn->dstAddr);
	    if( getpeername(conn->fd, (struct sockaddr *)&conn->dstAddr, &conn->dalen) < 0 )
	    {
		perror("getpeername failed");
		memset(&conn->dstAddr, 0, sizeof(conn->dstAddr));
	    }

	    a1 = ntohl(conn->srcAddr.sin_addr.s_addr);
	    a2 = ntohl(conn->dstAddr.sin_addr.s_addr);

	    printf("%u.%u.%u.%u -> %u.%u.%u.%u\n",
		   (a1 >> 24) & 0xff, (a1 >> 16) & 0xff, (a1 >> 8) & 0xff, a1 & 0xff,
		   (a2 >> 24) & 0xff, (a2 >> 16) & 0xff, (a2 >> 8) & 0xff, a2 & 0xff);
	}
	else	perror("not connected");

	close(conn->fd);
    }
    else	perror("socket not created");

    return 0;
}


