//----------------------------------------------------------------------//
//									//
//									//
//----------------------------------------------------------------------//

#define		INCL_PM
#include	<os2.h>
#include	"dive.h"

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<malloc.h>


class OS2DiveBlitter
{
    HWND	hwnd;

    HDIVE	hDive;
    RECTL	rcScreen;
    ULONG	cbScanLine;
    ULONG	ctBitsPerPixel;
    FOURCC	fccScreen;

    PBYTE	pFrameBuffer;

    static ULONG arMapTable[3][256];


public:
    OS2DiveBlitter();
    ~OS2DiveBlitter();

    BOOL	open(HWND hWindow);
    VOID	close(BOOL fShutdown);

    BOOL	blit(HPS hps, PBYTE pBits,
		     PBITMAPINFOHEADER2 pBmih,
		     PRECTL rcSrcUpdate = NULL,
		     int nDstOffsX = 0, int nDstOffsY = 0);
};





#ifndef		TESTBED

extern "C" {
  BOOL APIENTRY WinSetVisibleRegionNotify(HWND hwnd, BOOL fEnable);
  ULONG APIENTRY WinQueryVisibleRegion(HWND hwnd, HRGN hrgn);
}

ULONG OS2DiveBlitter::arMapTable[3][256];

#define mmioFOURCC( ch0, ch1, ch2, ch3 )                         \
		  ( (ULONG)(BYTE)(ch0) | ( (ULONG)(BYTE)(ch1) << 8 ) |    \
		  ( (ULONG)(BYTE)(ch2) << 16 ) | ( (ULONG)(BYTE)(ch3) << 24 ) )

#define FOURCC_R565  mmioFOURCC( 'R', '5', '6', '5' )
#define FOURCC_R555  mmioFOURCC( 'R', '5', '5', '5' )
#define FOURCC_R664  mmioFOURCC( 'R', '6', '6', '4' )


#ifndef	bswap32
  #define bswap32(a)	(((a) >> 24) | ((a) << 24) | \
			 (((a) << 8) & 0x00ff0000) | (((a) >> 8) & 0x0000ff00))
#endif


//----------------------------------------------------------------------//
//									//
//----------------------------------------------------------------------//

OS2DiveBlitter::OS2DiveBlitter()
{
    ULONG	u;
    DIVE_CAPS	Caps;

    ctBitsPerPixel = 0;
    hDive = NULLHANDLE;
    memset(arMapTable, 0, sizeof(arMapTable));

    memset(&Caps, 0, sizeof(Caps));
    Caps.ulStructLen = sizeof(Caps);

    if( DiveQueryCaps(&Caps, DIVE_BUFFER_SCREEN) == DIVE_ERR_INSUFFICIENT_LENGTH )
    {
	printf("DiveCaps.fScreenDirect: %d\n", (int)Caps.fScreenDirect);
	printf("DiveCaps.fBankSwitched: %d\n", (int)Caps.fBankSwitched);
	printf("DiveCaps.ulWidth: %d\n", (int)Caps.ulHorizontalResolution);
	printf("DiveCaps.ulHeight: %d\n", (int)Caps.ulVerticalResolution);
	printf("DiveCaps.ulDepth: %d\n", (int)Caps.ulDepth);
	printf("DiveCaps.ulScanLineBytes: %d\n", (int)Caps.ulScanLineBytes);
	printf("DiveCaps.fccColorEncoding: %.4s\n", (char *)&Caps.fccColorEncoding);

	if( Caps.fScreenDirect && !Caps.fBankSwitched )
	{
	    cbScanLine       = Caps.ulScanLineBytes;
	    ctBitsPerPixel   = Caps.ulDepth;
	    rcScreen.xLeft   = 0;
	    rcScreen.yBottom = 0;
	    rcScreen.xRight  = Caps.ulHorizontalResolution;
	    rcScreen.yTop    = Caps.ulVerticalResolution;
	    fccScreen        = Caps.fccColorEncoding;

	    switch( fccScreen )
	    {
	      case FOURCC_R565:
		for( u = 0; u < 256; u++ )
		{
		   arMapTable[0][u] = (u >> 3) << 0;
		   arMapTable[1][u] = (u >> 2) << 5;
		   arMapTable[2][u] = (u >> 3) << 11;
		}
		break;

	      case FOURCC_R555:
		for( u = 0; u < 256; u++ )
		{
		   arMapTable[0][u] = (u >> 3) << 0;
		   arMapTable[1][u] = (u >> 3) << 5;
		   arMapTable[2][u] = (u >> 3) << 10;
		}
		break;

	      case FOURCC_R664:
		for( u = 0; u < 256; u++ )
		{
		   arMapTable[0][u] = (u >> 2) << 0;
		   arMapTable[1][u] = (u >> 2) << 6;
		   arMapTable[2][u] = (u >> 4) << 12;
		}
		break;
	    }
	}
    }
}


//----------------------------------------------------------------------//
//									//
//----------------------------------------------------------------------//

OS2DiveBlitter::~OS2DiveBlitter()
{
    close(TRUE);
}


//----------------------------------------------------------------------//
//									//
//----------------------------------------------------------------------//

BOOL OS2DiveBlitter::open(HWND hWindow)
{
    if( ctBitsPerPixel <= 8 )
    {
       return FALSE;
    }

    if( !hDive && DiveOpen(&hDive, FALSE, &pFrameBuffer) != 0 )
    {
       return FALSE;
    }

    hwnd = hWindow;

    return TRUE;
}


//----------------------------------------------------------------------//
//									//
//----------------------------------------------------------------------//

VOID OS2DiveBlitter::close(BOOL fShutdown)
{
    if( fShutdown && hDive )
    {
//printf("DiveClose\n");
	DiveClose(hDive);	hDive = NULLHANDLE;
    }

    hwnd = NULLHANDLE;
}


//----------------------------------------------------------------------//
//									//
//----------------------------------------------------------------------//

BOOL OS2DiveBlitter::blit(HPS hps, PBYTE pBits,
			  PBITMAPINFOHEADER2 pBmih,
			  PRECTL rcSrcUpdate, int nDstOffsX, int nDstOffsY)
{
  HRGN		hrgn;
  ULONG		u, rc;
  RGNRECT	RgnCtl;
  PUSHORT	pusTemp;
  PRECTL	arRgnRects;
  PUCHAR	pDst, pSrc;
  RECTL		rcWindow, rcClip;
  LONG		cyWndHeight, ctRows, ctCols, i;

//  if( pBmih->cbFix < FIELDOFFSET(BITMAPINFOHEADER2, ulCompression) )
  if( pBmih->cbFix < (ULONG) (&((PBITMAPINFOHEADER2)NULL)->ulCompression) )
  {
     return FALSE;
  }

  if( pBmih->cPlanes != 1 || pBmih->cBitCount != 32 )
  {
     return FALSE;
  }


  if( hwnd && (hrgn = GpiCreateRegion(hps, 0, NULL)) != NULLHANDLE )
  {
      if( WinQueryVisibleRegion(hwnd, hrgn) != RGN_ERROR )
      {
	GpiQueryClipBox(hps, &rcClip);
	rcClip.xRight++;
	rcClip.yTop++;

	RgnCtl.ircStart    = 1;
	RgnCtl.crc         = 0;
	RgnCtl.crcReturned = 0;
	RgnCtl.ulDirection = RECTDIR_LFRT_BOTTOP;

	if( GpiQueryRegionRects(hps, hrgn, &rcClip, &RgnCtl, NULL) )
	{
//printf("VisibleRgn: %u rects\n", RgnCtl.crcReturned);

	   if( RgnCtl.crcReturned )
	   {
	     arRgnRects = (PRECTL)alloca(RgnCtl.crcReturned * sizeof(RECTL));
	     RgnCtl.crc = RgnCtl.crcReturned;
	     RgnCtl.crcReturned = 0;

	     GpiQueryRegionRects(hps, hrgn, &rcClip, &RgnCtl, arRgnRects);

//printf("VisibleRgn2: %u rects\n", RgnCtl.crcReturned);

	     WinQueryWindowRect(hwnd, &rcWindow);
	     WinMapWindowPoints(hwnd, HWND_DESKTOP, (PPOINTL)&rcWindow, 2);
	     cyWndHeight = rcWindow.yTop - rcWindow.yBottom;

	     rc = DiveAcquireFrameBuffer(hDive, &rcScreen);
	     if( rc == 0 )
	     {
//	       printf("--- %d,%d  %d,%d\n", rcScreen.xLeft, rcScreen.yBottom, rcScreen.xRight, rcScreen.yTop);

		for( u = 0; u < RgnCtl.crcReturned; u++ )
		{
		  // I don't know, why...
		  arRgnRects[u].xRight--;
		  arRgnRects[u].yBottom++;

		  arRgnRects[u].xLeft  -= nDstOffsX;
		  arRgnRects[u].xRight -= nDstOffsX;
		  arRgnRects[u].yTop    = cyWndHeight - arRgnRects[u].yTop - nDstOffsY;
		  arRgnRects[u].yBottom = cyWndHeight - arRgnRects[u].yBottom - nDstOffsY;
/*
printf("  %u: %d,%d  %d,%d\n", u,
       arRgnRects[u].xLeft, arRgnRects[u].yTop,
       arRgnRects[u].xRight, arRgnRects[u].yBottom);
*/
		  if( arRgnRects[u].xLeft < rcSrcUpdate->xLeft )
			arRgnRects[u].xLeft = rcSrcUpdate->xLeft;

		  if( arRgnRects[u].xRight > rcSrcUpdate->xRight )
			arRgnRects[u].xRight = rcSrcUpdate->xRight;

		  if( arRgnRects[u].yTop < rcSrcUpdate->yTop )
			arRgnRects[u].yTop = rcSrcUpdate->yTop;

		  if( arRgnRects[u].yBottom > rcSrcUpdate->yBottom )
			arRgnRects[u].yBottom = rcSrcUpdate->yBottom;

/*
printf("  %u: %d,%d  %d,%d\n", u,
       arRgnRects[u].xLeft, arRgnRects[u].yTop,
       arRgnRects[u].xRight, arRgnRects[u].yBottom);
*/

		  ctRows = arRgnRects[u].yBottom - arRgnRects[u].yTop + 1;
		  ctCols = arRgnRects[u].xRight - arRgnRects[u].xLeft + 1;

//  printf("Rect%u: Rows: %d, Cols: %d\n", u, ctRows, ctCols);

		  if( ctCols > 0 && ctRows > 0 && pBits )
		  {
		    pSrc = (PUCHAR)&pBits[arRgnRects[u].xLeft * 4 +
				  arRgnRects[u].yTop * pBmih->cx * 4];

		    pDst = (PUCHAR)&pFrameBuffer[
			     ((rcWindow.xLeft + arRgnRects[u].xLeft + nDstOffsX) * ctBitsPerPixel) / 8 +
			     (rcScreen.yTop - rcWindow.yTop + arRgnRects[u].yTop + nDstOffsY) * cbScanLine];

		    if( ctBitsPerPixel == 32 )
		    {
			if( (UCHAR)fccScreen == 'B' )	// BGR32
			    do
			    {
				for( i = 0; i < ctCols; i++ )
				{
				    *(PULONG)pDst = *(PULONG)pSrc;
				    pSrc += 4;	pDst += 4;
				}

				pSrc += (pBmih->cx - ctCols) * 4;
				pDst += cbScanLine - (ctCols * 4);

			    } while( --ctRows );
			else				// RGB3
			    do
			    {
				for( i = 0; i < ctCols; i++ )
				{
				    *(PULONG)pDst = bswap32(*(PULONG)pSrc) >> 8;
				    pSrc += 4;	pDst += 4;
				}

				pSrc += (pBmih->cx - ctCols) * 4;
				pDst += cbScanLine - (ctCols * 4);

			    } while( --ctRows );
		    }
		    else if( ctBitsPerPixel == 24 )
		    {
			// RGB24, BGR24 not supported

		    }
		    else if( ctBitsPerPixel == 16 )
		    {
			// R565, R555, R664
			do
			{
			    pusTemp = (PUSHORT)pDst;
			    for( i = 0; i < ctCols; i++ )
			    {
			       *pusTemp++ = (USHORT)(arMapTable[0][pSrc[0]] |
						     arMapTable[1][pSrc[1]] |
						     arMapTable[2][pSrc[2]]);
			       pSrc += 4;
			    }

			    pSrc += (pBmih->cx - ctCols) * 4;
			    pDst += cbScanLine;

			} while( --ctRows );
		    }
		  }

		}

		DiveDeacquireFrameBuffer(hDive);
	     }
	   }

	}
      }

      GpiDestroyRegion(hps, hrgn);
    }

    return TRUE;
}


#endif

