//  (C) Copyright John Maddock 2001 - 2003. 
//  (C) Copyright Darin Adler 2001. 
//  (C) Copyright Douglas Gregor 2002. 
//  Use, modification and distribution are subject to the 
//  Boost Software License, Version 1.0. (See accompanying file 
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org for most recent version.

//  generic BSD config options:

#if !defined(__OS2__) 
#error "This platform is not OS/2"
#endif

#define BOOST_PLATFORM "OS2 " BOOST_STRINGIZE(__OS2__)

//
// is this the correct version check?
// FreeBSD has <nl_types.h> but does not
// advertise the fact in <unistd.h>:
//

#  define BOOST_HAS_NL_TYPES_H

//
// FreeBSD 3.x has pthreads support, but defines _POSIX_THREADS in <pthread.h>
// and not in <unistd.h>
//
#  define BOOST_HAS_PTHREADS
#  define BOOST_HAS_PTHREAD_YIELD
//
// No wide character support in the BSD header files:
//
#define BOOST_NO_CWCHAR
#define BOOST_NO_CWCTYPE
#define BOOST_IOSTREAMS_NO_WIDE_STREAMS
#define BOOST_NO_STD_WSTRING

//
// The BSD <ctype.h> has macros only, no functions:
//
#if !defined(__OpenBSD__)
#  define BOOST_NO_CTYPE_FUNCTIONS
#endif

//
// thread API's not auto detected:
//
#define BOOST_HAS_NANOSLEEP
#define BOOST_HAS_GETTIMEOFDAY
#define BOOST_HAS_SIGACTION


// some EAI_ definitions
#define EAI_SERVICE EPROTOTYPE
#define EAI_SOCKTYPE ESOCKTNOSUPPORT
#define EAI_AGAIN EAGAIN
#define EAI_BADFLAGS EINVAL
#define EAI_FAIL ECONNABORTED
#define EAI_FAMILY EAFNOSUPPORT
#define EAI_MEMORY EOVERFLOW
#define EAI_NONAME EHOSTUNREACH
#define EAI_NODATA EAI_NONAME

#ifndef NI_MAXHOST
#define NI_MAXHOST 1025
#endif

#ifndef NI_MAXSERV
#define NI_MAXSERV 32
#endif

// boilerplate code:
#define BOOST_HAS_UNISTD_H
#include <boost/config/posix_features.hpp>






