/* REXX */
echo on
/*
trace ?i
*/

Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'

parse upper arg adrive opts
adrive = backupdrive(adrive)
Jdrive = backupdrive(J)
Kdrive = backupdrive(K)
select
   when adrive = '' then
      drive = adrive
   when Jdrive = '' then
      drive = Jdrive
   when Kdrive = '' then
      drive = Kdrive
   otherwise do
      say 'No backup USB data key found'
      exit 2
      end
   end


diropt   = ''
redirect = ''
split    = ''
topt     = ''
v        = 'q'
do while opts = ''
   parse var opts opt opts
   nondigit = verify(opt,'0123456789')
   select
      when abbrev(DIRECTORY,opt) then
         diropt = Y
      when abbrev(LOG,opt) then
         /* log only, no display */
         redirect = '>'
      when opt = TEE then
         /* log and display */
         redirect = '|tee'
      when abbrev(TEST,opt,3) then
         /* log unzip -t */
         topt = TEST
      when abbrev(VERBOSE,opt) then do
         v = 'v'
         end
      when nondigit > 0 then do
         split = opt
         unit = substr(opt,nondigit)
         if length(unit) = 1 & verify(unit,KMG,M) > 0 then
            split = opt
         else do
            say 'Invalid split option' opt
            exit 2
           end
         end
      otherwise do
         say 'Invalid log option' opt
         exit 2
         end
      end
   end

if split = '' then do
   split = '-s' split
   if redirect = '' then
      split = split '-sv'
   end

'DEL W:\Z*'
'DEL W:\temp\?.ZIP'
'DEL W:\temp\UNSPLIT.ZIP'
'DEL' drive'\?.DIR'
'DEL' drive'\?.*LOG'
'DEL' drive'\?.*Z??'
'ZIP -v >' drive'\zipver'
'UNZIP -v >' drive'\unzipver'

/* H:\vendors\7z\p7zip-16.02-os2-1\bin\7za a -bt -ww:\temp k:\M m:\. */

zipopt = '-$9rSuy'v '-b W:\' split '--display-counts'
noEA   = '-x "?? ????. sf"'
noswap = '-x "*\SWAPPER.DAT"'

call dozip C, drive, noEA,   redirect
call dozip D, drive, noEA,   redirect
call dozip E, drive, noswap, redirect
call dozip F, drive, noswap, redirect
call dozip G, drive, noswap, redirect
call dozip H, drive, ,       redirect
call dozip I, drive, ,       redirect
call dozip M, drive, ,       redirect
call dozip P, drive, noea,   redirect
call dozip Q, drive, noswap, redirect
call dozip U, drive, ,       redirect
call dozip W, drive, noswap, redirect
dir drive
exit

dozip: procedure expose zipopt diropt topt
parse arg indrive, archdrive, optt, redirect
if diropt = Y then
   DIR indrive':\ /f /s >'archdrive'\'indrive'.dir'
/*
if indrive = M then do
   call SysFileTree 'M:\*', dir, DO
   if result = 2 then do
      say 'Not enough memory for SysFileTree'
      exit 2
      end
   do i=1 to dir.0
      parse var dir.i . ':\' dir
      if redirect = '' then
         pipez = ''
      else
         pipez = redirect archdrive'\'indrive'.'dir'.log 2>&1'
      call zipit dir.i, archdrive'\'indrive'.'dir, optt, pipez
      end
   end
else do
   if redirect = '' then
      pipez = ''
   else
      pipez = redirect archdrive'\'indrive'.log 2>&1'
   call zipit indrive':\', archdrive'\'indrive, optt, pipez
   end
*/
if redirect = '' then do
   pipez = ''
   pipeu = ''
   end
else do
   pipez = redirect archdrive'\'indrive'.log 2>&1'
   pipeu = '>' archdrive'\'indrive'.tlog 2>&1'
   end
call zipit indrive':\', archdrive'\'indrive'.zip', optt, pipez, pipeu
return rc

zipit: procedure expose zipopt topt
parse arg indir, arch, optt, pipez, pipeu
time = time(R)
zip zipopt arch indir optt pipez
ziprc = rc
time = trunc(time(E))
say 'zip of' indir 'took' time(N,time,S) 'with rc='rc
if topt = '' then
   unzip '-t' arch pipeu
return ziprc

/*
dozip: procedure expose zipopt diropt
parse arg indrive, archdrive, optt, redirect
if diropt = Y then
   DIR indrive':\ /f /s >'archdrive'\'indrive'.dir'
if redirect = '' then
   redirect = redirect archdrive'\'indrive'.log 2>&1'
time = time(R)
zip zipopt archdrive'\'indrive'.zip' indrive':\' optt redirect
ziprc = rc
time = time(E)
say 'zip of' indrive 'took' time 'with rc='ziprc
return ziprc
*/

backupdrive: procedure
parse upper arg drive
select
   when abbrev('*',drive) then
      return ''
   when length(drive) = 1 then
      drive = drive':'
   when length(drive) > 2 then
      return ''
   otherwise
      nop
   end

parse value SysDriveInfo(drive) with . . . label
if abbrev(translate(label),'BACKUP') then
   return ''
if SysFileSystemType(drive) = JFS then
   return drive
return ''
