:userdoc.
:docprof toc=1.
:title.Testcases for double quotes
:h1 id=1 clear.Testing reftype=launch
:p.
Launching an external application (testing 2.19.b2 - 2.19.b3)&colon.
:p.
1) :link reftype=launch object='view.exe' data='cmdref xcopy'.xcopy:elink. (ok - crash)
:p.
2) :link reftype=launch object='view.exe' data='cmdref net view'.net view:elink. (ok - crash)
:p.
3) :link reftype=launch object='view.exe' data='cmdref "net view"'."net view":elink. (ok - crash)
:p.
4) :link reftype=launch object='view.exe' data='cmdref /s:net view'./s&colon.net view:elink. (not ok, as expected - crash)
:p.
5) :link reftype=launch object='view.exe' data='cmdref /s:"net view"'./s&colon."net view":elink. (not ok - crash)
:p.
6) :link reftype=launch object='view.exe' data='cmdref /s:""net view""'./s&colon.""net view"":elink. (not ok - crash)
:p.
7) :link reftype=launch object='view.exe' data='cmdref /s:"""net view"""'./s&colon."""net view""":elink. (not ok - crash)
:p.
8) :link reftype=launch object='epm.exe' data='\config.sys'.epm.exe \config.sys:elink. (ok - crash)
:p.
9) :link reftype=launch object='epm.exe' data='"\config.sys"'.epm.exe "\config.sys":elink. (not ok - crash)
:p.
:hp2.NewView 2.19.b2 :ehp2.
:p.
For every link above, where the link data contains :hp2.double
quotes:ehp2., all double quotes where doubled. 2.19.b2 shows that on
its status bar and it could be proved when making EPM's commandline
parameters visible.
:p.
:hp2.NewView 2.19.b3 :ehp2.
:p.
That version shows the double quotes correctly on its status bar! But
the executable and the parameters for it are separated with an
:hp2.ampersand:ehp2. sign instead of a space. The example 9) shows also
that the :hp2.backslash:ehp2. is doubled, what worked correct with
2.19.b2.
:h1 id=2 clear.Commandline parsing&colon. double quotes
:p.
Executing the following lines in CMD.EXE (testing 2.19.b2 - 2.19.b3)&colon.
:p.
1) start NewView cmdref xcopy (ok - ok)
:p.
2) start NewView cmdref net view (ok - ok, many thanks for fixing this, Ronald!)
:p.
3) start NewView cmdref "net view" (ok - ok)
:p.
4) start NewView cmdref /s&colon.net view (not ok - not ok, as expected)
:p.
5) start NewView cmdref /s&colon."net view" (not ok - not ok)
:p.
6) start NewView cmdref /s&colon.""net view"" (not ok - not ok)
:p.
7) start NewView cmdref /s&colon."""net view""" (works - works)
:p.
:hp2.Notes&colon.:ehp2.  For calling NewView with its extended search
(using the /s parameter), a string of multiple words has to be enclosed
with :hp2.tripled double quotes:ehp2., like shown in example 7). This
was changed with 2.19.b2, IIRC.
:p.
For earlier NewView versions, just the closing double quote had to be
doubled. Moreover, example 2) works since 2.19.b2.
:euserdoc.
