/* Enhanced OPEN -- open objects via commandline and more
   Copyright (C) 1998-2003, 2010 Herwig Bauernfeind

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.          */

/* Register RexxUtil, try to register RxExtras */
call _LoadOtherFuncs

/* say Hello */
Version = '2.4.0'
say 'OPEN Version 'version', (c) Copyright 1998-2003, 2010 by Herwig Bauernfeind.'

/* get commandline arguments, handle quotes */
parse arg CmdLine

if pos('"', CmdLine) > 0 then parse value CmdLine with '"'Object'"' ' 'OtherCMDLineParms
                         else parse value CmdLine with Object OtherCMDLineParms

/* if no arguments (or point only) assume current directory */
/* if compiled arg() return 1 even if there is no argument, therefore the
   extended check */
if arg() = 0 | (arg()=1 & arg(1)='') then Object = '.' 
if Object = '.' then Object = directory()

/* Check if user wants help */
if Object = '/?' | Object = '-?' | Object = '?' then signal _helpscreen

/* Check if parameter is an object ID */
isObjectID = (left(Object,1) = '<')

/* Check if parameter is a URL */
isURL = pos('HTTP:',translate(Object)) | pos('HTTPS:',translate(Object)) | pos('FTP:',translate(Object))
if isURL then URLNameStart = pos(':',Object)

/* Assume no destroy */
DestroyIt = 0

/* Assume no root */
isRoot = 0

if \isObjectID & \isURL then do /* it is not an object ID and not a URL */
    if right(Object,2) = ':\' then do /* check for root */
        isRoot = 1
    end
    else do /* if ':\' is not there, assume current directory */
        if SubStr(Object, 2, 2) <> ':\' then do
            NewObject = directory()
            if left(Object,1) \= '\' & substr(NewObject,length(NewObject),1) \= '\' 
                then NewObject = NewObject'\'
            Object = NewObject||Object
        end
    end
end

if \isURL then do 
    /* Do we have a directory ? */
    ok = SysFileTree(strip(Object,'T','\'), DirInfo., 'DO')
    if isRoot then isDirectory = 1
    else do /* Check for non-root directory */
        isDirectory = (DirInfo.0 = 1)
        if isDirectory then Object = DirInfo.1
    end
end
else do	/* we use Ulrich Mllers netscDDE for URLs */
    '@netscDDE 'left(Object,URLNameStart)'//'substr(Object,URLNameStart+1)
	exit 0
end
    
/* Handle other parameters stuff */
OtherCMDLineParms = ' '||translate(OtherCMDLineParms)||' '
OtherEnvVarParms  = ' '||value('OPEN',,'OS2ENVIRONMENT')||' '
OpenMode          = ''
WPS               = ''
Answer            = ''
Recurse           = ''

/* Get values from from environment var */
if (pos(' W',OtherEnvVarParms) > 0) then WPS    = 'W'
if (pos(' A',OtherEnvVarParms) > 0) then Answer = 'A'
if (pos(' Y',OtherEnvVarParms) > 0) then Answer = 'Y'
if (pos(' E',OtherEnvVarParms) > 0) then Answer = 'E' /* dangerous */
if (pos(' R',OtherEnvVarParms) > 0) then Recurse= 'S'

/* Override environment var by commandline */
if (pos(' W',OtherCMDLineParms) > 0) then WPS    = 'W'
if (pos(' A',OtherCMDLineParms) > 0) then Answer = 'A'
if (pos(' Y',OtherCMDLineParms) > 0) then Answer = 'Y'
if (pos(' E',OtherCMDLineParms) > 0) then Answer = 'E'
if Answer \= '' then say 'Assuming "'Answer'" on all answers.'
if (pos(' R',OtherCMDLineParms) > 0) then Recurse= 'S'

/* Get open mode from environment variable */
select
    when pos(' D',OtherEnvVarParms) > 0 then OpenMode = 'DETAILS'
    when pos(' S',OtherEnvVarParms) > 0 then OpenMode = 'SETTINGS'
    when pos(' I',OtherEnvVarParms) > 0 then OpenMode = 'ICON'
    when pos(' N',OtherEnvVarParms) > 0 then OpenMode = 'NAVIGATE'
    when pos(' V',OtherEnvVarParms) > 0 then OpenMode = 'SPLITVIEW'
    when pos(' T',OtherEnvVarParms) > 0 then if isDirectory | isObjectID  
        then OpenMode = 'TREE'                                             
        else OpenMode = 'TEXT'                                             
    otherwise OpenMode = ''
end

/* Override environment var openmode by commandline */
select
    when pos(' D',OtherCMDLineParms) > 0 then OpenMode = 'DETAILS'
    when pos(' S',OtherCMDLineParms) > 0 then OpenMode = 'SETTINGS'
    when pos(' I',OtherCMDLineParms) > 0 then OpenMode = 'ICON'
    when pos(' N',OtherCMDLineParms) > 0 then OpenMode = 'NAVIGATE'
    when pos(' V',OtherCMDLineParms) > 0 then OpenMode = 'SPLITVIEW'
    when pos(' T',OtherCMDLineParms) > 0 then if isDirectory | isObjectID
        then OpenMode = 'TREE'
        else OpenMode = 'TEXT'
    otherwise if OpenMode = '' then OpenMode = 'DEFAULT'
end

if isObjectID | isDirectory then do /* directory or object ID */
    call _openobj /* just open it */
end
else do /* we have one or more file(s), obviously */
    /* override invalid view selections */
    if pos(OpenMode, 'DETAILS ICON NAVIGATE TREE SPLITVIEW SETTINGS') > 0 then do
        OpenMode = 'DEFAULT'
        say 'Invalid view selected, using 'OpenMode' instead.'
    end
    /* Check number of files */
    ok = SysFileTree(Object, FileInfo., 'FO'||Recurse)
    /* if Recurse <> '' then say 'Recursing into subdirectories.' */
    /* no matching files available ? */
    if (FileInfo.0 = 0) & (pos('*',Object) = 0) & (pos('?',Object) = 0) then do
        say 'File "'filespec('N', Object) ||'" does not exist.'
        call charout ,'Create it? [y]es [N]o  '
        if Answer = '' then Key = translate(SysGetKey('NOECHO'))
                       else Key = Answer /* This is a bit dirty (No A/N check) */
        say Key
        if Key = 'Y' then do
            call charout Object, ''
            call charout Object
            call _openobj
        end
    end
    else do
        /* No matching files, wildcards have been provided, error obviously */
        if FileInfo.0 = 0 then say 'No objects match pattern of "'filespec('N',Object)'".'
        else do /* we have files, let's process them, that's why we are here */
            if FileInfo.0 > 1 then say FileInfo.0' files match pattern of "'filespec('N',Object)'".'
            /* Open first file without asking (I like it that way) */
            OpenIt = 1
            do I = 1 to FileInfo.0
                Object = FileInfo.I
                if OpenIt then call _openobj
                if I < FileInfo.0 then do /* ask for further files */
                    J = I + 1
                    call charout, 'Open next file "'filespec('N',FileInfo.J)'"? [Y]es [n]o [a]bort [e]rase '
                    if Answer = '' then Key = translate(SysGetKey('NOECHO'))
                                   else Key = Answer
                    call charout ,Key
                    if Key = 'A' then do; say; leave; end
                    if Key = 'E' then do
                        call charout , '. Are you sure? [yN]'
                        SureKey = translate(SysGetKey('NOECHO'))
						if SureKey = 'Y' then do
                            parse value SysCurPos() with row col
                            ok = SysCurPos(row,0)
                            ok = SysDestroyObject(FileInfo.J)
                            if Ok then do
                                say left('Destroyed object "'filespec('N',FileInfo.J)'" successfully.',79)
                                OpenIt = 0
                                Iterate
                            end
                            else do
                                say 'Failed to destroy "'filespec('N',FileInfo.J)'"'
                                OpenIt = 0
                            end
                        end
                        else do
                            say 'Aborted.'
                            iterate
                        end
                    end
                    if Key = 'N' then do; say; OpenIt = 0; end
                    else do
                        parse value SysCurPos() with row col
                        ok = SysCurPos(row,0)
                        OpenIt = 1
                    end
                end
            end
        end
    end
end

/* we are done, bye, bye */
exit 0

_LoadOtherFuncs: /* Load libraries */
    /* Register RexxUtil */
    call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL','SysLoadFuncs'
    call SysLoadFuncs

    /* Check for RxExtras */
    RxExtrasAPI = RxFuncQuery('RxSwitchTo')
    /* Try to register it */
    if RxExtrasAPI then do
        Registered = RxFuncAdd('RxExtra', 'RxExtras', 'RxExtra')
        if Registered = 0 then call RxExtra 'Load'
    end
    UseRxSwitchTo = \RxFuncQuery('RxSwitchTo')
return

_openobj: /* Open objects subroutine */
    if isObjectID | isDirectory then ObjectName = Object
    else do
        ObjectName = filespec('N',Object)
        ObjectPath = filespec('D',Object)||filespec('P',Object)
    end
    if Recurse <> '' then say 'Path: "'ObjectPath'"'
    call charout, 'Opening object "'ObjectName'" in 'OpenMode' view'
    ok = SysSetObjectData(Object, "OPEN="OpenMode";")
    if \ok then call charout , ', failure'
    else do
        call charout , ', success'
        if WPS = 'W' then do
            say ', switching to desktop.'
            if UseRxSwitchTo then do
                ok = RxQuerySwitchList(OpenEntries.)
                Last = OpenEntries.0
                ok = RxSwitchTo(OpenEntries.Last)
            end
            /* Does not work for abstract objects and folders */
            else call SysSetObjectData Object, "OPEN="OpenMode";"
        end
        else say '.           '
    end
return

_helpscreen: /* Our ultra informative helpscreen */
    say 'It comes with ABSOLUTELY NO WARRANTY! This is free software under the General'
    say 'Public License and you are welcome to redistribute it. Read the file COPYING.'
    say 
    say 'Usage: OPEN [ Dir | File | "<ObjID>" | URL*)] [View] [WPS] [Answer] [Recurse]'
    say	'                             *) Omit // for URL, otherwise opening will fail!'
    say 'Second parameter determines, which kind of view should be opened:'
    say
    say '    D or DETAILS   opens Details view'
    say '    I or ICON      opens Icon view'
    say '    N or NAVIGATE  opens Object Navigator from Object Desktop'
    say '    V or SPLITVIEW opens Split View from xWorkplace'
    say '    S or SETTINGS  opens Settings view'
    say '    T or TREE/TEXT opens Tree or Text view'
    say
    say 'Further parameters:'
    say
    say '    W or WPS       switches to the desktop'
    say '    Y or YES       assume Yes on all answers'
    say '    A or ABORT     assume Abort (or No) on all answers'
    say '    R or RECURSE   searches and opens files in subdirectories'
    say '    E or ERASE     deletes file instead of opening it'
    say
    say 'Parameters are case insensitive, object has to be first, order of other'
    say 'parameters does not matter.'
    exit -1
return
