#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/wait.h>
#include <dlfcn.h>

void issue_fork()
{
    int pid, rc;
    pid = fork();
    if( pid < 0 )
    {
        printf("fork failed, errno=%d\n", errno);
        exit(0);
    } else
    {
        if( pid == 0 )
        {
            /* child */
            printf("I'm child pid=%d\n", getpid());
            exit(0);
        } else
        {
            /* parent */
            printf("I'm parent pid=%d\n", getpid());
            waitpid( pid, &rc, 0);
            printf("child finished\n");
        }
    }

}

int main( int argc, char *argv[] )
{
    void *library;
    void *pfn;

    if( argc > 1 )
    {
        argc= atoi(argv[1]);
    } else
        argc= 0;
    printf("load foo.dll\n");
    library= dlopen("foo.dll", 0);
    if( library )
    {
        pfn= dlsym(library, "_foo");
        printf("foo.dll handle %p; foo() function addr %p\n", library, pfn);
        if( argc > 0 )
        {
            printf("unload foo.dll before fork()\n");
            dlclose(library);
            library= 0;
        }
        if( argc > 1 )
        {
            printf("load foo.dll again fork()\n");
            library= dlopen("foo.dll", 0);
        }
    } else
    {
        printf("dlopen failed\n");
        exit(0);
    }
    issue_fork();
    return 0;
}
