
#define INCL_DOS
#include <os2.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <stdio.h>
#include <time.h>

#include "procstat.h"

int getrusage(int who, struct rusage *usage)
{
	PQPROCSTAT16 	pps;
	PRCTHREAD 		prct;
	ULONG   		timer_interval;

	DosQuerySysInfo(QSV_TIMER_INTERVAL, QSV_TIMER_INTERVAL,
				   (PVOID)&timer_interval, sizeof(ULONG));
	//printf( "QSV_TIMER_INTERVAL %d\n", aulSysInfo[0]);

	if (who != RUSAGE_SELF) {
	   errno = EINVAL;
	   return -1;
	}

	if (prc16GetInfo(&pps) != 0) {
	   errno = EINVAL;
	   return -1;
	}
	
	if (prc16QueryThreadInfo( pps, getpid(), 1, &prct) == TRUE) {
		double	u, s;
		u = 10.0 * prct.ulUserTime / timer_interval;
		s = 10.0 * prct.ulSysTime / timer_interval;
		usage->ru_utime.tv_sec = u;
		usage->ru_utime.tv_usec = (u - usage->ru_utime.tv_sec) * 1000000;
		usage->ru_stime.tv_sec = s;
		usage->ru_stime.tv_usec = (s - usage->ru_stime.tv_sec) * 1000000;
		//printf("user: %d  system: %d\n", prct.ulUserTime, prct.ulSysTime);
	}
	prc16FreeInfo(pps);
	
}

#ifdef MAIN

void main( void)
{
	struct rusage ru;
	clock_t	t1, t2;
	
	while( 1) {
		printf( "clock %d\n", clock());
		getrusage( RUSAGE_SELF, &ru);
		printf( "ru %d,%d\n", ru.ru_utime.tv_sec,ru.ru_utime.tv_usec);  
		t1 = clock();
		while( clock()-t1<CLOCKS_PER_SEC)
			;
		//DosSleep(1*1000);
	}
}

#endif
