#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <fcntl.h>

int main(void)
{
  int rc;
  int fd;
  int status;

  pid_t pid = fork();
  if (pid == -1)
  {
    perror("fork failed");
    return 1;
  }

  if (pid == 0)
  {
    /* Child */

    char tmp[] = "/tmp/tst-urpo-XXXXXX";
    fd = mkstemp(tmp);
//    fd = open(tmp, O_CREAT | O_WRONLY);
    printf("tmp [%s] fd %d\n", tmp, fd);

//    close(fd);
//    unlink(tmp);

    exit(0);
  }

  /* Parent */

  if (waitpid(pid, &status, 0) != pid)
  {
    perror("waitpid failed");
    return 1;
  }

  if (!WIFEXITED(status) || WEXITSTATUS(status))
  {
    puts("child 1 terminated abnormally or with error");
    return 1;
  }

  return 0;
}
