#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

#define MAX_ENV_SIZE (32 * 1024)

int main( int _argc, char *_argv[], char *_envp[])
{
    const char *name = "envtest2.exe";
    const char *argv[ 100 ];
    const char *envp[ 1024 ];
    int   totallen;
    char *env;
    int   envpos;
    int   envsize;
    int   i;
    int   rc = -1;

    for( i = 0; _envp[ i ]; i++ )
        envp[ i ] = _envp[ i ];

    envpos = i;
    envp[ envpos + 1 ] = NULL;

    for( envsize = MAX_ENV_SIZE; rc == -1; --envsize )
    {
        env = calloc( 1, envsize + 1 );

        memset( env, 'K', envsize );

        envp[ envpos ] = env;
 
#if 1
        argv[ 0 ] = "envtest2.exe";
        argv[ 1 ] = NULL;
        rc = spawnvpe( P_WAIT, argv[0], argv, envp );
#else
{
        RESULTCODES res;
        char *envz;
        char *p;

        envz = calloc( 1, 64 * 1024 );
        for( p = envz, i = 0; envp[ i ]; i++ )
        {
            strcpy( p, envp[ i ]);
            p += strlen( envp[ i ]) + 1;
        }

        rc = DosExecPgm( NULL, 0, EXEC_SYNC, "envtest2.exe\0", envz, &res,
                         name );
        if( rc != 0 )
            rc = -1;

        free( envz );
}
#endif
        for( totallen = 0, i = 0; envp[ i ]; ++i )
            totallen += strlen( envp[ i ]) + 1;

        printf("total len = %d, envsize = %d, rc = %d\n",
               totallen, envsize, rc );

        if( rc != -1 )
        {
            FILE *fp;

            fp = fopen("envtest.log", "wt");

            for( i = 0; envp[ i ]; i++ )
            {
                fprintf( fp, "%s\n", envp[ i ]);
            }

            fclose( fp );
        }

        free( env );
    }

    return 0;
}
