#!/bin/sh
#
#
# This can probably be smarter about 
# (like reading an ENV variable)
#
KBUILD_TOP=/export/src/kmk/021907/kmk
#
#############################################
#
# setup the parts we need to bootstrap
# kmk on Solaris
#
# Have to use GNU cp, ln, mv and sed 
# because cp, ln, and mv won't work out
# of any other directory but /usr/bin,
# and solaris's sed is busticated for
# doing sed's configure.
#
# I just make a temporary directory for
# GNU's sed and put that path in front
# so that the sed configure picks it.
# I might be able to do something with
# defining which sed to use, but I've
# already got this working.
#
#############################################
#
SYSBIN=/usr/bin
BSDBIN=/usr/ucb
GNUBIN=/opt/csw/bin
KBUILD_BIN=${KBUILD_TOP}/kBuild/bin
SOLX86BIN=${KBUILD_BIN}/solaris.x86
#
# Create the target/bin directory
#
if [ ! -d ${SOLX86BIN} ];  then
	mkdir -p ${SOLX86BIN}
fi
#
# have to use bash to bootstrap because Solaris has
# no ash. this will have to do in bootstrapping,
#
cp /usr/bin/bash ${SOLX86BIN}/kmk_ash
#
# Use Solaris versions of these commands to
# bootstrap kmk
#
for i in cat echo mkdir rm rmdir
do
	SRCFILE=${SYSBIN}/${i}
	if [ -f ${SRCFILE} ]; then
		cp ${SRCFILE} ${SOLX86BIN}/kmk_${i}
	else
		echo "couldn't find ${SRCFILE}"
	fi
done

# 
# Have to use GNU versions of these commands
# to build kmk due to "Solarisisms".
# 
for i in cp ln mv sed
do
	SRCFILE=${GNUBIN}/g${i}
	if [ -f ${SRCFILE} ]; then
		cp ${SRCFILE} ${SOLX86BIN}/kmk_${i}
	else
		echo "couldn't find ${SRCFILE}"
	fi
done
#
# cheat and use /usr/ucb/install just because it does
# the right things
#
for i in install
do
	SRCFILE=${BSDBIN}/${i}
	if [ -f ${SRCFILE} ]; then
		cp ${SRCFILE} ${SOLX86BIN}/kmk_${i}
	else
		echo "couldn't find ${SRCFILE}"
	fi
done
#
# Have to put GNU's sed in front of the /usr/bin/sed
# so that sed's configure will complete.
#