/****************************** Module Header *******************************
*
* Module Name: FM2Assocs.cmd
*
****************************************************************************/
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

signal on novalue                                  /* for debug purposes */

call setlocal

GlobalVars = 'action interactive av2_objecthandle ext_list tables. env pgm_name TRUE FALSE'

call Init                                          /* Initialize variables */

tracevar =  value('JBSTRACE',, env)                /* for debug purposes */
if tracevar == "" then
   tracevar = 'n'
trace value tracevar

parse arg args                                     /* Process parameters, if any */
call ProcessArgs translate(strip(args))

call ReadBB2File

if interactive = TRUE then
   do
      do until action >= 0 & action <= 5
         call Heading
         say 'The program allows one to set or remove associations for FM/2.'
         say
         say 'Currently the only associations this program will handle are'
         say "associations of archiver extensions, like *.ZIP, with FM/2's"
         say "archiver utility, AV/2."
         say
         say 'Options:'
         say '   1) Associate AV/2 with ALL extensions it can handle.'
         say '   2) Make AV/2 the default association for ALL extensions it can handle.'
         say '   3) Remove ALL AV/2 associations.'
         say '   4) One-by-one, set associations for each extension it can handle.'
         say '   5) Quit this program.'
         say
         call charout, 'Enter the number of your choice: '
         action = SysGetKey()
         say
      end
      if action <= 3 then
         interactive = FALSE
   end
if action \= '5' then
   do
      do i = 1 to words(ext_list)
         ext = word(ext_list, i)
         filter = '*.' || ext
         assoc_handle_list = translate(SysIni(, 'PMWP_ASSOC_FILTER', filter), ' ', '00'x)
         if assoc_handle_list = 'ERROR:' then assoc_handle_list = ''
         av2_pos = wordpos(av2_objecthandle, assoc_handle_list)
         if interactive = TRUE then
            do
               call SysCls
               do until (action >= 1 & action <= 5)
                  call Heading
                  say 'Extension:' ext
                  say
                  say 'Current Associations (first is default):'
                  if (assoc_handle_list = '') then
                     say '   None'
                  else
                     do j = 1 to words(assoc_handle_list)
                        handle = word(assoc_handle_list, j)
                        select
                           when handle = av2_objecthandle then
                              say "   FM/2's Archive Utility (" || tables._handle2id.handle || ')'
                           when tables._handle2id.handle = '<ECS_ARCVIEW>' then
                              say "   ECS Archive Viewer (<ECS_ARCVIEW>)"
                           otherwise
                              say '  ' tables._handle2id.handle
                        end
                     end
                  say
                  say 'Options:'
                  say '   1) Associate AV/2 with this extension'
                  say '   2) Make AV/2 the default association for this extension'
                  if av2_pos > 0 then
                     say '   3) Remove the AV/2 association with this extension'
                  else
                     say '   3) N/A'
                  say '   4) Skip this extension (and proceed to the next, if any)'
                  say '   5) Quit'
                  say
                  call charout, 'Enter the number of your choice: '
                  action = SysGetKey()
                  say;say;say
                  if action = 3 & av2_pos = 0 then
                     action = 40
               end
            end
         new_assoc_handle_list = ''
         select
            when action = '1' then
               if av2_pos = 0 then
                  new_assoc_handle_list = assoc_handle_list av2_objecthandle
            when action = '2' then
               if av2_pos \= 1 then
                  do
                     new_assoc_handle_list = av2_objecthandle
                     do j = 1 to words(assoc_handle_list)
                        handle = word(assoc_handle_list, j)
                        if handle \= av2_objecthandle then
                           new_assoc_handle_list = new_assoc_handle_list handle
                     end
                  end
            when action = '3' then
               if av2_pos \= 0 then
                  do
                     do j = 1 to words(assoc_handle_list)
                        handle = word(assoc_handle_list, j)
                        if j \= av2_pos then
                           new_assoc_handle_list = new_assoc_handle_list handle
                     end
                  end
            when action = '4' then
               iterate
            when action = '5' then
               leave i
            otherwise
               nop
         end
         if new_assoc_handle_list \= '' then
            do
               new_assoc_handle_list = space(new_assoc_handle_list) || ' '
               new_assoc_handle_list = translate(new_assoc_handle_list, '00'x, ' ')
               if SysIni(, 'PMWP_ASSOC_FILTER', filter, new_assoc_handle_list) = 'ERROR:' then
                  do
                     say 'Error encountered in updating associations!'
                     '@pause'
                  end
            end
         else
            if action = 3 then
               do
                  new_assoc_handle_list = '00'x
                  if SysIni(, 'PMWP_ASSOC_FILTER', filter, new_assoc_handle_list) = 'ERROR:' then
                     do
                        say 'Error encountered in updating associations!'
                        '@pause'
                     end
               end
      end
   end
   call endlocal
return

ProcessArgs: procedure expose (GlobalVars)
   parse arg args
   if args \= '' then
      do
         select
            when args = '/ASSOCIATEALL' then
               do
                  interactive = FALSE
                  action = 1                       /* Associate extensions with AV/2 */
               end
            when args = '/DEFAULTALL' then
               do
                  interactive = FALSE
                  action = 2                       /* Associate extensions with AV/2 */
               end
            when args = '/REMOVEALL' then
               do
                  interactive = FALSE
                  action = 3                       /* Associate extensions with AV/2 */
               end
            otherwise
               nop
         end
      end
return


Init: procedure expose (GlobalVars)
   env   = 'OS2ENVIRONMENT';
   TRUE  = (1 = 1);
   FALSE = (0 = 1);
   interactive = TRUE

   parse source . . full_pgm_name
   pgm_name = filespec('N', full_pgm_name)
   pgm_name = left(pgm_name, lastpos('.', pgm_name) - 1)
   pgm_dir = filespec('D', full_pgm_name) || filespec('P', full_pgm_name) || '.'
   call directory pgm_dir

   tables.    = ''
   call BuildTables
return

Heading: procedure expose (GlobalVars)
   call SysCls
   say
   say pgm_name || ": FM/2's associations utility"
   say
return

BuildTables: procedure expose (GlobalVars)
   rcx = SysIni(, 'PM_Workplace:Location', 'ALL:', 'objids.')
   do i = 1 to objids.0
      objid = objids.i
      handle = GetObjHandle(objid)
      if objid = '<FM/2_AV/2>' then
         av2_objecthandle = handle
      tables._handle2id.handle = objid
   end
return

GetObjHandle: procedure expose (GlobalVars)
   parse arg objid
   BinObjHandle = reverse(SysIni(, 'PM_Workplace:Location', objid))
   DecObjHandle = c2d(BinObjHandle)
return DecObjHandle

ReadBB2File: procedure expose (GlobalVars)
   ext_list = ''
   BB2File = 'archiver.bb2'
   if stream(BB2File, 'c', 'query exists') = '' then
      do
         call Heading
         say "Fatal error!"
         say
         say "FM/2's archiver definitions file," BB2File || ", cannot be found."
         say
         say "This program cannot run without this file."
         say
         say "Make sure this program and" BB2File "are in the same directory"
         say "and try again."
         exit 1
      end
   line = linein(BB2File)                                   /* Skip past the '21' line */
   do while lines(BB2File) > 0
      do while lines(BB2File) > 0
         line = linein(BB2File)
         select
            when strip(line) = '' then
               iterate
            when left(line, 1) = ';' then
               iterate
            otherwise
               leave
         end
      end
      if lines(BB2File) = 0 then leave
      /* Found start of definition (i.e. description line) */
      ext = translate(strip(linein(BB2File)))               /* extension */
      line = strip(linein(BB2File))                         /* Skip past the sig offset */
      line = strip(linein(BB2File))                         /* list command (w/ parameters) */
      list_cmd = translate(strip(word(line, 1), 'B', '"'))  /* list command (w/o parameters and w/o quotes) */
      if ext \= '' then
         if ((SysSearchPath('PATH', list_cmd) \= '') | (stream(list_cmd, 'c', 'query exists') \= '')) then
            do
               ext_num = wordpos(ext, ext_list)
               if ext_num = 0 then
                  ext_list = ext_list ext
            end
      do 17
         line = linein(BB2File)                             /* Skip past remainder of definition */
      end
   end
   call stream BB2File, 'c', 'close'
return

novalue:
   say 'Unset value on line 'sigl
   say 'Text: 'sourceline(sigl)
   exit
