/* Check wildcard match
 * @parm pszBuf Buffer to check
 * @parm pszWildCard wildcard to match
 * @parm fNotFileSpec TRUE if generic match else filespec match
 * @return TRUE if matched else FALSE
 */

BOOL wildcard(const PSZ pszBuf, const PSZ pszWildCard,
          const BOOL fNotFileSpec)
{
    PSZ fstr = pszBuf;
    PSZ fcard = pszWildCard;

    while( *fstr && *fcard )
    {
        switch( *fcard )
        {
            case '*' :
            {
                PSZ fstr1;

                /* find next non-wild character in wildcard */
                while( *fcard && ( *fcard == '*' || *fcard == '?'))
                    fcard++;

                /* if last char of wildcard is *, it matches */
                if( !*fcard )
                    return TRUE;

                fstr1 = fstr;
                while( *fstr1 )
                {
                    /* skip until partition, match, or eos */
                    while( *fstr1 && toupper( *fstr1 ) != toupper( *fcard ) &&
                           ( fNotFileSpec || ( *fstr1 != '/' && *fstr1 != '\\' )))
                        fstr1++;

                    if( !*fstr1 || ( !fNotFileSpec && ( *fstr1 == '/' || *fstr1 == '\\' )))
                        break;

                    if( wildcard( fstr1, fcard, fNotFileSpec ) == TRUE )
                        return TRUE;

                    fstr1++;
                }

                fstr = fstr1;
                break;
            }

            case '?' :          /* character substitution */
                fcard++;

                if( fNotFileSpec || ( *fstr != '.' && *fstr != '/' && *fstr != '\\'))
                    fstr++;     /* skip (match) next character */
                break;

            default :
                if( fNotFileSpec ||
                    ( *fstr  != '/' && *fstr  != '\\') ||
                    ( *fcard != '/' && *fcard != '\\' ))
                {
                    if( toupper( *fstr ) != toupper( *fcard ))
                        return FALSE;
                }

                fcard++;
                fstr++;
                break;
        }
    }

    if( !*fstr )
    {
        /* remove trailing * and ? */
        while( *fcard && ( *fcard == '?' || *fcard == '*' ))
            fcard++;

        if( !fNotFileSpec )
        {
            /* remove trailing . */
            while( *fcard && *fcard == '.' )
                fcard++;
        }
    }

    return ( *fstr == *fcard );
}

