/*
 * 187functions.cmd
 *
 * 1) Find function declarations in FM3DLL.H
 * 2) Find references to these functions in *.c files
 * 3) Find definitions for these functions in *.c files
 * 4) Summarize data and recommend action(s) for each function
 *
 * Usage:
 * 	187functions [threshhold_number]
 * The optional threshhold number sets the maximum numbers of files which
 * reference a function before this program recommends moving the
 * declaration out of FM3DLL.H. The default threshhold is 5.
 *
 */

signal on novalue

parse arg ref_threshhold
if strip(ref_threshhold) = '' then
   ref_threshhold = 5

function_list_file = 'functions.187'
function_refs_file = 'funcrefs.187'
function_defs_file = 'funcdefs.187'
function_summary_file = 'summary_threshhold' || ref_threshhold || '.187'
call SysFileDelete function_summary_file

grep_find  = '@grep'
grep_count = '@grep -c'

/* Clear the queue */
do while queued() > 0
   parse pull line
end

if stream(function_list_file, 'c', 'query exists') = '' then
	do
      /* Find function declarations in FM3DLL.H */
      find_include_declarations = '-Eno "^[ \t]*([[:alpha:]_][[:alnum:]_]*[ \t]+){1,2}[[:alpha:]_][[:alnum:]_]*[ \t]*\(" dll\fm3dll.h | grep -v "typedef" | rxqueue'
      grep_find find_include_declarations
      f = 0
      do while queued() > 0
         parse pull line
         line = strip(strip(line, 'T', '('))
         f = f + 1
         function.f = word(line, words(line))
      end
      function.0 = f
      say "Functions found:" function.0
      call SysStemSort 'function.'
      do f = 1 to function.0
         call lineout function_list_file, function.f
      end
      call SysFileDelete function_refs_file
      call SysFileDelete function_defs_file
	end
else	
   do
		f = 0
      do while lines(function_list_file) > 0
         f = f + 1
         function.f = linein(function_list_file)
      end
      function.0 = f
      say "Functions found:" function.0
   end
call stream function_list_file, 'c', 'close'

if stream(function_refs_file, 'c', 'query exists') = '' then
	do
      /* Find function references in all *.C files */
      do f = 1 to function.0
         ref_list.f = ''
         defined_in.f = ''
         call lineout function_list_file, function.f
         find_function_ref = '-Erno --include=*.c "\<' || function.f || '\>" . | rxqueue'
         grep_find find_function_ref
         say 'Processing:' function.f
         do while queued() > 0
            parse pull ref_filename ':' .
            if wordpos(ref_filename, ref_list.f) = 0 then
               ref_list.f = ref_list.f ref_filename
         end
         call lineout function_refs_file, function.f ref_list.f
      end
      call SysFileDelete function_defs_file
	end
else	
   do
		f = 0
      do while lines(function_refs_file) > 0
         f = f + 1
         parse value linein(function_refs_file) with . ref_list.f
         defined_in.f = ''
      end
      ref_list.0 = f
   end
call stream function_refs_file, 'c', 'close'

/* Find function definitions */
if stream(function_defs_file, 'c', 'query exists') = '' then
	do
      do f = 1 to function.0
         if ref_list.f = '' then
            call lineout function_defs_file, function.f
         else
            do
            	find_function_alloc_text = '-EnH "^#pragma[ \t]+alloc_text.*\<' || function.f || '\>"' ref_list.f '| rxqueue'
               say 'Grep call:' grep_count find_function_alloc_text
               grep_count find_function_alloc_text
               do while queued() > 0
                  parse pull line
                  say line
                  parse var line def_filename ':' def_count
                  if def_count \= 0 then
                     do
                     	defined_in.f = def_filename
                     	call lineout function_defs_file, function.f def_filename
                     end
               end
               if defined_in.f = '' then
                  do
            			find_function_definition = '-EnH "^[^[:space:]]+[ \t]+\<' || function.f || '[ \t]*\([^;]*$"' ref_list.f '| rxqueue'
            			say 'Grep call:' grep_find find_function_definition
               		grep_find find_function_definition
               		d = 0
                     do while queued() > 0
                        parse pull line
                        parse var line . ':' . ':' pgm_line
                        p = pos('if', pgm_line)
                        if p > 0 then
                        	if p < pos(function.f, pgm_line) then
                        		iterate
                        p = pos('while', pgm_line)
                        if p > 0 then
                        	if p < pos(function.f, pgm_line) then
                        		iterate
                        p = pos('//', pgm_line)
                        if p > 0 then
                        	if p < pos(function.f, pgm_line) then
                        		iterate
                        pgm_line = strip(pgm_line, 'T')
                       	if right(pgm_line, 2) = '&&' | right(pgm_line, 2) = '||' then
                       		iterate
                        d = d + 1
                        def_line.d = line
                     end
                     def_line.0 = d
                     if def_line.0 = 1 then
                        do
                        	parse var def_line.1 defined_in.f ':' .
                        	call lineout function_defs_file, function.f defined_in.f
                        end
                     else if def_line.0 \= 0 then
                        do
                           say '??? Multiple definitions for' function.f
                           do d = 1 to def_line.0
                        		say '   ' def_line.d
                           end
                        	call lineout function_defs_file, function.f '<multiple defs???>'
                        end
                     else
                        do
                        	say '??? Unable to find any definition for' function.f
                        	call lineout function_defs_file, function.f
                        end
                  end
            end
      end
	end
else	
   do
		f = 0
      do while lines(function_defs_file) > 0
         f = f + 1
         parse value linein(function_defs_file) with . defined_in.f
      end
      defined_in.0 = f
   end
call stream function_defs_file, 'c', 'close'

/* Write out a summary */
say '*** Summary ***'
do f = 1 to function.0
   Ref_count = words(ref_list.f)
   call SayAndLog 'Function:' function.f
   call SayAndLog '  Defined in :' defined_in.f
   call SayAndLog '  Ref count  :' ref_count
   call SayAndLog '  Refs       :' ref_list.f
   select
      when ref_count = 0 then
   		call SayAndLog '  Action     : Move declaration into OBSOLETE.H'
      when ref_count = 1 then
         if ref_list.f = defined_in.f then
            call SayAndLog '  Action     : Move declaration, as static, into' defined_in.f
         else
            do
            	call SayAndLog '  Action     : Move declaration, as static, into' ref_list.f
            	call SayAndLog '  Action     : Move definition from' defined_in 'to' ref_list.f
            end
      when ref_count <= ref_threshhold then
         do
            full_include_file = left(defined_in.f, length(defined_in.f) - 1) || 'h'
            p = lastpos('/', full_include_file)
            include_file_path = left(full_include_file, p)
            include_file_name = substr(full_include_file, p + 1)
            include_file_path_len = length(include_file_path)
            call SayAndLog '  Action     : Move declaration to' full_include_file
            do d = 1 to ref_count
               source_file = word(ref_list.f, d)
               if left(source_file, include_file_path_len) = include_file_path then
                  call SayAndLog '  Action     : Add -->#include "' || include_file_name || '"<-- to' source_file
               else
               	call SayAndLog '  Action     : Add -->#include "' || substr(full_include_file, 3) || '"<-- to' source_file
            end
         end
	   otherwise
	   	call SayAndLog '  Action     : N/A (Too many references for threshhold of' ref_threshhold || ')'
   end
end
return

SayAndLog: procedure expose function_summary_file
	parse arg msg
	msg = translate(msg, '\', '/')
	say msg
	call lineout function_summary_file, msg
return

novalue:
   say 'Uninitialized variable: ' || condition('D') || ' on line: 'sigl
   say 'Line text: 'sourceline(sigl)
   exit

