.*
.* eFTE2 user and reference manual -- mrwarper's note to future maintainers
.*
.* This file is adapted from the main HTML documentation and its contents should
.* be synchronized with that after it is updated. So far, both files need to be
.* maintained separately due to lack of appropriate tools.
.*
.* In short, for the manual to be as useful as possible, a number of elements
.* must be linked to one another. While this can be done freely with HTML
.* elements, limitations of IPFC impose that some contents of the document
.* must be duplicate in the IPF source:
.*
.* Single text elements within their section can't be linked to individually, so
.* they are duplicated instead as footnotes (which must also include many 'see
.* also' links). Such notes (most notably reference for individual editing
.* commands and mode settings) have been placed at the end of the section the
.* text they mirror belongs to, and they remain invisible (duplication happens
.* only in the source but not in rendering) until links to them are selected --
.* then they pop up in the right place.
.*
.* They should be locatable searching *in reverse* for :fn id= from header tags
.* :h1-:h6, since these separate sections.
.*
.* In the event that you need to add or modify anything in this file, please
.* take a few extra seconds to repeat that work in the footnotes to make this
.* a quality manual.
.*
:userdoc.
:docprof toc=1234.
:title.eFTE2 user and reference manual

:h1.eFTE2 user and reference manual
:artwork name='eFTE2img\01mancvr.bmp' align='center'.
:p.:lines align='center'.By Alfredo Fernndez Daz, mrwarper@yahoo.es:elines.
:p.November, 2017
.br
Last revision: 2017-11-01

:h1 id='features'.What is eFTE2?

eFTE2 is a :link reftype=hd refid='license'.free:elink. multiplatform text
editor loaded with features that make it the editor of choice of many
programmers and power users alike:

:ul compact.
  :li.It is :link reftype=hd refid='use-Fold'.a :hp2.FOLDING:ehp2. text editor:elink..
  :li.Almost every major feature is customizable:
    :ul compact.
      :li.:link reftype=hd refid='modes'.Editing modes for different file
types:elink. (including C/C++, REXX, Perl, HTML, Java, etc).
      :li.State-machine-based syntax parsing and highlighting.
      :li.Pull-down menus tailored for the current file type.
      :li.Common and mode-specific shortcut keys (with nice CUA defaults).
      :li.Programmable editing :link reftype=hd refid='macros'.macros:elink., which can be linked to both shortcut keys and menus.
    :eul.
  :li.Can operate on multiple files independently.
  :li.Hypertext list of file ":link reftype=hd refid='use-routines'.routines:elink.", as defined in each language.
  :li.Supports :link reftype=hd refid='use-Tags'.ctags:elink..
  :li.Named bookmarks.
  :li.Highlight all occurances of a word.
  :li.Automatically highlights matching symbol when cursor is on any parenthesis, brackets, or braces. Great for nesting checks.
  :li.Most stuff you might expect from any editor worth its salt:
    :ul compact.
      :li.block indenting
      :li.entab/detab
      :li.case changes on text block
      :li.sort lines
      :li.column marking/copying
      :li.call to external programs (such as compiling)
      :li.:link reftype=hd refid='use-regexp'.regular expression:elink. search and replace
      :li.:link reftype=fn refid='def-view'.screen splitting:elink.
    :eul.
  :li.Light and fast, can be used over a remote console / ssh connection (non-GUI versions anyway?).
  :li.Multi-platform (currently OS/2, Win32, and Linux/X11).
:eul.

:h1 id='install'.Installation

This section is devoted to what component files of eFTE2 are supposed to get
installed where.

:p.Installation of eFTE2 should be a simple matter, such as unzip and run,
which gives the end user full control (and responsability!) of which files are
installed where, overwritten, etc.

:p.However, eFTE2 is also distributed in alternate installer packages for
managed installation on modern systems. In those cases, it is up to the user
and system documentations to deal with system installers and their
idiosyncrasies&mdash.we infer if you are reading this, you must have been able
to install the application, or at least unpack it.

:h2 id='install-fte'.Compatibility with old FTE installs

If you want to install eFTE2 directly over an FTE/eFTE install on OS/2 and
not lose your custom configuration changes you can achieve that by installing
only packages 1 and 3 of the WPI to your current install directory.

:p.In the future you should be able to use eFTE2 with the configuration files
of an existing FTE install simply by creating a :font facename='System Monospaced' size=12x8.mymain.fte:font facename='default'. file in
the same directory as your old :font facename='System Monospaced' size=12x8.main.fte:font facename='default'. and setting :font facename='System Monospaced' size=12x8.EFTEDIR:font facename='default'.
to point there. Currently this is not possible in all cases because of an
undocumented change introduced in :link reftype=hd refid='history-eFTE'.eFTE:elink.&colon. before it,
:font facename='System Monospaced' size=12x8.include:font facename='default'.s in the configuration were interpreted as being relative to
the file they were found in, but in eFTE this was changed to 'relative to main
configuration'.

:p.Example: say you have two configuration bits :font facename='System Monospaced' size=12x8.a.fte:font facename='default'. and
:font facename='System Monospaced' size=12x8.b.fte:font facename='default'. under the directory 'menu', and the main configuration includes
"menu/a.fte". FTE would include ":font facename='System Monospaced' size=12x8.b:font facename='default'." from ":font facename='System Monospaced' size=12x8.a:font facename='default'." with
":font facename='System Monospaced' size=12x8.include b.fte:font facename='default'.", but eFTE and current eFTE2 need it to be
":font facename='System Monospaced' size=12x8.include menu/b.fte:font facename='default'.".

:p.This will be changed in the future to help preserving backwards
compatibility in as many cases as possible.

:h2 id='install-required'.Base files

The following files are included in all archives:

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.README2:font facename='default'.
  :dd.Readme file.
  :dt.:font facename='System Monospaced' size=12x8.edefault.fte:font facename='default'.
  :dd.Fallback configuration file. The file :font facename='System Monospaced' size=12x8.edefault.fte:font facename='default'. should be kept in eFTE2's install directory. It provides a basic configuration primarily intended for editing files when the regular configuration is broken.
  :dt.:font facename='System Monospaced' size=12x8.efte2.hlp:font facename='default'.
  :dd.The manual you're reading right now.
  :dt.:font facename='System Monospaced' size=12x8.config\*.fte:font facename='default'.
  :dd.Configuration files.
  :dt.:font facename='System Monospaced' size=12x8.HISTORY:font facename='default'.
  :dd.History of changes.
  :dt.:font facename='System Monospaced' size=12x8.README.efte:font facename='default'.
  :dd.efte readme file.
  :dt.:font facename='System Monospaced' size=12x8.file_id.diz:font facename='default'.
  :dd.Program description for BBS upload.
  :dt.:font facename='System Monospaced' size=12x8.COPYING:font facename='default'.
  :dd.GNU license.
  :dt.:font facename='System Monospaced' size=12x8.Artistic:font facename='default'.
  :dd.Artistic license.
  :dt.:font facename='System Monospaced' size=12x8.AUTHORS:font facename='default'.
  :dd.Contributor credits.
:edl.

:h2 id='install-os2'.On OS/2 / eCS / ArcaOS

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.efte.exe:font facename='default'.
  :dd.VIO console-only executable.
  :dt.:font facename='System Monospaced' size=12x8.eftepm.exe:font facename='default'.
  :dd.PM GUI executable.
:edl.

:p.Suggested installation file paths:

:ul compact.
  :li.%TOOLS%\eFTE\efte.exe
  :li.%TOOLS%\eFTE\eftepm.exe
  :li.%TOOLS%\eFTE\efte2.hlp
  :li.%TOOLS%\eFTE\edefault.fte
  :li.%TOOLS%\eFTE\config\*.fte
  :li.%TOOLS%\eFTE\docs\README.efte
  :li.%TOOLS%\eFTE\docs\HISTORY
  :li.%TOOLS%\eFTE\docs\README2
  :li.%TOOLS%\eFTE\docs\COPYING
  :li.%TOOLS%\eFTE\docs\Artistic
  :li.%TOOLS%\eFTE\docs\AUTHORS
:eul.

:p.Place executable files somewhere on your :font facename='System Monospaced' size=12x8.PATH:font facename='default'.. The configuration
files should be located in the config subdirectory. If you wish to install
the config files somewhere else you may need to SET the EFTEDIR environmental
variable to point to that directory. By default eFTE and eFTEPM look for the
file :font facename='System Monospaced' size=12x8.mymain.fte:font facename='default'. as the root configuration file. All the rest of the
configuration files are 'included' by earlier files. You can name your 'root'
file something else but you will then need to use the :font facename='System Monospaced' size=12x8.-c:font facename='default'. switch
followed by the full pathname for that file. For example:

:xmp.efte -cx&colon.\efte\config\mynewconfig.fte
:exmp.

To get the most out of eFTE2, you may install some additional programs and
include various help files in your HELP and/or BOOKSHELF paths in config.sys.
Even if you are using Open Watcom and don't need the IBM OS/2 toolkit, you
should install it and include the path to its help files in HELP. The same is
true for your compiler help files. See the list of help files below. Most of
these files come with OS/2, the OS/2 toolkit, Open Watcom or WarpIN. The few
that don't are available on Hobbes. It is also recommendable putting your
eFTE2 directory in your :font facename='System Monospaced' size=12x8.PATH:font facename='default'. and :font facename='System Monospaced' size=12x8.DPATH:font facename='default'. in CONFIG.SYS.

:p.These are the :link reftype=hd refid='use-Tools'.programs eFTE2 is setup to work with:elink.
if they are found in the PATH:

:dl compact.
  :dt.Open Watcom (http&colon.//www.openwatcom.org/)
  :dd.Wmake and the C/C++ help files are available directly from the menus (Can easily be changed if you use something else).
    :p.See :link reftype=fn refid=OW_OS2.additional notes on using Open Watcom:elink..
  :dt.:link reftype=hd refid='use-Grep'.Grep:elink.
  :dd.Called directly from the menu; You can click on the results to open the file at the found line.
  :dt.:link reftype=hd refid='use-ISpell'.ISpell:elink.
  :dd.Provides reasonable spell checking.
  :dt.:link reftype=hd refid='use-cvs_svn'.SVN and CVS:elink.
  :dd.Direct access to the most commonly used commands for these versioning systems.
  :dt.:link reftype=hd refid='use-Tidy'.HTML Tidy:elink.
  :dd.Direct access via menu.
:edl.

:fn id='OW_OS2'.Note on using Open Watcom: The 'Tools' menu entry 'Make and open list file' invokes directly 'wdis' via the totally undocumented command 'MakeListFile'.
:p.The object file must be in the compile directory or directory relative to the compile directory (see below) f.e. ..\object\my.obj. Absolute paths are not currently supported.
:p.Compile directory is the directory containing the file you are currently editing the first time you run/compile/etc.
After that the directory remains the same as long as the Messages :link reftype=hd refid='use-buffers'.buffer:elink. is left open.
The directory is listed on the 'running' line [running 'myprogram ' in directory] Directory is the compile directory.
One way to change it is to close the Messages buffer and run/ compile from a file in a different directory.
:efn.

:p.OS/2 developer documentation packages are linked to as well in the 'Help'
menus of the appropriate editing modes. You will be able to directly consult
the following books if they are available in your
:font facename='System Monospaced' size=12x8.HELP:font facename='default'. path:

:dl compact.
  :dt.OS/2 Programming Guide
  :dd.The following inf files make up this book: addendum.inf +CP1.inf
+CP2.inf +CP3.inf +GPI1.inf +GPI2.inf+ GPI3.inf +GPI4.inf +MMREF1.inf
+MMREF2.inf +MMREF3.inf +MMSSPG.inf +PM1.inf +PM2.inf +PM3.inf +PM4.inf
+PM5.inf +WPS1.inf +WPS2.inf +WPS3.inf.
  :dt.Watcom C Help
  :dd.The following inf files make up this book: clib.inf +clr.inf.
  :dt.Watcom C++ Help
  :dd.The following inf files make up this book: cpplib.inf +wpperrs.inf.
  :dt.EMX Help
  :dd.The following inf files make up this book: emxbsd.inf +emxlib.inf +emxdev.inf +emxrt.inf.
  :dt.IPF Help
  :dd.ipfref.inf
  :dt.Make Help
  :dd.Open Watcom tools.inf
  :dt.REXX Information
  :dd.rexx.inf
  :dt.REXX Multimedia
  :dd.mcirexx.inf
  :dt.REXX Tips and Tricks
  :dd.rxtt36.inf
  :dt.TCP/IP REXX FTP API
  :dd.rxftp.inf
  :dt.TCP/IP REXX Sockets API
  :dd.rxsocket.inf
  :dt.WarpIN Programmer's Guide and Reference
  :dd.wpi_prog.inf
:edl.

:h2 id='install-win'.On Windows

:h2 id='install-linux'.On Linux

:h2 id='install-cfglist' toc=12.List of Configuration Files

This is a complete list of the config files that will be installed on a
clean install. Updates are meant to be included in a file related to the file
being update i.e. mym_html.fte for m_html.fte. In practice any one of them
may get edited by the user. This means updating them will be difficult.

:p.If you wish to modify only a specific mode, add customizations to a
:font facename='System Monospaced' size=12x8.my*.fte:font facename='default'. file and 'include' it at the end of file. To also modify all
of the descendants, 'include' customizations right after the include
statement for mode.

:h3.Main/Global configuration

:ul compact.
  :li.main.fte
  :li.mymain.fte
  :li.myfontsize.fte
  :li.systemmain.fte
  :li.global.fte
:eul.

:h3.User interface color definitions and schemes

:ul compact.
  :li.color.fte
  :li.pal_b_kb.fte
  :li.pal_base.fte
  :li.pal_blk.fte
  :li.pal_blue.fte
  :li.pal_bluez.fte
  :li.pal_gray.fte
  :li.pal_nce.fte
  :li.pal_wht.fte
:eul.

:h3.HTML character sets and conversion tools selectable from menus (incomplete)

:ul compact.
  :li.charset\ents.fte
  :li.charset\jap.fte
  :li.charset\latin.fte
  :li.htmlchar.fte
  :li.htmlconv.fte
:eul.

:h3.Mode specific text highlighting

:ul compact.
  :li.m_4gl.fte
  :li.m_a51.fte
  :li.m_ada.fte
  :li.m_asm.fte
  :li.m_asm370.fte
  :li.m_basic.fte
  :li.m_batch.fte
  :li.m_bin.fte
  :li.m_c.fte
  :li.m_catbs.fte
  :li.m_clario.fte
  :li.m_cmake.fte
  :li.m_cnfgs.fte
  :li.m_css.fte
  :li.m_diff.fte
  :li.m_ebnf.fte
  :li.m_eiffel.fte
  :li.m_euphoria.fte
  :li.m_falcon.fte
  :li.m_fort90.fte
  :li.m_fte.fte
  :li.m_gawk.fte
  :li.m_groovy.fte
  :li.m_html.fte
  :li.m_icon.fte
  :li.m_idl.fte
  :li.m_ipf.fte
  :li.m_java.fte
  :li.m_ldsgml.fte
  :li.m_lisaac.fte
  :li.m_lua.fte
  :li.m_make.fte
  :li.m_markup.fte
  :li.m_merge.fte
  :li.m_mod3.fte
  :li.m_msg.fte
  :li.m_mvsasm.fte
  :li.m_ocaml.fte
  :li.m_pascal.fte
  :li.m_perl.fte
  :li.m_php.fte
  :li.m_plain.fte
  :li.m_py.fte
  :li.m_resdlg.fte
  :li.m_rexx.fte
  :li.m_rpm.fte
  :li.m_rst.fte
  :li.m_ruby.fte
  :li.m_sgml.fte
  :li.m_sh.fte
  :li.m_siod.fte
  :li.m_sl.fte
  :li.m_sml.fte
  :li.m_source.fte
  :li.m_sql.fte
  :li.m_tcl.fte
  :li.m_trp.fte
  :li.m_tex.fte
  :li.m_texi.fte
  :li.m_text.fte
  :li.m_unrealscript.fte
  :li.m_vhdl.fte
  :li.m_wis.fte
  :li.m_xml.fte
  :li.m_xslt.fte
:eul.

:h3.User interface styles

:ul compact.
  :li.ui_brief.fte
  :li.ui_ew.fte
  :li.ui_fte.fte
  :li.ui_mixed.fte
  :li.ui_ne.fte
  :li.ui_ws.fte
  :li.uicstyle.fte
:eul.

:h3.Experimental (incomplete) expansions of the UI (included as a base for further development)

:ul compact.
  :li.Experimental\m_vi.fte
  :li.Experimental\m_xp.fte
  :li.Experimental\rgbcolor.fte
  :li.Experimental\ui_k_joe.fte
  :li.Experimental\ui_vi.fte
:eul.

:h3.Mode-specific keyboard hotkey definitions

:ul compact.
  :li.kbd\k_c.fte
  :li.kbd\k_fte.fte
  :li.kbd\k_groovy.fte
  :li.kbd\k_html.fte
  :li.kbd\k_java.fte
  :li.kbd\k_perl.fte
  :li.kbd\k_rexx.fte
  :li.kbd\k_rst.fte
  :li.kbd\k_sgml.fte
:eul.

:h3.Abbreviation expansion for various modes

:ul compact.
  :li.ab_c.fte
  :li.ab_c_os2.fte
  :li.ab_java.fte
  :li.ab_perl.fte
  :li.ab_rexx.fte
  :li.ab_sh.fte
:eul.

:h3.Default Menus (Normally English but can be any at user discretion)

:ul compact.
  :li.menu\m_c.fte
  :li.menu\m_css.fte
  :li.menu\m_groovy.fte
  :li.menu\m_html.fte
  :li.menu\m_html_t.fte
  :li.menu\m_ipf.fte
  :li.menu\m_make.fte
  :li.menu\m_resdlg.fte
  :li.menu\m_rexx.fte
  :li.menu\m_rst.fte
  :li.menu\m_sgml.fte
  :li.menu\m_wis.fte
  :li.menu\ui_k_brf.fte
  :li.menu\ui_k_fte.fte
  :li.menu\ui_k_ne.fte
  :li.menu\ui_k_ws.fte
  :li.menu\ui_m_ew.fte
  :li.menu\ui_m_fte.fte
  :li.menu\ui_m_ne.fte
  :li.menu\ui_m_ws.fte
:eul.

:h3.Internationalized menus where xx is the country code (optional)

:ul compact.
  :li.menu_xx\m_c.fte
  :li.menu_xx\m_css.fte
  :li.menu_xx\m_groovy.fte
  :li.menu_xx\m_html.fte
  :li.menu_xx\m_html_t.fte
  :li.menu_xx\m_ipf.fte
  :li.menu_xx\m_make.fte
  :li.menu_xx\m_rexx.fte
  :li.menu_xx\m_rst.fte
  :li.menu_xx\m_sgml.fte
  :li.menu_xx\ui_k_brf.fte
  :li.menu_xx\ui_k_fte.fte
  :li.menu_xx\ui_k_ne.fte
  :li.menu_xx\ui_k_ws.fte
  :li.menu_xx\ui_m_ew.fte
  :li.menu_xx\ui_m_fte.fte
  :li.menu_xx\ui_m_ne.fte
  :li.menu_xx\ui_m_ws.fte
:eul.

:h1 id='use' toc=123.Using eFTE2: out of the box

.* :h2 id='use-legend'.Manual conventions
:hp2.Manual conventions:ehp2.

:p.Along this document, the syntax of program command lines, eFTE2 arguments
and macro editing commands, and others will be explained using a uniform
selection of symbols, compiled here for your convenience. They are:

:ul compact.
  :li.When not assigned another specific meaning (such as in sections :link
reftype=hd refid='regexp-match'.regular expression match operators:elink., or
:link reftype=hd refid='ref-mode'.keybindings:elink.) square brackets "[" and
"]" indicate optional arguments or text.
  :li.When not assigned another specific meaning, angle brackets &lt. and &gt.
indicate an example that must be adjusted to particular cases, without the
brackets.
  :li.When not assigned another specific meaning, or appearing literally in
code, curly braces { and } denote a set of mutually exclusive values.
:eul.

.* id='use-fags'
:p.Also, a number of operations can be performed according to conditions
expressed independently of each other by the presence or absence of some
characters in a so called 'flags' string. Such characters are referred to as
'flags' for short, and flags strings are used in settings as well as some
interaction with the user.

:h2 id='command-line' toc=12.Command line options

The command line syntax is:

:p.:font facename='System Monospaced' size=12x8.efte[pm] [[options] [file(s)]]:font facename='default'.

:p.If no options nor file(s) are specified, eFTE2 will start in :link reftype=hd refid='use-directory'.file browsing:elink. mode.

:p.:hp2.
:h3 id='command-line-options'.Options
:ehp2.

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-l:ehp2.line[,column]:font facename='default'.
  :dd.Go to line (and column) in next file specified on command line.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-m:ehp2.[MODE]:font facename='default'.
  :dd.Use mode :font facename='System Monospaced' size=12x8.MODE:font facename='default'. for remaining files. If no argument is specified, mode override is cancelled.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-C:ehp2. or :hp2.-!:ehp2.[file]:font facename='default'.
  :dd.Use specified configuration file (full pathname). If no argument is specified, the default configuration :font facename='System Monospaced' size=12x8.edefault.fte:font facename='default'. is used.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-D:ehp2.[file.dsk]:font facename='default'.
  :dd.Load/save :link reftype=fn refid='def-desktop'.desktop:elink. from :font facename='System Monospaced' size=12x8.file.dsk:font facename='default'.. If no argument is specified, desktop loading/saving is disabled.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-H:ehp2.[file.his]:font facename='default'.
  :dd.Load/save history from :font facename='System Monospaced' size=12x8.file.his:font facename='default'.. If no argument, disable history load/save.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-T:ehp2.tags:font facename='default'.
  :dd.Load tags file :font facename='System Monospaced' size=12x8.tags:font facename='default'.. The file must be in the format generated by the ctags program.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-t:ehp2.tag:font facename='default'.
  :dd.Lookup tag named :font facename='System Monospaced' size=12x8.tag:font facename='default'. and display file containing it.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.--:ehp2.:font facename='default'.
  :dd.The rest of the arguments are not options, but filenames.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.-+:ehp2.:font facename='default'.
  :dd.The next argument is not an option even if starting with a '-'.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.--help -h or -?:ehp2.:font facename='default'.
  :dd.This shows a usage dialog.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.--debug / --debugclean:ehp2.:font facename='default'.
  :dd.These start logging; :font facename='System Monospaced' size=12x8.debug:font facename='default'. appends efte.log, :font facename='System Monospaced' size=12x8.debugclean:font facename='default'. creates a new one.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.--version:ehp2.:font facename='default'.
  :dd.Provides some version information.
:edl.

:p.:hp2.N.B.&colon.:ehp2. there should not be any delimiter between an option and its arguments.

:p.:hp2.
:h3 id='command-line-examples'.Examples
:ehp2.

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -mBIN efte.exe:font facename='default'.
  :dd.load efte.exe in BIN mode.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -l100,30 win.c:font facename='default'.
  :dd.go to (100,30) in win.c.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -! -l100,30 mymain.fte:font facename='default'.
  :dd.use the default configuration and go to (100,30) in mymain.fte.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] window.cpp:font facename='default'.
  :dd.load file window.cpp.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -dGNU window.cpp:font facename='default'.
  :dd.load file window.cpp using the GNU indent style.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] --debug window.cpp:font facename='default'.
  :dd.load file window.cpp with logging enabled in append mode.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -mBIN efte.exe -m window.cpp:font facename='default'.
  :dd.load efte[pm].exe in binary mode, window.cpp in default mode (C/C++).
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -mBIN -+ -bla-:font facename='default'.
  :dd.load file -bla- in BIN mode.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -- -1 -2 -3 -4 -5 -6:font facename='default'.
  :dd.load files -1, -2, -3, -4, -5, -6.
  :dt.:font facename='System Monospaced' size=12x8.efte[pm] -D -H efte.dsk efte.his:font facename='default'.
  :dd.Disable desktop and history loading and saving and load files efte.dsk and efte.his.
:edl.

:p.Under OS/2, NT and DOS default history and :link reftype=fn refid='def-desktop'.desktop files:elink.
are named :font facename='System Monospaced' size=12x8.eFTE.DSK:font facename='default'. and :font facename='System Monospaced' size=12x8.eFTE.HIS:font facename='default'. respectively.
Under Unix they are named :font facename='System Monospaced' size=12x8..efte-desktop:font facename='default'. and :font facename='System Monospaced' size=12x8..efte-history:font facename='default'..
The global desktop and history files will be searched in program directory
under OS/2 and in user home directory under Unix.

:h2 id='use-editing' toc=1234.Standard 'plain' text editing

eFTE2 default configuration follows the common user access (CUA)
guidelines, so it should be rather intuitive how to perform typical text
editing tasks and get started. However, the capabilities of eFTE2 extend
beyond those of basic system text editors, such as E, NotePad, or the like,
so it is a good idea to explore them in some depth. Furthermore, basic text
editing tasks can be daisy-chained in ":link reftype=hd refid='macros'.macros:elink.", a
feature which is obviously easier to take advantage of if at least a
superficial grasp of the basic editor capabilities has been acquired.

:h3 id='use-Text-vs-Plain'.Text vs Plain mode

There are two basic styles of editing text files, stream and line
editing. Stream editors treat files as one long stream of characters, line
editors treat files as a series of individual lines, separated by a line end
character. Being originally oriented towards programming, eFTE2 is
feature-rich on the line editing side, but since both editing styles are
valid interpretations of the same reality, and stream editing is so popular
with word processors and many other applications, eFTE2's set of features lets
the user work seamlessly either way. (eFTE2 also features another variation:
'column-' editing.)

:p.The difference, however, may be very important regarding specific files. In
general, computer code and other text formats where line numbers and exact text
position are important tend to have many short lines to help clarity and avoid
lateral scrolling in editors. On the other hand, text documents tend to have
paragraphs condensed in single, [very] long lines, precisely because line
numbers and exact text position are not considered important in them. Text
documents are thus generally expected to have their lines automatically
rearranged, split, and wrapped by word processors or other applications as
necessary for comfortable editing.

:p.By default, 'plain' files are never reflowed in eFTE2, while in 'text' files
:link reftype=fn refid='ms.WordWrap'.word wrap:elink. is set to automatically
divide lines as the :link reftype=fn refid='ms.RightMargin'.right margin:elink.
is reached when writing. Word wrap can also be set to continuously reflow any
text block delimited by empty lines (a "paragraph") as it is edited.

:p.:hp2.A word of caution&colon.:ehp2. there is always 'undo' and 'discard
changes', but at the very least, check the :link reftype=hd
refid='status'.status line:elink. when you're starting to edit files with
eFTE2&mdash.'plain' and 'text' modes are :hp1.not:ehp1. the same thing!

:h3 id='status'.Status line

eFTE2 always shows a status line at the bottom of its screen.

:p.While editing a file, the status line shows the following information:

:p.:font facename='System Monospaced'
size=12x8.curpos|flags|mode|mod?filename[ ... ]curchar|winno:font facename='default'.

:p.Where each field represents:

:dl compact.
  :dt.:hp2.cursor position:ehp2.
  :dd.line&colon.column
  :dt.:hp2.flags:ehp2.
  :dd.
    :dl compact.
      :dt.I
      :dd.Insert
      :dt.A
      :dd.Autoindent
      :dt.C
      :dd.Matches are case sensitive
      :dt.SLC
      :dd.Stream, Line, or Column block-mode
      :dt.wW
      :dd.Automatic :link reftype=fn refid='ms.WordWrap'.word wrap:elink. active
(w = line, W = paragraph).
    :edl.
  :dt.:hp2.mode:ehp2.
  :dd.Mode name as specified in configuration file.
  :dt.:hp2.mod?:ehp2.
  :dd.:hp2.*:ehp2. if file was modified, :hp2.%:ehp2. if file is read-only.
  :dt.:hp2.curchar:ehp2.
  :dd.Decimal ASCII code of character under cursor, or EOL/EOF.
  :dt.winno
  :dd.'window' number
:edl.

:p.:link reftype=hd refid='use-routines'.Routines:elink.,
:link reftype=hd refid='use-buffers'.buffers:elink.,
or :link reftype=hd refid='use-directory'.directory browser:elink. screens
display lists of selectable items, with a final status line at the bottom
showing the item count and the index of the current selection within it on the
right corner; the rest of the information displayed should be self-explanatory.

:h3 id='use-menus-keys'.Keys, menus and tasks

Most tasks in eFTE2 should be accessible with one or two keystrokes, but eFTE2
is built with customizability in mind, starting with key assignment. It would
then be a bit self-defeating to give a command key reference when key shortcuts
may well be used for different tasks in different interface configurations or
:link reftype=hd refid='modes'.editing modes:elink.. A task reference is given
instead.

:p.Unlike other text editors, eFTE2 is built with accessibility and clarity in
mind as well, so all basic tasks are bound to pull-down menus (also accessible
through the mouse), which in turn are organized in logical groups.

:p.As menus unfold, you may notice some characters are underscored or
highlighted in a different color; by pressing the corresponding keys you can
activate the right menu entries significantly faster than getting to them with
the cursor keys.

:p.The default configuration menus also reflect what key combinations (or
shortcuts) each task is bound to, so it should be easy to learn by heart the
key combinations in each mode by opening the menus a few times, and then
effectively not needing them any more.

:h4 id='use-menus-ellipsis'.Further input required

Menu items linked to tasks that require any kind of further user input for
proper execution typically have an ellipsis (...) in them. You can see
this in "Open...", "Save as...", and other menu items, and also in some
entries pointing to sub-menus.

:p.Submenu entries are always marked with :font facename='System Monospaced'
size=12x8.&rarrow.:font facename='default'., so those marked with an ellipsis
too indicate that all actions linked to the submenu entries require additional
user input as well.

:p.The tasks that will be described now are general-purpose, and as such they
should be available in all :link reftype=hd refid='modes'.editing
modes:elink.&mdash.in most cases they correspond to single internal editing
commands of the editor, and so their actions are not described directly, but
are linked instead to the appropriate section of the :link reftype=hd
refid='ref-commands'.commands reference:elink. in most cases.

:p.Once a file is opened in eFTE2, the tasks laid out under the application
menus are described in the following sections.

:h3 id='use-File'.File

Under the File menu, you find pretty much the same options as not just in
every other text editor, but pretty much in every other application in
existence: load a file, save changes, exit the application, etc., with
possibly only a couple of exceptions: the reference to
":link reftype=hd refid='modes'.editing modes:elink.", and "Next/Previous".

:p.It is often overlooked that eFTE2 is capable of editing several files at
once: the humble "Next/Previous" labels stand for "Next/Previous
:hp1.file:ehp1." (or, more accurately, :link reftype=hd refid='use-buffers'.buffer:elink.), each
of which will be edited in the appropriate :hp1.mode:ehp1..

:table cols='15 12 60'.
:row.:c.Entry:c.Key (if any):c.Command / action
:row.:c.Open...:c.F3:c.:link reftype=fn refid='ec.FileOpen'.FileOpen:elink.
:row.:c.Open in Mode...:c.Ctrl+F3:c.Opens :link reftype=hd refid='use-File-OpeninMode'.menu for picking the editing mode:elink. before opening a file.
:row.:c.Open Directory:c.Ctrl+M:c.:link reftype=fn refid='ec.DirOpen'.DirOpen:elink.
:row.:c.Reload:c.Shift+F3:c.:link reftype=fn refid='ec.FileReload'.FileReload:elink.
:row.:c.Save:c.F2:c.:link reftype=fn refid='ec.FileSave'.FileSave:elink.
:row.:c.Save As...:c.Shift+F2:c.:link reftype=fn refid='ec.FileSaveAs'.FileSaveAs:elink.
:row.:c.Save All:c.Ctrl+F2:c.:link reftype=fn refid='ec.FileSaveAll'.FileSaveAll:elink.
:row.:c.Write To...:c.:c.:link reftype=fn refid='ec.FileWriteTo'.FileWriteTo:elink.
:row.:c.Print:c.:c.:link reftype=fn refid='ec.FilePrint'.FilePrint:elink.
:row.:c.Next:c.Alt+Right:c.:link reftype=fn refid='ec.FileNext'.FileNext:elink.
:row.:c.Previous:c.Alt+Left:c.:link reftype=fn refid='ec.FilePrev'.FilePrev:elink.
:row.:c.Close:c.Alt+Q:c.:link reftype=fn refid='ec.FileClose'.FileClose:elink.
:row.:c.Close All:c.:c.:link reftype=fn refid='ec.FileCloseAll'.FileCloseAll:elink.
:row.:c.Exit:c.Alt+X:c.:link reftype=fn refid='ec.ExitEditor'.ExitEditor:elink.
:etable.

:h4 id='use-File-OpeninMode'.Open in Mode

The entry "Open in Mode..." of the menu "File" offers to open a file from
a selection of submenu entries. The difference with regular "Open file..." is
that the :link reftype=hd refid='modes'.editing mode:elink. for the file is
:link reftype=hd refid='mode-select'.established first:elink. through the appropriate menu entry.
Then the file can be opened normally, be it by specifying its name, or from
:link reftype=hd refid='use-directory'.the file browser:elink..

:p.It is out of the scope of this manual to explain what all the programming
/ scripting / markup languages formats, and their associated modes are.
However, :link reftype=hd refid='use-Text-vs-Plain'.'plain' or 'text' editing
modes:elink. are very important to understand, for the other modes are directly
derived from one of these.

:h3 id='use-Edit'.Edit

:table cols='15 16 20'.
:row.:c.Entry:c.Key (if any):c.Command / action
:row.:c.Undo:c.Alt+BackSp:c.:link reftype=fn refid='ec.Undo'.Undo:elink.
:row.:c.Redo:c.Alt+Shift+BackSp:c.:link reftype=fn refid='ec.Redo'.Redo:elink.
:row.:c.Cut:c.Shift+Del:c.:link reftype=fn refid='ec.BlockCut'.BlockCut:elink.
:row.:c.Copy:c.Ctrl+Ins:c.:link reftype=fn refid='ec.BlockCopy'.BlockCopy:elink.
:row.:c.Cut-Append:c.:c.:link reftype=fn refid='ec.BlockCutAppend'.BlockCutAppend:elink.
:row.:c.Copy-Append:c.:c.:link reftype=fn refid='ec.BlockCopyAppend'.BlockCopyAppend:elink.
:row.:c.Paste Stream:c.Shift+Ins:c.:link reftype=fn refid='ec.BlockPasteStream'.BlockPasteStream:elink.
:row.:c.Paste Column:c.Alt+Ins:c.:link reftype=fn refid='ec.BlockPasteColumn'.BlockPasteColumn:elink.
:row.:c.Paste Line:c.:c.:link reftype=fn refid='ec.BlockPasteLine'.BlockPasteLine:elink.
:row.:c.Clear:c.Ctrl+Del:c.:link reftype=fn refid='ec.BlockKill'.BlockKill:elink.
:row.:c.Line:c.:c.Opens submenu :link reftype=hd refid='use-Line'.Line:elink.
:row.:c.Quote Literal...:c.Ctrl+Q:c.:link reftype=fn refid='ec.InsertChar'.InsertChar:elink.
:row.:c.ASCII Table...:c.Ctrl+Sh+A:c.:link reftype=fn refid='ec.ASCIITable'.ASCIITable:elink.
:etable.

:h4 id='use-Line'.Line

:table cols='15 15 50'.
:row.:c.Entry:c.Key (if any):c.Command / macro
:row.:c.Insert line:c.Shift+Enter:c.:link reftype=fn refid='ec.LineInsert'.LineInsert:elink.
:row.:c.Add line:c.Alt+Enter:c.:link reftype=fn refid='ec.LineAdd'.LineAdd:elink.
:row.:c.Split line:c.Ctrl+Enter:c.:link reftype=fn refid='ec.LineSplit'.LineSplit:elink.
:row.:c.Join line:c.Ctrl+J:c.:link reftype=fn refid='ec.LineJoin'.LineJoin:elink.
:row.:c.Duplicate line:c.Ctrl+D:c.:link reftype=fn refid='ec.LineDuplicate'.LineDuplicate:elink.
:row.:c.Delete line:c.Ctrl+Y:c.:link reftype=fn refid='ec.KillLine'.KillLine:elink.
:row.:c.Center line:c.:c.:link reftype=fn refid='ec.LineCenter'.LineCenter:elink.
:row.:c.Delete to line end:c.Alt+End:c.:link reftype=fn refid='ec.KillToLineEnd'.KillToLineEnd:elink.
:row.:c.Delete to line start:c.Ctrl+Sh+BackSp:c.:link reftype=fn refid='ec.KillToLineStart'.KillToLineStart:elink.
:row.:c.:link reftype=fn refid='line_comment'.Comment *:elink.:c.Ctrl+Alt+C:c.:link reftype=fn refid='ec.MoveLineStart'.MoveLineStart:elink.; ?:link reftype=fn refid='ec.FindReplace'.FindReplace:elink. /^(\s*)/ /\/\/  \1/ "xnc"; :link reftype=fn refid='ec.MoveDown'.MoveDown:elink.
:row.:c.Uncomment:c.Ctrl+Alt+U:c.MoveLineStart; ?FindReplace /^[\/][\/] / // "xnc"; MoveDown
:row.:c.Uppercase:c.:c.:link reftype=fn refid='ec.LineCaseUp'.LineCaseUp:elink.
:row.:c.Lowercase:c.:c.:link reftype=fn refid='ec.LineCaseDown'.LineCaseDown:elink.
:row.:c.Togglecase:c.:c.:link reftype=fn refid='ec.LineCaseToggle'.LineCaseToggle:elink.
:row.:c.Rot13:c.:c.:link reftype=fn refid='ec.LineTrans'.LineTrans:elink. 'A-Za-z' 'N-ZA-Mn-za-m'
:row.:c.User specified...:c.:c.LineTrans
:etable.

:fn id='line_comment'.You may notice that this commenting lines out / back in is
in the style of C programming. This behaviour should be expected to be
adapted to what is considered a comment in different languages.:efn.

:h3 id='use-Block'.Block

:table cols='15 12 25'.
:row.:c.Entry:c.Key (if any):c.Command / action
:row.:c.Unmark:c.Esc:c.:link reftype=fn refid='ec.BlockUnmark'.BlockUnmark:elink.
:row.:c.Mark Stream:c.Alt+A:c.:link reftype=fn refid='ec.BlockMarkStream'.BlockMarkStream:elink.
:row.:c.Mark Column:c.Alt+K:c.:link reftype=fn refid='ec.BlockMarkColumn'.BlockMarkColumn:elink.
:row.:c.Mark Line:c.Alt+L:c.:link reftype=fn refid='ec.BlockMarkLine'.BlockMarkLine:elink.
:row.:c.Select Word:c.:c.:link reftype=fn refid='ec.BlockSelectWord'.BlockSelectWord:elink.
:row.:c.Select Line:c.:c.:link reftype=fn refid='ec.BlockSelectLine'.BlockSelectLine:elink.
:row.:c.Write...:c.:c.:link reftype=fn refid='ec.BlockWrite'.BlockWrite:elink.
:row.:c.Read Stream...:c.:c.:link reftype=fn refid='ec.BlockReadStream'.BlockReadStream:elink.
:row.:c.Read Column...:c.:c.:link reftype=fn refid='ec.BlockReadColumn'.BlockReadColumn:elink.
:row.:c.Read Line...:c.:c.:link reftype=fn refid='ec.BlockReadLine'.BlockReadLine:elink.
:row.:c.Print:c.:c.:link reftype=fn refid='ec.BlockPrint'.BlockPrint:elink.
:row.:c.Indent:c.Alt+I:c.:link reftype=fn refid='ec.BlockIndent'.BlockIndent:elink.
:row.:c.Unindent:c.Alt+U:c.:link reftype=fn refid='ec.BlockUnindent'.BlockUnindent:elink.
:row.:c.ReIndent:c.Alt+\:c.:link reftype=fn refid='ec.BlockReIndent'.BlockReIndent:elink.
:row.:c.Translate:c.:c.Opens submenu :link reftype=hd refid='use-Translate'.Translate:elink..
:row.:c.Expand Tabs:c.:c.:link reftype=fn refid='ec.BlockUnTab'.BlockUnTab:elink.
:row.:c.Generate Tabs:c.:c.:link reftype=fn refid='ec.BlockEnTab'.BlockEnTab:elink.
:row.:c.Sort:c.:c.:link reftype=fn refid='ec.BlockSort'.BlockSort:elink.
:row.:c.Sort Reverse:c.:c.:link reftype=fn refid='ec.BlockSortReverse'.BlockSortReverse:elink.
:etable.

:h4 id='use-Translate'.Translate

:table cols='15 35'.
:row.:c.Entry:c.Command / macro
:row.:c.Uppercase:c.:link reftype=fn refid='ec.BlockCaseUp'.BlockCaseUp:elink.
:row.:c.Lowercase:c.:link reftype=fn refid='ec.BlockCaseDown'.BlockCaseDown:elink.
:row.:c.Togglecase:c.:link reftype=fn refid='ec.BlockCaseToggle'.BlockCaseToggle:elink.
:row.:c.Rot13:c.:link reftype=fn refid='ec.BlockTrans'.BlockTrans:elink. 'A-Za-z' 'N-ZA-Mn-za-m'
:row.:c.User specified...:c.BlockTrans
:etable.

:h3 id='use-Search'.Search

:table cols='15 12 28'.
:row.:c.Entry:c.Key (if any):c.Command / action
:row.:c.Find...:c.Ctrl+F:c.:link reftype=fn refid='ec.FindReplace'.Find:elink.
:row.:c.Find Next:c.Ctrl+G:c.:link reftype=fn refid='ec.FindRepeat'.FindRepeat:elink.
:row.:c.Find Prev:c.Ctrl+H:c.:link reftype=fn refid='ec.FindRepeatReverse'.FindRepeatReverse:elink.
:row.:c.Find and Replace...:c.Ctrl+R:c.:link reftype=fn refid='ec.FindReplace'.FindReplace:elink.
:row.:c.Place Bookmark...:c.:c.:link reftype=fn refid='ec.PlaceBookmark'.PlaceBookmark:elink.
:row.:c.Goto Bookmark...:c.:c.:link reftype=fn refid='ec.GotoBookmark'.GotoBookmark:elink.
:row.:c.Tags:c.:c.Opens submenu :link reftype=hd refid='use-Tags'.Tags:elink.
:row.:c.Match Parenthesis:c.Alt+-:c.:link reftype=fn refid='ec.MatchBracket'.MatchBracket:elink.
:row.:c.Goto Line...:c.Alt+J:c.:link reftype=fn refid='ec.MoveToLine'.MoveToLine:elink.
:row.:c.Goto Column...:c.:c.:link reftype=fn refid='ec.MoveToColumn'.MoveToColumn:elink.
:row.:c.Current Word:c.:c.Opens submenu :link reftype=hd refid='use-SearchWords'.SearchWords:elink.
:etable.

:h4 id='use-SearchWords'.SearchWords

:table cols='15 12 15'.
:row.:c.Entry:c.Key (if any):c.Command
:row.:c.Search Prev:c.Alt+,:c.:link reftype=fn refid='ec.SearchWordPrev'.SearchWordPrev:elink.
:row.:c.Search Next:c.Alt+.:c.:link reftype=fn refid='ec.SearchWordNext'.SearchWordNext:elink.
:row.:c.Highlight:c.Alt+/:c.:link reftype=fn refid='ec.HilitWord'.HilitWord:elink.
:etable.

:h4 id='use-Tags'.Tags

"Tags" are a way of creating automated hypertext links between, for
example, function calls and function definitions (even across files!).

:p.For this to work with the file(s) currently being edited, another index (or
"tag") file must have been generated first by CTags
(see http&colon.//ctags.sourceforge.net/) or an equivalent program.

:p.From the CTags manual:

:lm margin=8.
:rm margin=8.
:p.Ctags generates an index (or "tag") file of names found in a set of files in a number of languages.
Depending on the language, functions, variables, class members, macros and so on may be indexed.
This tag file allows these items to be quickly and easily located by a text editor or other utility.
A "tag" signifies a language object for which an index entry is available (or, alternatively, the index entry created for that object).
:p.Alternatively, ctags can generate a cross reference file which lists, in human readable form, information about the various source objects found in a set of language files.
:rm margin=1.
:lm margin=1.

:p.Typically, you would want to know if something in one file is referenced in
others. Once loaded in the editor, the tags file acts as a proxy allowing to
jump between all references in the 'regular' files to the items listed in the
tags. Some additional examples could be:

:ol compact.
  :li.We are editing the editor configuration and we want to check if matching :font facename='System Monospaced' size=12x8.colorize:font facename='default'. and :font facename='System Monospaced' size=12x8.eventmap:font facename='default'.s are defined. Or, some menu imports as submenu another menu from another file. The names of these objects would be in the tags file.
  :li.Elements of an HTML document with :font facename='System Monospaced' size=12x8.class:font facename='default'. or :font facename='System Monospaced' size=12x8.id:font facename='default'. attributes could have these used as "." or "#" selectors in a CSS file. The attribute values would be in the tags file.
:eol.

:table cols='15 12 12'.
:row.:c.Entry:c.Key (if any):c.Command
:row.:c.Find word:c.Ctrl+]:c.:link reftype=fn refid='ec.TagFindWord'.TagFindWord:elink.
:row.:c.Search tag...:c.Ctrl+Sh+]:c.:link reftype=fn refid='ec.TagFind'.TagFind:elink.
:row.:c.Go back:c.Ctrl+[:c.:link reftype=fn refid='ec.TagPop'.TagPop:elink.
:row.:c.Next tag:c.Alt+]:c.:link reftype=fn refid='ec.TagNext'.TagNext:elink.
:row.:c.Previous tag:c.Alt+[:c.:link reftype=fn refid='ec.TagPrev'.TagPrev:elink.
:row.:c.Load tags...:c.:c.:link reftype=fn refid='ec.TagLoad'.TagLoad:elink.
:row.:c.Clear tags:c.:c.:link reftype=fn refid='ec.TagClear'.TagClear:elink.
:etable.

:p.An expected difficulty when trying to use the CTags feature is lack of
support for more modern languages. This should not be a problem because CTags
was developed with flexibility and extensibility in mind, but sometimes it is
for users because the documentation is not all that clear about how to add
that support themselves.

:p.Support for new languages must be added to CTags via command line parameters,
or adding these to its configuration file
(:font facename='System Monospaced' size=12x8..ctags:font facename='default'.)
This is an editor-centric example of support for the eFTE2 config 'language' as
must be added to the CTags configuration:

:xmp.--langdef=fte
--langmap=fte&colon..fte
--regex-fte=/^[ \t]*menu[ \t]+(.*)[ \t]+/\1/u,usermenu,UI menu definitions/
--regex-fte=/^[ \t]*colorize[ \t]+([A-Za-z0-9_-]+)([ \t]*&colon.[ \t]*([A-Za-z0-9_-]+)[ \t*])/\1 \3/c,colorize,syntax highlight schemes/
--regex-fte=/^[ \t]*eventmap[ \t]+([A-Za-z0-9_-]+)([ \t]*&colon.[ \t]*([A-Za-z0-9_-]+)[ \t*])/\1 \3/e,eventmap,menu and key bindings/
--regex-fte=/^[ \t]*mode[ \t]+([A-Za-z0-9_-]+)([ \t]*&colon.[ \t]*([A-Za-z0-9_-]+)[ \t*])/\1 \3/m,mode,editing modes/
:exmp.

Please note that the syntax used for CTags
:link reftype=hd refid='use-regexp'.regular expressions:elink. is a bit different from
:link reftype=hd refid='ref-regexp'.the one eFTE2 uses:elink..

:h3 id='use-Fold'.Fold

The idea behind folding is that the text you are editing is often composed
of conceptual blocks that you want to be reminded of, but don't necessarily
want to have to scroll through. For example, a programmer might want to see
all the methods of a class on screen at once, but not necessarily the whole
implementation of each method (and if you did show the implementation, it
would not all fit on one screen). But even more than programming code, one
thing that benefits *hugely* from folding is HTML. Here is an example, based
on the HTML source of this manual:

:xmp.&lt.h4&gt.SaveFolds&lt./h4&gt.  (0&colon.10)
&lt.h4&gt.Colorizer&lt./h4&gt.  [0]
    Specifies a previously declared &lt.A
    HREF="#colorizer"&gt.colorize&lt./A&gt. mode to use for syntax
    highlighting in this editing mode.
&lt.h4&gt.Loading files in various formats&lt./h4&gt. (0&colon.43)
:exmp.

The first and last line here are color-highlighted within eFTE2 itself.
The parenthesis (also color-highlighted to stand out) after the folded lines
quickly tell you that, e.g., the "SaveFolds" section has 10 lines in it, and
is a top-level fold (it might contain sub-folds). It takes just a couple
keystrokes to fold away "Colorizer" and display the "SaveFolds" body.

:p.If you happen to need to look at the same file in a different text editor,
the folds are indicated by comments appropriate to the language being used,
for example:

:xmp.&lt.h4&gt.Loading files in various formats&lt./h4&gt. &lt.!--fold00--&gt.
:exmp.

It adds a few extra characters to the file, but doesn't interfere with its
actual function outside of this editor.

:p.Once the folding concept is illustrated, the 'folding' tasks referenced
below should not be difficult to understand:

:table cols='25 12 22'.
:row.:c.Entry:c.Key (if any):c.Command
:row.:c.Open fold:c.Ctrl+Gr+:c.:link reftype=fn refid='ec.FoldOpen'.FoldOpen:elink.
:row.:c.Open nested folds:c.Ctrl+Gr*:c.:link reftype=fn refid='ec.FoldOpenNested'.FoldOpenNested:elink.
:row.:c.Open all folds:c.Alt+Gr*:c.:link reftype=fn refid='ec.FoldOpenAll'.FoldOpenAll:elink.
:row.:c.Close fold:c.Ctrl+Gr-:c.:link reftype=fn refid='ec.FoldClose'.FoldClose:elink.
:row.:c.Close all folds:c.Alt+Gr/:c.:link reftype=fn refid='ec.FoldCloseAll'.FoldCloseAll:elink.
:row.:c.Create fold:c.Alt+Gr+:c.:link reftype=fn refid='ec.FoldCreate'.FoldCreate:elink.
:row.:c.Create folds by regexp...:c.:c.:link reftype=fn refid='ec.FoldCreateByRegexp'.FoldCreateByRegexp:elink.
:row.:c.Create folds at :link reftype=hd refid='use-routines'.routines:elink.:c.:c.:link reftype=fn refid='ec.FoldCreateAtRoutines'.FoldCreateAtRoutines:elink.
:row.:c.Destroy fold:c.Alt+Gr-:c.:link reftype=fn refid='ec.FoldDestroy'.FoldDestroy:elink.
:row.:c.Destroy all folds:c.:c.:link reftype=fn refid='ec.FoldDestroyAll'.FoldDestroyAll:elink.
:row.:c.Promote:c.Sh+Gr-:c.:link reftype=fn refid='ec.FoldPromote'.FoldPromote:elink.
:row.:c.Demote:c.Sh+Gr+:c.:link reftype=fn refid='ec.FoldDemote'.FoldDemote:elink.
:row.:c.Toggle:c.Ctrl+Gr/:c.:link reftype=fn refid='ec.FoldToggleOpenClose'.FoldToggleOpenClose:elink.
:etable.

:h3 id='use-Options'.Options

The "Options" menu entries let the users change settings that affect the
behaviour of eFTE2 while editing the file.

:table cols='15 12 34'.
:row.:c.Entry:c.Key (if any):c.Command / macro / action
:row.:c.Change mode [more]:c.:c.Opens a submenu to change the :link reftype=hd refid='modes'.editing mode:elink. for current file.
:row.:c.Change C indent style:c.:c.Opens a submenu to choose from a selection of popular styles.
:row.:c.Toggle:c.:c.Opens submenu :link reftype=hd refid='use-Toggle'.Toggle:elink.
:row.:c.Insert mode:c.C+O C+I:c.:link reftype=fn refid='ec.ToggleInsert'.ToggleInsert:elink.
:row.:c.Word wrap:c.C+O C+W:c.:link reftype=fn refid='ec.ToggleWordWrap'.ToggleWordWrap:elink.
:row.:c.Left margin...:c.C+O A+[:c.:link reftype=fn refid='ec.ChangeLeftMargin'.ChangeLeftMargin:elink.
:row.:c.Right margin...:c.C+O A+]:c.:link reftype=fn refid='ec.ChangeRightMargin'.ChangeRightMargin:elink.
:row.:c.Show markers:c.C+O C+.:c.:link reftype=fn refid='ec.ToggleShowMarkers'.ToggleShowMarkers:elink.; :link reftype=fn refid='ec.WinRefresh'.WinRefresh:elink.
:row.:c.Highlight tags:c.:c.:link reftype=fn refid='ec.ToggleHilitTags'.ToggleHilitTags:elink.; WinRefresh
:row.:c.Show bookmarks:c.:c.:link reftype=fn refid='ec.ToggleShowBookmarks'.ToggleShowBookmarks:elink.; WinRefresh
:row.:c.Show tabs:c.C+O Tab:c.:link reftype=fn refid='ec.ToggleShowTabs'.ToggleShowTabs:elink.; WinRefresh
:row.:c.Tab size...:c.C+O C+T:c.:link reftype=fn refid='ec.ChangeTabSize'.ChangeTabSize:elink.; WinRefresh
:row.:c.Expand tabs:c.C+O C+Tab:c.:link reftype=fn refid='ec.ToggleExpandTabs'.ToggleExpandTabs:elink.; WinRefresh
:row.:c.Insert tabulator:c.S+Tab:c.:link reftype=fn refid='ec.InsertTab'.InsertTab:elink.
:row.:c.File Trim EOL:c.:c.:link reftype=fn refid='ec.FileTrim'.FileTrim:elink.; WinRefresh
:row.:c.Indent block:c.Alt+\:c.:link reftype=fn refid='ec.BlockReIndent'.BlockReIndent:elink.; FileTrim; WinRefresh
:row.:c.Print to...:c.:c.:link reftype=fn refid='ec.SetPrintDevice'.SetPrintDevice:elink.
:etable.

:h4 id='use-Toggle'.Toggle

:table cols='16 12 22'.
:row.:c.Entry:c.Key (if any):c.Command
:row.:c.Character case:c.A+`:c.:link reftype=fn refid='ec.CharCaseToggle'.CharCaseToggle:elink.
:row.:c.Auto indent:c.C+O C+A:c.:link reftype=fn refid='ec.ToggleAutoIndent'.ToggleAutoIndent:elink.
:row.:c.Case sensitive:c.C+O C+C:c.:link reftype=fn refid='ec.ToggleMatchCase'.ToggleMatchCase:elink.
:row.:c.Trim EOL spaces:c.C+O C+E:c.:link reftype=fn refid='ec.ToggleTrim'.ToggleTrim:elink.
:row.:c.Undo/Redo:c.C+O C+U:c.:link reftype=fn refid='ec.ToggleUndo'.ToggleUndo:elink.
:row.:c.Read only:c.C+O C+R:c.:link reftype=fn refid='ec.ToggleReadOnly'.ToggleReadOnly:elink.
:row.:c.Keep backups:c.:c.:link reftype=fn refid='ec.ToggleKeepBackups'.ToggleKeepBackups:elink.
:row.:c.Make backups:c.:c.:link reftype=fn refid='ec.ToggleMakeBackups'.ToggleMakeBackups:elink.
:row.:c.Backspace Unindents:c.:c.:link reftype=fn refid='ec.ToggleBackSpUnindents'.ToggleBackSpUnindents:elink.
:row.:c.Indent with tabs:c.:c.:link reftype=fn refid='ec.ToggleIndentWithTabs'.ToggleIndentWithTabs:elink.
:row.:c.Space tabs:c.:c.:link reftype=fn refid='ec.ToggleSpaceTabs'.ToggleSpaceTabs:elink.
:row.:c.Backspace kill tab:c.:c.:link reftype=fn refid='ec.ToggleBackSpKillTab'.ToggleBackSpKillTab:elink.
:row.:c.Delete kill tab:c.:c.:link reftype=fn refid='ec.ToggleDeleteKillTab'.ToggleDeleteKillTab:elink.
:etable.

:h3 id='use-localMenu'.Local (pop-up) editing menu

This is an internally called 'Local' menu, not another entry in the main
application menu. It pops up while editing a file when you click with the
second mouse button on the background of the editor window, or
alternatively if you press its key shortcut (Shift+F10 by default).

:p.It gives access to the most frequently used actions relevant to the
current file, line, or selected block of text, all of which have been
covered already:

:table cols='14 10 36'.
:row.:c.Entry:c.Key:c.Command / macro
:row.:c.Unmark:c.Esc:c.BlockUnmark
:row.:c.Cut:c.Shift+Del:c.BlockCut
:row.:c.Copy:c.Ctrl+Ins:c.BlockCopy
:row.:c.Paste:c.Shift+Ins:c.BlockPasteStream
:row.:c.Paste Column:c.Alt+Ins:c.BlockPasteColumn
:row.:c.Delete line:c.Ctrl+Y:c.KillLine
:row.:c.Delete to EOL:c.Alt+End:c.KillToLineEnd
:row.:c.Indent block:c.Alt+\:c.BlockReIndent; FileTrim; WinRefresh
:row.:c.Save:c.F2:c.FileSave
:row.:c.Close:c.Alt+Q:c.FileClose
:etable.

The contents of this menu are customizable as well; note that different
pop-up menus are available in the other views of eFTE2 (see
:link reftype=hd refid='use-housekeeping'.Non-editing tasks:elink.).

:h2 id='use-housekeeping'.Non-editing tasks

No tasks under certain application submenus have been covered so far&mdash.eFTE2
lets the user do other tasks that, being handy to have covered from within the
editor, and very useful at that, are not part of the editing itself, so they
have their own separate section.

:h3 id='use-Window'.Window

Items under the menu Window let the user decide what information eFTE2
displays, and how it is visually presented. The task reference and some term
definitions follow:

:table cols='17 13 18'.
:row.:c.Entry:c.Key (if any):c.Command / action
:row.:c.New :link reftype=fn refid='def-frame'.Frame:elink.:c.:c.:link reftype=fn refid='ec.FrameNew'.FrameNew:elink.
:row.:c.Split Horizontal:c.Ctrl+F4:c.:link reftype=fn refid='ec.WinHSplit'.WinHSplit:elink.
:row.:c.Close :link reftype=fn refid='def-view'.view:elink.:c.Shift+Alt+F4:c.:link reftype=fn refid='ec.WinClose'.WinClose:elink.
:row.:c.Close other views:c.F5:c.:link reftype=fn refid='ec.WinZoom'.WinZoom:elink.
:row.:c.Next view:c.F4:c.:link reftype=fn refid='ec.WinNext'.WinNext:elink.
:row.:c.Prev view:c.Shift+F4:c.:link reftype=fn refid='ec.WinPrev'.WinPrev:elink.
:row.:c.Load :link reftype=fn refid='def-desktop'.Desktop:elink.:c.:c.:link reftype=fn refid='ec.DesktopLoad'.DesktopLoad:elink.
:row.:c.Save Desktop:c.:c.:link reftype=fn refid='ec.DesktopSave'.DesktopSave:elink.
:row.:c.Save Desktop As:c.:c.:link reftype=fn refid='ec.DesktopSaveAs'.DesktopSaveAs:elink.
:row.:c.:link reftype=hd refid='use-routines'.Routines:elink.:c.Ctrl+I:c.:link reftype=fn refid='ec.ListRoutines'.ListRoutines:elink.
:row.:c.:link reftype=hd refid='use-buffers'.Buffers:elink.:c.Alt+0:c.:link reftype=fn refid='ec.ViewBuffers'.ViewBuffers:elink.
:row.:c.:link reftype=hd refid='use-directory'.Directory:elink.:c.C+M:c.:link reftype=fn refid='ec.DirOpen'.DirOpen:elink.
:etable.

:dl compact.
  :dt.Frame
  :dd.In GUI environments, a new program window executing eFTE2. Frames can be
closed one by one, or all at once.
  :dt.View
  :dd.Each eFTE2 window (whether text mode- or a GUI session) may be split in
sub-displays stacked vertically, named 'views', only one of which can have
active focus at a time to receive user input. All of them act like independent
editor windows (syntax highlight, key bindings, status line) within the editor
display, and the active view controls the common visual elements of the display,
f.e. contents of the application menu.
:p.Note that different views are not the same thing as different buffers (see
note about :link reftype=fn refid='views_vs_buffers'.Views vs. buffers:elink.
in the next section).
  :dt.Desktop
  :dd.A special text file where eFTE2 stores a list of editing buffers, position
in them, etc. Following the same metaphore as popular operating systems, this
provides a quick way to replicate previous work sessions by opening again the
same files and directories that were open at some point in time, like returning
to a real desktop to continue what was being done before leaving it.
  :dt.:link reftype=hd refid='use-routines'.Routines:elink.:dd.
  :dt.:link reftype=hd refid='use-buffers'.Buffers:elink.:dd.
  :dt.:link reftype=hd refid='use-directory'.Directory:elink.:dd.
:edl.

:fn id='def-frame'.Frame: In GUI environments, a new program window executing
eFTE2. Frames can be closed one by one, or all at once.:efn.

:fn id='def-view'.View: Each eFTE2 window (whether text mode- or a GUI session)
may be split in sub-displays stacked vertically, named 'views', only one of
which can have active focus at a time to receive user input. All of them act
like independent editor windows (syntax highlight, key bindings, status line)
within the editor display, and the active view controls the common visual
elements of the display, f.e. contents of the application menu. :p.Note that
different views are not the same thing as different buffers (see note
about :link reftype=fn refid='views_vs_buffers'.Views vs. buffers:elink. in the
next section).:efn.

:fn id='def-desktop'.Desktop: A special text file where eFTE2 stores a list of
editing buffers, position in them, etc. Following the same metaphore as popular
operating systems, this provides a quick way to replicate previous work
sessions by opening again the same files and directories that were open at some
point in time, like returning to a real desktop to continue what was being done
before leaving it.:efn.

:h3 id='use-routines'.Routines: parts of a file

While editing a file, you can open an alternate view (called a :link reftype=hd
refid='use-buffers'.buffer:elink.) that shows just a summary  of the meaningful
units of your text (function definitions, HTML headings, class declarations,
etc.), one per line. Highlight any unit from this list and press enter to jump
there.

:p.The concept is similar to :link reftype=hd refid='use-Fold'.folds:elink.,
but operates independently of what is folded. Because of the similarity, when
editing a file eFTE2 actually lets you define :link reftype=fn
refid='ec.FoldCreateAtRoutines'.file folds based on the routines:elink. found
in it.

:p.What text constructs the editor will consider as "routines" exactly
depends on the file type being edited, and thus on the corresponding editing
mode. In the configuration settings for that mode, routines
:link reftype=fn refid='ms.RoutineRegexp'.must be defined:elink. using a
:link reftype=hd refid='use-regexp'.regular expression:elink. that allows the
editor to find them.

:p.The routines buffer does not allow for editing, it only allows to select
routines to move quickly through long files, so its menus have few entries, and
others are very simplified compared to those shown when editing the file.

:h3 id='use-buffers'.Buffers

In eFTE2 terminology, a 'buffer' is any channel used to store information
for the user to select and browse or otherwise work on what is in it. The
buffers list will show open files, file browser instances, message queues, or
the :link reftype=hd refid='use-EventMapView'.EventMapView:elink. buffer if
open, and can be used as a quick way to switch between them, or do some
rudimentary managing of open files (limited to saving or closing them).

:p.The buffers list is in itself a buffer, and is thus listed at the top,
because it is the only one that cannot be closed.

:p.Unless files are opened in different instances of the editor, operating
systems cannot show them independently in their tasks lists, so this is the
only way to list all files currently opened in it.

:p.It is possible to switch from one editing buffer to the previous or next
one using the File menu, or jump direclty to one of the first ten using the
default key combination Alt+#, where # is the buffer number displayed for
each buffer in the list.

:p.:hp2.Notes&colon.:ehp2.

:ol compact.
:li.Different :link reftype=fn refid='def-view'.views:elink. can show the same
buffer, for example a file being edited. They do not edit the file
independently, though, but only display independently parts of it: if the same
[region of a] buffer is shown in more than one view, any action that takes
place in the active one is immediately reflected in the other(s).
:li.Different editing buffers can be opened for the same file (for example by
re-opening it via the :link reftype=hd refid='use-directory'.file
browser:elink.), though. If this is the case, these can be shown and act
totally independently in different views.
:eol.

:fn id='views_vs_buffers'.Views vs buffers:
:ol compact.
:li.Different :link reftype=fn refid='def-view'.views:elink. can show the same
buffer, for example a file being edited. They do not edit the file
independently, though, but only display independently parts of it: if the same
[region of a] buffer is shown in more than one view, any action that takes
place in the active one is immediately reflected in the other(s).
:li.Different editing buffers can be opened for the same file (for example by
re-opening it via the :link reftype=hd refid='use-directory'.file
browser:elink.), though. If this is the case, these can be shown and act
totally independently in different views.
:eol.
:efn.

:h3 id='use-directory'.Directory

eFTE2 incorporates a minimal file browser which provides the ability to
make directories, navigate the file system, and rename or delete individual
files. (See :link reftype=hd refid='use-Navigate'."Navigate" menu:elink. below.)

:p.The file browser lists, in its own :link reftype=hd
refid='use-buffers'.buffer(s):elink., the contents of the last directories
examined when manually picking files for editing.

:h4 id='use-Navigate'."Navigate" menu

:table cols='15 12 15'.
:row.:c.Entry:c.Key (if any):c.Command
:row.:c.Reload:c.Ctrl+R:c.:link reftype=fn refid='ec.Rescan'.Rescan:elink.
:row.:c.Go &lt. level:c.Ctrl+PgUp:c.:link reftype=fn refid='ec.DirGoUp'.DirGoUp:elink.
:row.:c.Go &gt. level:c.Ctrl+PgDn:c.:link reftype=fn refid='ec.DirGoDown'.DirGoDown:elink.
:row.:c.Go to \:c.Ctrl+\:c.:link reftype=fn refid='ec.DirGoRoot'.DirGoRoot:elink.
:row.:c./ Goto Dir...:c./:c.:link reftype=fn refid='ec.DirGoto'.DirGoto:elink.
:row.:c.Rename File:c.:c.:link reftype=fn refid='ec.RenameFile'.RenameFile:elink.
:row.:c.Make Directory:c.:c.:link reftype=fn refid='ec.MakeDirectory'.MakeDirectory:elink.
:row.:c.Delete File:c.Ctrl+D:c.:link reftype=fn refid='ec.DeleteFile'.DeleteFile:elink.
:etable.

:h3 id='use-Help'.Help

:table cols='15 12 20'.
:row.:c.Entry:c.Key (if any):c.Command / macro
:row.:c.:link reftype=fn refid='help_contents'.Contents *:elink.:c.F1:c.:link reftype=fn refid='ec.ShowHelp'.ShowHelp:elink. "eFTE2" ""
:row.:c.Keyboard:c.Alt+F1:c.:link reftype=fn refid='ec.ViewModeMap'.ViewModeMap:elink.
:row.:c.Show key:c.:c.:link reftype=fn refid='ec.ShowKey'.ShowKey:elink.
:row.:c.About...:c.:c.:link reftype=fn refid='ec.ShowVersion'.ShowVersion:elink.
:etable.

:fn id='help_contents'.* On OS/2 systems only (?).:efn.

:h3 id='use-EventMapView'.EventMapView

From pretty much anywhere in eFTE2, selecting 'keyboard' from the 'Help'
menu, or pressing the corresponding key combination (Alt+F1 by default) will
bring up this unique buffer listing keyboard bindings.

:p.EventMapView list starts with the mode last active when it was
invoked, then each item in the list shows a key combination plus a dump
of the command macro that it will execute. The listing will recursively
repeat the listing for all parent modes linked by inheritance.

:h2 id='use-developer' toc=1234.Editing files to be used with other programs

It is of course possible to write general-purpose text files, or all your
relevant documents in plain text, but you will be most likely using eFTE2 to
edit text files following some particular style or structure so the resulting
file will be used by another application lacking the ability of editing such
files with the same flexibility and freedom, be it because that is not its
primary function, or whatever other reason. Examples of this could be:

:ul compact.
  :li.Writing documents to pass on to a typesetting system such as TeX.
  :li.The sources to some computer program written in programming languages like C/C++ before it is compiled.
  :li.An HTML document to be published online and viewed in internet browsers.
  :li.An interpreted program, e.g. a REXX or Perl script.
  :li.Online manuals or help for application programs, with internal links and different contexts for help or references.
:eul.

:p.In all of these cases and many more, the final use of a file with an
application other than the text editor is the culmination of an often lengthy
task that could benefit from intermediate stages such as spell-checking,
testing internal references, suitability for compilation, etc. eFTE2 provides
the ability not only to invoke external applications to execute such tasks,
but also to capture and process their output for further use, if relevant,
within eFTE2.

:p.For example, a compiler will write to the standard output to inform you
of mistakes needing your attention at some locations in a program source file
before it can be further used. If executed from within eFTE2, such compiler
output could be used to open the file in eFTE2 at those precise locations for
immediate action to take place.

:p.Because FTE was initially conceived as a programming editor, the editing
command and setting that govern this behavior in eFTE2 in each editing mode
are actually called :link reftype=fn refid='ec.Compile'.Compile:elink. and
:link reftype=fn refid='gs.CompileRx'.CompileRx:elink.. However, this feature
can be useful in any process for which one or more suitable analogs for the
compilation / check compiler messages for feedback exist. In fact, most entries
in the standard* 'Tools' pull-down menu do some variant of (some part of) it.

:p.* specific editing modes may execute a substantially different
set of tasks from their 'Tools' menu.

:p.Typically, a file must be saved immediately prior to invoking a tool, as
will be done with the standard ones, so any modifications the tool might make
to the file will not conflict with those made in the editor since the last
time the file was saved.

:h3 id='use-messages'.Output messages from external applications

There are two basic internal commands to run an external program from
eFTE2: :font facename='System Monospaced' size=12x8.:link reftype=fn
refid='ec.RunProgram'.RunProgram:elink.:font facename='default'. and
:font facename='System Monospaced' size=12x8.:link reftype=fn
refid='ec.Compile'.Compile:elink.:font facename='default'..

:p.When :font facename='System Monospaced' size=12x8.RunProgram:font
facename='default'. is used, programs are executed without special regarding to
any possible output. GUI eFTE2 runs programs aynchronously in a separate
session, but the text mode version runs them as a child process. In this case,
it is still possible to read at least the last part of any output by pressing
:link reftype=fn refid='key_ShowEntryScreen'.Alt+F5 *:elink., like in the old
Borland IDEs.

:fn id='key_ShowEntryScreen'.This is the default key combination. For
reference, the internal command executed is :font facename='System Monospaced'
size=12x8.:link reftype=fn
refid='ec.ShowEntryScreen'.ShowEntryScreen:elink.:font
facename='default'..:efn.

:p.On the other hand, when an external program is executed via :font
facename='System Monospaced' size=12x8.:link reftype=fn
refid='ec.Compile'.Compile:elink.:font facename='default'., its output is
captured by eFTE2 and put into yet another buffer. With the aid of an adequate
regular expression to parse it, the Messages buffer will let you move quickly
through the application output and jump from one error to another skipping the
rest, or return to the exact position in the file that was 'compiled', if that
information is available.

:p.This is the local (pop-up) menu task reference for messages buffers:

:table cols='14 12 18'.
:row.
:c.Entry:c.Key (if any):c.Command / action
:row.
:c.View error:c.Enter:c.:link reftype=fn refid='ec.Activate'.Activate:elink.
:row.
:c.Previous error:c.F11:c.:link reftype=fn refid='ec.CompilePrevError'.CompilePrevError:elink.
:row.
:c.Next error:c.F12:c.:link reftype=fn refid='ec.CompileNextError'.CompileNextError:elink.
:etable.

:h3 id='use-Tools'.Tools: standard external programs

By default eFTE2 is ready to execute a number of standard tools available
on most platforms, and suitable for a variety of tasks:

:table cols='15 12 27'.
:row.:c.Entry:c.Key (if any):c.Command / action:row.:c.Compile...:c.F9:c.:link reftype=fn refid='ec.Compile'.Compile:elink. "wmake -e "
:row.:c.Grep...:c.:c.Compile "grep -n -I "
:row.:c.:link reftype=fn refid='MakeListFile'.Make and Load List File *:elink.:c.:c.MakeListFile
:row.:c.Save and ISpell:c.:c.:link reftype=fn refid='ec.FileSave'.FileSave:elink.; :link reftype=fn refid='ec.RunProgram'.RunProgram:elink. "ispell.exe ".$FilePath; :link reftype=fn refid='ec.FileReload'.FileReload:elink.
:row.:c.Shell:c.Alt+F9:c.RunProgram ""
:row.:c.Run...:c.Ctrl+F9:c.RunProgram
:row.:c.Previous error:c.F11:c.:link reftype=fn refid='ec.CompilePrevError'.CompilePrevError:elink.
:row.:c.Next error:c.F12:c.:link reftype=fn refid='ec.CompileNextError'.CompileNextError:elink.
:row.:c.Messages:c.S+F9:c.:link reftype=fn refid='ec.ViewMessages'.ViewMessages:elink.
:row.:c.Clear Messages:c.:c.:link reftype=fn refid='ec.ClearMessages'.ClearMessages:elink.
:row.:c.CVS:c.C+O_C+V:c.Opens submenu :link reftype=hd refid='use-cvs'.CVS:elink.
:row.:c.SVN:c.C+O_C+N:c.Opens submenu :link reftype=hd refid='use-svn'.SVN:elink.
:etable.

:fn id='MakeListFile'.* On OS/2 systems only (?). See :link reftype=fn
refid='OW_OS2'.Notes on using Open Watcom:elink., under :link reftype=hd
refid='install-os2'.installation:elink..:efn.

:h4 id='use-grep'.Grep...

:font facename='System Monospaced' size=12x8.grep:font facename='default'.
is a standard command-line utility for searching plain-text files for
lines that match a :link reftype=hd refid='use-regexp'.regular expression:elink..
Its name comes from the "ed" editor command g/re/p ("globally search a regular
expression and print").

:p.See https&colon.//en.wikipedia.org/wiki/Grep for more information.

:h4 id='use-ISpell'.ISpell

Ispell is a program, part of the GNU system, that helps you to correct
spelling and typographical errors in a file. When presented with a word that
is not in the dictionary, ispell attempts to find near misses that might
include the word you meant.

:p.Supposedly ISpell may be superseded by a similar tool called ASpell, for
which support might be added in the future.

:h4 id='use-cvs_svn' toc=12345.Version control in concurrent environments

Both CVS and SVN are applications for controlling the changes made /
applied to files in a concurrent work environment. With slightly different
approaches, CVS and SVN let you compare a set of files in a central
repository with a local copy, and selectively synchronize either by applying
individual changes or sets of them in the appropriate direction.

:p.While primarily intended for cooperative software development, these
systems can be applied, at least in theory, to any environment meeting the
aforementioned conditions.

:p.Detailed use of either versioning system is beyond the intended scope of
this manual, but under the pull-down menu 'Tools', you can see two sub-menus
that give direct access to the most frequently used commands of both and
their output from within eFTE2 with some more specialized macros/internal
commands:

:h5 id='use-cvs'.CVS

:table cols='20 20'.
:row.:c.Entry:c.Macro
:row.:c.CVS Check:c.:link reftype=fn refid='ec.RunCvs'.RunCvs:elink. "-n update"
:row.:c.CVS Update:c.RunCvs "update -d"
:row.:c.CVS Diff:c.:link reftype=fn refid='ec.CvsDiff'.CvsDiff:elink. ""
:row.:c.CVS Commit:c.:link reftype=fn refid='ec.RunCvsCommit'.RunCvsCommit:elink. ""
:row.:c.CVS Add:c.RunCvs "add"
:row.:c.CVS Remove:c.RunCvs "remove"
:row.:c.CVS Status:c.RunCvs "status -v"
:row.:c.CVS:c.:link reftype=fn refid='ec.Cvs'.Cvs:elink.
:row.:c.View CVS:c.:link reftype=fn refid='ec.ViewCvs'.ViewCvs:elink.
:row.:c.View CVS Diff:c.:link reftype=fn refid='ec.ViewCvsDiff'.ViewCvsDiff:elink.
:row.:c.View CVS Log:c.:link reftype=fn refid='ec.ViewCvsLog'.ViewCvsLog:elink.
:row.:c.Clear CVS messages:c.:link reftype=fn refid='ec.ClearCvsMessages'.ClearCvsMessages:elink.
:etable.

:h5 id='use-svn'.SVN

:table cols='20 20'.
:row.:c.Entry:c.Macro
:row.:c.SVN Status:c.RunSvn "status"
:row.:c.SVN Update:c.RunSvn "update"
:row.:c.SVN Diff:c.SvnDiff ""
:row.:c.SVN Commit:c.RunSvnCommit ""
:row.:c.SVN Add:c.RunSvn "add"
:row.:c.SVN Remove:c.RunSvn "remove"
:row.:c.SVN Log:c.RunSvn "log"
:row.:c.SVN Revert:c.RunSvn "revert"
:row.:c.SVN Blame:c.RunSvn "blame"
:row.:c.SVN:c.Svn
:row.:c.View SVN:c.ViewSvn
:row.:c.View SVN Diff:c.ViewSvnDiff
:row.:c.View SVN log:c.ViewSvnLog
:row.:c.Clear SVN messages:c.ClearSvnMessages
:etable.

:h2 id='use-regexp'.Regular expressions

.* :h3 id='regexp-intro'.Introduction

While most developers might be expected to get acquainted with regular
expressions at some point, this is not necessarily the case with many
'regular' users.

:p.Regular expressions, used extensively within eFTE2, are bits of text that
often look a lot like file filters with 'wildcards' in them, think f.e. *.txt,
or *12?.htm?. They also provide an advanced method of representing or
searching and replacing text in your files, much more powerful than working
with wildcards or static text strings.

:p.In most old text editors, and even many word processors, users are not
expected to do anything significantly beyond inputting text, and maybe simple
substitution stuff like replacing 'cat' with 'dog', or perhaps ' ,' with ', '
for the typographically-inclined. Search / replace operations like "find full
stops not followed by upper case letters" or "replace any sequence of more
than one space with a single one" are quite often hopelessly impossible
except using specific, 'advanced' functions or tools present in few
programs.

:p.Regular expressions use a relatively simple syntax to encode expressions
similar to the aforementioned ones in machine-processable form. In most
regular expression 'dialects' those would look very similar to:

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8..*\.\l:font facename='default'.
  :dd."any character string followed by a dot immediately followed by a lowercase letter, no spaces in between".
  :dt.:font facename='System Monospaced' size=12x8.\s+:font facename='default'.
  :dd."a sequence of at least one blank character (space, tab, newline or carriage return)".
:edl.

:p.Formally, regular expressions consist of normal characters, and characters
with a special meaning, called 'operators'. Operators allow you to anchor
matches, match classes of characters, match a given pattern several times or
match among alternate patterns. Operators can be also used to group simple
patterns to form more complex ones. (See
:link reftype=hd refid='regexp-match'.regular expression match operators:elink. for reference.)

:h3 id='regexp-example'.Regular expressions in action

To illustrate how regular expression matching works, an example might
come in handy.

:p.You might want to search for tags with a named anchor inside in an HTML
file, like :font facename='System Monospaced' size=12x8.&lt.h4&gt.&lt.a
name="destination"&gt.A header&lt./a&gt.&lt./h4&gt.:font facename='default'..

:p.Depending on how much details we need to care about within our targeted
tags, this regular expression might suffice:

:p.:font facename='System Monospaced' size=12x8.\&lt.(\w+)\&gt.\&lt.a
name="([^"]*)"\&gt.[^\&lt.]*\&lt.\/a\&gt.\&lt.\/\w+\&gt.:font facename='default'.

:p.Borrowing some knowledge from the :link reftype=hd
refid='ref-regexp'.regular expression syntax reference:elink., let's examine a
bit more in detail what this expression matches:

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.\&lt.(\w+)\&gt.:font facename='default'.
  :dd.\w+ stands for "one or more word characters" (A to Z and a to z plus numbers in most cases).
Being between parenthesis, whatever it matches must be registered for later use,
and it must also be enclosed in angled brackets "&lt." and "&gt.", so that expression bit efectively means "find and remember any single word between &lt. and &gt.",
or in HTML terms, "any opening tag, without attributes".
    :p.Notes:
    :ol compact.
      :li.w is escaped so it means "word character" instead of being taken as a regular letter; on the other hand, both "&lt." and "&gt." have to be escaped to be taken literally and not as regular expression operators.
      :li.Only the tag name is registered, without the angled brackets&mdash. these are :hp1.outside:ehp1. the parenthesis.
    :eol.
  :dt.:font facename='System Monospaced' size=12x8.\&lt.a name="([^"]*)"\&gt.:font facename='default'.
  :dd.This is again an :font facename='System Monospaced' size=12x8.a:font facename='default'. tag with the attribute :font facename='System Monospaced' size=12x8.name:font facename='default'. being assigned some value between double quotes.
The value, :font facename='System Monospaced' size=12x8.[^"]*:font facename='default'., can thus be any string of zero or more (the :font facename='System Monospaced' size=12x8.*:font facename='default'. bit) characters other than the double quote (:font facename='System Monospaced' size=12x8.^":font facename='default'.).
Whatever is inside the quotes is registered for future reference as well.
  :dt.:font facename='System Monospaced' size=12x8.[^\&lt.]*:font facename='default'.
  :dd.Any number of characters (again even none at all) other than "&lt." (escaped with "\"). This goes on until a new HTML tag opening character "&lt." or the next one in the expression are found in the text.
  :dt.:font facename='System Monospaced' size=12x8.\&lt.\/a\&gt.\&lt.\/\w+\&gt.:font facename='default'.
  :dd.The closing tag "&lt./a&gt.", followed by :hp1.any:ehp1. other closing tag. Note that in reasonably well-formed HTML this would match the first tag, but this covers mismatched tags as well.
:edl.

:p.So this expression will match any HTML string following that precise
pattern. Some examples might be:

:ol compact.:font facename='System Monospaced' size=12x8.
  :li.&lt.h1&gt.&lt.a name=&odq.start&cdq.&gt.Title&lt./a&gt.&lt./h1&gt.
  :li.&lt.h2&gt.&lt.a name=&odq.section_n&cdq.&gt.Some intermediate header&lt./a&gt.&lt./h1&gt.
  :li.&lt.h3&gt.&lt.a name=&odq.please_fill_in&cdq.&gt.&lt./a&gt.&lt./h3&gt.
  :li.&lt.p&gt.&lt.a name=&odq.note_on_xyz&cdq.&gt.This might be a footnote.&lt./a&gt.&lt./p&gt.
:eol.:font facename='default'.

:p.In general, it is best to start matching text with simple regular
expressions that match text quite rigidly and gradually incorporate elements
that may or may not be present in the text to be matched, to make them more
flexible and effective: for example, the matching expression above could
account for extra tag attributes, or spaces around them too.

:p.After a pattern is thus matched to a regular expression, it can be replaced
with a simple text string or another pattern with its own operators. (See
:link reftype=hd refid='regexp-replace'.regular expression replacement operators:elink. for
reference.)

:p.In the example above, we might want to modernize the HTML code, and replace
the :font facename='System Monospaced' size=12x8.name:font facename='default'.
attribute of the anchor tag with an :font facename='System Monospaced'
size=12x8.id:font facename='default'. attribute for the opening tag, keeping
the same value, and get rid of the anchor altogether. Using the same expression
as before, the following one could be a suitable replacement: :font
facename='System Monospaced' size=12x8.&lt.\1 id="\2"&gt.\3&lt.\/\1&gt.:font
facename='default'. (note the same tag is used twice now to ensure opening and
closing tags of the element do match).

:p.The above would replace the previous matched tags examples with:

:ol compact.:font facename='System Monospaced' size=12x8.
  :li.&lt.h1 id=&odq.start&cdq.&gt.Title&lt./h1&gt.
  :li.&lt.h2 id=&odq.section_n&cdq.&gt.Some intermediate header&lt./h2&gt.
  :li.&lt.h3 id=&odq.please_fill_in&cdq.&gt.&lt./h3&gt.
  :li.&lt.p id=&odq.note_on_xyz&cdq.&gt.This might be a footnote.&lt./p&gt.
:eol.:font facename='default'.

:p.:hp2.N.B.&colon.:ehp2. If you inspect closely example #2, you will see how both
opening and closing tags now do match.

:h3 id='regexp-where'.Regular expressions in eFTE2

Regular expressions can be typed in eFTE2 when doing Find / Replace
operations, but they are also used in many parts of the configuration, be it
to define editing mode file names, the text constructs that make up the proper
routines in that particular mode, ways to analyze output of other programs, or
as part of macro commands involving Find / Replace actions, for example in the
alternate HTML mode 'Tools' menu. Naturally, the same syntax and operators are
used everywhere; see the :link reftype=hd refid='ref-regexp'.regular expressions
reference:elink. for details.

:h2 id='use-alternate'.Editing modes (example: HTML)

This section of the manual is intended to illustrate the kind of enhanced
editing you can expect from mature specialized editing modes, part of the
decision-making involved in writing some parts, and how using them can
make your life easier. HTML mode will be used as an example, leaving out as
many details about HTML itself as possible.

:p.This new editing mode :link reftype=hd refid='modes'.builds up:elink. on
plain mode, and thus shares all of its functionality and menus, but also extends
them by adding some automated editing functions written with the HTML format
peculiarities in mind.

:p.These functions are accessible through hotkeys and two application menu
entries, corresponding to two main categories: a new one simply called 'HTML',
and 'Tools', where a number of submenus have been changed or added.

:p.For this manual, it will suffice to consider HTML as regular text
interspersed with special constructs called 'entities' and 'tags' (not to be
confused with :link reftype=hd refid='use-Tags'.search tags:elink.). Regular
text is mostly unpredictable in its input patterns, and already covered by the
standard editing functions anyway, so enhancements to HTML editing are aimed
directly at dealing with these special elements.

:h3 id='use-alternate-colors'.New colors schemes

Different types of text (programming code, tagged text) may have specific syntax
rules that benefit greatly from coloring.

:p.HTML tags follow a rigid syntax, so one thing that definitely helps to write
them right is coloring, or syntax highlighting, i.e. when editing an HTML file,
different colors are used to write all parts of a tag so you can not only spot
them against the normal text they are interspersed with, but also so you can
tell whether they are well formed or not at a glance.

:p.HTML tags are written like this:

:font facename='System Monospaced' size=12x8.&lt.tag attribute=&odq.value&cdq.[
more attributes... ]&gt.text&lt./tag&gt.:font facename='default'.

:p.So in eFTE2 you should see the symbols &lt., &gt., / and = in the code
punctuation color when they are part of a tag, and different colors for 'tag',
'attribute', 'value' and 'text'.

:p.Text colors are changed and assigned at different positions according to the
sequence of characters found prior to getting there. F.e., in HTML specifically
the colorizer is programmed so that '&lt.' triggers the change from default
color to punctuation, then to 'tag', and '&gt.' gets back to 'normal' from
'tag'. Also, while in 'tag' sub-mode, 'attribute' is entered automatically at
the first space, and '=' and quotes change from 'attribute' to 'value', etc.

:p.Now, the colorizer goes a little yet important step beyond that: you are not
supposed to make up your tag or attribute names, but to pick them from
pre-defined lists. Being a mere text-editor, eFTE2 will of course let you type
anything you want while, at the same time, it will try to match your input
against word lists. This lets several colors be used so you can tell on the fly
whether your input matches any 'allowed' (or 'forbidden'!) keywords on different
spots.

:p.Examples:

:ul compact.:font facename='System Monospaced' size=12x8.
  :li.&lt.MyTag&gt.You are not supposed to do this&lt./MyTag&gt.
  :li.&lt.p MyAttribute="do not do this either"&gt.More made-up stuff&lt./p&gt.
  :li.&lt.p style="text-align: center;"&gt.Now this is legal&lt./p&gt.
  :li.&lt.center&gt.Was deprecated years ago&lt./center&gt.
:eul.:font facename='default'.

:h3 id='use-alternate-simple'.New editing functions

Every entry under the menu "HTML" is devoted to speed up writing HTML tags and
entities. These can be classified in several groups according to their
complexity, but all items within the same group are equivalent for all practical
editing purposes, so only a working description of each group will be given.

:h4.HTML entities, colors, single tags

A first approach could be automatic insertion of text strings that are
hard to memorize, or long to type, for example HTML entities. That is
exactly what you will find under the submenus "Colors" or "Special
characters". No more trying to remember whether 'black' is '#000000' or
something completely different. Just put the cursor where you want it,
select the right menu, and the editor will write it in for you. Ditto
for math symbols or what have you.

:h4.Tag pairs

The next level in complexity stems from most HTML tags coming in opening and
closing pairs, f.e.&colon. :font facename='System Monospaced' size=12x8.&lt.i&gt.this
should be cursive&lt./i&gt.:font facename='default'..

:p.An easy try at this could be to have the editor to write both tags at once,
f.e. ":font facename='System Monospaced' size=12x8.&lt.i&gt.&lt./i&gt.:font
facename='default'.". Short as this is (two or three keystrokes vs. typing both
these shortest tags), it wouldn't be quite practical: HTML tag pairs enclose
text between them most of the time, so any carefully written macro should take
this into account.

:p.And indeed, the method currently employed to write HTML tag pairs does that
precisely: it will move to the start of any block of text selected, write an
opening tag, then move to the end of the block, and write the closig tag; if no
text is selected at all upon invocation, the whole process falls back to writing
both tags at cursor position.

:p.If you try it, you may wonder why such tag pair injections leave any text
selected previously plus the newly injected tags selected upon termination. The
reason is simple: doing so provides an easier way to serialize these operations.
Imagine you need to enclose a text block in two tag pairs. If the first
enclosing ended and unselected the block, it would be necessary to select it
again for the second one, and only you (the user) can do that, so you are
required to do it&mdash.by hand. On the other hand, if the block is left
selected, the second enclosing can be executed directly. But what if no second
operation were to be performed, you may ask? Well, unmarking the block can be
done with just an additional keystroke, or, and this is the good part, with an
additional :hp1.automated:ehp1. operation.

:h4.Tags that need to be at a specific location

Some HTML tags need to be at specific locations; for example, DTD tags must
be at the very top of the file, and encoding tags need to be in the HTML head
block, but before any other tag within it, especially the document title, to
avoid getting funny-looking characters.

:p.If you were editing a file and suddenly you remembered you need to include
one of these tags, you would need to search for the appropriate location to
insert them, and then type them in (or do it from one of those menus intended
to save you precious time). But the necessary location is marked, so moving
the cursor there can be done as well with an automated search!

:p.And that is exactly what all entries under 'Base tags' or 'Document head'
do: they insert the required tag(s) only after making sure a suitable location
is found in the file, and moving the cursor there.

:h4.Putting it all together

As with all good building block sets, the ability to automatically write
tags at cursor position, or at specific locations, is pretty much all that is
needed to create a more complex structure, such as a new HTML document (empty
but for the necessary tags) from scratch&mdash.it is just a matter of doing
all of those things sequentially, so that would be the next logical step in
automatisation.

:p.But can more interesting things be done? after all, it is even easier
to have empty document templates in store than creating them from scratch
every time, no mater if it takes only a few keystrokes. It would be really
much nicer to have the possibility of combining HTML templates with existing
text documents.

:p.Said and done. We could enclose existing text in HTML tags, couldn't we?
So, let's just open an ASCII text file in HTML mode, select its whole
contents, and an HTML template can be built around it before going on with the
editing! It is nearly the same thing as the multiple tag inclusions discussed
in the previous section.

:p.And a new whole submenu under 'HTML' is born: 'Create structures' (from
text).

:h3 id='use-alternate-complex'.New and tailored tools

Besides adding tags to text faster than simply typing them, there is the
question of dealing with HTML already written in a document opened for
editing. All tags start with "&lt.", and end with "&gt.", so they are easy to
find for doing some nifty tricks!:

:h4.Zap tags

First thing would be getting rid of tags quickly. Under "Tools" you will
find a "Zap HTML tags" submenu:

:dl.
  :dt.&lt. &gt.? Current &lt.? &gt.
  :dd.Assumes cursor is inside a tag (between "&lt." and "&gt."), and deletes the whole tag. If cursor is between two tags, they both and any text between them will be erased.
  :p.Examples:
  :ul compact.:font facename='System Monospaced' size=12x8.
    :li.&lt.!-- this whole comment [cursor] will be erased --&gt.
    :li.&lt.img class="undesired image" [cursor] ... src="..."&gt.
    :li.&lt.p&gt.This whole paragraph [cursor] will be erased.&lt./p&gt.
  :eul.:font facename='default'.
  :dt.Previous
  :dd.Looks up first tag ending anywhere before the current cursor position, and deletes it. Cursor does not even need to be moved near the tag.
    :p.Example:
    :p.:font facename='System Monospaced' size=12x8.&lt.p class=&odq.tag to be deleted&cdq.&gt.Some text [cursor] ... &lt./p&gt.:font facename='default'.
  :dt.Next
  :dd.Looks up any tag starting anywhere to right of cursor, and deletes it.
(The closing :font facename='System Monospaced' size=12x8.&lt./p&gt.:font facename='default'. in the example above.)
  :dt.Both
  :dd.Performs both previous operations.
    :p.Example:
    :p.:font facename='System Monospaced' size=12x8."&lt.p&gt.Some [cursor] text.&lt./p&gt.":font facename='default'. -&rarrow. :font facename='System Monospaced' size=12x8."Some [cursor] text.":font facename='default'.
:edl.

:h4.Duplicate tags

If for some reason existing HTML tags must be duplicated, the tools
described above are replicated under "Duplicate HTML tags", but they will
copy and paste again the tags instead of deleting them.

:h4.Elements: text between tags

A simple definition for an HTML element could be "plain text enclosed
between matching opening and closing tags," for example:

:xmp.&lt.p&gt.A simple text paragraph.&lt./p&gt.
:exmp.

Some obvious operations can be greatly accelerated with the right
specialized tools:

:dl.
  :dt.Complete closing tag
  :dd.This will look for any tag starting before the cursor, and will add a matching closing tag at the end of the line the cursor is in.
    :p.Example:
    :p.:font facename='System Monospaced' size=12x8.&lt.p&gt.This paragraph will have a closing tag added...
.br
[cursor] somewhere.&lt.!-- Here --&gt.:font facename='default'.
  :dt.Complete opening tag
  :dd.This will look for any ending tag starting after the cursor, and will
    add a matching opening tag at the beginning of the line the cursor is in.
    :p.Example:
    :p.:font facename='System Monospaced' size=12x8.&lt.!-- Opening tag will be created here --&gt.This paragraph wasn't properly started [cursor], but it can be&mdash.
.br
as long as this closing tag is found&colon.&lt./p&gt.:font facename='default'.
  :dt.Split at cursor
  :dd.If the cursor is placed before an element closing tag, it can be
    split in two at cursor by replicating the closing tag. Example:
    :p.:font facename='System Monospaced' size=12x8.&lt.p&gt.Some text.[cursor]Some more text.&lt./p&gt.:font facename='default'.
.br
will be split into&colon.
.br
:font facename='System Monospaced' size=12x8.&lt.p&gt.Some text.&lt./p&gt.[cursor]&lt.p&gt.Some more text&lt./p&gt.:font facename='default'.
  :dt.Merge with next
  :dd.Sometimes, two adjacent elements must be merged, which is equivalent to deleting the end tag of the first, the open tag of the next, and the space in between. Example:
    :p.:font facename='System Monospaced' size=12x8.&lt.p&gt.This text[cursor]&lt./p&gt.
.br
&lt.p&gt.should be connected&lt./p&gt.:font facename='default'.
    :p.will be merged like this:
    :p.:font facename='System Monospaced' size=12x8.&lt.p&gt.This text[cursor]should be connected&lt./p&gt.:font facename='default'.
:edl.

:p.Please note these 'element' operations are not aware of the Document Object
Model, or :link reftype=hd refid='use-Tidy'.HTML well-formedness:elink., and they are not a
magic wand, just some basic tools oriented at speeding up manual editing of
reasonably clean HTML code. They are easy to trip up if you are not
careful!

:h4.Metadata extraction

It is quite frequent to find HTML documents which contents have been merely
pasted on some template system, so the document will look OK at first glance
but soon enough you'll start spotting details like the document title being,
well, 'document title'. A couple of extra tools have been included to automate
doing some search, copy and text replacement to palliate common cases of such
sloppy publishing.

:p.Under the submenu "Extract metadata" you will find:

:dl compact.
  :dt.Title
  :dd.Looks for the first :font facename='System Monospaced' size=12x8.h1:font facename='default'. element available in the document, copies its contents, and replaces any document title element with that.
  :dt.Author
  :dd.Looks for an element similar to :font facename='System Monospaced' size=12x8.&lt.p class=&odq.author&cdq.&gt.Name here&lt./p&gt.:font facename='default'., and adds a
  :font facename='System Monospaced' size=12x8.meta:font facename='default'. tag to the file replicating that information.
:edl.

:h4.Extended search and replace

Recurrent search and replace operations in HTML can be too tedious and
complicated to type them in every time, so they are best automated too. All of
the following can be performed from the corresponding menus in any selected
block of text:

:ul compact.
 :li.Make empty elements (non-)self-closing, f.e.&colon. :font facename='System Monospaced' size=12x8.&lt.br&gt.:font facename='default'. &larrow.-&rarrow. :font facename='System Monospaced' size=12x8.&lt.br /&gt.:font facename='default'..
 :li.Transform non-ASCII characters to HTML entities and viceversa. (According to selected encodings.)
 :li.Convert named entites to numeric, and viceversa.
 :li.Convert ASCII constructs to HTML, like simplified entitites (f.e. ":font facename='System Monospaced' size=12x8.(c):font facename='default'." for ""), line breaks, paragraphs, etc.
:eul.

:h4 id='use-Tidy'.HTML Tidy (external application)

Specialized HTML editing macros and all, when editing HTML it is easy to
make mistakes. From the Tidy website:

:lm margin=8.
:rm margin=8.
:p.Wouldn't it be nice if there was a simple way to fix these mistakes automatically and tidy up sloppy editing into nicely layed out markup? HTML TIDY is a free utility for doing just that.
It also works great on the atrociously hard to read markup generated by specialized HTML editors and  conversion tools, and can help you identify where you need to pay further attention on making your pages more accessible to people with disabilities.
:p.Tidy is able to fix up a wide range of problems and to bring to your attention things that you need to work on yourself.
Each item found is listed with the line number and column so that you can see where the problem lies in your markup.
Tidy won't generate a cleaned up version when there are problems that it can't be sure of how to handle. These are logged as "errors" rather than "warnings".
:lm margin=1.
:rm margin=1.

:p.Tidy will be invoked directly from the 'Tools' after choosing the current
HTML file encoding from its submenu. For this to work, Tidy must be available
in your :font facename='System Monospaced' size=12x8.PATH:font facename='default'.
(or its equivalent in Unix systems).

:h2 id='use-more'.Alternate editing modes included

Currently, eFTE2 incorporates all these mode definitions in its configuration.
This listing was generated from :link reftype=hd refid='use-Tags'.a tags file:elink..

:table cols='12 18 9 42'.
:row.:c.Mode name:c.Definition file:c.Inherits from mode:c.Additional information
:row.:c.GL:c.m_4gl.fte:c.SOURCE:c.
:row.:c.ASM51:c.m_a51.fte:c.SOURCE:c.
:row.:c.Ada:c.m_ada.fte:c.SOURCE:c.
:row.:c.ASM:c.m_asm.fte:c.SOURCE:c.
:row.:c.ASM370:c.m_asm370.fte:c.SOURCE:c.
:row.:c.BASIC:c.m_basic.fte:c.SOURCE:c.http&colon.//www.freebasic.net
:row.:c.Batch:c.m_batch.fte:c.PLAIN:c.DOS .BAT and JP Software Command Processor BTM files, by Michael DeBusk
:row.:c.BIN:c.m_bin.fte:c.PLAIN:c.Binary mode
:row.:c.C:c.m_c.fte:c.SOURCE
:row.:c.CATBS:c.m_catbs.fte:c.PLAIN:c.For viewing nroff output (do NOT use for editing)
:row.:c.CLARION:c.m_clario.fte:c.SOURCE
:row.:c.CMAKE:c.m_cmake.fte:c.PLAIN
:row.:c.CNFGSYS:c.m_cnfgs.fte:c.PLAIN:c.DOS and OS/2 CONFIG.SYS files, by Michael DeBusk
:row.:c.CSS:c.m_css.fte:c.PLAIN:c.Cascading Style Sheets (*.CSS) files to dress up HTML.
:row.:c.DIFF:c.m_diff.fte:c.PLAIN
:row.:c.EBNF:c.m_ebnf.fte:c.PLAIN
:row.:c.Eiffel:c.m_eiffel.fte:c.SOURCE
:row.:c.EUPHORIA:c.m_euphoria.fte:c.SOURCE:c.http&colon.//openeuphoria.org/
:row.:c.FALCON:c.m_falcon.fte:c.SOURCE
:row.:c.FORTRAN:c.m_fort90.fte:c.SOURCE:c.Fortran-90
:row.:c.FTE:c.m_fte.fte:c.SOURCE:c.The editor configuration 'language'.
:row.:c.GAWK:c.m_gawk.fte:c.SOURCE
:row.:c.GROOVY:c.m_groovy.fte:c.SOURCE
:row.:c.HTML:c.m_html.fte:c.PLAIN:c.Internet sites are woven HyperText Markup Language.
:row.:c.ICON:c.m_icon.fte:c.SOURCE:c.https&colon.//www2.cs.arizona.edu/icon/index.htm
:row.:c.IDL:c.m_idl.fte:c.C
:row.:c.IPF:c.m_ipf.fte:c.PLAIN:c.Text source format for IBM Information Presentation Facility binary online help and manuals (INF/HLP).
:row.:c.JAVA:c.m_java.fte:c.SOURCE:c.C without pointers?
:row.:c.LDSGML:c.m_ldsgml.fte:c.MARKUP:c.LinuxDoc SGML
:row.:c.LISAAC:c.m_lisaac.fte:c.SOURCE:c.http&colon.//isaacproject.u-strasbg.fr
:row.:c.Lua:c.m_lua.fte:c.SOURCE
:row.:c.MAKE:c.m_make.fte:c.PLAIN
:row.:c.MARKUP:c.m_markup.fte:c.PLAIN:c.The theory: all markup modes should inherit from this mode, which enables the user to easily modify preferences for all markup file types.
:row.:c.MERGE:c.m_merge.fte:c.PLAIN
:row.:c.MODULA3:c.m_mod3.fte:c.SOURCE:c.Modula-3
:row.:c.MSG:c.m_msg.fte:c.TEXT:c.EMail messages
:row.:c.MVSASM:c.m_mvsasm.fte:c.SOURCE
:row.:c.OCAML:c.m_ocaml.fte:c.PLAIN
:row.:c.PASCAL:c.m_pascal.fte:c.SOURCE
:row.:c.PERL:c.m_perl.fte:c.SOURCE
:row.:c.PHP:c.m_php.fte:c.SOURCE:c.A popular server-side HTML preprocessing programming language.
:row.:c.PYTHON:c.m_py.fte:c.SOURCE
:row.:c.RESOURCE:c.m_resdlg.fte:c.PLAIN:c.OS/2 and Win* dialog resource files.
:row.:c.REXX:c.m_rexx.fte:c.SOURCE
:row.:c.NETREXX:c.m_rexx.fte:c.REXX
:row.:c.RPM:c.m_rpm.fte:c.SOURCE:c.RPM spec files
:row.:c.reST:c.m_rst.fte:c.PLAIN:c.ReStucturedText files, http&colon.//docutils.sourceforge.net/
:row.:c.Ruby:c.m_ruby.fte:c.SOURCE
:row.:c.SGML:c.m_sgml.fte:c.MARKUP
:row.:c.SH:c.m_sh.fte:c.SOURCE
:row.:c.SIOD:c.m_siod.fte:c.SOURCE
:row.:c.sl:c.m_sl.fte:c.SOURCE:c.SLang
:row.:c.SML:c.m_sml.fte:c.SOURCE
:row.:c.SOURCE:c.m_source.fte:c.PLAIN:c.The theory: All source modes should inherit from this mode which enables the user to easily modify preferences for all source code file types.
:row.:c.SQL:c.m_sql.fte:c.SOURCE
:row.:c.TCL:c.m_tcl.fte:c.SOURCE
:row.:c.TEX:c.m_tex.fte:c.MARKUP
:row.:c.TEXINFO:c.m_texi.fte:c.MARKUP
:row.:c.TEXT:c.m_text.fte:c.PLAIN
:row.:c.TRP:c.m_trp.fte:c.SOURCE:c.Trap reports generated by Exceptq/MapXQS.
:row.:c.UNREALSCRIPT:c.m_unrealscript.fte:c.C
:row.:c.VHDL:c.m_vhdl.fte:c.SOURCE
:row.:c.WIS:c.m_wis.fte:c.PLAIN:c.WarpIN installer script
:row.:c.XML:c.m_xml.fte:c.MARKUP
:row.:c.XSLT:c.m_xslt.fte:c.HTML
:etable.


:h1 id='custom'.Customizing and extending eFTE2

.* :h2 id='custom-intro'.Introduction

Every major user interface feature in eFTE2 can be customized to fit your
preferences or extend its functionality by editing the configuration, which
is directly loaded from .FTE files, like :font facename='System Monospaced' size=12x8.edefault.fte:font facename='default'.. This file
should be located and kept in the installation directory of eFTE2 as a
failsafe mechanism:

:p.Since the configuration is plain text, it can be edited from within eFTE2
itself. However, it is not possible to reload the configuration on the fly
(yet?), and any syntax errors in the configuration will prevent eFTE2 from
opening until they are fixed, so it is recommendable to leave eFTE2 open after
editing and open a second instance to test the changes. If it fails you can
easily edit/back out the changes in the first instance.

:p.Another possibility is to make a copy of the current configuration and edit
that instead. eFTE2 can switch between configurations using the :font
facename='System Monospaced' size=12x8.-c:font facename='default'. :link
reftype=hd refid='command-line'.command line:elink. switch followed by the full
path to the alternate configuration.

:p.If everything fails, use the "efte -!..." string from the error message.
This will open the configuration at the problem line while using the default
configuration.

:h2 id='cfgfiles'.Configuration files

To make management of complex configurations easier, the eFTE2 configuration is
by default broken down into several smaller modules (modes, menus, keys) that
are linked together via :font facename='System Monospaced'
size=12x8.include:font facename='default'. directives in them. However, all
configuration parameters of linked separate files are incorporated to the same
single configuration space, which is referred to in this manual as 'the
configuration (file)' for short.

:p.On startup, the editor will attempt to load the configuration starting from
:font facename='System Monospaced' size=12x8.mymain.fte:font
facename='default'. in any of several standard places including:

:ul compact.
  :li.The eFTE2 install directory (can be named anything)
  :li.efte\config
  :li.efte\local
:eul.

:p.and under the "Program Files" and "HOME" directories from your environment.
If you want the configuration files somewhere else or if eFTE2 is having
trouble finding :font facename='System Monospaced' size=12x8.mymain.fte:font facename='default'., you can use the environment variable
:font facename='System Monospaced' size=12x8.EFTEDIR:font facename='default'. with :font facename='System Monospaced' size=12x8.SET EFTEDIR = &lt.MYPATH&gt.:font facename='default'.. eFTE2 will look
in that directory and in a :font facename='System Monospaced' size=12x8.config:font facename='default'. and/or :font facename='System Monospaced' size=12x8.local:font facename='default'. subdirectory.
If you have several sets of configuration files use SET EFTEDIR in a script to
switch between them.

:p.Four 'compiler directives' are defined to conditionally include or exclude
configuration files. The directives are :font facename='System Monospaced'
size=12x8.%if:font facename='default'., :font facename='System Monospaced'
size=12x8.%endif:font facename='default'., :font facename='System Monospaced'
size=12x8.%define:font facename='default'. and :font
facename='System Monospaced' size=12x8.%undefine:font facename='default'.. They
behave as expected and :font facename='System Monospaced' size=12x8.!:font
facename='default'., the "not" character, can be used in the defines. Do not
try to put comments (or anything else) on these lines, as this will result in a
syntax error. White space is tolerated. In the last section of the manual there
is a complete reference of the :link reftype=hd refid='ref'.configuration
sections and syntax:elink..
.* ID above was ref-sections, a 'removed' heading

:p.Note that the :font facename='System Monospaced' size=12x8.include:font facename='default'. directives allow different configurations
to share important, non-changing bits.

:p.In :font facename='System Monospaced' size=12x8.mymain.fte:font facename='default'. you can select the global UI style and color
scheme as explained in the :link reftype=hd refid='colors'.following section:elink., or you
can skip it and go to the main configuration file, :font facename='System Monospaced' size=12x8.main.fte:font facename='default'.. There
you will find the :link reftype=hd refid='ref-global'.global configuration settings:elink.,
and includes to start linking editing modes and menus.

:h2 id='colors'.Interface colors

eFTE2 user interface colors are defined in :font facename='System Monospaced' size=12x8.pal_base.fte:font facename='default'. and
grouped together in different color schemes in other FTE configuration files
(:font facename='System Monospaced' size=12x8.pal_*.fte:font facename='default'.),
which are selectively included in the main configuration file to allow for easy customization.

:p.You can select any pre-made color scheme editing the file
:font facename='System Monospaced' size=12x8.mymain.fte:font facename='default'., edit the color schemes themselves, or create your own to
be included anywhere in the configuration.

:p.Color symbolic names and UI editor objects (f.e scroll bars) are linked to
one another in :font facename='System Monospaced' size=12x8.color.fte:font facename='default'..

:p.Except for the possibility of rendering text or other objects unreadable
or invisible with the same color for both foreground and background, changing
the interface colors is independent of the rest of eFTE2 functionality.

:p.The syntax for color settings is:

:p.:font facename='System Monospaced' size=12x8.:hp2.color_palette:ehp2. { {
'name', 'value' } [, ...] }:font facename='default'.

:p.where 'name' is any symbolic name string defined for later use in any
other parts of the configuration dealing with color, and 'value' is either a
colon-separated pair of symbolic names as previously defined, or a
space-separated couple of numeric values, corresponding to the standard PC
color numbering in text video modes; the first item in 'value' is for the
background color, the second one is for the foreground.

:p.In the default configuration, :font facename='System Monospaced' size=12x8.pal_base.fte:font facename='default'. maps numeric colors to
symbolic names like this:

:p.:font facename='System Monospaced' size=12x8.{ 'black', '0 0' }:font facename='default'.

:p.which are then used in :font facename='System Monospaced' size=12x8.pal_*.fte:font facename='default'. color schemes like this:

:p.:font facename='System Monospaced' size=12x8.{ 'Editor_Selected', 'black&colon.darkCyan' }:font facename='default'.

:p.All numeric color values are listed in the
:link reftype=hd refid='ref-colors'.color reference:elink..

:h2 id='custom-highlight'.Text and colors: syntax highlighting

It would make very little sense to define different colors for text as seen in
:font facename='System Monospaced' size=12x8.pal*.fte:font facename='default'.
files if all text were to be rendered in the same one. eFTE2 lets the user to
define sets of rules governing how text will change color as special symbols,
words, or combinations of them are found, and form patterns that make edition
easier for the user.

:p.This is done creating a :font facename='System Monospaced'
size=12x8.colorizer:font facename='default'. in the configuration. The safest
way to try this is to create a new file, say :font facename='System Monospaced'
size=12x8.test.fte:font facename='default'., and then :hp1.optionally:ehp1.
include it from the main configuration files with ":font
facename='System Monospaced' size=12x8.oinclude test.fte:font
facename='default'.". This way, if this file breaks the configuration, it will
suffice to rename or delete it and the editor will start as normal when it is
not found.

:h3.Coloring files

The absolute minimum to do text highlighting would obviously be two colors. To
do things a bit more interesting, four are defined here for internal use
(assuming they actually map to four different colors as defined in the :font
facename='System Monospaced' size=12x8.pal*.fte:font facename='default'.). This
is a working skeleton :font facename='System Monospaced'
size=12x8.test.fte:font facename='default'. file to expand:

:xmp.colorize TEST {
    SyntaxParser = 'SIMPLE';
    color {
        { 'Normal',      'Editor_Default' },
        { 'Number',      'Lang_DecimalNumber' },
        { 'Punctuation', 'Lang_Punctuation' },
        { 'Comment',     'Lang_Comment' },
    };
}
mode TEST {
    FileNameRx = /\.\c{TST}$/;
    HilitOn    = 1;
    Colorizer  = 'TEST';
}
:exmp.

This will make eFTE2 open :font facename='System Monospaced'
size=12x8.*.tst:font facename='default'. files in 'test' mode, all text in one
color. Note the :font facename='System Monospaced' size=12x8.colorize:font
facename='default'. is not bound in itself to file extensions, nor the other
way round. This allows for the same colorizer to be used for different file
extensions if necessary.

:h3.Changing colors

To alternate between colors, rules must be specified in the :font
facename='System Monospaced' size=12x8.colorize:font facename='default'.
section, after the :font facename='System Monospaced' size=12x8.color:font
facename='default'. pairings between 'internal' colors just declared for
highlighting and global color categories defined for the editor in :font
facename='System Monospaced' size=12x8.pal*.fte:font facename='default'.. The
rules for color change correspond to transitions in a 'state machine'. The
first state must be declared like this:

:xmp.colorize TEST {
    SyntaxParser = 'SIMPLE';
    color { [...] };
    h_state 0 { 'Normal' }
}
:exmp.

which should make all text appear in 'Normal' color, or any of the other three
if the rule is changed accordingly.

:p.Let us imagine now that TEST files allow for comments, ignoring all text
appearing between the character '#' and the end of each line. This will require
a second state and transitions from state 0 to 1 and back to be declared like
this&colon.

:xmp.colorize TEST { [...]
    h_state 0 { 'Normal' }
    h_trans { 1, '', '#', 'Comment' }
    h_state 1 { 'Comment' }
    h_trans { 0, '$', '', 'Normal' }
}
:exmp.

which should result in lines of :font facename='System Monospaced'
size=12x8.test:font facename='default'. files being split in two color regions
on either side of wherever the character '#' appears.

:p.Now some more color could be applied, for example, to mathematical
operations&colon.

:xmp.colorize TEST { [...]
    h_state 0 { 'Normal' }
    h_trans { 0, 's', '-+&colon.=;&lt.&gt.', 'Punctuation' }
    h_trans { 0, 'x', '[0-9]+', 'Number' }
    h_trans { 1, '', '#', 'Comment' }
    h_state 1 { 'Comment' }
    h_trans { 0, '$', '', 'Normal' }
}
:exmp.

Note that the two new highlight rules operate completely within state 0, so no
coloring of numbers or operators takes place in the comments, to the right of
'#'s. An inverted coloring pattern could be easily defined on the comments side
like this&colon.

:xmp.colorize TEST { [...]
    h_state 0 { 'Normal' }
    h_trans { 0, 's', '-+&colon.=;&lt.&gt.', 'Punctuation' }
    h_trans { 0, 'x', '[0-9]+', 'Number' }
    h_trans { 1, '', '#', 'Comment' }
    h_state 1 { 'Comment' }
    h_trans { 1, 's', '-+&colon.=;&lt.&gt.', 'Normal' }
    h_trans { 1, 'x', '[0-9]+', 'Punctuation' }
    h_trans { 0, '$', '', 'Normal' }
}
:exmp.

Additionally, rules for highlighting specific keywords can be added to each
state, either within a given state or with the possibility of state transitions
when keywords are matched or not. The mechanism, though, remains essentially
the same: as the editor explores the file contents, all characters found are
checked against states and transition rules to be given a corresponding color.
If the file contents are altered, so may the colors downstream be.

:p.Please note that all transition rules for any given state are tested
sequentially, that is, the moment a token in the file matches a transition
rule, no more of them are tested, and the cursor is advanced in the file to
start checking again the rules against the new token. It is generally a good
idea to put more specific rules ahead of more general ones in order to reduce
the likelihood of interference.

:p.Syntax highlighting and text coloring can get complicated, and ten or more
states are not a rarity among common colorizers; however, most cases can be
adequately and briefly dealt with after the basic transitions outlined above
are properly mastered.

:h2 id='macros'.Extending editing functionality: macros

Macros are sequences of actions executed automatically to speed up text
editing. Once defined, macros are activated either by pressing an appropriate
key combination or through interface menus, or when invoked from other
macros.

:p.:hp2.Example&colon.:ehp2. putting quotes around some text is done by moving the
cursor to the beginning of the text, inserting a quote character ("), and
doing the same again after moving the cursor to the end of the text to be
quoted. This could be automated by defining a macro to execute after
selecting some text.

:p.In the configuration, macros are semicolon-separated series of commands
between curly braces, i.e.:

:xmp.{
    &lt.command&gt.; # (f.e. InsertString "Hello World!";)
    [...;]
    &lt.command&gt.
}
:exmp.

Any number of :link reftype=hd refid='ref-commands'.commands:elink. in the sequence can be
in the same line; except for the last one, all of them must be followed by a
semicolon.

:p.The example mentioned above could thus look like this:

:xmp.{ MoveBlockStart; InsertString '"';
MoveBlockEnd; InsertString '"' }
:exmp.

Commands in a macro can be optionally preceded by a whole number and a
colon to be executed more than once (f.e.&colon. 3&colon.MoveDown), and a question mark
if failing should not halt the macro (f.e.&colon. ?Replace_1; ?Replace_2;
?Replace_3 ..., or 2&colon.?Find '/').

:p.Macro execution will end after the last command is executed, or halt when
the first command not marked with '?' fails.

:p.Example&mdash.two command sets:

:ol compact.:font facename='System Monospaced' size=12x8.
  :li.Find 'place'; InsertString "X";
  :li.?Find 'place'; InsertString "X";
:eol.:font facename='default'.

:p.These behave the same if 'place' is found -&rarrow. cursor is moved there, and
an X marks the spot.

:p.OTOH if 'place' is not found, 1) stops right there, whereas 2) goes on and
most likely the X ends up in the wrong place...


:h2 id='menus'.Easy access to macros: menus

The first way a user might want to invoke an editing macro, being unfamiliar
with the editor, would be selecting it from a menu. Let us assume, then, that
you want to use the example macro that was described before to put quotes
around blocks of text.

:p.Now, a natural place to put something like this might be the 'Block' menu,
and that must be done at a specific location:
:font facename='System Monospaced' size=12x8.ui_m_fte.fte:font
facename='default'., or whatever other UI style linked from :font
facename='System Monospaced' size=12x8.main.fte:font
facename='default'.&mdash.that one is simply the default.

:p.The code for the menu block will look very similar to the following, maybe
with different :link reftype=fn refid='menu_keylabels'.key shortcut labels
*:elink.&colon.

:xmp.menu Block {
    item &odq.&amp.Unmark\tEsc&cdq.        { BlockUnmark }
    item &odq.Mark &amp.Stream\tAlt+A&cdq. { BlockMarkStream }
    item &odq.Mark &amp.Column\tAlt+K&cdq. { BlockMarkColumn }
    item &odq.Mark &amp.Line\tAlt+L&cdq.   { BlockMarkLine }
    item;
    item &odq.Select Wor&amp.d&cdq.        { BlockSelectWord }
    item &odq.Selec&amp.t Line&cdq.        { BlockSelectLine }
    item;
    item &odq.&amp.Write...&cdq.           { BlockWrite }
    item &odq.&amp.Read Stream...&cdq.     { BlockReadStream }
    item &odq.Re&amp.ad Column...&cdq.     { BlockReadColumn }
    item &odq.Rea&amp.d Line...&cdq.       { BlockReadLine }
    item &odq.&amp.Print&cdq.              { BlockPrint }
    item;
    item &odq.&amp.Indent\tAlt+I&cdq.      { BlockIndent }
    item &odq.U&amp.nindent\tAlt+U&cdq.    { BlockUnindent }
    item &odq.R&amp.eIndent\tAlt+\&cdq.    { BlockReIndent }
    item;
    submenu &odq.Translat&amp.e&cdq.,        Translate;
    item &odq.E&amp.xpand Tabs&cdq.        { BlockUnTab }
    item &odq.&amp.Generate Tabs&cdq.      { BlockEnTab }
    item &odq.Sor&amp.t&cdq.               { BlockSort }
    item &odq.Sort Re&amp.verse&cdq.       { BlockSortReverse }
}
:exmp.

:fn id='menu_keylabels'.Please note that shortcut keys are not really defined
in the menu entries&mdash.if they exist, mere courtesy to the user dictates
they ought to be reflected there. This might not be necessary in the
future.:efn.

:p.All you need to include in the code above is these lines before the closing
curly brace (well, the first line is not really necessary):

:xmp.menu Block {
    ...
    item;
    item "Put block in quotes"
      { MoveBlockStart; InsertString '"'; MoveBlockEnd; InsertString '"' }
}
:exmp.

The next time the editor is started, the item "Put block in quotes" will
be the last one in the 'Block' menu, ready to go when selected after selecting
some block of text.

:p.But it would be even better to be able to invoke any user defined macros
with their own shortcut keys, wouldn't it? After all, the purpose of having
macros is to save time and every keystroke counts.

:p.Instead of binding the same series of commands again to some key definition
we will get to, the first real step to saving work would be to name the macro
so it can be invoked just like any other command&mdash.from the menu above (or
any other), via some key combination, or even from other macros.

:p.This should be easy enough:

:xmp.sub BlockQuote {
    SavePos;
    MoveBlockStart; InsertString '"';
    MoveBlockEnd; InsertString '"' ;
    MoveSavedPos;
}
:exmp.

Actually, commands in any macro can be either internal commands (such as
MoveRight) or other macros that have been previously defined: any macro meant to
be invoked by others must be declared before them.

:p.Example: if we intend to have a macro like

:xmp.sub ComplexStuff {
    [command(s);]
    SimpleStuff;
    [more command(s)]
}
:exmp.

where "SimpleStuff" is another macro we have created, SimpleStuff must
appear in the configuration before ComplexStuff.

:p.So, where in the configuration must named macros appear exactly?

:p.If you have a look at :font facename='System Monospaced' size=12x8.main.fte:font facename='default'., you will see that a bunch of
"mode" (m_*.fte) files are included together. If you browse the bigger ones,
you will see they include named macros in their bodies, but these are not
enclosed in other sections. This means macros are global to the configuration,
so putting them in one file or the other is just a matter of helping to
manage complex configurations more easily.

:p.Since the merging of contents into configuration space is done
sequentially, care must be taken so files containing macro definitions that
invoke other macros are included in the right order, but that is all there is
to it. In general, though, putting macros for one "mode" into that m_*.fte
file is enough&mdash.it is unlikely that macros conceived for some specific
purpose are to be invoked from more than one mode.

:p.But what is a "mode", anyway?

:h2 id='modes'.Editing "modes"

A :hp2.mode:ehp2. is a collection of basic editor settings (such as tab size,
or what is considered a comment) plus editing macros, menus, syntax
highlighting, and/or sets of key combinations that
:link reftype=hd refid='mode-connect'.are bound together:elink. to ease editing
of specific file types&mdash.all of these settings are available at the same
time when editing files of given types, thus conforming an 'editing mode' for
them. Modes are declared like this in the configuration:

:p.:font facename='System Monospaced' size=12x8.:hp2.:link reftype=hd refid='ref-mode'.mode:elink. new[&colon.old]:ehp2. { mode settings }:font facename='default'.

:p.The mode named :font facename='System Monospaced' size=12x8.new:font facename='default'. inherits its initial
:link reftype=hd refid='ref-mode'.settings:elink. from :font facename='System Monospaced' size=12x8.old:font facename='default'. parent mode if one is
specified at declaration, then overrules any values with its own.

:h3 id='mode-load_settings'.Loading files in various formats

Here are appropriate settings for loading files in various formats:

:dl compact.
  :dt.DOS/Win/OS2/NT text files (CR/LF delimited):
  :dd.:xmp.StripChar 13
LineChar 10
AddCR 1
AddLF 1:exmp.
  :dt.Unix text files (LF delimited):
  :dd.:xmp.StripChar -1
LineChar 10
AddCR 0
AddLF 1:exmp.
  :dt.MAC text files (CR delimited):
  :dd.:xmp.StripChar -1
LineChar 13
AddCR 1
AddLF 0:exmp.
  :dt.Binary files (fixed record length):
  :dd.:xmp.StripChar -1
LineChar -1
AddCR 0
AddLF 0
LoadMargin 64
ForceNewLine 0:exmp.
:edl.

:h3 id='mode-select'.Mode selection

To determine what mode to use for a file, eFTE2 will first check if such
mode has been established by the command :link reftype=fn refid='ec.FileOpenInMode'.FileOpenInMode:elink.
or a command line option (:hp2.-m:ehp2.).

:p.If no mode has been set, the file name is then matched to all :link
reftype=fn refid='ms.FileNameRx'.FileNameRx:elink. defined in mode
declarations.

:p.If a mode has not been determined like that yet, the first line of the file
will be read (up to 80 chars), to try and match it with the :link reftype=fn
refid='ms.FirstLineRx'.FirstLineRx:elink. declarations of all modes.

:p.If all of the above fails, the editor will use the mode specified by the
global setting :font facename='System Monospaced' size=12x8.:link reftype=fn
refid='gs.DefaultModeName'.DefaultModeName:elink.:font facename='default'. to
load a file. If such mode does not exist, the first mode defined in the
configuration will be used.

:h3 id='mode-connect'.Mode, syntax highlight and event maps

Besides colors for syntax highlighting, the most visible effects in the editor
come from ":link reftype=hd refid='eventmaps'.event maps:elink.". Remember,
macros, syntax highlighting and menus are defined globally so they can be
shared and linked to different editing modes when/where appropriate. :font
facename='System Monospaced' size=12x8.eventmap:font facename='default'.
sections of the configuration are used to bind user events (key presses and
activation of menus) to one another and to specific modes.

:p.Both syntax highlighting schemes and user events are linked to a given mode
either by having in the configuration a corresponding configuration section
of the appropriate type with the same name, i.e.:

:xmp.mode     'MYMODE'[&colon.PARENT] { mode     settings }
colorize 'MYMODE'[&colon.PARENT] { eventmap settings }
eventmap 'MYMODE'[&colon.PARENT] { eventmap settings }
:exmp.

or by establishing the values :link reftype=fn refid='ms.eventmap'.:font
facename='System Monospaced' size=12x8.EventMap:font facename='default'.:elink.
or :link reftype=fn refid='ms.colorizer'.:font facename='System Monospaced'
size=12x8.Colorizer:font facename='default'.:elink.in the mode settings.

:p.This allows for similar modes to share :font facename='System Monospaced'
size=12x8.eventmap:font facename='default'. and/or
:font facename='System Monospaced' size=12x8.colorize:font facename='default'.
definitions without the need to have additional sections that just inherit
settings from a previous one.

:p.:hp2.Contributor's note&colon.:ehp2. this also seems to be a fail-safe
mechanism, as inferred from some notes in the configuration (notably :font
facename='System Monospaced' size=12x8.ui_vi.fte:font facename='default'. file)
which read "make sure proper eventmap is used".

:h2 id='eventmaps'.Event maps

Eventmap settings sections of the configuration may include activation of
menus, keybindings, and abbreviations as well. If &lt.PARENT&gt. if specified
in the definition, any &lt.PARENT&gt. settings will be inherited by
&lt.MYMODE&gt..

:p.The references for establishing the :link reftype=hd refid='ref-mode'.menus
and keybindings:elink. for a mode should be self-explanatory.

:p.Key combinations can be bound to any macro, just like menu items. Again, all
commands in the macro are executed in sequence until one of them fails.

:p.Keybindings are inherited from parent modes and optionally overriden.

:p.Key names can be preceded by modifiers :hp2.A, C, G, S:ehp2. (for Alt,
Control, Shift, and Grey (numeric pad)). If modifier is followed by a
:hp2.+:ehp2. (plus), the key specification will be matched only if the modifier
key is pressed. If the modifier is followed by :hp2.-:ehp2. (minus), the state
of the modifier key is ignored.

:h3 id='keybinding_examples'.Keybinding examples

Here are some examples of key specifications (see configuration files under
config/kbd for more):

:dl compact.
  :dt.[A]
  :dd.Uppercase a
  :dt.[a]
  :dd.Lowercase a
  :dt.[;]
  :dd.Semicolon
  :dt.[A+A]
  :dd.Alt+A
  :dt.[C+B]
  :dd.Ctrl+B
  :dt.[A+C+F1]
  :dd.Alt+Ctrl+F1
  :dt.[A+C+S+F1]
  :dd.Alt+Ctrl+Shift+F1
  :dt.[A+Space]
  :dd.Alt+Space
  :dt.[C+K_C+B]
  :dd.Ctrl+K and then Ctrl+B (two keys)
  :dt.[C+A_C+B_C+C]
  :dd.Ctrl+A, Ctrl+B and Ctrl+C must be pressed in sequence.
  :dt.[G+-]
  :dd.Gray -
  :dt.[G++]
  :dd.Gray +
  :dt.[C-S-X]
  :dd.X, ignore the state of Ctrl and Shift keys.
  :dt.[C+\\]
  :dd.Ctrl+Backslash
  :dt.[C+\[]
  :dd.Ctrl+[
  :dt.[C+G-Left]
  :dd.Ctrl+Left, ignore difference between the two Left keys.
  :dt.[C+A-A]
  :dd.Ctrl+A, ignore the state of Alt key.
:edl.

:h3 id='abbrevs'.Abbreviations

Abbreviations are used to automatically replace some text or run an editor
macro when some word is typed in. When a non-word character is entered, the
previous word is searched for in the list of abbreviations. If it is found,
the word is either replaced with a new string or a macro is executed.

:p.Some examples of abbreviations:

:xmp.abbrev 'wcsw' 'WinCreateStdWindow';

abbrev 'ifx' {
   KillWordPrev; InsertString 'if () {'; LineIndent; LineNew;
   InsertString '}'; LineIndent;
   MoveUp; MoveLineEnd; 3&colon.MoveLeft.
   Fail; # do not insert typed character
}
:exmp.

The first one defines a replacement string, while the second one defines
an editor macro to be run.

:p.:hp2.N.B.&colon.:ehp2. For abbreviations to work, setting
:link reftype=fn refid='ms.Abbreviations'.Abbreviations:elink. must be set to 1 for active mode.

:h1 id='ref'.Configuration reference

.* :h2 id='ref-sections'.Sections, directives, and comments

The syntax for eFTE2 configuration sections is:

:p.:font facename='System Monospaced' size=12x8.:hp2.type:ehp2. [name[&colon.parent]] { settings }:font facename='default'.

:dl compact.
 :dt.:font facename='System Monospaced' size=12x8.type:font facename='default'.
 :dd.One of :font facename='System Monospaced' size=12x8.object, color_palette, global, sub, colorize, mode, eventmap:font facename='default'..
 :dt.:font facename='System Monospaced' size=12x8.name:font facename='default'.
 :dd.Section :font facename='System Monospaced' size=12x8.object:font facename='default'. may have the privileged name :font facename='System Monospaced' size=12x8.GLOBAL:font facename='default'.,
 :font facename='System Monospaced' size=12x8.color_palette:font facename='default'. can't have a name, :font facename='System Monospaced' size=12x8.sub:font facename='default'. can't have a parent.
 :dt.:font facename='System Monospaced' size=12x8.settings:font facename='default'.
 :dd.Each section type has its own settings syntax.
:edl.

:p.Comments start with :font facename='System Monospaced' size=12x8.#:font facename='default'. anywhere in a line and last until the end
of the line.

:p.:hp2.Note&colon.:ehp2. comments are not allowed in lines starting with compiler
directives :font facename='System Monospaced' size=12x8.%if:font facename='default'., :font facename='System Monospaced' size=12x8.%endif:font facename='default'., :font facename='System Monospaced' size=12x8.%define:font facename='default'., or
:font facename='System Monospaced' size=12x8.%undefine:font facename='default'..

:p.Sections and %if/%endif blocks can be enclosed in one another.

:p.When split across several files, the configuration can incude other files
via the :font facename='System Monospaced' size=12x8.include:font facename='default'. command. Its twin command :font facename='System Monospaced' size=12x8.oinclude:font facename='default'. is meant
for optional files in which users should make their changes, so updating the
base files leaves them intact. Including non-existing files will not halt
loading the configuration if done via :font facename='System Monospaced' size=12x8.oinclude:font facename='default'..

:p.Syntax:

:p.:font facename='System Monospaced' size=12x8.[o]include '[folder/]file.fte';:font facename='default'.

:h2 id='ref-strings'.Strings

Strings can be specified using any of :font facename='System Monospaced' size=12x8.' " /:font facename='default'. characters.

:p.Single quoted strings perform no substitution. To include :font facename='System Monospaced' size=12x8.':font facename='default'. or
:font facename='System Monospaced' size=12x8.\:font facename='default'. in a string, it must be preceded with a backslash.

:p.Double quoted strings perform the following substitutions:

:ul compact.
  :li.\t -&gt. ^I, tab character
  :li.\r -&gt. ^M, CR
  :li.\n -&gt. ^J, LF
  :li.\e -&gt. ^[, escape character
  :li.\v -&gt. ^L, vertical tab
  :li.\b -&gt. ^H, backspace
  :li.\a -&gt. ^G, bell
:eul.

:p.Strings started by :font facename='System Monospaced' size=12x8./:font
facename='default'. character require no escaping (except for '/'). Mostly
useful for specifying :link reftype=hd refid='ref-regexp'.regular
expressions:elink. without double backslashes that are necessary in single and
double quoted strings. In turn, regular expression operators must be escaped to
be interpreted as literal characters while operating with regular expressions.

:h2 id='ref-regexp'.Regular expressions

This is the reference for the particular syntax and operators of regular
expressions in eFTE2, which may be different from other implementations you
are used to. In particular, eFTE2 currently lacks operators to indicate match
lengths other than conditional 0 or 1, but there may be more differences, so
please read carefully.

:p.Also, regular expression match and replace can be conditioned by some :link
reftype=hd refid='use'.flags:elink.. These flags are unrelated to regular
expressions themselves, and are the same used for literal text in :link
reftype=fn refid='ec.FindReplace'.search and replace commands:elink..

:h3 id='regexp-match'.Match Operators

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.\:font facename='default'.
  :dd.(Un)quotes the following character: alphanumeric characters gain a special meaning as described below, and non-alphanumeric operators are interpreted literally (f.e. "\." comes to mean "a single dot" instead of "any character").
  :dt.:font facename='System Monospaced' size=12x8.\n:font facename='default'.
  :dd.Matches a 0x0A (LF) character.
  :dt.:font facename='System Monospaced' size=12x8.\r:font facename='default'.
  :dd.Matches a 0x0D (CR) character.
  :dt.:font facename='System Monospaced' size=12x8.\t:font facename='default'.
  :dd.Matches a 0x09 (TAB) character.
  :dt.:font facename='System Monospaced' size=12x8.\e:font facename='default'.
  :dd.Matches an escape character (0x1B).
  :dt.:font facename='System Monospaced' size=12x8.\s:font facename='default'.
  :dd.Matches whitespace (CR, LF, TAB, SPACE) characters.
  :dt.:font facename='System Monospaced' size=12x8.\S:font facename='default'.
  :dd.Matches non-whitespace (the reverse of \s).
  :dt.:font facename='System Monospaced' size=12x8.\w:font facename='default'.
  :dd.Matches word character [a-zA-Z0-9].
  :dt.:font facename='System Monospaced' size=12x8.\W:font facename='default'.
  :dd.Matches non-word character.
  :dt.:font facename='System Monospaced' size=12x8.\d:font facename='default'.
  :dd.Matches a digit [0-9].
  :dt.:font facename='System Monospaced' size=12x8.\D:font facename='default'.
  :dd.Matches a non-digit.
  :dt.:font facename='System Monospaced' size=12x8.\U:font facename='default'.
  :dd.Matches uppercase characters (A-Z).
  :dt.:font facename='System Monospaced' size=12x8.\L:font facename='default'.
  :dd.Matches lowercase characters (a-z).
  :dt.:font facename='System Monospaced' size=12x8.\x##:font facename='default'.
  :dd.Matches specified hex value (\x0A, \x0D, \x09, etc.).
  :dt.:font facename='System Monospaced' size=12x8.\o###:font facename='default'.
  :dd.Matches specified octal value (\o000, \o015, etc.).
  :dt.:font facename='System Monospaced' size=12x8.\N###:font facename='default'.
  :dd.Matches specified decimal value (\N000, \N013, \N009, etc.).
  :dt.:font facename='System Monospaced' size=12x8.\C:font facename='default'.
  :dd.Starts case sensitive matching.
  :dt.:font facename='System Monospaced' size=12x8.\c:font facename='default'.
  :dd.Starts case insensitive matching.
  :dt.:font facename='System Monospaced' size=12x8.^:font facename='default'.
  :dd.Match a beginning of line.
  :dt.:font facename='System Monospaced' size=12x8.$:font facename='default'.
  :dd.Match an end of line.
  :dt.:font facename='System Monospaced' size=12x8..:font facename='default'.
  :dd.Match any character.
  :dt.:font facename='System Monospaced' size=12x8.&lt.:font facename='default'.
  :dd.Match beginning of word (word consists of [A-Za-z0-9]).
  :dt.:font facename='System Monospaced' size=12x8.&gt.:font facename='default'.
  :dd.Match end of word.
  :dt.:font facename='System Monospaced' size=12x8.[ ]:font facename='default'.
  :dd.Specifies a class of characters ([abc123], [\]\x10], etc), any of which will be matched individually.
  :dt.:font facename='System Monospaced' size=12x8.[ - ]:font facename='default'.
  :dd.Specifies a range of characters ([0-9a-zA-Z_], [0-9], etc).
  :dt.:font facename='System Monospaced' size=12x8.[^ ]:font facename='default'.
  :dd.Specifies complement class ([^a-z], [^\-], etc).
  :dt.:font facename='System Monospaced' size=12x8.?:font facename='default'.
  :dd.Matches preceding pattern optionally (a?bc, filename\.?, $?, etc.).
  :dt.:font facename='System Monospaced' size=12x8.|:font facename='default'.
  :dd.Matches preceding or next pattern (a|b, c|d, abc|d). Only one character will be used as pattern unless grouped together using parenthesis (), or curly braces {}.
  :dt.:font facename='System Monospaced' size=12x8.*:font facename='default'.
  :dd.Match zero or more occurances of preceding pattern. Matching is greedy and will match as much as possible.
  :dt.:font facename='System Monospaced' size=12x8.+:font facename='default'.
  :dd.Match one or more occurances of preceding pattern. Match is greedy.
  :dt.:font facename='System Monospaced' size=12x8.@:font facename='default'.
  :dd.Match zero or more occurances of preceding pattern. Matching is non-greedy and will match as little as possible without causing the rest of the pattern match to fail.
  :dt.:font facename='System Monospaced' size=12x8.#:font facename='default'.
  :dd.Match one or more occurances of preceding pattern. Matching is non-greedy.
  :dt.:font facename='System Monospaced' size=12x8.{ }:font facename='default'.
  :dd.Group patterns together to form complex patterns (f.e.&colon. {abc}, {abc}|{cde}, {abc}?, {word}?).
  :dt.:font facename='System Monospaced' size=12x8.( ):font facename='default'.
  :dd.Group patterns together to form complex patterns. Also used to save the matched substring into the register which can be used for substitution operation. Up to 9 registers can be used.
:edl.

:h3 id='regexp-replace'.Replacement Operators

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.\:font facename='default'.
  :dd.Causes next character to alternate between being interpreted literally, or as a special character.
F.e.&colon. \0, or \\ to get a literal "\".
  :dt.:font facename='System Monospaced' size=12x8.\0:font facename='default'.
  :dd.Recalls entire matched pattern.
  :dt.:font facename='System Monospaced' size=12x8.\1 to \9:font facename='default'.
  :dd.Recalls stored substrings from registers (\1, \2, \3, to \9).
  :dt.:font facename='System Monospaced' size=12x8.\n:font facename='default'.
  :dd.Inserts a 0x0A (LF) character.
  :dt.:font facename='System Monospaced' size=12x8.\r:font facename='default'.
  :dd.Inserts a 0x0D (CR) character.
  :dt.:font facename='System Monospaced' size=12x8.\t:font facename='default'.
  :dd.Inserts a 0x09 (TAB) character.
  :dt.:font facename='System Monospaced' size=12x8.\u:font facename='default'.
  :dd.Convert next character to uppercase.
  :dt.:font facename='System Monospaced' size=12x8.\l:font facename='default'.
  :dd.Convert next character to lowercase.
  :dt.:font facename='System Monospaced' size=12x8.\U:font facename='default'.
  :dd.Convert to uppercase till \E or \e.
  :dt.:font facename='System Monospaced' size=12x8.\L:font facename='default'.
  :dd.Convert to lowercase till \E or \e.
:edl.

:h2 id='ref-global'.Global Settings

:hp2.Note&colon.:ehp2. Many of these have been lifted from the original FTE
documentation w/o further verification. They are styled :color fc=default bc=red.like this text:color fc=default bc=default..

:p.The following settings can be used in the :font facename='System Monospaced'
size=12x8.object :hp2.GLOBAL:ehp2.:font facename='default'. section of the
configuration. Some of the options are platform specific (to be fixed).

:dl compact.
  :dt.:color fc=default bc=red.DefaultModeName:color fc=default bc=default.
  :dd.Default mode name for loading/editing files. If not set or invalid, first mode in the configuration file will be used instead. By default set to 'PLAIN'.
  :dt.:color fc=default bc=red.CompletionFilter:color fc=default bc=default.
  :dd.A :link reftype=hd refid='use-regexp'.regular expression:elink.. Files matching it are ignored when doing filename completion.
  :dt.:color fc=default bc=red.CompileRx:color fc=default bc=default.
  :dd.Defines :link reftype=hd refid='use-regexp'.regular expressions:elink. and their subpattern indices to match when searching for errors and warnings in compilation output.
First number is an index of the subpattern that matches filename.
The second must match the line number, the third parameter is the regular expression to match to each line of the compiler output.
  :dt.:color fc=default bc=red.OpenAfterClose:color fc=default bc=default.
  :dd.If set to 1, editor will prompt for another file when all files are closed.
  :dt.:color fc=default bc=red.SysClipboard:color fc=default bc=default.
  :dd.When set to 1, editor will use external (PM, X11) clipboard instead of internal one.
  :dt.:color fc=default bc=red.ScreenSizeX:color fc=default bc=default.
  :dd.Number of columns visible on screen or window.
  :dt.:color fc=default bc=red.ScreenSizeY:color fc=default bc=default.
  :dd.Number of lines visible on screen or window.
  :dt.:color fc=default bc=red.CursorInsertStart:color fc=default bc=default.
  :dd.Starting percentage of cursor size (from top) when in insert mode.
  :dt.:color fc=default bc=red.CursorInsertEnd:color fc=default bc=default.
  :dd.Ending percentage of cursor size when in insert mode.
  :dt.:color fc=default bc=red.CursorOverStart:color fc=default bc=default.
  :dd.Starting percentage of cursor size when in overstrike mode.
  :dt.:color fc=default bc=red.CursorOverEnd:color fc=default bc=default.
  :dd.Ending percentage of cursor size when in overstrike mode.
  :dt.:color fc=default bc=red.SelectPathname:color fc=default bc=default.
  :dd.If set to 1, pathname will be selected by default when prompting for a file in :link reftype=fn refid='ec.FileOpen'.FileOpen:elink. function. If set to 0, pathname will not be selected, this allows you to quickly type a new filename, without erasing an entire entryfield.
  :dt.:color fc=default bc=red.ShowMenuBar:color fc=default bc=default.
  :dd.If set to 1, main menu bar will be visible.
  :dt.:color fc=default bc=red.ShowVScroll:color fc=default bc=default.
  :dd.If set to 1, scroll bar will be visible.
  :dt.:color fc=default bc=red.ShowHScroll:color fc=default bc=default.
  :dd.If set to 1, scroll bar will be visible.
  :dt.:color fc=default bc=red.KeepHistory:color fc=default bc=default.
  :dd.If set to 1, last file position and input prompt history will be loaded on startup and saved on exit. Can be overriden with command line option '-h'.
  :dt.:color fc=default bc=pink.LoadDesktopOnEntry:color fc=default bc=default.
  :dd.If set to 1, all files listed in :link reftype=fn refid='def-desktop'.desktop file:elink. in current directory or program directory will be loaded into eFTE2. The desktop file can be overriden with command line option '-d'.
    :p.If set to 2, desktop is only loaded (and saved) if there are no files specified on the command line.
  :dt.:color fc=default bc=red.SaveDesktopOnExit:color fc=default bc=default.
  :dd.If set to 1, desktop will be automatically saved when :link reftype=fn refid='ec.ExitEditor'.ExitEditor:elink. command is issued.
  :dt.:color fc=default bc=red.KeepMessages:color fc=default bc=default.
  :dd.If set to 1, compiler messages will be kept until deleted by user.
  :dt.:color fc=default bc=red.ScrollBorderX:color fc=default bc=default.
  :dd.Horizontal offset to the border before window starts scrolling.
  :dt.:color fc=default bc=red.ScrollBorderY:color fc=default bc=default.
  :dd.Vertical offset to the border before window starts scrolling.
  :dt.:color fc=default bc=red.ScrollJumpX:color fc=default bc=default.
  :dd.Scroll window by this many columns when cursor reaches scrolling border.
  :dt.:color fc=default bc=red.ScrollJumpY:color fc=default bc=default.
  :dd.Scroll window by this many lines when cursor reaches scrolling border.
  :dt.:color fc=default bc=red.C_*:color fc=default bc=default.
  :dd.Define the C mode smart indentation parameters.
    :p.See section on :link reftype=hd refid='global-cmode'.configuring C mode indentation:elink..
  :dt.:color fc=default bc=red.REXX_Indent:color fc=default bc=default.
  :dd.Defines the REXX basic indentation level.
:edl.

:fn id='gs.DefaultModeName'.:color fc=default bc=red.DefaultModeName:color
fc=default bc=default.&colon. Default mode name for loading/editing files. If not set
or invalid, first mode in the configuration file will be used instead. By
default set to 'PLAIN'.:efn..

:fn id='gs.CompletionFilter'.:color fc=default bc=red.CompletionFilter:color
fc=default bc=default.&colon. A :link reftype=hd refid='use-regexp'.regular
expression:elink.. Files matching it are ignored when doing filename
completion.:efn..

:fn id='gs.CompileRx'.:color fc=default bc=red.CompileRx:color fc=default
bc=default.&colon. Defines :link reftype=hd refid='use-regexp'.regular
expressions:elink. and their subpattern indices to match when searching for
errors and warnings in compilation output. First number is an index of the
subpattern that matches filename. The second must match the line number, the
third parameter is the regular expression to match to each line of the compiler
output.:efn..

:fn id='gs.OpenAfterClose'.:color fc=default bc=red.OpenAfterClose:color
fc=default bc=default.&colon. If set to 1, editor will prompt for another file when
all files are closed.:efn..

:fn id='gs.SysClipboard'.:color fc=default bc=red.SysClipboard:color fc=default
bc=default.&colon. When set to 1, editor will use external (PM, X11) clipboard
instead of internal one.:efn..

:fn id='gs.ScreenSizeX'.:color fc=default bc=red.ScreenSizeX:color fc=default
bc=default.&colon. Number of columns visible on screen or window.:efn..

:fn id='gs.ScreenSizeY'.:color fc=default bc=red.ScreenSizeY:color fc=default
bc=default.&colon. Number of lines visible on screen or window.:efn..

:fn id='gs.CursorInsertStart'.:color fc=default bc=red.CursorInsertStart:color
fc=default bc=default.&colon. Starting percentage of cursor size (from top) when in
insert mode.:efn..

:fn id='gs.CursorInsertEnd'.:color fc=default bc=red.CursorInsertEnd:color
fc=default bc=default.&colon. Ending percentage of cursor size when in insert
mode.:efn..

:fn id='gs.CursorOverStart'.:color fc=default bc=red.CursorOverStart:color
fc=default bc=default.&colon. Starting percentage of cursor size when in overstrike
mode.:efn..

:fn id='gs.CursorOverEnd'.:color fc=default bc=red.CursorOverEnd:color
fc=default bc=default.&colon. Ending percentage of cursor size when in overstrike
mode.:efn..

:fn id='gs.SelectPathname'.:color fc=default bc=red.SelectPathname:color
fc=default bc=default.&colon. If set to 1, pathname will be selected by default when
prompting for a file in :link reftype=fn refid='ec.FileOpen'.FileOpen:elink.
function. If set to 0, pathname will not be selected, this allows you to
quickly type a new filename, without erasing an entire entryfield.:efn..

:fn id='gs.ShowMenuBar'.:color fc=default bc=red.ShowMenuBar:color fc=default
bc=default.&colon. If set to 1, main menu bar will be visible.:efn..

:fn id='gs.ShowVScroll'.:color fc=default bc=red.ShowVScroll:color fc=default
bc=default.&colon. If set to 1, scroll bar will be visible.:efn..

:fn id='gs.ShowHScroll'.:color fc=default bc=red.ShowHScroll:color fc=default
bc=default.&colon. If set to 1, scroll bar will be visible.:efn..

:fn id='gs.KeepHistory'.:color fc=default bc=red.KeepHistory:color fc=default
bc=default.&colon. If set to 1, last file position and input prompt history will be
loaded on startup and saved on exit. Can be overriden with command line option
'-h'.:efn..

:fn id='gs.LoadDesktopOnEntry'.:color fc=default
bc=pink.LoadDesktopOnEntry:color fc=default bc=default.&colon. If set to 1, all files
listed in :link reftype=fn refid='def-desktop'.desktop file:elink. in current
directory or program directory will be loaded into eFTE2. The desktop file can
be overriden with command line option '-d'.
:p.If set to 2, desktop is only loaded (and saved) if there are no files
specified on the command line.:efn..

:fn id='gs.SaveDesktopOnExit'.:color fc=default bc=red.SaveDesktopOnExit:color
fc=default bc=default.&colon. If set to 1, desktop will be automatically saved when
:link reftype=fn refid='ec.ExitEditor'.ExitEditor:elink. command is
issued.:efn..

:fn id='gs.KeepMessages'.:color fc=default bc=red.KeepMessages:color fc=default
bc=default.&colon. If set to 1, compiler messages will be kept until deleted by
user.:efn..

:fn id='gs.ScrollBorderX'.:color fc=default bc=red.ScrollBorderX:color
fc=default bc=default.&colon. Horizontal offset to the border before window starts
scrolling.:efn..

:fn id='gs.ScrollBorderY'.:color fc=default bc=red.ScrollBorderY:color
fc=default bc=default.&colon. Vertical offset to the border before window starts
scrolling.:efn..

:fn id='gs.ScrollJumpX'.:color fc=default bc=red.ScrollJumpX:color fc=default
bc=default.&colon. Scroll window by this many columns when cursor reaches scrolling
border.:efn..

:fn id='gs.ScrollJumpY'.:color fc=default bc=red.ScrollJumpY:color fc=default
bc=default.&colon. Scroll window by this many lines when cursor reaches scrolling
border.:efn..

:fn id='gs.REXX_Indent'.:color fc=default bc=red.REXX_Indent:color fc=default
bc=default.&colon. Defines the REXX basic indentation level.:efn..

:h3 id='global-cmode'.C mode Smart Indentation settings

:dl compact.
  :dt.:color fc=default bc=red.:hp2.C_Indent:ehp2.:color fc=default bc=default.
  :dd.Basic C indentation level.
  :dt.:color fc=default bc=red.:hp2.C_BraceOfs:ehp2.:color fc=default bc=default.
  :dd.Brace '{' offset.
  :dt.:color fc=default bc=red.:hp2.C_CaseOfs:ehp2.:color fc=default bc=default.
  :dd.Offset of case and default statements.
  :dt.:color fc=default bc=red.:hp2.C_CaseDelta:ehp2.:color fc=default bc=default.
  :dd.Offsets of statements following case/default.
  :dt.:color fc=default bc=red.:hp2.C_ClassOfs:ehp2.:color fc=default bc=default.
  :dd.Offset of public, private and protected.
  :dt.:color fc=default bc=red.:hp2.C_ClassDelta:ehp2.:color fc=default bc=default.
  :dd.Offset of statements following public, private, protected.
  :dt.:color fc=default bc=red.:hp2.C_ColonOfs:ehp2.:color fc=default bc=default.
  :dd.Offset of labels.
  :dt.:color fc=default bc=red.:hp2.C_CommentOfs:ehp2.:color fc=default bc=default.
  :dd.Offset of comments.
  :dt.:color fc=default bc=red.:hp2.C_CommentDelta:ehp2.:color fc=default bc=default.
  :dd.Offset of second line of comments.
  :dt.:color fc=default bc=red.:hp2.C_FirstLevelWidth:ehp2.:color fc=default bc=default.
  :dd.Width of the first indentation level (indent of '{' in the function start).
  :dt.:color fc=default bc=red.:hp2.C_FirstLevelIndent:ehp2.:color fc=default bc=default.
  :dd.Indentation of statements in the first indentation level.
  :dt.:color fc=default bc=red.:hp2.C_ParenDelta:ehp2.:color fc=default bc=default.
  :dd.When &ge. 0, offset of continued text after '('. When set to -1, the offset is equal to position of '(' plus one.
:edl.

:p.Example 1:

:xmp.
class line {
public:                   // C_ClassOfs = 0
    line();               // C_ClassDelta = 4
    ~line();
};
int main() {
    int x = 1;
    /*                    // C_CommentOfs = 0
     * check value        // C_CommentDelta = 1
     */
    puts("main");         // C_Indent = 4
    if (x)
    {                     // C_BraceOfs = 0
        switch (x) {
        case 1:           // C_CaseOfs = 0
            puts("ok");   // C_CaseDelta = 4
            break;
        }
    }
end:
    return 0;
}
:exmp.

Example 2:

:xmp.
class line {
  public:                     // C_ClassOfs = 2
    line();                   // C_ClassDelta = 2
    ~line();
};
int main() {
    int x = 1;
      /*                      // C_CommentOfs = 2
      ** check value          // C_CommentDelta = 0
      */
    puts("main");             // C_Indent = 4
    if (x)
    {                         // C_BraceOfs = 0
        switch (x) {
            case 1:           // C_CaseOfs = 4
                puts("ok");   // C_CaseDelta = 4
                break;
        }
    }
end:
    return 0;
}
:exmp.

:h2 id='ref-colors'.Interface colors

The syntax for color settings is:

:p.:font facename='System Monospaced' size=12x8.:hp2.color_palette:ehp2. { { 'name', 'value' } [, ...] }:font facename='default'.

:dl compact.
  :dt.name
  :dd.Any symbolic name defined here for later use.
  :dt.value
  :dd.Either a colon-separated pair of symbolic names, or a space-separated pair of numeric values; the first item in 'value' is for background, the second one for foreground.
:edl.

:p.Numeric values of colors:

:dl compact.
  :dt.0 (High bit 0, RGB mask 000)
  :dd.Black
  :dt.1 (High bit 0, RGB mask 001)
  :dd.Dark Blue
  :dt.2 (High bit 0, RGB mask 010)
  :dd.Dark Green
  :dt.3 (High bit 0, RGB mask 011)
  :dd.Dark Cyan
  :dt.4 (High bit 0, RGB mask 100)
  :dd.Dark Red
  :dt.5 (High bit 0, RGB mask 101)
  :dd.Dark Magenta
  :dt.6 (High bit 0, RGB mask 110)
  :dd.Orange
  :dt.7 (High bit 0, RGB mask 111)
  :dd.Pale Gray
  :dt.8 (High bit 1, RGB mask 000)
  :dd.Dark Gray
  :dt.9 (High bit 1, RGB mask 001)
  :dd.Blue
  :dt.A (High bit 1, RGB mask 010)
  :dd.Green
  :dt.B (High bit 1, RGB mask 011)
  :dd.Cyan
  :dt.C (High bit 1, RGB mask 100)
  :dd.Red
  :dt.D (High bit 1, RGB mask 101)
  :dd.Magenta
  :dt.E (High bit 1, RGB mask 110)
  :dd.Yellow
  :dt.F (High bit 1, RGB mask 111)
  :dd.White
:edl.

:h2 id='ref-colorize'.Syntax highlighting

Syntax:

:p.:font facename='System Monospaced' size=12x8.:hp2.colorize new[&colon.old]:ehp2. { settings }:font facename='default'.

:p.If specified, colorizer :font facename='System Monospaced' size=12x8.&lt.new&gt.:font facename='default'. inherits settings from
:font facename='System Monospaced' size=12x8.&lt.old&gt.:font facename='default'..

:p.Settings:

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.SyntaxParser:ehp2. = "&lt.parser&gt.";:font facename='default'.
  :dd.Activates the specified syntax parser for highlighting mode.
    :font facename='System Monospaced' size=12x8.&lt.Parser&gt.:font facename='default'. can be any of:
    :dl compact.
      :dt.PLAIN
      :dd.No syntax parser, only :link reftype=fn refid='hl_keyword'.keyword highlighting:elink. is available.
      :dt.SIMPLE
      :dd.:link reftype=hd refid='hl_simple'.User configurable syntax parser:elink. will be defined.
      :dt.C
      :dt.REXX
      :dt.HTML
      :dt.PERL
      :dt.MAKE
      :dt.DIFF
      :dd.For viewing output of :hp2.diff:ehp2..
      :dt.MERGE
      :dd.For editing output of :hp2.rcsmerge:ehp2. (RCS, CVS).
      :dt.IPF
      :dt.Ada
      :dt.MSG
      :dd.For editing E-Mail.
      :dt.SH
      :dt.PASCAL
      :dt.TEX
      :dt.FTE
      :dt.CATBS
      :dd.For :hp2.VIEWING ONLY:ehp2. of :hp2.nroff:ehp2. formatted man-pages (formatted with backspaces).
    :edl.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.color:ehp2. { { color match } [, { color match }... ] };:font facename='default'.
  :dd.Each "color match" couples color names internal to the colorizer and
symbolic color names defined globally:
:xmp.:font facename='System Monospaced' size=12x8.{ "highlight_color", ":link reftype=hd refid='colors'.global_name:elink." }:font facename='default'.
:exmp.
:font facename='System Monospaced' size=12x8.highlight_color:font
facename='default'. must be one of "Normal", "Keyword", "String", "Comment",
"CPreprocessor", "Regexp", "Header", "Quotes", "Number", "HexNumber",
"OctalNumber", "FloatNumber", "Function", "Command", "Tag", "Punctuation",
"New", "Old", "Changed", "Control", "Separator", "Variable", "Symbol",
"Directive", "Label", "Special", "QuoteDelim", "RegexpDelim".
  :dt.:font facename='System Monospaced' size=12x8.:hp2.keyword ":link reftype=hd refid='colors'.color_name:elink.":ehp2. { "some_keyword" [, "other_keyword"[, ...]]};:font facename='default'.
  :dd.Multiple keyword sets with different colors can be defined.
:font facename='System Monospaced' size=12x8.color_name:font facename='default'. is always a global editor color name.
:edl.

:fn id='hl_color'. :font facename='System Monospaced' size=12x8.highlight_color:font
facename='default'. must be one of "Normal", "Keyword", "String", "Comment",
"CPreprocessor", "Regexp", "Header", "Quotes", "Number", "HexNumber",
"OctalNumber", "FloatNumber", "Function", "Command", "Tag", "Punctuation",
"New", "Old", "Changed", "Control", "Separator", "Variable", "Symbol",
"Directive", "Label", "Special", "QuoteDelim", "RegexpDelim".:efn.

:fn id='hl_keyword'.:font facename='System Monospaced' size=12x8.:hp2.keyword ":link reftype=hd refid='colors'.color_name:elink.":ehp2. { "some_keyword" [, "other_keyword"[, ...]]};:font facename='default'.&colon.
Multiple keyword sets with different colors can be defined.:efn.

:h3 id='hl_simple'.Configurable Syntax Parser

When :hp2.SyntaxParser:ehp2. is set to "SIMPLE", the following commands can be
used to configure the state machine used for parsing the text:

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.h_state:ehp2. state_number { ":link reftype=fn refid='hl_color'.color_name:elink." }:font facename='default'.
  :dd.Defines a new state for the state machine.
    :p.States must be numbered sequentially from 0 without skipping any numbers.
    :p.The color denoted by internal name will be used for characters that are not matched by any transition string or keyword.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.h_wtype:ehp2. { next_state_if_matched, next_state_if_not_matched, next_state_if_otheronly, "state_flags", "keyword_charset" }:font facename='default'.
  :dd.Specifies the keyword matching parameters for current state. There can be only one :hp2.h_wtype:ehp2. keyword per state.
    :p.:hp2.h_wtype:ehp2. takes the following arguments:
    :dl compact.
      :dt.:font facename='System Monospaced' size=12x8.next_state_if_matched:font facename='default'.
      :dd.-1 to keep current state, or the number of the next state to go into if a keyword is matched.
      :dt.:font facename='System Monospaced' size=12x8.next_state_if_not_matched:font facename='default'.
      :dd.-1 to keep current state, or the number of the next state to go into if a string other than a keyword is found.
      :dt.:font facename='System Monospaced' size=12x8.next_state_if_otheronly:font facename='default'.
      :dd.-1 to keep current state, or the number of the next state to go into if only characters not in the specified charset are found.
      :dt.:font facename='System Monospaced' size=12x8.state_flags:font facename='default'.
      :dd.String containing zero or more of the following characters:
        :dl compact.
          :dt.:hp2.i:ehp2.
          :dd.Keyword matching is performed case-insensitively.
        :edl.
      :dt.:font facename='System Monospaced' size=12x8.keyword_charset:font facename='default'.
      :dd.A character set such as 'a-zA-Z0-9_$@'.
    :edl.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.h_trans:ehp2. { next_state, trans_flags, trans_match, 'color_name' }:font facename='default'.
  :dd.:font facename='System Monospaced' size=12x8.h_trans:font facename='default'. defines a new state transition for current state. It takes the following parameters:
    :dl compact.
      :dt.:font facename='System Monospaced' size=12x8.next_state:font facename='default'.
      :dd.The number of next state to go if a match is successful.
      :dt.:font facename='System Monospaced' size=12x8.trans_flags:font facename='default'.
      :dd.Determines options for matching :font facename='System Monospaced' size=12x8.trans_match:font facename='default'.. Can contain zero or more of the following characters:
        :dl compact.
          :dt.:hp2.^:ehp2.
          :dd.Matches only at beginning of line.
          :dt.:hp2.$:ehp2.
          :dd.Matches only at end of line.
          :dt.:hp2.i:ehp2.
          :dd.Match is case-insensitive.
          :dt.:color fc=default bc=pink.:hp2.s:ehp2.:color fc=default bc=default.
          :dd.:font facename='System Monospaced' size=12x8.trans_match:font facename='default'. is a character set. Matches only if the next character is part of the set.
"-" is allowed in :font facename='System Monospaced' size=12x8.trans_match:font facename='default'. to specify ranges of characters, f.e: 'A-J0-9'. If "-" is part of the set, it must be the first character in it or escaped.
          :dt.:hp2.S:ehp2.
          :dd.Same as 's' but next character must not be part of the set.
          :dt.:hp2.x:ehp2.
          :dd.:font facename='System Monospaced' size=12x8.trans_match:font facename='default'. is a regular expression.
If some part of expression is enclosed in parentheses, pointer is advanced up to the start of parenthesized match (WARNING: this can cause infinite loops).
          :dt.:hp2.-:ehp2.
          :dd.After successfull match, the pointer is not advanced, matching will resume at the same position in next state. (WARNING: this can cause infinite loops).
          :dt.:hp2.&lt.:ehp2.
          :dd.The matched character(s) are tagged with current state number.
This is important for proper operation of :hp2.:link reftype=fn refid='ec.MatchBracket'.MatchBracket:elink.:ehp2. command.
MatchBracket will only match braces tagged with same state number.
          :dt.:hp2.&gt.:ehp2.
          :dd.The matched character(s) are tagged with next state number.
          :dt.:hp2.q:ehp2.
          :dd.On successful match quote the next character (the next character is not used for matching).
          :dt.:hp2.Q:ehp2.
          :dd.On successful match quote the end of line (the end of line is not used for matching).
        :edl.
      :dt.:font facename='System Monospaced' size=12x8.trans_match:font facename='default'.
      :dd.When :hp2.S:ehp2. or :hp2.s:ehp2. options are used, a set of characters, any of which should be matched.
When :hp2.S:ehp2. or :hp2.s:ehp2. options are not used, a string to be matched. If :hp2.x:ehp2. is specified,
:font facename='System Monospaced' size=12x8.trans_match:font facename='default'. is a regular expression with its corresponding matching operators and escaped characters.
    :edl.
  :dt.:font facename='System Monospaced' size=12x8.:hp2.h_words:ehp2. ":link reftype=hd refid='colors'.color_name:elink." { "some_keyword" [,"another_keyword" ... }:font facename='default'.
  :dd.Specifies the set of keywords to match in this state. All characters in keywords must be part of the :font facename='System Monospaced' size=12x8.keyword_charset:font facename='default'. in :hp2.h_wtype:ehp2. command for this mode.
    :p.Works the same way as :font facename='System Monospaced' size=12x8.:link reftype=fn refid='hl_keyword'.keyword:elink.:font facename='default'. but keywords are for current state only.
    :p.Multiple keyword sets with different colors can be defined.
    :p.'-' can be used for color specifier to use the default keyword color specified in global settings.
:edl.

:h2 id='ref-macros'.Editing macros

A macro can be declared to have a name assigned for invocation, or be directly
assigned to a menu or keybinding without being declared.

:p.Syntax:

:xmp.:hp2.sub:ehp2. &lt.macro name&gt. { macro }
:exmp.

or

:xmp.menu &lt.menu name&gt. {
    [...;] item "&lt.title&gt." { macro } [;...]
}
:exmp.

or

:xmp.eventmap &lt.mode...&gt. {
    [...;] key &lt.keyspec&gt. { macro } [;...]
}
:exmp.

:font facename='System Monospaced' size=12x8.macro:font facename='default'.
breakdown:

:xmp.[n&colon.][?]command[; more commands]
:exmp.

:dl compact.
  :dt.:font facename='System Monospaced' size=12x8.n:font facename='default'.
  :dd.How many times
:font facename='System Monospaced' size=12x8.command:font facename='default'. will be executed.
  :dt.:font facename='System Monospaced' size=12x8.?:font facename='default'.
  :dd.Flag: if present, continue macro execution even if
:font facename='System Monospaced' size=12x8.command:font facename='default'. fails.
  :dt.:font facename='System Monospaced' size=12x8.command:font facename='default'.
  :dd.Any other macro previously declared, or editor
:link reftype=hd refid='ref-commands'.internal command:elink. (see next section).
:edl.

:h2 id='ref-commands'.Internal commands

:hp2.Note&colon.:ehp2. Most of these have been lifted from the original FTE
documentation without further verification. They are styled
:color fc=default bc=red.like this text:color fc=default bc=default..

:ul compact.
  :li.:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.
  :li.:link reftype=hd refid='cmd_delete'.Deleting text:elink.
  :li.:link reftype=hd refid='cmd_line'.Line commands:elink.
  :li.:link reftype=hd refid='cmd_block'.Block commands:elink.
  :li.:link reftype=hd refid='cmd_edit'.Text editing:elink.
  :li.:link reftype=hd refid='cmd_fold'.Folding text:elink.
  :li.:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.
  :li.:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.
  :li.:link reftype=hd refid='cmd_file'.File commands:elink.
  :li.:link reftype=hd refid='cmd_directory'.Directory commands:elink.
  :li.:link reftype=hd refid='cmd_search'.Search and replace:elink.
  :li.:link reftype=hd refid='cmd_window'.Window commands:elink.
  :li.:link reftype=hd refid='cmd_compile'.Compiler support:elink.
  :li.:link reftype=hd refid='cmd_cvs'.CVS support:elink.
  :li.:link reftype=hd refid='cmd_tags'.TAGS commands:elink.
  :li.:link reftype=hd refid='cmd_option'.Option commands:elink.
  :li.:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.
:eul.

:h3 id='cmd_cursor'.Cursor movement

:dl compact.
  :dt.MoveDown
  :dd.Move cursor to next line.
  :dt.MoveUp
  :dd.Move cursor to previous line.
  :dt.MoveLeft
  :dd.Move cursor to previous column.
  :dt.MoveRight
  :dd.Move cursor to next column.
  :dt.MovePrev
  :dd.Move cursor to previous character.
Moves to end of the previous line if cursor is at the beginning of line.
  :dt.MoveNext
  :dd.Move cursor to next character.
Moves to the beginning of next line if cursor is at the end of line.
  :dt.:color fc=default bc=red.MoveWordLeft:color fc=default bc=default.
  :dd.Move cursor to the beginning of the word on the left.
  :dt.:color fc=default bc=red.MoveWordRight:color fc=default bc=default.
  :dd.Move cursor to the beginning of the word on the right.
  :dt.:color fc=default bc=red.MoveWordPrev:color fc=default bc=default.
  :dd.Move cursor to the beginning of the previous word.
  :dt.:color fc=default bc=red.MoveWordNext:color fc=default bc=default.
  :dd.Move cursor to the beginning of the next word.
  :dt.:color fc=default bc=red.MoveWordEndLeft:color fc=default bc=default.
  :dd.Move cursor to the end of the previous word.
  :dt.:color fc=default bc=red.MoveWordEndRight:color fc=default bc=default.
  :dd.Move cursor to the end of the word on the right.
  :dt.:color fc=default bc=red.MoveWordEndPrev:color fc=default bc=default.
  :dd.Move cursor to the end of the previous word.
  :dt.:color fc=default bc=red.MoveWordEndNext:color fc=default bc=default.
  :dd.Move cursor to the end of the next word.
  :dt.:color fc=default bc=red.MoveWordOrCapLeft:color fc=default bc=default.
  :dd.Move cursor to the beginning of the word or capital letter on the right.
  :dt.:color fc=default bc=red.MoveWordOrCapRight:color fc=default bc=default.
  :dd.Move cursor to the beginning of the word or capital letter on the left.
  :dt.:color fc=default bc=red.MoveWordOrCapPrev:color fc=default bc=default.
  :dd.Move cursor to the beginning of the previous word or to previous capital letter.
  :dt.:color fc=default bc=red.MoveWordOrCapNext:color fc=default bc=default.
  :dd.Move cursor to the beginning of the next word or to next capital letter.
  :dt.:color fc=default bc=red.:color fc=default bc=default. MoveWordOrCapEndLeft
  :dd.Move cursor to the end of the word or capitals on the left.
  :dt.:color fc=default bc=red.:color fc=default bc=default. MoveWordOrCapEndRight
  :dd.Move cursor to the end of the word or capitals on the right.
  :dt.:color fc=default bc=red.:color fc=default bc=default. MoveWordOrCapEndPrev
  :dd.Move cursor to the end of the previous word or capitals.
  :dt.:color fc=default bc=red.:color fc=default bc=default. MoveWordOrCapEndNext
  :dd.Move cursor to the end of the next word or capitals.
  :dt.MoveLineStart
  :dd.Move cursor to the beginning of line.
  :dt.MoveLineEnd
  :dd.Move cursor to the end of line.
  :dt.:color fc=default bc=red.MovePageStart:color fc=default bc=default.
  :dd.Move cursor to the first line on current page.
  :dt.:color fc=default bc=red.MovePageEnd:color fc=default bc=default.
  :dd.Move cursor to the last line on currently page.
  :dt.:color fc=default bc=red.MovePageUp:color fc=default bc=default.
  :dd.Display previous page.
  :dt.:color fc=default bc=red.MovePageDown:color fc=default bc=default.
  :dd.Display next page.
  :dt.MoveFileStart
  :dd.Move cursor to the beginning of file.
  :dt.MoveFileEnd
  :dd.Move cursor to the end of file.
  :dt.:color fc=default bc=red.MovePageLeft:color fc=default bc=default.
  :dd.Scroll horizontally to display page on the left.
  :dt.:color fc=default bc=red.MovePageRight:color fc=default bc=default.
  :dd.Scroll horizontally to display page on the right.
  :dt.MoveBlockStart
  :dd.Move cursor to the beginning of selected block.
  :dt.MoveBlockEnd
  :dd.Move cursor to end beginning of selected block.
  :dt.MoveFirstNonWhite
  :dd.Move cursor to the first non-blank character on line.
  :dt.MoveLastNonWhite
  :dd.Move cursor to the last non-blank character on line.
  :dt.:color fc=default bc=red.MovePrevEqualIndent:color fc=default bc=default.
  :dd.Move cursor to the previous line with equal indentation.
  :dt.:color fc=default bc=red.MoveNextEqualIndent:color fc=default bc=default.
  :dd.Move cursor to the next line with equal indentation.
  :dt.:color fc=default bc=red.MovePrevTab:color fc=default bc=default.
  :dd.Move cursor to the previous tab position.
  :dt.:color fc=default bc=red.MoveNextTab:color fc=default bc=default.
  :dd.Move cursor to the next tab position.
  :dt.:color fc=default bc=red.MoveTabStart:color fc=default bc=default.
  :dd.When cursor is on the tab characters, moves it to the beginning of the tab.
  :dt.:color fc=default bc=red.MoveTabEnd:color fc=default bc=default.
  :dd.When cursor is on the tab characters, moves it to the end of the tab.
  :dt.:color fc=default bc=red.MoveLineTop:color fc=default bc=default.
  :dd.Scroll the file to make the current line appear on the top of the window.
  :dt.:color fc=default bc=red.MoveLineCenter:color fc=default bc=default.
  :dd.Scroll the file to make the current line appear on the center of the window.
  :dt.:color fc=default bc=red.MoveLineBottom:color fc=default bc=default.
  :dd.Scroll the file to make the current line appear on the bottom of the window.
  :dt.:color fc=default bc=red.ScrollLeft:color fc=default bc=default.
  :dd.Scroll screen left.
  :dt.:color fc=default bc=red.ScrollRight:color fc=default bc=default.
  :dd.Scroll screen right.
  :dt.:color fc=default bc=red.ScrollDown:color fc=default bc=default.
  :dd.Scroll screen down.
  :dt.:color fc=default bc=red.ScrollUp:color fc=default bc=default.
  :dd.Scroll screen up.
  :dt.:color fc=default bc=red.MoveFoldTop:color fc=default bc=default.
  :dd.Move to the beginning of current fold.
  :dt.:color fc=default bc=red.MoveFoldPrev:color fc=default bc=default.
  :dd.Move to the beginning of previous fold.
  :dt.:color fc=default bc=red.MoveFoldNext:color fc=default bc=default.
  :dd.Move to the beginning of next fold.
  :dt.:color fc=default bc=red.MoveBeginOrNonWhite:color fc=default bc=default.
  :dd.Move to beginning of line, or to first non blank character.
  :dt.:color fc=default bc=red.:color fc=default bc=default. MoveBeginLinePageFile
  :dd.Move to the beginning of line. If there already, move to the beginning page. If there already, move to the beginning of file.
  :dt.:color fc=default bc=red.MoveEndLinePageFile:color fc=default bc=default.
  :dd.Move to the end of line. If there already, move to the end page. If there already, move to the end of file.
  :dt.:color fc=default bc=red.MoveToLine:color fc=default bc=default.
  :dd.Move to line number given as argument.
  :dt.:color fc=default bc=red.MoveToColumn:color fc=default bc=default.
  :dd.Move to column given as argument.
  :dt.:color fc=default bc=red.MoveSavedPosCol:color fc=default bc=default.
  :dd.Move to column from saved position.
  :dt.:color fc=default bc=red.MoveSavedPosRow:color fc=default bc=default.
  :dd.Move to line from saved position.
  :dt.MoveSavedPos
  :dd.Move to saved position.
  :dt.SavePos
  :dd.Save current cursor position.
  :dt.:color fc=default bc=red.MovePrevPos:color fc=default bc=default.
  :dd.Move to last cursor position.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.MoveDown'.MoveDown: Move cursor to next line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveUp'.MoveUp: Move cursor to previous line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLeft'.MoveLeft: Move cursor to previous column.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveRight'.MoveRight: Move cursor to next column.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePrev'.MovePrev: Move cursor to previous character. Moves to end of the previous line if cursor is at the beginning of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveNext'.MoveNext: Move cursor to next character. Moves to the beginning of next line if cursor is at the end of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordLeft'.:color fc=default bc=red.MoveWordLeft:color fc=default bc=default.&colon. Move cursor to the beginning of the word on the left.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordRight'.:color fc=default bc=red.MoveWordRight:color fc=default bc=default.&colon. Move cursor to the beginning of the word on the right.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordPrev'.:color fc=default bc=red.MoveWordPrev:color fc=default bc=default.&colon. Move cursor to the beginning of the previous word.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordNext'.:color fc=default bc=red.MoveWordNext:color fc=default bc=default.&colon. Move cursor to the beginning of the next word.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordEndLeft'.:color fc=default bc=red.MoveWordEndLeft:color fc=default bc=default.&colon. Move cursor to the end of the previous word.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordEndRight'.:color fc=default bc=red.MoveWordEndRight:color fc=default bc=default.&colon. Move cursor to the end of the word on the right.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordEndPrev'.:color fc=default bc=red.MoveWordEndPrev:color fc=default bc=default.&colon. Move cursor to the end of the previous word.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordEndNext'.:color fc=default bc=red.MoveWordEndNext:color fc=default bc=default.&colon. Move cursor to the end of the next word.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapLeft'.:color fc=default bc=red.MoveWordOrCapLeft:color fc=default bc=default.&colon. Move cursor to the beginning of the word or capital letter on the right.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapRight'.:color fc=default bc=red.MoveWordOrCapRight:color fc=default bc=default.&colon. Move cursor to the beginning of the word or capital letter on the left.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapPrev'.:color fc=default bc=red.MoveWordOrCapPrev:color fc=default bc=default.&colon. Move cursor to the beginning of the previous word or to previous capital letter.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapNext'.:color fc=default bc=red.MoveWordOrCapNext:color fc=default bc=default.&colon. Move cursor to the beginning of the next word or to next capital letter.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapEndLeft'.:color fc=default bc=red.MoveWordOrCapEndLeft:color fc=default bc=default.&colon. Move cursor to the end of the word or capitals on the left.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapEndRight'.:color fc=default bc=red.MoveWordOrCapEndRight:color fc=default bc=default.&colon. Move cursor to the end of the word or capitals on the right.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapEndPrev'.:color fc=default bc=red.MoveWordOrCapEndPrev:color fc=default bc=default.&colon. Move cursor to the end of the previous word or capitals.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveWordOrCapEndNext'.:color fc=default bc=red.MoveWordOrCapEndNext:color fc=default bc=default.&colon. Move cursor to the end of the next word or capitals.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLineStart'.MoveLineStart: Move cursor to the beginning of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLineEnd'.MoveLineEnd: Move cursor to the end of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePageStart'.:color fc=default bc=red.MovePageStart:color fc=default bc=default.&colon. Move cursor to the first line on current page.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePageEnd'.:color fc=default bc=red.MovePageEnd:color fc=default bc=default.&colon. Move cursor to the last line on currently page.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePageUp'.:color fc=default bc=red.MovePageUp:color fc=default bc=default.&colon. Display previous page.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePageDown'.:color fc=default bc=red.MovePageDown:color fc=default bc=default.&colon. Display next page.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFileStart'.MoveFileStart: Move cursor to the beginning of file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFileEnd'.MoveFileEnd: Move cursor to the end of file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePageLeft'.:color fc=default bc=red.MovePageLeft:color fc=default bc=default.&colon. Scroll horizontally to display page on the left.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePageRight'.:color fc=default bc=red.MovePageRight:color fc=default bc=default.&colon. Scroll horizontally to display page on the right.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveBlockStart'.MoveBlockStart: Move cursor to the beginning of selected block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveBlockEnd'.MoveBlockEnd: Move cursor to end beginning of selected block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFirstNonWhite'.MoveFirstNonWhite: Move cursor to the first non-blank character on line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLastNonWhite'.MoveLastNonWhite: Move cursor to the last non-blank character on line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePrevEqualIndent'.:color fc=default bc=red.MovePrevEqualIndent:color fc=default bc=default.&colon. Move cursor to the previous line with equal indentation.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveNextEqualIndent'.:color fc=default bc=red.MoveNextEqualIndent:color fc=default bc=default.&colon. Move cursor to the next line with equal indentation.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePrevTab'.:color fc=default bc=red.MovePrevTab:color fc=default bc=default.&colon. Move cursor to the previous tab position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveNextTab'.:color fc=default bc=red.MoveNextTab:color fc=default bc=default.&colon. Move cursor to the next tab position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveTabStart'.:color fc=default bc=red.MoveTabStart:color fc=default bc=default.&colon. When cursor is on the tab characters, moves it to the beginning of the tab.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveTabEnd'.:color fc=default bc=red.MoveTabEnd:color fc=default bc=default.&colon. When cursor is on the tab characters, moves it to the end of the tab.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLineTop'.:color fc=default bc=red.MoveLineTop:color fc=default bc=default.&colon. Scroll the file to make the current line appear on the top of the window.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLineCenter'.:color fc=default bc=red.MoveLineCenter:color fc=default bc=default.&colon. Scroll the file to make the current line appear on the center of the window.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveLineBottom'.:color fc=default bc=red.MoveLineBottom:color fc=default bc=default.&colon. Scroll the file to make the current line appear on the bottom of the window.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ScrollLeft'.:color fc=default bc=red.ScrollLeft:color fc=default bc=default.&colon. Scroll screen left.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ScrollRight'.:color fc=default bc=red.ScrollRight:color fc=default bc=default.&colon. Scroll screen right.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ScrollDown'.:color fc=default bc=red.ScrollDown:color fc=default bc=default.&colon. Scroll screen down.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ScrollUp'.:color fc=default bc=red.ScrollUp:color fc=default bc=default.&colon. Scroll screen up.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFoldTop'.:color fc=default bc=red.MoveFoldTop:color fc=default bc=default.&colon. Move to the beginning of current fold.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFoldPrev'.:color fc=default bc=red.MoveFoldPrev:color fc=default bc=default.&colon. Move to the beginning of previous fold.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFoldNext'.:color fc=default bc=red.MoveFoldNext:color fc=default bc=default.&colon. Move to the beginning of next fold.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveBeginOrNonWhite'.:color fc=default bc=red.MoveBeginOrNonWhite:color fc=default bc=default.&colon. Move to beginning of line, or to first non blank character.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveBeginLinePageFile'.:color fc=default bc=red.MoveBeginLinePageFile:color fc=default bc=default.&colon. Move to the beginning of line. If there already, move to the beginning page. If there already, move to the beginning of file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveEndLinePageFile'.:color fc=default bc=red.MoveEndLinePageFile:color fc=default bc=default.&colon. Move to the end of line. If there already, move to the end page. If there already, move to the end of file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveToLine'.:color fc=default bc=red.MoveToLine:color fc=default bc=default.&colon. Move to line number given as argument.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveToColumn'.:color fc=default bc=red.MoveToColumn:color fc=default bc=default.&colon. Move to column given as argument.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveSavedPosCol'.:color fc=default bc=red.MoveSavedPosCol:color fc=default bc=default.&colon. Move to column from saved position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveSavedPosRow'.:color fc=default bc=red.MoveSavedPosRow:color fc=default bc=default.&colon. Move to line from saved position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveSavedPos'.MoveSavedPos: Move to saved position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SavePos'.SavePos: Save current cursor position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MovePrevPos'.:color fc=default bc=red.MovePrevPos:color fc=default bc=default.&colon. Move to last cursor position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cursor'.Cursor movement:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_delete'.Deleting text

:dl compact.
  :dt.KillLine
  :dd.Delete current line. If the line is the last line in the file, only the text is deleted.
  :dt.KillChar
  :dd.Delete character under (after) cursor.
  :dt.:color fc=default bc=red.KillCharPrev:color fc=default bc=default.
  :dd.Delete character before cursor.
  :dt.:color fc=default bc=red.KillWord:color fc=default bc=default.
  :dd.Delete the word after cursor.
  :dt.:color fc=default bc=red.KillWordPrev:color fc=default bc=default.
  :dd.Delete the word before cursor.
  :dt.:color fc=default bc=red.KillWordOrCap:color fc=default bc=default.
  :dd.Delete word or capitals after cursor.
  :dt.:color fc=default bc=red.KillWordOrCapPrev:color fc=default bc=default.
  :dd.Delete word or capitals before cursor.
  :dt.:color fc=default bc=red.KillToLineStart:color fc=default bc=default.
  :dd.Delete characters to the beginning of line.
  :dt.:color fc=default bc=red.KillToLineEnd:color fc=default bc=default.
  :dd.Delete characters to the end of line.
  :dt.:color fc=default bc=red.KillBlock:color fc=default bc=default.
  :dd.Delete block.
  :dt.:color fc=default bc=red.KillBlockOrChar:color fc=default bc=default.
  :dd.If block is marked, delete it, otherwise delete character under cursor.
  :dt.:color fc=default bc=red.KillBlockOrCharPrev:color fc=default bc=default.
  :dd.If block is marked, delete it, otherwise delete character before cursor.
  :dt.Delete
  :dd.Delete character under (after) cursor.
  :dt.BackSpace
  :dd.Delete character before cursor.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=fn refid='ms.DeleteKillTab'.DeleteKillTab:elink.,
:link reftype=fn refid='ms.DeleteKillBlock'.DeleteKillBlock:elink.,
:link reftype=fn refid='ms.BackSpKillTab'.BackSpKillTab:elink.,
:link reftype=fn refid='ms.BackSpKillBlock'.BackSpKillBlock:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.KillLine'.KillLine: Delete current line. If the line is the last line in the file, only the text is deleted.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillChar'.KillChar: Delete character under (after) cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillCharPrev'.:color fc=default bc=red.KillCharPrev:color fc=default bc=default.&colon. Delete character before cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillWord'.:color fc=default bc=red.KillWord:color fc=default bc=default.&colon. Delete the word after cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillWordPrev'.:color fc=default bc=red.KillWordPrev:color fc=default bc=default.&colon. Delete the word before cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillWordOrCap'.:color fc=default bc=red.KillWordOrCap:color fc=default bc=default.&colon. Delete word or capitals after cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillWordOrCapPrev'.:color fc=default bc=red.KillWordOrCapPrev:color fc=default bc=default.&colon. Delete word or capitals before cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillToLineStart'.:color fc=default bc=red.KillToLineStart:color fc=default bc=default.&colon. Delete characters to the beginning of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillToLineEnd'.:color fc=default bc=red.KillToLineEnd:color fc=default bc=default.&colon. Delete characters to the end of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillBlock'.:color fc=default bc=red.KillBlock:color fc=default bc=default.&colon. Delete block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillBlockOrChar'.:color fc=default bc=red.KillBlockOrChar:color fc=default bc=default.&colon. If block is marked, delete it, otherwise delete character under cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.KillBlockOrCharPrev'.:color fc=default bc=red.KillBlockOrCharPrev:color fc=default bc=default.&colon. If block is marked, delete it, otherwise delete character before cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.Delete'.Delete: Delete character under (after) cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BackSpace'.BackSpace: Delete character before cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_delete'.Deleting text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_line'.Line commands

:dl compact.
  :dt.LineInsert
  :dd.Insert a new line before the current one.
  :dt.LineAdd
  :dd.Add a new line after the current one.
  :dt.LineSplit
  :dd.Insert line break at cursor position.
  :dt.LineJoin
  :dd.Supress break between current line and the next one. If cursor is positioned beyond the end of line, the current line is first padded with whitespace.
  :dt.LineNew
  :dd.Insert line break and move to the beginning of the new line.
  :dt.:color fc=default bc=red.LineIndent:color fc=default bc=default.
  :dd.Reindent current line.
  :dt.:color fc=default bc=red.LineTrim:color fc=default bc=default.
  :dd.Trim whitespace at the end of current line.
  :dt.:color fc=default bc=red.LineDuplicate:color fc=default bc=default.
  :dd.Duplicate the current line.
  :dt.:color fc=default bc=red.LineCenter:color fc=default bc=default.
  :dd.Center the current line.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.LineInsert'.LineInsert: Insert a new line before the current one.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineAdd'.LineAdd: Add a new line after the current one.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineSplit'.LineSplit: Insert line break at cursor position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineJoin'.LineJoin: Supress break between current line and the next one. If cursor is positioned beyond the end of line, the current line is first padded with whitespace.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineNew'.LineNew: Insert line break and move to the beginning of the new line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineIndent'.:color fc=default bc=red.LineIndent:color fc=default bc=default.&colon. Reindent current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineTrim'.:color fc=default bc=red.LineTrim:color fc=default bc=default.&colon. Trim whitespace at the end of current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineDuplicate'.:color fc=default bc=red.LineDuplicate:color fc=default bc=default.&colon. Duplicate the current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineCenter'.:color fc=default bc=red.LineCenter:color fc=default bc=default.&colon. Center the current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_line'.Line commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_block'.Block commands

:dl compact.
  :dt.BlockBegin
  :dd.Set block beginning to current position.
  :dt.BlockEnd
  :dd.Set block end to current position.
  :dt.BlockUnmark
  :dd.Unmark block.
  :dt.BlockCut
  :dd.Cut selected block to clipboard.
  :dt.BlockCopy
  :dd.Copy selected block to clipboard.
  :dt.:color fc=default bc=red.BlockCutAppend:color fc=default bc=default.
  :dd.Cut selected block and append it to clipboard.
  :dt.:color fc=default bc=red.BlockCopyAppend:color fc=default bc=default.
  :dd.Append selected block to clipboard.
  :dt.:color fc=default bc=red.BlockClear:color fc=default bc=default.
  :dd.Clear selected block.
  :dt.BlockPaste
  :dd.Paste clipboard to current position.
  :dt.:color fc=default bc=red.BlockKill:color fc=default bc=default.
  :dd.Delete selected text.
  :dt.:color fc=default bc=red.BlockIndent:color fc=default bc=default.
  :dd.Indent block by 1 character.
  :dt.:color fc=default bc=red.BlockUnindent:color fc=default bc=default.
  :dd.Unindent block by 1 character.
  :dt.:color fc=default bc=red.BlockMarkStream:color fc=default bc=default.
  :dd.Start/stop marking stream block.
  :dt.:color fc=default bc=red.BlockMarkLine:color fc=default bc=default.
  :dd.Start/stop marking line block.
  :dt.:color fc=default bc=red.BlockMarkColumn:color fc=default bc=default.
  :dd.Start/stop marking column block.
  :dt.BlockExtendBegin
  :dd.Start extending selected block following cursor moves.
  :dt.BlockExtendEnd
  :dd.Stop extending selected block.
  :dt.:color fc=default bc=red.BlockReIndent:color fc=default bc=default.
  :dd.Reindent entire block (C/REXX mode).
  :dt.:color fc=default bc=red.BlockSelectWord:color fc=default bc=default.
  :dd.Select word under cursor as block.
  :dt.:color fc=default bc=red.BlockSelectLine:color fc=default bc=default.
  :dd.Select current line as block.
  :dt.:color fc=default bc=red.BlockSelectPara:color fc=default bc=default.
  :dd.Select current paragraph (delimited by blank lines) as block.
  :dt.:color fc=default bc=red.BlockPasteStream:color fc=default bc=default.
  :dd.Paste clipboard to current position as stream block.
  :dt.:color fc=default bc=red.BlockPasteLine:color fc=default bc=default.
  :dd.Paste clipboard to current position as line block.
  :dt.:color fc=default bc=red.BlockPasteColumn:color fc=default bc=default.
  :dd.Paste clipboard to current position as column block.
  :dt.:color fc=default bc=red.BlockPrint:color fc=default bc=default.
  :dd.Print a block to configured device.
  :dt.:color fc=default bc=red.BlockRead:color fc=default bc=default.
  :dd.Read block from file.
  :dt.:color fc=default bc=red.BlockReadStream:color fc=default bc=default.
  :dd.Read block from file as stream block.
  :dt.:color fc=default bc=red.BlockReadLine:color fc=default bc=default.
  :dd.Read block from file as line block.
  :dt.:color fc=default bc=red.BlockReadColumn:color fc=default bc=default.
  :dd.Read block from file as column block.
  :dt.:color fc=default bc=red.BlockWrite:color fc=default bc=default.
  :dd.Write marked block to file.
  :dt.:color fc=default bc=red.BlockSort:color fc=default bc=default.
  :dd.Sorts the marked block in ascending order. If mode setting MatchCase is set, characters will be compared case sensitively.
When block is marked in :link reftype=fn refid='ec.BlockMarkStream'.Stream:elink. or :link reftype=fn refid='ec.BlockMarkLine'.Line:elink. mode,
the entire lines in marked block will be compared. When block is marked in :link reftype=fn refid='ec.BlockMarkColumn'.Column:elink. mode,
only characters within marked columns will be compared.
  :dt.:color fc=default bc=red.BlockSortReverse:color fc=default bc=default.
  :dd.Sorts the marked block in descending order.
  :dt.:color fc=default bc=red.BlockUnTab:color fc=default bc=default.
  :dd.Remove tabs from marked lines.
  :dt.:color fc=default bc=red.BlockEnTab:color fc=default bc=default.
  :dd.Generate and optimize tabs in marked lines.
  :dt.:color fc=default bc=red.BlockMarkFunction:color fc=default bc=default.
  :dd.Mark current function as block.
  :dt.:color fc=default bc=red.BlockTrim:color fc=default bc=default.
  :dd.Trim end-of-line whitespace.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.BlockBegin'.BlockBegin: Set block beginning to current position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockEnd'.BlockEnd: Set block end to current position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockUnmark'.BlockUnmark: Unmark block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCut'.BlockCut: Cut selected block to clipboard.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCopy'.BlockCopy: Copy selected block to clipboard.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCutAppend'.:color fc=default bc=red.BlockCutAppend:color fc=default bc=default.&colon. Cut selected block and append it to clipboard.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCopyAppend'.:color fc=default bc=red.BlockCopyAppend:color fc=default bc=default.&colon. Append selected block to clipboard.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockClear'.:color fc=default bc=red.BlockClear:color fc=default bc=default.&colon. Clear selected block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockPaste'.BlockPaste: Paste clipboard to current position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockKill'.:color fc=default bc=red.BlockKill:color fc=default bc=default.&colon. Delete selected text.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockIndent'.:color fc=default bc=red.BlockIndent:color fc=default bc=default.&colon. Indent block by 1 character.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockUnindent'.:color fc=default bc=red.BlockUnindent:color fc=default bc=default.&colon. Unindent block by 1 character.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockMarkStream'.:color fc=default bc=red.BlockMarkStream:color fc=default bc=default.&colon. Start/stop marking stream block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockMarkLine'.:color fc=default bc=red.BlockMarkLine:color fc=default bc=default.&colon. Start/stop marking line block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockMarkColumn'.:color fc=default bc=red.BlockMarkColumn:color fc=default bc=default.&colon. Start/stop marking column block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockExtendBegin'.BlockExtendBegin: Start extending selected block following cursor moves.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockExtendEnd'.BlockExtendEnd: Stop extending selected block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockReIndent'.:color fc=default bc=red.BlockReIndent:color fc=default bc=default.&colon. Reindent entire block (C/REXX mode).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockSelectWord'.:color fc=default bc=red.BlockSelectWord:color fc=default bc=default.&colon. Select word under cursor as block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockSelectLine'.:color fc=default bc=red.BlockSelectLine:color fc=default bc=default.&colon. Select current line as block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockSelectPara'.:color fc=default bc=red.BlockSelectPara:color fc=default bc=default.&colon. Select current paragraph (delimited by blank lines) as block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockPasteStream'.:color fc=default bc=red.BlockPasteStream:color fc=default bc=default.&colon. Paste clipboard to current position as stream block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockPasteLine'.:color fc=default bc=red.BlockPasteLine:color fc=default bc=default.&colon. Paste clipboard to current position as line block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockPasteColumn'.:color fc=default bc=red.BlockPasteColumn:color fc=default bc=default.&colon. Paste clipboard to current position as column block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockPrint'.:color fc=default bc=red.BlockPrint:color fc=default bc=default.&colon. Print a block to configured device.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockRead'.:color fc=default bc=red.BlockRead:color fc=default bc=default.&colon. Read block from file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockReadStream'.:color fc=default bc=red.BlockReadStream:color fc=default bc=default.&colon. Read block from file as stream block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockReadLine'.:color fc=default bc=red.BlockReadLine:color fc=default bc=default.&colon. Read block from file as line block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockReadColumn'.:color fc=default bc=red.BlockReadColumn:color fc=default bc=default.&colon. Read block from file as column block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockWrite'.:color fc=default bc=red.BlockWrite:color fc=default bc=default.&colon. Write marked block to file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockSort'.:color fc=default bc=red.BlockSort:color fc=default bc=default.&colon. Sorts the marked block in ascending order. If mode setting MatchCase is set, characters will be compared case sensitively. When block is marked in :link reftype=fn refid='ec.BlockMarkStream'.Stream:elink. or :link reftype=fn refid='ec.BlockMarkLine'.Line:elink. mode, the entire lines in marked block will be compared. When block is marked in :link reftype=fn refid='ec.BlockMarkColumn'.Column:elink. mode, only characters within marked columns will be compared.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockSortReverse'.:color fc=default bc=red.BlockSortReverse:color fc=default bc=default.&colon. Sorts the marked block in descending order.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockUnTab'.:color fc=default bc=red.BlockUnTab:color fc=default bc=default.&colon. Remove tabs from marked lines.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockEnTab'.:color fc=default bc=red.BlockEnTab:color fc=default bc=default.&colon. Generate and optimize tabs in marked lines.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockMarkFunction'.:color fc=default bc=red.BlockMarkFunction:color fc=default bc=default.&colon. Mark current function as block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockTrim'.:color fc=default bc=red.BlockTrim:color fc=default bc=default.&colon. Trim end-of-line whitespace.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_block'.Block commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_edit'.Text editing

:dl compact.
  :dt.:color fc=default bc=red.Undo:color fc=default bc=default.
  :dd.Undo last operation.
  :dt.:color fc=default bc=red.Redo:color fc=default bc=default.
  :dd.Redo last undone operation.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.Undo'.:color fc=default bc=red.Undo:color fc=default bc=default.&colon. Undo last operation.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_edit'.Text editing:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.Redo'.:color fc=default bc=red.Redo:color fc=default bc=default.&colon. Redo last undone operation.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_edit'.Text editing:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_fold'.Folding text

:dl compact.
  :dt.:color fc=default bc=red.FoldCreate:color fc=default bc=default.
  :dd.Create fold.
  :dt.:color fc=default bc=red.FoldCreateByRegexp:color fc=default bc=default.
  :dd.Create folds at lines matching a :link reftype=hd refid='use-regexp'.regular expression:elink..
  :dt.FoldCreateAtRoutines
  :dd.Create folds at lines matching :link reftype=fn refid='ms.RoutineRegexp'.RoutineRegexp:elink..
  :dt.:color fc=default bc=red.FoldDestroy:color fc=default bc=default.
  :dd.Destroy fold at current line.
  :dt.:color fc=default bc=red.FoldDestroyAll:color fc=default bc=default.
  :dd.Destroy all folds in the file.
  :dt.:color fc=default bc=red.FoldPromote:color fc=default bc=default.
  :dd.Promote fold to outer level.
  :dt.:color fc=default bc=red.FoldDemote:color fc=default bc=default.
  :dd.Demote fold to inner level.
  :dt.:color fc=default bc=red.FoldOpen:color fc=default bc=default.
  :dd.Open fold at current line.
  :dt.:color fc=default bc=red.FoldOpenNested:color fc=default bc=default.
  :dd.Open fold and nested folds.
  :dt.:color fc=default bc=red.FoldClose:color fc=default bc=default.
  :dd.Close current fold.
  :dt.:color fc=default bc=red.FoldOpenAll:color fc=default bc=default.
  :dd.Open all folds in the file.
  :dt.:color fc=default bc=red.FoldCloseAll:color fc=default bc=default.
  :dd.Close all folds in the file.
  :dt.:color fc=default bc=red.FoldToggleOpenClose:color fc=default bc=default.
  :dd.Toggle open/close current fold.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.FoldCreate'.:color fc=default bc=red.FoldCreate:color fc=default bc=default.&colon. Create fold.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldCreateByRegexp'.:color fc=default bc=red.FoldCreateByRegexp:color fc=default bc=default.&colon. Create folds at lines matching a :link reftype=hd refid='use-regexp'.regular expression:elink..
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldCreateAtRoutines'.FoldCreateAtRoutines: Create folds at lines matching :link reftype=fn refid='ms.RoutineRegexp'.RoutineRegexp:elink..
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldDestroy'.:color fc=default bc=red.FoldDestroy:color fc=default bc=default.&colon. Destroy fold at current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldDestroyAll'.:color fc=default bc=red.FoldDestroyAll:color fc=default bc=default.&colon. Destroy all folds in the file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldPromote'.:color fc=default bc=red.FoldPromote:color fc=default bc=default.&colon. Promote fold to outer level.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldDemote'.:color fc=default bc=red.FoldDemote:color fc=default bc=default.&colon. Demote fold to inner level.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldOpen'.:color fc=default bc=red.FoldOpen:color fc=default bc=default.&colon. Open fold at current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldOpenNested'.:color fc=default bc=red.FoldOpenNested:color fc=default bc=default.&colon. Open fold and nested folds.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldClose'.:color fc=default bc=red.FoldClose:color fc=default bc=default.&colon. Close current fold.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldOpenAll'.:color fc=default bc=red.FoldOpenAll:color fc=default bc=default.&colon. Open all folds in the file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldCloseAll'.:color fc=default bc=red.FoldCloseAll:color fc=default bc=default.&colon. Close all folds in the file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FoldToggleOpenClose'.:color fc=default bc=red.FoldToggleOpenClose:color fc=default bc=default.&colon. Toggle open/close current fold.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_fold'.Folding text:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_bookmark'.Bookmarks

:dl compact.
  :dt.:color fc=default bc=red.PlaceBookmark:color fc=default bc=default.
  :dd.Place a file-local bookmark.
  :dt.:color fc=default bc=red.RemoveBookmark:color fc=default bc=default.
  :dd.Remove a file-local bookmark.
  :dt.:color fc=default bc=red.GotoBookmark:color fc=default bc=default.
  :dd.Go to file-local bookmark location.
  :dt.:color fc=default bc=red.PlaceGlobalBookmark:color fc=default bc=default.
  :dd.Place global (persistent) bookmark.
  :dt.:color fc=default bc=red.RemoveGlobalBookmark:color fc=default bc=default.
  :dd.Remove global bookmark.
  :dt.:color fc=default bc=red.GotoGlobalBookmark:color fc=default bc=default.
  :dd.Go to global bookmark location.
  :dt.:color fc=default bc=red.PushGlobalBookmark:color fc=default bc=default.
  :dd.Push global bookmark (named as #&lt.num&gt.) to stack.
  :dt.:color fc=default bc=red.PopGlobalBookmark:color fc=default bc=default.
  :dd.Pop global bookmark from stack.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.PlaceBookmark'.:color fc=default bc=red.PlaceBookmark:color fc=default bc=default.&colon. Place a file-local bookmark.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RemoveBookmark'.:color fc=default bc=red.RemoveBookmark:color fc=default bc=default.&colon. Remove a file-local bookmark.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.GotoBookmark'.:color fc=default bc=red.GotoBookmark:color fc=default bc=default.&colon. Go to file-local bookmark location.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.PlaceGlobalBookmark'.:color fc=default bc=red.PlaceGlobalBookmark:color fc=default bc=default.&colon. Place global (persistent) bookmark.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RemoveGlobalBookmark'.:color fc=default bc=red.RemoveGlobalBookmark:color fc=default bc=default.&colon. Remove global bookmark.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.GotoGlobalBookmark'.:color fc=default bc=red.GotoGlobalBookmark:color fc=default bc=default.&colon. Go to global bookmark location.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.PushGlobalBookmark'.:color fc=default bc=red.PushGlobalBookmark:color fc=default bc=default.&colon. Push global bookmark (named as #&lt.num&gt.) to stack.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.PopGlobalBookmark'.:color fc=default bc=red.PopGlobalBookmark:color fc=default bc=default.&colon. Pop global bookmark from stack.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_bookmark'.Bookmarks:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_trans'.Character translation / insertion

:dl compact.
  :dt.:color fc=default bc=red.CharCaseUp:color fc=default bc=default.
  :dd.Convert current character to uppercase.
  :dt.:color fc=default bc=red.CharCaseDown:color fc=default bc=default.
  :dd.Convert current character to lowercase.
  :dt.:color fc=default bc=red.CharCaseToggle:color fc=default bc=default.
  :dd.Toggle case of current character.
  :dt.:color fc=default bc=red.CharTrans:color fc=default bc=default.
  :dd.Translate current character (like perl/sed).
  :dt.:color fc=default bc=red.LineCaseUp:color fc=default bc=default.
  :dd.Convert current line to uppercase.
  :dt.:color fc=default bc=red.LineCaseDown:color fc=default bc=default.
  :dd.Convert current line to lowercase.
  :dt.:color fc=default bc=red.LineCaseToggle:color fc=default bc=default.
  :dd.Toggle case of current line.
  :dt.:color fc=default bc=red.LineTrans:color fc=default bc=default.
  :dd.Translate characters on current line.
  :dt.:color fc=default bc=red.BlockCaseUp:color fc=default bc=default.
  :dd.Convert characters in selected block to uppercase.
  :dt.:color fc=default bc=red.BlockCaseDown:color fc=default bc=default.
  :dd.Convert characters in selected block to lowercase.
  :dt.:color fc=default bc=red.BlockCaseToggle:color fc=default bc=default.
  :dd.Toggle case of characters in selected block.
  :dt.:color fc=default bc=red.BlockTrans:color fc=default bc=default.
  :dd.Translate characters in selected block.
  :dt.InsertString &lt.string&gt.
  :dd.Insert argument :font facename='System Monospaced' size=12x8.string:font facename='default'. at cursor position.
  :dt.:color fc=default bc=red.InsertSpace:color fc=default bc=default.
  :dd.Insert space.
  :dt.:color fc=default bc=red.InsertChar:color fc=default bc=default.
  :dd.Insert character argument at cursor position.
  :dt.:color fc=default bc=red.TypeChar:color fc=default bc=default.
  :dd.Insert character at cursor position (expanding abbreviations).
  :dt.:color fc=default bc=red.InsertTab:color fc=default bc=default.
  :dd.Insert tab character at cursor position.
  :dt.:color fc=default bc=red.InsertSpacesToTab:color fc=default bc=default.
  :dd.Insert appropriate number of spaces to simulate a tab.
  :dt.SelfInsert
  :dd.Insert typed character.
  :dt.:color fc=default bc=red.WrapPara:color fc=default bc=default.
  :dd.Wrap current paragraph.
  :dt.:color fc=default bc=red.InsPrevLineChar:color fc=default bc=default.
  :dd.Insert character in previous line above cursor.
  :dt.:color fc=default bc=red.InsPrevLineToEol:color fc=default bc=default.
  :dd.Insert previous line from cursor to end of line.
  :dt.:color fc=default bc=red.CompleteWord:color fc=default bc=default.
  :dd.Complete current word to last word starting with the same prefix.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.CharCaseUp'.:color fc=default bc=red.CharCaseUp:color fc=default bc=default.&colon. Convert current character to uppercase.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CharCaseDown'.:color fc=default bc=red.CharCaseDown:color fc=default bc=default.&colon. Convert current character to lowercase.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CharCaseToggle'.:color fc=default bc=red.CharCaseToggle:color fc=default bc=default.&colon. Toggle case of current character.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CharTrans'.:color fc=default bc=red.CharTrans:color fc=default bc=default.&colon. Translate current character (like perl/sed).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineCaseUp'.:color fc=default bc=red.LineCaseUp:color fc=default bc=default.&colon. Convert current line to uppercase.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineCaseDown'.:color fc=default bc=red.LineCaseDown:color fc=default bc=default.&colon. Convert current line to lowercase.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineCaseToggle'.:color fc=default bc=red.LineCaseToggle:color fc=default bc=default.&colon. Toggle case of current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LineTrans'.:color fc=default bc=red.LineTrans:color fc=default bc=default.&colon. Translate characters on current line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCaseUp'.:color fc=default bc=red.BlockCaseUp:color fc=default bc=default.&colon. Convert characters in selected block to uppercase.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCaseDown'.:color fc=default bc=red.BlockCaseDown:color fc=default bc=default.&colon. Convert characters in selected block to lowercase.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockCaseToggle'.:color fc=default bc=red.BlockCaseToggle:color fc=default bc=default.&colon. Toggle case of characters in selected block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BlockTrans'.:color fc=default bc=red.BlockTrans:color fc=default bc=default.&colon. Translate characters in selected block.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertString'.InsertString &lt.string&gt.&colon. Insert argument :font facename='System Monospaced' size=12x8.string:font facename='default'. at cursor position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertSpace'.:color fc=default bc=red.InsertSpace:color fc=default bc=default.&colon. Insert space.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertChar'.:color fc=default bc=red.InsertChar:color fc=default bc=default.&colon. Insert character argument at cursor position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TypeChar'.:color fc=default bc=red.TypeChar:color fc=default bc=default.&colon. Insert character at cursor position (expanding abbreviations).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertTab'.:color fc=default bc=red.InsertTab:color fc=default bc=default.&colon. Insert tab character at cursor position.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertSpacesToTab'.:color fc=default bc=red.InsertSpacesToTab:color fc=default bc=default.&colon. Insert appropriate number of spaces to simulate a tab.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SelfInsert'.SelfInsert: Insert typed character.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WrapPara'.:color fc=default bc=red.WrapPara:color fc=default bc=default.&colon. Wrap current paragraph.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsPrevLineChar'.:color fc=default bc=red.InsPrevLineChar:color fc=default bc=default.&colon. Insert character in previous line above cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsPrevLineToEol'.:color fc=default bc=red.InsPrevLineToEol:color fc=default bc=default.&colon. Insert previous line from cursor to end of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CompleteWord'.:color fc=default bc=red.CompleteWord:color fc=default bc=default.&colon. Complete current word to last word starting with the same prefix.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_trans'.Character translation / insertion:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_file'.File commands

:dl compact.
  :dt.FileOpen
  :dd.Prompts for file name to open, editing mode is :link reftype=hd refid='mode-select'.determined automatically:elink.. If a directory name is specified, the internal file browser is opened.
  :dt.FileOpenInMode "&lt.mode&gt."
  :dd.Prompts for file name to open using specified mode.
  :dt.FileReload
  :dd.Reload current file.
  :dt.FileSave
  :dd.Save current file.
  :dt.:color fc=default bc=red.FileSaveAll:color fc=default bc=default.
  :dd.Save all modified files.
  :dt.:color fc=default bc=red.FileSaveAs:color fc=default bc=default.
  :dd.Rename Save current file.
  :dt.:color fc=default bc=red.FileWriteTo:color fc=default bc=default.
  :dd.Write current file into another file.
  :dt.:color fc=default bc=red.FilePrint:color fc=default bc=default.
  :dd.Print current file.
  :dt.:color fc=default bc=red.FileClose:color fc=default bc=default.
  :dd.Close current file.
  :dt.:color fc=default bc=red.FileCloseAll:color fc=default bc=default.
  :dd.Close all open files.
  :dt.:color fc=default bc=red.FileTrim:color fc=default bc=default.
  :dd.Trim end-of-line whitespace.
  :dt.:color fc=default bc=red.FilePrev:color fc=default bc=default.
  :dd.Switch to previous file in ring.
  :dt.:color fc=default bc=red.FileNext:color fc=default bc=default.
  :dd.Switch to next file in ring.
  :dt.:color fc=default bc=red.FileLast:color fc=default bc=default.
  :dd.Exchange last two files in ring.
  :dt.:color fc=default bc=red.SwitchTo:color fc=default bc=default.
  :dd.Switch to numbered buffer given as argument.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.FileOpen'.FileOpen: Prompts for file name to open, editing mode is :link reftype=hd refid='mode-select'.determined automatically:elink.. If a directory name is specified, the internal file browser is opened.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileOpenInMode'.FileOpenInMode "&lt.mode&gt.": Prompts for file name to open using specified mode.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileReload'.FileReload: Reload current file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileSave'.FileSave: Save current file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileSaveAll'.:color fc=default bc=red.FileSaveAll:color fc=default bc=default.&colon. Save all modified files.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileSaveAs'.:color fc=default bc=red.FileSaveAs:color fc=default bc=default.&colon. Rename Save current file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileWriteTo'.:color fc=default bc=red.FileWriteTo:color fc=default bc=default.&colon. Write current file into another file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FilePrint'.:color fc=default bc=red.FilePrint:color fc=default bc=default.&colon. Print current file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileClose'.:color fc=default bc=red.FileClose:color fc=default bc=default.&colon. Close current file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileCloseAll'.:color fc=default bc=red.FileCloseAll:color fc=default bc=default.&colon. Close all open files.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileTrim'.:color fc=default bc=red.FileTrim:color fc=default bc=default.&colon. Trim end-of-line whitespace.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FilePrev'.:color fc=default bc=red.FilePrev:color fc=default bc=default.&colon. Switch to previous file in ring.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileNext'.:color fc=default bc=red.FileNext:color fc=default bc=default.&colon. Switch to next file in ring.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FileLast'.:color fc=default bc=red.FileLast:color fc=default bc=default.&colon. Exchange last two files in ring.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SwitchTo'.:color fc=default bc=red.SwitchTo:color fc=default bc=default.&colon. Switch to numbered buffer given as argument.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_file'.File commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_directory'.Directory commands

:dl compact.
  :dt.:color fc=default bc=red.DirOpen:color fc=default bc=default.
  :dd.Open directory browser.
  :dt.:color fc=default bc=red.DirGoUp:color fc=default bc=default.
  :dd.Change to parent directory.
  :dt.:color fc=default bc=red.DirGoDown:color fc=default bc=default.
  :dd.Change to currently selected directory.
  :dt.:color fc=default bc=red.DirGoRoot:color fc=default bc=default.
  :dd.Change to root directory.
  :dt.:color fc=default bc=red.DirGoto:color fc=default bc=default.
  :dd.Change to directory given as argument.
  :dt.:color fc=default bc=red.DirSearchCancel:color fc=default bc=default.
  :dd.Cancel search.
  :dt.:color fc=default bc=red.DirSearchNext:color fc=default bc=default.
  :dd.Find next matching file.
  :dt.:color fc=default bc=red.DirSearchPrev:color fc=default bc=default.
  :dd.Find previous matching file.
  :dt.:color fc=default bc=pink.RenameFile:color fc=default bc=default.
  :dd.
  :dt.:color fc=default bc=pink.MakeDirectory:color fc=default bc=default.
  :dd.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.DirOpen'.:color fc=default bc=red.DirOpen:color fc=default bc=default.&colon. Open directory browser.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirGoUp'.:color fc=default bc=red.DirGoUp:color fc=default bc=default.&colon. Change to parent directory.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirGoDown'.:color fc=default bc=red.DirGoDown:color fc=default bc=default.&colon. Change to currently selected directory.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirGoRoot'.:color fc=default bc=red.DirGoRoot:color fc=default bc=default.&colon. Change to root directory.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirGoto'.:color fc=default bc=red.DirGoto:color fc=default bc=default.&colon. Change to directory given as argument.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirSearchCancel'.:color fc=default bc=red.DirSearchCancel:color fc=default bc=default.&colon. Cancel search.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirSearchNext'.:color fc=default bc=red.DirSearchNext:color fc=default bc=default.&colon. Find next matching file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DirSearchPrev'.:color fc=default bc=red.DirSearchPrev:color fc=default bc=default.&colon. Find previous matching file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RenameFile'.:color fc=default bc=pink.RenameFile:color fc=default bc=default.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MakeDirectory'.:color fc=default bc=pink.MakeDirectory:color fc=default bc=default.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_directory'.Directory commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_search'.Search and replace

:dl compact.
  :dt.:color fc=default bc=red.IncrementalSearch:color fc=default bc=default.
  :dd.Incremental search.
  :dt.:xmp.Find [find [flags]]
FindReplace [find [replace [flags]]]:exmp.
  :dd.:font facename='System Monospaced' size=12x8.Find:font facename='default'. and :font facename='System Monospaced' size=12x8.FindReplace:font facename='default'. will interact with the user when parameters are omitted.
The editor then asks what to find, [what to replace it with,] and for the search flags string: "Options (All / Block / Cur / Delln / Glob / Igncase / Joinln / Rev / SplitLn / Noask / Word / regX)&colon.".
    :p.:hp2.Notes&colon.:ehp2.
    :ol compact.
      :li.:font facename='System Monospaced' size=12x8.find:font
facename='default'.  and :font facename='System Monospaced'
size=12x8.replace:font facename='default'. can be :link reftype=hd
refid='use-regexp'.regular expressions:elink..
      :li.In configuration files, :font facename='System Monospaced'
size=12x8.find:font facename='default'., :font facename='System Monospaced'
size=12x8.replace:font facename='default'., and :font facename='System Monospaced'
size=12x8.flags:font facename='default'. are either single- or double-quote-,
or slash-delimited character strings in which the :link reftype=hd
refid='ref-strings'.usual replacements:elink. take place.
    :eol.
    :p.:font facename='System Monospaced' size=12x8.flags:font facename='default'. string may contain the following characters:
    :dl compact.
      :dt.a
      :dd."All matches." If absent only one Find/Replace operation will be performed. If present, a Find operation will move cursor position to the last match.
      :dt.b
      :dd.Operate within the selected block only (cursor must be located ahead of block start).
      :dt.c
      :dd.Include matches at cursor position; default is to skip to next match if any.
      :dt.d
      :dd.Delete line containing matched find -&gt. same as replacing with "" + LineDelete would do.
      :dt.g
      :dd.Global lookup, i.e. from beginning of file.
      :dt.i
      :dd.Ignore case when matching.
      :dt.j
      :dd.Join line containing matched find with the next line.
      :dt.r
      :dd.Reverse look up (upstream in the file, only for literal Find/Replace).
      :dt.s
      :dd.Split line containing match at cursor position.
      :dt.n
      :dd.Do not ask for confirmation (this tag is honored only when invoking Find/Replace commands from a configuration file, and not when taken from user input?).
    :edl.
    :p.
    :dl compact.
      :dt.x
      :dd.Regular expression; if not present, find [and replace] are interpreted as literal strings.
      :dt.w
      :dd."Words only" ?
    :edl.
  :dt.FindRepeat
  :dd.Repeat last find/replace operation, including flags.
  :dt.FindRepeatOnce
  :dd.Repeat last find/replace operation only once.
  :dt.FindRepeatReverse
  :dd.Repeat last find/replace operation in reverse. Not supported in RegExp mode (yet?), only literal search works.
  :dt.:color fc=default bc=red.MatchBracket:color fc=default bc=default.
  :dd.Find matching bracket ([{&lt.&gt.}]).
  :dt.:color fc=default bc=red.HilitWord:color fc=default bc=default.
  :dd.Highlight current word everywhere in the file.
  :dt.:color fc=default bc=red.SearchWordPrev:color fc=default bc=default.
  :dd.Search for previous occurence of word under cursor.
  :dt.:color fc=default bc=red.SearchWordNext:color fc=default bc=default.
  :dd.Search for next occurence of word under cursor.
  :dt.:color fc=default bc=red.HilitMatchBracket:color fc=default bc=default.
  :dd.Highlight matching bracket.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.IncrementalSearch'.:color fc=default bc=red.IncrementalSearch:color fc=default bc=default.&colon. Incremental search.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FindReplace'.:xmp.Find [find [flags]]
FindReplace [find [replace [flags]]]
:exmp.
:font facename='System Monospaced' size=12x8.Find:font facename='default'. and :font facename='System Monospaced' size=12x8.FindReplace:font facename='default'. will interact with the user when parameters are omitted.
The editor then asks what to find, [what to replace it with,] and for the search flags string: "Options (All / Block / Cur / Delln / Glob / Igncase / Joinln / Rev / SplitLn / Noask / Word / regX)&colon.".
:p.:hp2.Notes&colon.:ehp2.
:ol compact.
  :li.:font facename='System Monospaced' size=12x8.find:font facename='default'. and :font facename='System Monospaced' size=12x8.replace:font facename='default'. can be :link reftype=hd refid='use-regexp'.regular expressions:elink..
  :li.In configuration files, :font facename='System Monospaced' size=12x8.find:font facename='default'., :font facename='System Monospaced' size=12x8.replace:font facename='default'., and :font facename='System Monospaced' size=12x8.flags:font facename='default'. are either single- or double-quote-, or slash-delimited character strings in which the usual replacements take place {link to strings in cfgfiles}.
:eol.
:p.:font facename='System Monospaced' size=12x8.flags:font facename='default'. string may contain the following characters:
:dl compact.
  :dt.a
  :dd."All matches." If absent only one Find/Replace operation will be performed. If present, a Find operation will move cursor position to the last match.
  :dt.b
  :dd.Operate within the selected block only (cursor must be located ahead of block start).
  :dt.c
  :dd.Include matches at cursor position; default is to skip to next match if any.
  :dt.d
  :dd.Delete line containing matched find -&gt. same as replacing with "" + LineDelete would do.
  :dt.g
  :dd.Global lookup, i.e. from beginning of file.
  :dt.i
  :dd.Ignore case when matching.
  :dt.j
  :dd.Join line containing matched find with the next line.
  :dt.r
  :dd.Reverse look up (upstream in the file, only for literal Find/Replace).
  :dt.s
  :dd.Split line containing match at cursor position.
  :dt.n
  :dd.Do not ask for confirmation (this tag is honored only when invoking Find/Replace commands from a configuration file, and not when taken from user input?).
:edl.
:p.
:dl compact.
  :dt.x
  :dd.Regular expression; if not present, find [and replace] are interpreted as literal strings.
  :dt.w
  :dd."Words only" ?
:edl.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FindRepeat'.FindRepeat: Repeat last find/replace operation, including flags.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FindRepeatOnce'.FindRepeatOnce: Repeat last find/replace operation only once.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FindRepeatReverse'.FindRepeatReverse: Repeat last find/replace operation in reverse. Not supported in RegExp mode (yet?), only literal search works.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MatchBracket'.:color fc=default bc=red.MatchBracket:color fc=default bc=default.&colon. Find matching bracket ([{&lt.&gt.}]).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.HilitWord'.:color fc=default bc=red.HilitWord:color fc=default bc=default.&colon. Highlight current word everywhere in the file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SearchWordPrev'.:color fc=default bc=red.SearchWordPrev:color fc=default bc=default.&colon. Search for previous occurence of word under cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SearchWordNext'.:color fc=default bc=red.SearchWordNext:color fc=default bc=default.&colon. Search for next occurence of word under cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.HilitMatchBracket'.:color fc=default bc=red.HilitMatchBracket:color fc=default bc=default.&colon. Highlight matching bracket.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_search'.Search and replace:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_window'.Window commands

:dl compact.
  :dt.:color fc=default bc=red.WinHSplit:color fc=default bc=default.
  :dd.Split window horizontally.
  :dt.:color fc=default bc=red.WinNext:color fc=default bc=default.
  :dd.Switch to next (bottom) window.
  :dt.:color fc=default bc=red.WinPrev:color fc=default bc=default.
  :dd.Switcn to previous (top) window.
  :dt.:color fc=default bc=red.WinClose:color fc=default bc=default.
  :dd.Close current window.
  :dt.:color fc=default bc=red.WinZoom:color fc=default bc=default.
  :dd.Delete all windows except for current one.
  :dt.:color fc=default bc=red.WinResize:color fc=default bc=default.
  :dd.Resize current window (+n,-n given as argument).
  :dt.:color fc=default bc=red.ViewBuffers:color fc=default bc=default.
  :dd.View currently open buffers.
  :dt.:color fc=default bc=red.ListRoutines:color fc=default bc=default.
  :dd.Display routines in current source file.
  :dt.:color fc=default bc=red.ExitEditor:color fc=default bc=default.
  :dd.Exit eFTE2.
  :dt.:color fc=default bc=red.ShowEntryScreen:color fc=default bc=default.
  :dd.View external program output if available.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.WinHSplit'.:color fc=default bc=red.WinHSplit:color fc=default bc=default.&colon. Split window horizontally.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WinNext'.:color fc=default bc=red.WinNext:color fc=default bc=default.&colon. Switch to next (bottom) window.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WinPrev'.:color fc=default bc=red.WinPrev:color fc=default bc=default.&colon. Switcn to previous (top) window.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WinClose'.:color fc=default bc=red.WinClose:color fc=default bc=default.&colon. Close current window.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WinZoom'.:color fc=default bc=red.WinZoom:color fc=default bc=default.&colon. Delete all windows except for current one.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WinResize'.:color fc=default bc=red.WinResize:color fc=default bc=default.&colon. Resize current window (+n,-n given as argument).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ViewBuffers'.:color fc=default bc=red.ViewBuffers:color fc=default bc=default.&colon. View currently open buffers.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ListRoutines'.:color fc=default bc=red.ListRoutines:color fc=default bc=default.&colon. Display routines in current source file.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ExitEditor'.:color fc=default bc=red.ExitEditor:color fc=default bc=default.&colon. Exit eFTE2.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ShowEntryScreen'.:color fc=default bc=red.ShowEntryScreen:color fc=default bc=default.&colon. View external program output if available.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_window'.Window commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_compile'.Compiler support

:dl compact.
  :dt.:color fc=default bc=pink.Compile [command]:color fc=default bc=default.
  :dd.Ask for compile command and run compiler. If :font facename='System Monospaced' size=12x8.command:font facename='default'. parameter is specified, it is offered to the user for completion.
  :dt.:color fc=default bc=red.RunCompiler:color fc=default bc=default.
  :dd.Run configured compile command.
  :dt.:color fc=default bc=red.ViewMessages:color fc=default bc=default.
  :dd.View compiler output.
  :dt.:color fc=default bc=red.CompileNextError:color fc=default bc=default.
  :dd.Switch to next compiler error.
  :dt.:color fc=default bc=red.CompilePrevError:color fc=default bc=default.
  :dd.Switch to previous compiler error.
  :dt.:color fc=default bc=red.RunProgram:color fc=default bc=default.
  :dd.Run external program.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all macro
commands:elink..

:fn id='ec.Compile'.:color fc=default bc=pink.Compile [command]:color fc=default bc=default.&colon. Ask for compile command and run compiler. If :font facename='System Monospaced' size=12x8.command:font facename='default'. parameter is specified, it is offered to the user for completion.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_compile'.Compiler support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RunCompiler'.:color fc=default bc=red.RunCompiler:color fc=default bc=default.&colon. Run configured compile command.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_compile'.Compiler support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ViewMessages'.:color fc=default bc=red.ViewMessages:color fc=default bc=default.&colon. View compiler output.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_compile'.Compiler support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CompileNextError'.:color fc=default bc=red.CompileNextError:color fc=default bc=default.&colon. Switch to next compiler error.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_compile'.Compiler support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CompilePrevError'.:color fc=default bc=red.CompilePrevError:color fc=default bc=default.&colon. Switch to previous compiler error.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_compile'.Compiler support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RunProgram'.:color fc=default bc=red.RunProgram:color fc=default bc=default.&colon. Run external program.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_compile'.Compiler support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_cvs'.CVS support

:dl compact.
  :dt.:color fc=default bc=red.Cvs:color fc=default bc=default.
  :dd.Ask for CVS options and run CVS.
  :dt.:color fc=default bc=red.RunCvs:color fc=default bc=default.
  :dd.Run configured CVS command.
  :dt.:color fc=default bc=red.ViewCvs:color fc=default bc=default.
  :dd.View CVS output.
  :dt.:color fc=default bc=red.ClearCvsMessages:color fc=default bc=default.
  :dd.Clear CVS messages.
  :dt.:color fc=default bc=red.CvsDiff:color fc=default bc=default.
  :dd.Ask for CVS diff options and run CVS.
  :dt.:color fc=default bc=red.RunCvsDiff:color fc=default bc=default.
  :dd.Run configured CVS diff command.
  :dt.:color fc=default bc=red.ViewCvsDiff:color fc=default bc=default.
  :dd.View CVS diff output.
  :dt.:color fc=default bc=red.CvsCommit:color fc=default bc=default.
  :dd.Ask for CVS commit options and run CVS.
  :dt.:color fc=default bc=red.RunCvsCommit:color fc=default bc=default.
  :dd.Run configured CVS commit command.
  :dt.:color fc=default bc=red.ViewCvsLog:color fc=default bc=default.
  :dd.View CVS log.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.Cvs'.:color fc=default bc=red.Cvs:color fc=default bc=default.&colon. Ask for CVS options and run CVS.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RunCvs'.:color fc=default bc=red.RunCvs:color fc=default bc=default.&colon. Run configured CVS command.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ViewCvs'.:color fc=default bc=red.ViewCvs:color fc=default bc=default.&colon. View CVS output.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ClearCvsMessages'.:color fc=default bc=red.ClearCvsMessages:color fc=default bc=default.&colon. Clear CVS messages.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CvsDiff'.:color fc=default bc=red.CvsDiff:color fc=default bc=default.&colon. Ask for CVS diff options and run CVS.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RunCvsDiff'.:color fc=default bc=red.RunCvsDiff:color fc=default bc=default.&colon. Run configured CVS diff command.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ViewCvsDiff'.:color fc=default bc=red.ViewCvsDiff:color fc=default bc=default.&colon. View CVS diff output.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CvsCommit'.:color fc=default bc=red.CvsCommit:color fc=default bc=default.&colon. Ask for CVS commit options and run CVS.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.RunCvsCommit'.:color fc=default bc=red.RunCvsCommit:color fc=default bc=default.&colon. Run configured CVS commit command.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ViewCvsLog'.:color fc=default bc=red.ViewCvsLog:color fc=default bc=default.&colon. View CVS log.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_cvs'.CVS support:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_tags'.TAGS commands

eFTE2 supports TAGS files generated by programs like ctags.

:dl compact.
  :dt.:color fc=default bc=red.TagFind:color fc=default bc=default.
  :dd.Find word argument in tag files.
  :dt.:color fc=default bc=red.TagFindWord:color fc=default bc=default.
  :dd.Find word under cursor in tag files.
  :dt.:color fc=default bc=red.TagNext:color fc=default bc=default.
  :dd.Switch to next occurance of tag.
  :dt.:color fc=default bc=red.TagPrev:color fc=default bc=default.
  :dd.Switch to previous occurance of tag.
  :dt.:color fc=default bc=red.TagPop:color fc=default bc=default.
  :dd.Pop saved position from tag stack.
  :dt.:color fc=default bc=red.TagLoad:color fc=default bc=default.
  :dd.Load tag file and merge with current tags.
  :dt.:color fc=default bc=red.TagClear:color fc=default bc=default.
  :dd.Clear loaded tags.
  :dt.:color fc=default bc=red.TagGoto:color fc=default bc=default.
  :dd.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.TagFind'.:color fc=default bc=red.TagFind:color fc=default bc=default.&colon. Find word argument in tag files.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagFindWord'.:color fc=default bc=red.TagFindWord:color fc=default bc=default.&colon. Find word under cursor in tag files.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagNext'.:color fc=default bc=red.TagNext:color fc=default bc=default.&colon. Switch to next occurance of tag.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagPrev'.:color fc=default bc=red.TagPrev:color fc=default bc=default.&colon. Switch to previous occurance of tag.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagPop'.:color fc=default bc=red.TagPop:color fc=default bc=default.&colon. Pop saved position from tag stack.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagLoad'.:color fc=default bc=red.TagLoad:color fc=default bc=default.&colon. Load tag file and merge with current tags.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagClear'.:color fc=default bc=red.TagClear:color fc=default bc=default.&colon. Clear loaded tags.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.TagGoto'.:color fc=default bc=red.TagGoto:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_tags'.TAGS commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_option'.Option commands

:dl compact.
  :dt.:color fc=default bc=red.ToggleAutoIndent:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleInsert:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleExpandTabs:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleShowTabs:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleUndo:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleReadOnly:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleKeepBackups:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleMatchCase:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleBackSpKillTab:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleDeleteKillTab:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleSpaceTabs:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleIndentWithTabs:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleBackSpUnindents:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleWordWrap:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleTrim:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleShowMarkers:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleHilitTags:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleShowBookmarks:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.SetLeftMargin:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.SetRightMargin:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ToggleSysClipboard:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.SetPrintDevice:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ChangeTabSize:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ChangeLeftMargin:color fc=default bc=default.:dd.
  :dt.:color fc=default bc=red.ChangeRightMargin:color fc=default bc=default.:dd.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.ToggleAutoIndent'.:color fc=default bc=red.ToggleAutoIndent:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleInsert'.:color fc=default bc=red.ToggleInsert:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleExpandTabs'.:color fc=default bc=red.ToggleExpandTabs:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleShowTabs'.:color fc=default bc=red.ToggleShowTabs:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleUndo'.:color fc=default bc=red.ToggleUndo:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleReadOnly'.:color fc=default bc=red.ToggleReadOnly:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleKeepBackups'.:color fc=default bc=red.ToggleKeepBackups:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleMakeBackups'.:color fc=default bc=pink.:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleMatchCase'.:color fc=default bc=red.ToggleMatchCase:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleBackSpKillTab'.:color fc=default bc=red.ToggleBackSpKillTab:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleDeleteKillTab'.:color fc=default bc=red.ToggleDeleteKillTab:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleSpaceTabs'.:color fc=default bc=red.ToggleSpaceTabs:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleIndentWithTabs'.:color fc=default bc=red.ToggleIndentWithTabs:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleBackSpUnindents'.:color fc=default bc=red.ToggleBackSpUnindents:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleWordWrap'.:color fc=default bc=red.ToggleWordWrap:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleTrim'.:color fc=default bc=red.ToggleTrim:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleShowMarkers'.:color fc=default bc=red.ToggleShowMarkers:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleHilitTags'.:color fc=default bc=red.ToggleHilitTags:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleShowBookmarks'.:color fc=default bc=red.ToggleShowBookmarks:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SetLeftMargin'.:color fc=default bc=red.SetLeftMargin:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SetRightMargin'.:color fc=default bc=red.SetRightMargin:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ToggleSysClipboard'.:color fc=default bc=red.ToggleSysClipboard:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SetPrintDevice'.:color fc=default bc=red.SetPrintDevice:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChangeTabSize'.:color fc=default bc=red.ChangeTabSize:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChangeLeftMargin'.:color fc=default bc=red.ChangeLeftMargin:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChangeRightMargin'.:color fc=default bc=red.ChangeRightMargin:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_option'.Option commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h3 id='cmd_other'.Miscellaneous commands

:dl compact.
  :dt.:color fc=default bc=red.ShowPosition:color fc=default bc=default.
  :dd.Show internal position information on status line.
  :dt.:color fc=default bc=red.ShowVersion:color fc=default bc=default.
  :dd.Show editor version information.
  :dt.ShowKey
  :dd.Wait for keypress and display modifiers+key pressed in status line.
  :dt.:color fc=default bc=red.WinRefresh:color fc=default bc=default.
  :dd.Refresh display.
  :dt.:color fc=default bc=red.MainMenu:color fc=default bc=default.
  :dd.Activate main menu.
  :dt.:color fc=default bc=red.ShowMenu:color fc=default bc=default.
  :dd.Popup menu specified as argument.
  :dt.:color fc=default bc=red.LocalMenu:color fc=default bc=default.
  :dd.Popup context menu.
  :dt.:color fc=default bc=red.ChangeMode:color fc=default bc=default.
  :dd.Change active mode for current buffer.
  :dt.:color fc=default bc=red.ChangeKeys:color fc=default bc=default.
  :dd.Change keybindings for current buffer.
  :dt.:color fc=default bc=red.ChangeFlags:color fc=default bc=default.
  :dd.Change option flags for current buffer.
  :dt.:color fc=default bc=red.Cancel:color fc=default bc=default.
  :dt.:color fc=default bc=red.Activate:color fc=default bc=default.
  :dt.:color fc=default bc=red.Rescan:color fc=default bc=default.
  :dt.:color fc=default bc=red.CloseActivate:color fc=default bc=default.
  :dt.:color fc=default bc=red.:color fc=default bc=default. ActivateInOtherWindow
  :dt.:color fc=default bc=red.DeleteFile:color fc=default bc=default.
  :dt.:color fc=default bc=red.ASCIITable:color fc=default bc=default.
  :dd.Display ASCII selector in status line.
  :dt.:color fc=default bc=red.DesktopSave:color fc=default bc=default.
  :dd.Save desktop.
  :dt.:color fc=default bc=red.ClipClear:color fc=default bc=default.
  :dd.Clear clipboard.
  :dt.:color fc=default bc=red.DesktopSaveAs:color fc=default bc=default.
  :dd.Save desktop under a new name.
  :dt.:color fc=default bc=pink.DesktopLoad:color fc=default bc=default.
  :dt.:color fc=default bc=red.ChildClose:color fc=default bc=default.
  :dt.:color fc=default bc=red.BufListFileSave:color fc=default bc=default.
  :dd.Save currently selected file in buffer list.
  :dt.:color fc=default bc=red.BufListFileClose:color fc=default bc=default.
  :dd.Close currently selected file in buffer list.
  :dt.:color fc=default bc=red.BufListSearchCancel:color fc=default bc=default.
  :dd.Cancel search.
  :dt.:color fc=default bc=red.BufListSearchNext:color fc=default bc=default.
  :dd.Next match in search.
  :dt.:color fc=default bc=red.BufListSearchPrev:color fc=default bc=default.
  :dd.Previous match in search.
  :dt.ViewModeMap
  :dd.Lists current mode keybindings in :link reftype=hd refid='use-EventMapView'.EventMapView:elink..
  :dt.:color fc=default bc=red.ClearMessages:color fc=default bc=default.
  :dd.Clear compiler messages.
  :dt.:color fc=default bc=red.IndentFunction:color fc=default bc=default.
  :dd.Indent current function.
  :dt.:color fc=default bc=red.MoveFunctionPrev:color fc=default bc=default.
  :dd.Move cursor to previous function.
  :dt.:color fc=default bc=red.MoveFunctionNext:color fc=default bc=default.
  :dd.Move cursor to next function.
  :dt.:color fc=default bc=red.InsertDate:color fc=default bc=default.
  :dd.Insert date at cursor.
  :dt.:color fc=default bc=red.InsertUid:color fc=default bc=default.
  :dd.Insert user name at cursor.
  :dt.:color fc=default bc=red.FrameNew:color fc=default bc=default.
  :dt.:color fc=default bc=red.FrameClose:color fc=default bc=default.
  :dt.:color fc=default bc=red.FrameNext:color fc=default bc=default.
  :dt.:color fc=default bc=red.FramePrev:color fc=default bc=default.
  :dt.:color fc=default bc=red.BufferViewNext:color fc=default bc=default.
  :dt.:color fc=default bc=red.BufferViewPrev:color fc=default bc=default.
  :dt.:color fc=default bc=pink.ShowHelpWord "FileList?" OS-specific?:color fc=default bc=default.
  :dd.Show context help on keyword.
  :dt.:color fc=default bc=pink.ShowHelp [file? [what?]]:color fc=default bc=default.
  :dd.Show help manual.
  :dt.:color fc=default bc=red.ConfigRecompile:color fc=default bc=default.
  :dd.Recompile editor configuration.
  :dt.:color fc=default bc=red.SetCIndentStyle:color fc=default bc=default.
  :dd.Set C indentation style parameters. Has the following parameters:
C_Indent = 4; C_BraceOfs = 0; C_ParenDelta = -1; C_CaseOfs = 0; C_CaseDelta = 4;
C_ClassOfs = 0; C_ClassDelta = 4; C_ColonOfs = -4; C_CommentOfs = 0;
C_CommentDelta = 1; C_FirstLevelWidth = -1; C_FirstLevelIndent = 4;
C_Continuation = 4;
  :dt.:color fc=default bc=red.SetIndentWithTabs:color fc=default bc=default.
  :dd.Set value of indent-with-tabs to argument.
  :dt.:color fc=default bc=red.ListMark:color fc=default bc=default.
  :dd.Mark single line in list.
  :dt.:color fc=default bc=red.ListUnmark:color fc=default bc=default.
  :dd.Unmark single line in list.
  :dt.:color fc=default bc=red.ListToggleMark:color fc=default bc=default.
  :dd.Toggle marking of single line in list.
  :dt.:color fc=default bc=red.ListMarkAll:color fc=default bc=default.
  :dd.Mark all lines in list.
  :dt.:color fc=default bc=red.ListUnmarkAll:color fc=default bc=default.
  :dd.Unmark all lines in list Toggle marking of all lines in list.
:edl.

:p.:hp2.See also&colon.:ehp2. :link reftype=hd refid='ref-commands'.all commands:elink..

:fn id='ec.ShowPosition'.:color fc=default bc=red.ShowPosition:color fc=default bc=default.&colon. Show internal position information on status line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ShowVersion'.:color fc=default bc=red.ShowVersion:color fc=default bc=default.&colon. Show editor version information.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ShowKey'.ShowKey: Wait for keypress and display modifiers+key pressed in status line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.WinRefresh'.:color fc=default bc=red.WinRefresh:color fc=default bc=default.&colon. Refresh display.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MainMenu'.:color fc=default bc=red.MainMenu:color fc=default bc=default.&colon. Activate main menu.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ShowMenu'.:color fc=default bc=red.ShowMenu:color fc=default bc=default.&colon. Popup menu specified as argument.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.LocalMenu'.:color fc=default bc=red.LocalMenu:color fc=default bc=default.&colon. Popup context menu.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChangeMode'.:color fc=default bc=red.ChangeMode:color fc=default bc=default.&colon. Change active mode for current buffer.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChangeKeys'.:color fc=default bc=red.ChangeKeys:color fc=default bc=default.&colon. Change keybindings for current buffer.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChangeFlags'.:color fc=default bc=red.ChangeFlags:color fc=default bc=default.&colon. Change option flags for current buffer.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.Cancel'.:color fc=default bc=red.Cancel:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.Activate'.:color fc=default bc=red.Activate:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.Rescan'.:color fc=default bc=red.Rescan:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.CloseActivate'.:color fc=default bc=red.CloseActivate:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ActivateInOtherWindow'.:color fc=default bc=red.ActivateInOtherWindow:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DeleteFile'.:color fc=default bc=red.DeleteFile:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ASCIITable'.:color fc=default bc=red.ASCIITable:color fc=default bc=default.&colon. Display ASCII selector in status line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DesktopSave'.:color fc=default bc=red.DesktopSave:color fc=default bc=default.&colon. Save desktop.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ClipClear'.:color fc=default bc=red.ClipClear:color fc=default bc=default.&colon. Clear clipboard.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DesktopSaveAs'.:color fc=default bc=red.DesktopSaveAs:color fc=default bc=default.&colon. Save desktop under a new name.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.DesktopLoad'.:color fc=default bc=pink.DesktopLoad:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ChildClose'.:color fc=default bc=red.ChildClose:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufListFileSave'.:color fc=default bc=red.BufListFileSave:color fc=default bc=default.&colon. Save currently selected file in buffer list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufListFileClose'.:color fc=default bc=red.BufListFileClose:color fc=default bc=default.&colon. Close currently selected file in buffer list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufListSearchCancel'.:color fc=default bc=red.BufListSearchCancel:color fc=default bc=default.&colon. Cancel search.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufListSearchNext'.:color fc=default bc=red.BufListSearchNext:color fc=default bc=default.&colon. Next match in search.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufListSearchPrev'.:color fc=default bc=red.BufListSearchPrev:color fc=default bc=default.&colon. Previous match in search.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ViewModeMap'.ViewModeMap: Lists current mode keybindings in :link reftype=hd refid='use-EventMapView'.EventMapView:elink..
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ClearMessages'.:color fc=default bc=red.ClearMessages:color fc=default bc=default.&colon. Clear compiler messages.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.IndentFunction'.:color fc=default bc=red.IndentFunction:color fc=default bc=default.&colon. Indent current function.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFunctionPrev'.:color fc=default bc=red.MoveFunctionPrev:color fc=default bc=default.&colon. Move cursor to previous function.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.MoveFunctionNext'.:color fc=default bc=red.MoveFunctionNext:color fc=default bc=default.&colon. Move cursor to next function.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertDate'.:color fc=default bc=red.InsertDate:color fc=default bc=default.&colon. Insert date at cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.InsertUid'.:color fc=default bc=red.InsertUid:color fc=default bc=default.&colon. Insert user name at cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FrameNew'.:color fc=default bc=red.FrameNew:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FrameClose'.:color fc=default bc=red.FrameClose:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FrameNext'.:color fc=default bc=red.FrameNext:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.FramePrev'.:color fc=default bc=red.FramePrev:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufferViewNext'.:color fc=default bc=red.BufferViewNext:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.BufferViewPrev'.:color fc=default bc=red.BufferViewPrev:color fc=default bc=default.&colon.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ShowHelpWord'.:color fc=default bc=pink.ShowHelpWord "FileList?" OS-specific?:color fc=default bc=default.&colon. Show context help on keyword.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ShowHelp'.:color fc=default bc=pink.ShowHelp [file? [what?]]:color fc=default bc=default.&colon. Show help manual.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ConfigRecompile'.:color fc=default bc=red.ConfigRecompile:color fc=default bc=default.&colon. Recompile editor configuration.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SetCIndentStyle'.:color fc=default bc=red.SetCIndentStyle:color
fc=default bc=default.&colon. Set C indentation style parameters.
Has the following parameters:
C_Indent = 4; C_BraceOfs = 0; C_ParenDelta = -1;
C_CaseOfs = 0; C_CaseDelta = 4;
C_ClassOfs = 0; C_ClassDelta = 4;
C_ColonOfs = -4;
C_CommentOfs = 0; C_CommentDelta = 1;
C_FirstLevelWidth = -1; C_FirstLevelIndent = 4; C_Continuation = 4;
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.SetIndentWithTabs'.:color fc=default bc=red.SetIndentWithTabs:color fc=default bc=default.&colon. Set value of indent-with-tabs to argument.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ListMark'.:color fc=default bc=red.ListMark:color fc=default bc=default.&colon. Mark single line in list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ListUnmark'.:color fc=default bc=red.ListUnmark:color fc=default bc=default.&colon. Unmark single line in list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ListToggleMark'.:color fc=default bc=red.ListToggleMark:color fc=default bc=default.&colon. Toggle marking of single line in list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ListMarkAll'.:color fc=default bc=red.ListMarkAll:color fc=default bc=default.&colon. Mark all lines in list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.
:fn id='ec.ListUnmarkAll'.:color fc=default bc=red.ListUnmarkAll:color fc=default bc=default.&colon. Unmark all lines in list Toggle marking of all lines in list.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='cmd_other'.Miscellaneous commands:elink.,
:link reftype=hd refid='ref-commands'.all commands:elink..
:efn.

:h2 id='ref-menus'.Menus

Syntax:

:xmp.menu &lt.name&gt. {
  [item ["&lt.title&gt." { macro }]]
  [; [more items]
  [submenu "&lt.title&gt.", &lt.submenu&gt.]
  [; more items]]
}
:exmp.

Menu item definitions are separated by semicolons. This is optional for the
last menu item. Items without parameters are inactive and split their menu
into groups.

:dl compact.
  :dt.&lt.name&gt.
  :dd.An internal name to refer to the menu from event maps or other menus.
  :dt.&lt.submenu&gt.
:dd.The :font facename='System Monospaced' size=12x8.name:font
facename='default'. of another menu to be opened from this menu item. :edl.

:h2 id='ref-mode'.Modes

The syntax of :hp2.mode:ehp2. definitions is:

:p.:font facename='System Monospaced' size=12x8.:hp2.mode
NEW[&colon.PARENT]:ehp2. { mode settings }:font facename='default'.

:p.Mode named :font facename='System Monospaced' size=12x8.NEW:font
facename='default'. inherits its settings from mode :font
facename='System Monospaced' size=12x8.PARENT:font facename='default'. if
specified at mode declaration.

.* :h3 id='ref-mode_settings'.Mode Settings

:p.The following settings can be specified for each mode:

:dl compact.
  :dt.:hp2.ExpandTabs:ehp2. {0,1}
  :dd.Should be set to 1 if tabs are to be expanded when displayed. Use :link reftype=fn refid='ec.ToggleExpandTabs'.ToggleExpandTabs:elink. command to toggle during editing.
  :dt.:hp2.TabSize:ehp2. {1-32}
  :dd.Tab size when tabs are shown expanded on display.
  :dt.:hp2.AutoIndent:ehp2. {0,1}
  :dd.Should be set to 1 if autoindent is to be used. Use :link reftype=fn refid='ec.ToggleAutoIndent'.ToggleAutoIndent:elink. command to toggle it on/off during editing.
  :dt.:hp2.Insert:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., Insert mode is active by default. If set to :hp2.0:ehp2., overwrite mode is active by default.
    :p.Use :link reftype=fn refid='ec.ToggleInsert'.ToggleInsert:elink. command to toggle it on/off during editing.
  :dt.:hp2.StripChar:ehp2. {ASCII code/-1}
  :dd.This character will be stripped if found at the end of any lines when the file is being loaded. If it is set to :hp2.-1:ehp2., no characters will be stripped.
    :p.Normally used to strip 13 (CR) characters from DOS text files.
  :dt.:hp2.LineChar:ehp2. {ASCII code/-1}
  :dd.This character is used as a line separator when loading a file. If set to :hp2.-1:ehp2., there is no line separator.
(:hp2.WARNING: File will be loaded as one line if LineChar is set to -1:ehp2..)
    :p.Usually set to 10 (LF) as standard text file line separator.
  :dt.:hp2.AddCR:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., CR (13, \r) character will be added to end of line when saving.
  :dt.:hp2.AddLF:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., LF (10, \n) characted will be added to end if line when saving.
  :dt.:hp2.ForceNewLine:ehp2. {0,1}
  :dd.Normally, the last line is saved without any CR/LF characters when saving. This setting will override that behaviour.
  :dt.:hp2.Hilit:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., syntax highliting will be active.
  :dt.:hp2.ShowTabs:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., tabs will be visible as circles (EPM-like).
  :dt.:hp2.IndentMode:ehp2. {PLAIN,C,REXX}
  :dd.Activates the specified smart indent mode. (PLAIN mode specifies no smart audoindenting, just normal autoindent).
  :dt.:hp2.Colorizer:ehp2. &lt.name&gt.
  :dd.Specifies a previously declared :link reftype=hd refid='ref-colorize'.colorize:elink. to use for syntax highlighting in current mode.
  :dt.:hp2.EventMap:ehp2. &lt.name&gt.
  :dd.Specifies the existing :font facename='System Monospaced' size=12x8.name:font facename='default'. eventmap to use in current mode.
  :dt.:hp2.UndoLimit:ehp2. {Number}
  :dd.Limit undo to this many recent commands (-1 = unlimited)
  :dt.:hp2.UndoMoves:ehp2. {0,1}
  :dd.If set to 1, all cursor movements will be recorded on undo stack.
  :dt.:hp2.MakeBackups:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., backup files will be created. KeepBackups determines if they are kept after save is successful.
  :dt.:hp2.KeepBackups:ehp2. {0,1}
  :dd.If set to :hp2.0:ehp2., backup files will be deleted after a successful save operation.
  :dt.:hp2.MatchCase:ehp2. {0,1}
  :dd.If set to :hp2.0:ehp2., searches will be case insensitive. This can be toggled via :link reftype=fn refid='ec.ToggleMatchCase'.ToggleMatchCase:elink. command when editor is running.
  :dt.:hp2.BackSpKillTab:ehp2. {0,1}
  :dd.If set to 1, :link reftype=fn refid='ec.BackSpace'.BackSpace:elink. will kill entire tabs instead of converting them to spaces.
  :dt.:hp2.DeleteKillTab:ehp2. {0,1}
  :dd.If set to 1, :link reftype=fn refid='ec.Delete'.Delete:elink. will kill entire tabs instead of converting them to spaces.
  :dt.:hp2.BackSpUnindents:ehp2. {0,1}
  :dd.If set to 1, :link reftype=fn refid='ec.BackSpace'.BackSpace:elink. will unindent to previous indentation level if issued on beginning of line.
  :dt.:hp2.SpaceTabs:ehp2. {0,1}
  :dd.If set to 1, :link reftype=fn refid='ec.InsertTab'.InsertTab:elink. command will insert spaces instead of tabs.
  :dt.:hp2.IndentWithTabs:ehp2. {0,1}
  :dd.If set to 1, indentation will be done using tabs instead of spaces.
  :dt.:hp2.WordWrap:ehp2. {0,1,2}
  :dd.If set to 1, editor wrap current line when right margin is reached.
If set to 2, editor will wrap current paragraph continously.
Paragraphs as recognised by :link reftype=fn refid='ec.WrapPara'.WrapPara:elink. command must be separated by blank lines.
  :dt.:hp2.LeftMargin:ehp2. {1-xx}
  :dd.Left margin for word wrap (:link reftype=fn refid='ec.WrapPara'.WrapPara:elink. command).
  :dt.:hp2.RightMargin:ehp2. {1-xx}
  :dd.Right margin for word wrap (:link reftype=fn refid='ec.WrapPara'.WrapPara:elink. command).
  :dt.:hp2.Trim:ehp2. {0,1}
  :dd.If set to 1, spaces on the end of line will be trimmed when editing.
  :dt.:hp2.ShowMarkers:ehp2. {0,1}
  :dd.If set to 1, end of line and end of file markers will be shown.
  :dt.:hp2.CursorTroughTabs:ehp2. {0,1}
  :dd.If set to 1, editor will allow cursor to be positioned inside tabs.
  :dt.:hp2.DefFindOpt:ehp2. 'options'
  :dd.Default search flags for :link reftype=fn refid='ec.FindReplace'.Find:elink. command.
  :dt.:hp2.DefFindReplaceOpt:ehp2. 'options'
  :dd.Default search/replace flags for :link reftype=fn refid='ec.FindReplace'.FindReplace:elink. command.
  :dt.:hp2.SaveFolds:ehp2. {0,1,2}
  :dd.If 0, folds are not saved. If 1, folds are saved at beginning of line, if 2 folds are saved at end of line.
  :p.Folds are saved as comments in source files, depending on active editing mode.
  :p.See mode settings :link reftype=fn refid='ms.CommentStart'.CommentStart:elink. and :link reftype=fn refid='ms.CommentEnd'.CommentEnd:elink. for configuration of fold comments.
  :dt.:hp2.CommentStart:ehp2. "comment-start-string"
  :dd.String that starts comments (for saving folds)
  :dt.:hp2.CommentEnd:ehp2. "comment-end-string"
  :dd.String that ends comments
  :dt.:hp2.AutoHilitParen:ehp2. {0,1}
  :dd.If set to :hp2.1:ehp2., editor will automatically highlight the matching bracket if it is visible on screen.
This is equivalent to executing the command :link reftype=fn refid='ec.HilitMatchBracket'.HilitMatchBracket:elink..
  :dt.:hp2.Abbreviations:ehp2. {0,1}
  :dd.If set to 1, :link reftype=hd refid='abbrevs'.abbreviation:elink. expansion will be active in this mode.
  :dt.:hp2.BackSpKillBlock:ehp2. {0,1}
  :dd.If set to 1, :link reftype=fn refid='ec.BackSpace'.BackSpace:elink. command will delete block if it is marked, otherwise it will delete the previous character.
  :dt.:hp2.DeleteKillBlock:ehp2. {0,1}
  :dd.If set to 1, :link reftype=fn refid='ec.Delete'.Delete:elink. command will delete block if marked, instead of deleting the character below cursor.
  :dt.:hp2.PersistentBlocks:ehp2. {0,1}
  :dd.If set to 1, blocks will stay marked even if cursor is moved in the file, if set to 0, block is unmarked as soon as the cursor is moved.
  :dt.:hp2.InsertKillBlock:ehp2. {0,1}
  :dd.If set to 1, the marked block is deleted when a new character is typed.
  :dt.:hp2.FileNameRx:ehp2. "regexp"
  :dd.Must be set to &lt.regexp&gt. matching names of files that should be edited in this mode. Has priority over :link reftype=fn refid='ms.FirstLineRx'.FirstLineRx:elink..
  :dt.:hp2.FirstLineRx:ehp2. "regexp"
  :dd.Must be set to &lt.regexp&gt. matching the first line of files that should be edited in this mode.
This is checked only if no :link reftype=fn refid='ms.FileNameRx'.FileNameRx:elink. in any mode matches the filename.
  :dt.:hp2.RoutineRegexp:ehp2. "regexp"
  :dd.:link reftype=hd refid='use-regexp'.Regular expression:elink. that matches function headers or otherwise relevant logical blocks of the file being edited.
    :p.Used by editor commands: :link reftype=fn refid='ec.ListRoutines'.ListRoutines:elink.,
    :link reftype=fn refid='ec.MoveFunctionPrev'.MoveFunctionPrev:elink.,
    :link reftype=fn refid='ec.MoveFunctionNext'.MoveFunctionNext:elink.,
    :link reftype=fn refid='ec.BlockMarkFunction'.BlockMarkFunction:elink.,
    :link reftype=fn refid='ec.IndentFunction'.IndentFunction:elink..
:edl.

:p.Examples of appropriate :link reftype=hd refid='mode-load_settings'.settings
for loading a number of file formats:elink. are given in the Customization
section of the manual.

:fn id='ms.ExpandTabs'.:hp2.ExpandTabs:ehp2. {0,1}: Should be set to 1 if tabs
are to be expanded when displayed. Use :link reftype=fn
refid='ec.ToggleExpandTabs'.ToggleExpandTabs:elink. command to toggle during
editing.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.TabSize'.:hp2.TabSize:ehp2. {1-32}: Tab size when tabs
are shown expanded on display.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.AutoIndent'.:hp2.AutoIndent:ehp2. {0,1}: Should be set to 1 if
autoindent is to be used. Use :link reftype=fn
refid='ec.ToggleAutoIndent'.ToggleAutoIndent:elink. command to toggle it on/off
during editing.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.Insert'.:hp2.Insert:ehp2. {0,1}: If set to :hp2.1:ehp2., Insert mode
is active by default. If set to :hp2.0:ehp2., overwrite mode is active by
default.
:p.Use :link reftype=fn refid='ec.ToggleInsert'.ToggleInsert:elink.
command to toggle it on/off during editing.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.StripChar'.:hp2.StripChar:ehp2. {ASCII code/-1}: This character will
be stripped if found at the end of any lines when the file is being loaded. If
it is set to :hp2.-1:ehp2., no characters will be stripped.:p.Normally used to
strip 13 (CR) characters from DOS text files.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.LineChar'.:hp2.LineChar:ehp2. {ASCII code/-1}: This character is
used as a line separator when loading a file. If set to :hp2.-1:ehp2., there is
no line separator.(:hp2.WARNING: File will be loaded as one line if LineChar is
set to -1:ehp2..)
:p.Usually set to 10 (LF) as standard text file line separator.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.AddCR'.:hp2.AddCR:ehp2. {0,1}: If set to :hp2.1:ehp2., CR (13, \r)
character will be added to end of line when saving.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.AddLF'.:hp2.AddLF:ehp2. {0,1}: If set to :hp2.1:ehp2., LF (10, \n)
characted will be added to end if line when saving.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.ForceNewLine'.:hp2.ForceNewLine:ehp2. {0,1}: Normally, the last line
is saved without any CR/LF characters when saving. This setting will override
that behaviour.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.Hilit'.:hp2.Hilit:ehp2. {0,1}: If set to :hp2.1:ehp2., syntax
highliting will be active.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.ShowTabs'.:hp2.ShowTabs:ehp2. {0,1}: If set to :hp2.1:ehp2., tabs
will be visible as circles (EPM-like).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.IndentMode'.:hp2.IndentMode:ehp2. {PLAIN,C,REXX}: Activates the
specified smart indent mode. (PLAIN mode specifies no smart audoindenting, just
normal autoindent).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.colorizer'.:hp2.Colorizer:ehp2.&lt.name&gt.&colon. Specifies a previously
declared :link reftype=hd refid='ref-colorize'.colorize:elink. to use for
syntax highlighting in current mode. :p.:hp2.See also&colon.:ehp2. :link
reftype=hd refid='ref-mode'.Mode settings:elink.. :efn.

:fn id='ms.eventmap'.EventMap &lt.name&gt.&colon. Specifies the existing :font
facename='System Monospaced' size=12x8.name:font facename='default'. eventmap
to use in current mode.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.UndoLimit'.:hp2.UndoLimit:ehp2. {Number}: Limit undo to this many
recent commands (-1 = unlimited)
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.UndoMoves'.:hp2.UndoMoves:ehp2. {0,1}: If set to 1, all cursor
movements will be recorded on undo stack.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.MakeBackups'.:hp2.MakeBackups:ehp2. {0,1}: If set to :hp2.1:ehp2.,
backup files will be created. KeepBackups determines if they are kept after
save is successful.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.KeepBackups'.:hp2.KeepBackups:ehp2. {0,1}: If set to :hp2.0:ehp2.,
backup files will be deleted after a successful save operation.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.MatchCase'.:hp2.MatchCase:ehp2. {0,1}: If set to :hp2.0:ehp2.,
searches will be case insensitive. This can be toggled via :link reftype=fn
refid='ec.ToggleMatchCase'.ToggleMatchCase:elink. command when editor is
running.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.BackSpKillTab'.:hp2.BackSpKillTab:ehp2. {0,1}: If set to 1, :link
reftype=fn refid='ec.BackSpace'.BackSpace:elink. will kill entire tabs instead
of converting them to spaces.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.DeleteKillTab'.:hp2.DeleteKillTab:ehp2. {0,1}: If set to 1, :link
reftype=fn refid='ec.Delete'.Delete:elink. will kill entire tabs instead of
converting them to spaces.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.BackSpUnindents'.:hp2.BackSpUnindents:ehp2. {0,1}: If set to 1,
:link reftype=fn refid='ec.BackSpace'.BackSpace:elink. will unindent to
previous indentation level if issued on beginning of line.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.SpaceTabs'.:hp2.SpaceTabs:ehp2. {0,1}: If set to 1, :link reftype=fn
refid='ec.InsertTab'.InsertTab:elink. command will insert spaces instead of
tabs.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.IndentWithTabs'.:hp2.IndentWithTabs:ehp2. {0,1}: If set to 1,
indentation will be done using tabs instead of spaces.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.WordWrap'.:hp2.WordWrap:ehp2. {0,1,2}: If set to 1, editor wrap
current line when right margin is reached. If set to 2, editor will wrap
current paragraph continously. Paragraphs as recognised by :link reftype=fn
refid='ec.WrapPara'.WrapPara:elink. command must be separated by blank
lines.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.LeftMargin'.:hp2.LeftMargin:ehp2. {1-xx}: Left margin for word wrap
(:link reftype=fn refid='ec.WrapPara'.WrapPara:elink. command).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.RightMargin'.:hp2.RightMargin:ehp2. {1-xx}: Right margin for word
wrap (:link reftype=fn refid='ec.WrapPara'.WrapPara:elink. command).
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.Trim'.:hp2.Trim:ehp2. {0,1}: If set to 1, spaces on
the end of line will be trimmed when editing.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.ShowMarkers'.:hp2.ShowMarkers:ehp2. {0,1}: If set to 1, end of line
and end of file markers will be shown.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.CursorTroughTabs'.:hp2.CursorTroughTabs:ehp2. {0,1}: If set to 1,
editor will allow cursor to be positioned inside tabs.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.DefFindOpt'.:hp2.DefFindOpt:ehp2. 'options': Default search flags for
:link reftype=fn refid='ec.FindReplace'.Find:elink. command.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.DefFindReplaceOpt'.:hp2.DefFindReplaceOpt:ehp2. 'options': Default
search/replace flags for :link reftype=fn
refid='ec.FindReplace'.FindReplace:elink. command.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.SaveFolds'.:hp2.SaveFolds:ehp2. {0,1,2}: If 0, folds are not saved.
If 1, folds are saved at beginning of line, if 2 folds are saved at end of
line.
:p.Folds are saved as comments in source files, depending on active editing
mode. :p.See mode settings :link reftype=fn
refid='ms.CommentStart'.CommentStart:elink. and :link reftype=fn
refid='ms.CommentEnd'.CommentEnd:elink. for configuration of fold
comments.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.CommentStart'.:hp2.CommentStart:ehp2. "comment-start-string": String
that starts comments (for saving folds)
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.CommentEnd'.:hp2.CommentEnd:ehp2. "comment-end-string": String that
ends comments
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.AutoHilitParen'.:hp2.AutoHilitParen:ehp2. {0,1}: If set to
:hp2.1:ehp2., editor will automatically highlight the matching bracket if it is
visible on screen. This is equivalent to executing the command :link reftype=fn
refid='ec.HilitMatchBracket'.HilitMatchBracket:elink..
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.Abbreviations'.:hp2.Abbreviations:ehp2. {0,1}: If set to 1, :link
reftype=hd refid='abbrevs'.abbreviation:elink. expansion will be active in this
mode.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.BackSpKillBlock'.:hp2.BackSpKillBlock:ehp2. {0,1}: If set
to 1, :link reftype=fn refid='ec.BackSpace'.BackSpace:elink. command will
delete block if it is marked, otherwise it will delete the previous
character.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.DeleteKillBlock'.:hp2.DeleteKillBlock:ehp2. {0,1}:
If set to 1, :link reftype=fn refid='ec.Delete'.Delete:elink. command will
delete block if marked, instead of deleting the character below cursor.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.PersistentBlocks'.:hp2.PersistentBlocks:ehp2. {0,1}: If set to 1,
blocks will stay marked even if cursor is moved in the file, if set to 0, block
is unmarked as soon as the cursor is moved.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.InsertKillBlock'.:hp2.InsertKillBlock:ehp2. {0,1}: If set to 1, the
marked block is deleted when a new character is typed.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.FileNameRx'.:hp2.FileNameRx:ehp2. "regexp": Must be set to
&lt.regexp&gt. matching names of files that should be edited in this mode. Has
priority over :link reftype=fn refid='ms.FirstLineRx'.FirstLineRx:elink..
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.FirstLineRx'.:hp2.FirstLineRx:ehp2. "regexp": Must be set to
&lt.regexp&gt. matching the first line of files that should be edited in this
mode. This is checked only if no :link reftype=fn
refid='ms.FileNameRx'.FileNameRx:elink. in any mode matches the filename.
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

:fn id='ms.RoutineRegexp'.:hp2.RoutineRegexp:ehp2. "regexp": :link reftype=hd
refid='use-regexp'.Regular expression:elink. that matches function headers or
otherwise relevant logical blocks of the file being edited.
:p.Used by editor commands: :link reftype=fn
refid='ec.ListRoutines'.ListRoutines:elink., :link reftype=fn
refid='ec.MoveFunctionPrev'.MoveFunctionPrev:elink., :link reftype=fn
refid='ec.MoveFunctionNext'.MoveFunctionNext:elink., :link reftype=fn
refid='ec.BlockMarkFunction'.BlockMarkFunction:elink., :link reftype=fn
refid='ec.IndentFunction'.IndentFunction:elink..
:p.:hp2.See also&colon.:ehp2.
:link reftype=hd refid='ref-mode'.Mode settings:elink..
:efn.

.* Most mysterious non-section: :h3 id='ref-mode_tabopts'.Tab options (?)

:h2 id='ref-eventmap' toc=12.Eventmap

:font facename='System Monospaced' size=12x8.eventmap:font facename='default'. sections are declared with the syntax:

:xmp.:hp2.eventmap mode[&colon.parent]:ehp2. {
  [:hp2.MainMenu:ehp2. = 'name'; ]
  [:hp2.LocalMenu:ehp2. = 'name'; ]
  [keybindings]
  ...
  [abbreviations]
  ...
}:exmp.

:hp2.
:h3 id='es.menus'.Menu settings
:ehp2.

:dl compact.
.* id='es.MainMenu'
  :dt.:font facename='System Monospaced' size=12x8.MainMenu 'name':font
facename='default'.
  :dd.Sets menu defined with :font facename='System Monospaced'
size=12x8.name:font facename='default'. in the configuration as the main
application pull-down menu displayed when working in this mode.
.* id='es.LocalMenu'
  :dt.:font facename='System Monospaced' size=12x8.LocalMenu 'name':font
facename='default'.
  :dd.Sets menu defined with :font facename='System Monospaced'
size=12x8.name:font facename='default'. in the configuration as the local,
pop-up menu used when working in this mode.
:edl.

:hp2.
:h3 id='es.keybindings'.Keybindings
:ehp2.

:p.Keys are bound using the :font facename='System Monospaced'
size=12x8.key:font facename='default'. command with the following syntax:

:p.:font facename='System Monospaced' size=12x8.:hp2.key [ keyspec ]:ehp2. {
:link reftype=hd refid='ref-macros'.macro:elink. }:font facename='default'.

:p.:font facename='System Monospaced' size=12x8.keyspec:font facename='default'.
(non-optional, but delimited by "[" and "]") is a key name, or sequence of them:
multiple-key combinations can be specified by separating them with "_"
(underline).

:p.Key names are denoted by the characters they return, or the following
special key names (case sensitive): :hp2.F1-F12, Home, End, PgUp, PgDn, Insert,
Delete, Up, Down, Left, Right, Enter, Esc, BackSp, Space, Tab, Center:ehp2.
(meaning 5 in the numeric pad).

:p.ASCII characters >= 32 are bound to TypeChar by default.

:p.Key names can be preceded by modifiers :hp2.A, C, G, S:ehp2. plus "+" or "-"
flag. :hp2.-:ehp2. (minus) indicates to ignore modifier key, :hp2.+:ehp2. (plus)
indicates to match keyname only if previous modifier key is pressed.

:p.A number of :link reftype=hd refid='keybinding_examples'.keybinding
examples:elink. is given in the Customizing section of the manual.

:hp2.
:h3 id='es.abbrevs'.Abbreviations
:ehp2.

:p.Syntax:

:xmp.abbrev 'old-word' 'new-string';
abbrev 'old-word' { macro }
:exmp.

:hp2.N.B.&colon.:ehp2. For abbreviations to work, the setting
:link reftype=fn refid='ms.Abbreviations'.Abbreviations:elink. must be 1
for active mode.

:h1 id='metainfo' toc=123.This program, authors, timeline

WWW: http&colon.//svn.netlabs.org/efte

:p.This is the first version of eFTE2. It is based on eFTE (see README.efte
and http&colon.//sourceforge.net/projects/efte/)
which in turn is based on FTE (Folding Text Editor, see
http&colon.//fte.sourceforge.net/). The configuration now compiles on the fly.

:h2 id='license'.License of use
.* id='license-eFTE2'
:lines align='center'.:hp2.eFTE2, Version 1.0:ehp2.
:p.Copyright 2009&ndash.2016 by Gregg Young
Copyright 2008&ndash.2009 by eFTE SF Group.
Copyright 1994&ndash.1998 by Marko Macek.
All rights reserved.
:elines.

:p.This program is free software; you can redistribute it and/or modify it
under the terms of either:

:ul compact.
  :li.the GNU General Public License as published by the Free Software Foundation; either :link reftype=hd refid='license-gnu2'.version 2:elink., or (at your option) any later version, or
  :li.the ":link reftype=hd refid='license-artistic'.Artistic License:elink." which comes with this Kit.
:eul.

:p.This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See either
the GNU General Public License or the Artistic License for more
details.

:p.You should have received a copy of the Artistic License with this Kit,
in the file named "Artistic".  If not, I'll be glad to provide one.

:p.You should also have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
675 Mass Ave, Cambridge, MA 02139, USA.

:h3 id='license-gnu2'.GNU GENERAL PUBLIC LICENSE Version 2, June 1991

:xmp.
 Copyright  1989, 1991 Free Software Foundation, Inc.
       675 Mass Ave, Cambridge, MA 02139, USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

                            Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software&mdash.to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation&apos.s software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author&apos.s protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors&apos. reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone&apos.s free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

                    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The &odq.Program&cdq., below,
refers to any such program or work, and a &odq.work based on the Program&cdq.
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term &odq.modification&cdq..)  Each licensee is addressed as &odq.you&cdq..

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program&apos.s
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients&apos. exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and &odq.any
later version&cdq., you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

                            NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM &odq.AS IS&cdq. WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

                     END OF TERMS AND CONDITIONS

        Appendix: How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the &odq.copyright&cdq. line and a pointer to where the full notice is found.

    &lt.one line to give the program&apos.s name and a brief idea of what it does.&gt.
    Copyright  19yy  &lt.name of author&gt.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright  19yy name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c for details.

The hypothetical commands `show w and `show c should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w and `show c; they could even be
mouse-clicks or menu items&mdash.whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a &odq.copyright disclaimer&cdq. for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision (which makes passes at compilers) written by James Hacker.

  &lt.signature of Ty Coon&gt., 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.
:exmp.

:h3 id='license-artistic'.The "Artistic License"

:p.:hp2.Preamble:ehp2.

:p.The intent of this document is to state the conditions under which a
Package may be copied, such that the Copyright Holder maintains some
semblance of artistic control over the development of the package,
while giving the users of the package the right to use and distribute
the Package in a more-or-less customary fashion, plus the right to make
reasonable modifications.

:p.:hp2.Definitions:ehp2.

:dl compact.
  :dt."Package"
  :dd.refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
  :dt."Standard Version"
  :dd.refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder as specified below.
  :dt."Copyright Holder"
  :dd.is whoever is named in the copyright or copyrights for the package.
  :dt."You"
  :dd.is you, if you're thinking about copying or distributing this Package.
  :dt."Reasonable copying fee"
  :dd.is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on.
(You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
  :dt."Freely Available"
  :dd.means that no fee is charged for the item itself, though there may be fees involved in handling the item.
It also means that recipients of the item may redistribute it under the same conditions they received it.
:edl.

:ol compact.
  :li.You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
  :li.You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
  :li. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
    :ol compact.
      :li.place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium,
or placing the modifications on a major archive site such as uunet.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
      :li.use the modified Package only within your corporation or organization.
      :li.rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
      :li.make other distribution arrangements with the Copyright Holder.
    :eol.
  :li.You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
    :ol compact.
      :li.distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
      :li.accompany the distribution with the machine-readable source of the Package with your modifications.
      :li.give non-standard executables non-standard names, and clearly document the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
      :li.make other distribution arrangements with the Copyright Holder.
    :eol.
  :li.You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself.
However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
You may embed this Package's interpreter within an executable of yours (by linking); this shall be construed as a mere form of aggregation, provided that the complete Standard Version of the interpreter is so embedded.
  :li.The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package,
but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
If such scripts or library files are aggregated with this Package via the so-called "undump" or "unexec" methods of producing a binary executable image,
then distribution of such an image shall neither be construed as a distribution of this Package nor shall it fall under the restrictions of Paragraphs 3 and 4,
provided that you do not represent such an executable image as a Standard Version of this Package.
  :li.C subroutines (or comparably compiled subroutines in other
  languages) supplied by you and linked into this Package in order to
  emulate subroutines and variables of the language defined by this
  Package shall not be considered part of this Package, but are the
  equivalent of input as in Paragraph 6, provided these subroutines do
  not change the language in any way that would cause it to fail the
  regression tests for the language.
  :li.Aggregation of this Package with a commercial distribution is always
  permitted provided that the use of this Package is embedded; that is,
  when no overt attempt is made to make this Package's interfaces visible
  to the end user of the commercial distribution.  Such use shall not be
  construed as a distribution of this Package.
  :li.The name of the Copyright Holder may not be used to endorse or promote
  products derived from this software without specific prior written
  permission.
  :li.THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
  WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
:eol.

:lines align='center'.The End:elines.

:h2 id='authors'.Authors

:dl compact.
  :dt.Current Author
  :dd.
    :ul compact.
      :li.Gregg Young
    :eul.
  :dt.Current Contact Method:
  :dd.
    :ul compact.
      :li.http&colon.//svn.netlabs.org/efte
      :li.ygk@qwest.net
    :eul.
  :dt.Earlier Authors
  :dd.
    :ul compact.
      :li.Marko Macek
      :li.Jeremy Cowgar
      :li.Lauri Nurmi
      :li.Timo Sirainen
    :eul.
  :dt.Contributors
  :dd.
    :ul compact.
      :li.F.Jalvingh
      :li.Markus F.X.J. Oberhumer
      :li.Martin Frydl
      :li.S. Pinigin
      :li.Zednek Kabelac
      :li.Don Mahurin
      :li.Lothar Schmidt
      :li.Alfredo Fern&aa.ndez D&ia.az
      :li.Michael DeBusk
      :li.Timo Maier
      :li.John Small
    :eul.
:edl.

:p.If you feel your name should be listed but it isn't, please contact us.

:h2 id='history'.Future, present and past: revision history

:h3 id='history-plans'.Plans (by Gregg Young)

In the future you should be able to use eFTE2 with the configuration files of
an existing FTE install again simply by creating a :font
facename='System Monospaced' size=12x8.mymain.fte:font facename='default'. file
in the same directory as your old :font facename='System Monospaced'
size=12x8.main.fte:font facename='default'..

:p.I have structured the configuration files to make it easier to translate the
menus. I lack the language skills to do the translations. If you have an
opportunity to do one or more of the translations please send them to me at
ygk@qwest.net. The menu files are located in the :font
facename='System Monospaced' size=12x8.menu_xx:font facename='default'. (where
xx is the language code) subdirectories of the config directory. You may add
any language with a 2 letter code. Simple create a :font
facename='System Monospaced' size=12x8.menu_xx:font facename='default'.
subdirectory using the code and place the menus in it. To test them copy the
direcctory :font facename='System Monospaced' size=12x8.menu_xx:font
facename='default'. to the config directory of an eFTE2 install and start eFTE2
with -Lxx (xx = language code) on the command line. The :font
facename='System Monospaced' size=12x8.edefault.fte:font facename='default'.
also could be translated. If you are interested in translating the
documentation (help file, etc.) please contact me.

:h3 id='history-issues'.Known issues

:ol compact.
  :li.Occasionally, eFTE2 will trap when starting an external program. The
problem appears to be an estyler issue. If this is a significant problem for
you try adding eFTEPM.exe to estyler's exclusion list.
  :li.Openinng some help files with certain keywords will trap newview. This is
an issue either with newview or with the help file as it occurs when newview
searches the same term. (e.g. open the Open Watcom 2.0 C Library Reference and
search for return).
  :li.Anything placed on the command-line after --debug&lt.clean&gt. is ignored.
If you wish to use other parameters and or load files with :font
facename='System Monospaced' size=12x8.--debug&lt.clean&gt.:font
facename='default'. place them before it.
:eol.

:h3 id='history-legend'.Revision legend

:dl compact.
  :dt.-:dd.general alteration/note
  :dt.+:dd.added new feature
  :dt.!:dd.fixed a bug
  :dt.C:dd.Configuration file Changes
:edl.

:h3 id='history-eFTE2'.As eFTE2

:h4.eFTE/2 1.0 &mdash. May 30, 2016

:ul compact.
  :li.- First release of eFTE2 (C)
  :li.- Branded eFTE to eFTE/2
  :li.- Migrated to netlabs SVN
  :li.- Renamed some configuration files and reorganized configuration directories. (C)
  :li.- Program will still work with old configurations (C)
  :li.- Build with OpenWatcom
  :li.+ Changes to ease translation of the menus  (C)
  :li.+ Added Enhanced HTML, CSS, and IPF modes by Alfredo Fern&aa.ndez D&ia.az (C)
  :li.+ Added Spanish translation by Alfredo Fern&aa.ndez D&ia.az (C)
  :li.+ Added Enhanced REXX editing mode by Michael DeBusk (C)
  :li.+ Added PHP &amp. MySQL modes by Timo Maier (C)
  :li.+ Added BAT, BTM, and CONFIG.SYS modes by Michael DeBusk (C)
  :li.+ Added %undefine configuration compiler directive (C)
  :li.+ Reactivate the status bar message for toggles (e.g. tells you word wrap has changed to "Auto", "Yes" or "No")
  :li.+ Updated main.fte to include all available modes (C)
  :li.+ Moved UI %defines to mymain.fte with possibility to override them in systemmain.fte (C)
  :li.+ Moved color %defines to mymain.fte (C)
  :li.! Fixed error messages to always use a dialog box for gui versions
  :li.! Tolerate white space after "%" directives in configuration files (C)
  :li.+ Added ability to set the "C" indent style from command-line or by an environment variable
  :li.+ Restored a default configuration (edefault.fte) (C)
  :li.+ Move default font size settings to global.fte added myfontsize.fte to allow for over riding the default (C)
  :li.! Fixed the find dialog layout
  :li.+ Added latest perl highlighting code from FTE
  :li.+ Updated help file to reflect changes converted HTML to IPF
  :li.+ Help contents menu item using F1 accel key to open updated help file
  :li.+ Added wis file highlighting (C)
  :li.+ Warpin installer
  :li.! Improve ability of eFTE to find its config files
  :li.* Added environment variable to set config directory
  :li.+ Added REXX_End_Offset Effects placement of end, catch and finally relative to do, loop and select; 0 = aligned (C)
  :li.1 Fixed reverse search, search for all (trapped PM version) and search and replace where the search string was contained in the replace string
  :li.+ Pass search string to help files (either the word at the cursor or from a dialog if no word is picked)
  :li.! Clean up appearance of help viewer opening in PM
  :li.+ Make indent level for REXX keywords end, catch and finally user settable (C)
  :li.+ Added -I to default grep command (C)
  :li.+ Added rescan, compile, grep and run program button to the toolbar.
  :li.+ Added bubble help to toolbar buttons
  :li.* Added exceptq to the executables
  :li.+ Added exceptq TRP file support (C)
  :li.+ New Icons for program objects
  :li.! Update usage instruction provide a dialog to show them for PM version
  :li.+ Lxlite executables
  :li.+ Got the about dialog working in PM version updated its appearance
  :li.+ Add build level strings to exes
  :li.+ "Wrap" large menus in PM version removing "mode more" menus in the process
  :li.+ Added previous and next menu items
  :li.! Multiple changes to avoid/fix buffer overruns, hangs and traps
  :li.! Got -H  and -D command-line switches to accept filenames
  :li.! Fixed scrollbar failure on files with more than 64k lines
  :li.- Added eFTE to PATH and eFTE help to HELP in config.sys
  :li.* Added OS/2 resource file highlighting (C)
  :li.* Added Help menu items for multiple file types including REXX, C, EMX, WIS, WMAKE and more (C)
  :li.! Fixed wrong month in log timestamps
  :li.* Added support for eCS/OS2 HOME (Steven Levine)
:eul.

:h3 id='history-eFTE'.As eFTE

:h4.1.1&mdash.October 11, 2009
:ul compact.
  :li.! Fixed a frequent buffer overflow in e_redraw.cpp
  :li.! Fixed a couple of memory/resource leaks found by static analysis
:eul.

:h4.1.0&mdash.June 16, 2009
:ul compact.
  :li.- First release of eFTE
  :li.- Branded FTE to be eFTE
  :li.- Removed DJGPP support
  :li.- Migrated to SVN for revision control
  :li.+ Added CursorWithinEOL
  :li.+ Added searching in the Routine List
  :li.+ Added new mode for CMake files
  :li.+ Windows XP and Vista now expand ~ to be the users home directory
  :li.+ Windows now normalizes path separators, / becomes \\
  :li.! BlockRead command was not expanding any file
  :li.! WM_COMMAND now set in X11 binary
  :li.- Removed partially implemented block cursor sizing
  :li.+ Added DesktopLoad command
  :li.+ Added oinclude command which optionally includes a configuration file
  :li.+ Modes are now user configurable w/o need to edit actual mode file
  :li.- Cleaned up code a bit with manual and automatic formatting (astyle)
  :li.- Converted from Makefiles to CMake on Win32, Unixes and OS/X
  :li.! assert bug fixed when compiling with newer Microsoft compilers
  :li.+ Configuration compiler loading is now much smarter
  :li.- Moved all documentation to the wiki where it is now user editable as well as developer editable.
  :li.! Many minor bug fixes
  :li.- Began native Mac OS X GUI interface
  :li.+ Added configuration variable BackupDirectory to allow storing backups in a common directory
  :li.+ Added based modes SOURCE and MARKUP and changed all existing modes to inherit from SOURCE, MARKUP or PLAIN
  :li.+ ebuild added, contributed by Daniel Hiepler
  :li.+ efte.spec added for rpm distributions
  :li.+ Macro system is now case insensitive
  :li.+ Added split method to FindReplace
  :li.+ Removed binary configuration dependency. eFTE now reads the plain text configuration files
  :li.+ Added a nicer help screen
  :li.! WM_HINTS are set properly in X11
  :li.+ GetString and $Str0-$Str9
  :li.+ User defined mode based generic indentation system
  :li.+ RegExp macro to perform regular expression replacements on user variables
  :li.+ ExpandTemplate macro for advanced user templates
  :li.+ Added user defined regular expression based indentation engine for any mode
  :li.+ Added new modes for Euphoria, Lua, VHDL
  :li.! Many bugs fixed in the bash syntax parser
:eul.

:h4.0.50.1&mdash.January 17, 2008
:ul compact.
  :li.- Forked from FTE (http&colon.//fte.sourceforge.net)
:eul.

:h3 id='history-FTE'.As FTE

:h4.0.50.1&mdash.September 2006
:ul compact.
  :li.- Cleanup and Debian package update
:eul.

:h4.0.50.0&mdash.&lt.fill month here&gt. 2003
:ul compact.
  :li.- Many internal and some external changes
  :li.- Some bugs fixed in this release
  :li.+ cfte: added -p[reprocess] command line paramter, it can be used to debug configuration files.
  :li.! X11: XShellCommand is used to specify used shell under X11. $TERM is no longer used as shell.
:eul.

:h4.0.46
:ul compact.
  :li.! bug fixes
  :li.! coredump when $DISPLAY not set fixed
  :li.! occasional coredump at exit from PM version fixed.
  :li.! X11: check for invalid -geometry (larger than 255x255).
  :li.+ colors are specified using a palette in the configuration file
  :li.+ ShowHelp command (view .INF file under OS/2, .HLP under Win*, manpage under UNIX). Context Sensitive.
  :li.+ configuration file preprocessor %if(), %endif, %define
  :li.+ Global (persistent) Bookmarks commands + Push/Pop bookmark
  :li.+ Under UNIX it should now print using lpr
  :li.+ SIOD mode contributed.
  :li.+ command FileTrim,BlockTrim - trim whitespace at end of lines
  :li.+ mode option to strip whitespace at EOF on FileSave. (TrimOnSave)
  :li.+ C/C++ indentation style is now selectable from menu
  :li.+ compile command configurable per mode (CompileCommand option)
  :li.* PM toolbar compile tool configurable (CompileCommand2 option)
  :li.+ command to compile without asking anything (RunCompiler)
  :li.+ only load desktop when no arguments on command line (option) (this is achieved by setting LoadDesktopOnEntry=2 in :font facename='System Monospaced' size=12x8.global.fte:font facename='default'.)
  :li.+ create folds with RoutineRx (command FoldCreateAtRoutines)
  :li.+ command to center current line (LineCenter)
  :li.+ OS/2: does not need 'clipserv' anymore (experimental, please report bugs).
  :li.+ Readonly files are not editable when loaded.
  :li.+ ...
:eul.

:h4.0.45&mdash.February 1997
:ul compact.
  :li.! bug fixes.
  :li.! some command line option changes (-h = help now, -H = history).
  :li.+ support for multiple frames in the PM version.
  :li.+ first win32 console version.
:eul.

:h4.0.44&mdash.November 28

:h4.0.44b6&mdash.November 1996
:ul compact.
  :li.! Bug fixes in Linux pipe handling.
  :li.! Bug fixes in OS/2 PM version.
  :li.! Fixed repainting bugs in Messages view.
:eul.

:h4.0.44b5&mdash.November 1996
:ul compact.
  :li.! Minor bug fixes.
  :li.! Changes in syntax highlighting configuration.
:eul.

:h4.0.44b4&mdash.October 1996
:ul compact.
  :li.! Minor bug fixes and numerous performance improvements.
  :li.+ New commands: BlockEnTab, BlockUnTab.
  :li.+ Configurable syntax highlighting. Modes HTML/IPF/Ada/Pascal/... are now configured externally.
  :li.+ CTags support. New commands: TagFind, TagFindWord, TagNext, TagPrev, TagPop, TagLoad, TagClear. Needs external ctags utility to create tags file. Tagfile and tag to find can be given on command line.
  :li.+ New option: KeepMessages. New command: ClearMessages.
  :li.+ X11: added support for selection copy/paste.
  :li.+ PM: Accept file dropped on editor window.
  :li.+ PM: Optional toolbar (not configurable yet). New option: ShowToolBar.
  :li.+ PM: GUI dialogs (find/replace, file, ...). New option: GUIDialogs.
  :li.+ PM: Conditional cascade menus can now be used.
  :li.+ PM: Alt+Fx accelerators can now be disabled with PMDisableAccel option.
  :li.- Removed WSStyleSearch flag.
  :li.! PM: Rollup of editor window should now work (tested with title.dll)
  :li.! Menus can now be overriden by predefining them.
  :li.! Unix: completion of .* (dot) files now works.
  :li.! Various fixes to C-mode smart indentation.
  :li.! BlockReadXXX caused crashes when used with bad filename.
  :li.+ Incremental search can now be continued by using up/down arrow.
  :li.! ExitEditor doesn't close files immediatelly after discard. Desktop is now properly saved after cancelling ExitEditor command.
  :li.+ PM: Bigger file selection dialog box with history and save position.
  :li.+ New commands: IndentFunction, BlockMarkFunction, MoveFunctionPrev, MoveFunctionNext. Contributed by: jalving@ibm.net
  :li.+ ...
:eul.

:h4.0.43&mdash.15 July 1996
:ul compact.
  :li.! Minor bug fixes.
  :li.! Upper/Lower block in column mode could cause a crash.
  :li.! CompleteWord command occasionally inserted garbage when previous match was found in the same line.
:eul.

:h4.0.42&mdash.July 1996
:ul compact.
  :li.! Several minor bug fixes.
  :li.! PM version doesn't crash when non-existant file is loaded on startup.
  :li.! HilitWord command now works again.
  :li.+ Setting for HilitWord color.
  :li.+ ViewModeMap command is back.
:eul.

:h4.0.41&mdash.June 1996
:ul compact.
  :li.! Compile command crashed depending on command input.
  :li.! Substrings were matched for keywords in smart indentation (C,REXX)
  :li.! InsertSpacesToTab command always returned fail status.
  :li.! CFTE now compiles to temporary file first and replaces original on success only.
  :li.! CFTE returns correct errorlevel on failure (0 = ok, 1 = fail).
  :li.! SavePos/PrevPos is now stored using real line number, not virtual (folded).
  :li.+ BlockSort command.
  :li.+ UndoMoves setting can be set for mode to enable undo/redo of all cursor movements.
  :li.+ BlockCutAppend, BlockCopyAppend commands to append cut/copied block to clipboard.
  :li.+ Error message locations now track the position better when a file is edited (lines are added/removed).
:eul.

:h4.0.40&mdash.June 1996
:ul compact.
  :li.! Keyword inheritance was not properly handled in colorize modes.
  :li.! Colors were not inherited in colorize modes.
  :li.! OS2: Keys Alt+&lt.menu-letter&gt., F10, Alt+Enter, Alt+Space are
available for remapping.
  :li.! Some startup window sizing problems fixed.
  :li.! Fixed several bugs in configuration files (no bindings for MSG mode,
some Alt+&lt.letter&gt. menu shortcuts).
  :li.! Abbreviation expansion could abort with 'asssertion failed'.
  :li.+ Performance improvements (MatchBracket and related stuff).
  :li.+ OS2: Window position is now saved.
  :li.+ FTE now remembers the directory the compilation was started from and
will resolve all relative pathnames found in error messages using this
directory. The current directory is determined by currently active file or
directory. If Messages are already open, FTE will use directory from there
instead of the current one. The current directory of message list is always the
directory the compilation was started from.
:eul.

:h4.0.39&mdash.May 96
:ul compact.
  :li.! Fixed crash in Compile commands when repeating it.
  :li.! Multi-key bindings inserted an ascii char if the 2+ key was not valid.
  :li.! when inserting ) in Cmode, it failed to advance the cursor when there was no match and AutoHilitParen was set to 1.
  :li.+ EventMap variable to define keymap to use for mode.
  :li.! MoveToLine shows correct default line value when folds are used.
  :li.- Did some reorganization of config files to make adding new binding sets easier.
:eul.

:h4.0.38&mdash.May 96
:ul compact.
  :li.! Many bug fixes (mostly minor).
  :li.+ BlockWrite command can now append to a file.
  :li.+ Directory browser.
  :li.! PERL: properly highlight :font facename='System Monospaced' size=12x8.s[][]:font facename='default'., :font facename='System Monospaced' size=12x8.tr[][]:font facename='default'..
  :li.+ Configuration files must now be compiled.
  :li.+ Syntax highlighting definitions now independant of editing mode.
  :li.+ Event mappings now independant of editing mode.
  :li.+ Abbreviatons. Can expand the text or run a macro.
  :li.+ Searching can now check for words without using regular expressions.
  :li.+ Loading files is now almost twice as fast.
  :li.+ File positions and prompt history is now saved in file FTE.HIS.
  :li.+ The list of loaded files is saved on exit to FTE.DSK. Files are automatically loaded on startup. Several settings and command line options are available to configure this.
  :li.+ On startup, only the first file is actually loaded. Other files are loaded only as they are needed.
  :li.+ BlockTrans, CharTrans and LineTrans commands. Can translate characters according to arguments (BlockTrans 'a-z' 'A-Z', etc).
  :li.+ When cursor is over the bracket, the matching bracket can be higlighted automatically of visible on screen.
  :li.! InsPrevLineChar, InsPrevLineToEol failed when tabs were on previous line.
  :li.+ Nonpersistent blocks (with various options and commands).
  :li.+ ...
:eul.

:h4.0.37&mdash.Dec 95
:ul compact.
  :li.- Status line can now be hidden. Also changed it's look.
  :li.- Changed the syntax of keyboard bindings. Now it is possible to better emulate the wordstar two-key behavior. See documentation for details. It is also possible to define different commands for gray/white keys.
  :li.! MENU shortcuts now work.
  :li.+ New command: FileWriteTo
  :li.! Fixed crash when trying to center nonexistant line in file.
  :li.- Changing folds now modifies the file.
  :li.- When CursorTroughTabs was set to 0, certain movement commands would behave incorrectly.
  :li.+ S-Ins will perform Paste operation in prompts.
  :li.+ New Command: WinResize &lt.delta&gt. and WinClose. Windows can be also resized by a mouse.
:eul.

:h4.0.36&mdash.Oct 95
:ul compact.
  :li.! Fixed when editor would crash when saving a folded file, but no folds are configured for active mode.
  :li.! Fixed minor bug in C mode indentation.
  :li.+ New command: InsertSpacesToTab (takes optional tabsize argument).
:eul.

:h4.0.35&mdash.Oct 95
:ul compact.
  :li.KillWordPrev now works correctly.
  :li.FindReplace command works correctly if WSStyleSearch == 1.
:eul.

:h4.0.34&mdash.1995/10/15
:ul compact.
  :li.Minor fixes &amp. docs updates...
:eul.

:h4.0.33&mdash.1995/10/01
:ul compact.
  :li.! SIGBREAK handler now works again.
  :li.! Fixes in C/C++ smart indentation (if in switch, ...)
  :li.+ Pascal highlighting mode.
  :li.+ Printing.
  :li.+ Rewritten folding. Now supports nested folds, opening, closing folds, and persistent folds.
  :li.+ New folding commands: FoldCreate, FoldDestroy, FoldOpen,
   FoldClose, FoldPromote, FoldDemote, FoldCreateByRegexp,
   FoldOpenAll, FoldOpenNested, FoldCloseAll, FoldDestroyAll,
   FoldToggleOpenClose, MoveFoldPrev, MoveFoldNext.
  :li.+ New settings: SaveFolds, CommentStart, CommentEnd.
  :li.+ Word characters can be configured using WordChars setting.
:eul.

:h4.0.32&mdash.1995/08/15
:ul compact.
  :li.+ New search routines. (Find, FindReplace, FindRepeat, FindRepeatReverse, FindRepeatOnce, ...)
  :li.+ Block-local searches.
  :li.+ In buffer-list, most recently used files will now be listed first.
  :li.+ Main menu bar can now be hidden.
  :li.+ Performance improvements.
  :li.+ Bookmarks! New commands: PlaceBookmark, GotoBookmark, RemoveBookmark
  :li.+ Files can now be saved and closed from window list.
  :li.+ Optimized CMode indentation. Also more configurable.
:eul.

:h4.0.31&mdash.1995/07/31
:ul compact.
  :li.! Bug fixed in undo/redo when UndoLimit reached.
:eul.

:h4.0.30&mdash.1995/07/30
:ul compact.
  :li.+ Folding support.
  :li.+ New commands: FoldLine, UnfoldLine, UnfoldNextLine, UnfoldAll, ClearFolds, FoldIndent, FoldRegexp, FoldBlock, UnfoldBlock, FoldBlockRegexp.
  :li.! BackSpace at eof when TrimLine is enabled will not abort.
  :li.+ Incremental search (IncrementalSearch).
  :li.+ PgUp/PgDn on a file prompt will show a list of files.
  :li.+ New command: CompleteWord
:eul.

:h4.0.29&mdash.1995/07/20
:ul compact.
  :li.Regexps can now be case insensitive (\C,\c).
  :li.BlockRead/BlockReadColumn/BlockWrite commands.
  :li.Block marking can now be undone.
  :li.Commands that prompt for string/int values can now take string/int arguments.
  :li.Multiple compile-regex statements can be specified simultaneously
  :li.Minor bug-fixes in regexps ([\x00-\xFF] now works).
  :li.Filter for filename completion.
  :li.New commands: SwitchTo ChangeKeys ChangeFlags ShowMenu
  :li.New options: CompletionFilter DefaultModeName
:eul.

:h4.0.28&mdash.1995/07/08
:ul compact.
  :li.- Needs to have documentation updated.
  :li.Mostly rewritten PERL highlighting. Works much better now.
  :li.Completely new config file syntax.
  :li.New commands: ASCIITable, LoadFileInMode
  :li.CMode indentation should now work for Perl (close enough).
  :li.Highlighting for ADA and Email messages.
:eul.

:h4.0.27&mdash.1995/06/19
:ul compact.
  :li.Minor bug fixes.
:eul.

:h4.0.26&mdash.1995/06/18
:ul compact.
  :li.New commands: {Char,Line,Block}Case{Up,Down,Toggle}
  :li.New setting: LoadAfterQuit&mdash.if set to 1, editor will prompt to load another file before exiting.
  :li.New setting: ShowScrollBar {0,1}.
:eul.

:h4.0.25&mdash.1995/06/12
:ul compact.
  :li.Minor bug fix in REXX highlighting ("\"", ...)
  :li.Bug fixes in word wrap.
  :li.BlockCut now doesn't move the cursor to the block beginning.
  :li.New commands: MoveLineTop, MoveLineCenter, MoveLineBottom.
  :li.Editor will now check if the file has changed before the first modification.
  :li.Found text is now highlighted.
  :li.New CMode setting: C.BraceOfs and command: ChangeCBraceOfs
  :li.New commands: MovePrevPos, SavePos, MoveSavedPos, MoveSavedPosCol, MoveSavedPosRow
:eul.

:h4.0.24&mdash.1995/06/06
:ul compact.
  :li.When checking for file modification time of last change is now used instead of the time of last access.
  :li.Wildcard support for file loading.
:eul.

:h4.0.23&mdash.1995/06/04
:ul compact.
  :li.Ctrl+C and Ctrl+Break are now disabled.
  :li.Ctrl+S and Ctrl+C keys are now again recognised in Windowed mode.
  :li.Fixed problem when spawning a subprocess in Windowed mode.
  :li.New command: ShowEntryScreen
  :li.ListRoutines in CMode only shows functions not their prototypes.
  :li.New setting: SysClipboard - if set to 1, editor will automatically use system clipboard.
  :li.New command: ToggleSysClipboard.
  :li.Minor bug fix in PM clipboard support.
  :li.New commands: BlockPasteStream, BlockPasteColumn and BlockPasteLine. BlockPaste command will now always paste in current block mode, not in the last Copy/Cut mode.
  :li.More than 4 commands can be bound to a key (actually this worked since 0.18, but was not documented).
  :li.New command: FileReload.
  :li.Editor will now check if file has changed on disk before saving it.
:eul.

:h4.0.22&mdash.1995/05/28
:ul compact.
  :li.But fix in regular expressions (nested +#*@).
  :li.Changes in regular expression syntax.
  :li.New function: ListRoutines. Shows functions in current buffer.
  :li.New setting: RoutineRx
:eul.

:h4.0.21&mdash.1995/05/21
:ul compact.
  :li.REXX mode smart indentation.
  :li.KillWord &amp. KillWordPrev commands now actually work.
  :li.Pressing Ctrl+Enter to begin Search will toggle case sensitivity of search.
  :li.New option 'Trim' and commands 'ToggleTrim', 'LineTrim'. Removes whitespace from end of lines.
  :li.New option 'ShowMarkers' and command 'ToggleShowMarkers'. Shows end of line and end of file markers.
  :li.Bug fix in PERL highlighting (caused lockups)
  :li.Bug fixes and improvements in regular expressions.
:eul.

:h4.0.20&mdash.1995/05/18
:ul compact.
  :li.Major bug fixes in word wrap.
  :li.New commands: MovePrevTab, MoveNextTab.
  :li.Bug fixes in BlockIndent and BlockUnindent (stream/line mode)
:eul.

:h4.0.19&mdash.1995/05/16
:ul compact.
  :li.Function names in REXX are now highlighted.
  :li.WordWrap can be set to 0 - disabled, 1 - wrap line at right margin and 2 - wrap paragraph continously. Function ToggleAutoWrap renamed to ToggleWordWrap.
  :li.New way to set left/right margin (SetLeftMargin, SetLeftMargin)
  :li.Minor fix in PERL highlighting.
:eul.

:h4.0.18&mdash.1995/05/13
:ul compact.
  :li.PERL Syntax Higlighting.
  :li.Memory allocation problem in tab expansion.
  :li.Wordwrap now strips all spaces on beginning of line (except on the first line of the paragraph).
  :li.Tabs can be set to any number between 1 and 32.
  :li.Changed names of buffer flags (WrapOn -> AutoWrap, UndoRedo -> Undo, ShowTab -> ShowTabs)
  :li.New commands: ToggleAutoIndent, ToggleExpandTabs, ToggleShowTabs, ToggleUndo, ToggleReadOnly, ToggleKeepBackups, ToggleMatchCase, ToggleBackSpKillTab, ToggleDeleteKillTab, ToggleSpaceTabs, ToggleIndentWithTabs, ToggleBackSpUnindents, ToggleAutoWrap.
  :li.New commands: WinRefresh, ChangeTabSize, ChangeCIndent, ChangeLeftMargin, ChangeRightMargin.
:eul.

:h4.0.17&mdash.1995/05/10
:ul compact.
  :li.Minor fix in word-wrap.
  :li.Screen repaint problems when shelling out fixed.
  :li.Blinking disabled for full-screen, high-intensity background colors can now be used.
:eul.

:h4.0.16&mdash.1995/05/06
:ul compact.
  :li.Minor speedups in screen handling and highlighting.
  :li.Regular expressions can now match start and end of words using .
  :li.Regexp replace can paste entire matched string using &amp..
  :li.Regexp search/replace could match part of just replaced string.
  :li.New commands: MoveLastNonWhite, MovePrevEqualIndent and MoveNextEqualIndent, LineDuplicate, InsPrevLineChar, InsPrevLineToEol.
  :li.New color config. 'C.Function' for functions in C highlighting mode.
  :li.Improved CMode hilit, preprocessor hiliting improved (strings, comments, numbers)
:eul.

:h4.0.15

:h5.1995/04/29
:ul compact.
  :li.Speed improvement in CMode auto indent.
  :li.Delete command can now delete full tabs instead of converting them to spaces.
  :li.When closing a modified file, editor prompts you to save it.
  :li.Automatic indentation can now use tabs.
  :li.Manual and automatic wordwrap.
:eul.

:h5.1995/04/24
:ul compact.
  :li.Backspace can now delete full tabs instead of converting them to spaces
  :li. (See BackSpace and KillBackTab).
  :li.Backspace can unindent to previous indentation level.
:eul.

:h5.1995/04/20
:ul compact.
  :li.Basic mouse support.
:eul.

:h5.1995/04/12
:ul compact.
  :li.Configurable colors/keywords in C/REXX mode.
:eul.

:h4.0.14&mdash.1995/04/07
:ul compact.
  :li.Characters could not be entered using AltGr on international keyboards.
  :li.Immediatelly doing an undo on a newly loaded file deleted the first line.
  :li.Ascii characters >= 128 can be now entered without quote command (C-Q).
  :li.IPF Syntax highlighting.
:eul.

:h4.0.13&mdash.1995/04/03
:ul compact.
  :li.Bug fix in regular expressions.
  :li.Bug fixes in compiler support
  :li.Editor clipboard can now be copied to/from PM clipboard.
:eul.

:h4.0.12

:h5.1995/03/30
:ul compact.
  :li.Compiler support + error message parsing
:eul.

:h5.1995/03/25
:ul compact.
  :li.Paren matching (Command: MatchBracket).
  :li.Bug fixes in CMode smart indentation.
:eul.

:h4.0.11

:h5.1995/03/11
:ul compact.
  :li.Unlimited undo now works again.
:eul.

:h5.1995/03/18
:ul compact.
  :li.Entire blocks of C code can now be reindented (BlockReIndent)
  :li.Search can now be case insensitive (SearchMatchCase - toggle). Option: MatchCase, Command: SearchMatchCase
  :li.Regular expression find/replace works (case sensitive only)
:eul.

:h5.1995/03/19
:ul compact.
  :li.Fixed a bug in redo (last command could not be undone)
  :li.New option: KeepBackups&mdash.if set to 0, backup files will be deleted after a succesful save.
:eul.

:h4.0.10

:h5.1995/03/06
:ul compact.
  :li.Fixed CMode indent when tabs are present in the file.
  :li.Prompts now retain previous text only if you try to edit it.
:eul.

:h5.1995/03/04
:ul compact.
  :li.4DOS/4OS2 style filename completion (FileOpen, ...).
:eul.

:h5.1995/02/25
:ul compact.
  :li.New load routine, much faster in some cases.
  :li.Undo/Redo can now be limited (if you hate to waste memory).
:eul.

:h5.1995/02/19
:ul compact.
  :li.C Mode indentation level can now be specified (C.Indent)
  :li.Bug fixes in screen redraw.
  :li.Editor will now scroll text instead of always redisplaying the screen.
  :li.Regular expressions (Search only).
:eul.

:h4.0.09&mdash.1995/02/08
:ul compact.
  :li.First public release (Version 0.09b)
:eul.
:euserdoc.