/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20131115-32 [Nov 28 2013]
 * Copyright (c) 2000 - 2013 Intel Corporation
 * 
 * Disassembly of , Fri Aug 22 07:08:51 2014
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00004DF6 (19958)
 *     Revision         0x01 **** 32-bit table (V1), no 64-bit math support
 *     Checksum         0x8F
 *     OEM ID           "HP"
 *     OEM Table ID     "Wombat"
 *     OEM Revision     0x06040000 (100925440)
 *     Compiler ID      "MSFT"
 *     Compiler Version 0x0100000B (16777227)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "HP", "Wombat", 0x06040000)
{
    Scope (_PR)
    {
        Processor (CPU0, 0x00, 0x00000000, 0x00) {}
        Processor (CPU1, 0x01, 0x00000000, 0x00) {}
    }

    Scope (_SB)
    {
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))  // _HID: Hardware ID
            Name (_BBN, 0x00)  // _BBN: BIOS Bus Number
            Name (_ADR, 0x00)  // _ADR: Address
            OperationRegion (REGS, PCI_Config, 0x40, 0xC0)
            Field (REGS, DWordAcc, Lock, Preserve)
            {
                Offset (0x18), 
                    ,   7, 
                HEN,    1, 
                PAM0,   8, 
                PAM1,   8, 
                PAM2,   8, 
                PAM3,   8, 
                PAM4,   8, 
                PAM5,   8, 
                PAM6,   8, 
                DRB0,   8, 
                Offset (0x22), 
                DRB1,   8, 
                Offset (0x24), 
                DRB2,   8, 
                Offset (0x26), 
                DRB3,   8, 
                Offset (0x28), 
                DRB4,   8, 
                Offset (0x2A), 
                DRB5,   8, 
                Offset (0x2C), 
                DRB6,   8, 
                Offset (0x2E), 
                DRB7,   8, 
                Offset (0x3E), 
                DRBF,   16, 
                Offset (0x84), 
                TOM,    16
            }

            Name (RSRC, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    0x00,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    0x00,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    0x00,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000C3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y01, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C4000,         // Range Minimum
                    0x000C7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y02, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C8000,         // Range Minimum
                    0x000CBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y03, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000CC000,         // Range Minimum
                    0x000CFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y04, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D0000,         // Range Minimum
                    0x000D3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y05, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D4000,         // Range Minimum
                    0x000D7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y06, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D8000,         // Range Minimum
                    0x000DBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y07, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000DC000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y08, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E0000,         // Range Minimum
                    0x000E3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y09, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E4000,         // Range Minimum
                    0x000E7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0A, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E8000,         // Range Minimum
                    0x000EBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0B, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000EC000,         // Range Minimum
                    0x000EFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0C, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    0x00,, _Y00, AddressRangeMemory, TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    0x00,, , TypeStatic)
            })
            Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
            {
                Store (Zero, Local1)
                CreateDWordField (RSRC, \_SB.PCI0._Y00._MIN, BTMN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y00._MAX, BTMX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y00._LEN, BTLN)  // _LEN: Length
                Store (TOM, Local0)
                ShiftLeft (Local0, 0x10, Local0)
                Store (Local0, BTMN)
                Subtract (0xFEC00000, Local0, BTLN)
                Subtract (Add (BTMN, BTLN), 0x01, BTMX)
                CreateBitField (RSRC, \_SB.PCI0._Y01._RW, C0RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y01._MIN, C0MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y01._MAX, C0MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y01._LEN, C0LN)  // _LEN: Length
                Store (One, C0RW)
                If (LEqual (And (PAM1, 0x03), 0x01))
                {
                    Store (Zero, C0RW)
                }

                Store (Zero, C0LN)
                If (LNot (And (PAM1, 0x03)))
                {
                    Store (0x4000, C0LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y02._RW, C4RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y02._MIN, C4MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y02._MAX, C4MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y02._LEN, C4LN)  // _LEN: Length
                Store (One, C4RW)
                If (LEqual (And (PAM1, 0x30), 0x10))
                {
                    Store (Zero, C4RW)
                }

                Store (Zero, C4LN)
                If (LNot (And (PAM1, 0x30)))
                {
                    Store (0x4000, C4LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y03._RW, C8RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y03._MIN, C8MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y03._MAX, C8MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y03._LEN, C8LN)  // _LEN: Length
                Store (One, C8RW)
                If (LEqual (And (PAM2, 0x03), 0x01))
                {
                    Store (Zero, C8RW)
                }

                Store (Zero, C8LN)
                If (LNot (And (PAM2, 0x03)))
                {
                    Store (0x4000, C8LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y04._RW, CCRW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y04._MIN, CCMN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y04._MAX, CCMX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y04._LEN, CCLN)  // _LEN: Length
                Store (One, CCRW)
                If (LEqual (And (PAM2, 0x30), 0x10))
                {
                    Store (Zero, CCRW)
                }

                Store (Zero, CCLN)
                If (LNot (And (PAM2, 0x30)))
                {
                    Store (0x4000, CCLN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y05._RW, D0RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y05._MIN, D0MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y05._MAX, D0MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y05._LEN, D0LN)  // _LEN: Length
                Store (One, D0RW)
                If (LEqual (And (PAM3, 0x03), 0x01))
                {
                    Store (Zero, D0RW)
                }

                Store (Zero, D0LN)
                If (LNot (And (PAM3, 0x03)))
                {
                    Store (0x4000, D0LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y06._RW, D4RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y06._MIN, D4MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y06._MAX, D4MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y06._LEN, D4LN)  // _LEN: Length
                Store (One, D4RW)
                If (LEqual (And (PAM3, 0x30), 0x10))
                {
                    Store (Zero, D4RW)
                }

                Store (Zero, D4LN)
                If (LNot (And (PAM3, 0x30)))
                {
                    Store (0x4000, D4LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y07._RW, D8RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y07._MIN, D8MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y07._MAX, D8MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y07._LEN, D8LN)  // _LEN: Length
                Store (One, D8RW)
                If (LEqual (And (PAM4, 0x03), 0x01))
                {
                    Store (Zero, D8RW)
                }

                Store (Zero, D8LN)
                If (LNot (And (PAM4, 0x03)))
                {
                    Store (0x4000, D8LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y08._RW, DCRW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y08._MIN, DCMN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y08._MAX, DCMX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y08._LEN, DCLN)  // _LEN: Length
                Store (One, DCRW)
                If (LEqual (And (PAM4, 0x30), 0x10))
                {
                    Store (Zero, DCRW)
                }

                Store (Zero, DCLN)
                If (LNot (And (PAM4, 0x30)))
                {
                    Store (0x4000, DCLN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y09._RW, E0RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y09._MIN, E0MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y09._MAX, E0MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y09._LEN, E0LN)  // _LEN: Length
                Store (One, E0RW)
                If (LEqual (And (PAM5, 0x03), 0x01))
                {
                    Store (Zero, E0RW)
                }

                Store (Zero, E0LN)
                If (LNot (And (PAM5, 0x03)))
                {
                    Store (0x4000, E0LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0A._RW, E4RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y0A._MIN, E4MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y0A._MAX, E4MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y0A._LEN, E4LN)  // _LEN: Length
                Store (One, E4RW)
                If (LEqual (And (PAM5, 0x30), 0x10))
                {
                    Store (Zero, E4RW)
                }

                Store (Zero, E4LN)
                If (LNot (And (PAM5, 0x30)))
                {
                    Store (0x4000, E4LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0B._RW, E8RW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y0B._MIN, E8MN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y0B._MAX, E8MX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y0B._LEN, E8LN)  // _LEN: Length
                Store (One, E8RW)
                If (LEqual (And (PAM6, 0x03), 0x01))
                {
                    Store (Zero, E8RW)
                }

                Store (Zero, E8LN)
                If (LNot (And (PAM6, 0x03)))
                {
                    Store (0x4000, E8LN)
                }

                CreateBitField (RSRC, \_SB.PCI0._Y0C._RW, ECRW)  // _RW_: Read-Write Status
                CreateDWordField (RSRC, \_SB.PCI0._Y0C._MIN, ECMN)  // _MIN: Minimum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y0C._MAX, ECMX)  // _MAX: Maximum Base Address
                CreateDWordField (RSRC, \_SB.PCI0._Y0C._LEN, ECLN)  // _LEN: Length
                Store (One, ECRW)
                If (LEqual (And (PAM6, 0x30), 0x10))
                {
                    Store (Zero, ECRW)
                }

                Store (Zero, ECLN)
                If (LNot (And (PAM6, 0x30)))
                {
                    Store (0x4000, ECLN)
                }

                Return (RSRC)
            }

            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (LNot (\PICF))
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x00, 
                            \_SB.PCI0.LPC0.LNKA, 
                            0x00
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x01, 
                            \_SB.PCI0.LPC0.LNKB, 
                            0x00
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x02, 
                            \_SB.PCI0.LPC0.LNKC, 
                            0x00
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x03, 
                            \_SB.PCI0.LPC0.LNKD, 
                            0x00
                        }
                    })
                }
                Else
                {
                    Return (Package (0x04)
                    {
                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x00, 
                            0x00, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x01, 
                            0x00, 
                            0x11
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x02, 
                            0x00, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x03, 
                            0x00, 
                            0x13
                        }
                    })
                }
            }

            Device (AGP)
            {
                Name (_ADR, 0x00010000)  // _ADR: Address
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (LNot (\PICF))
                    {
                        Return (Package (0x02)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                0x00, 
                                \_SB.PCI0.LPC0.LNKA, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x01, 
                                \_SB.PCI0.LPC0.LNKB, 
                                0x00
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x02)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                0x00, 
                                0x00, 
                                0x10
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x01, 
                                0x00, 
                                0x11
                            }
                        })
                    }
                }
            }

            Device (HLB)
            {
                Name (_ADR, 0x00020000)  // _ADR: Address
                Device (P64H)
                {
                    Name (_ADR, 0x001F0000)  // _ADR: Address
                    Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                    {
                        If (LNot (\PICF))
                        {
                            Return (Package (0x0A)
                            {
                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x00, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x01, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x02, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x03, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x00, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x01, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x02, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x03, 
                                    \_SB.PCI0.LPC0.LNKG, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0008FFFF, 
                                    0x00, 
                                    \_SB.PCI0.LPC0.LNKH, 
                                    0x00
                                }, 

                                Package (0x04)
                                {
                                    0x0008FFFF, 
                                    0x01, 
                                    \_SB.PCI0.LPC0.LNKD, 
                                    0x00
                                }
                            })
                        }
                        Else
                        {
                            Return (Package (0x0A)
                            {
                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x00, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x01, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x02, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0004FFFF, 
                                    0x03, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x00, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x01, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x02, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0005FFFF, 
                                    0x03, 
                                    0x00, 
                                    0x16
                                }, 

                                Package (0x04)
                                {
                                    0x0008FFFF, 
                                    0x00, 
                                    0x00, 
                                    0x17
                                }, 

                                Package (0x04)
                                {
                                    0x0008FFFF, 
                                    0x01, 
                                    0x00, 
                                    0x13
                                }
                            })
                        }
                    }

                    Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                    {
                        0x18, 
                        0x04
                    })
                }
            }

            Device (SLOT)
            {
                Name (_ADR, 0x001E0000)  // _ADR: Address
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (LNot (\PICF))
                    {
                        Return (Package (0x0D)
                        {
                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x00, 
                                \_SB.PCI0.LPC0.LNKB, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x01, 
                                \_SB.PCI0.LPC0.LNKC, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x02, 
                                \_SB.PCI0.LPC0.LNKD, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x03, 
                                \_SB.PCI0.LPC0.LNKE, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x00, 
                                \_SB.PCI0.LPC0.LNKC, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x01, 
                                \_SB.PCI0.LPC0.LNKD, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x02, 
                                \_SB.PCI0.LPC0.LNKE, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x03, 
                                \_SB.PCI0.LPC0.LNKF, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x00, 
                                \_SB.PCI0.LPC0.LNKD, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x01, 
                                \_SB.PCI0.LPC0.LNKE, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x02, 
                                \_SB.PCI0.LPC0.LNKF, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x03, 
                                \_SB.PCI0.LPC0.LNKG, 
                                0x00
                            }, 

                            Package (0x04)
                            {
                                0x000DFFFF, 
                                0x00, 
                                \_SB.PCI0.LPC0.LNKF, 
                                0x00
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x0D)
                        {
                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x00, 
                                0x00, 
                                0x11
                            }, 

                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x01, 
                                0x00, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x02, 
                                0x00, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0x000AFFFF, 
                                0x03, 
                                0x00, 
                                0x14
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x00, 
                                0x00, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x01, 
                                0x00, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x02, 
                                0x00, 
                                0x14
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x03, 
                                0x00, 
                                0x15
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x00, 
                                0x00, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x01, 
                                0x00, 
                                0x14
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x02, 
                                0x00, 
                                0x15
                            }, 

                            Package (0x04)
                            {
                                0x0009FFFF, 
                                0x03, 
                                0x00, 
                                0x16
                            }, 

                            Package (0x04)
                            {
                                0x000DFFFF, 
                                0x00, 
                                0x00, 
                                0x15
                            }
                        })
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0B, 
                    0x04
                })
            }

            Device (LPC0)
            {
                Name (_ADR, 0x001F0000)  // _ADR: Address
                Method (DECD, 4, Serialized)
                {
                    Store (Arg0, Debug)
                }

                OperationRegion (REGS, PCI_Config, 0x40, 0xC0)
                Field (REGS, DWordAcc, Lock, Preserve)
                {
                    PMBA,   16, 
                    Offset (0x18), 
                    GPBA,   16, 
                    Offset (0xB0), 
                        ,   5, 
                    FUND,   2
                }

                Device (MBRD)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x1F)  // _UID: Unique ID
                    Name (RSRC, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0024,             // Range Minimum
                            0x0024,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0028,             // Range Minimum
                            0x0028,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x002C,             // Range Minimum
                            0x002C,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0030,             // Range Minimum
                            0x0030,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0034,             // Range Minimum
                            0x0034,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0038,             // Range Minimum
                            0x0038,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x003C,             // Range Minimum
                            0x003C,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x004E,             // Range Minimum
                            0x004E,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x01,               // Alignment
                            0x06,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A4,             // Range Minimum
                            0x00A4,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A8,             // Range Minimum
                            0x00A8,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00AC,             // Range Minimum
                            0x00AC,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00B0,             // Range Minimum
                            0x00B0,             // Range Maximum
                            0x01,               // Alignment
                            0x06,               // Length
                            )
                        IO (Decode16,
                            0x00B8,             // Range Minimum
                            0x00B8,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00BC,             // Range Minimum
                            0x00BC,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0100,             // Range Minimum
                            0x0100,             // Range Maximum
                            0x01,               // Alignment
                            0x20,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x1000,             // Range Minimum
                            0x1000,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            _Y0D)
                        IO (Decode16,
                            0x1180,             // Range Minimum
                            0x1180,             // Range Maximum
                            0x01,               // Alignment
                            0x40,               // Length
                            _Y0E)
                        IO (Decode16,
                            0x0CA2,             // Range Minimum
                            0x0CA2,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00E2,             // Range Minimum
                            0x00E2,             // Range Maximum
                            0x01,               // Alignment
                            0x03,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.MBRD._Y0D._MIN, PMMN)  // _MIN: Minimum Base Address
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.MBRD._Y0D._MAX, PMMX)  // _MAX: Maximum Base Address
                        And (^^PMBA, 0xFF80, PMMN)
                        Store (PMMN, PMMX)
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.MBRD._Y0E._MIN, GPMN)  // _MIN: Minimum Base Address
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.MBRD._Y0E._MAX, GPMX)  // _MAX: Maximum Base Address
                        And (^^GPBA, 0xFF80, GPMN)
                        Store (GPMN, GPMX)
                        Return (RSRC)
                    }
                }

                Device (DMAC)
                {
                    Name (_HID, EisaId ("PNP0200"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x01,               // Alignment
                            0x0F,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x01,               // Alignment
                            0x20,               // Length
                            )
                        DMA (Compatibility, NotBusMaster, Transfer16, )
                            {4}
                    })
                }

                Device (MATH)
                {
                    Name (_HID, EisaId ("PNP0C04"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {13}
                    })
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {2}
                    })
                }

                Device (RTC)
                {
                    Name (_HID, EisaId ("PNP0B00"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {8}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (TIME)
                {
                    Name (_HID, EisaId ("PNP0100"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {0}
                    })
                }

                Device (LNKA)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x01)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y0F)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRA, 0x80, PIRA)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKA._Y0F._INT, IRQ0)  // _INT: Interrupts
                        And (PIRA, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Store (RSRC, Debug)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        Store (Arg0, Debug)
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRA, 0x70), PIRA)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRA, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKB)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x02)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y10)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRB, 0x80, PIRB)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKB._Y10._INT, IRQ0)  // _INT: Interrupts
                        And (PIRB, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRB, 0x70), PIRB)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRB, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKC)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x03)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y11)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRC, 0x80, PIRC)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKC._Y11._INT, IRQ0)  // _INT: Interrupts
                        And (PIRC, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRC, 0x70), PIRC)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRC, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKD)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x04)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y12)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRD, 0x80, PIRD)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKD._Y12._INT, IRQ0)  // _INT: Interrupts
                        And (PIRD, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRD, 0x70), PIRD)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRD, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKE)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x05)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y13)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRE, 0x80, PIRE)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKE._Y13._INT, IRQ0)  // _INT: Interrupts
                        And (PIRE, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Store (RSRC, Debug)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        Store (Arg0, Debug)
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRE, 0x70), PIRE)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRE, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKF)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x06)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y14)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRF, 0x80, PIRF)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKF._Y14._INT, IRQ0)  // _INT: Interrupts
                        And (PIRF, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Store (RSRC, Debug)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        Store (Arg0, Debug)
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRF, 0x70), PIRF)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRF, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKG)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x07)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y15)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRG, 0x80, PIRG)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKG._Y15._INT, IRQ0)  // _INT: Interrupts
                        And (PIRG, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Store (RSRC, Debug)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        Store (Arg0, Debug)
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRG, 0x70), PIRG)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRG, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                Device (LNKH)
                {
                    Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                    Name (_UID, 0x08)  // _UID: Unique ID
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,6,7,9,10,11,14,15}
                    })
                    Name (RSRC, ResourceTemplate ()
                    {
                        IRQ (Level, ActiveLow, Shared, _Y16)
                            {}
                    })
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Or (PIRH, 0x80, PIRH)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (RSRC, \_SB.PCI0.LPC0.LNKH._Y16._INT, IRQ0)  // _INT: Interrupts
                        And (PIRH, 0x0F, Local0)
                        ShiftLeft (0x01, Local0, IRQ0)
                        Store (RSRC, Debug)
                        Return (RSRC)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        Store (Arg0, Debug)
                        CreateWordField (Arg0, 0x01, IRQ0)
                        FindSetRightBit (IRQ0, Local0)
                        Decrement (Local0)
                        Or (Local0, And (PIRH, 0x70), PIRH)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (PIRH, 0x80))
                        {
                            Return (0x09)
                        }

                        Return (0x0B)
                    }
                }

                OperationRegion (PIRX, PCI_Config, 0x60, 0x04)
                Field (PIRX, DWordAcc, Lock, Preserve)
                {
                    AccessAs (ByteAcc, 0x00), 
                    PIRA,   8, 
                    PIRB,   8, 
                    PIRC,   8, 
                    PIRD,   8
                }

                OperationRegion (PIRY, PCI_Config, 0x68, 0x04)
                Field (PIRY, DWordAcc, Lock, Preserve)
                {
                    AccessAs (ByteAcc, 0x00), 
                    PIRE,   8, 
                    PIRF,   8, 
                    PIRG,   8, 
                    PIRH,   8
                }

                OperationRegion (DB80, SystemIO, 0x80, 0x01)
                Field (DB80, ByteAcc, NoLock, Preserve)
                {
                    PT80,   8
                }

                OperationRegion (GPOX, SystemIO, 0x1180, 0x30)
                Field (GPOX, DWordAcc, NoLock, Preserve)
                {
                    Offset (0x07), 
                        ,   3, 
                    IO27,   1, 
                    Offset (0x0F), 
                        ,   3, 
                    LV27,   1, 
                    Offset (0x1B), 
                        ,   3, 
                    BL27,   1
                }

                OperationRegion (PMIO, SystemIO, 0x1000, 0x30)
                Field (PMIO, WordAcc, NoLock, Preserve)
                {
                    AccessAs (DWordAcc, 0x00), 
                    Offset (0x2C), 
                        ,   6, 
                    GPES,   1, 
                    Offset (0x2E), 
                        ,   6, 
                    GPEE,   1
                }

                Device (FWH)
                {
                    Name (_HID, EisaId ("INT0800"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        Memory32Fixed (ReadOnly,
                            0xFFF80000,         // Address Base
                            0x00080000,         // Address Length
                            )
                    })
                }

                Device (SIO)
                {
                    Scope (\_SB)
                    {
                        Method (TWRI, 3, NotSerialized)
                        {
                            And (Arg0, Arg1, Local2)
                            Not (Arg0, Local3)
                            And (Local3, 0xFF, Local3)
                            And (Arg2, Local3, Local1)
                            Or (Local1, Local2, Local2)
                            Return (Local2)
                        }

                        Method (SEAR, 3, NotSerialized)
                        {
                            Store (SizeOf (Arg0), Local0)
                            Name (OFFS, Buffer (0x01)
                            {
                                 0x00
                            })
                            CreateByteField (OFFS, 0x00, OFST)
                            Store (Zero, OFST)
                            Store (Zero, Local7)
                            Store (Arg2, Local1)
                            Add (Local0, Local1, Local0)
                            While (LLess (Local1, Local0))
                            {
                                Store (BURD (Arg1, Local1, 0x01, 0x00, 0x01), Local5)
                                If (LEqual (Local5, 0x47))
                                {
                                    Add (OFST, 0x06, Local6)
                                    Add (OFST, 0x02, Local2)
                                    Add (OFST, 0x04, Local4)
                                    Store (BURD (Arg0, Local6, 0x01, 0x00, 0x01), Local6)
                                    Store (BURD (Arg0, Local2, 0x01, 0x00, 0x02), Local3)
                                    Store (BURD (Arg0, Local4, 0x01, 0x00, 0x02), Local4)
                                    Store (BURD (Arg1, Add (Local1, 0x02), 0x01, 0x00, 0x02), 
                                        Local2)
                                    Store (Zero, Local7)
                                    While (LAnd (LLess (Local3, Local2), LLess (Local3, Local4)))
                                    {
                                        Add (Local3, Local6, Local3)
                                        Increment (Local7)
                                    }

                                    If (LNotEqual (Local3, Local2))
                                    {
                                        Store (0xFF, Local7)
                                    }

                                    Add (Local1, 0x08, Local1)
                                    Add (OFST, 0x08, OFST)
                                }

                                If (LEqual (Local5, 0x2A))
                                {
                                    Add (OFST, 0x01, Local2)
                                    Store (BURD (Arg0, Local2, 0x01, 0x00, 0x01), Local6)
                                    Store (BURD (Arg1, Add (Local1, 0x01), 0x01, 0x00, 0x01), 
                                        Local2)
                                    Store (FIIX (Local2, Local6), Local7)
                                    Add (Local1, 0x03, Local1)
                                    Add (OFST, 0x03, OFST)
                                }

                                If (LEqual (Local5, 0x22))
                                {
                                    Add (OFST, 0x01, Local2)
                                    Store (BURD (Arg0, Local2, 0x01, 0x00, 0x02), Local6)
                                    Store (BURD (Arg1, Add (Local1, 0x01), 0x01, 0x00, 0x02), 
                                        Local2)
                                    Store (FIIX (Local2, Local6), Local7)
                                    Add (Local1, 0x03, Local1)
                                    Add (OFST, 0x03, OFST)
                                }

                                If (LEqual (Local5, 0x85))
                                {
                                    Add (Local1, 0x18, Local1)
                                }

                                If (LEqual (Local7, 0xFF))
                                {
                                    Store (Local0, Local1)
                                }
                            }

                            Return (Local7)
                        }

                        Method (FIIX, 2, NotSerialized)
                        {
                            Store (Arg0, Local2)
                            Store (Arg1, Local6)
                            Store (Zero, Local7)
                            Store (Local6, Local4)
                            FindSetRightBit (Local4, Local3)
                            Decrement (Local3)
                            ShiftLeft (0x01, Local3, Local4)
                            Store (MABI (Arg1), Local5)
                            While (LAnd (LNotEqual (Local2, Local4), Local5))
                            {
                                Increment (Local7)
                                Store (Zero, Local4)
                                Store (GETI (Local6, Local7), Local3)
                                Decrement (Local3)
                                ShiftLeft (0x01, Local3, Local4)
                                Decrement (Local5)
                            }

                            If (LEqual (Local4, Local2))
                            {
                                If (Local7)
                                {
                                    Decrement (Local7)
                                }
                            }
                            Else
                            {
                                Store (0xFF, Local7)
                            }

                            Return (Local7)
                        }

                        Method (MABI, 1, NotSerialized)
                        {
                            Store (Arg0, Local0)
                            Store (Zero, Local7)
                            Store (One, Local5)
                            While (LNotEqual (Local0, Zero))
                            {
                                FindSetRightBit (Local0, Local1)
                                ShiftRight (Local0, Local1, Local0)
                                Increment (Local7)
                            }

                            Return (Local7)
                        }

                        Method (GETI, 2, NotSerialized)
                        {
                            Store (Zero, Local3)
                            Store (Arg1, Local7)
                            While (Local7)
                            {
                                FindSetRightBit (Arg0, Local1)
                                ShiftRight (Arg0, Local1, Arg0)
                                Add (Local3, Local1, Local3)
                                Decrement (Local7)
                            }

                            Return (Local3)
                        }

                        Method (MORE, 3, NotSerialized)
                        {
                            Store (SizeOf (Arg1), Local0)
                            Store (Arg2, Local1)
                            While (LLess (Local1, Local0))
                            {
                                Store (BURD (Arg1, Local1, 0x01, 0x00, 0x01), Local5)
                                If (LEqual (Local5, 0x47))
                                {
                                    Add (Local1, 0x06, Local6)
                                    Add (Local1, 0x02, Local2)
                                    Add (Local1, 0x04, Local4)
                                    Store (BURD (Arg1, Local6, 0x01, 0x00, 0x01), Local6)
                                    Multiply (Arg0, Local6, Local6)
                                    Store (BURD (Arg1, Local2, 0x01, 0x00, 0x02), Local3)
                                    Add (Local3, Local6, Local3)
                                    BURD (Arg1, Local2, 0x02, Local3, 0x02)
                                    BURD (Arg1, Local4, 0x02, Local3, 0x02)
                                    Add (Local1, 0x08, Local1)
                                }

                                If (LEqual (Local5, 0x2A))
                                {
                                    Add (Local1, 0x01, Local2)
                                    Store (BURD (Arg1, Local2, 0x01, 0x00, 0x01), Local6)
                                    Store (Arg0, Local7)
                                    Increment (Local7)
                                    Store (Zero, Local4)
                                    While (Local7)
                                    {
                                        FindSetRightBit (Local6, Local3)
                                        ShiftRight (Local6, Local3, Local6)
                                        Add (Local4, Local3, Local4)
                                        Decrement (Local7)
                                    }

                                    If (LNotEqual (Local4, Zero))
                                    {
                                        Decrement (Local4)
                                        ShiftLeft (0x01, Local4, Local4)
                                        BURD (Arg1, Local2, 0x02, Local4, 0x01)
                                    }

                                    Add (Local1, 0x03, Local1)
                                }

                                If (LEqual (Local5, 0x22))
                                {
                                    Add (Local1, 0x01, Local2)
                                    Store (BURD (Arg1, Local2, 0x01, 0x00, 0x02), Local6)
                                    Store (Arg0, Local7)
                                    Increment (Local7)
                                    Store (Zero, Local4)
                                    While (Local7)
                                    {
                                        FindSetRightBit (Local6, Local3)
                                        ShiftRight (Local6, Local3, Local6)
                                        Add (Local4, Local3, Local4)
                                        Decrement (Local7)
                                    }

                                    If (LNotEqual (Local4, Zero))
                                    {
                                        Decrement (Local4)
                                        ShiftLeft (0x01, Local4, Local4)
                                        BURD (Arg1, Local2, 0x02, Local4, 0x02)
                                    }

                                    Add (Local1, 0x03, Local1)
                                }

                                If (LEqual (Local5, 0x85))
                                {
                                    Add (Local1, 0x18, Local1)
                                }
                            }
                        }

                        Method (BURD, 5, NotSerialized)
                        {
                            Store (Zero, Local1)
                            If (LEqual (Arg2, 0x02))
                            {
                                If (LEqual (Arg4, 0x01))
                                {
                                    CreateByteField (Arg0, Arg1, WRI)
                                    Store (Arg3, WRI)
                                }

                                If (LEqual (Arg4, 0x02))
                                {
                                    CreateWordField (Arg0, Arg1, WRIT)
                                    Store (Arg3, WRIT)
                                }
                            }

                            If (LEqual (Arg2, 0x01))
                            {
                                If (LEqual (Arg4, 0x01))
                                {
                                    CreateByteField (Arg0, Arg1, REA)
                                    Store (REA, Local1)
                                }

                                If (LEqual (Arg4, 0x02))
                                {
                                    CreateWordField (Arg0, Arg1, READ)
                                    Store (READ, Local1)
                                }
                            }

                            Return (Local1)
                        }

                        Method (FRTO, 5, NotSerialized)
                        {
                            CreateField (Arg0, Arg1, Arg4, SOUR)
                            CreateField (Arg2, Arg3, Arg4, DEST)
                            Store (SOUR, DEST)
                        }
                    }

                    Method (DEC, 2, NotSerialized)
                    {
                        Store (SizeOf (Arg0), Local0)
                        Store (Zero, Local1)
                        While (LLess (Local1, Local0))
                        {
                            Store (BURD (Arg0, Local1, 0x01, 0x00, 0x01), Local5)
                            If (LEqual (Local5, 0x47))
                            {
                                Add (Local1, 0x02, Local2)
                                Add (Local1, 0x07, Local6)
                                Store (BURD (Arg0, Local2, 0x01, 0x00, 0x02), Local3)
                                Store (BURD (Arg1, Local2, 0x01, 0x00, 0x02), Local2)
                                Store (BURD (Arg0, Local6, 0x01, 0x00, 0x01), Local4)
                                Store (BURD (Arg1, Local6, 0x01, 0x00, 0x01), Local6)
                                DECD (Local3, Local4, Local2, Local6)
                                Add (Local1, 0x08, Local1)
                            }

                            If (LEqual (Local5, 0x2A))
                            {
                                Add (Local1, 0x03, Local1)
                            }

                            If (LEqual (Local5, 0x22))
                            {
                                Add (Local1, 0x03, Local1)
                            }

                            If (LEqual (Local5, 0x85))
                            {
                                Add (Local1, 0x18, Local1)
                            }

                            If (LEqual (Local5, 0x79))
                            {
                                Add (Local1, 0x02, Local1)
                            }
                        }
                    }

                    Method (RD, 1, NotSerialized)
                    {
                        Name (LENG, Buffer (0x02)
                        {
                             0x00, 0x00
                        })
                        Store (SizeOf (Arg0), LENG)
                        CreateWordField (LENG, 0x00, LEN)
                        Store (One, Local1)
                        Store (Ones, Local7)
                        Store (Zero, Local5)
                        Store (Zero, Local4)
                        While (Local7)
                        {
                            Store (DerefOf (Index (Arg0, Local1)), Local2)
                            If (LNotEqual (Local2, 0x02))
                            {
                                Add (Local1, 0x02, Local2)
                                Add (Local1, 0x03, Local3)
                                Store (READ (DerefOf (Index (Arg0, Local1)), DerefOf (Index (Arg0, 
                                    Local2)), DerefOf (Index (Arg0, Local3))), Local4)
                                If (LEqual (DerefOf (Index (Arg0, Add (Local3, 0x01))), 
                                    Local4))
                                {
                                    Store (Zero, Local5)
                                    Add (Local1, 0x08, Local1)
                                    If (LGreaterEqual (Local1, LEN))
                                    {
                                        Store (Zero, Local7)
                                    }
                                    Else
                                    {
                                    }
                                }
                                Else
                                {
                                    Add (Local1, 0x05, Local6)
                                    Add (Local1, 0x06, Local0)
                                    Add (Local3, 0x01, Local3)
                                    If (DerefOf (Index (Arg0, Local6)))
                                    {
                                        Store (DerefOf (Index (Arg0, Local6)), Local6)
                                        Store (DerefOf (Index (Arg0, Local0)), Local0)
                                        Store (Zero, Local2)
                                        Store (DerefOf (Index (Arg0, Local3)), Local3)
                                        While (LAnd (LNotEqual (Local3, Local4), LLess (Local3, Local6)))
                                        {
                                            Add (Local3, Local0, Local3)
                                            Add (Local2, 0x01, Local2)
                                        }

                                        If (LEqual (Local3, Local4))
                                        {
                                            Store (Local2, Local5)
                                            Add (Local1, 0x08, Local1)
                                            If (LGreaterEqual (Local1, LEN))
                                            {
                                                Store (Zero, Local7)
                                            }
                                            Else
                                            {
                                            }
                                        }
                                        Else
                                        {
                                            Store (0xFF, Local5)
                                            Store (Zero, Local7)
                                        }
                                    }
                                    Else
                                    {
                                        Store (0xFF, Local5)
                                        Store (Zero, Local7)
                                    }
                                }
                            }
                            Else
                            {
                                Subtract (Local1, 0x01, Local1)
                                Store (RDCF (DerefOf (Index (Arg0, Local1))), Local5)
                                If (LEqual (Local5, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }
                                Else
                                {
                                    Add (Local1, 0x02, Local1)
                                    If (LGreaterEqual (Local1, LEN))
                                    {
                                        Store (Zero, Local7)
                                    }
                                    Else
                                    {
                                    }
                                }
                            }
                        }

                        Return (Local5)
                    }

                    Method (RDCF, 1, NotSerialized)
                    {
                        Store (SizeOf (Arg0), Local0)
                        Store (Ones, Local7)
                        Store (0xFF, Local5)
                        Store (Zero, Local1)
                        Store (Zero, Local4)
                        While (Local7)
                        {
                            Add (Local1, 0x01, Local1)
                            Add (Local1, 0x02, Local2)
                            Add (Local1, 0x03, Local3)
                            Store (READ (DerefOf (Index (Arg0, Local1)), DerefOf (Index (Arg0, 
                                Local2)), DerefOf (Index (Arg0, Local3))), Local4)
                            If (LEqual (DerefOf (Index (Arg0, Add (Local3, 0x01))), 
                                Local4))
                            {
                                Store (Zero, Local7)
                                If (LEqual (Local5, 0xFF))
                                {
                                    Store (Zero, Local5)
                                }
                                Else
                                {
                                    Increment (Local5)
                                }
                            }
                            Else
                            {
                                Add (Local1, 0x05, Local1)
                                If (LEqual (Local5, 0xFF))
                                {
                                    Store (Zero, Local5)
                                }
                                Else
                                {
                                    Increment (Local5)
                                }

                                If (LGreaterEqual (Local1, Local0))
                                {
                                    Store (Zero, Local7)
                                    Store (0xFF, Local5)
                                }
                            }
                        }

                        Return (Local5)
                    }

                    Method (RD1, 2, NotSerialized)
                    {
                        Store (SizeOf (Arg0), Local0)
                        Store (One, Local1)
                        Store (Zero, Local2)
                        Store (Ones, Local7)
                        Store (Zero, Local3)
                        While (Local7)
                        {
                            Store (RD (DerefOf (Index (Arg0, Local1))), Local3)
                            If (LEqual (Local3, 0xFF))
                            {
                                Store (Zero, Local7)
                            }
                            Else
                            {
                                Subtract (Local1, 0x01, Local1)
                                Multiply (Local2, 0x08, Local5)
                                Store (SizeOf (Index (Arg0, Local1)), Local4)
                                Multiply (Local4, 0x08, Local4)
                                FRTO (DerefOf (Index (Arg0, Local1)), 0x00, Arg1, Local5, Local4)
                                MORE (Local3, Arg1, Local2)
                                Add (Local2, SizeOf (Index (Arg0, Local1)), Local2)
                                Add (Local1, 0x03, Local1)
                            }

                            If (LLessEqual (Local0, Local1))
                            {
                                Store (Zero, Local7)
                            }
                        }

                        Return (Local3)
                    }

                    Method (WR, 2, NotSerialized)
                    {
                        Name (LENG, Buffer (0x02)
                        {
                             0x00, 0x00
                        })
                        Store (SizeOf (Arg0), LENG)
                        CreateWordField (LENG, 0x00, LEN)
                        Store (One, Local1)
                        Store (Ones, Local7)
                        Store (Zero, Local5)
                        Store (Zero, Local4)
                        While (Local7)
                        {
                            Store (DerefOf (Index (Arg0, Local1)), Local2)
                            If (LNotEqual (Local2, 0x02))
                            {
                                Add (Local1, 0x01, Local1)
                                Add (Local1, 0x01, Local2)
                                Add (Local1, 0x02, Local3)
                                Add (Local1, 0x05, Local4)
                                If (DerefOf (Index (Arg0, Local4)))
                                {
                                    Multiply (DerefOf (Index (Arg0, Local4)), Arg1, Local4)
                                    Add (Local1, 0x03, Local5)
                                    Store (DerefOf (Index (Arg0, Local5)), Local5)
                                    Add (Local5, Local4, Local4)
                                }
                                Else
                                {
                                    Add (Local1, 0x03, Local4)
                                    Store (DerefOf (Index (Arg0, Local4)), Local4)
                                }

                                Store (READ (DerefOf (Index (Arg0, Subtract (Local1, 0x01))), 
                                    DerefOf (Index (Arg0, Local2)), 0xFF), Local6)
                                Store (TWRI (DerefOf (Index (Arg0, Local3)), Local4, Local6), Local6)
                                WRIT (DerefOf (Index (Arg0, Local1)), DerefOf (Index (Arg0, Local2
                                    )), Local6)
                                Add (Local1, 0x07, Local1)
                                If (LGreaterEqual (Local1, LEN))
                                {
                                    Store (Zero, Local7)
                                }
                                Else
                                {
                                }
                            }
                            Else
                            {
                                Subtract (Local1, 0x01, Local1)
                                Store (0x02, Local2)
                                Multiply (Arg1, 0x06, Local3)
                                Add (Local3, Local2, Local3)
                                Add (Local3, 0x01, Local2)
                                Add (Local3, 0x02, Local4)
                                Store (READ (DerefOf (Index (DerefOf (Index (Arg0, Local1)), Subtract (
                                    Local3, 0x01))), DerefOf (Index (DerefOf (Index (Arg0, Local1)), 
                                    Local2)), 0xFF), Local6)
                                Store (TWRI (DerefOf (Index (DerefOf (Index (Arg0, Local1)), Local4
                                    )), DerefOf (Index (DerefOf (Index (Arg0, Local1)), Add (Local4, 0x01
                                    ))), Local6), Local6)
                                WRIT (DerefOf (Index (DerefOf (Index (Arg0, Local1)), Local3)), 
                                    DerefOf (Index (DerefOf (Index (Arg0, Local1)), Local2)), Local6)
                                Add (Local1, 0x02, Local1)
                                If (LGreaterEqual (Local1, LEN))
                                {
                                    Store (Zero, Local7)
                                }
                            }
                        }
                    }

                    Method (SEA, 2, NotSerialized)
                    {
                        Store (Zero, Local0)
                        Store (Zero, Local2)
                        Store (SizeOf (Arg0), Local1)
                        While (LLess (Local0, Local1))
                        {
                            Store (SEAR (DerefOf (Index (Arg0, Local0)), Arg1, Local2), Local3)
                            If (LEqual (Local3, 0xFF))
                            {
                                Store (Local1, Local0)
                            }
                            Else
                            {
                                Store (SizeOf (Index (Arg0, Local0)), Local4)
                                Add (Local0, 0x01, Local0)
                                WR (DerefOf (Index (Arg0, Local0)), Local3)
                                Add (Local2, Local4, Local2)
                                Add (Local0, 0x01, Local0)
                            }
                        }

                        Return (Local3)
                    }

                    Mutex (N366, 0x00)
                    Name (_HID, EisaId ("PNP0A05"))  // _HID: Hardware ID
                    Device (FDC)
                    {
                        Name (_HID, EisaId ("PNP0700"))  // _HID: Hardware ID
                        Name (_UID, 0x01)  // _UID: Unique ID
                        Name (MCD, 0x11)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        })
                        Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03F0,             // Range Minimum
                                        0x03F0,             // Range Maximum
                                        0x08,               // Alignment
                                        0x06,               // Length
                                        )
                                    IO (Decode16,
                                        0x03F7,             // Range Minimum
                                        0x03F7,             // Range Maximum
                                        0x01,               // Alignment
                                        0x01,               // Length
                                        )
                                    IRQNoFlags ()
                                        {6}
                                    DMA (Compatibility, NotBusMaster, Transfer8, )
                                        {2}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0370,             // Range Minimum
                                        0x0370,             // Range Maximum
                                        0x08,               // Alignment
                                        0x06,               // Length
                                        )
                                    IO (Decode16,
                                        0x0377,             // Range Minimum
                                        0x0377,             // Range Maximum
                                        0x01,               // Alignment
                                        0x01,               // Length
                                        )
                                    IRQNoFlags ()
                                        {6}
                                    DMA (Compatibility, NotBusMaster, Transfer8, )
                                        {2}
                                }
                                EndDependentFn ()
                            })
                        }

                        Name (DF0A, Package (0x02)
                        {
                            Package (0x06)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xF0, 0x03, 0xF0, 0x03, 0x08, 0x06,
                                    /* 0008 */   0x47, 0x01, 0xF7, 0x03, 0xF7, 0x03, 0x01, 0x01
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x00, 
                                    0xFF, 
                                    0x5E, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\"@"
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x05, 
                                    0x05, 
                                    0x70, 
                                    0xFF, 
                                    0x06, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x2A, 0x04, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x05, 
                                    0x05, 
                                    0x74, 
                                    0xFF, 
                                    0x02, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x06)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x70, 0x03, 0x70, 0x03, 0x08, 0x06,
                                    /* 0008 */   0x47, 0x01, 0x77, 0x03, 0x77, 0x03, 0x01, 0x01
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x00, 
                                    0xFF, 
                                    0x4E, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\"@"
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x05, 
                                    0x05, 
                                    0x70, 
                                    0xFF, 
                                    0x06, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x2A, 0x04, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x05, 
                                    0x05, 
                                    0x74, 
                                    0xFF, 
                                    0x02, 
                                    0x00, 
                                    0x00
                                }
                            }
                        })
                        Name (ENBL, Package (0x08)
                        {
                            0x01, 
                            0x05, 
                            0x05, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x05, 
                            0x05, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0xB0, RE00)
                            Name (BU00, Buffer (0x16)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0xB0, RE00)
                            Name (BU00, Buffer (0x16)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x0F)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x00)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x00)
                        }
                    }

                    Device (COMA)
                    {
                        Name (_HID, EisaId ("PNP0501"))  // _HID: Hardware ID
                        Name (_UID, 0x01)  // _UID: Unique ID
                        Name (MCD, 0x0F)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        })
                        Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0100,             // Range Minimum
                                        0x07F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15}
                                }
                                EndDependentFn ()
                            })
                        }

                        Name (DF0A, Package (0x09)
                        {
                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x03, 0xF8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x5F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x02, 0xF8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x3F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x03, 0xE8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x5D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x02, 0xE8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x3D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x03, 0xF8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x5F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x02, 0xF8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x3F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x03, 0xE8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x5D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x02, 0xE8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x3D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0x00, 0x01, 0xF8, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x03, 
                                    0xFF, 
                                    0x00, 
                                    0x01DF, 
                                    0x01
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0xFF, 0xFF
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x00, 
                                    0x00, 
                                    0x70, 
                                    0xFF, 
                                    0x00, 
                                    0x0F, 
                                    0x01
                                }
                            }
                        })
                        Name (ENBL, Package (0x08)
                        {
                            0x01, 
                            0x00, 
                            0x00, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x00, 
                            0x00, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0x58, RE00)
                            Name (BU00, Buffer (0x0B)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0x58, RE00)
                            Name (BU00, Buffer (0x0B)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x0F)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x03)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x03)
                        }

                        Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                        {
                            0x08, 
                            0x04
                        })
                    }

                    Device (COMB)
                    {
                        Name (_HID, EisaId ("PNP0501"))  // _HID: Hardware ID
                        Name (_UID, 0x02)  // _UID: Unique ID
                        Name (MCD, 0x10)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        })
                        Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0100,             // Range Minimum
                                        0x07F8,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15}
                                }
                                EndDependentFn ()
                            })
                        }

                        Name (DF0A, Package (0x09)
                        {
                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x03, 0xF8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x5F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x02, 0xF8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x3F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x03, 0xE8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x5D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x02, 0xE8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x3D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x03, 0xF8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x5F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xF8, 0x02, 0xF8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x3F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x03, 0xE8, 0x03, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x5D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x08, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0xE8, 0x02, 0xE8, 0x02, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x3D, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x10, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x04, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x08)
                                {
                                     0x47, 0x01, 0x00, 0x01, 0xF8, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x02, 
                                    0xFF, 
                                    0x00, 
                                    0x01DF, 
                                    0x01
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0xFF, 0xFF
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x03, 
                                    0x03, 
                                    0x70, 
                                    0xFF, 
                                    0x00, 
                                    0x0F, 
                                    0x01
                                }
                            }
                        })
                        Name (ENBL, Package (0x10)
                        {
                            0x03, 
                            0x04, 
                            0x04, 
                            0x00, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00, 
                            0x01, 
                            0x03, 
                            0x03, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x03, 
                            0x03, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0x58, RE00)
                            Name (BU00, Buffer (0x0B)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0x58, RE00)
                            Name (BU00, Buffer (0x0B)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x0F)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x02)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x02)
                        }

                        Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                        {
                            0x08, 
                            0x04
                        })
                    }

                    Device (LPT)
                    {
                        Name (_HID, EisaId ("PNP0400"))  // _HID: Hardware ID
                        Name (_UID, 0x01)  // _UID: Unique ID
                        Name (MCD, 0x12)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        })
                        Method (B_PR, 0, NotSerialized)
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IO (Decode16,
                                        0x07BC,             // Range Minimum
                                        0x07BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IO (Decode16,
                                        0x07BC,             // Range Minimum
                                        0x07BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                            })
                        }

                        Name (DF0A, Package (0x06)
                        {
                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xBC, 0x03, 0xBC, 0x03, 0x08, 0x03,
                                    /* 0008 */   0x47, 0x01, 0xBC, 0x07, 0xBC, 0x07, 0x08, 0x08
                                }, 

                                Package (0x10)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x60, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00, 
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x61, 
                                    0xFF, 
                                    0xBC, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xBC, 0x03, 0xBC, 0x03, 0x08, 0x03,
                                    /* 0008 */   0x47, 0x01, 0xBC, 0x07, 0xBC, 0x07, 0x08, 0x08
                                }, 

                                Package (0x10)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x60, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00, 
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x61, 
                                    0xFF, 
                                    0xBC, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }
                        })
                        Name (ENBL, Package (0x10)
                        {
                            0x03, 
                            0x07, 
                            0x07, 
                            0x00, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00, 
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (B_DI, 0, NotSerialized)
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (B_SR, 1, NotSerialized)
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x00)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x01)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x01)
                        }
                    }

                    Device (LPTB)
                    {
                        Name (_HID, EisaId ("PNP0400"))  // _HID: Hardware ID
                        Name (_UID, 0x02)  // _UID: Unique ID
                        Name (MCD, 0x13)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        })
                        Method (B_PR, 0, NotSerialized)
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IO (Decode16,
                                        0x07BC,             // Range Minimum
                                        0x07BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IO (Decode16,
                                        0x07BC,             // Range Minimum
                                        0x07BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                            })
                        }

                        Name (DF0A, Package (0x06)
                        {
                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xBC, 0x03, 0xBC, 0x03, 0x08, 0x03,
                                    /* 0008 */   0x47, 0x01, 0xBC, 0x07, 0xBC, 0x07, 0x08, 0x08
                                }, 

                                Package (0x10)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x60, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00, 
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x61, 
                                    0xFF, 
                                    0xBC, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xBC, 0x03, 0xBC, 0x03, 0x08, 0x03,
                                    /* 0008 */   0x47, 0x01, 0xBC, 0x07, 0xBC, 0x07, 0x08, 0x08
                                }, 

                                Package (0x10)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x60, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00, 
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x61, 
                                    0xFF, 
                                    0xBC, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }
                        })
                        Name (ENBL, Package (0x10)
                        {
                            0x03, 
                            0x07, 
                            0x07, 
                            0x00, 
                            0xFF, 
                            0x20, 
                            0x00, 
                            0x00, 
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (B_DI, 0, NotSerialized)
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (B_SR, 1, NotSerialized)
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x00)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x01)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x01)
                        }
                    }

                    Device (ECP)
                    {
                        Name (_HID, EisaId ("PNP0401"))  // _HID: Hardware ID
                        Name (_UID, 0x01)  // _UID: Unique ID
                        Name (MCD, 0x14)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        })
                        Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IO (Decode16,
                                        0x07BC,             // Range Minimum
                                        0x07BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IO (Decode16,
                                        0x07BC,             // Range Minimum
                                        0x07BC,             // Range Maximum
                                        0x08,               // Alignment
                                        0x03,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                                DMA (Compatibility, NotBusMaster, Transfer8, )
                                    {1,3}
                            })
                        }

                        Name (DF0A, Package (0x06)
                        {
                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xBC, 0x03, 0xBC, 0x03, 0x08, 0x03,
                                    /* 0008 */   0x47, 0x01, 0xBC, 0x07, 0xBC, 0x07, 0x08, 0x03
                                }, 

                                Package (0x10)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x60, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00, 
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x61, 
                                    0xFF, 
                                    0xBC, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0xBC, 0x03, 0xBC, 0x03, 0x08, 0x03,
                                    /* 0008 */   0x47, 0x01, 0xBC, 0x07, 0xBC, 0x07, 0x08, 0x03
                                }, 

                                Package (0x10)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x60, 
                                    0xFF, 
                                    0x03, 
                                    0x00, 
                                    0x00, 
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x61, 
                                    0xFF, 
                                    0xBC, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }
                        })
                        Name (IF00, Package (0x02)
                        {
                            Buffer (0x03)
                            {
                                 0x2A, 0x0A, 0x00
                            }, 

                            Package (0x08)
                            {
                                0x01, 
                                0x06, 
                                0x06, 
                                0x74, 
                                0xFF, 
                                0x01, 
                                0x03, 
                                0x02
                            }
                        })
                        Name (ENBL, Package (0x10)
                        {
                            0x03, 
                            0x07, 
                            0x07, 
                            0x00, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00, 
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            CreateField (ALLC, 0x98, 0x18, RE01)
                            Name (BU01, Buffer (0x03)
                            {
                                 0x00
                            })
                            Store (RE01, BU01)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Store (SizeOf (IF00), Local0)
                            Store (One, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD (DerefOf (Index (IF00, Local1))), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                    Subtract (Local1, 0x01, Local1)
                                    Store (SizeOf (Index (IF00, Local1)), Local4)
                                    Multiply (0x08, Local4, Local4)
                                    FRTO (DerefOf (Index (IF00, Local1)), 0x00, BU01, 0x00, Local4)
                                    MORE (Local3, BU01, 0x00)
                                    Store (BU01, RE01)
                                    Add (Local1, 0x01, Local1)
                                }

                                Add (Local1, 0x02, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            CreateField (Arg0, 0x98, 0x18, RE01)
                            Name (BU01, Buffer (0x03)
                            {
                                 0x00
                            })
                            Store (RE01, BU01)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            Store (SizeOf (IF00), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEAR (DerefOf (Index (IF00, Local1)), BU01, 0x00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Add (Local1, 0x01, Local1)
                                    WR (DerefOf (Index (IF00, Local1)), Local3)
                                    Add (Local1, 0x01, Local1)
                                    If (LLessEqual (Local0, Local1))
                                    {
                                        Store (Zero, Local7)
                                    }
                                    Else
                                    {
                                    }
                                }
                                Else
                                {
                                    Add (Local1, 0x02, Local1)
                                    If (LLessEqual (Local0, Local1))
                                    {
                                        Store (Zero, Local7)
                                    }
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x0F)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x01)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x01)
                        }
                    }

                    Device (EPP)
                    {
                        Name (_HID, EisaId ("PNP0400"))  // _HID: Hardware ID
                        Name (_UID, 0x03)  // _UID: Unique ID
                        Name (MCD, 0x15)
                        Name (ALLC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        })
                        Method (B_PR, 0, NotSerialized)
                        {
                            Return (ResourceTemplate ()
                            {
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0178,             // Range Minimum
                                        0x0178,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0578,             // Range Minimum
                                        0x0578,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFnNoPri ()
                                {
                                    IO (Decode16,
                                        0x0178,             // Range Minimum
                                        0x0178,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0578,             // Range Minimum
                                        0x0578,             // Range Maximum
                                        0x08,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                            })
                        }

                        Name (IIO0, Package (0x08)
                        {
                            0x47, 
                            0x01, 
                            0x78, 
                            0x01, 
                            0x78, 
                            0x01, 
                            0x08, 
                            0x08
                        })
                        Name (IIO1, Package (0x08)
                        {
                            0x47, 
                            0x01, 
                            0x78, 
                            0x05, 
                            0x78, 
                            0x05, 
                            0x08, 
                            0x08
                        })
                        Name (IIO2, Package (0x08)
                        {
                            0x47, 
                            0x01, 
                            0x78, 
                            0x01, 
                            0x78, 
                            0x01, 
                            0x08, 
                            0x08
                        })
                        Name (IIO3, Package (0x08)
                        {
                            0x47, 
                            0x01, 
                            0x78, 
                            0x05, 
                            0x78, 
                            0x05, 
                            0x08, 
                            0x08
                        })
                        Name (DF0A, Package (0x06)
                        {
                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x03, 0x78, 0x03, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x07, 0x78, 0x07, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x4F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x02, 0x78, 0x02, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x06, 0x78, 0x06, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x01, 
                                    0x01, 
                                    0x01, 
                                    0xFF, 
                                    0x2F, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x01, 0x78, 0x01, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x05, 0x78, 0x05, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x08, 
                                    0x08, 
                                    0x03, 
                                    0xFF, 
                                    0x01, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                     0x22, 0x80, 0x00
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x07, 
                                    0x00, 
                                    0x00
                                }
                            }, 

                            Package (0x04)
                            {
                                Buffer (0x10)
                                {
                                    /* 0000 */   0x47, 0x01, 0x78, 0x01, 0x78, 0x01, 0x08, 0x08,
                                    /* 0008 */   0x47, 0x01, 0x78, 0x05, 0x78, 0x05, 0x08, 0x08
                                }, 

                                Package (0x08)
                                {
                                    0x03, 
                                    0x08, 
                                    0x08, 
                                    0x03, 
                                    0xFF, 
                                    0x01, 
                                    0x00, 
                                    0x00
                                }, 

                                Buffer (0x03)
                                {
                                    "\" "
                                }, 

                                Package (0x08)
                                {
                                    0x01, 
                                    0x06, 
                                    0x06, 
                                    0x70, 
                                    0xFF, 
                                    0x05, 
                                    0x00, 
                                    0x00
                                }
                            }
                        })
                        Name (ENBL, Package (0x10)
                        {
                            0x03, 
                            0x07, 
                            0x07, 
                            0x00, 
                            0xFF, 
                            0x80, 
                            0x00, 
                            0x00, 
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x01, 
                            0x00, 
                            0x00
                        })
                        Name (DISB, Package (0x08)
                        {
                            0x01, 
                            0x06, 
                            0x06, 
                            0x30, 
                            0xFF, 
                            0x00, 
                            0x00, 
                            0x00
                        })
                        Method (B_DI, 0, NotSerialized)
                        {
                            WR (DISB, 0x00)
                            Store (0x0D, _STA)
                        }

                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateField (ALLC, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Zero, Local2)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (RD1 (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (BU00, RE00)
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    If (Local7)
                                    {
                                        Store (Zero, Local7)
                                        Store (0xFF, Local3)
                                    }
                                }
                            }

                            Return (ALLC)
                        }

                        Method (B_SR, 1, NotSerialized)
                        {
                            DEC (ALLC, Arg0)
                            CreateField (Arg0, 0x00, 0x98, RE00)
                            Name (BU00, Buffer (0x13)
                            {
                                 0x00
                            })
                            Store (RE00, BU00)
                            Store (SizeOf (DF0A), Local0)
                            Store (Zero, Local1)
                            Store (Ones, Local7)
                            Store (Zero, Local3)
                            While (Local7)
                            {
                                Store (SEA (DerefOf (Index (DF0A, Local1)), BU00), Local3)
                                If (LNotEqual (Local3, 0xFF))
                                {
                                    Store (Zero, Local7)
                                }

                                Add (Local1, 0x01, Local1)
                                If (LLessEqual (Local0, Local1))
                                {
                                    Store (Zero, Local7)
                                }
                            }

                            WR (ENBL, 0x00)
                            Store (0x0F, _STA)
                        }

                        Name (_STA, 0x00)  // _STA: Status
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            PWON (0x01)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            PWOF (0x01)
                        }
                    }

                    Method (SLTL, 1, NotSerialized)
                    {
                        WR00 (0x07, Arg0)
                    }

                    Method (PWON, 1, NotSerialized)
                    {
                        Acquire (N366, 0xFFFF)
                        SLTL (Arg0)
                        Store (0xF0, INDX)
                        Store (DATA, Local0)
                        Or (Local0, 0x02, Local0)
                        Store (Local0, DATA)
                        Release (N366)
                    }

                    Method (PWOF, 1, NotSerialized)
                    {
                        Acquire (N366, 0xFFFF)
                        SLTL (Arg0)
                        Store (0xF0, INDX)
                        Store (DATA, Local0)
                        And (Local0, Not (0x02), Local0)
                        Store (Local0, DATA)
                        Release (N366)
                    }

                    Method (SLBA, 2, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03F8))
                        {
                            Store (Arg1, R3FB)
                        }

                        If (LEqual (Arg0, 0x03E8))
                        {
                            Store (Arg1, R3EB)
                        }

                        If (LEqual (Arg0, 0x02F8))
                        {
                            Store (Arg1, R2FB)
                        }

                        If (LEqual (Arg0, 0x02E8))
                        {
                            Store (Arg1, R2EB)
                        }

                        Return (0x00)
                    }

                    Method (STUM, 2, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03F8))
                        {
                            Store (Arg1, R3FA)
                        }

                        If (LEqual (Arg0, 0x03E8))
                        {
                            Store (Arg1, R3EA)
                        }

                        If (LEqual (Arg0, 0x02F8))
                        {
                            Store (Arg1, R2FA)
                        }

                        If (LEqual (Arg0, 0x02E8))
                        {
                            Store (Arg1, R2EA)
                        }

                        Return (0x00)
                    }

                    Method (STEM, 2, NotSerialized)
                    {
                        If (LEqual (0x03F8, Arg0))
                        {
                            Store (Arg1, R3FC)
                        }

                        If (LEqual (0x03E8, Arg0))
                        {
                            Store (Arg1, R3EC)
                        }

                        If (LEqual (0x02F8, Arg0))
                        {
                            Store (Arg1, R2FC)
                        }

                        If (LEqual (0x02E8, Arg0))
                        {
                            Store (Arg1, R2EC)
                        }

                        Return (0x00)
                    }

                    Method (WREN, 2, NotSerialized)
                    {
                    }

                    Method (WRSL, 2, NotSerialized)
                    {
                        Add (RDGA (0x01), 0x0402, Local2)
                        And (Local2, Not (0xE0), Local3)
                        Or (Local3, 0x00, Local0)
                        WR00 (Local2, Local0)
                        Add (RDGA (0x01), 0x02, Local1)
                        WR00 (Local1, Or (And (Local1, 0xC4, Local0), 0x04, Local0))
                        Or (Arg0, Local3, Local3)
                        WR00 (Local2, Local3)
                    }

                    Method (WRFD, 2, NotSerialized)
                    {
                        SLTL (0x00)
                        WR00 (Arg0, Arg1)
                    }

                    Method (WRCB, 2, NotSerialized)
                    {
                        SLTL (0x02)
                        WR00 (Arg0, Arg1)
                    }

                    Method (WRCA, 2, NotSerialized)
                    {
                        SLTL (0x03)
                        WR00 (Arg0, Arg1)
                    }

                    Method (WRLP, 2, NotSerialized)
                    {
                        SLTL (0x01)
                        WR00 (Arg0, Arg1)
                    }

                    Method (WRAD, 2, NotSerialized)
                    {
                        ShiftLeft (Arg1, 0x03, Local0)
                        Add (Local0, 0x0100, Local0)
                        WRGA (Arg0, Local0)
                    }

                    Method (WRGA, 2, NotSerialized)
                    {
                        SLTL (Arg0)
                        And (Arg1, 0xFF, Local1)
                        WR00 (0x61, Local1)
                        ShiftRight (Arg1, 0x08, Local1)
                        WR00 (0x60, Local1)
                    }

                    Method (WR00, 2, NotSerialized)
                    {
                        Store (Arg0, INDX)
                        Store (Arg1, DATA)
                    }

                    Method (WRIT, 3, NotSerialized)
                    {
                        Acquire (N366, 0xFFFF)
                        If (LEqual (Arg0, 0x01))
                        {
                            WRAD (Arg1, Arg2)
                        }

                        If (LEqual (Arg0, 0x00))
                        {
                            WRCA (Arg1, Arg2)
                        }

                        If (LEqual (Arg0, 0x03))
                        {
                            WRCB (Arg1, Arg2)
                        }

                        If (LEqual (Arg0, 0x04))
                        {
                            WREN (Arg1, Arg2)
                        }

                        If (LEqual (Arg0, 0x05))
                        {
                            WRFD (Arg1, Arg2)
                        }

                        If (LEqual (Arg0, 0x06))
                        {
                            WRLP (Arg1, Arg2)
                        }

                        If (LEqual (Arg0, 0x07))
                        {
                            WRSL (Arg1, Arg2)
                        }

                        Release (N366)
                    }

                    Method (RDGL, 1, NotSerialized)
                    {
                        Add (RDGA (0x01), 0x0402, Local0)
                        And (Local0, 0xE0, Local0)
                        Return (Local0)
                    }

                    Method (RDLP, 1, NotSerialized)
                    {
                        SLTL (0x01)
                        Store (RD00 (Arg0), Local0)
                        Return (Local0)
                    }

                    Method (RDFD, 1, NotSerialized)
                    {
                        SLTL (0x00)
                        Store (RD00 (Arg0), Local0)
                        Return (Local0)
                    }

                    Method (RDEN, 1, NotSerialized)
                    {
                        Return (0x00)
                    }

                    Method (RDCB, 1, NotSerialized)
                    {
                        SLTL (0x02)
                        Store (RD00 (Arg0), Local0)
                        Return (Local0)
                    }

                    Method (RDAD, 1, NotSerialized)
                    {
                        Subtract (RDGA (Arg0), 0x0100, Local1)
                        ShiftRight (Local1, 0x03, Local1)
                        Return (Local1)
                    }

                    Method (RDCA, 1, NotSerialized)
                    {
                        SLTL (0x03)
                        Store (RD00 (Arg0), Local0)
                        Return (Local0)
                    }

                    Method (RD00, 1, NotSerialized)
                    {
                        Store (Arg0, INDX)
                        Store (DATA, Local0)
                        Return (Local0)
                    }

                    Method (RDGA, 1, NotSerialized)
                    {
                        SLTL (Arg0)
                        Store (RD00 (0x61), Local0)
                        Store (RD00 (0x60), Local1)
                        ShiftLeft (Local1, 0x08, Local2)
                        Or (Local2, Local0, Local1)
                        Return (Local1)
                    }

                    Method (READ, 3, NotSerialized)
                    {
                        Acquire (N366, 0xFFFF)
                        If (LEqual (Arg0, 0x00))
                        {
                            Store (RDCA (Arg1), Local1)
                        }

                        If (LEqual (Arg0, 0x01))
                        {
                            Store (RDAD (Arg1), Local1)
                        }

                        If (LEqual (Arg0, 0x03))
                        {
                            Store (RDCB (Arg1), Local1)
                        }

                        If (LEqual (Arg0, 0x04))
                        {
                            Store (RDEN (Arg1), Local1)
                        }

                        If (LEqual (Arg0, 0x05))
                        {
                            Store (RDFD (Arg1), Local1)
                        }

                        If (LEqual (Arg0, 0x06))
                        {
                            Store (RDLP (Arg1), Local1)
                        }

                        If (LEqual (Arg0, 0x07))
                        {
                            Store (RDGL (Arg1), Local1)
                        }

                        And (Local1, Arg2, Local1)
                        Release (N366)
                        Return (Local1)
                    }

                    OperationRegion (I2E8, SystemIO, 0x02E8, 0x08)
                    Field (I2E8, ByteAcc, NoLock, Preserve)
                    {
                        R2E8,   8, 
                        R2E9,   8, 
                        R2EA,   8, 
                        R2EB,   8, 
                        R2EC,   8
                    }

                    OperationRegion (I2F8, SystemIO, 0x02F8, 0x08)
                    Field (I2F8, ByteAcc, NoLock, Preserve)
                    {
                        R2F8,   8, 
                        R2F9,   8, 
                        R2FA,   8, 
                        R2FB,   8, 
                        R2FC,   8
                    }

                    OperationRegion (I3E8, SystemIO, 0x03E8, 0x08)
                    Field (I3E8, ByteAcc, NoLock, Preserve)
                    {
                        R3E8,   8, 
                        R3E9,   8, 
                        R3EA,   8, 
                        R3EB,   8, 
                        R3EC,   8
                    }

                    OperationRegion (I3F8, SystemIO, 0x03F8, 0x08)
                    Field (I3F8, ByteAcc, NoLock, Preserve)
                    {
                        R3F8,   8, 
                        R3F9,   8, 
                        R3FA,   8, 
                        R3FB,   8, 
                        R3FC,   8
                    }

                    OperationRegion (SIIO, SystemIO, 0x4E, 0x02)
                    Field (SIIO, ByteAcc, NoLock, Preserve)
                    {
                        INDX,   8, 
                        DATA,   8
                    }

                    OperationRegion (SWC, SystemIO, 0x0100, 0x20)
                    Field (SWC, ByteAcc, NoLock, Preserve)
                    {
                        WKS0,   8, 
                        WKS1,   8, 
                        WKE0,   8, 
                        WKE1,   8, 
                        WKCF,   8, 
                        Offset (0x13), 
                        PS2C,   8, 
                        Offset (0x18), 
                        PSK0,   8, 
                        PSK1,   8
                    }
                }

                Device (KBC0)
                {
                    Name (_HID, EisaId ("PNP0303"))  // _HID: Hardware ID
                    Name (KBST, 0xFF)
                    Name (KBCF, 0xFF)
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {1}
                    })
                    Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                    {
                        0x1D, 
                        0x04
                    })
                    OperationRegion (KBIO, SystemIO, 0x60, 0x01)
                    Field (KBIO, ByteAcc, NoLock, Preserve)
                    {
                        KDAT,   8
                    }
                }

                Device (MOUS)
                {
                    Name (_HID, EisaId ("PNP0F13"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {12}
                    })
                    Name (MSST, 0xFF)
                }
            }

            Device (IDE)
            {
                Name (_ADR, 0x001F0001)  // _ADR: Address
                OperationRegion (PC2, PCI_Config, 0x20, 0x04)
                Field (PC2, DWordAcc, Lock, Preserve)
                {
                    R20,    32
                }

                OperationRegion (PC3, PCI_Config, 0x04, 0x04)
                Field (PC3, DWordAcc, Lock, Preserve)
                {
                    R04,    32
                }

                OperationRegion (REGS, PCI_Config, 0x44, 0x08)
                Field (REGS, DWordAcc, Lock, Preserve)
                {
                    SIT0,   4, 
                    SIT1,   4, 
                    Offset (0x04), 
                    UDC0,   2, 
                    UDC1,   2, 
                    Offset (0x06), 
                    UDT0,   8, 
                    UDT1,   8
                }

                Name (GMBU, Buffer (0x14)
                {
                     0x00
                })
                Method (GTM, 4, NotSerialized)
                {
                    Store (Buffer (0x14) {}, Local0)
                    CreateDWordField (Local0, 0x00, PIO0)
                    CreateDWordField (Local0, 0x04, DMA0)
                    CreateDWordField (Local0, 0x08, PIO1)
                    CreateDWordField (Local0, 0x0C, DMA1)
                    CreateDWordField (Local0, 0x10, FLAG)
                    If (LOr (And (Arg0, 0x08), LNot (And (Arg0, 0x01
                        ))))
                    {
                        Store (0x0384, PIO0)
                    }
                    Else
                    {
                        Subtract (0x09, ShiftRight (And (Arg0, 0x0300), 0x08), Local1)
                        Subtract (Local1, ShiftRight (And (Arg0, 0x3000), 0x0C), Local1)
                        Multiply (Local1, 0x1E, PIO0)
                    }

                    If (And (Arg2, 0x01))
                    {
                        Subtract (0x04, And (Arg3, 0x03), Local1)
                        Multiply (Local1, 0x1E, DMA0)
                    }
                    Else
                    {
                        Subtract (0x09, ShiftRight (And (Arg0, 0x0300), 0x08), Local1)
                        Subtract (Local1, ShiftRight (And (Arg0, 0x3000), 0x0C), Local1)
                        Multiply (Local1, 0x1E, DMA0)
                    }

                    If (And (Arg0, 0x4000))
                    {
                        If (LOr (And (Arg0, 0x80), LNot (And (Arg0, 0x10
                            ))))
                        {
                            Store (0x0384, PIO1)
                        }
                        Else
                        {
                            Subtract (0x09, And (Arg1, 0x03), Local1)
                            Subtract (Local1, ShiftRight (And (Arg1, 0x0C), 0x02), Local1)
                            Multiply (Local1, 0x1E, PIO1)
                        }
                    }
                    Else
                    {
                        Store (PIO0, PIO1)
                    }

                    If (And (Arg0, 0x4000))
                    {
                        If (And (Arg2, 0x02))
                        {
                            Subtract (0x04, ShiftRight (And (Arg3, 0x30), 0x04), Local1)
                            Multiply (Local1, 0x1E, DMA1)
                        }
                        Else
                        {
                            Subtract (0x09, And (Arg1, 0x03), Local1)
                            Subtract (Local1, ShiftRight (And (Arg1, 0x0C), 0x02), Local1)
                            Multiply (Local1, 0x1E, DMA1)
                        }
                    }
                    Else
                    {
                        Store (DMA0, DMA1)
                    }

                    Store (0x10, FLAG)
                    If (And (Arg2, 0x01))
                    {
                        Or (FLAG, 0x01, FLAG)
                    }

                    If (And (Arg0, 0x02))
                    {
                        Or (FLAG, 0x02, FLAG)
                    }

                    If (And (Arg2, 0x02))
                    {
                        Or (FLAG, 0x04, FLAG)
                    }

                    If (And (Arg0, 0x20))
                    {
                        Or (FLAG, 0x08, FLAG)
                    }

                    Return (Local0)
                }

                Method (STMS, 1, NotSerialized)
                {
                    CreateDWordField (Arg0, 0x00, PIO0)
                    CreateDWordField (Arg0, 0x04, DMA0)
                    CreateDWordField (Arg0, 0x08, PIO1)
                    CreateDWordField (Arg0, 0x0C, DMA1)
                    CreateDWordField (Arg0, 0x10, FLAG)
                    Store (Buffer (0x10) {}, Local7)
                    CreateDWordField (Local7, 0x00, ITM)
                    CreateDWordField (Local7, 0x04, SIT)
                    CreateDWordField (Local7, 0x08, UDC)
                    CreateDWordField (Local7, 0x0C, UDT)
                    Store (Or (Or (0x4000, 0x04), 0x40), Local0)
                    If (And (FLAG, 0x02))
                    {
                        Or (Local0, 0x02, Local0)
                    }

                    If (And (FLAG, 0x08))
                    {
                        Or (Local0, 0x20, Local0)
                    }

                    If (LLess (DMA0, PIO0))
                    {
                        Or (Local0, 0x08, Local0)
                    }

                    If (LLess (DMA1, PIO1))
                    {
                        Or (Local0, 0x80, Local0)
                    }

                    If (LLess (PIO0, 0x0384))
                    {
                        Or (Local0, 0x01, Local0)
                    }

                    If (LLess (PIO1, 0x0384))
                    {
                        Or (Local0, 0x10, Local0)
                    }

                    If (And (FLAG, 0x01))
                    {
                        Store (PIO0, Local1)
                    }
                    Else
                    {
                        Store (DMA0, Local1)
                    }

                    If (LLessEqual (Local1, 0x78))
                    {
                        Or (Local0, 0x2300, Local0)
                    }
                    Else
                    {
                        If (LLessEqual (Local1, 0xB4))
                        {
                            Or (Local0, 0x2100, Local0)
                        }
                        Else
                        {
                            If (LLessEqual (Local1, 0xF0))
                            {
                                Or (Local0, 0x1000, Local0)
                            }
                        }
                    }

                    Store (Local0, ITM)
                    Store (Zero, Local0)
                    If (And (FLAG, 0x04))
                    {
                        Store (PIO1, Local1)
                    }
                    Else
                    {
                        Store (DMA1, Local1)
                    }

                    If (LLessEqual (Local1, 0x78))
                    {
                        Store (0x0B, Local0)
                    }
                    Else
                    {
                        If (LLessEqual (Local1, 0xB4))
                        {
                            Store (0x09, Local0)
                        }
                        Else
                        {
                            If (LLessEqual (Local1, 0xF0))
                            {
                                Store (0x04, Local0)
                            }
                        }
                    }

                    Store (Local0, SIT)
                    Store (0x00, Local0)
                    If (And (FLAG, 0x01))
                    {
                        Or (Local0, 0x01, Local0)
                    }

                    If (And (FLAG, 0x04))
                    {
                        Or (Local0, 0x02, Local0)
                    }

                    Store (Local0, UDC)
                    Store (0x00, Local0)
                    If (And (FLAG, 0x01))
                    {
                        Divide (DMA0, 0x1E, Local1)
                        And (Local1, 0x03, Local1)
                        Subtract (0x04, Local1, Local0)
                    }

                    If (And (FLAG, 0x04))
                    {
                        Divide (DMA0, 0x1E, Local1)
                        And (Local1, 0x03, Local1)
                        Subtract (0x04, Local1, Local1)
                        ShiftLeft (Local1, 0x04, Local1)
                        Or (Local0, Local1, Local0)
                    }

                    Store (Local0, UDT)
                    Return (Local7)
                }

                Method (GTF0, 4, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        }, Local6)
                    Store (Buffer (0x07)
                        {
                             0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                        }, Local7)
                    CreateByteField (Local7, 0x01, MODE)
                    If (And (Arg2, 0x01))
                    {
                        And (Arg3, 0x03, Local0)
                        Or (Local0, 0x40, MODE)
                    }
                    Else
                    {
                        Add (ShiftRight (And (Arg0, 0x0300), 0x08), ShiftRight (And (
                            Arg0, 0x3000), 0x0C), Local0)
                        If (LGreaterEqual (Local0, 0x05))
                        {
                            Store (0x22, MODE)
                        }
                        Else
                        {
                            If (LGreaterEqual (Local0, 0x03))
                            {
                                Store (0x21, MODE)
                            }
                            Else
                            {
                                Store (0x20, MODE)
                            }
                        }
                    }

                    Store (Local7, Local6)
                    Store (Zero, MODE)
                    If (LOr (And (Arg0, 0x08), LNot (And (Arg0, 0x01
                        ))))
                    {
                        If (And (Arg0, 0x02))
                        {
                            Store (0x00, MODE)
                        }
                        Else
                        {
                            Store (0x01, MODE)
                        }
                    }
                    Else
                    {
                        Add (ShiftRight (And (Arg0, 0x0300), 0x08), ShiftRight (And (
                            Arg0, 0x3000), 0x0C), Local0)
                        If (LGreaterEqual (Local0, 0x05))
                        {
                            Store (0x0C, MODE)
                        }
                        Else
                        {
                            If (LGreaterEqual (Local0, 0x03))
                            {
                                Store (0x0B, MODE)
                            }
                            Else
                            {
                                Store (0x0A, MODE)
                            }
                        }
                    }

                    Concatenate (Local6, Local7, Local5)
                    Return (Local5)
                }

                Method (GTF1, 4, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        }, Local6)
                    Store (Buffer (0x07)
                        {
                             0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                        }, Local7)
                    CreateByteField (Local7, 0x01, MODE)
                    If (And (Arg2, 0x02))
                    {
                        And (Arg3, 0x30, Local0)
                        ShiftRight (Local0, 0x04, Local0)
                        Or (Local0, 0x40, MODE)
                    }
                    Else
                    {
                        If (And (Local0, 0x4000))
                        {
                            Add (And (Arg1, 0x03), ShiftRight (And (Arg1, 0x0C), 
                                0x02), Local0)
                        }
                        Else
                        {
                            Add (ShiftRight (And (Arg0, 0x0300), 0x08), ShiftRight (And (
                                Arg0, 0x3000), 0x0C), Local0)
                        }

                        If (LGreaterEqual (Local0, 0x05))
                        {
                            Store (0x22, MODE)
                        }
                        Else
                        {
                            If (LGreaterEqual (Local0, 0x03))
                            {
                                Store (0x21, MODE)
                            }
                            Else
                            {
                                Store (0x20, MODE)
                            }
                        }
                    }

                    Store (Local7, Local6)
                    Store (Zero, MODE)
                    If (LOr (And (Arg0, 0x80), LNot (And (Arg0, 0x10
                        ))))
                    {
                        If (And (Arg0, 0x20))
                        {
                            Store (0x00, MODE)
                        }
                        Else
                        {
                            Store (0x01, MODE)
                        }
                    }
                    Else
                    {
                        If (And (Local0, 0x4000))
                        {
                            Add (And (Arg1, 0x03), ShiftRight (And (Arg1, 0x0C), 
                                0x02), Local0)
                        }
                        Else
                        {
                            Add (ShiftRight (And (Arg0, 0x0300), 0x08), ShiftRight (And (
                                Arg0, 0x3000), 0x0C), Local0)
                        }

                        If (LGreaterEqual (Local0, 0x05))
                        {
                            Store (0x0C, MODE)
                        }
                        Else
                        {
                            If (LGreaterEqual (Local0, 0x03))
                            {
                                Store (0x0B, MODE)
                            }
                            Else
                            {
                                Store (0x0A, MODE)
                            }
                        }
                    }

                    Concatenate (Local6, Local7, Local5)
                    Return (Local5)
                }

                Name (B04, Buffer (0x04) {})
                Name (B20, Buffer (0x04) {})
                Name (B40, Buffer (0x04) {})
                Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                {
                    Store ("IDE_PS3", Debug)
                    If (LEqual (_PSC, 0x04))
                    {
                        Store (B04, R04)
                        Store (B20, R20)
                        Store (B40, R40)
                    }

                    Store (0x03, _PSC)
                }

                Name (_PSC, 0x00)  // _PSC: Power State Current
                OperationRegion (PCI, PCI_Config, 0x40, 0x04)
                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                    Offset (0x03), 
                        ,   7, 
                    SIDE,   1
                }

                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                    R40,    32
                }

                Field (PCI, DWordAcc, NoLock, Preserve)
                {
                    ITM0,   16, 
                    ITM1,   16
                }

                Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                {
                    Store ("IDE_PS0", Debug)
                    If (LEqual (_PSC, 0x03)) {}
                    Store (0x00, _PSC)
                    Store (R40, B40)
                }
            }

            Device (USB)
            {
                Name (_ADR, 0x001F0002)  // _ADR: Address
                OperationRegion (USBO, PCI_Config, 0xC4, 0x01)
                Field (USBO, ByteAcc, Lock, Preserve)
                {
                    AccessAs (DWordAcc, 0x00), 
                    RSEN,   2
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x03, 
                    0x01
                })
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, RSEN)
                    }
                    Else
                    {
                        Store (0x00, RSEN)
                    }
                }
            }

            Device (SMBS)
            {
                Name (_ADR, 0x001F0003)  // _ADR: Address
            }

            Device (AC97)
            {
                Name (_ADR, 0x001F0005)  // _ADR: Address
            }

            Device (PWRB)
            {
                Name (_HID, EisaId ("PNP0C0C"))  // _HID: Hardware ID
                Name (_STA, 0x0B)  // _STA: Status
            }
        }
    }

    Scope (_GPE)
    {
        Method (_L03, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB, 0x02)
        }

        Method (_L08, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.LPC0.SIO.COMA, 0x02)
            Notify (\_SB.PCI0.LPC0.SIO.COMB, 0x02)
        }

        Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.SLOT, 0x02)
            Notify (\_SB.PCI0.PWRB, 0x02)
        }

        Method (_L18, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.HLB.P64H, 0x02)
        }

        Method (_L1D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Store (0x00, \_SB.PCI0.LPC0.SIO.WKE0)
            Notify (\_SB.PCI0.PWRB, 0x02)
            Notify (\_SB.PCI0.LPC0.KBC0, 0x02)
        }
    }

    Scope (_SI)
    {
        Method (_SST, 1, NotSerialized)  // _SST: System Status
        {
            Or (Arg0, 0xD8, \_SB.PCI0.LPC0.PT80)
            If (LEqual (Arg0, 0x01))
            {
                If (LNotEqual (\_SB.PCI0.LPC0.MOUS.MSST, 0xFF))
                {
                    Store (0x07, \_SB.PCI0.LPC0.SIO.INDX)
                    Store (0x05, \_SB.PCI0.LPC0.SIO.DATA)
                    Store (0x30, \_SB.PCI0.LPC0.SIO.INDX)
                    Store (\_SB.PCI0.LPC0.MOUS.MSST, \_SB.PCI0.LPC0.SIO.DATA)
                    Store (0x07, \_SB.PCI0.LPC0.SIO.INDX)
                    Store (0x06, \_SB.PCI0.LPC0.SIO.DATA)
                    Store (0x30, \_SB.PCI0.LPC0.SIO.INDX)
                    Store (\_SB.PCI0.LPC0.KBC0.KBST, \_SB.PCI0.LPC0.SIO.DATA)
                    Store (0xF0, \_SB.PCI0.LPC0.SIO.INDX)
                    Store (\_SB.PCI0.LPC0.KBC0.KBCF, \_SB.PCI0.LPC0.SIO.DATA)
                }

                Store (0x00, \_SB.PCI0.LPC0.SIO.WKE0)
            }

            If (LGreaterEqual (Arg0, 0x03))
            {
                Store (0x07, \_SB.PCI0.LPC0.SIO.INDX)
                Store (0x05, \_SB.PCI0.LPC0.SIO.DATA)
                Store (0x30, \_SB.PCI0.LPC0.SIO.INDX)
                Store (\_SB.PCI0.LPC0.SIO.DATA, \_SB.PCI0.LPC0.MOUS.MSST)
                Store (0x00, \_SB.PCI0.LPC0.SIO.DATA)
                Store (0x07, \_SB.PCI0.LPC0.SIO.INDX)
                Store (0x06, \_SB.PCI0.LPC0.SIO.DATA)
                Store (0x30, \_SB.PCI0.LPC0.SIO.INDX)
                Store (\_SB.PCI0.LPC0.SIO.DATA, \_SB.PCI0.LPC0.KBC0.KBST)
                Store (0x00, \_SB.PCI0.LPC0.SIO.DATA)
                Store (0xF0, \_SB.PCI0.LPC0.SIO.INDX)
                Store (\_SB.PCI0.LPC0.SIO.DATA, \_SB.PCI0.LPC0.KBC0.KBCF)
                Store (0x01, \_SB.PCI0.LPC0.SIO.DATA)
                And (\_SB.PCI0.LPC0.SIO.WKCF, 0xFC, \_SB.PCI0.LPC0.SIO.WKCF)
                Store (0x00, \_SB.PCI0.LPC0.SIO.PSK0)
                Store (0x00, \_SB.PCI0.LPC0.SIO.PSK1)
                Store (0x00, \_SB.PCI0.LPC0.SIO.PS2C)
                Store (0x01, \_SB.PCI0.LPC0.SIO.PS2C)
                Store (0x04, \_SB.PCI0.LPC0.SIO.WKS0)
                Store (0x04, \_SB.PCI0.LPC0.SIO.WKE0)
            }

            Or (Arg0, 0xD0, \_SB.PCI0.LPC0.PT80)
        }
    }

    Scope (_TZ)
    {
    }

    Name (_S0, Package (0x02)  // _S0_: S0 System State
    {
        0x00, 
        0x00
    })
    Name (_S1, Package (0x02)  // _S1_: S1 System State
    {
        0x01, 
        0x01
    })
    Name (_S4, Package (0x02)  // _S4_: S4 System State
    {
        0x06, 
        0x06
    })
    Name (_S5, Package (0x02)  // _S5_: S5 System State
    {
        0x07, 
        0x07
    })
    Name (PICF, 0x00)
    Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
    {
        Store (Arg0, \PICF)
    }

    Method (_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        Notify (\_SB.PCI0.PWRB, 0x02)
    }
}

