/* Test case for mismatched operand length problem
 *
 * The problem is that warnings are generated when they should not be.
 *
 * In all cases, correct code is generated.
 *
 * In all cases, the "Warning W124" appears to be an invalid warning.
 */
typedef unsigned short UINT16;
typedef unsigned long UINT32;
typedef unsigned long long UINT64;

UINT64 Global64;
UINT32 Global32;

#define UINT16_MAX (UINT16)(~((UINT16) 0)) /* 0xFFFF */
#define UINT32_MAX (UINT32)(~((UINT32) 0)) /* 0xFFFFFFFF */

int Proc1(void)
{
    UINT64 Local64;
    UINT32 Local32;

    Local64 = Global64 * 16;
    Local32 = Global32 * 16;

    /* No warning, correct code */
    if (Global32 > UINT16_MAX)
    {
        return 1;
    }

    /* No warning, correct code */
    if (Local32 > UINT16_MAX)
    {
        return 2;
    }

    /* Generates a bogus warning, but generates correct code. */
    if (Global64 > UINT32_MAX)
    {
        return 3;
    }

    /* Generates a bogus warning, but generates correct code. */
    if (Local64 > UINT32_MAX)
    {
        return 4;
    }

    /* No warning, correct code */
    if (Local32 > Global64)
    {
        return 5;
    }

    return 0;
}

int Proc2(void)
{
    UINT64 Local64;
    UINT32 Local32;
    int rc = 0;

    Local64 = Global64 * 16;
    Local32 = Global32 * 16;

    /* No warning, correct code */
    if (Global32 > UINT16_MAX)
    {
        rc = 1;
    }

    /* No warning, correct code */
    if (Local32 > UINT16_MAX)
    {
        rc = 2;
    }

    /* Generates a bogus warning, but generates correct code. */
    if (Global64 > UINT32_MAX)
    {
        rc = 3;
    }

    /* Generates a bogus warning, but generates correct code. */
    if (Local64 > UINT32_MAX)
    {
        rc = 4;
    }

    return rc;
}

int Proc3(void)
{
    UINT64 Local64;

    Local64 = Global64 * 16;

    /* No warning, correct code */
    if (Global64 > (UINT64)UINT32_MAX)
    {
        return 3;
    }

    /* No warning, correct code */
    if (Local64 > (UINT64)UINT32_MAX)
    {
        return 4;
    }

    return 0;
}

int Proc4(void)
{
    UINT32 Local32;

    Local32 = Global32 * 16;

    /* No warning, correct code */
    if (UINT16_MAX > Global32)
    {
        return 1;
    }

    /* No warning, correct code */
    if (UINT16_MAX > Local32)
    {
        return 2;
    }

    /* No warning, correct code */
    if (Local32 > Global32)
    {
        return 3;
    }
    return 0;
}

