/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20121114-32 [Dec 15 2012]
 * Copyright (c) 2000 - 2012 Intel Corporation
 * 
 * Disassembly of (null), Fri Jan  4 13:33:26 2013
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00006A06 (27142)
 *     Revision         0x01 **** 32-bit table (V1), no 64-bit math support
 *     Checksum         0x38
 *     OEM ID           "NVIDIA"
 *     OEM Table ID     "AWRDACPI"
 *     OEM Revision     0x00001000 (4096)
 *     Compiler ID      "MSFT"
 *     Compiler Version 0x0100000E (16777230)
 */

DefinitionBlock ("DSDT.aml", "DSDT", 1, "NVIDIA", "AWRDACPI", 0x00001000)
{
    Scope (\_PR)
    {
        Processor (\_PR.CPU0, 0x00, 0x00000000, 0x00) {}
        Processor (\_PR.CPU1, 0x01, 0x00000000, 0x00) {}
    }

    Name (\_S0, Package (0x04)  // _S0_: S0 System State
    {
        0x00, 
        0x00, 
        0x00, 
        0x00
    })
    Name (\_S1, Package (0x04)  // _S1_: S1 System State
    {
        0x01, 
        0x00, 
        0x00, 
        0x00
    })
    Name (\_S3, Package (0x04)  // _S3_: S3 System State
    {
        0x05, 
        0x00, 
        0x00, 
        0x00
    })
    Name (\_S4, Package (0x04)  // _S4_: S4 System State
    {
        0x06, 
        0x00, 
        0x00, 
        0x00
    })
    Name (\_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x07, 
        0x00, 
        0x00, 
        0x00
    })
    OperationRegion (\DEBG, SystemIO, 0x1080, 0x01)
    Field (\DEBG, ByteAcc, NoLock, Preserve)
    {
        DBG1,   8
    }

    OperationRegion (KBC, SystemIO, 0x64, 0x01)
    Field (KBC, ByteAcc, NoLock, Preserve)
    {
        KCMD,   8
    }

    OperationRegion (KBCD, SystemIO, 0x60, 0x01)
    Field (KBCD, ByteAcc, NoLock, Preserve)
    {
        KDAT,   8
    }

    OperationRegion (EXTM, SystemMemory, 0x000FF830, 0x10)
    Field (EXTM, WordAcc, NoLock, Preserve)
    {
        ROM1,   16, 
        RMS1,   16, 
        ROM2,   16, 
        RMS2,   16, 
        ROM3,   16, 
        RMS3,   16, 
        AMEM,   32
    }

    OperationRegion (\PM1S, SystemIO, 0x4000, 0x02)
    Field (\PM1S, ByteAcc, NoLock, Preserve)
    {
        Offset (0x01), 
        PBTS,   1, 
            ,   1, 
        RTCS,   1, 
            ,   4, 
        WAKS,   1
    }

    OperationRegion (ELCR, SystemIO, 0x04D0, 0x02)
    Field (ELCR, ByteAcc, NoLock, Preserve)
    {
        ELC1,   8, 
        ELC2,   8
    }

    OperationRegion (\STUS, SystemIO, 0x4400, 0x04)
    Field (\STUS, ByteAcc, NoLock, Preserve)
    {
        G_ST,   32
    }

    OperationRegion (\GPS0, SystemIO, 0x4020, 0x04)
    Field (\GPS0, ByteAcc, NoLock, Preserve)
    {
        GS00,   8, 
        GS01,   8, 
        GS02,   8, 
        GS03,   8
    }

    OperationRegion (\P20S, SystemIO, 0x4020, 0x04)
    Field (\P20S, ByteAcc, NoLock, Preserve)
    {
        P_20,   32
    }

    OperationRegion (\SMIC, SystemIO, 0x442E, 0x01)
    Field (\SMIC, ByteAcc, NoLock, Preserve)
    {
        SCP,    8
    }

    OperationRegion (\SLIG, SystemIO, 0x48CC, 0x01)
    Field (\SLIG, ByteAcc, NoLock, Preserve)
    {
        SLG,    8
    }

    Method (NVSL, 0, NotSerialized)
    {
        Store (SLG, Local0)
        Return (Local0)
    }

    OperationRegion (\PCBC, SystemIO, 0x0800, 0x01)
    Field (\PCBC, ByteAcc, NoLock, Preserve)
    {
        PCB,    8
    }

    Method (PCBV, 0, NotSerialized)
    {
        Store (PCB, Local3)
        And (Local3, 0x02, Local3)
        ShiftRight (Local3, 0x01, Local3)
        Return (Local3)
    }

    OperationRegion (\GP1, SystemIO, 0x44C0, 0x3D)
    Field (\GP1, ByteAcc, NoLock, Preserve)
    {
        GP00,   8, 
        GP01,   8, 
        GP02,   8, 
        GP03,   8, 
        GP04,   8, 
        GP05,   8, 
        GP06,   8, 
        GP07,   8, 
        GP08,   8, 
        GP09,   8, 
        GP10,   8, 
        GP11,   8, 
        GP12,   8, 
        GP13,   8, 
        GP14,   8, 
        GP15,   8, 
        GP16,   8, 
        GP17,   8, 
        GP18,   8, 
        GP19,   8, 
        GP20,   8, 
        GP21,   8, 
        GP22,   8, 
        Offset (0x18), 
        GP24,   8, 
        GP25,   8, 
        GP26,   8, 
        GP27,   8, 
        GP28,   8, 
        GP29,   8, 
        GP30,   8, 
        GP31,   8, 
        GP32,   8, 
        GP33,   8, 
        GP34,   8, 
        GP35,   8, 
        GP36,   8, 
        GP37,   8, 
        GP38,   8, 
        GP39,   8, 
        GP40,   8, 
        GP41,   8, 
        GP42,   8, 
        GP43,   8, 
        GP44,   8, 
        GP45,   8, 
        GP46,   8, 
        GP47,   8, 
        GP48,   8, 
        GP49,   8, 
        GP50,   8, 
        GP51,   8, 
        GP52,   8, 
        GP53,   8, 
        GP54,   8, 
        GP55,   8, 
        GP56,   8, 
        GP57,   8, 
        GP58,   8, 
        GP59,   8, 
        GP60,   8
    }

    Name (OSFX, 0x01)
    Name (OSFL, 0x01)
    Method (STRC, 2, NotSerialized)
    {
        If (LNotEqual (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (0x00)
        }

        Add (SizeOf (Arg0), 0x01, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    OperationRegion (RTCM, SystemIO, 0x70, 0x02)
    Field (RTCM, ByteAcc, NoLock, Preserve)
    {
        CMIN,   8, 
        CMDA,   8
    }

    IndexField (CMIN, CMDA, ByteAcc, NoLock, Preserve)
    {
        Offset (0x0F), 
        SHUT,   8
    }

    OperationRegion (INFO, SystemMemory, 0x000FF840, 0x01)
    Field (INFO, ByteAcc, NoLock, Preserve)
    {
        KBDI,   1, 
        RTCW,   1, 
        PS2F,   1, 
        IRFL,   2, 
        DISE,   1, 
        SSHU,   1
    }

    OperationRegion (BEEP, SystemIO, 0x61, 0x01)
    Field (BEEP, ByteAcc, NoLock, Preserve)
    {
        S1B,    8
    }

    OperationRegion (CONT, SystemIO, 0x40, 0x04)
    Field (CONT, ByteAcc, NoLock, Preserve)
    {
        CNT0,   8, 
        CNT1,   8, 
        CNT2,   8, 
        CTRL,   8
    }

    Method (SPKR, 1, NotSerialized)
    {
        Store (S1B, Local0)
        Store (0xB6, CTRL)
        Store (0x55, CNT2)
        Store (0x03, CNT2)
        Store (Arg0, Local2)
        While (LGreater (Local2, 0x00))
        {
            Or (S1B, 0x03, S1B)
            Store (0x5FFF, Local3)
            While (LGreater (Local3, 0x00))
            {
                Decrement (Local3)
            }

            And (S1B, 0xFC, S1B)
            Store (0x0EFF, Local3)
            While (LGreater (Local3, 0x00))
            {
                Decrement (Local3)
            }

            Decrement (Local2)
        }

        Store (Local0, S1B)
    }

    Scope (\)
    {
        Name (PICF, 0x00)
        Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
        {
            Store (Arg0, PICF)
        }
    }

    Name (SID4, 0x00)
    Name (SLG0, 0x00)
    Name (SLG1, 0x00)
    Name (SLG2, 0x00)
    Name (SLG3, 0x00)
    Name (SLG4, 0x00)
    Name (SLG5, 0x00)
    Name (SLG6, 0x00)
    Name (SLG7, 0x00)
    Name (SLG8, 0x00)
    Name (SLG9, 0x00)
    Name (SLGA, 0x00)
    Name (SID5, 0x00)
    Name (SSM0, 0x00)
    Name (SSM1, 0x00)
    Name (SSM2, 0x00)
    Name (SSM3, 0x00)
    Name (SSM4, 0x00)
    Name (SUA0, 0x00)
    Name (SUB0, 0x00)
    Name (SX, 0x00)
    Name (SFLG, 0x00)
    Name (SID0, 0x00)
    Name (SID1, 0x00)
    Name (SID2, 0x00)
    Name (SID3, 0x00)
    Method (\_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
        Store (Arg0, Local0)
        Store (Local0, SX)
        Or (Arg0, 0xF0, Local0)
        Store (Local0, DBG1)
        OSTP ()
        Store (\_SB.PCI0.IDE0.ID20, SID0)
        Store (\_SB.PCI0.IDE0.IDTS, SID1)
        Store (\_SB.PCI0.IDE0.IDTP, SID2)
        Store (\_SB.PCI0.IDE0.ID22, SID3)
        Store (\_SB.PCI0.IDE0.UMSS, SID4)
        Store (\_SB.PCI0.IDE0.UMSP, SID5)
        If (LEqual (Arg0, 0x01)) {}
        If (LEqual (Arg0, 0x03)) {}
        If (LEqual (Arg0, 0x04)) {}
        If (LEqual (Arg0, 0x05))
        {
            If (LNotEqual (OSFL, 0x00))
            {
                Sleep (0x01F4)
            }
        }
    }

    Method (\_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        Store (0xFF, DBG1)
        Store (0x00, SFLG)
        If (LEqual (RTCW, 0x00))
        {
            Notify (\_SB.PWRB, 0x02)
        }

        Notify (\_SB.PCI0.USB0, 0x00)
        If (LGreaterEqual (OSFL, 0x01))
        {
            Store (0x00, \_SB.PCI0.SMB0.SMPM)
        }
    }

    Scope (\_SI)
    {
        Method (_MSG, 1, NotSerialized)  // _MSG: Message
        {
            Store ("==== MSG Working ====", Debug)
        }

        Method (_SST, 1, NotSerialized)  // _SST: System Status
        {
            Store ("==== SST Working ====", Debug)
        }
    }

    Scope (\_GPE)
    {
        Method (_L11, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Store (0x02, GS02)
            If (LNotEqual (PEV0, 0xFFFF))
            {
                If (PES0)
                {
                    While (PES0)
                    {
                        Store (0x01, PES0)
                    }

                    Notify (\_SB.PCI0.XVR0, 0x02)
                }
            }

            If (LNotEqual (PEV1, 0xFFFF))
            {
                If (PES1)
                {
                    While (PES1)
                    {
                        Store (0x01, PES1)
                    }

                    Notify (\_SB.PCI0.XVR1, 0x02)
                }
            }

            If (LNotEqual (PEV2, 0xFFFF))
            {
                If (PES2)
                {
                    While (PES2)
                    {
                        Store (0x01, PES2)
                    }

                    Notify (\_SB.PCI0.XVR2, 0x02)
                }
            }

            If (LNotEqual (PEV3, 0xFFFF))
            {
                If (PES3)
                {
                    While (PES3)
                    {
                        Store (0x01, PES3)
                    }

                    Notify (\_SB.PCI0.XVR3, 0x02)
                }
            }
        }

        Method (_L00, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.HUB0, 0x02)
        }

        Method (_L03, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UAR1, 0x02)
        }

        Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.MMAC, 0x02)
        }

        Method (_L0D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB0, 0x02)
        }

        Method (_L05, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB2, 0x02)
        }

        Method (_L07, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.MMCI, 0x02)
        }

        Method (_L10, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            \_SB.PCI0.PS2W ()
        }
    }

    Scope (\_SB)
    {
        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))  // _HID: Hardware ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0B)
            }
        }

        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))  // _HID: Hardware ID
            Name (_CID, EisaId ("PNP0A03"))  // _CID: Compatible ID
            Name (_ADR, 0x00)  // _ADR: Address
            Name (_UID, 0x01)  // _UID: Unique ID
            Name (_BBN, 0x00)  // _BBN: BIOS Bus Number
            Name (PCIA, 0x00)
            Method (_REG, 2, NotSerialized)  // _REG: Region Availability
            {
                If (LEqual (Arg0, 0x02))
                {
                    Store (Arg1, PCIA)
                }
            }

            OperationRegion (BRCR, PCI_Config, 0xD0, 0x04)
            Scope (\)
            {
                Field (\_SB.PCI0.BRCR, ByteAcc, NoLock, Preserve)
                {
                    GPUB,   32
                }
            }

            Device (MBIO)
            {
                Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                Name (_UID, 0x05)  // _UID: Unique ID
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF0, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x4000,             // Range Minimum
                            0x4000,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        IO (Decode16,
                            0x4080,             // Range Minimum
                            0x4080,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        IO (Decode16,
                            0x4400,             // Range Minimum
                            0x4400,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        IO (Decode16,
                            0x4480,             // Range Minimum
                            0x4480,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        IO (Decode16,
                            0x4800,             // Range Minimum
                            0x4800,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        IO (Decode16,
                            0x4880,             // Range Minimum
                            0x4880,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xA0000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y00)
                    })
                    CreateDWordField (BUF0, \_SB.PCI0.MBIO._CRS._Y00._BAS, BRAB)  // _BAS: Base Address
                    CreateDWordField (BUF0, \_SB.PCI0.MBIO._CRS._Y00._LEN, BRAL)  // _LEN: Length
                    If (GPUB)
                    {
                        ShiftLeft (GPUB, 0x10, Local0)
                        Store (Local0, BRAB)
                        Store (0x10000000, BRAL)
                    }

                    Return (BUF0)
                }
            }

            Name (NATA, Package (0x01)
            {
                0x00060000
            })
            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                If (LEqual (OSFL, 0x02))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0F)
            }

            OperationRegion (LDT3, PCI_Config, 0x6C, 0x04)
            Field (LDT3, DWordAcc, NoLock, Preserve)
            {
                UCFG,   32
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (BUF0, ResourceTemplate ()
                {
                    WordBusNumber (ResourceConsumer, MinNotFixed, MaxNotFixed, PosDecode,
                        0x0000,             // Granularity
                        0x0000,             // Range Minimum
                        0x00FF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0100,             // Length
                        ,, )
                    IO (Decode16,
                        0x0CF8,             // Range Minimum
                        0x0CF8,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0000,             // Range Minimum
                        0x0CF7,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0CF8,             // Length
                        ,, , TypeStatic)
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0D00,             // Range Minimum
                        0xFFFF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0xF300,             // Length
                        ,, , TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x000A0000,         // Range Minimum
                        0x000BFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00020000,         // Length
                        ,, , AddressRangeMemory, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x000C0000,         // Range Minimum
                        0x000DFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00020000,         // Length
                        ,, , AddressRangeMemory, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x00100000,         // Range Minimum
                        0xFEBFFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0xFFF00000,         // Length
                        ,, _Y01, AddressRangeMemory, TypeStatic)
                })
                CreateDWordField (BUF0, \_SB.PCI0._CRS._Y01._MIN, TCMM)  // _MIN: Minimum Base Address
                CreateDWordField (BUF0, \_SB.PCI0._CRS._Y01._LEN, TOMM)  // _LEN: Length
                Add (AMEM, 0x00010000, TCMM)
                Subtract (0xFEC00000, TCMM, TOMM)
                Return (BUF0)
            }

            Name (PICM, Package (0x1F)
            {
                Package (0x04)
                {
                    0x0001FFFF, 
                    0x00, 
                    \_SB.PCI0.LSMB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x01, 
                    \_SB.PCI0.LSMB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x00, 
                    \_SB.PCI0.LUBA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x01, 
                    \_SB.PCI0.LUB2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x00, 
                    \_SB.PCI0.LMAC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    \_SB.PCI0.LACI, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x01, 
                    \_SB.PCI0.LMCI, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x00, 
                    \_SB.PCI0.LIDE, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x00, 
                    \_SB.PCI0.LSID, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x00, 
                    \_SB.PCI0.LFID, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0017FFFF, 
                    0x00, 
                    \_SB.PCI0.LPCA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x00, 
                    \_SB.PCI0.LNK1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x01, 
                    \_SB.PCI0.LNK2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x02, 
                    \_SB.PCI0.LNK3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x03, 
                    \_SB.PCI0.LNK4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x00, 
                    \_SB.PCI0.LNK3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x01, 
                    \_SB.PCI0.LNK4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x02, 
                    \_SB.PCI0.LNK1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x03, 
                    \_SB.PCI0.LNK2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x00, 
                    \_SB.PCI0.LNK4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x01, 
                    \_SB.PCI0.LNK1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x02, 
                    \_SB.PCI0.LNK2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x03, 
                    \_SB.PCI0.LNK3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x00, 
                    \_SB.PCI0.LNK1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x01, 
                    \_SB.PCI0.LNK2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x02, 
                    \_SB.PCI0.LNK3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x03, 
                    \_SB.PCI0.LNK4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x00, 
                    \_SB.PCI0.LNK2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x01, 
                    \_SB.PCI0.LNK3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x02, 
                    \_SB.PCI0.LNK4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x03, 
                    \_SB.PCI0.LNK1, 
                    0x00
                }
            })
            Name (APIC, Package (0x1F)
            {
                Package (0x04)
                {
                    0x0001FFFF, 
                    0x00, 
                    \_SB.PCI0.APCS, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x01, 
                    \_SB.PCI0.APCS, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x00, 
                    \_SB.PCI0.APCF, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x01, 
                    \_SB.PCI0.APCL, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x00, 
                    \_SB.PCI0.APCH, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    \_SB.PCI0.APCJ, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x01, 
                    \_SB.PCI0.APCK, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x00, 
                    \_SB.PCI0.APCZ, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x00, 
                    \_SB.PCI0.APSI, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x00, 
                    \_SB.PCI0.APSJ, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0017FFFF, 
                    0x00, 
                    \_SB.PCI0.APCP, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x00, 
                    \_SB.PCI0.APC1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x01, 
                    \_SB.PCI0.APC2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x02, 
                    \_SB.PCI0.APC3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0009FFFF, 
                    0x03, 
                    \_SB.PCI0.APC4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x00, 
                    \_SB.PCI0.APC3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x01, 
                    \_SB.PCI0.APC4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x02, 
                    \_SB.PCI0.APC1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000EFFFF, 
                    0x03, 
                    \_SB.PCI0.APC2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x00, 
                    \_SB.PCI0.APC4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x01, 
                    \_SB.PCI0.APC1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x02, 
                    \_SB.PCI0.APC2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x03, 
                    \_SB.PCI0.APC3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x00, 
                    \_SB.PCI0.APC1, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x01, 
                    \_SB.PCI0.APC2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x02, 
                    \_SB.PCI0.APC3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x03, 
                    \_SB.PCI0.APC4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x00, 
                    \_SB.PCI0.APC2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x01, 
                    \_SB.PCI0.APC3, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x02, 
                    \_SB.PCI0.APC4, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x03, 
                    \_SB.PCI0.APC1, 
                    0x00
                }
            })
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (LNot (PICF))
                {
                    Return (PICM)
                }
                Else
                {
                    Return (APIC)
                }
            }

            Device (HUB0)
            {
                Name (_ADR, 0x00090000)  // _ADR: Address
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (PICM, Package (0x1C)
                {
                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }
                })
                Name (APIC, Package (0x1C)
                {
                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x00, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x01, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x02, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0001FFFF, 
                        0x03, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x00, 
                        \_SB.PCI0.APC1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x01, 
                        \_SB.PCI0.APC2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x02, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x03, 
                        \_SB.PCI0.APC4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x00, 
                        \_SB.PCI0.APC2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x01, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x02, 
                        \_SB.PCI0.APC4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0007FFFF, 
                        0x03, 
                        \_SB.PCI0.APC1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x00, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x01, 
                        \_SB.PCI0.APC4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x02, 
                        \_SB.PCI0.APC1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0008FFFF, 
                        0x03, 
                        \_SB.PCI0.APC2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x00, 
                        \_SB.PCI0.APC4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x01, 
                        \_SB.PCI0.APC1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x02, 
                        \_SB.PCI0.APC2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000AFFFF, 
                        0x03, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x00, 
                        \_SB.PCI0.APC1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x01, 
                        \_SB.PCI0.APC2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x02, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000BFFFF, 
                        0x03, 
                        \_SB.PCI0.APC4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x00, 
                        \_SB.PCI0.APC2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x01, 
                        \_SB.PCI0.APC3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x02, 
                        \_SB.PCI0.APC4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x000CFFFF, 
                        0x03, 
                        \_SB.PCI0.APC1, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (LNot (PICF))
                    {
                        Return (PICM)
                    }
                    Else
                    {
                        Return (APIC)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x00, 
                    0x05
                })
            }

            Device (SAT1)
            {
                Name (_ADR, 0x00070000)  // _ADR: Address
                Device (PRI0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SPTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SPTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Name (SSTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SSTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SSTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Return (\_SB.PCI0.NVRB.R_S0)
                }
            }

            Device (SAT2)
            {
                Name (_ADR, 0x00080000)  // _ADR: Address
                Device (PRI0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SPTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SPTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Name (SSTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SSTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SSTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Return (\_SB.PCI0.NVRB.R_S1)
                }
            }

            Device (IDE0)
            {
                Name (_ADR, 0x00060000)  // _ADR: Address
                OperationRegion (A090, PCI_Config, 0x50, 0x18)
                Field (A090, DWordAcc, NoLock, Preserve)
                {
                    ID20,   16, 
                    Offset (0x08), 
                    IDTS,   16, 
                    IDTP,   16, 
                    ID22,   32, 
                    UMSS,   16, 
                    UMSP,   16
                }

                Name (IDEP, Buffer (0x14) {})
                Name (IDES, Buffer (0x14) {})
                Method (GTM, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x00))
                    {
                        Store (IDTP, Local0)
                        Store (UMSP, Local1)
                        Store (IDEP, Local2)
                    }
                    Else
                    {
                        Store (IDTS, Local0)
                        Store (UMSS, Local1)
                        Store (IDES, Local2)
                    }

                    CreateDWordField (Local2, 0x00, PIO0)
                    CreateDWordField (Local2, 0x04, DMA0)
                    CreateDWordField (Local2, 0x08, PIO1)
                    CreateDWordField (Local2, 0x0C, DMA1)
                    CreateDWordField (Local2, 0x10, FLAG)
                    Store (0x10, FLAG)
                    And (Local0, 0x0F00, Local3)
                    And (Local0, 0xF000, Local4)
                    ShiftRight (Local3, 0x08, Local3)
                    ShiftRight (Local4, 0x0C, Local4)
                    Add (Local3, Local4, Local3)
                    Multiply (Add (Local3, 0x02), 0x1E, PIO0)
                    If (LLessEqual (PIO0, 0xB4))
                    {
                        Or (FLAG, 0x02, FLAG)
                    }

                    If (And (Local1, 0x4000))
                    {
                        Or (FLAG, 0x01, FLAG)
                        And (Local1, 0x0700, Local3)
                        ShiftRight (Local3, 0x08, Local3)
                        Store (U2T (Local3), DMA0)
                    }
                    Else
                    {
                        Store (PIO0, DMA0)
                    }

                    And (Local0, 0x0F, Local3)
                    And (Local0, 0xF0, Local4)
                    ShiftRight (Local4, 0x04, Local4)
                    Add (Local3, Local4, Local3)
                    Multiply (Add (Local3, 0x02), 0x1E, PIO1)
                    If (LLessEqual (PIO1, 0xB4))
                    {
                        Or (FLAG, 0x08, FLAG)
                    }

                    If (And (Local1, 0x40))
                    {
                        Or (FLAG, 0x04, FLAG)
                        And (Local1, 0x07, Local3)
                        Store (U2T (Local3), DMA1)
                    }
                    Else
                    {
                        Store (PIO1, DMA1)
                    }

                    If (LEqual (Arg0, 0x00))
                    {
                        Store (Local2, IDEP)
                        Return (IDEP)
                    }
                    Else
                    {
                        Store (Local2, IDES)
                        Return (IDES)
                    }
                }

                Method (U2T, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x00))
                    {
                        Return (0x3C)
                    }

                    If (LEqual (Arg0, 0x01))
                    {
                        Return (0x5A)
                    }

                    If (LEqual (Arg0, 0x02))
                    {
                        Return (0x78)
                    }

                    If (LEqual (Arg0, 0x03))
                    {
                        Return (0x96)
                    }

                    If (LEqual (Arg0, 0x04))
                    {
                        Return (0x2D)
                    }

                    If (LEqual (Arg0, 0x05))
                    {
                        Return (0x1E)
                    }

                    If (LEqual (Arg0, 0x06))
                    {
                        Return (0x14)
                    }

                    Return (0x0F)
                }

                Method (T2U, 1, NotSerialized)
                {
                    If (LGreater (Arg0, 0x78))
                    {
                        Return (0x03)
                    }

                    If (LGreater (Arg0, 0x5A))
                    {
                        Return (0x02)
                    }

                    If (LGreater (Arg0, 0x3C))
                    {
                        Return (0x01)
                    }

                    If (LGreater (Arg0, 0x2D))
                    {
                        Return (0x00)
                    }

                    If (LGreater (Arg0, 0x1E))
                    {
                        Return (0x04)
                    }

                    If (LGreater (Arg0, 0x14))
                    {
                        Return (0x05)
                    }

                    If (LGreater (Arg0, 0x0F))
                    {
                        Return (0x06)
                    }

                    Return (0x07)
                }

                Method (T2D, 1, NotSerialized)
                {
                    If (LGreater (Arg0, 0x01E0))
                    {
                        Return (0xA8)
                    }

                    If (LGreater (Arg0, 0x0186))
                    {
                        Return (0x77)
                    }

                    If (LGreater (Arg0, 0xF0))
                    {
                        Return (0x47)
                    }

                    If (LGreater (Arg0, 0xB4))
                    {
                        Return (0x33)
                    }

                    If (LGreater (Arg0, 0x96))
                    {
                        Return (0x22)
                    }

                    If (LGreater (Arg0, 0x78))
                    {
                        Return (0x21)
                    }

                    Return (0x20)
                }

                Method (STM, 4, NotSerialized)
                {
                    If (SX)
                    {
                        Store (SID0, ID20)
                        Store (SID1, IDTS)
                        Store (SID2, IDTP)
                        Store (SID3, ID22)
                        Store (SID4, UMSS)
                        Store (SID5, UMSP)
                    }
                    Else
                    {
                        Store (ID20, SID0)
                        Store (IDTS, SID1)
                        Store (IDTP, SID2)
                        Store (ID22, SID3)
                        Store (UMSS, SID4)
                        Store (UMSP, SID5)
                    }

                    Store (0x00, SX)
                    CreateDWordField (Arg0, 0x00, PIO0)
                    CreateDWordField (Arg0, 0x04, DMA0)
                    CreateDWordField (Arg0, 0x08, PIO1)
                    CreateDWordField (Arg0, 0x0C, DMA1)
                    CreateDWordField (Arg0, 0x10, FLAG)
                    If (LEqual (Arg3, 0x00))
                    {
                        Store (SID2, Local0)
                        Store (SID5, Local1)
                    }
                    Else
                    {
                        Store (SID1, Local0)
                        Store (SID4, Local1)
                    }

                    If (LNotEqual (PIO0, 0xFFFFFFFF))
                    {
                        And (Local0, 0xFF, Local0)
                        ShiftLeft (T2D (PIO0), 0x08, Local2)
                        Or (Local0, Local2, Local0)
                    }

                    If (LNotEqual (PIO1, 0xFFFFFFFF))
                    {
                        And (Local0, 0xFF00, Local0)
                        Or (Local0, T2D (PIO1), Local0)
                    }

                    If (And (FLAG, 0x01))
                    {
                        And (Local1, 0xFF, Local1)
                        ShiftLeft (T2U (DMA0), 0x08, Local2)
                        Or (0xC000, Local2, Local2)
                        Or (Local2, Local1, Local1)
                    }
                    Else
                    {
                        If (LNotEqual (DMA0, 0xFFFFFFFF))
                        {
                            And (Local0, 0xFF, Local0)
                            ShiftLeft (T2D (DMA0), 0x08, Local2)
                            Or (Local0, Local2, Local0)
                        }
                    }

                    If (And (FLAG, 0x04))
                    {
                        And (Local1, 0xFF00, Local1)
                        Or (0xC0, T2U (DMA1), Local2)
                        Or (Local2, Local1, Local1)
                    }
                    Else
                    {
                        If (LNotEqual (DMA1, 0xFFFFFFFF))
                        {
                            And (Local0, 0xFF00, Local0)
                            Or (Local0, T2D (DMA1), Local0)
                        }
                    }

                    If (LEqual (Arg3, 0x00))
                    {
                        Store (Local0, IDTP)
                        Store (Local1, UMSP)
                    }
                    Else
                    {
                        Store (Local0, IDTS)
                        Store (Local1, UMSS)
                    }
                }

                Method (GTF, 2, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                             0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                        }, Local0)
                    CreateByteField (Local0, 0x01, MODE)
                    CreateByteField (Local0, 0x05, DRIV)
                    Store (Arg1, DRIV)
                    If (LEqual (Arg0, 0x00))
                    {
                        Store (IDEP, Local1)
                    }
                    Else
                    {
                        Store (IDES, Local1)
                    }

                    CreateDWordField (Local1, 0x00, PIO0)
                    CreateDWordField (Local1, 0x04, DMA0)
                    CreateDWordField (Local1, 0x08, PIO1)
                    CreateDWordField (Local1, 0x0C, DMA1)
                    CreateDWordField (Local1, 0x10, FLGX)
                    If (LEqual (Arg1, 0xA0))
                    {
                        Store (PIO0, Local2)
                        Store (DMA0, Local3)
                        And (FLGX, 0x01, FLGX)
                    }
                    Else
                    {
                        Store (PIO1, Local2)
                        Store (DMA1, Local3)
                        And (FLGX, 0x04, FLGX)
                    }

                    Store (FLGX, Local1)
                    If (LGreater (Local2, 0x0186))
                    {
                        Store (0x00, Local2)
                    }
                    Else
                    {
                        If (LGreater (Local2, 0xF0))
                        {
                            Store (0x01, Local2)
                        }
                        Else
                        {
                            If (LGreater (Local2, 0xB4))
                            {
                                Store (0x02, Local2)
                            }
                            Else
                            {
                                If (LGreater (Local2, 0x78))
                                {
                                    Store (0x03, Local2)
                                }
                                Else
                                {
                                    Store (0x04, Local2)
                                }
                            }
                        }
                    }

                    Or (0x08, Local2, MODE)
                    Store (Local0, Local2)
                    If (FLGX)
                    {
                        If (LGreater (Local3, 0x5A))
                        {
                            Store (0x00, Local3)
                        }
                        Else
                        {
                            If (LGreater (Local3, 0x3C))
                            {
                                Store (0x01, Local3)
                            }
                            Else
                            {
                                If (LGreater (Local3, 0x2D))
                                {
                                    Store (0x02, Local3)
                                }
                                Else
                                {
                                    If (LGreater (Local3, 0x1E))
                                    {
                                        Store (0x03, Local3)
                                    }
                                    Else
                                    {
                                        If (LGreater (Local3, 0x14))
                                        {
                                            Store (0x04, Local3)
                                        }
                                        Else
                                        {
                                            If (LGreater (Local3, 0x0F))
                                            {
                                                Store (0x05, Local3)
                                            }
                                            Else
                                            {
                                                Store (0x06, Local3)
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        Or (0x40, Local3, MODE)
                    }
                    Else
                    {
                        If (LEqual (Local3, 0xFFFFFFFF))
                        {
                            Return (Local0)
                        }
                        Else
                        {
                            If (LGreater (Local3, 0x96))
                            {
                                Store (0x00, Local3)
                            }
                            Else
                            {
                                If (LGreater (Local3, 0x78))
                                {
                                    Store (0x01, Local3)
                                }
                                Else
                                {
                                    Store (0x02, Local3)
                                }
                            }

                            Or (0x20, Local3, MODE)
                        }
                    }

                    Concatenate (Local0, Local2, Local1)
                    Return (Local1)
                }

                Device (PRI0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (GTM (0x00))
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        STM (Arg0, Arg1, Arg2, 0x00)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x00, 0xA0))
                        }
                    }

                    Device (SLAV)
                    {
                        Name (_ADR, 0x01)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x00, 0xB0))
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (GTM (0x01))
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        STM (Arg0, Arg1, Arg2, 0x01)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x01, 0xA0))
                        }
                    }

                    Device (SLAV)
                    {
                        Name (_ADR, 0x01)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x01, 0xB0))
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Return (\_SB.PCI0.NVRB.R_P0)
                }
            }

            Device (XVR0)
            {
                Name (_ADR, 0x000E0000)  // _ADR: Address
                OperationRegion (PCV0, PCI_Config, 0x00, 0xFF)
                Scope (\)
                {
                    Field (\_SB.PCI0.XVR0.PCV0, ByteAcc, NoLock, Preserve)
                    {
                        PEV0,   16, 
                        Offset (0x9A), 
                        SLI0,   8, 
                        Offset (0x9C), 
                            ,   3, 
                        XPE0,   1, 
                        Offset (0xA0), 
                        RQD0,   16, 
                        PES0,   1, 
                        PEP0,   1
                    }

                    Method (ESLI, 0, NotSerialized)
                    {
                        And (SLI0, 0x40, Local0)
                        Return (Local0)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x11, 
                    0x05
                })
            }

            Device (XVR1)
            {
                Name (_ADR, 0x000D0000)  // _ADR: Address
                OperationRegion (PCV1, PCI_Config, 0x00, 0xFF)
                Scope (\)
                {
                    Field (\_SB.PCI0.XVR1.PCV1, ByteAcc, NoLock, Preserve)
                    {
                        PEV1,   16, 
                        Offset (0x9A), 
                        SLI1,   8, 
                        Offset (0x9C), 
                            ,   3, 
                        XPE1,   1, 
                        Offset (0xA0), 
                        RQD1,   16, 
                        PES1,   1, 
                        PEP1,   1
                    }

                    Method (DSLI, 0, NotSerialized)
                    {
                        And (SLI1, 0x40, Local0)
                        Return (Local0)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x11, 
                    0x05
                })
            }

            Device (XVR2)
            {
                Name (_ADR, 0x000C0000)  // _ADR: Address
                OperationRegion (PCV2, PCI_Config, 0x00, 0xFF)
                Scope (\)
                {
                    Field (\_SB.PCI0.XVR2.PCV2, ByteAcc, NoLock, Preserve)
                    {
                        PEV2,   16, 
                        Offset (0x9A), 
                        SLI2,   8, 
                        Offset (0x9C), 
                            ,   3, 
                        XPE2,   1, 
                        Offset (0xA0), 
                        RQD2,   16, 
                        PES2,   1, 
                        PEP2,   1
                    }

                    Method (CSLI, 0, NotSerialized)
                    {
                        And (SLI2, 0x40, Local0)
                        Return (Local0)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x11, 
                    0x05
                })
            }

            Device (XVR3)
            {
                Name (_ADR, 0x000B0000)  // _ADR: Address
                OperationRegion (PCV3, PCI_Config, 0x00, 0xFF)
                Scope (\)
                {
                    Field (\_SB.PCI0.XVR3.PCV3, ByteAcc, NoLock, Preserve)
                    {
                        PEV3,   16, 
                        Offset (0x9C), 
                            ,   3, 
                        XPE3,   1, 
                        Offset (0xA0), 
                        RQD3,   16, 
                        PES3,   1, 
                        PEP3,   1
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x11, 
                    0x05
                })
            }

            Device (SMB0)
            {
                Name (_ADR, 0x00010001)  // _ADR: Address
                OperationRegion (SMCF, PCI_Config, 0x48, 0x10)
                Field (SMCF, DWordAcc, NoLock, Preserve)
                {
                    SMPM,   4, 
                    SMT1,   28, 
                    SMT2,   32
                }

                OperationRegion (SMCA, PCI_Config, 0x20, 0x08)
                Field (SMCA, DWordAcc, NoLock, Preserve)
                {
                    SB1,    32, 
                    SB2,    32
                }

                Method (SMBB, 0, NotSerialized)
                {
                    If (PCIA)
                    {
                        And (SB1, 0xFFFE, Local0)
                    }
                    Else
                    {
                        Store (0x4C00, Local0)
                    }

                    Return (Local0)
                }
            }

            Device (VT86)
            {
                Name (_ADR, 0x00010000)  // _ADR: Address
                OperationRegion (PIO0, PCI_Config, 0x04, 0x20)
                Scope (\)
                {
                    Field (\_SB.PCI0.VT86.PIO0, ByteAcc, NoLock, Preserve)
                    {
                        SMEN,   8, 
                        Offset (0x0C), 
                        Offset (0x0D), 
                        SMIO,   8
                    }
                }

                OperationRegion (PIRQ, PCI_Config, 0x7C, 0x0C)
                Scope (\)
                {
                    Field (\_SB.PCI0.VT86.PIRQ, AnyAcc, NoLock, Preserve)
                    {
                        INTA,   4, 
                        INTB,   4, 
                        INTC,   4, 
                        INTD,   4, 
                        INTE,   4, 
                        IS0S,   4, 
                        SSAI,   4, 
                        IPCA,   4, 
                        SCII,   4, 
                        TCOI,   4, 
                        INTF,   4, 
                        INTQ,   4, 
                        INTU,   4, 
                        INTS,   4, 
                        IS0P,   4, 
                        ITID,   4, 
                        INTG,   4, 
                        INTH,   4, 
                        INTJ,   4, 
                        INTK,   4, 
                        INTL,   4, 
                        INTM,   4, 
                        INTN,   4, 
                        INTP,   4
                    }
                }

                OperationRegion (PDEV, PCI_Config, 0xE8, 0x04)
                Scope (\)
                {
                    Field (\_SB.PCI0.VT86.PDEV, AnyAcc, NoLock, Preserve)
                    {
                            ,   12, 
                        ACIE,   1
                    }
                }

                OperationRegion (LPIO, PCI_Config, 0xA0, 0x18)
                Scope (\)
                {
                    Field (\_SB.PCI0.VT86.LPIO, ByteAcc, NoLock, Preserve)
                    {
                        UAIO,   8, 
                        SNDD,   4, 
                        MIDD,   4, 
                        MSSD,   4, 
                        FDCD,   2, 
                        Offset (0x03), 
                        PRIO,   3, 
                            ,   1, 
                        GEN1,   1, 
                        GEN2,   1, 
                        GEN3,   1, 
                        GEN4,   1, 
                        GAM1,   8, 
                        GAM2,   8
                    }

                    OperationRegion (RTC2, SystemIO, 0x72, 0x02)
                    Field (RTC2, ByteAcc, NoLock, Preserve)
                    {
                        CM2I,   8, 
                        CM2D,   8
                    }

                    IndexField (CM2I, CM2D, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xCC), 
                        UA1D,   8
                    }

                    Name (UARA, 0x00)
                    Name (UARB, 0x00)
                    Method (DISD, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x00))
                        {
                            Store (UARA, Local0)
                            XOr (Local0, 0xFF, Local0)
                            And (UAIO, Local0, UAIO)
                        }

                        If (LEqual (Arg0, 0x01))
                        {
                            Store (UARB, Local0)
                            XOr (Local0, 0xFF, Local0)
                            And (UAIO, Local0, UAIO)
                        }

                        If (LEqual (Arg0, 0x02))
                        {
                            Store (0x00, PRIO)
                        }

                        If (LEqual (Arg0, 0x03))
                        {
                            Store (0x00, FDCD)
                        }

                        If (LEqual (Arg0, 0x04))
                        {
                            Store (0x00, GAM1)
                            Store (0x00, GAM2)
                        }

                        If (LEqual (Arg0, 0x05))
                        {
                            Store (0x00, MIDD)
                        }
                    }

                    Method (CKIO, 2, NotSerialized)
                    {
                        If (LEqual (Arg1, 0x00))
                        {
                            Or (UARA, UARB, Local0)
                            And (UAIO, Local0, UAIO)
                            Store (UARA, Local0)
                            XOr (Local0, 0xFF, Local0)
                            And (UAIO, Local0, UAIO)
                            If (LEqual (Arg0, 0x03F8))
                            {
                                Store (0x01, Local0)
                            }

                            If (LEqual (Arg0, 0x02F8))
                            {
                                Store (0x02, Local0)
                            }

                            If (LEqual (Arg0, 0x02E8))
                            {
                                Store (0x20, Local0)
                            }

                            If (LEqual (Arg0, 0x03E8))
                            {
                                Store (0x80, Local0)
                            }

                            Or (UAIO, Local0, UAIO)
                            Store (Local0, UARA)
                        }

                        If (LEqual (Arg1, 0x01))
                        {
                            Or (UARA, UARB, Local0)
                            And (UAIO, Local0, UAIO)
                            Store (UARB, Local0)
                            XOr (Local0, 0xFF, Local0)
                            And (UAIO, Local0, UAIO)
                            If (LEqual (Arg0, 0x03F8))
                            {
                                Store (0x01, Local0)
                            }

                            If (LEqual (Arg0, 0x02F8))
                            {
                                Store (0x02, Local0)
                            }

                            If (LEqual (Arg0, 0x02E8))
                            {
                                Store (0x20, Local0)
                            }

                            If (LEqual (Arg0, 0x03E8))
                            {
                                Store (0x80, Local0)
                            }

                            Or (UAIO, Local0, UAIO)
                            Store (Local0, UARB)
                        }

                        If (LEqual (Arg1, 0x02))
                        {
                            If (LEqual (Arg0, 0x0378))
                            {
                                Store (0x00, PRIO)
                                Or (PRIO, 0x01, PRIO)
                            }

                            If (LEqual (Arg0, 0x0278))
                            {
                                Store (0x00, PRIO)
                                Or (PRIO, 0x02, PRIO)
                            }

                            If (LEqual (Arg0, 0x03BC))
                            {
                                Store (0x00, PRIO)
                                Or (PRIO, 0x04, PRIO)
                            }
                        }

                        If (LEqual (Arg1, 0x03))
                        {
                            Or (FDCD, 0x01, FDCD)
                        }

                        If (LEqual (Arg1, 0x04))
                        {
                            Store (0x00, GAM1)
                            Store (0x00, GAM2)
                            If (LEqual (Arg0, 0x0201))
                            {
                                Or (GAM1, 0x02, GAM1)
                            }

                            If (LEqual (Arg0, 0x0209))
                            {
                                Or (GAM2, 0x02, GAM2)
                            }
                        }

                        If (LEqual (Arg1, 0x05))
                        {
                            Store (0x00, MIDD)
                            If (LEqual (Arg0, 0x0300))
                            {
                                Or (MIDD, 0x01, MIDD)
                            }

                            If (LEqual (Arg0, 0x0330))
                            {
                                Or (MIDD, 0x08, MIDD)
                            }
                        }
                    }

                    Method (SLDM, 2, NotSerialized)
                    {
                    }

                    Method (CLSU, 1, NotSerialized)
                    {
                        CreateWordField (Arg0, 0x02, UARO)
                        If (LEqual (UARO, 0x03F8))
                        {
                            And (UAIO, 0xFE, UAIO)
                        }

                        If (LEqual (UARO, 0x02F8))
                        {
                            And (UAIO, 0xFD, UAIO)
                        }

                        If (LEqual (UARO, 0x02E8))
                        {
                            And (UAIO, 0xBF, UAIO)
                        }

                        If (LEqual (UARO, 0x03E8))
                        {
                            And (UAIO, 0x7F, UAIO)
                        }
                    }
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x00020000)  // _ADR: Address
                Method (_S1D, 0, NotSerialized)  // _S1D: S1 Device State
                {
                    Return (0x01)
                }

                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    If (LEqual (OSFL, 0x02))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0D, 
                    0x03
                })
            }

            Device (USB2)
            {
                Name (_ADR, 0x00020001)  // _ADR: Address
                OperationRegion (P020, PCI_Config, 0x49, 0x01)
                Field (P020, AnyAcc, NoLock, Preserve)
                {
                    U0WK,   1
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x01, U0WK)
                    }
                    Else
                    {
                        Store (0x00, U0WK)
                    }
                }

                Method (_S1D, 0, NotSerialized)  // _S1D: S1 Device State
                {
                    Return (0x01)
                }

                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    Return (0x01)
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x05, 
                    0x03
                })
            }

            Device (MMAC)
            {
                Name (_ADR, 0x000A0000)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0B, 
                    0x05
                })
            }

            Device (MACI)
            {
                Method (_ADR, 0, NotSerialized)  // _ADR: Address
                {
                    If (ACIE)
                    {
                        Return (0x00040001)
                    }
                    Else
                    {
                        Return (0x00040000)
                    }
                }
            }

            Device (MMCI)
            {
                Method (_ADR, 0, NotSerialized)  // _ADR: Address
                {
                    If (ACIE)
                    {
                        Return (0x00040000)
                    }
                    Else
                    {
                        Return (0x00040001)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x07, 
                    0x05
                })
            }

            Device (NVRB)
            {
                Name (_HID, "_NVRAIDBUS")  // _HID: Hardware ID
                OperationRegion (NVRD, SystemMemory, 0x000FFF38, 0x02)
                Field (NVRD, ByteAcc, NoLock, Preserve)
                {
                    R_ST,   1, 
                        ,   3, 
                    R_P0,   4, 
                    R_S0,   4, 
                    R_S1,   4
                }

                Name (FNVR, 0xFF)
                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, FNVR)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (R_ST, 0x01))
                    {
                        If (LEqual (FNVR, 0xFF))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (0x0D)
                        }
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x04D2,             // Range Minimum
                        0x04D2,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                })
            }

            Device (ASOC)
            {
                Name (_HID, "ATK0110")  // _HID: Hardware ID
                Name (_UID, 0x01010110)  // _UID: Unique ID
                Name (MBIF, Package (0x08)
                {
                    0x01, 
                    "A8NSLI-P", 
                    0x01, 
                    0x01, 
                    0x02, 
                    0x00, 
                    0x00, 
                    0x00
                })
                Name (VBUF, Package (0x05)
                {
                    0x04, 
                    VCRE, 
                    V333, 
                    V500, 
                    V120
                })
                Name (VCRE, Package (0x05)
                {
                    0x06020000, 
                    "Vcore Voltage", 
                    0x05AA, 
                    0x06D6, 
                    0x01
                })
                Name (V333, Package (0x05)
                {
                    0x06020001, 
                    " +3.3 Voltage", 
                    0x0BB8, 
                    0x0E10, 
                    0x01
                })
                Name (V500, Package (0x05)
                {
                    0x06020002, 
                    " +5.0 Voltage", 
                    0x1194, 
                    0x157C, 
                    0x01
                })
                Name (V120, Package (0x05)
                {
                    0x06020003, 
                    "+12.0 Voltage", 
                    0x2BC0, 
                    0x3390, 
                    0x01
                })
                Name (TBUF, Package (0x03)
                {
                    0x02, 
                    CPUT, 
                    MBTP
                })
                Name (CPUT, Package (0x05)
                {
                    0x06030000, 
                    "CPU Temperature", 
                    0x0384, 
                    0x04E2, 
                    0x00010001
                })
                Name (MBTP, Package (0x05)
                {
                    0x06030001, 
                    "MB Temperature", 
                    0x02BC, 
                    0x04E2, 
                    0x00010001
                })
                Name (FBUF, Package (0x06)
                {
                    0x03, 
                    CPUF, 
                    CHAF, 
                    PWRF, 
                    CHPF, 
                    CH2F
                })
                Name (CPUF, Package (0x05)
                {
                    0x06040000, 
                    "CPU FAN Speed", 
                    0x00, 
                    0x0708, 
                    0x00010001
                })
                Name (CHAF, Package (0x05)
                {
                    0x06040001, 
                    "CHASSIS FAN Speed", 
                    0x00, 
                    0x0708, 
                    0x01
                })
                Name (PWRF, Package (0x05)
                {
                    0x06040002, 
                    "POWER FAN Speed", 
                    0x00, 
                    0x0708, 
                    0x00
                })
                Name (CHPF, Package (0x05)
                {
                    0x06040005, 
                    "CHIPSET FAN Speed", 
                    0x00, 
                    0x0708, 
                    0x01
                })
                Name (CH2F, Package (0x05)
                {
                    0x06040006, 
                    "CHASSIS2 FAN Speed", 
                    0x00, 
                    0x0708, 
                    0x00
                })
                Name (QFAN, Package (0x05)
                {
                    0x04060003, 
                    "CPU Q-Fan Control", 
                    0x00, 
                    0x01, 
                    0x01
                })
                Name (QFRO, Package (0x05)
                {
                    0x04050004, 
                    "CPU Q-Fan Ratio", 
                    0x3C, 
                    0x5A, 
                    0x00
                })
                Name (QFTP, Package (0x05)
                {
                    0x04030005, 
                    "CPU Target Temperature", 
                    0x33, 
                    0x51, 
                    0x00010001
                })
                Name (QCFN, Package (0x05)
                {
                    0x04060006, 
                    "Chassis Q-Fan Control", 
                    0x00, 
                    0x01, 
                    0x00
                })
                Name (QFCR, Package (0x05)
                {
                    0x04050007, 
                    "Chassis Q-Fan Ratio", 
                    0x38, 
                    0x64, 
                    0x00
                })
                OperationRegion (HWRE, SystemIO, 0x0295, 0x02)
                Field (HWRE, ByteAcc, NoLock, Preserve)
                {
                    HIDX,   8, 
                    HDAT,   8
                }

                IndexField (HIDX, HDAT, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x0B), 
                    FD11,   3, 
                    FD12,   3, 
                    FD13,   1, 
                    Offset (0x0C), 
                    Offset (0x0D), 
                    FAN1,   8, 
                    FAN2,   8, 
                    FAN3,   8, 
                    Offset (0x20), 
                    VCOR,   8, 
                    Offset (0x22), 
                    V33V,   8, 
                    V50V,   8, 
                    V12V,   8, 
                    Offset (0x29), 
                    TSR1,   8, 
                    MBTE,   8
                }

                Method (ASIF, 0, NotSerialized)
                {
                    Return (MBIF)
                }

                Method (VSIF, 0, NotSerialized)
                {
                    Return (VBUF)
                }

                Method (RVLT, 1, NotSerialized)
                {
                    Store (DerefOf (Index (VCRE, 0x00)), Local0)
                    If (LEqual (Arg0, Local0))
                    {
                        Store (VCOR, Local0)
                        Store (0x00, Local1)
                        While (LEqual (Local0, 0xFF))
                        {
                            Store (VCOR, Local0)
                            If (LEqual (Local1, 0x000186A0))
                            {
                                Break
                            }

                            Add (Local1, 0x01, Local1)
                        }

                        Multiply (Local0, 0x10, Local0)
                        Return (Local0)
                    }

                    Store (DerefOf (Index (V333, 0x00)), Local0)
                    If (LEqual (Arg0, Local0))
                    {
                        Store (V33V, Local0)
                        Store (0x00, Local1)
                        While (LEqual (Local0, 0xFF))
                        {
                            Store (V33V, Local0)
                            If (LEqual (Local1, 0x000186A0))
                            {
                                Break
                            }

                            Add (Local1, 0x01, Local1)
                        }

                        Multiply (Local0, 0x10, Local0)
                        Return (Local0)
                    }

                    Store (DerefOf (Index (V500, 0x00)), Local0)
                    If (LEqual (Arg0, Local0))
                    {
                        Store (V50V, Local0)
                        Store (0x00, Local1)
                        While (LEqual (Local0, 0xFF))
                        {
                            Store (V50V, Local0)
                            If (LEqual (Local1, 0x000186A0))
                            {
                                Break
                            }

                            Add (Local1, 0x01, Local1)
                        }

                        Multiply (Local0, 0x10, Local0)
                        Store (0x22, Local1)
                        Store (0x32, Local2)
                        Add (Local1, Local2, Local1)
                        Multiply (Local0, Local1, Local0)
                        Divide (Local0, Local2, Local3, Local0)
                        Return (Local0)
                    }

                    Store (DerefOf (Index (V120, 0x00)), Local0)
                    If (LEqual (Arg0, Local0))
                    {
                        Store (V12V, Local0)
                        Store (0x00, Local1)
                        While (LEqual (Local0, 0xFF))
                        {
                            Store (V12V, Local0)
                            If (LEqual (Local1, 0x000186A0))
                            {
                                Break
                            }

                            Add (Local1, 0x01, Local1)
                        }

                        Multiply (Local0, 0x10, Local0)
                        Store (0x1E, Local1)
                        Store (0x0A, Local2)
                        Add (Local1, Local2, Local1)
                        Multiply (Local0, Local1, Local0)
                        Divide (Local0, Local2, Local3, Local0)
                        Return (Local0)
                    }
                }

                Method (SVLT, 1, NotSerialized)
                {
                    Store (DerefOf (Index (Arg0, 0x00)), Local0)
                    And (Local0, 0x0F, Local0)
                    Store (DerefOf (Index (VBUF, 0x00)), Local1)
                    If (LGreaterEqual (Local0, Local1))
                    {
                        Return (0x01)
                    }

                    Add (Local0, 0x01, Local0)
                    Store (DerefOf (Index (Arg0, 0x01)), Local1)
                    Store (DerefOf (Index (Arg0, 0x02)), Local2)
                    Store (DerefOf (Index (Arg0, 0x03)), Local3)
                    Store (DerefOf (Index (Arg0, 0x04)), Local4)
                    Store (Local1, Index (DerefOf (Index (VBUF, Local0)), 0x01))
                    Store (Local2, Index (DerefOf (Index (VBUF, Local0)), 0x02))
                    Store (Local3, Index (DerefOf (Index (VBUF, Local0)), 0x03))
                    Store (Local4, Index (DerefOf (Index (VBUF, Local0)), 0x04))
                    Return (0x00)
                }

                Method (TSIF, 0, NotSerialized)
                {
                    Return (TBUF)
                }

                Method (RTMP, 1, NotSerialized)
                {
                    Store (DerefOf (Index (CPUT, 0x00)), Local0)
                    If (LEqual (Arg0, Local0))
                    {
                        Store (TSR1, Local0)
                        Store (0x00, Local1)
                        While (LEqual (Local0, 0x80))
                        {
                            Store (TSR1, Local0)
                            If (LEqual (Local1, 0x000186A0))
                            {
                                Break
                            }

                            Add (Local1, 0x01, Local1)
                        }

                        Multiply (Local0, 0x0A, Local0)
                        Return (Local0)
                    }

                    Store (DerefOf (Index (MBTP, 0x00)), Local0)
                    If (LEqual (Arg0, Local0))
                    {
                        Store (MBTE, Local0)
                        Store (0x00, Local1)
                        While (LEqual (Local0, 0x80))
                        {
                            Store (MBTE, Local0)
                            If (LEqual (Local1, 0x000186A0))
                            {
                                Break
                            }

                            Add (Local1, 0x01, Local1)
                        }

                        Multiply (Local0, 0x0A, Local0)
                        Return (Local0)
                    }
                }

                Method (STMP, 1, NotSerialized)
                {
                    Store (DerefOf (Index (Arg0, 0x00)), Local0)
                    And (Local0, 0x0F, Local0)
                    Store (DerefOf (Index (TBUF, 0x00)), Local1)
                    If (LGreaterEqual (Local0, Local1))
                    {
                        Return (0x01)
                    }

                    Add (Local0, 0x01, Local0)
                    Store (DerefOf (Index (Arg0, 0x01)), Local1)
                    Store (DerefOf (Index (Arg0, 0x02)), Local2)
                    Store (DerefOf (Index (Arg0, 0x03)), Local3)
                    Store (DerefOf (Index (Arg0, 0x04)), Local4)
                    Store (Local1, Index (DerefOf (Index (TBUF, Local0)), 0x01))
                    Store (Local2, Index (DerefOf (Index (TBUF, Local0)), 0x02))
                    Store (Local3, Index (DerefOf (Index (TBUF, Local0)), 0x03))
                    Store (Local4, Index (DerefOf (Index (TBUF, Local0)), 0x04))
                    Return (0x00)
                }

                Method (FSIF, 0, NotSerialized)
                {
                    Return (FBUF)
                }

                Method (RFAN, 1, NotSerialized)
                {
                    Store (DerefOf (Index (CPUF, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        Store (FAN1, Local0)
                        If (LAnd (LLess (Local0, 0xFF), LNotEqual (Local0, 0x00)))
                        {
                            Store (FD11, Local2)
                            Store (0x01, Local1)
                            ShiftLeft (Local1, Local2, Local2)
                            Multiply (Local0, Local2, Local0)
                            Divide (0x00149970, Local0, Local1, Local0)
                        }
                        Else
                        {
                            Store (0x00, Local0)
                        }
                    }

                    Store (DerefOf (Index (CHAF, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        Store (FAN2, Local0)
                        If (LAnd (LLess (Local0, 0xFF), LNotEqual (Local0, 0x00)))
                        {
                            Store (FD12, Local2)
                            Store (0x01, Local1)
                            ShiftLeft (Local1, Local2, Local2)
                            Multiply (Local0, Local2, Local0)
                            Divide (0x00149970, Local0, Local1, Local0)
                        }
                        Else
                        {
                            Store (0x00, Local0)
                        }
                    }

                    Store (DerefOf (Index (CHPF, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        Store (FAN3, Local0)
                        If (LAnd (LLess (Local0, 0xFF), LNotEqual (Local0, 0x00)))
                        {
                            Store (FD13, Local2)
                            Multiply (Local2, 0x08, Local2)
                            Multiply (Local0, Local2, Local0)
                            Divide (0x00149970, Local0, Local1, Local0)
                        }
                        Else
                        {
                            Store (0x00, Local0)
                        }
                    }

                    Return (Local0)
                }

                Method (SFAN, 1, NotSerialized)
                {
                    Store (DerefOf (Index (Arg0, 0x00)), Local0)
                    And (Local0, 0x0F, Local0)
                    Store (DerefOf (Index (FBUF, 0x00)), Local1)
                    If (LGreaterEqual (Local0, Local1))
                    {
                        Return (0x00)
                    }
                    Else
                    {
                        Add (Local0, 0x01, Local0)
                        Store (DerefOf (Index (Arg0, 0x01)), Local1)
                        Store (DerefOf (Index (Arg0, 0x02)), Local2)
                        Store (DerefOf (Index (Arg0, 0x03)), Local3)
                        Store (DerefOf (Index (Arg0, 0x04)), Local4)
                        Store (Local1, Index (DerefOf (Index (FBUF, Local0)), 0x01))
                        Store (Local2, Index (DerefOf (Index (FBUF, Local0)), 0x02))
                        Store (Local3, Index (DerefOf (Index (FBUF, Local0)), 0x03))
                        Store (Local4, Index (DerefOf (Index (FBUF, Local0)), 0x04))
                        Return (0x01)
                    }
                }

                Method (SFAS, 1, NotSerialized)
                {
                    Store (DerefOf (Index (Arg0, 0x00)), Local0)
                    And (Local0, 0x0F, Local0)
                    Store (DerefOf (Index (FBUF, 0x00)), Local1)
                    If (LGreaterEqual (Local0, Local1))
                    {
                        Return (0x00)
                    }
                    Else
                    {
                        Return (0x01)
                    }
                }

                Method (OCIF, 0, NotSerialized)
                {
                    Store (MMCM, Index (OC02, 0x03))
                    Store (MMCM, Local0)
                    Store (DerefOf (Index (OC02, 0x02)), Local1)
                    Subtract (Local0, Local1, Local0)
                    Multiply (Local0, 0x02, Local0)
                    Increment (Local0)
                    Store (Local0, Index (OC02, 0x04))
                    Return (OBUF)
                }

                Name (OC1F, 0x00)
                Name (OC2F, 0x00)
                Name (OC3F, 0x00)
                Name (OC4F, 0x00)
                Name (OC5F, 0x00)
                Name (OC6F, 0x00)
                Name (OC7F, 0x00)
                Name (OC8F, 0x00)
                Name (OC9F, 0x00)
                Name (OCAF, 0x00)
                Name (OCBF, 0x00)
                Name (OCCF, 0x00)
                Name (OCDF, 0x00)
                Name (OCEF, 0x00)
                Name (QFNF, 0x00)
                Name (QFPF, 0x00)
                Method (OCOP, 1, NotSerialized)
                {
                    Store (DerefOf (Index (OC01, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC1F, 0x00))
                        {
                            Store (FSBF, Local0)
                            If (LLess (Local0, 0x64))
                            {
                                Add (Local0, 0xFF, Local0)
                            }

                            Store (Local0, Local1)
                            Multiply (Local0, 0x64, Local0)
                            Store (Local0, Index (CPUO, 0x01))
                            Subtract (Local1, 0xC8, Local1)
                            Store (Local1, Index (CPUO, 0x02))
                            SPRE (Arg0, Local1)
                            Store (0x01, OC1F)
                        }

                        Return (CPUO)
                    }

                    Store (DerefOf (Index (OC02, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC2F, 0x00))
                        {
                            Store (MULF, Local0)
                            Store (Local0, Index (CPUM, 0x01))
                            Store (Local0, Index (CPUM, 0x02))
                            SPRD (Arg0, MUCM)
                            SPRE (Arg0, Local0)
                            Store (0x01, OC2F)
                        }

                        Return (CPUM)
                    }

                    Store (DerefOf (Index (OC0F, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        Store (K8HT, Local0)
                        Store (0x04, Local1)
                        If (LEqual (Local0, 0x06))
                        {
                            Store (0x05, Local1)
                        }

                        If (LEqual (Local0, 0x05))
                        {
                            Store (0x04, Local1)
                        }

                        If (LEqual (Local0, 0x04))
                        {
                            Store (0x03, Local1)
                        }

                        If (LEqual (Local0, 0x02))
                        {
                            Store (0x02, Local1)
                        }

                        If (LEqual (Local0, 0x00))
                        {
                            Store (0x01, Local1)
                        }

                        Store (Local1, Index (HTFQ, 0x02))
                        Return (HTFQ)
                    }

                    Store (DerefOf (Index (OC03, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC3F, 0x00))
                        {
                            Store (0x01, OC3F)
                        }

                        Return (MEMO)
                    }

                    Store (DerefOf (Index (OC04, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC4F, 0x00))
                        {
                            Store (0x01, OC4F)
                        }

                        Return (PCIO)
                    }

                    Store (DerefOf (Index (OC05, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC5F, 0x00))
                        {
                            Store (0x01, OC5F)
                        }

                        Return (OCPO)
                    }

                    Store (DerefOf (Index (OC06, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC6F, 0x00))
                        {
                            Store (NOS1, Local0)
                            Store (Local0, Index (AOCO, 0x02))
                            SPRE (Arg0, Local0)
                            Store (0x01, OC6F)
                        }

                        Return (AOCO)
                    }

                    Store (DerefOf (Index (OC07, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC7F, 0x00))
                        {
                            Store (NOS2, Local0)
                            Store (Local0, Index (ADCO, 0x02))
                            SPRE (Arg0, Local0)
                            Store (0x01, OC7F)
                        }

                        Return (ADCO)
                    }

                    Store (DerefOf (Index (OC08, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC8F, 0x00))
                        {
                            Store (0x01, OC8F)
                        }

                        Return (FANB)
                    }

                    Store (DerefOf (Index (OC09, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OC9F, 0x00))
                        {
                            Store (VCRV, Local0)
                            Store (Local0, Index (CPUV, 0x02))
                            SPRD (Arg0, CVCM)
                            SPRE (Arg0, Local0)
                            Store (0x01, OC9F)
                        }

                        Return (CPUV)
                    }

                    Store (DerefOf (Index (OC0A, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OCAF, 0x00))
                        {
                            Store (DDRV, Local0)
                            Store (Local0, Index (RAMV, 0x02))
                            SPRD (Arg0, DRVC)
                            SPRE (Arg0, Local0)
                            Store (0x01, OCAF)
                        }

                        Return (RAMV)
                    }

                    Store (DerefOf (Index (OC0B, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OCBF, 0x00))
                        {
                            Store (0x01, OCBF)
                        }

                        Return (PCIV)
                    }

                    Store (DerefOf (Index (OC0C, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OCCF, 0x00))
                        {
                            Store (0x01, OCCF)
                        }

                        Return (PRHT)
                    }

                    Store (DerefOf (Index (OC0D, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (OCDF, 0x00))
                        {
                            Store (AITU, Index (AITM, 0x02))
                            SPRE (Arg0, AITU)
                            Store (0x01, OCDF)
                        }

                        Return (AITM)
                    }

                    Store (DerefOf (Index (QFAN, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (QFNF, 0x00))
                        {
                            Store (QFNE, Index (CQFN, 0x02))
                            SPRE (Arg0, QFNE)
                            Store (0x01, QFNF)
                        }

                        Return (CQFN)
                    }

                    Store (DerefOf (Index (QFTP, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        If (LEqual (QFPF, 0x00))
                        {
                            Store (QFTE, Index (QFNT, 0x02))
                            SPRE (Arg0, QFTE)
                            Store (0x01, QFPF)
                        }

                        Return (QFNT)
                    }

                    Store (DerefOf (Index (OC0G, 0x00)), Local1)
                    If (LEqual (Arg0, Local1))
                    {
                        Store (CNQC, Local0)
                        If (LEqual (Local0, 0x01))
                        {
                            Store (0x00, Index (CNQF, 0x02))
                        }
                        Else
                        {
                            Store (0x01, Index (CNQF, 0x02))
                        }

                        Return (CNQF)
                    }
                }

                Method (PROC, 3, NotSerialized)
                {
                    If (LEqual (Arg2, 0x00))
                    {
                        Return (0x01)
                    }

                    If (LEqual (Arg2, 0x01))
                    {
                        Store (DerefOf (Index (OC0D, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            If (LEqual (Arg1, 0x00))
                            {
                                Store (0x00, Index (AITM, 0x02))
                            }

                            If (LEqual (Arg1, 0x01))
                            {
                                STDF (0x01)
                                Store (0x01, Index (AITM, 0x02))
                            }

                            If (LEqual (Arg1, 0x02))
                            {
                                STDF (0x02)
                                Store (0x02, Index (AITM, 0x02))
                            }

                            If (LEqual (Arg1, 0x03))
                            {
                                Store (0x03, Index (AITM, 0x02))
                            }

                            If (LEqual (Arg1, 0x04))
                            {
                                Store (0x04, Index (AITM, 0x02))
                            }
                        }

                        Store (DerefOf (Index (OC01, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (CPUO, 0x02))
                            Store (0x03, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (OC05, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (OCPO, 0x02))
                            If (LEqual (Arg1, 0x00))
                            {
                                Store (0x06, Local1)
                            }
                            Else
                            {
                                If (LEqual (Arg1, 0x01))
                                {
                                    Store (0x0A, Local1)
                                }
                                Else
                                {
                                    If (LEqual (Arg1, 0x02))
                                    {
                                        Store (0x10, Local1)
                                    }
                                    Else
                                    {
                                        If (LEqual (Arg1, 0x03))
                                        {
                                            Store (0x14, Local1)
                                        }
                                        Else
                                        {
                                            Store (0x00, Local1)
                                        }
                                    }
                                }
                            }

                            Store (Local1, Index (CPUO, 0x02))
                            Store (0x01, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (OC06, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (0x00, AIP)
                            Store (0x03, AIP2)
                            Store (0xB0, SCP)
                            Store (0x00, Index (CPUO, 0x02))
                            Store (Arg1, AIP)
                            Store (Arg1, Index (AOCO, 0x02))
                            Store (0x02, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (OC09, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (CPUV, 0x02))
                            Store (0x04, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (OC0A, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (RAMV, 0x02))
                            Store (0x05, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (OC02, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (CPUM, 0x01))
                            Store (Arg1, Index (CPUM, 0x02))
                            Store (0x06, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (QFAN, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (CQFN, 0x02))
                            Store (0x07, AIP2)
                            Store (0xB0, SCP)
                        }

                        Store (DerefOf (Index (QFTP, 0x00)), Local0)
                        If (LEqual (Arg0, Local0))
                        {
                            Store (Arg1, AIP)
                            Store (Arg1, Index (QFNT, 0x02))
                            Store (0x08, AIP2)
                            Store (0xB0, SCP)
                        }

                        SPRE (Arg0, Arg1)
                        Return (0x01)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Method (STDF, 1, NotSerialized)
                {
                    Store (0x00, AIP)
                    Store (0x03, AIP2)
                    Store (0xB0, SCP)
                    Store (0x00, Index (CPUO, 0x02))
                    Store (CVCM, AIP)
                    Store (0x04, AIP2)
                    Store (0xB0, SCP)
                    Store (CVCM, Index (CPUV, 0x02))
                    Store (MUCM, AIP)
                    Store (0x06, AIP2)
                    Store (0xB0, SCP)
                    Store (MUCM, Index (CPUM, 0x01))
                    Store (MUCM, Index (CPUM, 0x02))
                    Store (DRVC, AIP)
                    Store (0x05, AIP2)
                    Store (0xB0, SCP)
                    Store (DRVC, Index (RAMV, 0x02))
                    If (LEqual (Arg0, 0x01))
                    {
                        Store (0x01, AIP)
                        Store (0x09, AIP2)
                        Store (0xB0, SCP)
                    }
                    Else
                    {
                        Store (0x02, AIP)
                        Store (0x0A, AIP2)
                        Store (0xB0, SCP)
                    }
                }

                Method (GSLI, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x03060000))
                    {
                        Store (0x00, Local1)
                        Store (ESLI (), Local0)
                        If (LEqual (Local0, 0x40))
                        {
                            Or (Local1, 0x01, Local1)
                        }

                        Store (NVSL (), Local2)
                        If (LEqual (Local2, 0x00))
                        {
                            Store (PCBV (), Local3)
                            If (LEqual (Local3, 0x01))
                            {
                                Store (CSLI (), Local0)
                                If (LEqual (Local0, 0x40))
                                {
                                    Or (Local1, 0x02, Local1)
                                }
                            }
                            Else
                            {
                                Store (DSLI (), Local0)
                                If (LEqual (Local0, 0x40))
                                {
                                    Or (Local1, 0x02, Local1)
                                }
                            }
                        }
                        Else
                        {
                            Store (DSLI (), Local0)
                            If (LEqual (Local0, 0x40))
                            {
                                Or (Local1, 0x02, Local1)
                            }
                        }

                        Store (Local1, Index (VCNT, 0x02))
                        Return (VCNT)
                    }

                    If (LEqual (Arg0, 0x03060001))
                    {
                        Store (0x00, Local1)
                        Store (NVSL (), Local0)
                        If (LEqual (Local0, 0x10))
                        {
                            Or (Local1, 0x01, Local1)
                        }

                        Store (Local1, Index (SLIS, 0x02))
                        Return (SLIS)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Name (VCNT, Package (0x04)
                {
                    0x03060000, 
                    0x01, 
                    0x01, 
                    0x01
                })
                Name (SLIS, Package (0x06)
                {
                    0x03060001, 
                    0x00, 
                    0x01, 
                    0x01, 
                    "Disabled", 
                    "Enabled"
                })
                Method (SSLI, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x03060001))
                    {
                        If (Arg1)
                        {
                            Store (SLIC, Local0)
                            Not (0x60, Local2)
                            And (Local0, Local2, Local0)
                            Store (0x00, Local1)
                            ShiftLeft (Local1, 0x05, Local1)
                            Or (Local0, Local1, Local0)
                            Store (Local0, SLIC)
                            Return (0x03)
                        }
                        Else
                        {
                            Store (SLIC, Local0)
                            Not (0x60, Local2)
                            And (Local0, Local2, Local0)
                            Store (0x01, Local1)
                            ShiftLeft (Local1, 0x05, Local1)
                            Or (Local0, Local1, Local0)
                            Store (Local0, SLIC)
                            Return (0x03)
                        }
                    }
                    Else
                    {
                        Return (0x01)
                    }
                }

                IndexField (CM2I, CM2D, ByteAcc, NoLock, Preserve)
                {
                    Offset (0xBD), 
                    SLIC,   8
                }

                Name (CQFN, Package (0x06)
                {
                    0x04060003, 
                    0x00, 
                    0x00, 
                    0x01, 
                    "Disabled", 
                    "Enabled"
                })
                Name (QFNR, Package (0x09)
                {
                    0x04050004, 
                    0x5A, 
                    0x00, 
                    0x01, 
                    "Auto", 
                    "90%", 
                    "80%", 
                    "70%", 
                    "60%"
                })
                Name (QFNT, Package (0x0F)
                {
                    0x04030005, 
                    0x42, 
                    0x05, 
                    0x01, 
                    "51", 
                    "54", 
                    "57", 
                    "60", 
                    "63", 
                    "66", 
                    "69", 
                    "72", 
                    "75", 
                    "78", 
                    "81"
                })
                Name (OC01, Package (0x06)
                {
                    0x01010000, 
                    "CPU FSB", 
                    0x4E20, 
                    0x9C40, 
                    0xC9, 
                    0x00010003
                })
                Name (OC02, Package (0x06)
                {
                    0x01060001, 
                    "CPU Multiplier", 
                    0x04, 
                    0x14, 
                    0x21, 
                    0x00010003
                })
                Name (OC0F, Package (0x06)
                {
                    0x01060002, 
                    "Hyper Transport Freq", 
                    0x01, 
                    0x05, 
                    0x05, 
                    0x00010003
                })
                Name (OC03, Package (0x06)
                {
                    0x02010002, 
                    "Memory Freq", 
                    0x00, 
                    0x00, 
                    0x04, 
                    0x00010003
                })
                Name (OC04, Package (0x06)
                {
                    0x07010003, 
                    "PCI Express", 
                    0x2710, 
                    0x332C, 
                    0x20, 
                    0x00
                })
                Name (OC05, Package (0x06)
                {
                    0x05050004, 
                    "OC Profile", 
                    0x69, 
                    0x82, 
                    0x05, 
                    0x00010003
                })
                Name (OC06, Package (0x06)
                {
                    0x08050005, 
                    "Turbo N.O.S.", 
                    0x67, 
                    0x6E, 
                    0x04, 
                    0x00010003
                })
                Name (OC07, Package (0x06)
                {
                    0x08050006, 
                    "Twin Turbo N.O.S.", 
                    0x00, 
                    0x01, 
                    0x02, 
                    0x00
                })
                Name (OC08, Package (0x06)
                {
                    0x04040007, 
                    "FAN-Boost", 
                    0x2EE0, 
                    0x36B0, 
                    0x02, 
                    0x00010001
                })
                Name (OC09, Package (0x06)
                {
                    0x01020008, 
                    "CPU Voltage", 
                    0x1F40, 
                    0x4074, 
                    0x44, 
                    0x00
                })
                Name (OC0A, Package (0x06)
                {
                    0x02020009, 
                    "DRAM Voltage", 
                    0x0A28, 
                    0x0BB8, 
                    0x09, 
                    0x00
                })
                Name (OC0B, Package (0x06)
                {
                    0x0702000A, 
                    "PCIE Voltage", 
                    0x0D05, 
                    0x115C, 
                    0x03, 
                    0x00
                })
                Name (OC0C, Package (0x06)
                {
                    0x0106000B, 
                    "CPU HT", 
                    0x00, 
                    0x01, 
                    0x02, 
                    0x00010002
                })
                Name (OC0G, Package (0x06)
                {
                    0x0106000C, 
                    "CoolnQuietFlag", 
                    0x00, 
                    0x01, 
                    0x02, 
                    0x00010001
                })
                Name (OC0D, Package (0x06)
                {
                    0x0906000C, 
                    "AI Overclock Tuner", 
                    0x00, 
                    0x04, 
                    0x05, 
                    0x00010003
                })
                Name (OBUF, Package (0x0D)
                {
                    OC01, 
                    OC02, 
                    OC03, 
                    OC04, 
                    OC05, 
                    OC06, 
                    OC07, 
                    OC08, 
                    OC09, 
                    OC0A, 
                    OC0B, 
                    OC0C, 
                    OC0D
                })
                Name (CPUO, Package (0x04)
                {
                    0x01010000, 
                    0x4E20, 
                    0x64, 
                    0x01
                })
                Name (CPUM, Package (0x04)
                {
                    0x01060001, 
                    0x0E, 
                    0x00, 
                    0x01
                })
                Name (HTFQ, Package (0x04)
                {
                    0x01060002, 
                    0x04, 
                    0x03, 
                    0x01
                })
                Name (MEMO, Package (0x09)
                {
                    0x02010002, 
                    0xD034, 
                    0x04, 
                    0x01, 
                    "Auto", 
                    "1:3", 
                    "1:4", 
                    "1:2", 
                    "3:8"
                })
                Name (PCIO, Package (0x04)
                {
                    0x07010003, 
                    0x2710, 
                    0x00, 
                    0x01
                })
                Name (OCPO, Package (0x08)
                {
                    0x05050004, 
                    0x64, 
                    0x00, 
                    0x01, 
                    "103%", 
                    "105%", 
                    "108%", 
                    "110%"
                })
                Name (AOCO, Package (0x09)
                {
                    0x08050005, 
                    0x64, 
                    0x00, 
                    0x01, 
                    "Disabled", 
                    "103%", 
                    "105%", 
                    "108%", 
                    "110%"
                })
                Name (ADCO, Package (0x06)
                {
                    0x08050006, 
                    0x00, 
                    0x00, 
                    0x00, 
                    "Disabled", 
                    "Enabled"
                })
                Name (FANB, Package (0x06)
                {
                    0x04040007, 
                    0x00, 
                    0x00, 
                    0x00, 
                    "Disabled", 
                    "Enabled"
                })
                Name (CPUV, Package (0x04)
                {
                    0x01020008, 
                    0x073A, 
                    0x01, 
                    0x01
                })
                Name (RAMV, Package (0x0C)
                {
                    0x02020009, 
                    0x0A8C, 
                    0x01, 
                    0x01, 
                    "1.850V", 
                    "1.900V", 
                    "1.950V", 
                    "2.000V", 
                    "2.100V", 
                    "2.150V", 
                    "2.200V", 
                    "2.300V"
                })
                Name (PCIV, Package (0x04)
                {
                    0x0702000A, 
                    0x0640, 
                    0x00, 
                    0x00
                })
                Name (PRHT, Package (0x04)
                {
                    0x0106000B, 
                    0x01, 
                    0x00, 
                    0x00
                })
                Name (CNQF, Package (0x04)
                {
                    0x0106000C, 
                    0x00, 
                    0x00, 
                    0x01
                })
                Name (AITM, Package (0x09)
                {
                    0x0906000C, 
                    0x00, 
                    0x00, 
                    0x01, 
                    "Manual", 
                    "Auto", 
                    "Standard", 
                    "OC Profile", 
                    "AI NOS"
                })
                Name (PREB, Package (0x1C)
                {
                    0x02010002, 
                    0x00, 
                    0x07010003, 
                    0x00, 
                    0x08050005, 
                    0x00, 
                    0x08050006, 
                    0x00, 
                    0x04040007, 
                    0x00, 
                    0x01020008, 
                    0x00, 
                    0x02020009, 
                    0x00, 
                    0x0702000A, 
                    0x00, 
                    0x0106000B, 
                    0x00, 
                    0x0906000C, 
                    0x00, 
                    0x04060003, 
                    0x00, 
                    0x04030005, 
                    0x00, 
                    0x01010000, 
                    0x00, 
                    0x01060001, 
                    0x00
                })
                Name (PRED, Package (0x0A)
                {
                    0x01010000, 
                    0x00, 
                    0x01060001, 
                    0x00, 
                    0x01020008, 
                    0x00, 
                    0x02020009, 
                    0x00, 
                    0x0702000A, 
                    0x00
                })
                Method (SPRD, 2, NotSerialized)
                {
                    Store (0x00, Local0)
                    Store (0x01, Local2)
                    While (Local2)
                    {
                        Multiply (Local0, 0x02, Local1)
                        If (LEqual (DerefOf (Index (PRED, Local1)), Arg0))
                        {
                            Add (Local1, 0x01, Local1)
                            Store (Arg1, Index (PRED, Local1))
                            Store (0x00, Local2)
                        }

                        Increment (Local0)
                        If (LEqual (Local0, 0x06))
                        {
                            Store (0x00, Local2)
                        }
                    }
                }

                Method (GPRE, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Return (PREB)
                    }
                    Else
                    {
                        Return (PRED)
                    }
                }

                Method (SPRE, 2, NotSerialized)
                {
                    Store (0x00, Local0)
                    Store (0x01, Local2)
                    While (Local2)
                    {
                        Multiply (Local0, 0x02, Local1)
                        If (LEqual (DerefOf (Index (PREB, Local1)), Arg0))
                        {
                            Add (Local1, 0x01, Local1)
                            Store (Arg1, Index (PREB, Local1))
                            Store (0x00, Local2)
                        }

                        Increment (Local0)
                        If (LEqual (Local0, 0x10))
                        {
                            Store (0x00, Local2)
                        }
                    }
                }

                Method (GCQV, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x00))
                    {
                        Store (K8VL, Local0)
                        Return (Local0)
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x01))
                        {
                            Store (K8VH, Local0)
                            Return (Local0)
                        }
                        Else
                        {
                            If (LEqual (Arg0, 0x02))
                            {
                                If (LEqual (CNQC, 0x00))
                                {
                                    Store (0x01, Local0)
                                }
                                Else
                                {
                                    Store (0x00, Local0)
                                }

                                Return (Local0)
                            }
                        }
                    }
                }
            }

            Name (BUFA, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {3,4,5,7,9,10,11,12,14,15}
            })
            Name (BUFB, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, _Y02)
                    {}
            })
            CreateWordField (BUFB, \_SB.PCI0._Y02._INT, IRQV)  // _INT: Interrupts
            Method (CRS, 1, NotSerialized)
            {
                If (Arg0)
                {
                    ShiftLeft (0x01, Arg0, IRQV)
                }
                Else
                {
                    Store (Zero, IRQV)
                }

                Return (BUFB)
            }

            Method (SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRQ0)
                FindSetRightBit (IRQ0, Local0)
                Decrement (Local0)
                Return (Local0)
            }

            Method (CRSB, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x01))
                {
                    Return (0x11)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Return (0x12)
                }

                If (LEqual (Arg0, 0x08))
                {
                    Return (0x10)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Return (0x13)
                }

                Return (Arg0)
            }

            Method (CRSA, 1, Serialized)
            {
                Store (0x00, Local0)
                If (LEqual (Arg0, 0x08))
                {
                    Store (0x14, Local0)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x15, Local0)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x16, Local0)
                }

                If (LEqual (Arg0, 0x01))
                {
                    Store (0x17, Local0)
                }

                Name (IRZ5, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, _Y03)
                    {
                        0x00000007,
                    }
                })
                CreateWordField (IRZ5, \_SB.PCI0.CRSA._Y03._INT, INZ5)  // _INT: Interrupts
                Store (Local0, INZ5)
                Return (IRZ5)
            }

            Method (SRSA, 1, Serialized)
            {
                CreateWordField (Arg0, 0x05, INZ6)
                Store (0x08, Local0)
                If (LEqual (INZ6, 0x14))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (INZ6, 0x15))
                {
                    Store (0x0D, Local0)
                }

                If (LEqual (INZ6, 0x16))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (INZ6, 0x17))
                {
                    Store (0x01, Local0)
                }

                Return (Local0)
            }

            Device (LNK1)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTA)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTA)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTA))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTA)
                }
            }

            Device (LNK2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTB)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTB)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTB))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTB)
                }
            }

            Device (LNK3)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTC)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTC)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTC))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTC)
                }
            }

            Device (LNK4)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x04)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTD)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTD)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTD))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTD)
                }
            }

            Device (LNK5)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x05)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTE)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTE)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTE))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTE)
                }
            }

            Device (LUBA)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x06)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTG)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTG)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTG))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTG)
                }
            }

            Device (LUBB)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x07)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTH)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTH)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTH))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTH)
                }
            }

            Device (LMAC)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x08)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTJ)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTJ)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTJ))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTJ)
                }
            }

            Device (LACI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0A)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTL)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTL)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTL))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTL)
                }
            }

            Device (LMCI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0B)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTM)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTM)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTM))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTM)
                }
            }

            Device (LSMB)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0C)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTF)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTF)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTF))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTF)
                }
            }

            Device (LUB2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0D)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTQ)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTQ)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTQ))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTQ)
                }
            }

            Device (LIDE)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x10)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTN)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTN)
                    Store (0x00, INTP)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (INTN))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), INTN)
                    Store (SRS (Arg0), INTP)
                }
            }

            Device (LSID)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x11)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (ITID)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, ITID)
                    Store (0x00, SSAI)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (ITID))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), ITID)
                    Store (SRS (Arg0), SSAI)
                }
            }

            Device (LFID)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x12)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IS0P)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IS0P)
                    Store (0x00, IS0S)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (IS0P))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), IS0P)
                    Store (SRS (Arg0), IS0S)
                }
            }

            Device (LPCA)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x13)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IPCA)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IPCA)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRS (IPCA))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRS (Arg0), IPCA)
                }
            }

            Name (BUF1, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x00000010,
                }
            })
            Name (BUF2, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x00000011,
                }
            })
            Name (BUF3, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x00000012,
                }
            })
            Name (BUF4, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x00000013,
                }
            })
            Name (BUFF, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x00000014,
                    0x00000015,
                    0x00000016,
                    0x00000017,
                }
            })
            Name (BUFH, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x0000000B,
                }
            })
            Name (BUFI, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, )
                {
                    0x00000017,
                }
            })
            Name (IRZ1, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveLow, Shared, ,, _Y04)
                {
                    0x00000007,
                }
            })
            Device (APC1)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x14)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTA, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUF1)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTA)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateWordField (IRZ1, \_SB.PCI0._Y04._INT, IRQ1)  // _INT: Interrupts
                    Store (CRSB (INTA), IRQ1)
                    Return (IRZ1)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (0x08, INTA)
                }
            }

            Device (APC2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x15)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTB, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUF2)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTB)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateWordField (IRZ1, \_SB.PCI0._Y04._INT, IRQ1)  // _INT: Interrupts
                    Store (CRSB (INTB), IRQ1)
                    Return (IRZ1)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (0x01, INTB)
                }
            }

            Device (APC3)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x16)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTC, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUF3)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTC)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateWordField (IRZ1, \_SB.PCI0._Y04._INT, IRQ1)  // _INT: Interrupts
                    Store (CRSB (INTC), IRQ1)
                    Return (IRZ1)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (0x02, INTC)
                }
            }

            Device (APC4)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x17)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTD, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUF4)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTD)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateWordField (IRZ1, \_SB.PCI0._Y04._INT, IRQ1)  // _INT: Interrupts
                    Store (CRSB (INTD), IRQ1)
                    Return (IRZ1)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (0x0D, INTD)
                }
            }

            Device (APC5)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x18)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTE, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUF1)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTE)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (BUF1)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (0x08, INTE)
                }
            }

            Device (APCF)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x19)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTG, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTG)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTG))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTG)
                }
            }

            Device (APCG)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1A)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTH, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTH)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTH))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTH)
                }
            }

            Device (APCH)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1B)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTJ, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTJ)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTJ))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTJ)
                }
            }

            Device (APCJ)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1D)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTL, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTL)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTL))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTL)
                }
            }

            Device (APCK)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1E)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTM, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTM)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTM))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTM)
                }
            }

            Device (APCS)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1F)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTF, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTF)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTF))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTF)
                }
            }

            Device (APCL)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x20)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTQ, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTQ)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTQ))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTQ)
                }
            }

            Device (APCZ)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x23)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (INTN, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTN)
                    Store (0x00, INTP)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (INTN))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), INTN)
                    Store (SRSA (Arg0), INTP)
                }
            }

            Device (APSI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x24)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (ITID, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, ITID)
                    Store (0x00, SSAI)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (ITID))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), ITID)
                    Store (SRSA (Arg0), SSAI)
                }
            }

            Device (APSJ)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x25)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (IS0P, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IS0P)
                    Store (0x00, IS0S)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (IS0P))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), IS0P)
                    Store (SRSA (Arg0), IS0S)
                }
            }

            Device (APCP)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x26)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LAnd (IPCA, PICF))
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFF)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IPCA)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Return (CRSA (IPCA))
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    Store (SRSA (Arg0), IPCA)
                }
            }

            Scope (\)
            {
                OperationRegion (\SCPP, SystemIO, 0x442E, 0x01)
                Field (\SCPP, ByteAcc, NoLock, Preserve)
                {
                    SMIP,   8
                }
            }

            Method (\_SB.PCI0._INI, 0, NotSerialized)  // _INI: Initialize
            {
                If (STRC (\_OS, "Microsoft Windows"))
                {
                    Store (0x56, SMIP)
                }
                Else
                {
                    If (STRC (\_OS, "Microsoft Windows NT"))
                    {
                        If (CondRefOf (\_OSI, Local0))
                        {
                            If (\_OSI ("Windows 2001"))
                            {
                                Store (0x59, SMIP)
                                Store (0x00, OSFL)
                                Store (0x03, OSFX)
                            }
                        }
                        Else
                        {
                            Store (0x58, SMIP)
                            Store (0x00, OSFX)
                            Store (0x00, OSFL)
                        }
                    }
                    Else
                    {
                        Store (0x57, SMIP)
                        Store (0x02, OSFX)
                        Store (0x02, OSFL)
                    }
                }

                Name (TEMP, 0x00)
                Store (UA1D, TEMP)
                And (TEMP, 0x0F, TEMP)
                ShiftLeft (0x01, TEMP, UARA)
                Store (UA1D, TEMP)
                And (TEMP, 0xF0, TEMP)
                ShiftRight (TEMP, 0x04, TEMP)
                ShiftLeft (0x01, TEMP, UARB)
            }

            Scope (\)
            {
                Method (OSTP, 0, NotSerialized)
                {
                    If (LEqual (OSFX, 0x01))
                    {
                        Store (0x56, SMIP)
                    }

                    If (LEqual (OSFX, 0x02))
                    {
                        Store (0x57, SMIP)
                    }

                    If (LEqual (OSFX, 0x00))
                    {
                        Store (0x58, SMIP)
                    }

                    If (LEqual (OSFX, 0x03))
                    {
                        Store (0x59, SMIP)
                    }
                }
            }

            Device (SYSR)
            {
                Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0010,             // Range Minimum
                        0x0010,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x0022,             // Range Minimum
                        0x0022,             // Range Maximum
                        0x01,               // Alignment
                        0x1E,               // Length
                        )
                    IO (Decode16,
                        0x0044,             // Range Minimum
                        0x0044,             // Range Maximum
                        0x01,               // Alignment
                        0x1C,               // Length
                        )
                    IO (Decode16,
                        0x0062,             // Range Minimum
                        0x0062,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0065,             // Range Minimum
                        0x0065,             // Range Maximum
                        0x01,               // Alignment
                        0x0B,               // Length
                        )
                    IO (Decode16,
                        0x0074,             // Range Minimum
                        0x0074,             // Range Maximum
                        0x01,               // Alignment
                        0x0C,               // Length
                        )
                    IO (Decode16,
                        0x0091,             // Range Minimum
                        0x0091,             // Range Maximum
                        0x01,               // Alignment
                        0x03,               // Length
                        )
                    IO (Decode16,
                        0x00A2,             // Range Minimum
                        0x00A2,             // Range Maximum
                        0x01,               // Alignment
                        0x1E,               // Length
                        )
                    IO (Decode16,
                        0x00E0,             // Range Minimum
                        0x00E0,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x04D0,             // Range Minimum
                        0x04D0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0800,             // Range Minimum
                        0x0800,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                    IO (Decode16,
                        0x0290,             // Range Minimum
                        0x0290,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                })
            }

            Device (PIC)
            {
                Name (_HID, EisaId ("PNP0000"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0020,             // Range Minimum
                        0x0020,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00A0,             // Range Minimum
                        0x00A0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IRQNoFlags ()
                        {2}
                })
            }

            Device (DMA1)
            {
                Name (_HID, EisaId ("PNP0200"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    DMA (Compatibility, BusMaster, Transfer8, )
                        {4}
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x0080,             // Range Minimum
                        0x0080,             // Range Maximum
                        0x01,               // Alignment
                        0x11,               // Length
                        )
                    IO (Decode16,
                        0x0094,             // Range Minimum
                        0x0094,             // Range Maximum
                        0x01,               // Alignment
                        0x0C,               // Length
                        )
                    IO (Decode16,
                        0x00C0,             // Range Minimum
                        0x00C0,             // Range Maximum
                        0x01,               // Alignment
                        0x20,               // Length
                        )
                })
            }

            Device (TMR)
            {
                Name (_HID, EisaId ("PNP0100"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0040,             // Range Minimum
                        0x0040,             // Range Maximum
                        0x01,               // Alignment
                        0x04,               // Length
                        )
                    IRQNoFlags ()
                        {0}
                })
            }

            Device (RTC)
            {
                Name (_HID, EisaId ("PNP0B00"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0070,             // Range Minimum
                        0x0070,             // Range Maximum
                        0x04,               // Alignment
                        0x04,               // Length
                        )
                    IRQNoFlags ()
                        {8}
                })
            }

            Device (SPKR)
            {
                Name (_HID, EisaId ("PNP0800"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0061,             // Range Minimum
                        0x0061,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                })
            }

            Device (COPR)
            {
                Name (_HID, EisaId ("PNP0C04"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x00F0,             // Range Minimum
                        0x00F0,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IRQNoFlags ()
                        {13}
                })
            }

            Scope (\)
            {
                OperationRegion (WIN1, SystemIO, 0x2E, 0x02)
                Field (WIN1, ByteAcc, NoLock, Preserve)
                {
                    INDP,   8, 
                    DATP,   8
                }

                IndexField (INDP, DATP, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x02), 
                    CFG,    8, 
                    Offset (0x07), 
                    LDN,    8, 
                    Offset (0x20), 
                    IDHI,   8, 
                    IDLO,   8, 
                    POWC,   8, 
                    Offset (0x30), 
                    ACTR,   8, 
                    Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IO2H,   8, 
                    IO2L,   8, 
                    Offset (0x70), 
                    INTR,   8, 
                    Offset (0x72), 
                    INT1,   8, 
                    Offset (0x74), 
                    DMCH,   8, 
                    Offset (0xF0), 
                    OPT1,   8, 
                    OPT2,   8, 
                    OPT3,   8
                }

                Method (ENFG, 0, NotSerialized)
                {
                    Store (0x87, INDP)
                    Store (0x01, INDP)
                    Store (0x55, INDP)
                    Store (0x55, INDP)
                    Or (POWC, 0x80, POWC)
                }

                Method (EXFG, 0, NotSerialized)
                {
                    Store (0x02, CFG)
                }

                Method (GSRG, 1, NotSerialized)
                {
                    Store (Arg0, INDP)
                    Return (DATP)
                }

                Method (SSRG, 2, NotSerialized)
                {
                    Store (Arg0, INDP)
                    Store (Arg1, DATP)
                }
            }

            Device (FDC0)
            {
                Name (_HID, EisaId ("PNP0700"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (Zero, LDN)
                    If (ACTR)
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LOr (IOAH, IOAL))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x00, LDN)
                    Store (Zero, ACTR)
                    SLDM (DMCH, 0x04)
                    EXFG ()
                    DISD (0x03)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF0, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x03F0,             // Range Minimum
                            0x03F0,             // Range Maximum
                            0x01,               // Alignment
                            0x06,               // Length
                            _Y05)
                        IO (Decode16,
                            0x03F7,             // Range Minimum
                            0x03F7,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {6}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {2}
                    })
                    CreateByteField (BUF0, \_SB.PCI0.FDC0._CRS._Y05._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF0, 0x03, IOHI)
                    CreateByteField (BUF0, \_SB.PCI0.FDC0._CRS._Y05._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF0, 0x05, IORH)
                    ENFG ()
                    EXFG ()
                    Return (BUF0)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03F0,             // Range Minimum
                            0x03F0,             // Range Maximum
                            0x01,               // Alignment
                            0x06,               // Length
                            )
                        IO (Decode16,
                            0x03F7,             // Range Minimum
                            0x03F7,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {6}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {2}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x19, IRQW)
                    CreateByteField (Arg0, 0x1C, DMAV)
                    ENFG ()
                    Store (Zero, LDN)
                    Store (One, ACTR)
                    SLDM (DMCH, DMCH)
                    CKIO (IOAD, 0x03)
                    EXFG ()
                }
            }

            Device (UAR1)
            {
                Name (_HID, EisaId ("PNP0501"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x01, LDN)
                    If (ACTR)
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LOr (IOAH, IOAL))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }

                    EXFG ()
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x01, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x00)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y06)
                        IRQNoFlags (_Y07)
                            {}
                    })
                    CreateByteField (BUF1, \_SB.PCI0.UAR1._CRS._Y06._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x03, IOHI)
                    CreateByteField (BUF1, \_SB.PCI0.UAR1._CRS._Y06._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x05, IORH)
                    CreateWordField (BUF1, \_SB.PCI0.UAR1._CRS._Y07._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x01, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    Store (One, Local0)
                    ShiftLeft (Local0, INTR, IRQW)
                    EXFG ()
                    Return (BUF1)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03F8,             // Range Minimum
                            0x03F8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x02F8,             // Range Minimum
                            0x02F8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03E8,             // Range Minimum
                            0x03E8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x02E8,             // Range Minimum
                            0x02E8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x09, IRQW)
                    ENFG ()
                    Store (0x01, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetRightBit (IRQW, Local0)
                    Subtract (Local0, 0x01, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x00)
                }
            }

            Device (UAR2)
            {
                Method (_HID, 0, NotSerialized)  // _HID: Hardware ID
                {
                    ENFG ()
                    Store (0x02, LDN)
                    And (OPT1, 0x70, Local0)
                    If (LEqual (Local0, 0x40))
                    {
                        Return (0x05878526)
                    }
                    Else
                    {
                        Return (0x0105D041)
                    }

                    EXFG ()
                }

                Name (_UID, 0x02)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x02, LDN)
                    And (OPT1, 0x70, Local0)
                    If (LNotEqual (Local0, 0x10))
                    {
                        If (ACTR)
                        {
                            EXFG ()
                            Return (0x0F)
                        }
                        Else
                        {
                            If (LOr (IOAH, IOAL))
                            {
                                EXFG ()
                                Return (0x0D)
                            }
                            Else
                            {
                                EXFG ()
                                Return (0x00)
                            }
                        }
                    }
                    Else
                    {
                        EXFG ()
                        Return (0x00)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x02, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x01)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y08)
                        IRQNoFlags (_Y09)
                            {4}
                    })
                    CreateByteField (BUF2, \_SB.PCI0.UAR2._CRS._Y08._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF2, 0x03, IOHI)
                    CreateByteField (BUF2, \_SB.PCI0.UAR2._CRS._Y08._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF2, 0x05, IORH)
                    CreateWordField (BUF2, \_SB.PCI0.UAR2._CRS._Y09._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x02, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    Store (One, Local0)
                    ShiftLeft (Local0, INTR, IRQW)
                    EXFG ()
                    Return (BUF2)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03F8,             // Range Minimum
                            0x03F8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x02F8,             // Range Minimum
                            0x02F8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03E8,             // Range Minimum
                            0x03E8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x02E8,             // Range Minimum
                            0x02E8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x09, IRQW)
                    ENFG ()
                    Store (0x02, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetRightBit (IRQW, Local0)
                    Subtract (Local0, 0x01, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x01)
                }
            }

            Device (LPT1)
            {
                Name (_HID, EisaId ("PNP0400"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x03, LDN)
                    And (OPT1, 0x02, Local0)
                    If (LNotEqual (Local0, 0x02))
                    {
                        If (ACTR)
                        {
                            EXFG ()
                            Return (0x0F)
                        }
                        Else
                        {
                            If (LOr (IOAH, IOAL))
                            {
                                EXFG ()
                                Return (0x0D)
                            }
                            Else
                            {
                                EXFG ()
                                Return (0x00)
                            }
                        }
                    }
                    Else
                    {
                        EXFG ()
                        Return (0x00)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x03, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x02)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF5, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y0A)
                        IRQNoFlags (_Y0B)
                            {}
                    })
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y0A._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF5, 0x03, IOHI)
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y0A._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF5, 0x05, IORH)
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y0A._LEN, IOLE)  // _LEN: Length
                    CreateWordField (BUF5, \_SB.PCI0.LPT1._CRS._Y0B._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x03, LDN)
                    Store (IOAL, IOLO)
                    Store (IOLO, IORL)
                    Store (IOAH, IOHI)
                    Store (IOHI, IORH)
                    If (LEqual (IOLO, 0xBC))
                    {
                        Store (0x04, IOLE)
                    }
                    Else
                    {
                        Store (0x08, IOLE)
                    }

                    Store (One, Local0)
                    Store (INTR, Local5)
                    ShiftLeft (Local0, Local5, IRQW)
                    EXFG ()
                    Return (BUF5)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0378,             // Range Minimum
                            0x0378,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0278,             // Range Minimum
                            0x0278,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03BC,             // Range Minimum
                            0x03BC,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateByteField (Arg0, 0x04, IORL)
                    CreateByteField (Arg0, 0x05, IORH)
                    CreateWordField (Arg0, 0x09, IRQW)
                    ENFG ()
                    Store (0x03, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetLeftBit (IRQW, Local0)
                    Subtract (Local0, 0x01, Local0)
                    Store (Local0, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x02)
                }
            }

            Device (ECP1)
            {
                Name (_HID, EisaId ("PNP0401"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x03, LDN)
                    And (OPT1, 0x02, Local0)
                    If (LEqual (Local0, 0x02))
                    {
                        If (ACTR)
                        {
                            EXFG ()
                            Return (0x0F)
                        }
                        Else
                        {
                            If (LOr (IOAH, IOAL))
                            {
                                EXFG ()
                                Return (0x0D)
                            }
                            Else
                            {
                                EXFG ()
                                Return (0x00)
                            }
                        }
                    }
                    Else
                    {
                        EXFG ()
                        Return (0x00)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x03, LDN)
                    Store (Zero, ACTR)
                    SLDM (DMCH, 0x04)
                    EXFG ()
                    DISD (0x02)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF6, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            _Y0C)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            _Y0D)
                        IRQNoFlags (_Y0E)
                            {}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y0F)
                            {}
                    })
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0C._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF6, 0x03, IOHI)
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0C._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF6, 0x05, IORH)
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0C._LEN, IOLE)  // _LEN: Length
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0D._MIN, IOEL)  // _MIN: Minimum Base Address
                    CreateByteField (BUF6, 0x0B, IOEH)
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0D._MAX, IOML)  // _MAX: Maximum Base Address
                    CreateByteField (BUF6, 0x0D, IOMH)
                    CreateWordField (BUF6, \_SB.PCI0.ECP1._CRS._Y0E._INT, IRQW)  // _INT: Interrupts
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0F._DMA, DMAC)  // _DMA: Direct Memory Access
                    ENFG ()
                    Store (0x03, LDN)
                    Store (IOAL, Local2)
                    Store (Local2, IOLO)
                    Store (IOAH, Local3)
                    Store (Local3, IOHI)
                    Or (Local3, 0x04, Local3)
                    Store (Local3, IOEH)
                    Store (Local3, IOMH)
                    Store (IOLO, IORL)
                    Store (IOLO, IOEL)
                    Store (IOLO, IOML)
                    Store (IOHI, IORH)
                    If (LEqual (IOLO, 0xBC))
                    {
                        Store (0x04, IOLE)
                    }
                    Else
                    {
                        Store (0x08, IOLE)
                    }

                    Store (One, Local0)
                    Store (INTR, Local5)
                    ShiftLeft (Local0, Local5, IRQW)
                    Store (One, Local0)
                    Store (DMCH, Local5)
                    ShiftLeft (Local0, Local5, DMAC)
                    EXFG ()
                    Return (BUF6)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0378,             // Range Minimum
                            0x0378,             // Range Maximum
                            0x00,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0778,             // Range Minimum
                            0x0778,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {0,1,3}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0278,             // Range Minimum
                            0x0278,             // Range Maximum
                            0x00,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0678,             // Range Minimum
                            0x0678,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {0,1,3}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03BC,             // Range Minimum
                            0x03BC,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x07BC,             // Range Minimum
                            0x07BC,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {0,1,3}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x11, IRQW)
                    CreateByteField (Arg0, 0x14, DMAC)
                    ENFG ()
                    Store (0x03, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetLeftBit (IRQW, Local0)
                    Subtract (Local0, 0x01, Local0)
                    Store (Local0, INTR)
                    FindSetLeftBit (DMAC, Local1)
                    Store (DMCH, Local0)
                    Subtract (Local1, 0x01, DMCH)
                    SLDM (Local0, DMCH)
                    EXFG ()
                    CKIO (IOAD, 0x02)
                }
            }

            OperationRegion (KBCT, SystemIO, 0x60, 0x05)
            Field (KBCT, ByteAcc, NoLock, Preserve)
            {
                P060,   8, 
                Offset (0x04), 
                P064,   8
            }

            Device (PS2M)
            {
                Name (_HID, EisaId ("PNP0F13"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (PS2F, 0x00))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (BUF2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    If (LEqual (KBDI, 0x01))
                    {
                        If (LEqual (OSFL, 0x02))
                        {
                            Return (BUF1)
                        }

                        If (LEqual (OSFL, 0x01))
                        {
                            Return (BUF1)
                        }
                        Else
                        {
                            Return (BUF2)
                        }
                    }
                    Else
                    {
                        Return (BUF1)
                    }
                }
            }

            Device (PS2K)
            {
                Name (_HID, EisaId ("PNP0303"))  // _HID: Hardware ID
                Name (_CID, EisaId ("PNP030B"))  // _CID: Compatible ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (KBDI, 0x01))
                    {
                        Return (0x00)
                    }
                    Else
                    {
                        Return (0x0F)
                    }
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0060,             // Range Minimum
                        0x0060,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0064,             // Range Minimum
                        0x0064,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IRQNoFlags ()
                        {1}
                })
            }

            Device (PSMR)
            {
                Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (KBDI, 0x00))
                    {
                        Return (0x00)
                    }

                    If (LEqual (PS2F, 0x00))
                    {
                        If (LEqual (OSFL, 0x02))
                        {
                            Return (0x0F)
                        }

                        If (LEqual (OSFL, 0x01))
                        {
                            Return (0x0F)
                        }

                        Return (0x00)
                    }

                    Return (0x00)
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0060,             // Range Minimum
                        0x0060,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0064,             // Range Minimum
                        0x0064,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                })
            }

            Method (PS2W, 0, NotSerialized)
            {
                ENFG ()
                Store (GSRG (0x07), Local0)
                SSRG (0x07, 0x04)
                Store (GSRG (0xF1), Local1)
                If (And (Local1, 0x10))
                {
                    Notify (\_SB.PCI0.PS2M, 0x02)
                }

                If (And (Local1, 0x08))
                {
                    Notify (\_SB.PCI0.PS2K, 0x02)
                }

                SSRG (0xF1, 0xFF)
                SSRG (0x07, Local0)
                EXFG ()
            }

            Method (\_SB.PCI0.PS2M._PSW, 1, NotSerialized)  // _PSW: Power State Wake
            {
                ENFG ()
                Store (GSRG (0x07), Local0)
                SSRG (0x07, 0x04)
                Store (GSRG (0xF0), Local1)
                If (Arg0)
                {
                    Or (Local1, 0x10, Local1)
                }
                Else
                {
                    And (Local1, 0xEF, Local1)
                }

                SSRG (0xF0, Local1)
                SSRG (0x07, Local0)
                EXFG ()
            }

            Method (\_SB.PCI0.PS2K._PSW, 1, NotSerialized)  // _PSW: Power State Wake
            {
                ENFG ()
                Store (GSRG (0x07), Local0)
                SSRG (0x07, 0x04)
                Store (GSRG (0xF0), Local1)
                If (Arg0)
                {
                    Or (Local1, 0x08, Local1)
                }
                Else
                {
                    And (Local1, 0xF7, Local1)
                }

                SSRG (0xF0, Local1)
                SSRG (0x07, Local0)
                EXFG ()
            }

            Device (MIDI)
            {
                Name (_HID, EisaId ("PNPB006"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x08, LDN)
                    If (ACTR)
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LOr (IOAH, IOAL))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }

                    EXFG ()
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x08, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x05)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            _Y10)
                        IRQNoFlags (_Y11)
                            {}
                    })
                    CreateByteField (BUF1, \_SB.PCI0.MIDI._CRS._Y10._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x03, IOHI)
                    CreateByteField (BUF1, \_SB.PCI0.MIDI._CRS._Y10._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x05, IORH)
                    CreateWordField (BUF1, \_SB.PCI0.MIDI._CRS._Y11._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x08, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    Store (One, Local0)
                    ShiftLeft (Local0, INTR, IRQW)
                    EXFG ()
                    Return (BUF1)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0330,             // Range Minimum
                            0x0330,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0300,             // Range Minimum
                            0x0300,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x09, IRQW)
                    ENFG ()
                    Store (0x08, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetRightBit (IRQW, Local0)
                    Subtract (Local0, 0x01, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x05)
                }
            }

            Device (GAME)
            {
                Name (_HID, EisaId ("PNPB02F"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x09, LDN)
                    If (ACTR)
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LOr (IOAH, IOAL))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }

                    EXFG ()
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x09, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x04)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            _Y12)
                    })
                    CreateByteField (BUF1, \_SB.PCI0.GAME._CRS._Y12._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x03, IOHI)
                    CreateByteField (BUF1, \_SB.PCI0.GAME._CRS._Y12._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x05, IORH)
                    ENFG ()
                    Store (0x09, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    EXFG ()
                    Return (BUF1)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0201,             // Range Minimum
                            0x0201,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0209,             // Range Minimum
                            0x0209,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    ENFG ()
                    Store (0x09, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    EXFG ()
                    CKIO (IOAD, 0x04)
                }
            }

            Method (\_SB.PCI0.UAR1._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x03, 
                    0x05
                })
            }

            Method (\_SB.PCI0.PS2K._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x10, 
                    0x04
                })
            }

            Method (\_SB.PCI0.PS2M._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x10, 
                    0x04
                })
            }
        }

        OperationRegion (ACPM, SystemMemory, 0x7FFF2C00, 0x0400)
        Field (ACPM, ByteAcc, NoLock, Preserve)
        {
            FSBF,   16, 
            MULF,   8, 
            NOS1,   8, 
            NOS2,   8, 
            AITU,   8, 
            NOSM,   8, 
            VCRV,   8, 
            DDRV,   8, 
            QFNE,   8, 
            QFTE,   8, 
            MMCM,   8, 
            MUCM,   8, 
            DRVC,   8, 
            CNQC,   8, 
            K8VH,   16, 
            K8VL,   16, 
            K8HT,   8, 
            CVCM,   8, 
            MVCM,   16, 
            FIDC,   8, 
            AIBC,   8, 
            AIP,    8, 
            AIP2,   8
        }

        Device (MEM)
        {
            Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (BUF0, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x000F0000,         // Address Base
                        0x00004000,         // Address Length
                        _Y14)
                    Memory32Fixed (ReadWrite,
                        0x000F4000,         // Address Base
                        0x00004000,         // Address Length
                        _Y15)
                    Memory32Fixed (ReadWrite,
                        0x000F8000,         // Address Base
                        0x00004000,         // Address Length
                        _Y16)
                    Memory32Fixed (ReadWrite,
                        0x000FC000,         // Address Base
                        0x00004000,         // Address Length
                        _Y17)
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00010000,         // Address Length
                        _Y13)
                    Memory32Fixed (ReadWrite,
                        0xFFFF0000,         // Address Base
                        0x00010000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x000A0000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0x00100000,         // Address Base
                        0x00000000,         // Address Length
                        _Y18)
                    Memory32Fixed (ReadWrite,
                        0xFEC00000,         // Address Base
                        0x00001000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFEE00000,         // Address Base
                        0x00100000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFEFFF000,         // Address Base
                        0x00001000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFFF80000,         // Address Base
                        0x00001000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFFF90000,         // Address Base
                        0x00030000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFFFED000,         // Address Base
                        0x00003000,         // Address Length
                        )
                })
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y13._BAS, ACMM)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y14._BAS, RMA1)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y14._LEN, RSS1)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y15._BAS, RMA2)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y15._LEN, RSS2)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y16._BAS, RMA3)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y16._LEN, RSS3)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y17._BAS, RMA4)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y17._LEN, RSS4)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y18._LEN, EXTM)  // _LEN: Length
                Subtract (AMEM, 0x00100000, EXTM)
                If (LNotEqual (ROM1, Zero))
                {
                    Store (RMA1, RMA2)
                    ShiftLeft (ROM1, 0x08, Local0)
                    Store (Local0, RMA1)
                    ShiftLeft (RMS1, 0x08, Local0)
                    Store (Local0, RSS1)
                    Store (0x8000, RSS2)
                }

                If (LNotEqual (ROM2, Zero))
                {
                    Store (RMA2, RMA3)
                    ShiftLeft (ROM2, 0x08, Local0)
                    Store (Local0, RMA2)
                    ShiftLeft (RMS2, 0x08, Local0)
                    Store (Local0, RSS2)
                    Store (0xC000, RSS3)
                }

                If (LNotEqual (ROM3, Zero))
                {
                    Store (RMA3, RMA4)
                    ShiftLeft (ROM3, 0x08, Local0)
                    Store (Local0, RMA3)
                    ShiftLeft (RMS3, 0x08, Local0)
                    Store (Local0, RSS3)
                    Store (0x00010000, RSS4)
                }

                Store (AMEM, ACMM)
                Return (BUF0)
            }
        }

        Device (\_SB.PCI0.EXPL)
        {
            Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
            Name (_UID, 0x04)  // _UID: Unique ID
            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (BUF0, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xE0000000,         // Address Base
                        0x10000000,         // Address Length
                        )
                })
                Return (BUF0)
            }
        }
    }

    OperationRegion (TEMM, SystemMemory, 0x000FF810, 0x0C)
    Field (TEMM, WordAcc, NoLock, Preserve)
    {
        TP1H,   16, 
        TP1L,   16, 
        TP2H,   16, 
        TP2L,   16, 
        TRPC,   16, 
        SENF,   16
    }

    Name (TVAR, Buffer (0x05)
    {
         0x00, 0x00, 0x00, 0x00, 0x00
    })
    CreateByteField (TVAR, 0x00, PLCY)
    CreateWordField (TVAR, 0x01, CTOS)
    CreateWordField (TVAR, 0x03, CTHY)
    Name (TBUF, Buffer (0x04)
    {
         0x00, 0x00, 0x00, 0x00
    })
    CreateByteField (TBUF, 0x00, DB00)
    CreateByteField (TBUF, 0x01, DB01)
    CreateWordField (TBUF, 0x00, DW00)
    CreateWordField (TBUF, 0x02, DW01)
    CreateDWordField (TBUF, 0x00, DATD)
    OperationRegion (IP, SystemIO, 0x0295, 0x02)
    Field (IP, ByteAcc, NoLock, Preserve)
    {
        INDX,   8, 
        DAT0,   8
    }

    Method (SCFG, 1, NotSerialized)
    {
        SBYT (0x40, Arg0)
    }

    Method (STOS, 3, NotSerialized)
    {
        Divide (Arg2, 0x0A, Local0)
        If (LGreater (Local0, 0x0111))
        {
            Subtract (Local0, 0x0111, Local0)
        }
        Else
        {
            Subtract (0x0111, Local0, Local0)
            Or (Local0, 0x80, Local0)
        }

        SBYT (0x40, Local0)
    }

    Method (STHY, 3, NotSerialized)
    {
        Divide (Arg2, 0x0A, Local0)
        If (LGreater (Local0, 0x0111))
        {
            Subtract (Local0, 0x0111, Local0)
        }
        Else
        {
            Subtract (0x0111, Local0, Local0)
            Or (Local0, 0x80, Local0)
        }

        SBYT (0x41, Local0)
    }

    Method (RTMP, 0, NotSerialized)
    {
        Store (GBYT (0x29), Local0)
        FindSetLeftBit (Local0, Local1)
        If (LEqual (Local1, 0x08))
        {
            And (Local0, 0x7F, Local0)
            Multiply (Local0, 0x0A, Local0)
            Subtract (0x0AAC, Local0, Local0)
        }
        Else
        {
            Multiply (Local0, 0x0A, Local0)
            Add (0x0AAC, Local0, Local0)
        }

        If (LEqual (SSHU, 0x01))
        {
            Return (0x0C3C)
        }
        Else
        {
            Return (Local0)
        }
    }

    Method (SBYT, 2, NotSerialized)
    {
        Store (Arg0, INDX)
        Store (Arg1, DAT0)
    }

    Method (GBYT, 1, NotSerialized)
    {
        Store (Arg0, INDX)
        Store (DAT0, Local0)
        Return (Local0)
    }

    Method (SFAN, 1, NotSerialized)
    {
        And (SENF, 0x02, Local0)
        If (LEqual (Local0, Zero))
        {
            If (LEqual (Arg0, Zero))
            {
                FOFF ()
            }
            Else
            {
                FON ()
            }
        }
    }

    Method (FON, 0, NotSerialized)
    {
        SBYT (0x14, 0x00)
    }

    Method (FOFF, 0, NotSerialized)
    {
        XOr (0x00, 0x03, Local0)
        SBYT (0x14, Local0)
    }

    Scope (\_TZ)
    {
        Device (FAN)
        {
            Name (_HID, EisaId ("PNP0C0B"))  // _HID: Hardware ID
            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
                Store (TP1H, CTOS)
                Store (TP1L, CTHY)
            }
        }

        ThermalZone (THRM)
        {
            Name (_AL0, Package (0x01)  // _ALx: Active List
            {
                FAN
            })
            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
            }

            Method (_AC0, 0, NotSerialized)  // _ACx: Active Cooling
            {
                If (Or (PLCY, PLCY, Local7))
                {
                    Return (KELA (TP2H))
                }
                Else
                {
                    Return (KELA (TP1H))
                }
            }

            Name (_PSL, Package (0x01)  // _PSL: Passive List
            {
                \_PR.CPU0
            })
            Name (_TSP, 0x3C)  // _TSP: Thermal Sampling Period
            Name (_TC1, 0x04)  // _TC1: Thermal Constant 1
            Name (_TC2, 0x03)  // _TC2: Thermal Constant 2
            Method (_PSV, 0, NotSerialized)  // _PSV: Passive Temperature
            {
                If (Or (PLCY, PLCY, Local7))
                {
                    Return (KELA (TP1H))
                }
                Else
                {
                    Return (KELA (TP2H))
                }
            }

            Method (KELA, 1, NotSerialized)
            {
                If (LGreater (Arg0, 0x01F4))
                {
                    Return (Arg0)
                }
                Else
                {
                    Store (Arg0, Local1)
                    Multiply (Local1, 0x0A, Local1)
                    Add (Local1, 0x0AAC, Local1)
                    Return (Local1)
                }
            }

            Method (_CRT, 0, NotSerialized)  // _CRT: Critical Temperature
            {
                Return (TRPC)
            }

            Method (_TMP, 0, NotSerialized)  // _TMP: Temperature
            {
                And (SENF, 0x01, Local6)
                If (LEqual (Local6, 0x01))
                {
                    Return (RTMP ())
                }
                Else
                {
                    Return (0x0B86)
                }
            }

            Method (_SCP, 1, NotSerialized)  // _SCP: Set Cooling Policy
            {
                If (Arg0)
                {
                    Store (One, PLCY)
                }
                Else
                {
                    Store (Zero, PLCY)
                }

                Notify (\_TZ.THRM, 0x81)
            }

            Method (STMP, 2, NotSerialized)
            {
                Store (Arg1, DW00)
                If (Arg0)
                {
                    STHY (DB00, DB01, DW00)
                }
                Else
                {
                    STOS (DB00, DB01, DW00)
                }
            }
        }
    }
}

