/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20081031
 *
 * Disassembly of (null), Sun Mar 15 15:05:53 2009
 *
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00005470 (21616)
 *     Revision         0x01 **** ACPI 1.0, no 64-bit math support
 *     Checksum         0xDD
 *     OEM ID           "P0017"
 *     OEM Table ID     "P0017000"
 *     OEM Revision     0x00000000 (0)
 *     Compiler ID      "INTL"
 *     Compiler Version 0x20060113 (537264403)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "P0017", "P0017000", 0x00000000)
{
    Scope (_PR)
    {
        Processor (P001, 0x01, 0x00000810, 0x06) {}
        Alias (P001, CPU1)
    }

    Scope (_PR)
    {
        Processor (P002, 0x02, 0x00000810, 0x06) {}
        Alias (P002, CPU2)
    }

    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (APIC, One)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (GPBS, 0x0480)
    Name (GPLN, 0x40)
    Name (SMBL, Zero)
    Name (PM28, 0x0828)
    Name (PM30, 0x0830)
    Name (SUSW, 0xFF)
    Name (PCIB, 0xE0000000)
    Name (PCIL, 0x04000000)
    Name (SMBS, 0x0400)
    OperationRegion (BIOS, SystemMemory, 0x3F7AE064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
                Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32, 
        SMIF,   8, 
        DTSE,   8, 
        DTS1,   8, 
        DTS2,   8, 
        MPEN,   8, 
        TPMF,   8
    }

    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, Zero))
        {
            Store (0xAC, DBG8)
        }

        Store (One, OSVR)
        If (CondRefOf (_OSI, Local1))
        {
            If (_OSI ("Windows 2000"))
            {
                Store (0x04, OSVR)
            }

            If (_OSI ("Windows 2001"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001 SP1"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001 SP2"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001.1"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001.1 SP1"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2006"))
            {
                Store (Zero, OSVR)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (0x04, OSVR)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x02, OSVR)
                }

                If (MCTH (_OS, "Linux"))
                {
                    Store (0x03, OSVR)
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, DP80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Scope (_SB)
    {
        Name (PR00, Package (0x12)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                One, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKA, 
                Zero
            }
        })
        Name (AR00, Package (0x12)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                One, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x10
            }
        })
        Name (PR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR09, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR09, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,6,7,10,11,12,14,15}
        })
        Alias (PRSA, PRSB)
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))
            Name (_ADR, Zero)
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_S3D, 0, NotSerialized)
            {
                If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Name (_CID, EisaId ("PNP0A03"))
            Device (MCH)
            {
                Name (_HID, EisaId ("PNP0C01"))
                Name (_UID, 0x0A)
                Name (_CRS, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED13000,         // Address Base
                        0x00007000,         // Address Length
                        )
                })
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (P0P2)
            {
                Name (_ADR, 0x00010000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }

            Device (P0P1)
            {
                Name (_ADR, 0x001E0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (SBRG)
            {
                Name (_ADR, 0x001F0000)
                Method (SPTS, 1, NotSerialized)
                {
                    Store (One, PS1S)
                    Store (One, PS1E)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, PS1E)
                    If (LNot (GNVS (0x1654)))
                    {
                        Notify (PWRB, 0x02)
                    }
                }

                OperationRegion (PMS0, SystemIO, PMBS, PMLN)
                Field (PMS0, ByteAcc, NoLock, Preserve)
                {
                        ,   10, 
                    RTCS,   1, 
                        ,   4, 
                    WAKS,   1, 
                            Offset (0x03), 
                    PWBT,   1, 
                            Offset (0x04)
                }

                OperationRegion (SMIE, SystemIO, PM30, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PS1E,   1, 
                        ,   31, 
                    PS1S,   1, 
                            Offset (0x08)
                }

                OperationRegion (GPBX, SystemIO, GPBS, GPLN)
                Field (GPBX, ByteAcc, NoLock, Preserve)
                {
                    GPUS,   32, 
                    GPSL,   32, 
                            Offset (0x0C), 
                    GPLV,   32, 
                            Offset (0x18), 
                    GPBL,   32, 
                            Offset (0x2C), 
                    GPIV,   32
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, EisaId ("PNP030B"))
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("SYN0A04"))
                    Name (_CID, Package (0x03)
                    {
                        EisaId ("SYN0A00"), 
                        EisaId ("SYN0002"), 
                        EisaId ("PNP0F13")
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (EC0)
                {
                    Name (_HID, EisaId ("PNP0C09"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0066,             // Range Minimum
                            0x0066,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                    Name (_GPE, 0x1C)
                    Name (REGC, Zero)
                    Method (_REG, 2, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Store (Arg1, REGC)
                        }
                    }

                    Method (ECAV, 0, NotSerialized)
                    {
                        If (LEqual (REGC, Ones))
                        {
                            If (LGreaterEqual (_REV, 0x02))
                            {
                                Return (One)
                            }
                            Else
                            {
                                Return (Zero)
                            }
                        }

                        Return (REGC)
                    }

                    OperationRegion (ECOR, EmbeddedControl, Zero, 0xFF)
                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x29), 
                        BT00,   8, 
                        BT01,   8, 
                        BT02,   8, 
                        BT03,   8, 
                        BT04,   8, 
                        BT05,   8, 
                        BT06,   8, 
                        BT07,   8, 
                        BT08,   8, 
                        BT09,   8, 
                        BT10,   8, 
                        BT11,   8, 
                        BT12,   8, 
                        BT13,   8, 
                        BT14,   8, 
                        BT15,   8, 
                        BT16,   8, 
                        BT17,   8, 
                        BT18,   8, 
                        BT19,   8, 
                        BT20,   8, 
                        BT21,   8, 
                        BT22,   8, 
                        BT23,   8, 
                        BT24,   8, 
                        BT25,   8, 
                        BT26,   8
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x3F), 
                        BTS0,   1, 
                        BTS1,   1, 
                        BTS2,   1, 
                        BTS3,   1, 
                        BTS4,   1, 
                        BTS5,   1, 
                        BTS6,   1, 
                        BTS7,   1
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x51), 
                        ST00,   8, 
                        ST01,   8, 
                        ST02,   8, 
                        ST03,   8, 
                        ST04,   8, 
                        ST05,   8, 
                        ST06,   8, 
                        ST07,   8, 
                        ST08,   8, 
                        ST09,   8, 
                        ST10,   8
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x61), 
                        SC00,   8, 
                        SC01,   8, 
                        SC02,   8, 
                        SC03,   8, 
                        SC04,   8, 
                        SC05,   8, 
                        SC06,   8
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x71), 
                        TM00,   8, 
                        TM01,   8, 
                        TM02,   8, 
                        TM03,   8, 
                        TM04,   8, 
                        TM05,   8, 
                        TM06,   8, 
                        TM07,   8, 
                        TM08,   8
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x81), 
                        SM00,   8, 
                        SM01,   8, 
                        SM02,   8, 
                        SM03,   8, 
                        SM04,   8, 
                        SM05,   8, 
                        SM06,   8, 
                        SM07,   8, 
                        SM08,   8, 
                        SM09,   8, 
                        SM10,   8, 
                        SM11,   8, 
                        SM12,   8, 
                        SM13,   8, 
                        SM14,   8
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0xD0), 
                        SFB0,   8, 
                        SFB1,   8, 
                        SFB2,   8, 
                        SFB3,   8, 
                                Offset (0xEE), 
                                Offset (0xEF), 
                        SFBE,   8
                    }

                    Field (ECOR, ByteAcc, Lock, Preserve)
                    {
                                Offset (0xD0), 
                        SF00,   1, 
                        SF01,   1, 
                        SF02,   1, 
                        SF03,   1, 
                        SF04,   1, 
                        SF05,   1, 
                        SF06,   1, 
                        SF07,   1, 
                        SF08,   1, 
                        SF09,   1, 
                        SF10,   1, 
                        SF11,   1, 
                        SF12,   1, 
                        SF13,   1, 
                        SF14,   1, 
                        SF15,   1, 
                        SF16,   1, 
                        SF17,   1, 
                        SF18,   1, 
                        SF19,   1, 
                        SF20,   1, 
                        SF21,   1, 
                        SF22,   1, 
                        SF23,   1, 
                        SF24,   1, 
                        SF25,   1, 
                        SF26,   1, 
                        SF27,   1, 
                        SF28,   1, 
                        SF29,   1, 
                        SF30,   1, 
                        SF31,   1, 
                                Offset (0xEE), 
                        S240,   1, 
                        S241,   1, 
                        S242,   1, 
                        S243,   1, 
                        S244,   1, 
                        S245,   1, 
                        S246,   1, 
                        S247,   1, 
                        S248,   1, 
                        S249,   1, 
                        S250,   1, 
                        S251,   1, 
                        S252,   1, 
                        S253,   1, 
                        S254,   1, 
                        S255,   1
                    }

                    Method (EC0S, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            If (ECAV ())
                            {
                                If (LNot (Acquire (MUEC, 0xFFFF)))
                                {
                                    Store (One, SF28)
                                    Release (MUEC)
                                }
                            }
                        }

                        If (Arg0)
                        {
                            If (LLess (Arg0, 0x04)) {}
                        }
                    }

                    Method (EC0W, 1, NotSerialized)
                    {
                        If (Arg0)
                        {
                            If (LLess (Arg0, 0x04)) {}
                            If (LEqual (Arg0, 0x03))
                            {
                                If (ECAV ())
                                {
                                    If (LNot (Acquire (MUEC, 0xFFFF)))
                                    {
                                        Store (One, SF17)
                                        Release (MUEC)
                                    }
                                }
                            }
                        }
                    }
                }

                Scope (EC0)
                {
                    Mutex (MUEC, 0x00)
                    OperationRegion (DLYP, SystemIO, 0xE1, One)
                    Field (DLYP, ByteAcc, NoLock, Preserve)
                    {
                        DELY,   8
                    }

                    OperationRegion (KBCP, SystemIO, Zero, 0xFF)
                    Field (KBCP, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x60), 
                        KBCD,   8, 
                                Offset (0x62), 
                        EC62,   8, 
                                Offset (0x64), 
                        KBCC,   8, 
                                Offset (0x66), 
                        EC66,   8
                    }

                    Field (KBCP, ByteAcc, Lock, Preserve)
                    {
                                Offset (0x64), 
                        KBOF,   1, 
                        KBIE,   1, 
                                Offset (0x65), 
                                Offset (0x66), 
                        ECOF,   1, 
                        ECIE,   1, 
                                Offset (0x67)
                    }

                    Method (IBFR, 0, Serialized)
                    {
                        Store (0x1000, Local0)
                        While (LAnd (Decrement (Local0), KBIE))
                        {
                            Store (Zero, DELY)
                        }
                    }

                    Method (OBFL, 0, Serialized)
                    {
                        Store (0x1000, Local0)
                        While (LAnd (Decrement (Local0), LNot (KBOF)))
                        {
                            Store (Zero, DELY)
                        }
                    }

                    Method (IBFX, 0, Serialized)
                    {
                        Store (0x1000, Local0)
                        While (LAnd (Decrement (Local0), ECIE))
                        {
                            Store (Zero, DELY)
                        }
                    }

                    Method (OBFX, 0, Serialized)
                    {
                        Store (0x1000, Local0)
                        While (LAnd (Decrement (Local0), LNot (ECOF)))
                        {
                            Store (Zero, DELY)
                        }
                    }

                    Method (ECXW, 2, Serialized)
                    {
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                IBFX ()
                                Store (Arg0, EC66)
                                IBFX ()
                                Store (Arg1, EC62)
                                IBFX ()
                                Release (MUEC)
                            }
                        }
                    }

                    Method (ECXR, 1, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                IBFX ()
                                Store (Arg0, EC66)
                                OBFX ()
                                Store (EC62, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BWRN, 1, Serialized)
                    {
                        Store (Ones, Local2)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                And (Arg0, 0xFF, Local0)
                                ShiftRight (And (Arg0, 0xFF00), 0x08, Local1)
                                Store (Local1, BT12)
                                Store (Local0, BT13)
                                Release (MUEC)
                                Store (Zero, Local2)
                            }
                        }

                        Return (Local2)
                    }

                    Method (BLOW, 1, Serialized)
                    {
                        Store (Ones, Local2)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                And (Arg0, 0xFF, Local0)
                                ShiftRight (And (Arg0, 0xFF00), 0x08, Local1)
                                Store (Local1, BT14)
                                Store (Local0, BT15)
                                Release (MUEC)
                                Store (Zero, Local2)
                            }
                        }

                        Return (Local2)
                    }

                    Method (BCRT, 1, Serialized)
                    {
                        Store (Ones, Local2)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                And (Arg0, 0xFF, Local0)
                                ShiftRight (And (Arg0, 0xFF00), 0x08, Local1)
                                Store (Local1, BT16)
                                Store (Local0, BT17)
                                Release (MUEC)
                                Store (Zero, Local2)
                            }
                        }

                        Return (Local2)
                    }

                    Method (BIF1, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT00, Local0)
                                Store (BT01, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BIF2, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT23, Local0)
                                Store (BT24, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BIF4, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT02, Local0)
                                Store (BT03, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BIF5, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT12, Local0)
                                Store (BT13, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BIF6, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT14, Local0)
                                Store (BT15, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BST1, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT06, Local0)
                                Store (BT07, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BST2, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT10, Local0)
                                Store (BT11, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (BST3, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT04, Local0)
                                Store (BT05, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (EBTS, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (BT22, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (RCTP, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (ST00, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }

                    Method (ETPS, 1, Serialized)
                    {
                        Store (Zero, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                XOr (Arg0, One, Local1)
                                Store (Local1, SF19)
                                Release (MUEC)
                                Store (One, Local0)
                            }
                        }

                        Return (Local0)
                    }

                    Method (ETPG, 0, Serialized)
                    {
                        Store (Ones, Local0)
                        If (ECAV ())
                        {
                            If (LNot (Acquire (MUEC, 0xFFFF)))
                            {
                                Store (SF19, Local0)
                                XOr (Local0, One, Local0)
                                Release (MUEC)
                            }
                        }

                        Return (Local0)
                    }
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x0A,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x00,               // Alignment
                            0x0F,               // Length
                            )
                        IO (Decode16,
                            0x0063,             // Range Minimum
                            0x0063,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0067,             // Range Minimum
                            0x0067,             // Range Maximum
                            0x00,               // Alignment
                            0x09,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x025C,             // Range Minimum
                            0x025C,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0380,             // Range Minimum
                            0x0380,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0400,             // Range Minimum
                            0x0400,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y00)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y01)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y02)
                        Memory32Fixed (ReadWrite,
                            0x8C000000,         // Address Base
                            0x00020000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED1C000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED20000,         // Address Base
                            0x00020000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED50000,         // Address Base
                            0x00040000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFFB00000,         // Address Base
                            0x00100000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFFF00000,         // Address Base
                            0x00100000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MIN, GP00)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MAX, GP01)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._LEN, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._LEN, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._LEN, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }

                        Return (CRS)
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xFED00000,         // Address Base
                            0x00000400,         // Address Length
                            _Y03)
                    })
                    OperationRegion (^LPCR, SystemMemory, 0xFED1F404, 0x04)
                    Field (LPCR, AnyAcc, NoLock, Preserve)
                    {
                        HPTS,   2, 
                            ,   5, 
                        HPTE,   1, 
                                Offset (0x04)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (OSFL (), Zero))
                        {
                            If (HPTE)
                            {
                                Return (0x0F)
                            }
                        }
                        Else
                        {
                            If (HPTE)
                            {
                                Return (0x0B)
                            }
                        }

                        Return (Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.HPET._Y03._BAS, HPT)
                        Multiply (HPTS, 0x1000, Local0)
                        Add (Local0, 0xFED00000, HPT)
                        Return (CRS)
                    }
                }

                OperationRegion (RX80, PCI_Config, Zero, 0xFF)
                Field (RX80, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x80), 
                    LPCD,   16, 
                    LPCE,   16
                }

                Name (DBPT, Package (0x04)
                {
                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x03)
                    {
                        0x0378, 
                        0x0278, 
                        0x03BC
                    }, 

                    Package (0x02)
                    {
                        0x03F0, 
                        0x0370
                    }
                })
                Name (DDLT, Package (0x04)
                {
                    Package (0x02)
                    {
                        Zero, 
                        0xFFF8
                    }, 

                    Package (0x02)
                    {
                        0x04, 
                        0xFF8F
                    }, 

                    Package (0x02)
                    {
                        0x08, 
                        0xFCFF
                    }, 

                    Package (0x02)
                    {
                        0x0C, 
                        0xEFFF
                    }
                })
                Method (RRIO, 4, NotSerialized)
                {
                    If (LAnd (LLessEqual (Arg0, 0x03), LGreaterEqual (Arg0, Zero)))
                    {
                        Store (Match (DerefOf (Index (DBPT, Arg0)), MEQ, Arg2, MTR, 
                            Zero, Zero), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), Zero)), 
                                Local1)
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), One)), 
                                Local2)
                            ShiftLeft (Local0, Local1, Local0)
                            And (LPCD, Local2, LPCD)
                            Or (LPCD, Local0, LPCD)
                            WX82 (Arg0, Arg1)
                        }
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        If (LEqual (Arg2, 0x0200))
                        {
                            WX82 (0x08, Arg0)
                        }
                        Else
                        {
                            If (LEqual (Arg2, 0x0208))
                            {
                                WX82 (0x09, Arg0)
                            }
                        }
                    }

                    If (LAnd (LLessEqual (Arg0, 0x0D), LGreaterEqual (Arg0, 0x0A)))
                    {
                        WX82 (Arg0, Arg1)
                    }
                }

                Method (WX82, 2, NotSerialized)
                {
                    ShiftLeft (One, Arg0, Local0)
                    If (Arg1)
                    {
                        Or (LPCE, Local0, LPCE)
                    }
                    Else
                    {
                        Not (Local0, Local0)
                        And (LPCE, Local0, LPCE)
                    }
                }

                Method (RDMA, 3, NotSerialized)
                {
                }

                OperationRegion (SMRG, SystemIO, SMBS, 0x10)
                Field (SMRG, ByteAcc, NoLock, Preserve)
                {
                    HSTS,   8, 
                    SSTS,   8, 
                    HSTC,   8, 
                    HCMD,   8, 
                    HADR,   8, 
                    HDT0,   8, 
                    HDT1,   8, 
                    BLKD,   8
                }

                Field (SMRG, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x05), 
                    HDTW,   16
                }

                Method (SCMD, 4, NotSerialized)
                {
                    Store (0x05, Local0)
                    While (Local0)
                    {
                        Store (Arg0, HADR)
                        Store (Arg1, HCMD)
                        Store (Arg2, HDTW)
                        Store (0xFF, HSTS)
                        Store (Arg3, HSTC)
                        Store (0xFF, Local7)
                        While (Local7)
                        {
                            Decrement (Local7)
                            If (And (HSTS, 0x02))
                            {
                                Store (Zero, Local7)
                                Store (One, Local0)
                            }
                        }

                        Decrement (Local0)
                    }

                    If (And (HSTS, 0x02))
                    {
                        Return (HDTW)
                    }
                    Else
                    {
                        Return (Ones)
                    }
                }

                Method (SBYT, 2, NotSerialized)
                {
                    SCMD (Arg0, Arg1, Zero, 0x44)
                }

                Method (WBYT, 3, NotSerialized)
                {
                    SCMD (Arg0, Arg1, Arg2, 0x48)
                }

                Method (WWRD, 3, NotSerialized)
                {
                    SCMD (Arg0, Arg1, Arg2, 0x4C)
                }

                Method (RSBT, 2, NotSerialized)
                {
                    Or (Arg0, One, Arg0)
                    Return (SCMD (Arg0, Arg1, Zero, 0x44))
                }

                Method (RBYT, 2, NotSerialized)
                {
                    Or (Arg0, One, Arg0)
                    Return (SCMD (Arg0, Arg1, Zero, 0x48))
                }

                Method (RWRD, 2, NotSerialized)
                {
                    Or (Arg0, One, Arg0)
                    Return (SCMD (Arg0, Arg1, Zero, 0x4C))
                }

                Scope (\)
                {
                    OperationRegion (RAMW, SystemMemory, Subtract (TOPM, 0x00010000), 0x00010000)
                    Field (RAMW, ByteAcc, NoLock, Preserve)
                    {
                        PAR0,   32, 
                        PAR1,   32
                    }

                    OperationRegion (IOB2, SystemIO, 0xB2, 0x02)
                    Field (IOB2, ByteAcc, NoLock, Preserve)
                    {
                        SMIC,   8, 
                        SMIS,   8
                    }

                    Method (ISMI, 1, Serialized)
                    {
                        Store (Arg0, SMIC)
                    }

                    Method (GNVS, 1, Serialized)
                    {
                        Store (Arg0, PAR0)
                        ISMI (0x70)
                        Return (PAR1)
                    }

                    Method (SNVS, 2, Serialized)
                    {
                        Store (Arg0, PAR0)
                        Store (Arg1, PAR1)
                        ISMI (0x71)
                    }
                }

                Device (^PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xE0000000,         // Address Base
                            0x10000000,         // Address Length
                            _Y04)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y04._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y04._LEN, LEN1)
                        Store (PCIB, BAS1)
                        Store (PCIL, LEN1)
                        Return (CRS)
                    }
                }

                Scope (\)
                {
                }

                Scope (\)
                {
                    Name (MNAM, "901")
                    Field (RAMW, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x10), 
                        ACPS,   1, 
                        DCPS,   1, 
                        LCDC,   1, 
                        CPUC,   1, 
                        TPLK,   1, 
                        FANC,   1, 
                        BLTS,   1, 
                        DC2S,   1, 
                        FS70,   2, 
                                Offset (0x12), 
                        BCAT,   16, 
                        BLTC,   8, 
                        BCGS,   8, 
                        DSAF,   32, 
                        MDLC,   32, 
                                Offset (0xB0), 
                        TRTY,   8, 
                        FSFN,   8, 
                        FSTA,   16, 
                        FADR,   32, 
                        FSIZ,   16, 
                                Offset (0xC0), 
                        USBI,   32, 
                        WAKT,   8, 
                        SHE0,   8, 
                        FVSS,   8
                    }

                    Field (RAMW, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x16), 
                        DAWL,   1, 
                        DABT,   1, 
                        DAIR,   1, 
                        DACM,   1, 
                        DATV,   1, 
                        DAGP,   1, 
                        DADS,   1, 
                        DAMD,   1, 
                        DACR,   1, 
                                Offset (0x1A)
                    }

                    Method (ATKN, 1, NotSerialized)
                    {
                        Store (Zero, Local1)
                        If (\_SB.LID._LID ())
                        {
                            Store (ATKR (Arg0), Local1)
                        }

                        Return (Local1)
                    }

                    Method (ATKR, 1, NotSerialized)
                    {
                        Store (Zero, Local1)
                        If (\_SB.ATKP)
                        {
                            Notify (\_SB.ATKD, Arg0)
                            Store (One, Local1)
                        }

                        Return (Local1)
                    }
                }

                Scope (\_SB)
                {
                    Name (ATKP, Zero)
                    Device (ATKD)
                    {
                        Name (_HID, "ASUS010")
                        Name (_UID, 0x01010100)
                        Method (TYPE, 0, Serialized)
                        {
                            Return (0x20313039)
                        }

                        Method (TYP1, 0, Serialized)
                        {
                            Return (0x20204153)
                        }

                        Method (BIOS, 0, Serialized)
                        {
                            ShiftLeft (0x18, 0x08, Local0)
                            Store (0x08, Local1)
                            Return (Add (Local0, Local1))
                        }

                        Method (VERG, 0, Serialized)
                        {
                            ShiftLeft (One, 0x08, Local0)
                            Store (0x60, Local1)
                            Return (Add (Local0, Local1))
                        }

                        Method (QURY, 1, Serialized)
                        {
                            Name (_T_0, Zero)
                            Store (Arg0, _T_0)
                            If (LEqual (_T_0, 0x534C4250))
                            {
                                Store (One, Local1)
                            }
                            Else
                            {
                                If (LEqual (_T_0, 0x474C4250))
                                {
                                    Store (One, Local1)
                                }
                                Else
                                {
                                    If (LEqual (_T_0, 0x50534453))
                                    {
                                        Store (One, Local1)
                                    }
                                    Else
                                    {
                                        If (LEqual (_T_0, 0x53564643))
                                        {
                                            Store (One, Local1)
                                        }
                                        Else
                                        {
                                            If (LEqual (_T_0, 0x47564643))
                                            {
                                                Store (One, Local1)
                                            }
                                            Else
                                            {
                                                If (LEqual (_T_0, 0x53444C57))
                                                {
                                                    Store (One, Local1)
                                                }
                                                Else
                                                {
                                                    If (LEqual (_T_0, 0x47444C57))
                                                    {
                                                        Store (One, Local1)
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (_T_0, 0x534D4143))
                                                        {
                                                            Store (One, Local1)
                                                        }
                                                        Else
                                                        {
                                                            If (LEqual (_T_0, 0x474D4143))
                                                            {
                                                                Store (One, Local1)
                                                            }
                                                            Else
                                                            {
                                                                If (LEqual (_T_0, 0x53445243))
                                                                {
                                                                    Store (One, Local1)
                                                                }
                                                                Else
                                                                {
                                                                    If (LEqual (_T_0, 0x47445243))
                                                                    {
                                                                        Store (One, Local1)
                                                                    }
                                                                    Else
                                                                    {
                                                                        If (LEqual (_T_0, 0x53444F4D))
                                                                        {
                                                                            Store (One, Local1)
                                                                        }
                                                                        Else
                                                                        {
                                                                            If (LEqual (_T_0, 0x47444F4D))
                                                                            {
                                                                                Store (One, Local1)
                                                                            }
                                                                            Else
                                                                            {
                                                                                If (LEqual (_T_0, 0x53504448))
                                                                                {
                                                                                    Store (One, Local1)
                                                                                }
                                                                                Else
                                                                                {
                                                                                    If (LEqual (_T_0, 0x5347334D))
                                                                                    {
                                                                                        Store (One, Local1)
                                                                                    }
                                                                                    Else
                                                                                    {
                                                                                        If (LEqual (_T_0, 0x4747334D))
                                                                                        {
                                                                                            Store (One, Local1)
                                                                                        }
                                                                                        Else
                                                                                        {
                                                                                            If (LEqual (_T_0, 0x534D4957))
                                                                                            {
                                                                                                Store (One, Local1)
                                                                                            }
                                                                                            Else
                                                                                            {
                                                                                                If (LEqual (_T_0, 0x474D4957))
                                                                                                {
                                                                                                    Store (One, Local1)
                                                                                                }
                                                                                                Else
                                                                                                {
                                                                                                    If (LEqual (_T_0, 0x45505954))
                                                                                                    {
                                                                                                        Store (One, Local1)
                                                                                                    }
                                                                                                    Else
                                                                                                    {
                                                                                                        If (LEqual (_T_0, 0x31505954))
                                                                                                        {
                                                                                                            Store (One, Local1)
                                                                                                        }
                                                                                                        Else
                                                                                                        {
                                                                                                            If (LEqual (_T_0, 0x53485442))
                                                                                                            {
                                                                                                                Store (One, Local1)
                                                                                                            }
                                                                                                            Else
                                                                                                            {
                                                                                                                If (LEqual (_T_0, 0x47485442))
                                                                                                                {
                                                                                                                    Store (One, Local1)
                                                                                                                }
                                                                                                                Else
                                                                                                                {
                                                                                                                    If (LEqual (_T_0, 0x534F4942))
                                                                                                                    {
                                                                                                                        Store (One, Local1)
                                                                                                                    }
                                                                                                                    Else
                                                                                                                    {
                                                                                                                        Store (Zero, Local1)
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            Return (Local1)
                        }

                        Method (INIT, 1, Serialized)
                        {
                            Store (One, ATKP)
                            Store (Arg0, DSAF)
                            If (LEqual (FVSS, Zero))
                            {
                                If (LOr (LEqual (WAKT, 0x05), LEqual (WAKT, 0x04)))
                                {
                                    CFVS (GNVS (0x2665))
                                }
                                Else
                                {
                                    CFVS (FS70)
                                }
                            }

                            Return (One)
                        }

                        Method (CMSG, 0, Serialized)
                        {
                            Store (0x00301733, Local0)
                            If (LEqual (GNVS (0x1655), Zero))
                            {
                                And (Local0, 0xFFFFFFFE, Local0)
                            }

                            If (LEqual (GNVS (0x1657), Zero))
                            {
                                And (Local0, 0xFFFFFFEF, Local0)
                            }

                            If (LEqual (GNVS (0x1656), Zero))
                            {
                                And (Local0, 0xFFFFFFFD, Local0)
                            }

                            If (LEqual (GNVS (0x1660), Zero))
                            {
                                And (Local0, 0xFFFFFFDF, Local0)
                            }

                            If (LEqual (GNVS (0x1662), Zero))
                            {
                                And (Local0, 0xFFFFFFBF, Local0)
                            }

                            If (LEqual (GNVS (0x1664), Zero))
                            {
                                And (Local0, 0xFFEFFFFF, Local0)
                            }

                            If (LEqual (GNVS (0x1661), Zero))
                            {
                                And (Local0, 0xFFDFFFFF, Local0)
                            }

                            If (LEqual (GNVS (0x1663), Zero))
                            {
                                And (Local0, 0xFFBFFFFF, Local0)
                            }

                            Return (Local0)
                        }

                        Method (WLDS, 1, Serialized)
                        {
                            Return (OWLS (Arg0))
                        }

                        Method (WLDG, 0, Serialized)
                        {
                            Return (OWLG ())
                        }

                        Method (PBLS, 1, Serialized)
                        {
                            SNVS (0x43F4, Arg0)
                            ^^PCI0.SBRG.EC0.STBR ()
                            Return (One)
                        }

                        Method (PBLG, 0, Serialized)
                        {
                            Return (GNVS (0x43F4))
                        }

                        Method (CFVS, 1, Serialized)
                        {
                            Store (0x55, FVSS)
                            If (LOr (LOr (LEqual (WAKT, 0x03), LEqual (WAKT, 0x04)), LEqual (
                                WAKT, 0x05)))
                            {
                                ^^PCI0.SBRG.FSBA (Arg0)
                            }
                            Else
                            {
                                If (LNotEqual (Arg0, FS70))
                                {
                                    ^^PCI0.SBRG.FSBA (Arg0)
                                }
                            }

                            Store (Arg0, FS70)
                            Return (One)
                        }

                        Method (CFVG, 0, Serialized)
                        {
                            Return (^^PCI0.SBRG.FSBG ())
                        }

                        Method (CAMS, 1, Serialized)
                        {
                            Return (OCMS (Arg0))
                        }

                        Method (CAMG, 0, Serialized)
                        {
                            Return (OCMG ())
                        }

                        Method (BTHS, 1, Serialized)
                        {
                            Return (OBTS (Arg0))
                        }

                        Method (BTHG, 0, Serialized)
                        {
                            Return (OBTG ())
                        }

                        Method (SDSP, 1, Serialized)
                        {
                            ^^PCI0.VGA.SWHD (Arg0)
                            Return (One)
                        }

                        Method (MODS, 1, Serialized)
                        {
                            Return (OMDS (Arg0))
                        }

                        Method (MODG, 0, Serialized)
                        {
                            Return (OMDG ())
                        }

                        Method (CRDS, 1, Serialized)
                        {
                            Return (OCRS (Arg0))
                        }

                        Method (CRDG, 0, Serialized)
                        {
                            Return (OCRG ())
                        }

                        Method (M3GS, 1, Serialized)
                        {
                            Return (O3GS (Arg0))
                        }

                        Method (M3GG, 0, Serialized)
                        {
                            Return (O3GG ())
                        }

                        Method (WIMS, 1, Serialized)
                        {
                            Return (OWIS (Arg0))
                        }

                        Method (WIMG, 0, Serialized)
                        {
                            Return (OWIG ())
                        }

                        Method (HDPS, 1, Serialized)
                        {
                            Store (Arg0, Local0)
                            Store (Arg0, Local1)
                            ShiftRight (Local0, 0x08, Local0)
                            And (Local1, 0xFF, Local1)
                            Name (_T_0, Zero)
                            Store (Local1, _T_0)
                            If (LEqual (_T_0, 0x04)) {}
                            Else
                            {
                                If (LEqual (_T_0, 0x06)) {}
                                Else
                                {
                                    If (LEqual (_T_0, 0x07)) {}
                                    Else
                                    {
                                        If (LEqual (_T_0, 0x0B)) {}
                                        Else
                                        {
                                            If (LEqual (_T_0, 0x0C)) {}
                                            Else
                                            {
                                                If (LEqual (_T_0, 0x0E)) {}
                                                Else
                                                {
                                                    Return (Zero)
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            If (And (LLess (Local0, 0x05), LGreater (Local0, Zero)))
                            {
                                SNVS (0x81C0, Local1)
                                SNVS (0x81C8, Local0)
                                SNVS (0x8180, 0x46)
                                SNVS (0x8188, 0x57)
                                SNVS (0x8198, Or (GNVS (0x8198), 0x40))
                                Return (One)
                            }

                            Return (Zero)
                        }

                        Method (PBPS, 1, Serialized)
                        {
                            If (LEqual (Arg0, One))
                            {
                                Store (Zero, ^^PCI0.SBRG.EC0.SF18)
                            }
                            Else
                            {
                                Store (One, ^^PCI0.SBRG.EC0.SF18)
                            }

                            Return (One)
                        }

                        Method (PBPG, 0, Serialized)
                        {
                            XOr (^^PCI0.SBRG.EC0.SF18, One, Local0)
                            Return (Local0)
                        }

                        Method (HWCF, 0, Serialized)
                        {
                            Return (0x00040101)
                        }
                    }

                    Scope (\)
                    {
                        OperationRegion (PMIO, SystemIO, 0x0800, 0x80)
                        Field (PMIO, ByteAcc, NoLock, Preserve)
                        {
                                    Offset (0x10), 
                                ,   1, 
                            TDTY,   3, 
                            TENA,   1, 
                            TTDT,   3, 
                            TTEN,   1, 
                                ,   8, 
                            THLS,   1
                        }

                        Method (LPFS, 1, NotSerialized)
                        {
                            Store (Zero, FVSS)
                            Store (FS70, Local0)
                            If (LOr (LEqual (Arg0, 0x05), LEqual (Arg0, 0x04)))
                            {
                                SNVS (0x2665, Local0)
                            }
                        }

                        Method (LPWK, 1, NotSerialized)
                        {
                            If (LEqual (Arg0, 0x03))
                            {
                                \_SB.PCI0.SBRG.EC0.UAPF ()
                                \_SB.PCI0.SBRG.EC0.UBPF ()
                            }

                            Notify (\_SB.PCI0.BAT0, 0x81)
                            Notify (\_SB.PCI0.AC0, 0x81)
                            If (LNot (GNVS (0x1654)))
                            {
                                Notify (\_SB.PWRB, 0x02)
                            }

                            Notify (\_PR.CPU1, 0x80)
                            Notify (\_PR.CPU1, 0x81)
                            Sleep (0x0A)
                            Store (Arg0, WAKT)
                            If (LEqual (WAKT, 0x03))
                            {
                                If (LEqual (FS70, Zero))
                                {
                                    \_SB.PCI0.SBRG.FSBA (One)
                                    Sleep (0xC8)
                                }
                            }
                            Else
                            {
                                If (LEqual (GNVS (0x2665), Zero))
                                {
                                    \_SB.PCI0.SBRG.FSBA (One)
                                    Sleep (0xC8)
                                }
                            }
                        }
                    }

                    Scope (\_SB)
                    {
                        Device (LID)
                        {
                            Name (_HID, EisaId ("PNP0C0D"))
                            Name (LIDS, One)
                            Method (_LID, 0, NotSerialized)
                            {
                                Store (^^PCI0.SBRG.EC0.SF13, LIDS)
                                Return (LIDS)
                            }
                        }

                        Device (SLPB)
                        {
                            Name (_HID, EisaId ("PNP0C0E"))
                        }
                    }

                    Scope (PCI0.SBRG.EC0)
                    {
                        Method (_Q04, 0, NotSerialized)
                        {
                            Notify (SLPB, 0x80)
                        }

                        Method (_Q06, 0, NotSerialized)
                        {
                            If (LAnd (DSAF, One))
                            {
                                Store (0x10, Local0)
                            }
                            Else
                            {
                                Store (^^^^ATKD.WLDG (), Local0)
                                XOr (Local0, One, Local0)
                                ^^^^ATKD.WLDS (Local0)
                                If (Local0)
                                {
                                    Store (0x10, Local0)
                                }
                                Else
                                {
                                    Store (0x11, Local0)
                                }
                            }

                            ATKN (Local0)
                        }

                        Method (_Q07, 0, NotSerialized)
                        {
                            Store (GNVS (0x43F4), Local0)
                            If (LGreater (Local0, Zero))
                            {
                                Decrement (Local0)
                            }

                            If (LGreater (Local0, 0x0E))
                            {
                                Store (0x0E, Local0)
                            }

                            SNVS (0x43F4, Local0)
                            STBR ()
                            ATKN (Add (Local0, 0x20))
                        }

                        Method (_Q09, 0, NotSerialized)
                        {
                            Store (GNVS (0x43F4), Local0)
                            If (LLess (Local0, 0x0F))
                            {
                                Increment (Local0)
                            }
                            Else
                            {
                                Store (0x0F, Local0)
                            }

                            SNVS (0x43F4, Local0)
                            STBR ()
                            ATKN (Add (Local0, 0x20))
                        }

                        Method (_Q0C, 0, NotSerialized)
                        {
                            Store (^^^VGA.GETN (), Local0)
                            Store (^^^VGA.GETN (), Local0)
                            ATKN (Add (Local0, 0x2F))
                        }

                        Method (_Q0E, 0, NotSerialized)
                        {
                            ATKN (0x12)
                        }

                        Method (_Q10, 0, NotSerialized)
                        {
                            ATKN (0x13)
                        }

                        Method (_Q11, 0, NotSerialized)
                        {
                            Store (^^^VGA.GETN (), Local0)
                            ATKN (0x14)
                        }

                        Method (_Q13, 0, NotSerialized)
                        {
                            ATKN (0x15)
                        }

                        Method (_Q15, 0, NotSerialized)
                        {
                            ATKN (0x16)
                        }

                        Method (_Q17, 0, NotSerialized)
                        {
                        }

                        Method (_Q19, 0, NotSerialized)
                        {
                        }

                        Method (_Q1B, 0, NotSerialized)
                        {
                        }

                        Method (_Q27, 0, NotSerialized)
                        {
                            ATKN (0x1A)
                        }

                        Method (_Q28, 0, NotSerialized)
                        {
                            ATKN (0x1B)
                        }

                        Method (_Q29, 0, NotSerialized)
                        {
                            ATKN (0x1C)
                        }

                        Method (_Q2A, 0, NotSerialized)
                        {
                            ATKN (0x1D)
                        }

                        Method (_Q2B, 0, NotSerialized)
                        {
                            Notify (LID, 0x80)
                        }

                        Method (_Q2C, 0, NotSerialized)
                        {
                            Notify (LID, 0x80)
                        }

                        Method (_Q31, 0, NotSerialized)
                        {
                            UAPF ()
                            STBR ()
                            Notify (AC0, 0x80)
                            Notify (BAT0, 0x80)
                            Sleep (0x0A)
                            If (ACPS)
                            {
                                ATKN (0x50)
                            }
                            Else
                            {
                                ATKN (0x51)
                            }

                            Notify (\_PR.CPU1, 0x80)
                            Notify (\_PR.CPU1, 0x81)
                            Sleep (0x0A)
                        }

                        Method (_Q32, 0, NotSerialized)
                        {
                            UBPF ()
                            If (DCPS)
                            {
                                Sleep (0x01F4)
                            }

                            STBR ()
                            Notify (BAT0, One)
                            Notify (BAT0, 0x81)
                            Notify (AC0, 0x80)
                        }

                        Method (_Q33, 0, NotSerialized)
                        {
                            Notify (BAT0, 0x80)
                            Notify (AC0, 0x80)
                        }

                        Method (_Q35, 0, NotSerialized)
                        {
                            Notify (BAT0, 0x80)
                            Notify (AC0, 0x80)
                        }

                        Method (_Q36, 0, NotSerialized)
                        {
                            Notify (BAT0, 0x80)
                            Notify (AC0, 0x80)
                        }

                        Method (_Q37, 0, NotSerialized)
                        {
                            If (ATKN (0x52))
                            {
                                Notify (BAT0, 0x80)
                            }
                        }

                        Method (_Q44, 0, NotSerialized)
                        {
                            Notify (\_TZ.TZ00, 0x80)
                        }

                        Method (_Q3A, 0, NotSerialized)
                        {
                            EFTL ()
                        }

                        Method (_Q3B, 0, NotSerialized)
                        {
                        }

                        Method (_Q38, 0, NotSerialized)
                        {
                        }

                        Method (STBR, 0, Serialized)
                        {
                            ISMI (0x78)
                        }

                        Method (UBPF, 0, Serialized)
                        {
                            If (ECAV ())
                            {
                                If (LNot (Acquire (MUEC, 0xFFFF)))
                                {
                                    Store (SF01, Local0)
                                    Release (MUEC)
                                    Store (Local0, DCPS)
                                }
                            }
                        }

                        Method (UAPF, 0, Serialized)
                        {
                            If (ECAV ())
                            {
                                If (LNot (Acquire (MUEC, 0xFFFF)))
                                {
                                    Store (SF00, Local0)
                                    Release (MUEC)
                                    Store (Local0, ACPS)
                                }
                            }
                        }

                        Method (UBCF, 0, Serialized)
                        {
                            Store (BIF1 (), BCAT)
                        }

                        Method (UBCS, 0, Serialized)
                        {
                            If (ACPS)
                            {
                                Store (0x02, BCGS)
                                Store (EBTS (), Local1)
                                If (LNotEqual (Local1, Ones))
                                {
                                    If (And (Local1, 0x40))
                                    {
                                        Store (Zero, BCGS)
                                    }
                                }
                            }
                            Else
                            {
                                Store (One, BCGS)
                            }
                        }

                        Method (UBEC, 0, Serialized)
                        {
                            If (DCPS)
                            {
                                Store (BIF2 (), Local0)
                                If (LNotEqual (Local0, Ones))
                                {
                                    Multiply (Local0, 0x04, Local1)
                                    Divide (Local1, 0x64, Local2, Local1)
                                    BWRN (Local1)
                                    Multiply (Local0, 0x04, Local1)
                                    Divide (Local1, 0x64, Local2, Local1)
                                    BLOW (Local1)
                                    Multiply (Local0, 0x04, Local1)
                                    Divide (Local1, 0x64, Local2, Local1)
                                    BCRT (Local1)
                                }
                            }
                        }
                    }
                }

                Scope (^^PCI0)
                {
                    Device (BAT0)
                    {
                        Name (_HID, EisaId ("PNP0C0A"))
                        Name (_UID, Zero)
                        Name (_PCL, Package (0x01)
                        {
                            PCI0
                        })
                        Method (_STA, 0, NotSerialized)
                        {
                            Return (CSTA ())
                        }

                        Method (_BIF, 0, NotSerialized)
                        {
                            If (LEqual (DCPS, Zero))
                            {
                                Return (NBIF)
                            }

                            CBIF ()
                            Return (PBIF)
                        }

                        Method (_BST, 0, NotSerialized)
                        {
                            If (And (0x10, _STA ()))
                            {
                                CBST ()
                            }

                            Return (PBST)
                        }
                    }

                    Name (NBIF, Package (0x0D)
                    {
                        One, 
                        Ones, 
                        Ones, 
                        One, 
                        Ones, 
                        Ones, 
                        Ones, 
                        Ones, 
                        Ones, 
                        " ", 
                        " ", 
                        " ", 
                        " "
                    })
                    Name (PBIF, Package (0x0D)
                    {
                        One, 
                        0x10CC, 
                        0x1068, 
                        One, 
                        0x36D0, 
                        0x01A4, 
                        0xD2, 
                        0x1C, 
                        0x050A, 
                        "901", 
                        " ", 
                        "LION", 
                        "ASUS"
                    })
                    Name (BATF, Buffer (0x02) {})
                    CreateWordField (BATF, Zero, DATW)
                    Name (BAF1, Buffer (0x02) {})
                    CreateWordField (BAF1, Zero, DAT2)
                    Method (CSTA, 0, Serialized)
                    {
                        Store (DCPS, Local0)
                        If (Local0)
                        {
                            Return (0x1F)
                        }
                        Else
                        {
                            Return (0x0F)
                        }
                    }

                    Method (CBIF, 0, Serialized)
                    {
                        ^SBRG.EC0.UBCS ()
                        ^SBRG.EC0.UBEC ()
                        Store (^SBRG.EC0.BIF1 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (Local0, Index (PBIF, One))
                        }

                        Store (^SBRG.EC0.BIF2 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (Local0, Index (PBIF, 0x02))
                        }

                        Store (^SBRG.EC0.BIF4 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (Local0, Index (PBIF, 0x04))
                        }

                        Store (^SBRG.EC0.BIF5 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (Local0, Index (PBIF, 0x05))
                        }

                        Store (^SBRG.EC0.BIF6 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (Local0, Index (PBIF, 0x06))
                        }

                        Store (^SBRG.EC0.BIF1 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Divide (Local0, 0x64, Local1, Local0)
                            Store (Local0, Index (PBIF, 0x07))
                            Store (Local0, Index (PBIF, 0x08))
                        }
                    }

                    Name (PBST, Package (0x04)
                    {
                        Zero, 
                        0x8000, 
                        0x8000, 
                        0x36B0
                    })
                    Method (CBST, 0, Serialized)
                    {
                        ^SBRG.EC0.UBCS ()
                        Store (BCGS, Index (PBST, Zero))
                        Store (^SBRG.EC0.BST1 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            If (LGreaterEqual (Local0, 0x8000))
                            {
                                Subtract (Zero, Local0, Local0)
                                Increment (Local0)
                                And (Local0, 0xFFFF, Local0)
                            }

                            Store (Local0, Index (PBST, One))
                        }

                        Store (^SBRG.EC0.BST2 (), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (^SBRG.EC0.BIF2 (), Local1)
                            If (LNotEqual (Local1, Ones))
                            {
                                Divide (Multiply (Local1, 0x63, Local2), 0x64, Local3, Local2)
                                If (LGreater (Local0, Local2))
                                {
                                    Store (Local1, Local0)
                                }
                            }

                            Store (Local0, Index (PBST, 0x02))
                        }

                        Store (^SBRG.EC0.BST3 (), DATW)
                        If (LNotEqual (DATW, Ones))
                        {
                            Store (DATW, Index (PBST, 0x03))
                        }
                    }

                    Method (UBLP, 0, Serialized)
                    {
                        If (LEqual (BCGS, One))
                        {
                            Store (0x64, BLTC)
                        }

                        If (LOr (LEqual (BCGS, Zero), LEqual (BCGS, 0x02)))
                        {
                            Store (Zero, BLTC)
                        }
                    }
                }

                Scope (\_SB)
                {
                    Scope (PCI0)
                    {
                        Device (AC0)
                        {
                            Name (_HID, "ACPI0003")
                            Method (_PSR, 0, NotSerialized)
                            {
                                Return (ACPS)
                            }

                            Name (_PCL, Package (0x01)
                            {
                                PCI0
                            })
                        }
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, Zero)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y05)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y06)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y05._LEN, ML01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y05._BAS, MB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y06._LEN, ML02)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y06._BAS, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                        }

                        Return (CRS)
                    }
                }

                Device (^^RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, One)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y07)
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            _Y08)
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            _Y09)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0A)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.RMEM._Y07._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.RMEM._Y07._LEN, LEN1)
                        CreateDWordField (CRS, \_SB.RMEM._Y08._BAS, BAS2)
                        CreateDWordField (CRS, \_SB.RMEM._Y08._LEN, LEN2)
                        CreateDWordField (CRS, \_SB.RMEM._Y09._LEN, LEN3)
                        CreateDWordField (CRS, \_SB.RMEM._Y0A._BAS, BAS4)
                        CreateDWordField (CRS, \_SB.RMEM._Y0A._LEN, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Add (MG2B, MG2L, BAS4)
                        Subtract (Zero, BAS4, LEN4)
                        Return (CRS)
                    }
                }

                Scope (\)
                {
                    Field (\_SB.PCI0.SBRG.GPBX, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x0C), 
                            ,   7, 
                        SB07,   1, 
                            ,   2, 
                        SB10,   1, 
                        SB11,   1, 
                        SB12,   1, 
                        SB13,   1, 
                        SB14,   1, 
                                Offset (0x0F), 
                        SB24,   1, 
                        SB25,   1, 
                        SB26,   1, 
                        SB27,   1, 
                        SB28,   1, 
                                Offset (0x18), 
                            ,   25, 
                        BLNK,   1, 
                                Offset (0x2C), 
                            ,   11, 
                        IV0B,   1, 
                                Offset (0x38), 
                        SB32,   1, 
                        SB33,   1, 
                        SB34,   1, 
                        SB35,   1, 
                        SB36,   1
                    }

                    OperationRegion (RCBA, SystemMemory, 0xFED1C000, 0x4000)
                    Field (RCBA, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x3418), 
                        FDRT,   32
                    }

                    Method (DFTL, 0, NotSerialized)
                    {
                        Store (Zero, TTEN)
                    }

                    Method (EFTL, 0, NotSerialized)
                    {
                        Store (One, TTEN)
                    }
                }

                Scope (\_SB.PCI0.SBRG)
                {
                    Method (OEMI, 0, NotSerialized)
                    {
                    }

                    Method (OEMS, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03)) {}
                    }

                    Name (CLKB, Buffer (0x20) {})
                    Method (RCLK, 0, NotSerialized)
                    {
                        RBLK (0xD2, Zero, CLKB, 0x1F)
                    }

                    Method (WCLK, 0, NotSerialized)
                    {
                        WBLK (0xD2, Zero, 0x1F, CLKB)
                    }

                    Method (RCKB, 1, NotSerialized)
                    {
                        RCLK ()
                        Store (DerefOf (Index (CLKB, Arg0)), Local0)
                        Return (Local0)
                    }

                    Method (WCKB, 2, NotSerialized)
                    {
                        Store (Arg1, Index (CLKB, Arg0))
                    }

                    Name (DATA, Package (0x02)
                    {
                        Zero, 
                        Zero
                    })
                    Mutex (SMBA, 0x00)
                    Method (SMBC, 4, NotSerialized)
                    {
                        Acquire (SMBA, 0xFFFF)
                        Store (0xFF, HSTS)
                        Sleep (0x0A)
                        Store (HSTS, Local0)
                        And (Local0, 0x1F, Local0)
                        Store (0xFF, Local1)
                        While (LAnd (LGreater (Local1, Zero), LNotEqual (Local0, Zero)))
                        {
                            Decrement (Local1)
                            Store (0xFF, HSTS)
                            Sleep (0x0A)
                            Store (HSTS, Local0)
                            And (Local0, 0x1F, Local0)
                        }

                        If (Local0)
                        {
                            Store (0x02, HSTC)
                            Sleep (0x0A)
                            Store (Zero, HSTC)
                            Store (0xFF, HSTS)
                            Sleep (0x0A)
                            Store (HSTS, Local0)
                            And (Local0, 0x1F, Local0)
                            Store (0xFF, Local1)
                            While (LAnd (LGreater (Local1, Zero), LNotEqual (Local0, Zero)))
                            {
                                Decrement (Local1)
                                Store (0xFF, HSTS)
                                Sleep (0x0A)
                                Store (HSTS, Local0)
                                And (Local0, 0x1F, Local0)
                            }

                            If (Local0)
                            {
                                Store (One, Index (DATA, Zero))
                                Return (DATA)
                            }
                        }

                        Store (Arg1, HCMD)
                        Store (Arg0, HADR)
                        And (Arg0, One, Local0)
                        If (LNot (Local0))
                        {
                            And (Arg2, 0x04, Local0)
                            If (Local0)
                            {
                                Store (Arg3, HDTW)
                            }
                            Else
                            {
                                Store (Arg3, HDT0)
                            }
                        }

                        Store (Arg2, HSTC)
                        Sleep (0x0A)
                        Store (HSTS, Local0)
                        Store (0xFF, Local1)
                        While (LGreater (Local1, Zero))
                        {
                            And (Local0, 0x1C, Local2)
                            If (Local2)
                            {
                                Store (One, Index (DATA, Zero))
                                Return (DATA)
                            }

                            And (Local0, 0x02, Local2)
                            If (Local2)
                            {
                                Store (Zero, Index (DATA, Zero))
                                And (Arg2, 0x04, Local2)
                                If (Local0)
                                {
                                    Store (HDTW, Index (DATA, One))
                                }
                                Else
                                {
                                    Store (HDT0, Index (DATA, One))
                                }

                                Return (DATA)
                            }

                            Sleep (0x0A)
                            Store (HSTS, Local0)
                            Decrement (Local1)
                        }

                        Store (One, Index (DATA, Zero))
                        Release (SMBA)
                        Return (DATA)
                    }

                    Method (SMBB, 2, NotSerialized)
                    {
                        Store (Zero, HCMD)
                        Sleep (0x05)
                        Store (Arg0, HADR)
                        Sleep (0x05)
                        Store (0xFF, HSTS)
                        Sleep (0x50)
                        Store (0x54, HSTC)
                        Sleep (0x05)
                        Store (0xFF, Local0)
                        While (Local0)
                        {
                            Decrement (Local0)
                            Sleep (0x02)
                            If (And (HSTS, One))
                            {
                                Sleep (0x02)
                            }

                            If (And (HSTS, 0x02))
                            {
                                Store (Zero, Local0)
                                Store (One, Local1)
                            }
                        }

                        Store (HDT0, Local2)
                        Return (Local2)
                    }

                    Method (WBLK, 4, NotSerialized)
                    {
                        Acquire (SMBA, 0xFFFF)
                        Store (HSTC, Local0)
                        Store (Arg2, Local0)
                        Store (Zero, Local1)
                        While (Local0)
                        {
                            Store (DerefOf (Index (Arg3, Local1)), BLKD)
                            Decrement (Local0)
                            Increment (Local1)
                        }

                        Store (HSTC, Local0)
                        Store (Arg2, HDT0)
                        SMBB (Arg0, Arg1)
                        Release (SMBA)
                    }

                    Method (RBLK, 4, NotSerialized)
                    {
                        Acquire (SMBA, 0xFFFF)
                        Or (Arg0, One, Local0)
                        Store (SMBB (Local0, Arg1), Local1)
                        Store (HSTC, Local0)
                        Store (Arg3, Local0)
                        Add (Local1, One, Local2)
                        Store (Zero, Local1)
                        While (Local0)
                        {
                            Store (BLKD, Index (Arg2, Local1))
                            Decrement (Local0)
                            Increment (Local1)
                        }

                        Release (SMBA)
                    }

                    Name (CKFG, Package (0x03)
                    {
                        Package (0x09)
                        {
                            0x32, 
                            0x69, 
                            0x87, 
                            0x32, 
                            0xCF, 
                            0x68, 
                            0x1E, 
                            0x30, 
                            One
                        }, 

                        Package (0x09)
                        {
                            0x32, 
                            0x64, 
                            0x1F, 
                            0x30, 
                            0xCF, 
                            0x68, 
                            0x1E, 
                            0x30, 
                            One
                        }, 

                        Package (0x09)
                        {
                            0x32, 
                            0x4B, 
                            0x16, 
                            0x24, 
                            0xCF, 
                            0x68, 
                            0x1E, 
                            0x30, 
                            Zero
                        }
                    })
                    Name (CKFT, Package (0x02)
                    {
                        Package (0x09)
                        {
                            0xB2, 
                            0x5B, 
                            0x07, 
                            0x2C, 
                            0xCF, 
                            0x68, 
                            0x1E, 
                            0x30, 
                            One
                        }, 

                        Package (0x09)
                        {
                            0x32, 
                            0x54, 
                            0x6B, 
                            0x28, 
                            0xCF, 
                            0x68, 
                            0x1E, 
                            0x30, 
                            One
                        }
                    })
                    Method (FSBA, 1, NotSerialized)
                    {
                        Store (Arg0, Local0)
                        And (Local0, 0xFF, Local0)
                        ^EC0.ECXW (0xE1, One)
                        If (LNotEqual (Local0, 0x03))
                        {
                            RCLK ()
                            And (RCKB (Zero), 0xDF, Local2)
                            WCKB (Zero, Local2)
                            WCLK ()
                            Sleep (0x0A)
                            If (LEqual (FS70, 0x02))
                            {
                                FSBT (One)
                                FSBT (Zero)
                                FSBX (One)
                            }
                            Else
                            {
                                FSBX (One)
                            }

                            If (LEqual (Local0, 0x02))
                            {
                                FSBT (Zero)
                                FSBT (One)
                            }

                            Sleep (0x0A)
                            If (LEqual (Local0, Zero))
                            {
                                RCLK ()
                                WCKB (0x0F, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x04
                                    )))
                                WCKB (0x10, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x05
                                    )))
                                WCKB (0x11, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x06
                                    )))
                                WCKB (0x12, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x07
                                    )))
                                WCLK ()
                                Sleep (0x32)
                            }

                            RCLK ()
                            WCKB (0x0B, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), Zero
                                )))
                            WCKB (0x0C, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), One
                                )))
                            WCKB (0x0D, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x02
                                )))
                            WCKB (0x0E, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x03
                                )))
                            WCLK ()
                            Sleep (0x32)
                            RCLK ()
                            Or (RCKB (Zero), 0x20, Local2)
                            WCKB (Zero, Local2)
                            WCLK ()
                            Sleep (0x0A)
                        }
                        Else
                        {
                            If (ACPS)
                            {
                                FSBX (One)
                            }
                            Else
                            {
                                FSBX (0x02)
                                ^EC0.ECXW (0xE1, Zero)
                            }
                        }

                        If (LEqual (Local0, 0x02))
                        {
                            ^EC0.ECXW (0xE1, Zero)
                        }
                    }

                    Method (FSBX, 1, NotSerialized)
                    {
                        RCLK ()
                        WCKB (0x0B, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), Zero
                            )))
                        WCKB (0x0C, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), One
                            )))
                        WCKB (0x0D, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x02
                            )))
                        WCKB (0x0E, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x03
                            )))
                        WCLK ()
                        Sleep (0x32)
                        RCLK ()
                        WCKB (0x0F, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x04
                            )))
                        WCKB (0x10, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x05
                            )))
                        WCKB (0x11, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x06
                            )))
                        WCKB (0x12, DerefOf (Index (DerefOf (Index (CKFG, Arg0)), 0x07
                            )))
                        WCLK ()
                        Sleep (0x32)
                    }

                    Method (FSBT, 1, NotSerialized)
                    {
                        RCLK ()
                        WCKB (0x0B, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), Zero
                            )))
                        WCKB (0x0C, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), One
                            )))
                        WCKB (0x0D, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), 0x02
                            )))
                        WCKB (0x0E, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), 0x03
                            )))
                        WCLK ()
                        Sleep (0x32)
                        RCLK ()
                        WCKB (0x0F, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), 0x04
                            )))
                        WCKB (0x10, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), 0x05
                            )))
                        WCKB (0x11, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), 0x06
                            )))
                        WCKB (0x12, DerefOf (Index (DerefOf (Index (CKFT, Arg0)), 0x07
                            )))
                        WCLK ()
                        Sleep (0x32)
                    }

                    Method (FSBG, 0, Serialized)
                    {
                        Store (SizeOf (CKFG), Local0)
                        Store (SizeOf (Index (CKFG, Zero)), Local1)
                        Divide (Local0, Local1, Local0)
                        Store (FS70, Local1)
                        ShiftLeft (Local0, 0x08, Local0)
                        Return (Add (Local0, Local1))
                    }
                }

                Scope (\)
                {
                    Method (OCMS, 1, Serialized)
                    {
                        SNVS (0x1637, Arg0)
                        If (Arg0)
                        {
                            Store (One, SB35)
                        }
                        Else
                        {
                            Store (Zero, SB35)
                        }

                        Sleep (0x01F4)
                        Notify (\_SB.PCI0.USB3, Zero)
                        Return (One)
                    }

                    Method (OCMG, 0, Serialized)
                    {
                        Store (GNVS (0x1637), Local0)
                        Return (Local0)
                    }

                    Method (OMDS, 1, Serialized)
                    {
                        SNVS (0x1639, Arg0)
                        If (Arg0)
                        {
                            Store (One, SB28)
                        }
                        Else
                        {
                            Store (Zero, SB28)
                        }

                        Return (One)
                    }

                    Method (OMDG, 0, Serialized)
                    {
                        Store (GNVS (0x1639), Local0)
                        Return (Local0)
                    }

                    Method (OCRS, 1, Serialized)
                    {
                        SNVS (0x1636, Arg0)
                        If (Arg0)
                        {
                            Store (Zero, SB27)
                        }
                        Else
                        {
                            Store (One, SB27)
                        }

                        Sleep (0x64)
                        Notify (\_SB.PCI0.USB2, Zero)
                        Return (One)
                    }

                    Method (OCRG, 0, Serialized)
                    {
                        Store (GNVS (0x1636), Local0)
                        Return (Local0)
                    }

                    Method (OWLS, 1, Serialized)
                    {
                        SNVS (0x1638, Arg0)
                        If (Arg0)
                        {
                            Store (One, SB07)
                            Store (Zero, SB24)
                            Sleep (0x03E8)
                            Store (Zero, SB10)
                            Sleep (0x64)
                            Notify (\_SB.PCI0.P0P7, Zero)
                            Sleep (0x64)
                            Notify (\_SB.PCI0.P0P7, Zero)
                        }
                        Else
                        {
                            If (LEqual (SB36, Zero))
                            {
                                Store (Zero, SB07)
                            }

                            Store (One, SB10)
                            Sleep (0x64)
                            Store (One, SB24)
                            Sleep (0x64)
                            Notify (\_SB.PCI0.P0P7, Zero)
                            Sleep (0x64)
                            Notify (\_SB.PCI0.P0P7, Zero)
                        }

                        Return (One)
                    }

                    Method (OWLG, 0, Serialized)
                    {
                        Store (GNVS (0x1638), Local0)
                        Return (Local0)
                    }

                    Method (OBTS, 1, Serialized)
                    {
                        SNVS (0x163C, Arg0)
                        If (Arg0)
                        {
                            Store (One, SB36)
                            Store (One, SB07)
                            Sleep (0x03E8)
                            Notify (\_SB.PCI0.USB3, Zero)
                            Sleep (0x64)
                            Notify (\_SB.PCI0.USB3, Zero)
                        }
                        Else
                        {
                            Store (Zero, SB36)
                            If (LEqual (SB24, One))
                            {
                                Store (Zero, SB07)
                            }

                            Sleep (0x64)
                            Notify (\_SB.PCI0.USB3, Zero)
                            Sleep (0x64)
                            Notify (\_SB.PCI0.USB3, Zero)
                        }

                        Return (One)
                    }

                    Method (OBTG, 0, Serialized)
                    {
                        Store (GNVS (0x163C), Local0)
                        Return (Local0)
                    }

                    Method (O3GS, 1, Serialized)
                    {
                        SNVS (0x163A, Arg0)
                        If (Arg0)
                        {
                            Store (Zero, SB14)
                        }
                        Else
                        {
                            Store (One, SB14)
                        }

                        Return (One)
                    }

                    Method (O3GG, 0, Serialized)
                    {
                        Store (GNVS (0x163A), Local0)
                        Return (Local0)
                    }

                    Method (OWIS, 1, Serialized)
                    {
                        SNVS (0x1658, Arg0)
                        If (Arg0)
                        {
                            Store (Zero, SB14)
                        }
                        Else
                        {
                            Store (One, SB14)
                        }

                        Return (One)
                    }

                    Method (OWIG, 0, Serialized)
                    {
                        Store (GNVS (0x1658), Local0)
                        Return (Local0)
                    }
                }
            }

            Device (IDE0)
            {
                Name (_ADR, 0x001F0002)
                Name (^NATA, Package (0x01)
                {
                    0x001F0002
                })
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Name (TIM0, Package (0x08)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 

                    Package (0x06)
                    {
                        0x70, 
                        0x49, 
                        0x36, 
                        0x27, 
                        0x19, 
                        0x14
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    PMPT,   4, 
                    PSPT,   4, 
                    PMRI,   6, 
                            Offset (0x02), 
                    SMPT,   4, 
                    SSPT,   4, 
                    SMRI,   6, 
                            Offset (0x04), 
                    PSRI,   4, 
                    SSRI,   4, 
                            Offset (0x08), 
                    PM3E,   1, 
                    PS3E,   1, 
                    SM3E,   1, 
                    SS3E,   1, 
                            Offset (0x0A), 
                    PMUT,   2, 
                        ,   2, 
                    PSUT,   2, 
                            Offset (0x0B), 
                    SMUT,   2, 
                        ,   2, 
                    SSUT,   2, 
                            Offset (0x0C), 
                            Offset (0x14), 
                    PM6E,   1, 
                    PS6E,   1, 
                    SM6E,   1, 
                    SS6E,   1, 
                    PMCR,   1, 
                    PSCR,   1, 
                    SMCR,   1, 
                    SSCR,   1, 
                        ,   4, 
                    PMAE,   1, 
                    PSAE,   1, 
                    SMAE,   1, 
                    SSAE,   1
                }

                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local1)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local2)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (PMRI, Local1, PMUT, PSRI, Local2, PSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local0)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local1)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (PMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        If (And (Local0, One))
                        {
                            Store (One, PM3E)
                        }
                        Else
                        {
                            Store (Zero, PM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, PM6E)
                        }
                        Else
                        {
                            Store (Zero, PM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, PMAE)
                        }
                        Else
                        {
                            Store (Zero, PMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, PS3E)
                        }
                        Else
                        {
                            Store (Zero, PS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, PS6E)
                        }
                        Else
                        {
                            Store (Zero, PS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, PSAE)
                        }
                        Else
                        {
                            Store (Zero, PSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local1)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local2)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (SMRI, Local1, SMUT, SSRI, Local2, SSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local0)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local1)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (SMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        If (And (Local0, One))
                        {
                            Store (One, SM3E)
                        }
                        Else
                        {
                            Store (Zero, SM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, SM6E)
                        }
                        Else
                        {
                            Store (Zero, SM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, SMAE)
                        }
                        Else
                        {
                            Store (Zero, SMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, SS3E)
                        }
                        Else
                        {
                            Store (Zero, SS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, SS6E)
                        }
                        Else
                        {
                            Store (Zero, SS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, SSAE)
                        }
                        Else
                        {
                            Store (Zero, SSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (And (Arg1, 0x20))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    If (And (Arg4, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, 0x02)), MEQ, Arg3, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (And (Arg1, 0x07))
                    {
                        Store (Arg2, Local5)
                        If (And (Arg1, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg1, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (And (Arg4, 0x07))
                    {
                        Store (Arg5, Local5)
                        If (And (Arg4, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg4, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF) {}
                    Else
                    {
                        Store (Zero, GMUE)
                        Store (Zero, GMUT)
                        Store (Zero, GSUE)
                        Store (Zero, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GMUT)
                            Or (GMUE, One, GMUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GMUE, 0x02, GMUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GMUE, 0xFD, GMUE)
                                Or (GMUE, 0x04, GMUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                    Or (GMUE, 0x80, GMUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GSUT)
                            Or (GSUE, One, GSUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GSUE, 0x02, GSUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GSUE, 0xFD, GSUE)
                                Or (GSUE, 0x04, GSUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                    Or (GSUE, 0x80, GSUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x02))
                        {
                            Or (GMUE, 0x20, GMUE)
                        }

                        If (And (CHNF, 0x08))
                        {
                            Or (GSUE, 0x20, GSUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                            Local1)
                        Store (Local1, GMPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GMUE, 0x50, GMUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            Local1)
                        Store (Local1, GSPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GSUE, 0x50, GSUE)
                        }
                    }
                }

                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x05))
                        {
                            Store (0x05, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Concatenate (RETB, FZTF, RETB)
                    Return (RETB)
                }

                Name (FZTF, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
            }

            Device (IDE1)
            {
                Name (_ADR, 0x001F0001)
            }

            Device (P0P6)
            {
                Name (_ADR, 0x001C0002)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }

                    Return (PR06)
                }
            }

            Device (P0P7)
            {
                Name (_ADR, 0x001C0003)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR07)
                    }

                    Return (PR07)
                }
            }

            Device (P0P8)
            {
                Name (_ADR, 0x001C0004)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR08)
                    }

                    Return (PR08)
                }
            }

            Device (P0P9)
            {
                Name (_ADR, 0x001C0005)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR09)
                    }

                    Return (PR09)
                }
            }

            Device (P0P4)
            {
                Name (_ADR, 0x001C0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR04)
                    }

                    Return (PR04)
                }
            }

            Device (MC97)
            {
                Name (_ADR, 0x001E0003)
            }

            Device (USB0)
            {
                Name (_ADR, 0x001D0000)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x001D0001)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x001D0002)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x001D0003)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }
            }

            Device (EUSB)
            {
                Name (_ADR, 0x001D0007)
            }

            Device (VGA)
            {
                Name (_ADR, 0x00020000)
                Name (VGAB, Buffer (0x02) {})
                CreateWordField (VGAB, Zero, DISD)
                CreateByteField (VGAB, Zero, NXTD)
                CreateByteField (VGAB, One, AVLD)
                Name (LCDM, One)
                Name (CRTM, 0x02)
                Name (TVOM, 0x04)
                Name (DONE, Zero)
                Name (DOSF, One)
                Method (_INI, 0, NotSerialized)
                {
                    Store (GETD (), DISD)
                    Store (One, DONE)
                }

                Method (_DOS, 1, NotSerialized)
                {
                    Store (Arg0, DOSF)
                }

                Method (_DOD, 0, NotSerialized)
                {
                    Return (Package (0x03)
                    {
                        0x00010100, 
                        0x00010200, 
                        0x00010400
                    })
                }

                Method (CDCS, 1, NotSerialized)
                {
                    Store (0x0D, Local0)
                    If (And (NXTD, Arg0))
                    {
                        Or (Local0, 0x02, Local0)
                    }

                    If (And (AVLD, Arg0))
                    {
                        Or (Local0, 0x10, Local0)
                    }

                    Return (Local0)
                }

                Method (CDGS, 1, NotSerialized)
                {
                    If (And (NXTD, Arg0))
                    {
                        Return (One)
                    }

                    Return (Zero)
                }

                Device (CRTD)
                {
                    Name (_ADR, 0x0100)
                    Method (_DCS, 0, NotSerialized)
                    {
                        Return (CDCS (CRTM))
                    }

                    Method (_DGS, 0, NotSerialized)
                    {
                        Return (CDGS (CRTM))
                    }

                    Method (_DSS, 1, NotSerialized)
                    {
                        If (And (Arg0, 0x40000000))
                        {
                            If (And (Arg0, 0x80000000))
                            {
                                Store (One, DONE)
                            }
                        }
                    }
                }

                Device (TVOD)
                {
                    Name (_ADR, 0x0200)
                    Method (_DCS, 0, NotSerialized)
                    {
                        Return (CDCS (TVOM))
                    }

                    Method (_DGS, 0, NotSerialized)
                    {
                        Return (CDGS (TVOM))
                    }

                    Method (_DSS, 1, NotSerialized)
                    {
                        If (And (Arg0, 0x40000000))
                        {
                            If (And (Arg0, 0x80000000))
                            {
                                Store (One, DONE)
                            }
                        }
                    }
                }

                Device (LCDD)
                {
                    Name (_ADR, 0x0400)
                    Method (_DCS, 0, NotSerialized)
                    {
                        Return (CDCS (LCDM))
                    }

                    Method (_DGS, 0, NotSerialized)
                    {
                        Return (CDGS (LCDM))
                    }

                    Method (_DSS, 1, NotSerialized)
                    {
                        If (And (Arg0, 0x40000000))
                        {
                            If (And (Arg0, 0x80000000))
                            {
                                Store (One, DONE)
                            }
                        }
                    }
                }

                Method (SWHD, 1, Serialized)
                {
                    If (DOSF)
                    {
                        Store (Arg0, PAR1)
                        ISMI (0x73)
                    }
                    Else
                    {
                        Notify (VGA, 0x80)
                    }

                    Store (One, DONE)
                }

                Method (GETD, 0, NotSerialized)
                {
                    ISMI (0x72)
                    Return (PAR1)
                }

                Method (GETN, 0, Serialized)
                {
                    If (DONE)
                    {
                        Store (GETD (), DISD)
                    }

                    Store (Zero, DONE)
                    Store (Zero, Local0)
                    While (LNotEqual (NXTD, Local0))
                    {
                        Increment (NXTD)
                        If (LEqual (NXTD, 0x07))
                        {
                            Increment (NXTD)
                        }

                        If (And (NXTD, 0xF8))
                        {
                            Store (One, NXTD)
                        }

                        And (NXTD, AVLD, Local0)
                    }

                    Return (NXTD)
                }
            }

            Device (P0P5)
            {
                Name (_ADR, 0x001C0001)
                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR05)
                    }

                    Return (PR05)
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L09, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P2, 0x02)
                Notify (\_SB.PCI0.P0P6, 0x02)
                Notify (\_SB.PCI0.P0P7, 0x02)
                Notify (\_SB.PCI0.P0P8, 0x02)
                Notify (\_SB.PCI0.P0P9, 0x02)
                Notify (\_SB.PCI0.P0P4, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0B, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
        }
    }

    OperationRegion (_SB.PCI0.SBRG.PIX0, PCI_Config, 0x60, 0x0C)
    Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
    {
        PIRA,   8, 
        PIRB,   8, 
        PIRC,   8, 
        PIRD,   8, 
                Offset (0x08), 
        PIRE,   8, 
        PIRF,   8, 
        PIRG,   8, 
        PIRH,   8
    }

    Scope (_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        CreateWordField (BUFA, One, IRA0)
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRA, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRA, 0x80, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRA, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRB, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRB, 0x80, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRB, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRC, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRC, 0x80, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRC, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRD, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRD, 0x80, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRD, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRE, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRE, 0x80, PIRE)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRE, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x06)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRF, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRF, 0x80, PIRF)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRF, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRG, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRG, 0x80, PIRG)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRG, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRH, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRH, 0x80, PIRH)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRH, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }

    OperationRegion (SMRG, SystemIO, SMBS, 0x10)
    Field (SMRG, ByteAcc, NoLock, Preserve)
    {
        HSTS,   8, 
        SSTS,   8, 
        HSTC,   8, 
        HCMD,   8, 
        HADR,   8, 
        HDT0,   8, 
        HDT1,   8, 
        BLKD,   8
    }

    Field (SMRG, ByteAcc, NoLock, Preserve)
    {
                Offset (0x05), 
        HDTW,   16
    }

    Method (SCMD, 4, NotSerialized)
    {
        Store (0x05, Local0)
        While (Local0)
        {
            Store (Arg0, HADR)
            Store (Arg1, HCMD)
            Store (Arg2, HDTW)
            Store (0xFF, HSTS)
            Store (Arg3, HSTC)
            Store (0xFF, Local7)
            While (Local7)
            {
                Decrement (Local7)
                If (And (HSTS, 0x02))
                {
                    Store (Zero, Local7)
                    Store (One, Local0)
                }
            }

            Decrement (Local0)
        }

        If (And (HSTS, 0x02))
        {
            Return (HDTW)
        }
        Else
        {
            Return (Ones)
        }
    }

    Method (SBYT, 2, NotSerialized)
    {
        SCMD (Arg0, Arg1, Zero, 0x44)
    }

    Method (WBYT, 3, NotSerialized)
    {
        SCMD (Arg0, Arg1, Arg2, 0x48)
    }

    Method (WWRD, 3, NotSerialized)
    {
        SCMD (Arg0, Arg1, Arg2, 0x4C)
    }

    Method (RSBT, 2, NotSerialized)
    {
        Or (Arg0, One, Arg0)
        Return (SCMD (Arg0, Arg1, Zero, 0x44))
    }

    Method (RBYT, 2, NotSerialized)
    {
        Or (Arg0, One, Arg0)
        Return (SCMD (Arg0, Arg1, Zero, 0x48))
    }

    Method (RWRD, 2, NotSerialized)
    {
        Or (Arg0, One, Arg0)
        Return (SCMD (Arg0, Arg1, Zero, 0x4C))
    }

    Scope (_TZ)
    {
        Name (LTMP, 0x3C)
        Name (TCRT, 0x5A)
        Name (TSP, 0x1E)
        Method (KELV, 1, NotSerialized)
        {
            And (Arg0, 0xFF, Local0)
            Multiply (Local0, 0x0A, Local0)
            Add (Local0, 0x0AAC, Local0)
            Return (Local0)
        }

        Method (RTMP, 0, Serialized)
        {
            Store (\_SB.PCI0.SBRG.EC0.RCTP (), Local0)
            If (LLess (Local0, 0xFF))
            {
                Store (Local0, LTMP)
            }

            Return (LTMP)
        }

        ThermalZone (TZ00)
        {
            Name (_TZP, 0x012C)
            Method (_CRT, 0, NotSerialized)
            {
                Return (KELV (TCRT))
            }

            Method (_TMP, 0, NotSerialized)
            {
                Store (0x05, Local1)
                While (Local1)
                {
                    Store (RTMP (), Local0)
                    If (LGreater (Local0, TCRT))
                    {
                        Decrement (Local1)
                    }
                    Else
                    {
                        Store (Zero, Local1)
                    }
                }

                Return (KELV (Local0))
            }

            Method (_TSP, 0, NotSerialized)
            {
                Multiply (TSP, One, Local0)
                Return (Local0)
            }
        }
    }

    Scope (_SB)
    {
        Name (XCPD, Zero)
        Name (XNPT, One)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x0FFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }

        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (RDPE (Local0), Local1)
            If (LEqual (Local1, Ones))
            {
                Return (Zero)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    WDPE (Local0, And (Local1, 0x00010000))
                    Return (One)
                }

                Return (Zero)
            }
        }
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, _Y0B, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y0C, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y0B._MIN, MIN5)
            CreateDWordField (CRS, \_SB.PCI0._Y0B._MAX, MAX5)
            CreateDWordField (CRS, \_SB.PCI0._Y0B._LEN, LEN5)
            CreateDWordField (CRS, \_SB.PCI0._Y0C._MIN, MIN6)
            CreateDWordField (CRS, \_SB.PCI0._Y0C._MAX, MAX6)
            CreateDWordField (CRS, \_SB.PCI0._Y0C._LEN, LEN6)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Return (CRS)
            }
        }
    }

    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)
    {
        Store (Arg0, DBG8)
        PTS (Arg0)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
    }

    Method (_WAK, 1, NotSerialized)
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        Return (WAKP)
    }

    Name (_S0, Package (0x04)
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x06, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.SBRG.EC0.EC0S (Arg0)
            \_SB.PCI0.NPTS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
            LPFS (Arg0)
        }
    }

    Scope (_SB.PCI0)
    {
        Method (_INI, 0, NotSerialized)
        {
            Return (OSFL ())
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.SBRG.EC0.EC0W (Arg0)
        \_SB.PCI0.NWAK (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
        LPWK (Arg0)
    }
}

