/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20060912
 *
 * Disassembly of (null), Wed Feb 27 20:02:12 2008
 *
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x0000C1A0 (49568)
 *     Revision         0x01
 *     OEM ID           "TOSASU"
 *     OEM Table ID     "TOSASU00"
 *     OEM Revision     0x00000000 (0)
 *     Creator ID       "INTL"
 *     Creator Revision 0x20051117 (537202967)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "TOSASU", "TOSASU00", 0x00000000)
{
    Scope (_PR)
    {
        Processor (P001, 0x01, 0x00000810, 0x06) {}
        Alias (P001, CPU1)
    }

    Scope (_PR)
    {
        Processor (P002, 0x02, 0x00000810, 0x06) {}
        Alias (P002, CPU2)
    }

    Method (WDTS, 1, NotSerialized)
    {
        If (LEqual (Arg0, 0x03))
        {
            TRAP (0x46)
        }

        If (LEqual (Arg0, 0x04))
        {
            If (DTSE)
            {
                TRAP (0x47)
            }

            Notify (\_TZ.THRM, 0x80)
        }
    }

    Method (TRAP, 1, NotSerialized)
    {
        OperationRegion (SSMI, SystemIO, SMIP, One)
        Field (SSMI, ByteAcc, NoLock, Preserve)
        {
            SMIC,   8
        }

        Store (Arg0, SMIF)
        Store (DTSS, SMIC)
    }

    Scope (_SB)
    {
        Method (_INI, 0, NotSerialized)
        {
            If (DTSE)
            {
                TRAP (0x47)
            }
        }
    }

    Scope (_GPE)
    {
        Method (_L02, 0, NotSerialized)
        {
            Store (Zero, GPEC)
            ODTS ()
            Notify (\_TZ.THRM, 0x80)
        }
    }

    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (DTSS, 0x5A)
    Name (SMIP, 0xB2)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (GPBS, 0x0500)
    Name (GPLN, 0x40)
    Name (PM30, 0x0830)
    Name (SUSW, 0xFF)
    Name (APIC, One)
    Name (TOBS, 0x0860)
    Name (SUCC, One)
    Name (NVLD, 0x02)
    Name (CRIT, 0x04)
    Name (NCRT, 0x06)
    Name (LIDS, One)
    Name (PCIB, 0xE0000000)
    Name (PCIL, 0x10000000)
    Name (TPM1, 0x4700)
    Name (TPM3, 0x0254)
    Name (MBLF, 0x0A)
    Name (HPIO, 0x025E)
    Name (SMBS, 0x0400)
    Name (SMBL, 0x20)
    OperationRegion (BIOS, SystemMemory, 0x1F7AE064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
                Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32
    }

    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            DIAG (0xAA)
        }
        Else
        {
            DIAG (0xAC)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, Zero))
        {
            Store (0xAC, DBG8)
        }

        Store (One, OSVR)
        If (CondRefOf (_OSI, Local1))
        {
            If (_OSI ("Windows 2001"))
            {
                Store (Zero, OSVR)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (0x04, OSVR)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x02, OSVR)
                }

                If (MCTH (_OS, "Linux"))
                {
                    Store (0x03, OSVR)
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, DP80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Scope (_SB)
    {
        Name (PR00, Package (0x13)
        {
            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR00, Package (0x13)
        {
            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR02, Package (0x01)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }
        })
        Name (AR02, Package (0x01)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }
        })
        Name (PR06, Package (0x03)
        {
            Package (0x04)
            {
                0x0007FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKD, 
                Zero
            }
        })
        Name (AR06, Package (0x03)
        {
            Package (0x04)
            {
                0x0007FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x13
            }
        })
        Name (PR03, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR03, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,6,7,10,11,12}
        })
        Name (PRSB, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,6,7,10,12}
        })
        Alias (PRSB, PRSC)
        Alias (PRSB, PRSD)
        Name (PRSE, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {6}
        })
        Alias (PRSB, PRSF)
        Alias (PRSB, PRSG)
        Alias (PRSB, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))
            Name (_ADR, Zero)
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_S3D, 0, NotSerialized)
            {
                If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Name (_CID, 0x030AD041)
            Device (MCH)
            {
                Name (_HID, EisaId ("PNP0C01"))
                Name (_UID, 0x0A)
                Name (_CRS, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED14000,         // Address Base
                        0x00006000,         // Address Length
                        )
                })
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (SBRG)
            {
                Name (_ADR, 0x001F0000)
                Device (IELK)
                {
                    Name (_HID, "AWY0001")
                    OperationRegion (RXA0, PCI_Config, 0xA0, 0x20)
                    Field (RXA0, ByteAcc, NoLock, Preserve)
                    {
                            ,   9, 
                        PBLV,   1, 
                        BCPE,   1, 
                                Offset (0x10), 
                            ,   1, 
                        PBMS,   1, 
                            ,   1, 
                        PMCS,   1, 
                        ECNS,   1, 
                                Offset (0x11), 
                        ECT1,   16, 
                        ELEN,   1, 
                                Offset (0x14)
                    }

                    Method (\_GPE._L0A, 0, NotSerialized)
                    {
                        Notify (\_SB.PCI0.SBRG.IELK, 0x81)
                        Store (One, \_SB.PCI0.SBRG.IELK.PMCS)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (ELEN)
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (SMOD, 1, NotSerialized)
                    {
                    }

                    Method (GPBS, 0, NotSerialized)
                    {
                        Return (XOr (PBLV, One))
                    }
                }

                Method (SPTS, 1, NotSerialized)
                {
                    Store (One, PS1S)
                    Store (One, PS1E)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, PS1E)
                }

                OperationRegion (APMP, SystemIO, SMIP, 0x02)
                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                    APMC,   8, 
                    APMS,   8
                }

                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x01), 
                        ,   1, 
                    BRTC,   1
                }

                OperationRegion (PMS0, SystemIO, PMBS, 0x04)
                Field (PMS0, ByteAcc, NoLock, Preserve)
                {
                        ,   10, 
                    RTCS,   1, 
                        ,   4, 
                    WAKS,   1, 
                            Offset (0x03), 
                    PWBT,   1, 
                            Offset (0x04)
                }

                OperationRegion (SMIE, SystemIO, PM30, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PS1E,   1, 
                        ,   31, 
                    PS1S,   1, 
                            Offset (0x08)
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, 0x0B03D041)
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Device (PS2M)
                {
                    Method (_HID, 0, NotSerialized)
                    {
                        If (SYNA)
                        {
                            Return (0x0E0A2E4F)
                        }

                        If (ALPS)
                        {
                            Return (0x0713A906)
                        }

                        Return (0x0E0A2E4F)
                    }

                    Name (_CID, Package (0x05)
                    {
                        0x000A2E4F, 
                        0x02002E4F, 
                        0x030FD041, 
                        0x130FD041, 
                        0x120FD041
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (CRS1, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (CRS2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (CRS1)
                        }
                        Else
                        {
                            Return (CRS2)
                        }
                    }
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0063,             // Range Minimum
                            0x0063,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0067,             // Range Minimum
                            0x0067,             // Range Maximum
                            0x00,               // Alignment
                            0x09,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y00)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y01)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y02)
                        Memory32Fixed (ReadWrite,
                            0xFED1C000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED20000,         // Address Base
                            0x00020000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED45000,         // Address Base
                            0x00045000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFFB00000,         // Address Base
                            0x00100000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFFF00000,         // Address Base
                            0x00100000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MIN, GP00)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MAX, GP01)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._LEN, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._LEN, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._LEN, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }

                        Return (CRS)
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xFED00000,         // Address Base
                            0x00000400,         // Address Length
                            _Y03)
                    })
                    OperationRegion (^LPCR, SystemMemory, 0xFED1F404, 0x04)
                    Field (LPCR, AnyAcc, NoLock, Preserve)
                    {
                        HPTS,   2, 
                            ,   5, 
                        HPTE,   1, 
                                Offset (0x04)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (OSFL (), Zero))
                        {
                            If (HPTE)
                            {
                                Return (0x0F)
                            }
                        }
                        Else
                        {
                            If (HPTE)
                            {
                                Return (0x0B)
                            }
                        }

                        Return (Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.HPET._Y03._BAS, HPT)
                        Multiply (HPTS, 0x1000, Local0)
                        Add (Local0, 0xFED00000, HPT)
                        Return (CRS)
                    }
                }

                OperationRegion (RX80, PCI_Config, Zero, 0xFF)
                Field (RX80, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x80), 
                    LPCD,   16, 
                    LPCE,   16
                }

                Name (DBPT, Package (0x04)
                {
                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x03)
                    {
                        0x0378, 
                        0x0278, 
                        0x03BC
                    }, 

                    Package (0x02)
                    {
                        0x03F0, 
                        0x0370
                    }
                })
                Name (DDLT, Package (0x04)
                {
                    Package (0x02)
                    {
                        Zero, 
                        0xFFF8
                    }, 

                    Package (0x02)
                    {
                        0x04, 
                        0xFF8F
                    }, 

                    Package (0x02)
                    {
                        0x08, 
                        0xFCFF
                    }, 

                    Package (0x02)
                    {
                        0x0C, 
                        0xEFFF
                    }
                })
                Method (RRIO, 4, NotSerialized)
                {
                    If (LAnd (LLessEqual (Arg0, 0x03), LGreaterEqual (Arg0, Zero)))
                    {
                        Store (Match (DerefOf (Index (DBPT, Arg0)), MEQ, Arg2, MTR, 
                            Zero, Zero), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), Zero)), 
                                Local1)
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), One)), 
                                Local2)
                            ShiftLeft (Local0, Local1, Local0)
                            And (LPCD, Local2, LPCD)
                            Or (LPCD, Local0, LPCD)
                            WX82 (Arg0, Arg1)
                        }
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        If (LEqual (Arg2, 0x0200))
                        {
                            WX82 (0x08, Arg0)
                        }
                        Else
                        {
                            If (LEqual (Arg2, 0x0208))
                            {
                                WX82 (0x09, Arg0)
                            }
                        }
                    }

                    If (LAnd (LLessEqual (Arg0, 0x0D), LGreaterEqual (Arg0, 0x0A)))
                    {
                        WX82 (Arg0, Arg1)
                    }
                }

                Method (WX82, 2, NotSerialized)
                {
                    ShiftLeft (One, Arg0, Local0)
                    If (Arg1)
                    {
                        Or (LPCE, Local0, LPCE)
                    }
                    Else
                    {
                        Not (Local0, Local0)
                        And (LPCE, Local0, LPCE)
                    }
                }

                Method (RDMA, 3, NotSerialized)
                {
                }

                Device (^PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xE0000000,         // Address Base
                            0x10000000,         // Address Length
                            _Y04)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y04._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y04._LEN, LEN1)
                        Store (PCIB, BAS1)
                        Store (PCIL, LEN1)
                        Return (CRS)
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, Zero)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y05)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y06)
                        IO (Decode16,
                            0x0250,             // Range Minimum
                            0x0253,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0256,             // Range Minimum
                            0x025F,             // Range Maximum
                            0x01,               // Alignment
                            0x0A,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y05._LEN, ML01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y05._BAS, MB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y06._LEN, ML02)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y06._BAS, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                        }

                        Return (CRS)
                    }
                }

                Device (^^RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, One)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y07)
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            _Y08)
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            _Y09)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0A)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.RMEM._Y07._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.RMEM._Y07._LEN, LEN1)
                        CreateDWordField (CRS, \_SB.RMEM._Y08._BAS, BAS2)
                        CreateDWordField (CRS, \_SB.RMEM._Y08._LEN, LEN2)
                        CreateDWordField (CRS, \_SB.RMEM._Y09._LEN, LEN3)
                        CreateDWordField (CRS, \_SB.RMEM._Y0A._BAS, BAS4)
                        CreateDWordField (CRS, \_SB.RMEM._Y0A._LEN, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Add (MG2B, MG2L, BAS4)
                        Subtract (Zero, BAS4, LEN4)
                        Return (CRS)
                    }
                }

                Device (DSIO)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x05)
                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0260,             // Range Minimum
                            0x0260,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (CRS1)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (ACRD)
                        {
                            Return (0x1F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }
                }

                Method (SEDN, 1, NotSerialized)
                {
                    Store (Arg0, LDN)
                }

                OperationRegion (IOID, SystemIO, HPIO, 0x02)
                Field (IOID, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x07), 
                    LDN,    8, 
                            Offset (0x30), 
                    ACTR,   8, 
                            Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IOH2,   8, 
                    IOL2,   8, 
                            Offset (0x70), 
                    INTR,   8, 
                            Offset (0x74), 
                    DMCH,   8, 
                            Offset (0xF0), 
                    OPT0,   8, 
                    OPT1,   8, 
                    OPT2,   8
                }

                Method (DCNT, 2, NotSerialized)
                {
                    SEDN (Arg0)
                    ShiftLeft (IOAH, 0x08, Local1)
                    Or (IOAL, Local1, Local1)
                    If (LAnd (LLess (DMCH, 0x04), LNotEqual (And (DMCH, 0x03, 
                        Local1), Zero)))
                    {
                        RDMA (Arg0, Arg1, Increment (Local1))
                    }

                    Store (Arg1, ACTR)
                    RRIO (Arg0, Arg1, Local1, 0x08)
                }

                Device (CIR)
                {
                    Name (_HID, EisaId ("ITE8707"))
                    Method (_STA, 0, NotSerialized)
                    {
                        Return (IRST (0x10))
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        DCNT (0x10, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        Return (IRCR (0x10))
                    }

                    Method (_SRS, 1, NotSerialized)
                    {
                        IRSR (Arg0, 0x10)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        Return (IRPR)
                    }

                    Method (IRST, 1, NotSerialized)
                    {
                        SEDN (Arg0)
                        If (ACTR)
                        {
                            Store (0x0F, Local0)
                        }
                        Else
                        {
                            If (IOAH)
                            {
                                Store (0x0D, Local0)
                            }
                            Else
                            {
                                Store (Zero, Local0)
                            }
                        }

                        Return (Local0)
                    }

                    Name (IRPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0300,             // Range Minimum
                                0x0300,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                        }
                        EndDependentFn ()
                    })
                    Name (PBUF, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y0B)
                        IRQNoFlags (_Y0C)
                            {0}
                    })
                    Method (IRCR, 1, NotSerialized)
                    {
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.CIR._Y0B._MIN, IOLO)
                        CreateByteField (PBUF, 0x03, IOHI)
                        CreateWordField (PBUF, \_SB.PCI0.SBRG.CIR._Y0B._MIN, IOHL)
                        CreateWordField (PBUF, \_SB.PCI0.SBRG.CIR._Y0B._MAX, IORL)
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.CIR._Y0B._ALN, ALMN)
                        CreateByteField (PBUF, \_SB.PCI0.SBRG.CIR._Y0B._LEN, LENG)
                        CreateWordField (PBUF, \_SB.PCI0.SBRG.CIR._Y0C._INT, IRQL)
                        SEDN (Arg0)
                        Store (IOAH, IOHI)
                        Store (IOAL, IOLO)
                        Store (IOHL, IORL)
                        Store (One, ALMN)
                        Store (0x04, LENG)
                        Store (One, Local0)
                        ShiftLeft (Local0, INTR, IRQL)
                        Return (PBUF)
                    }

                    Method (IRSR, 2, NotSerialized)
                    {
                        CreateByteField (Arg0, 0x02, POLB)
                        CreateByteField (Arg0, 0x03, POHB)
                        CreateWordField (Arg0, 0x09, PIRQ)
                        SEDN (Arg1)
                        Store (One, ACTR)
                    }
                }
            }

            Device (IDE0)
            {
                Name (_ADR, 0x001F0001)
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                OperationRegion (BAR0, PCI_Config, Zero, 0x0100)
                Field (BAR0, DWordAcc, NoLock, Preserve)
                {
                    VDID,   32, 
                            Offset (0x40), 
                    TIMP,   16, 
                    TIMS,   16, 
                    STMP,   4, 
                    STMS,   4, 
                            Offset (0x48), 
                    UDMP,   2, 
                    UDMS,   2, 
                            Offset (0x4A), 
                    UDTP,   6, 
                            Offset (0x4B), 
                    UDTS,   6, 
                            Offset (0x54), 
                    PCB0,   2, 
                    SCB0,   2, 
                    PCA0,   2, 
                    SCA0,   2, 
                        ,   4, 
                    FPB0,   2, 
                    FSB0,   2, 
                    PSIG,   2, 
                    SSIG,   2
                }

                Name (TIM0, Package (0x09)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 

                    Package (0x07)
                    {
                        0x70, 
                        0x49, 
                        0x36, 
                        0x27, 
                        0x19, 
                        0x10, 
                        0x0D
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One, 
                        0x02
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One
                    }, 

                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                Name (GTIM, Zero)
                Name (GSTM, Zero)
                Name (GUDM, Zero)
                Name (GUDT, Zero)
                Name (GCB0, Zero)
                Name (GFB0, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (GTM (TIMP, STMP, UDMP, UDTP, PCB0, FPB0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (TIMP, GTIM)
                        Store (UDTP, GUDT)
                        If (STM ())
                        {
                            Store (GTIM, TIMP)
                            Store (GSTM, STMP)
                            Store (GUDM, UDMP)
                            Store (GUDT, UDTP)
                            Store (GCB0, PCB0)
                            Store (GFB0, FPB0)
                        }

                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (GTM (TIMS, STMS, UDMS, UDTS, SCB0, FSB0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (TIMS, GTIM)
                        Store (UDTS, GUDT)
                        If (STM ())
                        {
                            Store (GTIM, TIMS)
                            Store (GSTM, STMS)
                            Store (GUDM, UDMS)
                            Store (GUDT, UDTS)
                            Store (GCB0, SCB0)
                            Store (GFB0, FSB0)
                        }

                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 6, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (PIO0, PIO1)
                    Store (PIO0, DMA0)
                    Store (PIO0, DMA1)
                    Store (Zero, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (And (Arg0, 0x02))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }

                    ShiftRight (And (Arg0, 0x3300), 0x08, Local5)
                    Store (Match (DerefOf (Index (TIM0, One)), MLE, Local5, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    If (And (Arg0, 0x08))
                    {
                        Store (0x0384, PIO0)
                    }
                    Else
                    {
                        Store (Local7, PIO0)
                    }

                    If (And (Arg0, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }

                    If (And (Arg0, 0x4000))
                    {
                        Or (CHNF, 0x10, CHNF)
                        Store (Match (DerefOf (Index (TIM0, 0x02)), MLE, Arg1, MTR, 
                            Zero, Zero), Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local5)), 
                            Local6)
                        Store (Local6, DMA1)
                        If (And (Arg0, 0x80))
                        {
                            Store (0x0384, PIO1)
                        }
                        Else
                        {
                            Store (Local6, PIO1)
                        }
                    }

                    If (And (Arg2, One))
                    {
                        And (Arg3, 0x03, Local5)
                        If (And (Arg5, One))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Else
                        {
                            If (And (Arg4, One))
                            {
                                Add (Local5, 0x02, Local5)
                            }
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (And (Arg2, 0x02))
                    {
                        And (ShiftRight (Arg3, 0x04), 0x03, Local5)
                        If (And (Arg5, 0x02))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Else
                        {
                            If (And (Arg4, 0x02))
                            {
                                Add (Local5, 0x02, Local5)
                            }
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF) {}
                    Else
                    {
                        Return (Zero)
                    }

                    And (GTIM, 0x8044, GTIM)
                    Store (Zero, GSTM)
                    Store (Zero, GUDM)
                    Store (Zero, GCB0)
                    And (GUDT, 0xCC, GUDT)
                    Store (Zero, GFB0)
                    If (And (CHNF, One))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                            Zero, Zero), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Or (GUDT, DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0
                            )), GUDT)
                        Or (GCB0, DerefOf (Index (DerefOf (Index (TIM0, 0x05)), Local0
                            )), GCB0)
                        Or (GFB0, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), GFB0)
                        Or (GUDM, One, GUDM)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                        {
                            If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                            {
                                Store (DMA0, PIO0)
                                Or (GTIM, 0x08, GTIM)
                            }
                        }
                    }

                    If (And (CHNF, 0x04))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                            Zero, Zero), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Or (GUDT, ShiftLeft (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), 
                            Local0)), 0x04), GUDT)
                        Or (GCB0, ShiftLeft (DerefOf (Index (DerefOf (Index (TIM0, 0x05)), 
                            Local0)), One), GCB0)
                        Or (GFB0, ShiftLeft (DerefOf (Index (DerefOf (Index (TIM0, 0x06)), 
                            Local0)), One), GFB0)
                        Or (GUDM, 0x02, GUDM)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                        {
                            If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                            {
                                Store (DMA1, PIO1)
                                Or (GTIM, 0x80, GTIM)
                            }
                        }
                    }

                    If (And (CHNF, 0x02))
                    {
                        Or (GTIM, 0x03, GTIM)
                    }

                    If (And (CHNF, 0x08))
                    {
                        Or (GTIM, 0x30, GTIM)
                    }

                    And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                        Zero, Zero), 0x03, Local0)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                        Local1)
                    ShiftLeft (Local1, 0x08, Local2)
                    Or (GTIM, Local2, GTIM)
                    If (And (CHNF, 0x10))
                    {
                        Or (GTIM, 0x4000, GTIM)
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x03, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            GSTM)
                    }

                    Return (One)
                }

                Name (AT01, Buffer (0x07)
                {
                    /* 0000 */    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (AT05, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (W128, Zero)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                        CreateWordField (Arg1, 0x0100, I128)
                        Store (I128, W128)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x06))
                        {
                            Store (0x06, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x08)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x03, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    If (LEqual (Local7, 0xA0))
                    {
                        If (And (W128, One))
                        {
                            GTFB (AT05, Zero, Local7)
                        }
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (RETB)
                }
            }

            Device (IDE1)
            {
                Name (_ADR, 0x001F0002)
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                OperationRegion (BAR0, PCI_Config, Zero, 0x0100)
                Field (BAR0, DWordAcc, NoLock, Preserve)
                {
                    VDID,   32, 
                            Offset (0x0A), 
                    SCCR,   8, 
                    BCCR,   8, 
                            Offset (0x40), 
                    TIMP,   16, 
                    TIMS,   16, 
                    STMP,   4, 
                    STMS,   4, 
                            Offset (0x48), 
                    UDMP,   2, 
                    UDMS,   2, 
                            Offset (0x4A), 
                    UDTP,   6, 
                            Offset (0x4B), 
                    UDTS,   6, 
                            Offset (0x54), 
                    PCB0,   2, 
                    SCB0,   2, 
                    PCA0,   2, 
                    SCA0,   2, 
                        ,   4, 
                    FPB0,   2, 
                    FSB0,   2, 
                    PSIG,   2, 
                    SSIG,   2, 
                            Offset (0x90), 
                    MAPV,   2, 
                        ,   5, 
                    SCCF,   1, 
                            Offset (0x92), 
                    P0EN,   1, 
                        ,   1, 
                    P2EN,   1, 
                        ,   1, 
                    P0PF,   1, 
                        ,   1, 
                    P2PF,   1, 
                            Offset (0x93)
                }

                Name (TIM0, Package (0x09)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 

                    Package (0x07)
                    {
                        0x70, 
                        0x49, 
                        0x36, 
                        0x27, 
                        0x19, 
                        0x10, 
                        0x0D
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One, 
                        0x02
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x07)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One
                    }, 

                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                Name (GTIM, Zero)
                Name (GSTM, Zero)
                Name (GUDM, Zero)
                Name (GUDT, Zero)
                Name (GCB0, Zero)
                Name (GFB0, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (GTM (TIMP, STMP, UDMP, UDTP, PCB0, FPB0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (TIMP, GTIM)
                        Store (UDTP, GUDT)
                        If (STM ())
                        {
                            Store (GTIM, TIMP)
                            Store (GSTM, STMP)
                            Store (GUDM, UDMP)
                            Store (GUDT, UDTP)
                            Store (GCB0, PCB0)
                            Store (GFB0, FPB0)
                        }

                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Return (GTM (TIMS, STMS, UDMS, UDTS, SCB0, FSB0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        Store (TIMS, GTIM)
                        Store (UDTS, GUDT)
                        If (STM ())
                        {
                            Store (GTIM, TIMS)
                            Store (GSTM, STMS)
                            Store (GUDM, UDMS)
                            Store (GUDT, UDTS)
                            Store (GCB0, SCB0)
                            Store (GFB0, FSB0)
                        }

                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 6, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (PIO0, PIO1)
                    Store (PIO0, DMA0)
                    Store (PIO0, DMA1)
                    Store (Zero, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (And (Arg0, 0x02))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }

                    ShiftRight (And (Arg0, 0x3300), 0x08, Local5)
                    Store (Match (DerefOf (Index (TIM0, One)), MLE, Local5, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    If (And (Arg0, 0x08))
                    {
                        Store (0x0384, PIO0)
                    }
                    Else
                    {
                        Store (Local7, PIO0)
                    }

                    If (And (Arg0, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }

                    If (And (Arg0, 0x4000))
                    {
                        Or (CHNF, 0x10, CHNF)
                        Store (Match (DerefOf (Index (TIM0, 0x02)), MLE, Arg1, MTR, 
                            Zero, Zero), Local5)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local5)), 
                            Local6)
                        Store (Local6, DMA1)
                        If (And (Arg0, 0x80))
                        {
                            Store (0x0384, PIO1)
                        }
                        Else
                        {
                            Store (Local6, PIO1)
                        }
                    }

                    If (And (Arg2, One))
                    {
                        And (Arg3, 0x03, Local5)
                        If (And (Arg5, One))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Else
                        {
                            If (And (Arg4, One))
                            {
                                Add (Local5, 0x02, Local5)
                            }
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (And (Arg2, 0x02))
                    {
                        And (ShiftRight (Arg3, 0x04), 0x03, Local5)
                        If (And (Arg5, 0x02))
                        {
                            Add (Local5, 0x04, Local5)
                        }
                        Else
                        {
                            If (And (Arg4, 0x02))
                            {
                                Add (Local5, 0x02, Local5)
                            }
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF) {}
                    Else
                    {
                        Return (Zero)
                    }

                    And (GTIM, 0x8044, GTIM)
                    Store (Zero, GSTM)
                    Store (Zero, GUDM)
                    Store (Zero, GCB0)
                    And (GUDT, 0xCC, GUDT)
                    Store (Zero, GFB0)
                    If (And (CHNF, One))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                            Zero, Zero), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Or (GUDT, DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0
                            )), GUDT)
                        Or (GCB0, DerefOf (Index (DerefOf (Index (TIM0, 0x05)), Local0
                            )), GCB0)
                        Or (GFB0, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), GFB0)
                        Or (GUDM, One, GUDM)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                        {
                            If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                            {
                                Store (DMA0, PIO0)
                                Or (GTIM, 0x08, GTIM)
                            }
                        }
                    }

                    If (And (CHNF, 0x04))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                            Zero, Zero), Local0)
                        If (LGreater (Local0, 0x06))
                        {
                            Store (0x06, Local0)
                        }

                        Or (GUDT, ShiftLeft (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), 
                            Local0)), 0x04), GUDT)
                        Or (GCB0, ShiftLeft (DerefOf (Index (DerefOf (Index (TIM0, 0x05)), 
                            Local0)), One), GCB0)
                        Or (GFB0, ShiftLeft (DerefOf (Index (DerefOf (Index (TIM0, 0x06)), 
                            Local0)), One), GFB0)
                        Or (GUDM, 0x02, GUDM)
                    }
                    Else
                    {
                        If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                        {
                            If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                            {
                                Store (DMA1, PIO1)
                                Or (GTIM, 0x80, GTIM)
                            }
                        }
                    }

                    If (And (CHNF, 0x02))
                    {
                        Or (GTIM, 0x03, GTIM)
                    }

                    If (And (CHNF, 0x08))
                    {
                        Or (GTIM, 0x30, GTIM)
                    }

                    And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                        Zero, Zero), 0x03, Local0)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                        Local1)
                    ShiftLeft (Local1, 0x08, Local2)
                    Or (GTIM, Local2, GTIM)
                    If (And (CHNF, 0x10))
                    {
                        Or (GTIM, 0x4000, GTIM)
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x03, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            GSTM)
                    }

                    Return (One)
                }

                Name (AT01, Buffer (0x07)
                {
                    /* 0000 */    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (AT05, Buffer (0x07)
                {
                    /* 0000 */    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
                Name (AT06, Buffer (0x07)
                {
                    /* 0000 */    0x10, 0x03, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT07, Buffer (0x07)
                {
                    /* 0000 */    0x10, 0x06, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (ATA0, Buffer (0x2B) {})
                Name (ATA1, Buffer (0x2B) {})
                Name (ATA2, Buffer (0x2B) {})
                Name (ATA3, Buffer (0x2B) {})
                Name (ATAB, Buffer (0x2B) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (ID78, Zero)
                    Name (W128, Zero)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                        CreateWordField (Arg1, 0x9C, IW78)
                        Store (IW78, ID78)
                        CreateWordField (Arg1, 0x0100, I128)
                        Store (I128, W128)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x06))
                        {
                            Store (0x06, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x08)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x03, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    If (LEqual (Local7, 0xA0))
                    {
                        If (And (W128, One))
                        {
                            GTFB (AT05, Zero, Local7)
                        }

                        If (And (ID78, 0x40))
                        {
                            GTFB (AT07, 0x06, Local7)
                        }

                        If (And (ID78, 0x08))
                        {
                            GTFB (AT06, 0x03, Local7)
                        }
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (RETB)
                }

                Device (PRT0)
                {
                    Name (_ADR, 0xFFFF)
                    Method (_SDD, 1, NotSerialized)
                    {
                        Store (AGTF (Zero, Arg0), ATP0)
                    }

                    Method (_GTF, 0, NotSerialized)
                    {
                        Return (RATA (ATP0))
                    }
                }

                Device (PRT1)
                {
                    Name (_ADR, 0x0001FFFF)
                    Method (_SDD, 1, NotSerialized)
                    {
                        Store (AGTF (Zero, Arg0), ATP1)
                    }

                    Method (_GTF, 0, NotSerialized)
                    {
                        Return (RATA (ATP1))
                    }
                }

                Device (PRT2)
                {
                    Name (_ADR, 0x0002FFFF)
                    Method (_SDD, 1, NotSerialized)
                    {
                        Store (AGTF (Zero, Arg0), ATP2)
                    }

                    Method (_GTF, 0, NotSerialized)
                    {
                        Return (RATA (ATP2))
                    }
                }

                Name (ATP0, Buffer (0x24) {})
                Name (ATP1, Buffer (0x24) {})
                Name (ATP2, Buffer (0x24) {})
                Method (AGTF, 2, Serialized)
                {
                    Store (0xA0, Local0)
                    Store (Zero, CMDC)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x0100, I128)
                        If (And (I128, One))
                        {
                            GTFB (AT05, Zero, Local0)
                        }

                        CreateWordField (Arg1, 0x9C, IW78)
                        If (And (IW78, 0x40))
                        {
                            GTFB (AT07, 0x06, Local0)
                        }

                        If (And (IW78, 0x08))
                        {
                            GTFB (AT06, 0x03, Local0)
                        }
                    }

                    Return (ATAB)
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x001D0000)
                OperationRegion (BAR0, PCI_Config, 0xC0, 0x05)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    UBL1,   16, 
                            Offset (0x04), 
                    P0WE,   1, 
                    P1WE,   1, 
                            Offset (0x05)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (One, P0WE)
                        Store (One, P1WE)
                    }
                    Else
                    {
                        Store (Zero, P0WE)
                        Store (Zero, P1WE)
                    }
                }

                Method (UPAC, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (LEqual (OSFG, OS9X))
                    {
                        Store (One, Local0)
                    }
                    Else
                    {
                        If (LEqual (OSFG, OS98))
                        {
                            Store (One, Local0)
                        }
                    }

                    If (Local0)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Return (One)
                        }
                    }

                    Return (Zero)
                }

                OperationRegion (UPCI, PCI_Config, 0x20, 0x04)
                Field (UPCI, ByteAcc, NoLock, Preserve)
                {
                    UBAS,   32
                }

                Name (BASA, 0xB400)
                Name (P0ST, Zero)
                Name (P1ST, Zero)
                Method (SSTA, 0, NotSerialized)
                {
                    Store (UBAS, BASA)
                    And (BASA, 0xFFFFFFFE, BASA)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }

                    Store (CCS0, P0ST)
                    Store (CCS1, P1ST)
                }

                Method (RSTA, 0, NotSerialized)
                {
                    Store (BASA, UBAS)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }
                }

                Method (USBS, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        SSTA ()
                    }
                }

                Method (USBW, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        RSTA ()
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x03, 0x03))
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x001D0001)
                OperationRegion (BAR0, PCI_Config, 0xC0, 0x05)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    UBL1,   16, 
                            Offset (0x04), 
                    P0WE,   1, 
                    P1WE,   1, 
                            Offset (0x05)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (One, P0WE)
                        Store (One, P1WE)
                    }
                    Else
                    {
                        Store (Zero, P0WE)
                        Store (Zero, P1WE)
                    }
                }

                Method (UPAC, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (LEqual (OSFG, OS9X))
                    {
                        Store (One, Local0)
                    }
                    Else
                    {
                        If (LEqual (OSFG, OS98))
                        {
                            Store (One, Local0)
                        }
                    }

                    If (Local0)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Return (One)
                        }
                    }

                    Return (Zero)
                }

                OperationRegion (UPCI, PCI_Config, 0x20, 0x04)
                Field (UPCI, ByteAcc, NoLock, Preserve)
                {
                    UBAS,   32
                }

                Name (BASA, 0xB400)
                Name (P0ST, Zero)
                Name (P1ST, Zero)
                Method (SSTA, 0, NotSerialized)
                {
                    Store (UBAS, BASA)
                    And (BASA, 0xFFFFFFFE, BASA)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }

                    Store (CCS0, P0ST)
                    Store (CCS1, P1ST)
                }

                Method (RSTA, 0, NotSerialized)
                {
                    Store (BASA, UBAS)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }
                }

                Method (USBS, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        SSTA ()
                    }
                }

                Method (USBW, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        RSTA ()
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x04, 0x03))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x001D0002)
                OperationRegion (BAR0, PCI_Config, 0xC0, 0x05)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    UBL1,   16, 
                            Offset (0x04), 
                    P0WE,   1, 
                    P1WE,   1, 
                            Offset (0x05)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (One, P0WE)
                        Store (One, P1WE)
                    }
                    Else
                    {
                        Store (Zero, P0WE)
                        Store (Zero, P1WE)
                    }
                }

                Method (UPAC, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (LEqual (OSFG, OS9X))
                    {
                        Store (One, Local0)
                    }
                    Else
                    {
                        If (LEqual (OSFG, OS98))
                        {
                            Store (One, Local0)
                        }
                    }

                    If (Local0)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Return (One)
                        }
                    }

                    Return (Zero)
                }

                OperationRegion (UPCI, PCI_Config, 0x20, 0x04)
                Field (UPCI, ByteAcc, NoLock, Preserve)
                {
                    UBAS,   32
                }

                Name (BASA, 0xB400)
                Name (P0ST, Zero)
                Name (P1ST, Zero)
                Method (SSTA, 0, NotSerialized)
                {
                    Store (UBAS, BASA)
                    And (BASA, 0xFFFFFFFE, BASA)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }

                    Store (CCS0, P0ST)
                    Store (CCS1, P1ST)
                }

                Method (RSTA, 0, NotSerialized)
                {
                    Store (BASA, UBAS)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }
                }

                Method (USBS, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        SSTA ()
                    }
                }

                Method (USBW, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        RSTA ()
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0C, 0x03))
                }
            }

            Device (EUSB)
            {
                Name (_ADR, 0x001D0007)
                OperationRegion (U20P, PCI_Config, Zero, 0x0100)
                Field (U20P, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x04), 
                        ,   1, 
                    MSPE,   1, 
                            Offset (0x06), 
                            Offset (0x10), 
                    MBAS,   32, 
                            Offset (0x54), 
                    PSTA,   2, 
                            Offset (0x55), 
                    PMEE,   1, 
                        ,   6, 
                    PMES,   1
                }

                Method (_PSW, 1, NotSerialized)
                {
                    Store (MBAS, Local0)
                    And (Local0, 0xFFFFFFF0, Local0)
                    OperationRegion (MMIO, SystemMemory, Local0, 0x0100)
                    Field (MMIO, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x64), 
                        P0SC,   32, 
                        P1SC,   32, 
                        P2SC,   32, 
                        P3SC,   32, 
                        P4SC,   32, 
                        P5SC,   32
                    }

                    If (LNot (Local0))
                    {
                        Store (PSTA, Local2)
                        Store (Zero, PSTA)
                        Store (MSPE, Local3)
                        Store (One, MSPE)
                        If (Arg0)
                        {
                            Store (P0SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P0SC)
                            Store (P1SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P1SC)
                            Store (P2SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P2SC)
                            Store (P3SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P3SC)
                            Store (P4SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P4SC)
                            Store (P5SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P5SC)
                            Store (One, PMES)
                            Store (One, PMEE)
                        }
                        Else
                        {
                            Store (P0SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P0SC)
                            Store (P1SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P1SC)
                            Store (P2SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P2SC)
                            Store (P3SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P3SC)
                            Store (P4SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P4SC)
                            Store (P5SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P5SC)
                            Store (One, PMES)
                            Store (Zero, PMEE)
                        }

                        Store (Local3, MSPE)
                        Store (Local2, PSTA)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x03))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x001A0000)
                OperationRegion (BAR0, PCI_Config, 0xC0, 0x05)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    UBL1,   16, 
                            Offset (0x04), 
                    P0WE,   1, 
                    P1WE,   1, 
                            Offset (0x05)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (One, P0WE)
                        Store (One, P1WE)
                    }
                    Else
                    {
                        Store (Zero, P0WE)
                        Store (Zero, P1WE)
                    }
                }

                Method (UPAC, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (LEqual (OSFG, OS9X))
                    {
                        Store (One, Local0)
                    }
                    Else
                    {
                        If (LEqual (OSFG, OS98))
                        {
                            Store (One, Local0)
                        }
                    }

                    If (Local0)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Return (One)
                        }
                    }

                    Return (Zero)
                }

                OperationRegion (UPCI, PCI_Config, 0x20, 0x04)
                Field (UPCI, ByteAcc, NoLock, Preserve)
                {
                    UBAS,   32
                }

                Name (BASA, 0xB400)
                Name (P0ST, Zero)
                Name (P1ST, Zero)
                Method (SSTA, 0, NotSerialized)
                {
                    Store (UBAS, BASA)
                    And (BASA, 0xFFFFFFFE, BASA)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }

                    Store (CCS0, P0ST)
                    Store (CCS1, P1ST)
                }

                Method (RSTA, 0, NotSerialized)
                {
                    Store (BASA, UBAS)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }
                }

                Method (USBS, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        SSTA ()
                    }
                }

                Method (USBW, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        RSTA ()
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x03))
                }
            }

            Device (USB4)
            {
                Name (_ADR, 0x001A0001)
                OperationRegion (BAR0, PCI_Config, 0xC0, 0x05)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    UBL1,   16, 
                            Offset (0x04), 
                    P0WE,   1, 
                    P1WE,   1, 
                            Offset (0x05)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (One, P0WE)
                        Store (One, P1WE)
                    }
                    Else
                    {
                        Store (Zero, P0WE)
                        Store (Zero, P1WE)
                    }
                }

                Method (UPAC, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (LEqual (OSFG, OS9X))
                    {
                        Store (One, Local0)
                    }
                    Else
                    {
                        If (LEqual (OSFG, OS98))
                        {
                            Store (One, Local0)
                        }
                    }

                    If (Local0)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Return (One)
                        }
                    }

                    Return (Zero)
                }

                OperationRegion (UPCI, PCI_Config, 0x20, 0x04)
                Field (UPCI, ByteAcc, NoLock, Preserve)
                {
                    UBAS,   32
                }

                Name (BASA, 0xB400)
                Name (P0ST, Zero)
                Name (P1ST, Zero)
                Method (SSTA, 0, NotSerialized)
                {
                    Store (UBAS, BASA)
                    And (BASA, 0xFFFFFFFE, BASA)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }

                    Store (CCS0, P0ST)
                    Store (CCS1, P1ST)
                }

                Method (RSTA, 0, NotSerialized)
                {
                    Store (BASA, UBAS)
                    OperationRegion (UHCI, SystemIO, BASA, 0x20)
                    Field (UHCI, ByteAcc, NoLock, Preserve)
                    {
                        RSTP,   1, 
                        HRST,   1, 
                        GRST,   1, 
                                Offset (0x10), 
                        CCS0,   1, 
                        CSC0,   1, 
                        PED0,   1, 
                                Offset (0x12), 
                        CCS1,   1, 
                        CSC1,   1, 
                        PED1,   1
                    }
                }

                Method (USBS, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        SSTA ()
                    }
                }

                Method (USBW, 1, NotSerialized)
                {
                    If (UPAC (Arg0))
                    {
                        RSTA ()
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x05, 0x03))
                }
            }

            Device (USBE)
            {
                Name (_ADR, 0x001A0007)
                OperationRegion (U20P, PCI_Config, Zero, 0x0100)
                Field (U20P, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x04), 
                        ,   1, 
                    MSPE,   1, 
                            Offset (0x06), 
                            Offset (0x10), 
                    MBAS,   32, 
                            Offset (0x54), 
                    PSTA,   2, 
                            Offset (0x55), 
                    PMEE,   1, 
                        ,   6, 
                    PMES,   1
                }

                Method (_PSW, 1, NotSerialized)
                {
                    Store (MBAS, Local0)
                    And (Local0, 0xFFFFFFF0, Local0)
                    OperationRegion (MMIO, SystemMemory, Local0, 0x0100)
                    Field (MMIO, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x64), 
                        P0SC,   32, 
                        P1SC,   32, 
                        P2SC,   32, 
                        P3SC,   32, 
                        P4SC,   32, 
                        P5SC,   32
                    }

                    If (LNot (Local0))
                    {
                        Store (PSTA, Local2)
                        Store (Zero, PSTA)
                        Store (MSPE, Local3)
                        Store (One, MSPE)
                        If (Arg0)
                        {
                            Store (P0SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P0SC)
                            Store (P1SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P1SC)
                            Store (P2SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P2SC)
                            Store (P3SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P3SC)
                            Store (P4SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P4SC)
                            Store (P5SC, Local4)
                            Or (Local4, 0x00300000, Local4)
                            Store (Local4, P5SC)
                            Store (One, PMES)
                            Store (One, PMEE)
                        }
                        Else
                        {
                            Store (P0SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P0SC)
                            Store (P1SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P1SC)
                            Store (P2SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P2SC)
                            Store (P3SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P3SC)
                            Store (P4SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P4SC)
                            Store (P5SC, Local4)
                            And (Local4, 0xFFCFFFFF, Local4)
                            Store (Local4, P5SC)
                            Store (One, PMES)
                            Store (Zero, PMEE)
                        }

                        Store (Local3, MSPE)
                        Store (Local2, PSTA)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x03))
                }
            }

            Device (HDAC)
            {
                Name (_ADR, 0x001B0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x03))
                }
            }

            Device (VGA)
            {
                Name (_ADR, 0x00020000)
                OperationRegion (VSID, PCI_Config, Zero, 0x04)
                Field (VSID, ByteAcc, NoLock, Preserve)
                {
                    REG0,   32
                }

                OperationRegion (IGDM, SystemMemory, 0x1F7AE0C4, 0x2000)
                Field (IGDM, AnyAcc, NoLock, Preserve)
                {
                    SIGN,   128, 
                    SIZE,   32, 
                    OVER,   32, 
                    SVER,   256, 
                    VVER,   128, 
                    GVER,   128, 
                    MBOX,   32, 
                            Offset (0xF0), 
                    IBTT,   4, 
                    IPSC,   2, 
                    IPAT,   4, 
                    IBIA,   3, 
                    IBLC,   2, 
                            Offset (0xF2), 
                    ITVF,   4, 
                    ITVM,   4, 
                    IDVM,   1, 
                    IDVS,   2, 
                    ISSC,   1, 
                            Offset (0xF4), 
                            Offset (0xFC), 
                    SBUD,   1, 
                            Offset (0x100), 
                    DRDY,   32, 
                    CSTS,   32, 
                    CEVT,   32, 
                            Offset (0x120), 
                    DIDL,   32, 
                    DDL2,   32, 
                    DDL3,   32, 
                    DDL4,   32, 
                    DDL5,   32, 
                    DDL6,   32, 
                    DDL7,   32, 
                    DDL8,   32, 
                    CPDL,   32, 
                    CPL2,   32, 
                    CPL3,   32, 
                    CPL4,   32, 
                    CPL5,   32, 
                    CPL6,   32, 
                    CPL7,   32, 
                    CPL8,   32, 
                    CADL,   32, 
                    CAL2,   32, 
                    CAL3,   32, 
                    CAL4,   32, 
                    CAL5,   32, 
                    CAL6,   32, 
                    CAL7,   32, 
                    CAL8,   32, 
                    NADL,   32, 
                    NDL2,   32, 
                    NDL3,   32, 
                    NDL4,   32, 
                    NDL5,   32, 
                    NDL6,   32, 
                    NDL7,   32, 
                    NDL8,   32, 
                    ASLP,   32, 
                    TIDX,   32, 
                    CHPD,   32, 
                    CLID,   32, 
                    CDCK,   32, 
                    SXSW,   32, 
                    EVTS,   32, 
                    CNOT,   32, 
                    NRDY,   32, 
                            Offset (0x200), 
                    SCIE,   1, 
                    GEFC,   4, 
                    GXFC,   3, 
                    GESF,   8, 
                            Offset (0x204), 
                    PARM,   32, 
                    DSLP,   32, 
                            Offset (0x300), 
                    ARDY,   32, 
                    ASLC,   32, 
                    TCHE,   32, 
                    ALSI,   32, 
                    BCLP,   32, 
                    PFIT,   32, 
                    CBLV,   32, 
                    BCLM,   320, 
                    CPFM,   32, 
                    EPFM,   32, 
                            Offset (0x400), 
                    GVD1,   57344
                }

                OperationRegion (BRGI, SystemMemory, 0x1F7AE3E0, 0x40)
                Field (BRGI, AnyAcc, NoLock, Preserve)
                {
                    D000,   8, 
                    P000,   8, 
                    D010,   8, 
                    P010,   8, 
                    D020,   8, 
                    P020,   8, 
                    D030,   8, 
                    P030,   8, 
                    D040,   8, 
                    P040,   8, 
                    D050,   8, 
                    P050,   8, 
                    D060,   8, 
                    P060,   8, 
                    D070,   8, 
                    P070,   8, 
                    D080,   8, 
                    P080,   8, 
                    D090,   8, 
                    P090,   8, 
                    D100,   8, 
                    P100,   8
                }

                OperationRegion (TCOI, SystemIO, TOBS, 0x08)
                Field (TCOI, WordAcc, NoLock, Preserve)
                {
                            Offset (0x04), 
                        ,   9, 
                    SCIS,   1, 
                            Offset (0x06)
                }

                Name (DBTB, Package (0x15)
                {
                    Zero, 
                    0x07, 
                    0x38, 
                    0x01C0, 
                    0x0E00, 
                    0x3F, 
                    0x01C7, 
                    0x0E07, 
                    0x01F8, 
                    0x0E38, 
                    0x0FC0, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    0x7000, 
                    0x7007, 
                    0x7038, 
                    0x71C0, 
                    0x7E00
                })
                Method (GSCI, 0, NotSerialized)
                {
                    If (LEqual (GEFC, 0x04))
                    {
                        Store (GBDA (), GXFC)
                    }

                    If (LEqual (GEFC, 0x06))
                    {
                        Store (SBCB (), GXFC)
                    }

                    Store (One, SCIS)
                    Store (Zero, GEFC)
                    Store (Zero, GSSE)
                    Store (Zero, SCIE)
                    Return (Zero)
                }

                Name (OPBS, 0xFFFFFF00)
                Method (OPTS, 1, NotSerialized)
                {
                    If (And (VGAF, One))
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Store (ASLS, OPBS)
                        }
                    }
                }

                Method (OWAK, 1, NotSerialized)
                {
                    If (And (VGAF, One))
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Store (OPBS, ASLS)
                            Store (One, GSES)
                        }

                        Store (GLID (), CLID)
                    }
                }

                Method (PDRD, 0, NotSerialized)
                {
                    If (LNot (DRDY))
                    {
                        Sleep (ASLP)
                    }

                    Return (LNot (DRDY))
                }

                Method (PSTS, 0, NotSerialized)
                {
                    If (LGreater (CSTS, 0x02))
                    {
                        Sleep (ASLP)
                    }

                    Return (LEqual (CSTS, 0x03))
                }

                Method (OGCD, 0, NotSerialized)
                {
                    If (LEqual (CADL, Zero))
                    {
                        Store (0x0808, CSTE)
                        Return (Zero)
                    }

                    Store (OA2D (CADL), CSTE)
                    If (LEqual (CAL2, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL2), CSTE, CSTE)
                    If (LEqual (CAL3, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL3), CSTE, CSTE)
                    If (LEqual (CAL4, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL4), CSTE, CSTE)
                    If (LEqual (CAL5, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL5), CSTE, CSTE)
                    If (LEqual (CAL6, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL6), CSTE, CSTE)
                    If (LEqual (CAL7, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL7), CSTE, CSTE)
                    If (LEqual (CAL8, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CAL8), CSTE, CSTE)
                }

                Method (OGCA, 0, NotSerialized)
                {
                    If (LEqual (CPDL, Zero))
                    {
                        Store (0x0808, \CADL)
                        Return (Zero)
                    }

                    Store (OA2D (CPDL), \CADL)
                    If (LEqual (CPL2, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL2), \CADL, \CADL)
                    If (LEqual (CPL3, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL3), \CADL, \CADL)
                    If (LEqual (CPL4, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL4), \CADL, \CADL)
                    If (LEqual (CPL5, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL5), \CADL, \CADL)
                    If (LEqual (CPL6, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL6), \CADL, \CADL)
                    If (LEqual (CPL7, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL7), \CADL, \CADL)
                    If (LEqual (CPL8, Zero))
                    {
                        Return (Zero)
                    }

                    Or (OA2D (CPL8), \CADL, \CADL)
                }

                Method (OA2D, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (LEqual (Arg0, 0x0400))
                    {
                        Or (Local0, LCDM, Local0)
                    }

                    If (LEqual (Arg0, 0x0100))
                    {
                        Or (Local0, CRTM, Local0)
                    }

                    If (LEqual (Arg0, 0x0200))
                    {
                        Or (Local0, TVOM, Local0)
                    }

                    If (LEqual (Arg0, 0x0300))
                    {
                        Or (Local0, DVIM, Local0)
                    }

                    Return (Local0)
                }

                Method (LIDE, 1, NotSerialized)
                {
                    Store (Arg0, CLID)
                    Return (GNOT (0x02, Zero))
                }

                Method (GNOT, 2, NotSerialized)
                {
                    If (PDRD ())
                    {
                        Return (One)
                    }

                    If (PSTS ())
                    {
                        Return (One)
                    }

                    Store (Arg0, CEVT)
                    Store (0x03, CSTS)
                    If (LAnd (LEqual (CHPD, Zero), LEqual (Arg1, Zero)))
                    {
                        If (LEqual (OSFG, OSXP))
                        {
                            Notify (PCI0, Arg1)
                        }
                        Else
                        {
                            Notify (VGA, Arg1)
                        }

                        Sleep (0x03E8)
                    }

                    Notify (VGA, 0x80)
                    If (LNot (PSTS ()))
                    {
                        Store (Zero, CEVT)
                    }

                    Return (Zero)
                }

                Method (GBDA, 0, NotSerialized)
                {
                    If (LEqual (GESF, Zero))
                    {
                        Store (0x0279, PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, One))
                    {
                        Store (0x0240, PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x04))
                    {
                        And (PARM, 0xEFFF0000, PARM)
                        And (PARM, ShiftLeft (DerefOf (Index (DBTB, IBTT)), 0x10), 
                            PARM)
                        Or (IBTT, PARM, PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x05))
                    {
                        Store (IPSC, PARM)
                        Or (PARM, ShiftLeft (IPAT, 0x08), PARM)
                        Add (PARM, 0x0100, PARM)
                        Or (PARM, ShiftLeft (CLID, 0x10), PARM)
                        XOr (PARM, 0x00010000, PARM)
                        Or (PARM, ShiftLeft (IBIA, 0x14), PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x06))
                    {
                        Store (ITVF, PARM)
                        Or (PARM, ShiftLeft (ITVM, 0x04), PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x07))
                    {
                        Name (MEMS, 0x0D)
                        Store (GIVD, PARM)
                        XOr (PARM, One, PARM)
                        Or (PARM, ShiftLeft (GMFN, One), PARM)
                        Or (PARM, 0x1000, PARM)
                        Or (ShiftLeft (CDCT, 0x15), PARM, PARM)
                        If (LEqual (IDVM, One))
                        {
                            Store (0x11, MEMS)
                        }

                        If (LLess (TASM, M512))
                        {
                            Or (PARM, ShiftLeft (One, MEMS), PARM)
                        }
                        Else
                        {
                            If (LLess (TASM, M1GB))
                            {
                                If (LLess (IDVS, 0x03))
                                {
                                    Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                                }
                                Else
                                {
                                    Or (PARM, ShiftLeft (0x02, MEMS), PARM)
                                }
                            }
                            Else
                            {
                                Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                            }
                        }

                        Store (One, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x0A))
                    {
                        Store (Zero, PARM)
                        If (ISSC)
                        {
                            Or (PARM, 0x03, PARM)
                        }

                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    Store (Zero, GESF)
                    Return (CRIT)
                }

                Method (SBCB, 0, NotSerialized)
                {
                    If (LEqual (GESF, Zero))
                    {
                        Store (0x20, PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, One))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x03))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x04))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x05))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x06))
                    {
                        ShiftRight (PARM, 0x1C, Local0)
                        If (LEqual (Local0, Zero))
                        {
                            And (PARM, 0x0F, ITVF)
                            And (PARM, 0xF0, ITVM)
                        }

                        Store (One, SBUD)
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x07))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x08))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x09))
                    {
                        And (PARM, 0xFF, IBTT)
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x0A))
                    {
                        ShiftRight (PARM, 0x1C, Local0)
                        If (LEqual (Local0, Zero))
                        {
                            And (PARM, 0xFF, IPSC)
                            Subtract (And (ShiftRight (PARM, 0x08), 0xFF), One, IPAT)
                            And (ShiftRight (PARM, 0x12), 0x03, IBLC)
                            And (ShiftRight (PARM, 0x14), 0x07, IBIA)
                        }

                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x0B))
                    {
                        If (LEqual (And (ShiftRight (PARM, 0x0B), 0x03), 0x02))
                        {
                            And (ShiftRight (PARM, 0x0D), 0x0F, Local0)
                            And (ShiftRight (PARM, 0x11), 0x0F, Local1)
                            If (Local0)
                            {
                                Store (Zero, IDVM)
                                Store (Local0, IDVS)
                            }

                            If (Local1)
                            {
                                Store (One, IDVM)
                                Store (Local1, IDVS)
                            }
                        }

                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x10))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x11))
                    {
                        Store (ShiftLeft (LIDS, 0x08), PARM)
                        Add (PARM, 0x0100, PARM)
                        Store (Zero, GESF)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x12))
                    {
                        If (And (PARM, One))
                        {
                            If (LEqual (ShiftRight (PARM, One), One))
                            {
                                Store (One, ISSC)
                            }
                            Else
                            {
                                Store (Zero, GESF)
                                Return (CRIT)
                            }
                        }
                        Else
                        {
                            Store (Zero, ISSC)
                        }

                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    If (LEqual (GESF, 0x13))
                    {
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }

                    Store (Zero, GESF)
                    Return (SUCC)
                }

                Scope (^^PCI0)
                {
                    OperationRegion (MCHP, PCI_Config, 0x40, 0xC0)
                    Field (MCHP, AnyAcc, NoLock, Preserve)
                    {
                                Offset (0x60), 
                        TASM,   10, 
                                Offset (0x62)
                    }
                }

                OperationRegion (IGDP, PCI_Config, 0x40, 0xC0)
                Field (IGDP, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x12), 
                        ,   1, 
                    GIVD,   1, 
                        ,   2, 
                    GUMA,   3, 
                            Offset (0x14), 
                        ,   4, 
                    GMFN,   1, 
                            Offset (0x18), 
                            Offset (0x8C), 
                    CDCT,   10, 
                            Offset (0x8E), 
                            Offset (0xA4), 
                    ASLE,   8, 
                            Offset (0xA8), 
                    GSSE,   1, 
                    GSSB,   14, 
                    GSES,   1, 
                            Offset (0xB5), 
                    LBPC,   8, 
                            Offset (0xBC), 
                    ASLS,   32
                }

                Name (M512, 0x04)
                Name (M1GB, 0x08)
                Scope (\_GPE)
                {
                    Method (_L06, 0, NotSerialized)
                    {
                        \_SB.PCI0.VGA.GSCI ()
                    }
                }

                Method (PRST, 0, NotSerialized)
                {
                    If (LEqual (REG0, Ones))
                    {
                        Return (Zero)
                    }
                    Else
                    {
                        Return (One)
                    }
                }

                Name (LCDM, 0x0808)
                Name (CRTM, 0x0101)
                Name (TVOM, 0x0202)
                Name (DVIM, 0x0404)
                Name (DOSF, One)
                Name (UPDN, One)
                Name (NXTD, One)
                Method (MD2A, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (And (Arg0, LCDM))
                    {
                        Or (Local0, One, Local0)
                    }

                    If (And (Arg0, CRTM))
                    {
                        Or (Local0, 0x02, Local0)
                    }

                    If (And (Arg0, TVOM))
                    {
                        Or (Local0, 0x04, Local0)
                    }

                    If (And (Arg0, DVIM))
                    {
                        Or (Local0, 0x08, Local0)
                    }

                    If (LNot (Local0))
                    {
                        Return (NXTD)
                    }

                    Return (Local0)
                }

                Method (MA2D, 1, NotSerialized)
                {
                    Store (Zero, Local0)
                    If (And (Arg0, One))
                    {
                        Or (Local0, LCDM, Local0)
                    }

                    If (And (Arg0, 0x02))
                    {
                        Or (Local0, CRTM, Local0)
                    }

                    If (And (Arg0, 0x04))
                    {
                        Or (Local0, TVOM, Local0)
                    }

                    If (And (Arg0, 0x08))
                    {
                        Or (Local0, DVIM, Local0)
                    }

                    If (LNot (Local0))
                    {
                        Return (LCDM)
                    }

                    Return (Local0)
                }

                Method (_INI, 0, NotSerialized)
                {
                }

                Method (_DOS, 1, NotSerialized)
                {
                    Store (Arg0, DOSF)
                }

                Method (_DOD, 0, NotSerialized)
                {
                    Return (Package (0x03)
                    {
                        0x80010100, 
                        0x80010400, 
                        0x80010300
                    })
                }

                Device (DVID)
                {
                    Name (_ADR, 0x0300)
                    Method (_DCS, 0, NotSerialized)
                    {
                        If (And (CSTE, DVIM))
                        {
                            Return (0x1F)
                        }

                        Return (0x1D)
                    }

                    Method (_DGS, 0, NotSerialized)
                    {
                        If (And (NSTE, DVIM))
                        {
                            Return (One)
                        }

                        Return (Zero)
                    }

                    Method (_DSS, 1, NotSerialized)
                    {
                        If (Or (Not (And (Arg0, 0x80000000)), And (Arg0, 
                            0x40000000)))
                        {
                            Store (NSTE, CSTE)
                        }
                        Else
                        {
                            If (Not (And (Arg0, 0x40000000))) {}
                        }
                    }
                }

                Device (CRTD)
                {
                    Name (_ADR, 0x0100)
                    Method (_DCS, 0, NotSerialized)
                    {
                        If (And (CSTE, CRTM))
                        {
                            Return (0x1F)
                        }

                        Return (0x1D)
                    }

                    Method (_DGS, 0, NotSerialized)
                    {
                        If (And (NSTE, CRTM))
                        {
                            Return (One)
                        }

                        Return (Zero)
                    }

                    Method (_DSS, 1, NotSerialized)
                    {
                        If (Or (Not (And (Arg0, 0x80000000)), And (Arg0, 
                            0x40000000)))
                        {
                            Store (NSTE, CSTE)
                        }
                        Else
                        {
                            If (Not (And (Arg0, 0x40000000))) {}
                        }
                    }
                }

                Device (LCDD)
                {
                    Name (_ADR, 0x0400)
                    Method (_DCS, 0, NotSerialized)
                    {
                        If (And (CSTE, LCDM))
                        {
                            Return (0x1F)
                        }

                        Return (0x1D)
                    }

                    Method (_DGS, 0, NotSerialized)
                    {
                        If (And (NSTE, LCDM))
                        {
                            Return (One)
                        }

                        Return (Zero)
                    }

                    Method (_DSS, 1, NotSerialized)
                    {
                        If (Or (Not (And (Arg0, 0x80000000)), And (Arg0, 
                            0x40000000)))
                        {
                            Store (NSTE, CSTE)
                        }
                        Else
                        {
                            If (Not (And (Arg0, 0x40000000))) {}
                        }
                    }

                    Method (_BCL, 0, NotSerialized)
                    {
                        Return (Package (0x08)
                        {
                            0x1E, 
                            0x28, 
                            0x32, 
                            0x3C, 
                            0x46, 
                            0x50, 
                            0x5A, 
                            0x64
                        })
                    }

                    Method (_BCM, 1, NotSerialized)
                    {
                        Return (One)
                    }

                    Method (_BQC, 0, NotSerialized)
                    {
                        Return (One)
                    }
                }

                Method (SWHD, 1, Serialized)
                {
                    Store (One, UPDN)
                    If (And (DOSF, 0x03))
                    {
                        If (\NATK ())
                        {
                            Store (Zero, SFUN)
                        }
                        Else
                        {
                            Store (0x04, SFUN)
                        }

                        Store (Arg0, SSTE)
                        If (\NATK ())
                        {
                            Store (MA2D (Arg0), NSTE)
                            Store (NSTE, SSTE)
                        }

                        ISMI (0x94)
                        Notify (VGA, 0x81)
                    }
                    Else
                    {
                        Store (One, CEVT)
                        Store (0x03, CSTS)
                        If (LNotEqual (\CADL, PADL))
                        {
                            Store (\CADL, PADL)
                            If (LEqual (OSFG, OSXP))
                            {
                                Notify (PCI0, Zero)
                            }
                            Else
                            {
                                Notify (VGA, Zero)
                            }

                            Sleep (0x03E8)
                        }

                        Store (MA2D (Arg0), NSTE)
                        Notify (VGA, 0x80)
                        If (LNot (PSTS ()))
                        {
                            Store (Zero, CEVT)
                        }
                    }
                }

                Method (GCDD, 0, NotSerialized)
                {
                    Store (One, SFUN)
                    ISMI (0x95)
                    Return (CSTE)
                }

                Method (GNDD, 0, NotSerialized)
                {
                    Store (0x05, SFUN)
                    ISMI (0x95)
                    Return (NSTE)
                }

                Method (GCAD, 0, NotSerialized)
                {
                    Store (0x02, SFUN)
                    ISMI (0x95)
                    Return (\CADL)
                }

                Method (GVIF, 0, NotSerialized)
                {
                    Store (0x67, VBIF)
                    Store (Zero, SFUN)
                    ISMI (0x95)
                    Return (VBIF)
                }

                Method (ADVD, 0, NotSerialized)
                {
                    If (And (DOSF, 0x03))
                    {
                        GCDD ()
                        GCAD ()
                        GVIF ()
                    }
                    Else
                    {
                        OGCD ()
                        OGCA ()
                    }

                    If (\NATK ())
                    {
                        If (UPDN)
                        {
                            Store (MD2A (CSTE), NXTD)
                            Store (Zero, UPDN)
                        }

                        Store (Zero, Local0)
                        Store (MD2A (\CADL), Local1)
                        Store (Zero, Local2)
                        If (And (VGAF, One))
                        {
                            And (VBIF, 0x08, Local2)
                        }

                        If (And (LEqual (Local2, 0x08), And (VGAF, One)))
                        {
                            And (NXTD, Local1, NXTD)
                            Store (NXTD, Local0)
                        }

                        While (LNotEqual (NXTD, Local0))
                        {
                            Increment (NXTD)
                            If (And (DOSF, 0x03))
                            {
                                If (LEqual (NXTD, 0x05))
                                {
                                    Increment (NXTD)
                                }

                                If (LEqual (NXTD, 0x06))
                                {
                                    Increment (NXTD)
                                }
                            }

                            If (LEqual (NXTD, 0x07))
                            {
                                Increment (NXTD)
                            }

                            If (And (DOSF, 0x03))
                            {
                                If (LEqual (NXTD, 0x09))
                                {
                                    Increment (NXTD)
                                }
                            }

                            If (LEqual (NXTD, 0x0B))
                            {
                                Increment (NXTD)
                            }

                            If (And (DOSF, 0x03))
                            {
                                If (LEqual (NXTD, 0x0C))
                                {
                                    Increment (NXTD)
                                }
                            }

                            If (LGreater (NXTD, 0x0C))
                            {
                                Store (One, NXTD)
                            }

                            And (NXTD, Local1, Local0)
                        }

                        Return (NXTD)
                    }

                    Return (GNDD ())
                }

                Method (NATK, 0, NotSerialized)
                {
                    Return (One)
                }
            }

            Device (P0P8)
            {
                Name (_ADR, 0x00010000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }

            Device (P0P1)
            {
                Name (_ADR, 0x001C0000)
                OperationRegion (LCTL, PCI_Config, 0x50, 0x04)
                Field (LCTL, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PELD,   1, 
                    PERL,   1
                }

                OperationRegion (SLOT, PCI_Config, 0x54, 0x10)
                Field (SLOT, ByteAcc, NoLock, Preserve)
                {
                    SCAP,   32, 
                    SCTL,   16, 
                    ABP1,   1, 
                    PFD1,   1, 
                    MSC1,   1, 
                    PDC1,   1, 
                    CC10,   1, 
                    MS10,   1, 
                    PDS1,   1, 
                    RSV0,   1, 
                    LASC,   1, 
                    RSV1,   7
                }

                OperationRegion (RHUB, PCI_Config, 0x60, 0x10)
                Field (RHUB, ByteAcc, NoLock, Preserve)
                {
                    PMID,   16, 
                    PMES,   1, 
                    PMEP,   1, 
                    RSV2,   14
                }

                OperationRegion (MISC, PCI_Config, 0xD8, 0x08)
                Field (MISC, ByteAcc, NoLock, Preserve)
                {
                    RSV4,   30, 
                    PMCE,   1, 
                    HPCE,   1, 
                    PMMS,   1, 
                    HPPD,   1, 
                    HPAB,   1, 
                    HPCC,   1, 
                    HPLA,   1, 
                    RSV3,   25, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Method (HPHK, 0, NotSerialized)
                {
                    Store (One, PDC1)
                    Store (One, HPCS)
                    Store (Zero, PELD)
                    Sleep (0xFA)
                }
            }

            Device (P0P2)
            {
                Name (_ADR, 0x001C0001)
                OperationRegion (LCTL, PCI_Config, 0x50, 0x04)
                Field (LCTL, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PELD,   1, 
                    PERL,   1
                }

                OperationRegion (SLOT, PCI_Config, 0x54, 0x10)
                Field (SLOT, ByteAcc, NoLock, Preserve)
                {
                    SCAP,   32, 
                    SCTL,   16, 
                    ABP1,   1, 
                    PFD1,   1, 
                    MSC1,   1, 
                    PDC1,   1, 
                    CC10,   1, 
                    MS10,   1, 
                    PDS1,   1, 
                    RSV0,   1, 
                    LASC,   1, 
                    RSV1,   7
                }

                OperationRegion (RHUB, PCI_Config, 0x60, 0x10)
                Field (RHUB, ByteAcc, NoLock, Preserve)
                {
                    PMID,   16, 
                    PMES,   1, 
                    PMEP,   1, 
                    RSV2,   14
                }

                OperationRegion (MISC, PCI_Config, 0xD8, 0x08)
                Field (MISC, ByteAcc, NoLock, Preserve)
                {
                    RSV4,   30, 
                    PMCE,   1, 
                    HPCE,   1, 
                    PMMS,   1, 
                    HPPD,   1, 
                    HPAB,   1, 
                    HPCC,   1, 
                    HPLA,   1, 
                    RSV3,   25, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Method (HPHK, 0, NotSerialized)
                {
                    Store (One, PDC1)
                    Store (One, HPCS)
                    Store (Zero, PELD)
                    Sleep (0xFA)
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR02)
                    }

                    Return (PR02)
                }

                Device (WLAN)
                {
                    Name (_ADR, Zero)
                    OperationRegion (MINP, PCI_Config, Zero, 0x68)
                    Field (MINP, ByteAcc, NoLock, Preserve)
                    {
                        VNUM,   32, 
                                Offset (0x09), 
                        PINF,   8, 
                        SBCC,   8, 
                        BSCC,   8, 
                                Offset (0x2C), 
                        SNUM,   32, 
                                Offset (0x34)
                    }

                    Method (MPDP, 0, NotSerialized)
                    {
                        If (LEqual (SNUM, Ones))
                        {
                            Return (Zero)
                        }

                        If (LNotEqual (BSCC, 0x02))
                        {
                            Return (Zero)
                        }

                        Return (One)
                    }

                    Method (_PRW, 0, NotSerialized)
                    {
                        Return (GPRW (0x09, 0x04))
                    }
                }
            }

            Device (P0P3)
            {
                Name (_ADR, 0x001C0002)
                Name (_HPP, Package (0x04)
                {
                    0x08, 
                    0x40, 
                    One, 
                    Zero
                })
                OperationRegion (LCTL, PCI_Config, 0x50, 0x04)
                Field (LCTL, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PELD,   1, 
                    PERL,   1
                }

                OperationRegion (SLOT, PCI_Config, 0x54, 0x10)
                Field (SLOT, ByteAcc, NoLock, Preserve)
                {
                    SCAP,   32, 
                    SCTL,   16, 
                    ABP1,   1, 
                    PFD1,   1, 
                    MSC1,   1, 
                    PDC1,   1, 
                    CC10,   1, 
                    MS10,   1, 
                    PDS1,   1, 
                    RSV0,   1, 
                    LASC,   1, 
                    RSV1,   7
                }

                OperationRegion (RHUB, PCI_Config, 0x60, 0x10)
                Field (RHUB, ByteAcc, NoLock, Preserve)
                {
                    PMID,   16, 
                    PMES,   1, 
                    PMEP,   1, 
                    RSV2,   14
                }

                OperationRegion (MISC, PCI_Config, 0xD8, 0x08)
                Field (MISC, ByteAcc, NoLock, Preserve)
                {
                    RSV4,   30, 
                    PMCE,   1, 
                    HPCE,   1, 
                    PMMS,   1, 
                    HPPD,   1, 
                    HPAB,   1, 
                    HPCC,   1, 
                    HPLA,   1, 
                    RSV3,   25, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Method (HPHK, 0, NotSerialized)
                {
                    Store (One, PDC1)
                    Store (One, HPCS)
                    Store (Zero, PELD)
                    Sleep (0xFA)
                }

                Device (XCF0)
                {
                    Name (_ADR, Zero)
                    Method (_STA, 0, NotSerialized)
                    {
                        If (And (FDRT, 0x00040000))
                        {
                            Return (Zero)
                        }

                        Store (RBPE (0x000E205A), Local0)
                        If (And (Local0, 0x40))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (_RMV, 0, NotSerialized)
                    {
                        Return (One)
                    }
                }

                Device (XCF1)
                {
                    Name (_ADR, One)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Device (XCF2)
                {
                    Name (_ADR, 0x02)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Device (XCF3)
                {
                    Name (_ADR, 0x03)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Device (XCF4)
                {
                    Name (_ADR, 0x04)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Device (XCF5)
                {
                    Name (_ADR, 0x05)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Device (XCF6)
                {
                    Name (_ADR, 0x06)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Device (XCF7)
                {
                    Name (_ADR, 0x07)
                    Method (_EJ0, 1, NotSerialized)
                    {
                    }
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR03)
                    }

                    Return (PR03)
                }
            }

            Device (P0P5)
            {
                Name (_ADR, 0x001C0003)
                OperationRegion (LCTL, PCI_Config, 0x50, 0x04)
                Field (LCTL, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PELD,   1, 
                    PERL,   1
                }

                OperationRegion (SLOT, PCI_Config, 0x54, 0x10)
                Field (SLOT, ByteAcc, NoLock, Preserve)
                {
                    SCAP,   32, 
                    SCTL,   16, 
                    ABP1,   1, 
                    PFD1,   1, 
                    MSC1,   1, 
                    PDC1,   1, 
                    CC10,   1, 
                    MS10,   1, 
                    PDS1,   1, 
                    RSV0,   1, 
                    LASC,   1, 
                    RSV1,   7
                }

                OperationRegion (RHUB, PCI_Config, 0x60, 0x10)
                Field (RHUB, ByteAcc, NoLock, Preserve)
                {
                    PMID,   16, 
                    PMES,   1, 
                    PMEP,   1, 
                    RSV2,   14
                }

                OperationRegion (MISC, PCI_Config, 0xD8, 0x08)
                Field (MISC, ByteAcc, NoLock, Preserve)
                {
                    RSV4,   30, 
                    PMCE,   1, 
                    HPCE,   1, 
                    PMMS,   1, 
                    HPPD,   1, 
                    HPAB,   1, 
                    HPCC,   1, 
                    HPLA,   1, 
                    RSV3,   25, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Method (HPHK, 0, NotSerialized)
                {
                    Store (One, PDC1)
                    Store (One, HPCS)
                    Store (Zero, PELD)
                    Sleep (0xFA)
                }
            }

            Device (P0P6)
            {
                Name (_ADR, 0x001E0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0B, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }

                    Return (PR06)
                }

                Device (GLAN)
                {
                    Name (_ADR, 0x00070000)
                    OperationRegion (LANR, PCI_Config, Zero, 0x0100)
                    Field (LANR, ByteAcc, NoLock, Preserve)
                    {
                        VID,    16, 
                                Offset (0xE0), 
                            ,   15, 
                        PMES,   1
                    }

                    Method (_PRW, 0, NotSerialized)
                    {
                        If (WOLF)
                        {
                            Return (GPRW (0x0B, 0x04))
                        }
                        Else
                        {
                            Return (Package (0x02)
                            {
                                0x0B, 
                                Zero
                            })
                        }
                    }
                }

                Device (CBS0)
                {
                    Name (_ADR, 0x00010000)
                    OperationRegion (CBSP, PCI_Config, Zero, 0xF0)
                    Field (CBSP, DWordAcc, NoLock, Preserve)
                    {
                                Offset (0x04), 
                        CB04,   8, 
                                Offset (0x14), 
                        CB14,   8, 
                                Offset (0x3C), 
                        CB3C,   8, 
                                Offset (0x3E), 
                        CB3E,   8, 
                                Offset (0x44), 
                        CB44,   32, 
                                Offset (0xE0), 
                        PME0,   8, 
                        PME1,   8
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (RGPL (0x14, One))
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x0F)
                        }
                    }

                    Method (_INI, 0, NotSerialized)
                    {
                        Store (Zero, CB44)
                    }

                    Method (CBSW, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Store (Zero, CB44)
                        }
                    }

                    Method (CBSR, 0, NotSerialized)
                    {
                        And (PME1, 0x80, Local1)
                        If (Local1)
                        {
                            And (PME0, 0xFC, PME0)
                            Store (PME1, Local2)
                            Store (Local2, PME1)
                        }

                        Return (Local1)
                    }

                    Method (_PRW, 0, NotSerialized)
                    {
                        Return (GPRW (0x0B, 0x04))
                    }
                }
            }
        }
    }

    Scope (_SB.PCI0.SBRG)
    {
        Device (EC0)
        {
            Name (_HID, EisaId ("PNP0C09"))
            Name (_CRS, ResourceTemplate ()
            {
                IO (Decode16,
                    0x0062,             // Range Minimum
                    0x0062,             // Range Maximum
                    0x00,               // Alignment
                    0x01,               // Length
                    )
                IO (Decode16,
                    0x0066,             // Range Minimum
                    0x0066,             // Range Maximum
                    0x00,               // Alignment
                    0x01,               // Length
                    )
            })
            Name (_GPE, 0x1C)
            Mutex (MUEC, 0x00)
            Mutex (ASIO, 0x00)
            Name (ECFL, Ones)
            Method (ECAV, 0, NotSerialized)
            {
                If (LGreaterEqual (_REV, 0x02))
                {
                    Return (One)
                }

                If (LAnd (SLPN, LGreaterEqual (SLPT, 0x04)))
                {
                    Return (Zero)
                }

                If (LEqual (ECFL, Ones))
                {
                    Return (Zero)
                }

                Return (ECFL)
            }

            OperationRegion (ECOR, EmbeddedControl, Zero, 0xFF)
            Field (ECOR, ByteAcc, Lock, Preserve)
            {
                        Offset (0x04), 
                CMD1,   8, 
                CDT1,   8, 
                CDT2,   8, 
                CDT3,   8, 
                        Offset (0x80), 
                EPWS,   8, 
                EB0S,   8, 
                EB1S,   8, 
                EB0R,   8, 
                EB1R,   8, 
                EPWF,   8, 
                        Offset (0x87), 
                EB0T,   8, 
                EB1T,   8, 
                        Offset (0x93), 
                TAH0,   16, 
                TAH1,   16, 
                TSTP,   8, 
                        Offset (0x9C), 
                CDT4,   8, 
                CDT5,   8, 
                        Offset (0xA0), 
                ECPU,   8, 
                ECRT,   8, 
                EPSV,   8, 
                EACT,   8, 
                        Offset (0xB0), 
                B0PN,   16, 
                B0VL,   16, 
                B0RC,   16, 
                B0FC,   16, 
                B0MD,   16, 
                B0ST,   16, 
                B0CC,   16, 
                B0TM,   16, 
                B0C1,   16, 
                B0C2,   16, 
                B0C3,   16, 
                B0C4,   16, 
                        Offset (0xD0), 
                B1PN,   16, 
                B1VL,   16, 
                B1RC,   16, 
                B1FC,   16, 
                B1MD,   16, 
                B1ST,   16, 
                B1CC,   16, 
                B1TM,   16, 
                B1C1,   16, 
                B1C2,   16, 
                B1C3,   16, 
                B1C4,   16, 
                        Offset (0xF0), 
                B0DC,   16, 
                B0DV,   16, 
                B0SN,   16, 
                        Offset (0xF8), 
                B1DC,   16, 
                B1DV,   16, 
                B1SN,   16
            }

            Name (SMBF, Zero)
            OperationRegion (SMBX, EmbeddedControl, 0x18, 0x28)
            Field (SMBX, ByteAcc, NoLock, Preserve)
            {
                PRTC,   8, 
                SSTS,   5, 
                    ,   1, 
                ALFG,   1, 
                CDFG,   1, 
                ADDR,   8, 
                CMDB,   8, 
                BDAT,   256, 
                BCNT,   8, 
                    ,   1, 
                ALAD,   7, 
                ALD0,   8, 
                ALD1,   8
            }

            Field (SMBX, ByteAcc, NoLock, Preserve)
            {
                        Offset (0x04), 
                DAT0,   8, 
                DAT1,   8
            }

            Field (SMBX, ByteAcc, NoLock, Preserve)
            {
                        Offset (0x04), 
                DT2B,   16
            }

            OperationRegion (NSBS, EmbeddedControl, 0x40, 0x04)
            Field (NSBS, ByteAcc, NoLock, Preserve)
            {
                A2AD,   8, 
                A2D0,   8, 
                A2D1,   8, 
                A3AD,   8
            }

            Method (_INI, 0, NotSerialized)
            {
                If (LLessEqual (OSFG, OSME))
                {
                    Store (One, ECFL)
                }
            }

            Method (_REG, 2, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (Arg1, ECFL)
                }
            }
        }
    }

    OperationRegion (_SB.PCI0.SBRG.PIX0, PCI_Config, 0x60, 0x0C)
    Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
    {
        PIRA,   8, 
        PIRB,   8, 
        PIRC,   8, 
        PIRD,   8, 
                Offset (0x08), 
        PIRE,   8, 
        PIRF,   8, 
        PIRG,   8, 
        PIRH,   8
    }

    Scope (_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        CreateWordField (BUFA, One, IRA0)
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRA, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRA, 0x80, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRA, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRB, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRB, 0x80, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRB, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRC, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRC, 0x80, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRC, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRD, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRD, 0x80, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRD, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRE, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRE, 0x80, PIRE)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRE, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x06)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRF, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRF, 0x80, PIRF)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRF, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRG, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRG, 0x80, PIRG)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRG, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRH, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRH, 0x80, PIRH)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRH, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }

    Scope (_SB)
    {
        Name (XCPD, Zero)
        Name (XNPT, One)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x0FFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }

        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (RDPE (Local0), Local1)
            If (LEqual (Local1, Ones))
            {
                Return (Zero)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    WDPE (Local0, And (Local1, 0x00010000))
                    Return (One)
                }

                Return (Zero)
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (GBTT, 1, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Arg0, Zero))
                {
                    Store (EB0T, Local0)
                }
                Else
                {
                    Store (EB1T, Local0)
                }
            }
            Else
            {
                Store (0xFF, Local0)
            }

            Return (Local0)
        }

        Method (WCMD, 1, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CMD1)
                    Release (MUEC)
                }
            }
        }

        Method (DLY0, 1, Serialized)
        {
            If (LNot (ECAV ()))
            {
                Return (Ones)
            }

            Store (Ones, Local0)
            If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
            {
                Store (Arg0, CDT1)
                Store (0x6B, CDT2)
                Store (Zero, CDT3)
                Store (0xBB, CMD1)
                Store (0x7F, Local1)
                While (LAnd (Local1, CMD1))
                {
                    Sleep (One)
                    Decrement (Local1)
                }

                If (LEqual (CMD1, Zero))
                {
                    Store (CDT1, Local0)
                }

                Release (MUEC)
            }

            Return (Local0)
        }

        Method (RRAM, 1, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, Local0)
                    And (Local0, 0xFF, Local1)
                    ShiftRight (Local0, 0x08, Local0)
                    And (Local0, 0xFF, Local0)
                    Store (Local1, CDT3)
                    Store (Local0, CDT2)
                    Store (0x80, CDT1)
                    Store (0xB6, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (CDT1, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local0)
                    }

                    Release (MUEC)
                    Return (Local0)
                }
            }

            Return (Ones)
        }

        Method (WRAM, 2, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, Local0)
                    And (Local0, 0xFF, Local1)
                    ShiftRight (Local0, 0x08, Local0)
                    And (Local0, 0xFF, Local0)
                    Store (Local1, CDT3)
                    Store (Local0, CDT2)
                    Store (0x81, CDT1)
                    Store (Arg1, CDT4)
                    Store (0xB6, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (One, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local0)
                    }

                    Release (MUEC)
                    Return (Local0)
                }
            }

            Return (Ones)
        }

        Method (STBR, 0, Serialized)
        {
            And (VGAF, One, Local0)
            If (Local0)
            {
                ISMI (0x9A)
            }
        }

        Method (SBRV, 1, Serialized)
        {
            WBOV (Zero, Arg0)
        }

        Name (DECF, Zero)
        Method (SFNV, 2, Serialized)
        {
            If (LEqual (Arg0, Zero))
            {
                If (And (DECF, One))
                {
                    Store (RRAM (0x0521), Local0)
                    Or (Local0, 0x80, Local0)
                    WRAM (0x0521, Local0)
                }

                If (And (DECF, 0x02))
                {
                    Store (RRAM (0x0522), Local0)
                    Or (Local0, 0x80, Local0)
                    WRAM (0x0522, Local0)
                }

                Store (Zero, DECF)
                Return (Zero)
            }

            If (LEqual (Arg0, One))
            {
                Store (RRAM (0x0521), Local0)
                And (Local0, 0x7F, Local0)
                WRAM (0x0521, Local0)
                Or (DECF, One, DECF)
                WFOV (Zero, Arg1)
                Return (Zero)
            }

            If (LEqual (Arg0, 0x02))
            {
                Store (RRAM (0x0522), Local0)
                And (Local0, 0x7F, Local0)
                WRAM (0x0522, Local0)
                Or (DECF, 0x02, DECF)
                WFOV (One, Arg1)
                Return (Zero)
            }

            Return (Zero)
        }

        Method (SADC, 2, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT1)
                    Store (Arg1, CDT2)
                    Store (0xC4, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (CDT1, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local0)
                    }

                    Release (MUEC)
                    Return (Local0)
                }
            }

            Return (Ones)
        }

        Method (SBQH, 3, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT1)
                    Store (Arg1, CDT2)
                    Store (Arg2, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (CDT1, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local0)
                    }

                    Release (MUEC)
                    Return (Local0)
                }
            }

            Return (Ones)
        }

        Method (SPIN, 2, Serialized)
        {
            Store (Arg0, Local0)
            If (Arg1)
            {
                Or (Local0, 0x20, Local0)
            }
            Else
            {
                Or (Local0, 0x40, Local0)
            }

            STC5 (Local0)
            Return (One)
        }

        Method (RPIN, 1, Serialized)
        {
            And (Arg0, 0x1F, Local0)
            Store (STC5 (Local0), Local1)
            Return (Local1)
        }

        Method (ST87, 2, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (0x87, CDT1)
                    Store (Arg0, CDT2)
                    Store (Arg1, CDT3)
                    Store (0xB6, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (CDT1, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local0)
                    }

                    Release (MUEC)
                    Return (Local0)
                }
            }

            Return (Ones)
        }

        Method (STC5, 1, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT1)
                    Store (0xC5, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (CDT1, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local0)
                    }

                    Release (MUEC)
                    Return (Local0)
                }
            }

            Return (Ones)
        }

        Method (RBAT, 2, Serialized)
        {
            If (LNot (ECAV ()))
            {
                Return (Ones)
            }

            If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
            {
                Store (0x03, Local0)
                While (Local0)
                {
                    Store (Arg0, CDT2)
                    Store (Arg1, Local1)
                    ShiftLeft (Local1, One, Local1)
                    Add (Local1, 0xDA, Local1)
                    Store (Local1, CMD1)
                    Store (0x7F, Local1)
                    While (LAnd (CMD1, Local1))
                    {
                        Decrement (Local1)
                        Sleep (One)
                    }

                    If (LEqual (CMD1, Zero))
                    {
                        Store (CDT1, Local1)
                        Store (Zero, Local0)
                    }
                    Else
                    {
                        Store (Ones, Local1)
                        Decrement (Local0)
                    }
                }

                Release (MUEC)
                Return (Local1)
            }

            Return (Ones)
        }

        Method (WBAT, 3, Serialized)
        {
            Or (Arg0, 0x80, Local3)
            If (LNot (ECAV ()))
            {
                Return (Ones)
            }

            If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
            {
                Store (0x03, Local0)
                While (Local0)
                {
                    Store (Arg2, CDT1)
                    Store (Local3, CDT2)
                    Store (Arg1, Local1)
                    ShiftLeft (Local1, One, Local1)
                    Add (Local1, 0xDA, Local1)
                    Store (Local1, CMD1)
                    Store (0x7F, Local1)
                    While (LAnd (CMD1, Local1))
                    {
                        Decrement (Local1)
                        Sleep (One)
                    }
                }

                Release (MUEC)
                Return (Local1)
            }

            Return (Ones)
        }

        Method (FNCT, 2, Serialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT2)
                    Store (Arg1, CDT1)
                    Store (0xC4, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    Release (MUEC)
                }
            }
        }

        Name (WRQK, 0x02)
        Name (RDQK, 0x03)
        Name (SDBT, 0x04)
        Name (RCBT, 0x05)
        Name (WRBT, 0x06)
        Name (RDBT, 0x07)
        Name (WRWD, 0x08)
        Name (RDWD, 0x09)
        Name (WRBL, 0x0A)
        Name (RDBL, 0x0B)
        Name (PCLL, 0x0C)
        Name (GOOD, Zero)
        Name (UKER, 0x07)
        Name (DAER, 0x10)
        Name (CMDN, 0x12)
        Name (UKE2, 0x13)
        Name (DADN, 0x17)
        Name (SBTO, 0x18)
        Name (USPT, 0x19)
        Name (SBBY, 0x1A)
        Method (SWTC, 1, Serialized)
        {
            Store (UKER, Local0)
            Store (0x03, Local1)
            While (LAnd (Local0, Local1))
            {
                Store (0x23, Local2)
                While (Local2)
                {
                    If (PRTC)
                    {
                        Sleep (One)
                        Decrement (Local2)
                    }
                    Else
                    {
                        Store (Zero, Local2)
                        Store (SSTS, Local0)
                    }
                }

                If (Local0)
                {
                    Store (Zero, PRTC)
                    Decrement (Local1)
                    If (Local1)
                    {
                        Sleep (One)
                        Store (Arg0, PRTC)
                    }
                }
            }

            Return (Local0)
        }

        Method (SMBR, 3, Serialized)
        {
            Store (Package (0x03)
                {
                    0x07, 
                    Zero, 
                    Zero
                }, Local0)
            If (LNot (ECAV ()))
            {
                Return (Local0)
            }

            If (LNotEqual (Arg0, RDBL))
            {
                If (LNotEqual (Arg0, RDWD))
                {
                    If (LNotEqual (Arg0, RDBT))
                    {
                        If (LNotEqual (Arg0, RCBT))
                        {
                            If (LNotEqual (Arg0, RDQK))
                            {
                                Return (Local0)
                            }
                        }
                    }
                }
            }

            If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
            {
                Store (PRTC, Local1)
                Store (Zero, Local2)
                While (LNotEqual (Local1, Zero))
                {
                    Stall (0x0A)
                    Increment (Local2)
                    If (LGreater (Local2, 0x03E8))
                    {
                        Store (SBBY, Index (Local0, Zero))
                        Store (Zero, Local1)
                    }
                    Else
                    {
                        Store (PRTC, Local1)
                    }
                }

                If (LLessEqual (Local2, 0x03E8))
                {
                    ShiftLeft (Arg1, One, Local3)
                    Or (Local3, One, Local3)
                    Store (Local3, ADDR)
                    If (LNotEqual (Arg0, RDQK))
                    {
                        If (LNotEqual (Arg0, RCBT))
                        {
                            Store (Arg2, CMDB)
                        }
                    }

                    Store (Zero, BDAT)
                    Store (Arg0, PRTC)
                    Store (SWTC (Arg0), Index (Local0, Zero))
                    If (LEqual (DerefOf (Index (Local0, Zero)), Zero))
                    {
                        If (LEqual (Arg0, RDBL))
                        {
                            Store (BCNT, Index (Local0, One))
                            Store (BDAT, Index (Local0, 0x02))
                        }

                        If (LEqual (Arg0, RDWD))
                        {
                            Store (0x02, Index (Local0, One))
                            Store (DT2B, Index (Local0, 0x02))
                        }

                        If (LEqual (Arg0, RDBT))
                        {
                            Store (One, Index (Local0, One))
                            Store (DAT0, Index (Local0, 0x02))
                        }

                        If (LEqual (Arg0, RCBT))
                        {
                            Store (One, Index (Local0, One))
                            Store (DAT0, Index (Local0, 0x02))
                        }
                    }
                }

                Release (MUEC)
            }

            Return (Local0)
        }

        Method (SMBW, 5, Serialized)
        {
            Store (Package (0x01)
                {
                    0x07
                }, Local0)
            If (LNot (ECAV ()))
            {
                Return (Local0)
            }

            If (LNotEqual (Arg0, WRBL))
            {
                If (LNotEqual (Arg0, WRWD))
                {
                    If (LNotEqual (Arg0, WRBT))
                    {
                        If (LNotEqual (Arg0, SDBT))
                        {
                            If (LNotEqual (Arg0, WRQK))
                            {
                                Return (Local0)
                            }
                        }
                    }
                }
            }

            If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
            {
                Store (PRTC, Local1)
                Store (Zero, Local2)
                While (LNotEqual (Local1, Zero))
                {
                    Stall (0x0A)
                    Increment (Local2)
                    If (LGreater (Local2, 0x03E8))
                    {
                        Store (SBBY, Index (Local0, Zero))
                        Store (Zero, Local1)
                    }
                    Else
                    {
                        Store (PRTC, Local1)
                    }
                }

                If (LLessEqual (Local2, 0x03E8))
                {
                    Store (Zero, BDAT)
                    ShiftLeft (Arg1, One, Local3)
                    Store (Local3, ADDR)
                    If (LNotEqual (Arg0, WRQK))
                    {
                        If (LNotEqual (Arg0, SDBT))
                        {
                            Store (Arg2, CMDB)
                        }
                    }

                    If (LEqual (Arg0, WRBL))
                    {
                        Store (Arg3, BCNT)
                        Store (Arg4, BDAT)
                    }

                    If (LEqual (Arg0, WRWD))
                    {
                        Store (Arg4, DT2B)
                    }

                    If (LEqual (Arg0, WRBT))
                    {
                        Store (Arg4, DAT0)
                    }

                    If (LEqual (Arg0, SDBT))
                    {
                        Store (Arg4, DAT0)
                    }

                    Store (Arg0, PRTC)
                    Store (SWTC (Arg0), Index (Local0, Zero))
                }

                Release (MUEC)
            }

            Return (Local0)
        }

        Mutex (MUEP, 0x00)
        Method (RBEP, 1, NotSerialized)
        {
            Store (0xFFFF, Local1)
            If (LEqual (Acquire (MUEP, 0xFFFF), Zero))
            {
                Store (RRAM (0x0620), Local3)
                And (Local3, 0x7F, Local4)
                WRAM (0x0620, Local4)
                Store (0x10, Local2)
                Store (0x10, Local1)
                While (And (LEqual (Local1, 0x10), LNotEqual (Local2, Zero)))
                {
                    SMBW (WRWD, BADR, Zero, 0x02, 0x0635)
                    SMBW (WRWD, BADR, Zero, 0x02, 0x0606)
                    Store (SMBR (RDBT, 0x50, Arg0), Local0)
                    Store (DerefOf (Index (Local0, Zero)), Local1)
                    Decrement (Local2)
                }

                WRAM (0x0620, Local3)
                ShiftLeft (Local1, 0x08, Local1)
                Or (Local1, DerefOf (Index (Local0, 0x02)), Local1)
                Release (MUEP)
            }

            Return (Local1)
        }

        Method (WBEP, 2, NotSerialized)
        {
            Store (0xFFFF, Local1)
            If (LEqual (Acquire (MUEP, 0xFFFF), Zero))
            {
                Store (RRAM (0x0620), Local3)
                And (Local3, 0x7F, Local4)
                WRAM (0x0620, Local4)
                Store (0x10, Local2)
                Store (0x10, Local1)
                While (And (LEqual (Local1, 0x10), LNotEqual (Local2, Zero)))
                {
                    SMBW (WRWD, BADR, Zero, 0x02, 0x0635)
                    SMBW (WRWD, BADR, Zero, 0x02, 0x0606)
                    Store (SMBW (WRBT, 0x50, Arg0, One, Arg1), Local0)
                    Store (DerefOf (Index (Local0, Zero)), Local1)
                    Decrement (Local2)
                }

                WRAM (0x0620, Local3)
                Release (MUEP)
            }

            Return (Local1)
        }

        Method (ECXT, 6, NotSerialized)
        {
            Store (Package (0x06)
                {
                    0x10, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero
                }, Local1)
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg1, CDT1)
                    Store (Arg2, CDT2)
                    Store (Arg3, CDT3)
                    Store (Arg4, CDT4)
                    Store (Arg5, CDT5)
                    Store (Arg0, CMD1)
                    Store (0x7F, Local0)
                    While (LAnd (Local0, CMD1))
                    {
                        Sleep (One)
                        Decrement (Local0)
                    }

                    If (Local0)
                    {
                        Store (Zero, Index (Local1, Zero))
                        Store (CDT1, Index (Local1, One))
                        Store (CDT2, Index (Local1, 0x02))
                        Store (CDT3, Index (Local1, 0x03))
                        Store (CDT4, Index (Local1, 0x04))
                        Store (CDT5, Index (Local1, 0x05))
                    }
                    Else
                    {
                        Store (0x10, Index (Local1, Zero))
                    }

                    Release (MUEC)
                }
            }

            Return (Local1)
        }

        OperationRegion (KAID, SystemIO, 0x025C, One)
        Field (KAID, ByteAcc, NoLock, Preserve)
        {
            AEID,   8
        }

        OperationRegion (KAIC, SystemIO, 0x025D, One)
        Field (KAIC, ByteAcc, NoLock, Preserve)
        {
            AEIC,   8
        }

        Method (WEIE, 0, Serialized)
        {
            Store (0x4000, Local0)
            And (AEIC, 0x02, Local1)
            While (LAnd (LNotEqual (Local0, Zero), LEqual (Local1, 0x02)))
            {
                And (AEIC, 0x02, Local1)
                Decrement (Local0)
            }
        }

        Method (WEOF, 0, Serialized)
        {
            Store (0x4000, Local0)
            And (AEIC, One, Local1)
            While (LAnd (LNotEqual (Local0, Zero), LEqual (Local1, Zero)))
            {
                And (AEIC, One, Local1)
                Decrement (Local0)
            }
        }

        Method (RFOV, 1, Serialized)
        {
            Store (Zero, Local0)
            If (LEqual (Acquire (ASIO, 0xFFFF), Zero))
            {
                WEIE ()
                Store (0x83, AEIC)
                WEIE ()
                Store (Arg0, AEID)
                WEOF ()
                Store (AEID, Local0)
                WEIE ()
                Release (ASIO)
            }

            Return (Local0)
        }

        Method (WFOV, 2, Serialized)
        {
            If (LEqual (Acquire (ASIO, 0xFFFF), Zero))
            {
                WEIE ()
                Store (0x84, AEIC)
                WEIE ()
                Store (Arg0, AEID)
                WEIE ()
                Store (Arg1, AEID)
                Release (ASIO)
            }
        }

        Method (RBOV, 1, Serialized)
        {
            Store (Zero, Local0)
            If (LEqual (Acquire (ASIO, 0xFFFF), Zero))
            {
                WEIE ()
                Store (0x85, AEIC)
                WEIE ()
                Store (Arg0, AEID)
                WEOF ()
                Store (AEID, Local0)
                WEIE ()
                Release (ASIO)
            }

            Return (Local0)
        }

        Method (WBOV, 2, Serialized)
        {
            If (LEqual (Acquire (ASIO, 0xFFFF), Zero))
            {
                WEIE ()
                Store (0x86, AEIC)
                WEIE ()
                Store (Arg0, AEID)
                WEIE ()
                Store (Arg1, AEID)
                Release (ASIO)
            }
        }

        Method (WMFN, 1, Serialized)
        {
            If (LEqual (Acquire (ASIO, 0xFFFF), Zero))
            {
                WEIE ()
                Store (0x98, AEIC)
                WEIE ()
                Store (Arg0, AEID)
                WEIE ()
                Release (ASIO)
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Name (PWAC, Buffer (0x10)
        {
            /* 0000 */    0x1A, 0x2E, 0x47, 0x63, 0x70, 0x79, 0x87, 0x8F, 
            /* 0008 */    0x97, 0x9E, 0xA8, 0xB3, 0xBA, 0xCF, 0xD9, 0xFF
        })
        Name (PWDC, Buffer (0x10)
        {
            /* 0000 */    0x1A, 0x2E, 0x3A, 0x4C, 0x5E, 0x66, 0x6E, 0x72, 
            /* 0008 */    0x80, 0x87, 0x8F, 0x97, 0x9E, 0xA8, 0xB3, 0xCF
        })
        Method (ACPS, 0, Serialized)
        {
            Return (And (GPWS (), One))
        }

        Method (DCPS, 1, Serialized)
        {
            Store (GPWS (), Local0)
            If (Arg0)
            {
                And (Local0, 0x04, Local0)
            }
            Else
            {
                And (Local0, 0x02, Local0)
            }

            If (Local0)
            {
                Store (One, Local0)
            }
            Else
            {
                Store (Zero, Local0)
            }

            Return (Local0)
        }

        Method (GPWS, 0, Serialized)
        {
            If (ECAV ())
            {
                And (EPWS, 0x07, Local0)
            }
            Else
            {
                Store (Zero, Local0)
            }

            Return (Local0)
        }

        Method (BCHG, 1, Serialized)
        {
            If (Arg0)
            {
                If (ECAV ())
                {
                    Store (EB1S, Local0)
                    And (Local0, 0xFF, Local0)
                    If (LNotEqual (Local0, 0xFF))
                    {
                        And (Local0, 0x02, Local0)
                    }
                    Else
                    {
                        Store (Zero, Local0)
                    }
                }
                Else
                {
                    Store (Zero, Local0)
                }

                Return (Local0)
            }
            Else
            {
                If (ECAV ())
                {
                    Store (EB0S, Local0)
                    And (Local0, 0xFF, Local0)
                    If (LNotEqual (Local0, 0xFF))
                    {
                        And (Local0, 0x02, Local0)
                    }
                    Else
                    {
                        Store (Zero, Local0)
                    }
                }
                Else
                {
                    Store (Zero, Local0)
                }

                Return (Local0)
            }
        }

        Method (BCLE, 1, Serialized)
        {
            If (Arg0)
            {
                If (ECAV ())
                {
                    Store (EB1S, Local1)
                    And (Local1, 0xFFFF, Local1)
                    If (LNotEqual (Local1, 0xFFFF))
                    {
                        And (Local1, 0x16, Local1)
                        If (LEqual (Local1, 0x04))
                        {
                            Store (Zero, Local0)
                        }
                        Else
                        {
                            If (LEqual (Local1, 0x02))
                            {
                                Store (One, Local0)
                            }
                            Else
                            {
                                If (LEqual (Local1, 0x10))
                                {
                                    Store (One, Local0)
                                }
                            }
                        }
                    }

                    Store (Ones, Local0)
                }
                Else
                {
                    Store (Ones, Local0)
                }

                Return (Local0)
            }
            Else
            {
                If (ECAV ())
                {
                    Store (EB0S, Local1)
                    And (Local1, 0xFFFF, Local1)
                    If (LNotEqual (Local1, 0xFFFF))
                    {
                        And (Local1, 0x16, Local1)
                        If (LEqual (Local1, 0x04))
                        {
                            Store (Zero, Local0)
                        }
                        Else
                        {
                            If (LEqual (Local1, 0x02))
                            {
                                Store (One, Local0)
                            }
                            Else
                            {
                                If (LEqual (Local1, 0x10))
                                {
                                    Store (One, Local0)
                                }
                            }
                        }
                    }

                    Store (Ones, Local0)
                }
                Else
                {
                    Store (Ones, Local0)
                }

                Return (Local0)
            }
        }

        Method (CHBT, 1, Serialized)
        {
            If (ECAV ())
            {
                Store (GBTT (Arg0), Local1)
                If (LEqual (Local1, 0xFF))
                {
                    Store (Zero, Local0)
                }
                Else
                {
                    And (Local1, 0x10, Local0)
                    If (Local0)
                    {
                        Store (One, Local0)
                    }
                }
            }
            Else
            {
                Store (DCTP, Local0)
            }

            Return (Local0)
        }

        Method (TACH, 1, NotSerialized)
        {
            If (Arg0)
            {
                If (ECAV ())
                {
                    Store (TAH1, Local0)
                    And (Local0, 0xFFFF, Local0)
                    If (LNotEqual (Local0, Zero))
                    {
                        If (LEqual (Local0, 0xFFFF))
                        {
                            Store (Zero, Local0)
                        }
                        Else
                        {
                            Store (0x80, Local1)
                            Store (0x02, Local2)
                            Multiply (Local1, Local2, Local3)
                            Multiply (Local0, Local3, Local4)
                            Divide (0x03938700, Local4, Local5, Local6)
                            Multiply (Local6, 0x0A, Local6)
                            Store (Local6, Local0)
                        }
                    }
                    Else
                    {
                        Store (Zero, Local0)
                    }
                }
                Else
                {
                    Store (Ones, Local0)
                }

                Return (Local0)
            }
            Else
            {
                If (ECAV ())
                {
                    Store (TAH0, Local0)
                    And (Local0, 0xFFFF, Local0)
                    If (LNotEqual (Local0, Zero))
                    {
                        If (LEqual (Local0, 0xFFFF))
                        {
                            Store (Zero, Local0)
                        }
                        Else
                        {
                            Store (0x80, Local1)
                            Store (0x02, Local2)
                            Multiply (Local1, Local2, Local3)
                            Multiply (Local0, Local3, Local4)
                            Divide (0x03938700, Local4, Local5, Local6)
                            Multiply (Local6, 0x0A, Local6)
                            Store (Local6, Local0)
                        }
                    }
                    Else
                    {
                        Store (Zero, Local0)
                    }
                }
                Else
                {
                    Store (Ones, Local0)
                }

                Return (Local0)
            }
        }

        Method (EC0S, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x03)) {}
        }

        Method (EC0W, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x03)) {}
            If (LLessEqual (Arg0, 0x04))
            {
                Store (ACPS (), ACPF)
                Store (DCPS (Zero), DCPF)
            }
        }
    }

    Scope (\)
    {
        Name (TSP, 0x0A)
        Name (TC1, 0x02)
        Name (TC2, 0x0A)
    }

    Scope (_TZ)
    {
        Method (KELV, 1, NotSerialized)
        {
            And (Arg0, 0xFF, Local0)
            If (LGreaterEqual (Local0, 0x80))
            {
                Subtract (0x0100, Local0, Local0)
                Multiply (Local0, 0x0A, Local0)
                Subtract (0x0AAC, Local0, Local0)
                Return (Local0)
            }

            Multiply (Local0, 0x0A, Local0)
            Add (Local0, 0x0AAC, Local0)
            Return (Local0)
        }

        Method (CELC, 1, NotSerialized)
        {
            Subtract (Arg0, 0x0AAC, Local0)
            Divide (Local0, 0x0A, Local1, Local0)
            Return (Local0)
        }

        Name (PLCY, Zero)
        ThermalZone (THRM)
        {
            Method (_CRT, 0, NotSerialized)
            {
                Store (0x7F, Local0)
                Return (KELV (Local0))
            }

            Method (_TMP, 0, NotSerialized)
            {
                Store (0x05, Local1)
                While (Local1)
                {
                    Store (RTMP (), Local0)
                    If (LGreater (Local0, TCRT))
                    {
                        Decrement (Local1)
                    }
                    Else
                    {
                        Store (Zero, Local1)
                    }
                }

                Return (KELV (Local0))
            }

            Method (_PSL, 0, Serialized)
            {
                If (LGreaterEqual (CPUN, 0x02))
                {
                    Return (Package (0x02)
                    {
                        \_PR.CPU1, 
                        \_PR.CPU2
                    })
                }

                Return (Package (0x01)
                {
                    \_PR.CPU1
                })
            }

            Method (_TSP, 0, NotSerialized)
            {
                Multiply (TSP, 0x0A, Local0)
                Return (Local0)
            }

            Method (_TC1, 0, NotSerialized)
            {
                Return (TC1)
            }

            Method (_TC2, 0, NotSerialized)
            {
                Return (TC2)
            }

            Method (_PSV, 0, NotSerialized)
            {
                Store (0x7F, Local0)
                Return (KELV (Local0))
            }

            Method (_SCP, 1, NotSerialized)
            {
                Store (Zero, PLCY)
                Notify (THRM, 0x81)
            }
        }
    }

    Scope (_TZ)
    {
        Name (ATMP, 0x3C)
        Name (LTMP, 0x3C)
        Name (FANS, Zero)
        Method (RTMP, 0, NotSerialized)
        {
            If (\_SB.PCI0.SBRG.EC0.ECAV ())
            {
                Store (\_SB.PCI0.SBRG.EC0.ECPU, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (Local0, LTMP)
                }
            }

            Return (LTMP)
        }

        Method (RLTM, 0, NotSerialized)
        {
            Return (ATMP)
        }

        Method (RCRT, 0, NotSerialized)
        {
            If (\_SB.PCI0.SBRG.EC0.ECAV ())
            {
                Store (\_SB.PCI0.SBRG.EC0.ECRT, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (Local0, TCRT)
                }
            }
        }

        Method (RPSV, 0, NotSerialized)
        {
            If (\_SB.PCI0.SBRG.EC0.ECAV ())
            {
                Store (\_SB.PCI0.SBRG.EC0.EPSV, Local0)
                If (LLess (Local0, 0x80))
                {
                    Store (Local0, TPSV)
                }
            }
        }

        Method (RFAN, 1, NotSerialized)
        {
            If (\_SB.PCI0.SBRG.EC0.ECAV ())
            {
                Store (\_SB.PCI0.SBRG.EC0.TACH (Arg0), Local0)
                Divide (Local0, 0x64, Local1, Local0)
                Add (Local0, One, Local0)
                If (LLessEqual (Local0, 0x3C))
                {
                    Store (Local0, FANS)
                }
                Else
                {
                    Store (FANS, Local0)
                }
            }
            Else
            {
                Store (Zero, Local0)
            }

            Return (Local0)
        }

        Method (RFSE, 0, NotSerialized)
        {
            If (\_SB.PCI0.SBRG.EC0.ECAV ())
            {
                Store (\_SB.PCI0.SBRG.EC0.RFOV (Zero), Local1)
                If (LLess (Local1, 0x80))
                {
                    If (LLess (Local1, 0x0A))
                    {
                        Store (Zero, Local0)
                    }
                    Else
                    {
                        Store (One, Local0)
                    }
                }
                Else
                {
                    If (LLess (Local1, 0xF5))
                    {
                        Store (0x02, Local0)
                    }
                    Else
                    {
                        Store (0x0F, Local0)
                    }
                }
            }
            Else
            {
                Store (Zero, Local0)
            }

            Return (Local0)
        }

        Method (TCHG, 0, NotSerialized)
        {
        }

        Method (THDL, 0, NotSerialized)
        {
        }

        Method (TMSS, 1, NotSerialized)
        {
        }

        Method (TMSW, 1, NotSerialized)
        {
        }
    }

    Scope (\)
    {
        OperationRegion (PMIO, SystemIO, PMBS, 0x50)
        Field (PMIO, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x10), 
                ,   1, 
            TDTY,   3, 
            TENA,   1, 
            TTDT,   3, 
            FRCT,   1, 
                ,   8, 
            THLS,   1, 
                    Offset (0x13), 
                    Offset (0x28), 
                ,   1, 
            PEHS,   1, 
                ,   7, 
            PEPS,   1, 
            BLLS,   1, 
            SBPS,   1, 
                    Offset (0x2A), 
            G00S,   1, 
            G01S,   1, 
            G02S,   1, 
            G03S,   1, 
            G04S,   1, 
            G05S,   1, 
            G06S,   1, 
            G07S,   1, 
            G08S,   1, 
            G09S,   1, 
            G0AS,   1, 
            G0BS,   1, 
            G0CS,   1, 
            G0DS,   1, 
            G0ES,   1, 
            G0FS,   1, 
                ,   1, 
            PEHE,   1, 
            TPOL,   1, 
                ,   6, 
            PEPE,   1, 
            BLLE,   1, 
            SBPE,   1, 
                    Offset (0x2E), 
            G00E,   1, 
            G01E,   1, 
            G02E,   1, 
            G03E,   1, 
            G04E,   1, 
            G05E,   1, 
            G06E,   1, 
            G07E,   1, 
            G08E,   1, 
            G09E,   1, 
            G0AE,   1, 
            G0BE,   1, 
            G0CE,   1, 
            G0DE,   1, 
            G0EE,   1, 
            G0FE,   1, 
                ,   4, 
            SLPE,   1, 
            APME,   1, 
                ,   5, 
            MCSE,   1, 
                ,   1, 
            TCOE,   1, 
            PERE,   1, 
                    Offset (0x32), 
                    Offset (0x34), 
                ,   4, 
            SLPS,   1, 
            APMS,   1, 
                ,   5, 
            MCSS,   1, 
                ,   1, 
            TCOS,   1, 
            PERS,   1, 
                    Offset (0x36), 
                    Offset (0x42), 
                ,   1, 
            GPEC,   1
        }

        OperationRegion (GPIO, SystemIO, GPBS, 0x40)
        Field (GPIO, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x0C), 
            GL00,   16, 
            GL10,   16, 
                    Offset (0x18), 
            GB00,   32, 
                    Offset (0x2C), 
            GP00,   16, 
                    Offset (0x38), 
            GL20,   32
        }

        OperationRegion (RCBA, SystemMemory, 0xFED1C000, 0x4000)
        Field (RCBA, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x3418), 
            FDRT,   32
        }

        Method (RGPL, 2, Serialized)
        {
            Store (Arg1, Local0)
            Store (Zero, Local1)
            While (Local0)
            {
                ShiftLeft (Local1, One, Local1)
                Or (Local1, One, Local1)
                Decrement (Local0)
            }

            If (LLess (Arg0, 0x10))
            {
                ShiftLeft (Local1, Arg0, Local1)
                Store (GL00, Local0)
                And (Local0, Local1, Local0)
                ShiftRight (Local0, Arg0, Local0)
            }
            Else
            {
                If (LLess (Arg0, 0x20))
                {
                    Store (GL10, Local0)
                    Subtract (Arg0, 0x10, Local2)
                }
                Else
                {
                    Store (GL20, Local0)
                    Subtract (Arg0, 0x20, Local2)
                }

                ShiftLeft (Local1, Local2, Local1)
                And (Local0, Local1, Local0)
                ShiftRight (Local0, Local2, Local0)
            }

            Return (Local0)
        }

        Method (SGPL, 3, Serialized)
        {
            Store (Arg1, Local0)
            Store (Zero, Local1)
            While (Local0)
            {
                ShiftLeft (Local1, One, Local1)
                Or (Local1, One, Local1)
                Decrement (Local0)
            }

            If (LGreaterEqual (Arg0, 0x10))
            {
                If (LLess (Arg0, 0x20))
                {
                    Store (GL10, Local0)
                    Subtract (Arg0, 0x10, Local2)
                }
                Else
                {
                    Store (GL20, Local0)
                    Subtract (Arg0, 0x20, Local2)
                }

                ShiftLeft (Local1, Local2, Local1)
                Not (Local1, Local3)
                And (Local0, Local3, Local0)
                ShiftLeft (Arg2, Local2, Local4)
                Or (Local0, Local4, Local0)
                If (LLess (Arg0, 0x20))
                {
                    Store (Local0, GL10)
                }
                Else
                {
                    Store (Local0, GL20)
                }
            }
            Else
            {
                ShiftLeft (Local1, Arg0, Local1)
                Not (Local1, Local3)
                And (GL00, Local3, Local0)
                ShiftLeft (Arg2, Arg0, Local4)
                Or (Local0, Local4, Local0)
                Store (Local0, GL00)
            }
        }

        Method (RGPP, 1, Serialized)
        {
            ShiftRight (GP00, Arg0, Local0)
            And (Local0, One, Local0)
            Return (Local0)
        }

        Method (TGPP, 1, Serialized)
        {
            ShiftLeft (One, Arg0, Local0)
            XOr (GP00, Local0, GP00)
        }

        Method (SGPP, 2, Serialized)
        {
            ShiftLeft (One, Arg0, Local0)
            If (Arg1)
            {
                Or (GP00, Local0, GP00)
            }
            Else
            {
                Not (Local0, Local1)
                And (GP00, Local1, GP00)
            }
        }

        Name (PMEW, Zero)
        Method (SBRS, 1, NotSerialized)
        {
            CPXS ()
            \_SB.PCI0.USB0.USBS (Arg0)
            \_SB.PCI0.USB1.USBS (Arg0)
            \_SB.PCI0.USB2.USBS (Arg0)
            \_SB.PCI0.USB3.USBS (Arg0)
            \_SB.PCI0.USB4.USBS (Arg0)
        }

        Method (SBRW, 1, NotSerialized)
        {
            Store (SBPS, PMEW)
            \_SB.PCI0.USB0.USBW (Arg0)
            \_SB.PCI0.USB1.USBW (Arg0)
            \_SB.PCI0.USB2.USBW (Arg0)
            \_SB.PCI0.USB3.USBW (Arg0)
            \_SB.PCI0.USB4.USBW (Arg0)
        }

        Method (STRP, 1, NotSerialized)
        {
            If (Arg0)
            {
                Store (One, SLPS)
                Store (One, SLPE)
            }
            Else
            {
                Store (Zero, SLPE)
                Store (One, SLPS)
            }
        }

        Method (HKTH, 0, Serialized)
        {
            If (THLS)
            {
                Return (TTDT)
            }
            Else
            {
                Return (0xFFFF)
            }
        }

        Method (CPXS, 0, NotSerialized)
        {
            Store (Zero, Local0)
            Store (0x00010000, Local1)
            Store (0x000E0060, Local2)
            Store (0x000E00DC, Local3)
            While (LLess (Local0, 0x04))
            {
                If (LNot (And (FDRT, Local1)))
                {
                    While (And (\_SB.RDPE (Local2), 0x00010000))
                    {
                        Or (\_SB.RDPE (Local2), 0x00010000, Local4)
                        \_SB.WDPE (Local2, Local4)
                    }

                    While (And (\_SB.RDPE (Local3), 0x80000000))
                    {
                        Or (\_SB.RDPE (Local3), 0x80000000, Local4)
                        \_SB.WDPE (Local3, Local4)
                    }
                }

                Add (Local2, 0x1000, Local2)
                Add (Local3, 0x1000, Local3)
                ShiftLeft (Local1, One, Local1)
                Increment (Local0)
            }

            While (And (PEPS, One))
            {
                Or (PEPS, One, PEPS)
            }
        }
    }

    Scope (_GPE)
    {
        Method (_L01, 0, NotSerialized)
        {
            If (LNot (And (FDRT, 0x00040000)))
            {
                If (\_SB.PCI0.P0P3.HPCS)
                {
                    \_SB.PCI0.P0P3.HPHK ()
                    Notify (\_SB.PCI0.P0P3, Zero)
                }
            }
        }
    }

    Method (_L09, 0, NotSerialized)
    {
        If (\_SB.PCI0.P0P1.PMES)
        {
            While (\_SB.PCI0.P0P1.PMES)
            {
                Store (One, \_SB.PCI0.P0P1.PMES)
                Store (One, \_SB.PCI0.P0P1.PMCS)
            }

            Notify (\_SB.PCI0.P0P1, 0x02)
        }

        If (\_SB.PCI0.P0P2.PMES)
        {
            While (\_SB.PCI0.P0P2.PMES)
            {
                Store (One, \_SB.PCI0.P0P2.PMES)
                Store (One, \_SB.PCI0.P0P2.PMCS)
            }

            Notify (\_SB.PCI0.P0P2, 0x02)
        }

        If (\_SB.PCI0.P0P3.PMES)
        {
            While (\_SB.PCI0.P0P3.PMES)
            {
                Store (One, \_SB.PCI0.P0P3.PMES)
                Store (One, \_SB.PCI0.P0P3.PMCS)
            }

            Notify (\_SB.PCI0.P0P3, 0x02)
        }
    }

    Scope (\)
    {
        OperationRegion (SMB0, SystemIO, SMBS, 0x10)
        Field (SMB0, ByteAcc, NoLock, Preserve)
        {
            HSTS,   8, 
            SSTS,   8, 
            HSTC,   8, 
            HCMD,   8, 
            HADR,   8, 
            HDT0,   8, 
            HDT1,   8, 
            BLKD,   8, 
            SLCT,   8, 
            SHCM,   8, 
            SLEV,   16, 
            SLDT,   16, 
            SCFG,   8, 
            SADR,   8
        }

        Name (RBUF, Package (0x20) {})
        Method (HBSY, 0, NotSerialized)
        {
            Store (0x00FFFFFF, Local0)
            While (Local0)
            {
                And (HSTS, One, Local1)
                If (LNot (Local1))
                {
                    Return (Zero)
                }

                Decrement (Local0)
            }

            Return (One)
        }

        Method (WTSB, 0, NotSerialized)
        {
            Store (0x00FFFFFF, Local0)
            While (Local0)
            {
                Decrement (Local0)
                And (HSTS, 0x1E, Local1)
                If (LEqual (Local1, 0x02))
                {
                    Return (One)
                }

                If (Local1)
                {
                    Return (Zero)
                }
            }

            Return (Zero)
        }

        Mutex (P4SM, 0x00)
        Method (SBYT, 2, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Store (Arg0, HADR)
                    Store (Arg1, HCMD)
                    Store (0xFF, HSTS)
                    Store (0x44, HSTC)
                    If (WTSB ())
                    {
                        Release (P4SM)
                        Return (One)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (WBYT, 3, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Store (Arg0, HADR)
                    Store (Arg1, HCMD)
                    Store (Arg2, HDT0)
                    Store (0xFF, HSTS)
                    Store (0x48, HSTC)
                    If (WTSB ())
                    {
                        Release (P4SM)
                        Return (One)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (WWRD, 3, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Store (Arg0, HADR)
                    Store (Arg1, HCMD)
                    And (Arg2, 0xFF, Local1)
                    ShiftRight (Arg2, 0x08, Local2)
                    And (Local2, 0xFF, Local2)
                    Store (Local2, HDT0)
                    Store (Local1, HDT1)
                    Store (0xFF, HSTS)
                    Store (0x4C, HSTC)
                    If (WTSB ())
                    {
                        Release (P4SM)
                        Return (One)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (WBLK, 3, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Store (Arg0, HADR)
                    Store (Arg1, HCMD)
                    Store (HSTC, Local1)
                    Store (Arg2, Local2)
                    Store (Zero, Local1)
                    While (Local2)
                    {
                        Store (DerefOf (Index (RBUF, Local1)), BLKD)
                        Decrement (Local2)
                        Increment (Local1)
                    }

                    Store (Arg2, HDT0)
                    Store (HSTC, Local1)
                    Store (0xFF, HSTS)
                    Store (0x54, HSTC)
                    If (WTSB ())
                    {
                        Release (P4SM)
                        Return (One)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (RSBT, 2, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Or (Arg0, One, HADR)
                    Store (Arg1, HCMD)
                    Store (0xFF, HSTS)
                    Store (0x44, HSTC)
                    If (WTSB ())
                    {
                        Release (P4SM)
                        Return (HDT0)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (RBYT, 2, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Or (Arg0, One, HADR)
                    Store (Arg1, HCMD)
                    Store (0xFF, HSTS)
                    Store (0x48, HSTC)
                    If (WTSB ())
                    {
                        Release (P4SM)
                        Return (HDT0)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (RWRD, 2, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Or (Arg0, One, HADR)
                    Store (Arg1, HCMD)
                    Store (0xFF, HSTS)
                    Store (0x4C, HSTC)
                    If (WTSB ())
                    {
                        Store (HDT0, Local1)
                        ShiftLeft (Local1, 0x08, Local1)
                        Store (HDT1, Local2)
                        Add (Local1, Local2, Local1)
                        Release (P4SM)
                        Return (Local1)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }

        Method (RBLK, 3, Serialized)
        {
            If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
            {
                Return (Ones)
            }

            Store (0x05, Local0)
            While (Local0)
            {
                If (HBSY ())
                {
                    Decrement (Local0)
                }
                Else
                {
                    Or (Arg0, One, HADR)
                    Store (Arg1, HCMD)
                    Store (0xFF, HSTS)
                    Store (0x54, HSTC)
                    If (WTSB ())
                    {
                        Store (HSTC, Local1)
                        Store (HDT0, Local2)
                        Store (Local2, Local3)
                        Store (Zero, RBUF)
                        Store (Zero, Local1)
                        While (Local2)
                        {
                            Store (BLKD, Index (RBUF, Local1))
                            Decrement (Local2)
                            Increment (Local1)
                        }

                        Release (P4SM)
                        Return (Local3)
                    }
                    Else
                    {
                        Decrement (Local0)
                    }
                }
            }

            Release (P4SM)
            Return (Ones)
        }
    }

    Scope (_SB.PCI0)
    {
        Name (SUPP, Zero)
        Name (CTRL, Zero)
        Method (_OSC, 4, NotSerialized)
        {
            If (LEqual (Arg0, Buffer (0x10)
                    {
                        /* 0000 */    0x5B, 0x4D, 0xDB, 0x33, 0xF7, 0x1F, 0x1C, 0x40, 
                        /* 0008 */    0x96, 0x57, 0x74, 0x41, 0xC0, 0x3D, 0xD7, 0x66
                    }))
            {
                CreateDWordField (Arg3, Zero, CDW1)
                CreateDWordField (Arg3, 0x04, CDW2)
                CreateDWordField (Arg3, 0x08, CDW3)
                Store (CDW2, SUPP)
                Store (CDW3, CTRL)
                If (LNotEqual (And (SUPP, 0x16), 0x16))
                {
                    And (CTRL, 0x1E)
                }

                And (CTRL, 0x1D, CTRL)
                If (Not (And (CDW1, One)))
                {
                    If (And (CTRL, One))
                    {
                        Store (Zero, ^P0P3.HPCE)
                        Store (One, ^P0P3.HPCS)
                        Store (One, ^P0P3.ABP1)
                        Store (One, ^P0P3.PDC1)
                        Or (One, OSCF, OSCF)
                    }

                    If (And (CTRL, 0x04))
                    {
                        Store (Zero, ^SBRG.IELK.BCPE)
                        Store (Zero, ^P0P3.PMCE)
                        Store (One, ^P0P3.PMCS)
                        Or (0x04, OSCF, OSCF)
                    }
                }

                If (LNotEqual (Arg1, One))
                {
                    Or (CDW1, 0x08, CDW1)
                }

                If (LNotEqual (CDW3, CTRL))
                {
                    Or (CDW1, 0x10, CDW1)
                }

                Store (CTRL, CDW3)
                Return (Arg3)
            }
            Else
            {
                Or (CDW1, 0x04, CDW1)
                Return (Arg3)
            }
        }

        Name (OSCF, Zero)
        Method (OSCW, 0, NotSerialized)
        {
            If (And (OSCF, One))
            {
                Store (Zero, ^P0P3.HPCE)
                Store (One, ^P0P3.HPCS)
                Store (One, ^P0P3.ABP1)
                Store (One, ^P0P3.PDC1)
            }

            If (And (OSCF, 0x04))
            {
                Store (Zero, ^SBRG.IELK.BCPE)
                Store (Zero, ^P0P3.PMCE)
                Store (One, ^P0P3.PMCS)
            }
        }
    }

    Scope (_SB)
    {
        Name (ATKP, Zero)
        Device (ATKD)
        {
            Name (_HID, "ATK0100")
            Name (_UID, 0x01010100)
            Method (INIT, 1, NotSerialized)
            {
                Store (One, S4ST)
                Store (One, LCDT)
                If (And (WAF1, 0x80))
                {
                    Notify (ATKD, 0x69)
                }

                Store (One, ATKP)
                Return (MNAM)
            }

            Method (BSTS, 0, NotSerialized)
            {
                Store (IKFG, Local0)
                Or (Local0, ShiftLeft (IKF2, 0x08), Local0)
                If (ACPF)
                {
                    And (Local0, 0xFF7F, Local0)
                }

                Return (Local0)
            }

            Method (MLED, 1, NotSerialized)
            {
                OMLD (Arg0)
            }

            Method (TMPR, 0, NotSerialized)
            {
                Store (\_TZ.RTMP (), Local0)
                Store (\_TZ.RFAN (Zero), Local1)
                ShiftLeft (Local1, 0x10, Local1)
                Add (\_TZ.KELV (Local0), Local1, Local0)
                Store (Zero, Local2)
                If (TENA)
                {
                    Store (TDTY, Local2)
                }
                Else
                {
                    Store (HKTH (), Local3)
                    If (LNotEqual (Local3, 0xFFFF))
                    {
                        Store (Local3, Local2)
                    }
                }

                ShiftLeft (Local2, 0x18, Local2)
                Add (Local0, Local2, Local0)
                Store (\_TZ.RFSE (), Local3)
                ShiftLeft (Local3, 0x1C, Local3)
                Add (Local0, Local3, Local0)
                Return (Local0)
            }

            Method (SFUN, 0, NotSerialized)
            {
                Store (0x37, Local0)
                Or (Local0, 0x40, Local0)
                Or (Local0, 0x80, Local0)
                Or (Local0, 0x0800, Local0)
                Or (Local0, 0x4000, Local0)
                Or (Local0, 0x00020000, Local0)
                Or (Local0, 0x00080000, Local0)
                Return (Local0)
            }

            Method (OSVR, 1, NotSerialized)
            {
                Store (Arg0, OSFG)
            }

            Method (GPLV, 0, NotSerialized)
            {
                Return (LBTN)
            }

            Method (SPLV, 1, NotSerialized)
            {
                Store (Arg0, LBTN)
                ^^PCI0.SBRG.EC0.STBR ()
            }

            Method (WLED, 1, NotSerialized)
            {
                OWLD (Arg0)
                Store (Arg0, WRST)
                If (Arg0)
                {
                    Notify (ATKD, 0x5E)
                    SGPL (0x16, One, Zero)
                }
                Else
                {
                    Notify (ATKD, 0x5F)
                    SGPL (0x16, One, One)
                }
            }

            Method (BLED, 1, NotSerialized)
            {
                OBTD (Arg0)
            }

            Method (RSTS, 0, NotSerialized)
            {
                Return (ORST ())
            }

            Method (SDSP, 1, NotSerialized)
            {
                If (NATK ())
                {
                    SWHG (Arg0)
                }
            }

            Method (GPID, 0, NotSerialized)
            {
                Return (LCDR)
            }

            Method (HWRS, 0, NotSerialized)
            {
                Return (OHWR ())
            }

            Method (GLCD, 0, NotSerialized)
            {
                Return (LCDV)
            }

            Name (WAPF, Zero)
            Method (CWAP, 1, NotSerialized)
            {
                Or (Arg0, WAPF, WAPF)
                Return (One)
            }

            Name (PCDV, Zero)
            Method (WDOG, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x10))
                {
                    If (And (WAF1, 0x80))
                    {
                        Return (0x8003)
                    }

                    Return (Zero)
                }

                If (LEqual (Arg0, 0x11))
                {
                    If (And (WAF1, 0x80))
                    {
                        Decrement (WAF1)
                        If (And (WAF1, 0x40))
                        {
                            Notify (LID, 0x80)
                        }

                        If (And (WAF1, 0x0F))
                        {
                            Return (0x0100)
                        }
                        Else
                        {
                            Store (Zero, WAF1)
                            Return (Zero)
                        }
                    }

                    Return (Zero)
                }

                If (LEqual (Arg0, Zero))
                {
                    Store (PTIM, PCDV)
                    Return (0x3C)
                }

                If (LEqual (Arg0, One))
                {
                    Return (One)
                    If (^^LID._LID ())
                    {
                        Store (PTIM, PCDV)
                        Return (One)
                    }

                    If (LLess (\_TZ.RLTM (), PTMP))
                    {
                        Store (PTIM, PCDV)
                        Return (One)
                    }

                    Decrement (PCDV)
                    If (LEqual (PCDV, Zero))
                    {
                        Store (PTIM, PCDV)
                        Notify (ATKD, 0x6D)
                    }

                    Return (One)
                }

                Return (Zero)
            }

            Method (QMOD, 1, NotSerialized)
            {
                If (LEqual (Arg0, Zero))
                {
                    Return (One)
                }

                If (LEqual (Arg0, One))
                {
                    ShiftLeft (QFAN, 0x10, Local0)
                    Add (Local0, 0x98B6, Local0)
                    ECRW (Local0)
                }

                If (LEqual (Arg0, 0x02))
                {
                    ECRW (0x00FF98B6)
                }

                Return (One)
            }

            Method (ANVI, 1, Serialized)
            {
                Store (ASMI (Arg0), Local0)
                Return (Local0)
            }

            Method (PSTC, 1, Serialized)
            {
                If (LEqual (Arg0, Zero))
                {
                    Return (PSTN)
                }

                If (ACPF)
                {
                    ShiftRight (PSTN, 0x08, Local0)
                }
                Else
                {
                    And (PSTN, 0xFF, Local0)
                }

                If (LGreater (Arg0, Local0))
                {
                    Return (Ones)
                }

                Store (Arg0, SLMT)
                If (CIST)
                {
                    Notify (\_PR.CPU1, 0x80)
                    If (LGreaterEqual (CPUN, 0x02))
                    {
                        Notify (\_PR.CPU2, 0x80)
                    }
                }

                Return (Zero)
            }

            Method (SMBB, 1, Serialized)
            {
                ShiftRight (Arg0, 0x10, Local0)
                And (Local0, 0xFF, Local0)
                ShiftRight (Arg0, 0x18, Local1)
                And (Arg0, 0xFF, Local2)
                If (And (Local1, One))
                {
                    Return (RBYT (Local1, Local0))
                }
                Else
                {
                    Return (WBYT (Local1, Local0, Local2))
                }
            }

            Method (SMBW, 1, Serialized)
            {
                ShiftRight (Arg0, 0x10, Local0)
                And (Local0, 0xFF, Local0)
                ShiftRight (Arg0, 0x18, Local1)
                And (Arg0, 0xFF, Local2)
                If (And (Local1, One))
                {
                    Return (RWRD (Local1, Local0))
                }
                Else
                {
                    Return (WWRD (Local1, Local0, Local2))
                }
            }

            Method (SMBK, 1, Serialized)
            {
                ShiftRight (Arg0, 0x08, Local0)
                And (Local0, 0xFF, Local0)
                If (Local0)
                {
                    ShiftRight (Arg0, 0x10, Local0)
                    And (Local0, 0xFF, Local0)
                    ShiftRight (Arg0, 0x18, Local1)
                    And (Local1, 0xFF, Local1)
                    And (Arg0, 0x0F, Local3)
                    If (And (Local1, One))
                    {
                        RBLK (Local1, Local0, Local3)
                    }
                    Else
                    {
                        WBLK (Local1, Local0, Local3)
                    }

                    Return (Zero)
                }
                Else
                {
                    ShiftRight (Arg0, 0x10, Local2)
                    And (Local2, 0xFF, Local2)
                    ShiftRight (Arg0, 0x18, Local1)
                    If (And (Local1, One))
                    {
                        Return (DerefOf (Index (RBUF, Local2)))
                    }
                    Else
                    {
                        And (Arg0, 0xFF, Local1)
                        Store (Local1, Index (RBUF, Local2))
                        Return (Zero)
                    }
                }
            }

            Method (ECRW, 1, Serialized)
            {
                ShiftRight (Arg0, 0x18, Local0)
                And (Local0, 0xFF, Local0)
                ShiftRight (Arg0, 0x10, Local1)
                And (Local1, 0xFF, Local1)
                ShiftRight (Arg0, 0x08, Local2)
                And (Local2, 0xFF, Local2)
                And (Arg0, 0xFF, Local3)
                If (LNotEqual (Acquire (P4SM, 0xFFFF), Zero))
                {
                    Return (Ones)
                }

                Store (Local0, ^^PCI0.SBRG.EC0.CDT3)
                Store (Local1, ^^PCI0.SBRG.EC0.CDT2)
                Store (Local2, ^^PCI0.SBRG.EC0.CDT1)
                Store (Local3, ^^PCI0.SBRG.EC0.CMD1)
                Store (0x05, Local0)
                While (LAnd (Local0, ^^PCI0.SBRG.EC0.CMD1))
                {
                    Sleep (One)
                    Decrement (Local0)
                }

                Store (^^PCI0.SBRG.EC0.CDT3, Local0)
                Store (^^PCI0.SBRG.EC0.CDT2, Local1)
                Store (^^PCI0.SBRG.EC0.CDT1, Local2)
                Store (^^PCI0.SBRG.EC0.CMD1, Local3)
                Release (P4SM)
                ShiftLeft (Local0, 0x08, Local0)
                Or (Local0, Local1, Local0)
                ShiftLeft (Local0, 0x08, Local0)
                Or (Local0, Local2, Local0)
                ShiftLeft (Local0, 0x08, Local0)
                Or (Local0, Local3, Local0)
                Return (Local0)
            }

            Name (FNXX, Zero)
            Method (FNKY, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x80))
                {
                    If (LEqual (FNXX, 0xD2))
                    {
                        Return (0x03)
                    }

                    Store (^^PCI0.SBRG.EC0.ECBA (0x65, Zero), Local0)
                    If (And (Local0, 0x04))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        If (And (Local0, 0x02))
                        {
                            Return (One)
                        }
                    }

                    Return (Zero)
                }
                Else
                {
                    If (LEqual (Arg0, 0x05))
                    {
                        ^^PCI0.SBRG.EC0.ECE2 (0x02)
                        ^^PCI0.SBRG.EC0.ECBB (0xC4, 0x65, Zero)
                        Store (^^PCI0.SBRG.EC0.ECBA (0x25, Zero), Local0)
                        Or (Local0, 0x02, Local0)
                        ^^PCI0.SBRG.EC0.ECBB (Local0, 0x25, Zero)
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x04))
                        {
                            ^^PCI0.SBRG.EC0.ECE2 (0x02)
                            ^^PCI0.SBRG.EC0.ECBB (0xC2, 0x65, Zero)
                            Store (^^PCI0.SBRG.EC0.ECBA (0x25, Zero), Local0)
                            Or (Local0, 0x02, Local0)
                            ^^PCI0.SBRG.EC0.ECBB (Local0, 0x25, Zero)
                        }
                        Else
                        {
                            If (LEqual (Arg0, 0x03))
                            {
                                Store (^^PCI0.SBRG.EC0.B680 (0x04, 0xC0), Local0)
                                And (Local0, 0xFD, Local0)
                                ^^PCI0.SBRG.EC0.B681 (0x04, 0xC0, Local0)
                            }
                            Else
                            {
                                If (LEqual (Arg0, 0x02))
                                {
                                    Store (^^PCI0.SBRG.EC0.B680 (0x04, 0xC0), Local0)
                                    Or (Local0, 0x02, Local0)
                                    ^^PCI0.SBRG.EC0.B681 (0x04, 0xC0, Local0)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, One))
                                    {
                                        ^^PCI0.SBRG.EC0.ECE2 (0x02)
                                    }
                                    Else
                                    {
                                        If (LEqual (Arg0, Zero))
                                        {
                                            ^^PCI0.SBRG.EC0.ECE2 (Zero)
                                        }
                                        Else
                                        {
                                            If (LEqual (And (Arg0, 0xF0), 0x10))
                                            {
                                                Store (^^PCI0.SBRG.EC0.B680 (0x04, 0xC0), Local0)
                                                And (Local0, 0xFE, Local0)
                                                ^^PCI0.SBRG.EC0.B681 (0x04, 0xC0, Local0)
                                                And (Arg0, 0x0F, Local1)
                                                Multiply (Local1, 0x3C, Local1)
                                                ^^PCI0.SBRG.EC0.B681 (0x04, 0xC1, And (Local1, 0xFF))
                                                ^^PCI0.SBRG.EC0.B681 (0x04, 0xC2, ShiftRight (Local1, 0x08))
                                                If (Local1)
                                                {
                                                    Or (Local0, One, Local0)
                                                    ^^PCI0.SBRG.EC0.B681 (0x04, 0xC0, Local0)
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    Scope (_SB.ATKD)
    {
        Name (WBCF, Zero)
        Name (NABC, Zero)
        Name (B0BC, Zero)
        Name (B1BC, Zero)
        Method (PWBC, 1, NotSerialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Store (One, WBCF)
                Store (One, Local0)
                If (^^PCI0.SBRG.EC0.BATP (Zero))
                {
                    Or (Local0, 0x0100, Local0)
                }

                Return (Local0)
            }

            If (LEqual (Arg0, One))
            {
                If (^^PCI0.SBRG.EC0.BATP (Zero))
                {
                    ^^PCI0.SBRG.EC0.RSTB (Zero)
                }

                Return (One)
            }

            If (LEqual (Arg0, 0x02))
            {
                SBTL (One)
                Or (WBCF, 0x02, WBCF)
                ^^PCI0.SBRG.EC0.STBR ()
                Notify (\_PR.CPU1, 0x80)
                Return (One)
            }

            If (LEqual (Arg0, 0x03))
            {
                Return (^^PCI0.SBRG.EC0.PERC (Zero))
            }

            If (LEqual (Arg0, 0x05))
            {
                SBTL (Zero)
                And (WBCF, 0xFD, WBCF)
                ^^PCI0.SBRG.EC0.STBR ()
                Store (Zero, WBCF)
                Notify (\_PR.CPU1, 0x80)
                Return (One)
            }

            If (LEqual (Arg0, 0x06))
            {
                SBTL (Zero)
                And (WBCF, 0xFD, WBCF)
                ^^PCI0.SBRG.EC0.STBR ()
                Store (Zero, WBCF)
                Notify (\_PR.CPU1, 0x80)
                If (^^PCI0.SBRG.EC0.BATP (Zero))
                {
                    Store (One, B0BC)
                }

                Return (One)
            }

            If (LEqual (Arg0, 0x07))
            {
                Store (Zero, Local0)
                If (NABC)
                {
                    If (^^PCI0.SBRG.EC0.BATP (Zero))
                    {
                        If (^^PCI0.SBRG.EC0.CBYN (Zero))
                        {
                            Or (Local0, One, Local0)
                        }

                        If (B0BC)
                        {
                            Or (Local0, One, Local0)
                        }
                    }
                }

                Return (Local0)
            }

            If (LEqual (Arg0, 0x08))
            {
                Store (Zero, NABC)
                Return (One)
            }

            If (LEqual (Arg0, 0x09))
            {
                Store (One, NABC)
                Return (One)
            }

            If (LEqual (Arg0, 0x0A))
            {
                If (^^PCI0.SBRG.EC0.BL2C ())
                {
                    Notify (ATKD, 0x6E)
                }

                Return (One)
            }

            If (LEqual (Arg0, 0x0B))
            {
                Store (One, Local0)
                If (^^PCI0.SBRG.EC0.BL2C ())
                {
                    Notify (ATKD, 0x6E)
                    Store (Zero, Local0)
                }

                Return (Local0)
            }

            Return (One)
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (PERC, 1, NotSerialized)
        {
            If (Arg0) {}
            Else
            {
                ^^^BAT0._BST ()
                ^^^BAT0._BIF ()
                Store (DerefOf (Index (^^^BAT0.PBST, Zero)), Local0)
                Store (DerefOf (Index (^^^BAT0.PBST, 0x02)), Local1)
                Store (DerefOf (Index (^^^BAT0.PBIF, 0x02)), Local2)
            }

            Multiply (Local1, 0x64, Local1)
            Divide (Local1, Local2, Local3, Local4)
            If (And (^^^^ATKD.WBCF, 0x02))
            {
                If (CBCE ())
                {
                    Or (Local4, 0x0100, Local4)
                }

                If (And (Local0, One))
                {
                    Or (Local4, 0x0800, Local4)
                }
            }
            Else
            {
                If (ACPF)
                {
                    If (BCFC ())
                    {
                        Or (Local4, 0x0200, Local4)
                    }

                    If (And (Local0, 0x02))
                    {
                        Or (Local4, 0x0400, Local4)
                    }
                }
            }

            Return (Local4)
        }

        Method (CBL2, 0, NotSerialized)
        {
            Store (Zero, Local1)
            If (LAnd (BATP (Zero), LNot (^^^^ATKD.B0BC)))
            {
                And (PERC (Zero), 0xFF, Local0)
                If (LGreaterEqual (Local0, 0x0A))
                {
                    Or (Local1, One, Local1)
                    Store (One, ^^^^ATKD.B0BC)
                }
            }

            If (LNot (And (^^^^ATKD.WBCF, 0x02)))
            {
                If (LAnd (Local1, ^^^^ATKD.NABC))
                {
                    Notify (ATKD, 0x7B)
                }
                Else
                {
                    Notify (ATKD, 0x6E)
                }
            }
        }

        Method (CWCF, 0, NotSerialized)
        {
            If (ATKP)
            {
                Store (Zero, Local0)
                While (LAnd (BCFC (), LLessEqual (Local0, 0x02)))
                {
                    Sleep (0x01F4)
                    Increment (Local0)
                }

                If (LGreaterEqual (Local0, 0x03))
                {
                    Store (Zero, Local1)
                    If (LAnd (BATP (Zero), LNot (^^^^ATKD.B0BC)))
                    {
                        And (PERC (Zero), 0xFF, Local0)
                        If (LLessEqual (Local0, 0x61))
                        {
                            Or (Local1, One, Local1)
                            Store (One, ^^^^ATKD.B0BC)
                        }
                    }

                    If (LNot (And (^^^^ATKD.WBCF, One)))
                    {
                        If (LAnd (Local1, ^^^^ATKD.NABC))
                        {
                            Notify (ATKD, 0x7B)
                        }
                    }
                }
            }
        }

        Method (BL2C, 0, NotSerialized)
        {
            Store (Zero, Local1)
            Return (Local1)
            Return (Zero)
        }

        Method (BCFC, 0, NotSerialized)
        {
            Store (Zero, Local0)
            If (LAnd (LNot (GBTL ()), \ACPS ()))
            {
                If (LNot (CHGS (Zero)))
                {
                    Store (One, Local0)
                }
            }

            Return (Local0)
        }

        Method (CBCE, 0, NotSerialized)
        {
            Return (BL2C ())
        }
    }

    Scope (\)
    {
        Method (DIAG, 1, NotSerialized)
        {
            Store (Arg0, DBG8)
            SBYT (Zero, Arg0)
        }

        OperationRegion (GPSC, SystemIO, 0xB2, 0x02)
        Field (GPSC, ByteAcc, NoLock, Preserve)
        {
            SMCM,   8, 
            SMST,   8
        }

        Method (ISMI, 1, Serialized)
        {
            Store (Arg0, SMCM)
        }

        Method (ASMI, 1, Serialized)
        {
            Store (Arg0, ALPR)
            Store (0xA3, SMCM)
            Return (ALPR)
        }

        OperationRegion (ECMS, SystemIO, 0x72, 0x02)
        Field (ECMS, ByteAcc, Lock, Preserve)
        {
            EIND,   8, 
            EDAT,   8
        }

        IndexField (EIND, EDAT, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x38), 
            WOLF,   1, 
                    Offset (0x39), 
                    Offset (0x3A), 
            LCDT,   1, 
                    Offset (0x3B), 
                    Offset (0x40), 
            IKFG,   8, 
            FRPN,   16, 
            RAMB,   32, 
            AVOL,   8, 
            LBTN,   8, 
            ERRF,   8, 
            OCLK,   8, 
            WIDE,   1, 
            OVCK,   2, 
            SLPN,   3, 
            ACRD,   1, 
                    Offset (0x4C), 
            CPUR,   6, 
            CPUF,   2, 
            LBT2,   8, 
            PCMS,   8, 
            CLKS,   8, 
            CLKL,   8, 
            CLKD,   128, 
            ALSL,   8, 
            ALAE,   1, 
            ALDE,   1, 
            ALSP,   1, 
                    Offset (0x63), 
            WLDP,   1, 
            BTDP,   1, 
            WRST,   1, 
            BRST,   1, 
            F8ST,   1, 
            LSST,   1, 
                ,   1, 
            BATL,   1, 
            SYNA,   1, 
            ALPS,   1, 
            S4ST,   1, 
            WDMC,   1, 
                ,   5, 
            IKF2,   8, 
            UHDB,   8, 
            OSPM,   8, 
            TCGF,   8, 
            PPIS,   8, 
            PPIR,   8
        }

        OperationRegion (RAMW, SystemMemory, RAMB, 0x0100)
        Field (RAMW, AnyAcc, NoLock, Preserve)
        {
            TRTY,   8, 
            FSFN,   8, 
            FSTA,   16, 
            FADR,   32, 
            FSIZ,   16, 
            ACTD,   8, 
            AVLD,   8, 
            SETD,   8, 
            ACPF,   8, 
            DCPF,   8, 
            DCP2,   8, 
            DCTP,   8, 
            CTPY,   8, 
            PADL,   16, 
            CADL,   16, 
            CSTE,   16, 
            NSTE,   16, 
            SSTE,   16, 
            SFUN,   8, 
            TPSV,   8, 
            TAC0,   8, 
            TCRT,   8, 
            TDO1,   8, 
            TDO2,   8, 
            PPSV,   8, 
            PAC0,   8, 
            T0HL,   8, 
            T0LL,   8, 
            T0F1,   8, 
            T0F2,   8, 
            T1HL,   8, 
            T1LL,   8, 
            T1F1,   8, 
            T1F2,   8, 
            T2HL,   8, 
            T2LL,   8, 
            T2F1,   8, 
            T2F2,   8, 
            T3HL,   8, 
            T3LL,   8, 
            T3F1,   8, 
            T3F2,   8, 
            T4HL,   8, 
            T4LL,   8, 
            T4F1,   8, 
            T4F2,   8, 
            T5HL,   8, 
            T5LL,   8, 
            T5F1,   8, 
            T5F2,   8, 
            T6HL,   8, 
            T6LL,   8, 
            T6F1,   8, 
            T6F2,   8, 
            T7HL,   8, 
            T7LL,   8, 
            T7F1,   8, 
            T7F2,   8, 
            SLPT,   8, 
            AIBF,   8, 
            IDES,   8, 
            VGAF,   16, 
            C4CP,   8, 
            LUXS,   8, 
            LUXL,   8, 
            LUXH,   8, 
            LUXF,   8, 
            MNAM,   64, 
            DBR1,   32, 
            DBR2,   32, 
            DBR3,   32, 
            DBR4,   32, 
            LCDV,   32, 
            LCDR,   8, 
            PTIM,   8, 
            PTMP,   8, 
            SMIF,   8, 
            DTSE,   8, 
            DTS1,   8, 
            DTS2,   8, 
            MPEN,   8, 
            QFAN,   8, 
            VBIF,   8, 
            BIPA,   32, 
            RTCW,   16, 
            CPUN,   8, 
            ALPR,   32, 
            CIST,   8, 
            GNBF,   32, 
            CPUP,   8, 
            PSTN,   16
        }

        OperationRegion (DBGM, SystemMemory, 0x000D0000, 0x04)
        Field (DBGM, DWordAcc, NoLock, Preserve)
        {
            DBGG,   32
        }

        Name (OSFG, Zero)
        Name (OS9X, One)
        Name (OS98, 0x02)
        Name (OSME, 0x04)
        Name (OS2K, 0x08)
        Name (OSXP, 0x10)
        Name (OSVT, 0x20)
        Name (SLMT, Zero)
        Method (MSOS, 0, NotSerialized)
        {
            If (CondRefOf (_OSI, Local0))
            {
                If (_OSI ("Windows 2001"))
                {
                    Store (OSXP, OSFG)
                }

                If (_OSI ("Windows 2001 SP1"))
                {
                    Store (OSXP, OSFG)
                }

                If (_OSI ("Windows 2001 SP2"))
                {
                    Store (OSXP, OSFG)
                }

                If (_OSI ("Windows 2006"))
                {
                    Store (OSVT, OSFG)
                }

                Return (OSFG)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft Windows"))
                {
                    Store (OS98, OSFG)
                }
                Else
                {
                    If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                    {
                        Store (OSME, OSFG)
                    }
                    Else
                    {
                        If (MCTH (_OS, "Microsoft Windows NT"))
                        {
                            Store (OS2K, OSFG)
                        }
                        Else
                        {
                            Store (OSXP, OSFG)
                        }
                    }
                }
            }

            Return (OSFG)
        }

        Method (DBGR, 4, NotSerialized)
        {
            Store (Arg0, DBR1)
            Store (Arg1, DBR2)
            Store (Arg2, DBR3)
            Store (Arg3, DBR4)
            ISMI (0x96)
        }

        Name (ONAM, "TOSASU")
        Method (ADVG, 0, NotSerialized)
        {
            If (\_SB.PCI0.VGA.PRST ())
            {
                Return (\_SB.PCI0.VGA.ADVD ())
            }

            Return (0x03)
        }

        Method (SWHG, 1, Serialized)
        {
            If (\_SB.PCI0.VGA.PRST ())
            {
                \_SB.PCI0.VGA.SWHD (Arg0)
                Return (One)
            }

            Return (Zero)
        }

        Method (NATK, 0, NotSerialized)
        {
            If (\_SB.PCI0.VGA.PRST ())
            {
                Return (\_SB.PCI0.VGA.NATK ())
            }

            Return (One)
        }
    }

    Scope (_SB.PCI0)
    {
        Method (_INI, 0, NotSerialized)
        {
            Store (MSOS (), OSPM)
            If (ACPF)
            {
                ShiftRight (PSTN, 0x08, SLMT)
            }
            Else
            {
                And (PSTN, 0xFF, SLMT)
            }
        }
    }

    Scope (_SB.PCI0)
    {
        Device (AC0)
        {
            Name (_HID, "ACPI0003")
            Method (_PSR, 0, NotSerialized)
            {
                Return (^^SBRG.EC0.ACAP ())
            }

            Name (_PCL, Package (0x01)
            {
                PCI0
            })
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (ACAP, 0, Serialized)
        {
            Return (ACPF)
        }

        Method (_QA0, 0, NotSerialized)
        {
            If (ACPS ())
            {
                Store (One, ACPF)
                Store (0x58, Local0)
                ShiftRight (PSTN, 0x08, SLMT)
            }
            Else
            {
                Store (Zero, ACPF)
                Store (0x57, Local0)
                And (PSTN, 0xFF, SLMT)
            }

            If (LNotEqual (OSFG, OSVT))
            {
                STBR ()
            }

            Notify (AC0, 0x80)
            If (ATKP)
            {
                Notify (ATKD, Local0)
            }

            Sleep (0x64)
            If (CIST)
            {
                Notify (\_PR.CPU1, 0x80)
                If (LGreaterEqual (CPUN, 0x02))
                {
                    Notify (\_PR.CPU2, 0x80)
                }
            }

            Sleep (0x64)
            Notify (\_PR.CPU1, 0x81)
            If (LGreaterEqual (CPUN, 0x02))
            {
                Store (0x21, DBG8)
                Notify (\_PR.CPU2, 0x81)
            }

            Sleep (0x0A)
            NBAT (0x80)
        }
    }

    Scope (_SB.PCI0)
    {
        Device (BAT0)
        {
            Name (_HID, EisaId ("PNP0C0A"))
            Name (_UID, Zero)
            Name (_PCL, Package (0x01)
            {
                PCI0
            })
            Method (_STA, 0, NotSerialized)
            {
                If (^^SBRG.EC0.BATP (Zero))
                {
                    Return (0x1F)
                }
                Else
                {
                    Return (0x0F)
                }
            }

            Name (LOW2, 0x012C)
            Name (DVOT, 0x0E)
            Name (PUNT, One)
            Name (LFCC, 0x1770)
            Name (NBIF, Package (0x0D)
            {
                Zero, 
                Ones, 
                Ones, 
                One, 
                Ones, 
                Ones, 
                Ones, 
                Ones, 
                Ones, 
                "", 
                "", 
                "", 
                ""
            })
            Name (PBIF, Package (0x0D)
            {
                One, 
                0x1770, 
                0x1770, 
                One, 
                0x39D0, 
                0x0258, 
                0x012C, 
                0x3C, 
                0x3C, 
                "M3N", 
                " ", 
                "LIon", 
                "ASUSTek"
            })
            Name (PBST, Package (0x04)
            {
                Zero, 
                Ones, 
                Ones, 
                Ones
            })
            Method (FBIF, 5, NotSerialized)
            {
                Store (Arg0, PUNT)
                Store (Arg1, Local1)
                Store (Arg2, Local2)
                If (LEqual (PUNT, Zero))
                {
                    Multiply (Local1, 0x0A, Local1)
                    Multiply (Local2, 0x0A, Local2)
                }

                Store (Arg0, Index (PBIF, Zero))
                Store (Local1, Index (PBIF, One))
                Store (Local2, Index (PBIF, 0x02))
                Store (Local2, LFCC)
                Store (Arg3, Index (PBIF, 0x03))
                Store (Arg4, Index (PBIF, 0x04))
                Divide (Local1, 0x0A, Local3, Local5)
                Store (Local5, Index (PBIF, 0x05))
                ShiftRight (Local5, One, Local6)
                Store (Local6, Index (PBIF, 0x06))
                Store (Local6, LOW2)
                Divide (Local1, 0x64, Local3, Local7)
                Store (Local7, Index (PBIF, 0x07))
                Store (Local7, Index (PBIF, 0x08))
            }

            Method (CBIF, 0, NotSerialized)
            {
                If (PUNT)
                {
                    Store (DerefOf (Index (PBIF, 0x04)), Local0)
                    Add (Local0, 0x01F4, Local0)
                    Divide (Local0, 0x03E8, Local1, DVOT)
                    Store (Zero, Index (PBIF, Zero))
                    Multiply (DerefOf (Index (PBIF, One)), DVOT, Index (PBIF, One
                        ))
                    Multiply (DerefOf (Index (PBIF, 0x02)), DVOT, Index (PBIF, 0x02
                        ))
                    Multiply (DerefOf (Index (PBIF, 0x05)), DVOT, Index (PBIF, 0x05
                        ))
                    Multiply (DerefOf (Index (PBIF, 0x06)), DVOT, Index (PBIF, 0x06
                        ))
                    Multiply (DerefOf (Index (PBIF, 0x07)), DVOT, Index (PBIF, 0x07
                        ))
                    Multiply (DerefOf (Index (PBIF, 0x08)), DVOT, Index (PBIF, 0x08
                        ))
                }
            }

            Method (_BIF, 0, NotSerialized)
            {
                If (LNot (^^SBRG.EC0.BATP (Zero)))
                {
                    Return (NBIF)
                }

                If (LEqual (^^SBRG.EC0.GBTT (Zero), 0xFF))
                {
                    Return (NBIF)
                }

                BATS (Zero)
                Store (^^SBRG.EC0.BIF9 (), Index (PBIF, 0x09))
                Store (ONAM, Index (PBIF, 0x0C))
                Store (^^SBRG.EC0.BIF0 (), Local0)
                Store (^^SBRG.EC0.BIF1 (), Local1)
                Store (^^SBRG.EC0.BIF2 (), Local2)
                Store (^^SBRG.EC0.BIF3 (), Local3)
                Store (^^SBRG.EC0.BIF4 (), Local4)
                BATR ()
                If (LNotEqual (Local0, Ones))
                {
                    If (LNotEqual (Local1, Ones))
                    {
                        If (LNotEqual (Local2, Ones))
                        {
                            If (LNotEqual (Local3, Ones))
                            {
                                If (LNotEqual (Local4, Ones))
                                {
                                    FBIF (Local0, Local1, Local2, Local3, Local4)
                                    CBIF ()
                                }
                            }
                        }
                    }
                }

                If (LEqual (PUNT, Zero))
                {
                    Multiply (Local2, 0x0A, Local2)
                }

                Store (Local2, LFCC)
                Return (PBIF)
            }

            Method (FBST, 4, NotSerialized)
            {
                And (Arg1, 0xFFFF, Local1)
                Store (Zero, Local0)
                If (^^SBRG.EC0.ACAP ())
                {
                    Store (One, Local0)
                }

                If (Local0)
                {
                    If (CHGS (Zero))
                    {
                        Store (0x02, Local0)
                    }
                    Else
                    {
                        Store (Zero, Local0)
                    }
                }
                Else
                {
                    Store (One, Local0)
                }

                And (Arg0, 0x0300, Local2)
                If (Local2)
                {
                    ShiftLeft (One, 0x02, Local2)
                    Or (Local0, Local2, Local0)
                }

                If (LGreaterEqual (Local1, 0x8000))
                {
                    Subtract (0xFFFF, Local1, Local1)
                }

                Store (Arg2, Local2)
                If (LEqual (PUNT, Zero))
                {
                    Multiply (Local1, DVOT, Local1)
                    Multiply (Local2, 0x0A, Local2)
                }

                And (Local0, 0x02, Local3)
                If (LNot (Local3))
                {
                    Subtract (LFCC, Local2, Local3)
                    Divide (LFCC, 0xC8, Local4, Local5)
                    If (LLess (Local3, Local5))
                    {
                        Store (LFCC, Local2)
                    }
                }
                Else
                {
                    Divide (LFCC, 0xC8, Local4, Local5)
                    Subtract (LFCC, Local5, Local4)
                    If (LGreater (Local2, Local4))
                    {
                        Store (Local4, Local2)
                    }
                }

                If (LNot (^^SBRG.EC0.ACAP ()))
                {
                    Divide (Local2, MBLF, Local3, Local4)
                    If (LLess (Local1, Local4))
                    {
                        Store (Local4, Local1)
                    }
                }

                Store (Local0, Index (PBST, Zero))
                Store (Local1, Index (PBST, One))
                Store (Local2, Index (PBST, 0x02))
                Store (Arg3, Index (PBST, 0x03))
            }

            Method (CBST, 0, NotSerialized)
            {
                If (PUNT)
                {
                    Multiply (DerefOf (Index (PBST, One)), DVOT, Index (PBST, One
                        ))
                    Multiply (DerefOf (Index (PBST, 0x02)), DVOT, Index (PBST, 0x02
                        ))
                }
            }

            Method (_BST, 0, NotSerialized)
            {
                If (LNot (^^SBRG.EC0.BATP (Zero)))
                {
                    Store (Zero, Index (PBST, Zero))
                    Store (Ones, Index (PBST, One))
                    Store (Ones, Index (PBST, 0x02))
                    Store (Ones, Index (PBST, 0x03))
                    Return (PBST)
                }

                If (LEqual (^^SBRG.EC0.GBTT (Zero), 0xFF))
                {
                    Store (Zero, Index (PBST, Zero))
                    Store (Ones, Index (PBST, One))
                    Store (Ones, Index (PBST, 0x02))
                    Store (Ones, Index (PBST, 0x03))
                    Return (PBST)
                }

                If (MES4)
                {
                    Decrement (MES4)
                    Return (PBST)
                }

                BATS (Zero)
                Store (^^SBRG.EC0.BSTS (), Local0)
                Store (^^SBRG.EC0.BCRT (), Local1)
                Store (^^SBRG.EC0.BRCP (), Local2)
                Store (^^SBRG.EC0.BVOT (), Local3)
                BATR ()
                If (LNotEqual (Local0, Ones))
                {
                    If (LNotEqual (Local1, Ones))
                    {
                        If (LNotEqual (Local2, Ones))
                        {
                            If (LNotEqual (Local3, Ones))
                            {
                                FBST (Local0, Local1, Local2, Local3)
                                CBST ()
                            }
                        }
                    }
                }

                Return (PBST)
            }
        }
    }

    Scope (_SB.PCI0)
    {
        Name (B0CR, Zero)
        Name (B1CR, Zero)
        Method (GGCC, 1, Serialized)
        {
            BATS (Arg0)
            Store (^SBRG.EC0.BCRT (), Local0)
            BATR ()
            If (LEqual (Local0, Ones))
            {
                If (Arg0)
                {
                    Store (B1CR, Local0)
                }
                Else
                {
                    Store (B0CR, Local0)
                }
            }

            And (Local0, 0x8000, Local1)
            If (Local1)
            {
                Store (Zero, Local0)
            }

            If (Arg0)
            {
                Store (Local0, B1CR)
            }
            Else
            {
                Store (Local0, B0CR)
            }

            Return (Local0)
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Name (BADR, 0x0B)
        Name (CADR, 0x09)
        Name (SADR, 0x0A)
        Method (ALMH, 1, NotSerialized)
        {
            If (LEqual (Arg0, BADR))
            {
                NBAT (0x80)
            }
        }

        Method (BIFW, 1, NotSerialized)
        {
            Store (SMBR (RDWD, BADR, Arg0), Local0)
            Store (DerefOf (Index (Local0, Zero)), Local1)
            If (Local1)
            {
                Return (Ones)
            }
            Else
            {
                Return (DerefOf (Index (Local0, 0x02)))
            }
        }

        Method (BIF0, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1MD, Local0)
                }
                Else
                {
                    Store (B0MD, Local0)
                }

                If (LNotEqual (Local0, 0xFFFF))
                {
                    ShiftRight (Local0, 0x0F, Local1)
                    And (Local1, One, Local1)
                    XOr (Local1, One, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BIF1, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1DC, Local0)
                }
                Else
                {
                    Store (B0DC, Local0)
                }

                And (Local0, 0xFFFF, Local0)
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BIF2, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1FC, Local0)
                }
                Else
                {
                    Store (B0FC, Local0)
                }

                And (Local0, 0xFFFF, Local0)
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BIF3, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1MD, Local0)
                }
                Else
                {
                    Store (B0MD, Local0)
                }

                If (LNotEqual (Local0, 0xFFFF))
                {
                    ShiftRight (Local0, 0x09, Local0)
                    And (Local0, One, Local0)
                    XOr (Local0, One, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BIF4, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1DV, Local0)
                }
                Else
                {
                    Store (B0DV, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BIF9, 0, NotSerialized)
        {
            Name (BSTR, Buffer (0x20) {})
            Store (SMBR (RDBL, BADR, 0x21), Local0)
            If (LNotEqual (DerefOf (Index (Local0, Zero)), Zero))
            {
                Store (MNAM, BSTR)
                Store (Zero, Index (BSTR, 0x04))
            }
            Else
            {
                Store (DerefOf (Index (Local0, 0x02)), BSTR)
                Store (Zero, Index (BSTR, DerefOf (Index (Local0, One))))
            }

            Return (BSTR)
        }

        Method (BIFA, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1SN, Local0)
                }
                Else
                {
                    Store (B0SN, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BSTS, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1ST, Local0)
                }
                Else
                {
                    Store (B0ST, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BCRT, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1CC, Local0)
                }
                Else
                {
                    Store (B0CC, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BRCP, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1RC, Local0)
                }
                Else
                {
                    Store (B0RC, Local0)
                }

                If (LEqual (Local0, 0xFFFF))
                {
                    Store (Ones, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (BVOT, 0, NotSerialized)
        {
            If (ECAV ())
            {
                If (BSLF)
                {
                    Store (B1VL, Local0)
                }
                Else
                {
                    Store (B0VL, Local0)
                }
            }
            Else
            {
                Store (Ones, Local0)
            }

            Return (Local0)
        }

        Method (RSTB, 1, NotSerialized)
        {
            BATS (Arg0)
            SMBW (WRWD, BADR, 0x4F, 0x02, 0xFF5A)
            SMBW (WRWD, BADR, 0x7D, 0x02, Zero)
            SMBW (WRWD, BADR, 0x7D, 0x02, 0x80)
            BATR ()
        }

        Method (CBYN, 1, NotSerialized)
        {
            Store (Zero, Local1)
            If (BATP (Arg0))
            {
                BATS (Arg0)
                Store (BIFW (0x0C), Local0)
                BATR ()
                If (LGreaterEqual (Local0, 0x11))
                {
                    Or (Local1, One, Local1)
                }
            }

            Return (Local1)
        }
    }

    Scope (\)
    {
        Method (CHGS, 1, Serialized)
        {
            Store (\_SB.PCI0.SBRG.EC0.BCHG (Arg0), Local0)
            Return (Local0)
        }

        Name (BSLF, Zero)
        Method (BATS, 1, Serialized)
        {
            If (Arg0)
            {
                Store (One, BSLF)
            }
            Else
            {
                Store (Zero, BSLF)
            }
        }

        Method (BATR, 0, Serialized)
        {
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (_QA1, 0, NotSerialized)
        {
            Store (DCPS (Zero), DCPF)
            If (DCPF)
            {
                Sleep (0x07D0)
            }

            Notify (BAT0, 0x80)
            Notify (BAT0, 0x81)
        }

        Method (_QA5, 0, NotSerialized)
        {
            ISMI (0xB1)
            If (ATKP)
            {
                Notify (ATKD, 0x6E)
            }
            Else
            {
                If (BATP (Zero))
                {
                    Notify (BAT0, 0x80)
                }
            }
        }

        Method (_QA3, 0, NotSerialized)
        {
            If (BATL)
            {
                Store (EB0S, Local0)
                And (Local0, 0x0C, Local1)
                If (Local1)
                {
                    And (Local0, 0x02, Local1)
                    If (LEqual (Local1, Zero))
                    {
                        B681 (0x18, 0x05, 0x80)
                    }
                    Else
                    {
                        B681 (0x18, 0x05, Zero)
                    }
                }
                Else
                {
                    B681 (0x18, 0x05, Zero)
                }
            }
            Else
            {
                B681 (0x18, 0x05, Zero)
            }

            If (BATP (Zero))
            {
                Store (BCLE (Zero), Local0)
                If (LEqual (Local0, Zero))
                {
                    Notify (BAT0, 0x81)
                }
                Else
                {
                    Notify (BAT0, 0x81)
                    Notify (AC0, 0x80)
                }
            }
        }

        Method (BATP, 1, Serialized)
        {
            If (Arg0)
            {
                Return (DCP2)
            }
            Else
            {
                Return (DCPF)
            }
        }

        Method (NBAT, 1, NotSerialized)
        {
            If (BATP (Zero))
            {
                Notify (BAT0, Arg0)
            }
        }
    }

    Scope (_SB)
    {
        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
        }
    }

    Scope (_SB)
    {
        Device (SLPB)
        {
            Name (_HID, EisaId ("PNP0C0E"))
            Method (_PRW, 0, NotSerialized)
            {
                Return (Package (0x02)
                {
                    0x0B, 
                    0x04
                })
            }
        }
    }

    Scope (\)
    {
        Name (MES4, Zero)
        Method (OEMS, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x03))
            {
                If (LLessEqual (OSFG, OSME))
                {
                    Store (One, WIDE)
                }
                Else
                {
                    Store (Zero, WIDE)
                }
            }

            SBRS (Arg0)
            \_SB.PCI0.SBRG.EC0.EC0S (Arg0)
            Store (Arg0, SLPN)
            DIAG (Add (Arg0, 0xD0))
            Store (Arg0, SLPT)
            If (Arg0)
            {
                STRP (One)
            }

            PRJS (Arg0)
            ISMI (0x9D)
        }

        Method (OEMW, 1, NotSerialized)
        {
            ISMI (0x9E)
            Store (Zero, SLPT)
            If (LLessEqual (Arg0, 0x04))
            {
                If (CIST)
                {
                    Notify (\_PR.CPU1, 0x80)
                    If (LGreaterEqual (CPUN, 0x02))
                    {
                        Notify (\_PR.CPU2, 0x80)
                    }
                }

                Sleep (0x64)
                Notify (\_PR.CPU1, 0x81)
                If (LGreaterEqual (CPUN, 0x02))
                {
                    Notify (\_PR.CPU2, 0x81)
                }
            }

            \_SB.PCI0.SBRG.EC0.EC0W (Arg0)
            If (LEqual (Arg0, 0x04))
            {
                If (LLessEqual (OSFG, OSME))
                {
                    Store (0x02, MES4)
                }
                Else
                {
                    Store (Zero, MES4)
                }
            }

            \_SB.PCI0.P0P6.CBS0.CBSW (Arg0)
            SBRW (Arg0)
            If (LEqual (Arg0, 0x04))
            {
                Notify (\_SB.SLPB, 0x02)
            }

            PRJW (Arg0)
            DIAG (Add (Arg0, 0xF0))
        }
    }

    Scope (_SB.ATKD)
    {
        Method (FSMI, 1, NotSerialized)
        {
            Store (Arg0, FSFN)
            Or (Arg0, 0xA0, Local0)
            DIAG (Local0)
            ISMI (0x90)
            Return (FSTA)
        }

        Method (FLSH, 1, NotSerialized)
        {
            Store (Arg0, FSTA)
            FSMI (Zero)
        }

        Method (FINI, 1, NotSerialized)
        {
            Store (Arg0, FADR)
            Return (FSMI (One))
        }

        Method (FERS, 1, NotSerialized)
        {
            Store (Arg0, FSTA)
            Return (FSMI (0x02))
        }

        Method (FWRI, 1, NotSerialized)
        {
            Store (Arg0, FADR)
            Store (0x1000, FSIZ)
            Return (Subtract (0x1000, FSMI (0x03)))
        }

        Method (FWRP, 0, NotSerialized)
        {
            Store (Zero, FSIZ)
            Return (Subtract (0x1000, FSMI (0x03)))
        }

        Method (FEBW, 1, NotSerialized)
        {
            Store (Arg0, FADR)
            Return (FSMI (0x04))
        }

        Method (FEBR, 1, NotSerialized)
        {
            Store (Arg0, FADR)
            Return (FSMI (0x05))
        }

        Method (FEDW, 0, NotSerialized)
        {
            Return (FSMI (0x06))
        }

        Method (ECSR, 1, NotSerialized)
        {
            Store (Arg0, FSTA)
            Return (FSMI (0x07))
        }
    }

    Scope (_SB.ATKD)
    {
        Method (AGFN, 1, Serialized)
        {
            If (LEqual (Arg0, Zero))
            {
                Return (GNBF)
            }

            Store (Zero, Local0)
            OperationRegion (\PARM, SystemMemory, Arg0, 0x08)
            Field (PARM, DWordAcc, NoLock, Preserve)
            {
                MFUN,   16, 
                SFUN,   16, 
                LEN,    16, 
                STAS,   8, 
                EROR,   8
            }

            Store (Zero, EROR)
            Store (One, STAS)
            If (LEqual (MFUN, 0x20))
            {
                BSMI (Arg0)
                And (STAS, 0xFE, STAS)
            }

            If (LEqual (MFUN, 0x02))
            {
                BSMI (Arg0)
                And (STAS, 0xFE, STAS)
            }

            And (MFUN, 0xF0, Local0)
            If (LEqual (Local0, 0x10))
            {
                MF1X (Arg0, LEN, MFUN, SFUN)
            }

            If (LEqual (MFUN, One))
            {
                GVER (Arg0, LEN)
                And (STAS, 0xFE, STAS)
            }

            If (LEqual (MFUN, 0x30))
            {
                MF30 (Arg0, SFUN, LEN)
                And (STAS, 0xFE, STAS)
            }

            AGLN (Arg0, MFUN, SFUN, LEN)
            If (LEqual (STAS, One))
            {
                Store (One, EROR)
                Or (STAS, 0x02, STAS)
            }

            And (STAS, 0xFE, STAS)
            Or (STAS, 0x80, STAS)
            Return (Zero)
        }

        Method (GVER, 2, NotSerialized)
        {
            OperationRegion (\FGVR, SystemMemory, Arg0, Arg1)
            Field (FGVR, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                APID,   16, 
                APRV,   32
            }

            Return (Zero)
        }

        Method (MF30, 3, NotSerialized)
        {
            OperationRegion (FM30, SystemMemory, Arg0, 0x08)
            Field (FM30, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x06), 
                SM30,   8, 
                EM30,   8
            }

            Store (One, Local0)
            If (LEqual (Arg1, Zero))
            {
                Store (G30V (Arg0, Arg2), Local0)
            }

            If (LEqual (Arg1, One))
            {
                Store (EC01 (Arg0, Arg2), Local0)
            }

            If (Local0)
            {
                Store (Local0, EM30)
                Or (SM30, 0x02, SM30)
            }

            Or (SM30, 0x80, SM30)
            Return (Zero)
        }

        Method (G30V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F300, SystemMemory, Arg0, Arg1)
            Field (F300, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (EC01, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x10))
            {
                Return (0x02)
            }

            OperationRegion (FEC1, SystemMemory, Arg0, Arg1)
            Field (FEC1, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                ECMD,   8, 
                EDA1,   8, 
                EDA2,   8, 
                EDA3,   8, 
                EDA4,   8, 
                EDA5,   8
            }

            Store (^^PCI0.SBRG.EC0.ECXT (ECMD, EDA1, EDA2, EDA3, EDA4, EDA5), Local0)
            Store (DerefOf (Index (Local0, One)), EDA1)
            Store (DerefOf (Index (Local0, 0x02)), EDA2)
            Store (DerefOf (Index (Local0, 0x03)), EDA3)
            Store (DerefOf (Index (Local0, 0x04)), EDA4)
            Store (DerefOf (Index (Local0, 0x05)), EDA5)
            Return (DerefOf (Index (Local0, Zero)))
        }

        Method (GENW, 1, NotSerialized)
        {
            Store (Zero, RTCW)
        }
    }

    Method (BSMI, 1, Serialized)
    {
        Store (Arg0, BIPA)
        ISMI (0xA1)
    }

    Scope (_SB.ATKD)
    {
        Method (MF1X, 4, NotSerialized)
        {
            OperationRegion (FM1X, SystemMemory, Arg0, 0x08)
            Field (FM1X, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x06), 
                SM1X,   8, 
                EM1X,   8
            }

            Store (One, Local0)
            If (LEqual (Arg2, 0x10))
            {
                Store (MF10 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x11))
            {
                Store (MF11 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x12))
            {
                Store (MF12 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x13))
            {
                Store (MF13 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x14))
            {
                Store (MF14 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x15))
            {
                Store (MF15 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x16))
            {
                Store (MF16 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x17))
            {
                Store (MF17 (Arg0, Arg1, Arg3), Local0)
            }

            If (LEqual (Arg2, 0x18))
            {
                Store (MF18 (Arg0, Arg1, Arg3), Local0)
            }

            And (SM1X, 0xFE, SM1X)
            If (Local0)
            {
                Store (Local0, EM1X)
                Or (SM1X, 0x02, SM1X)
            }

            Or (SM1X, 0x80, SM1X)
        }

        Method (MF10, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G10V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (SRTC (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G10V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F100, SystemMemory, Arg0, Arg1)
            Field (F100, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (SRTC, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F101, SystemMemory, Arg0, Arg1)
            Field (F101, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                DLTM,   16
            }

            Store (DLTM, RTCW)
            Return (Zero)
        }

        Method (MF11, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G11V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GBAT (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (ASBR (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x03))
            {
                Store (ASBE (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x04))
            {
                Store (BTCR (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G11V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F110, SystemMemory, Arg0, Arg1)
            Field (F100, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GBAT, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F111, SystemMemory, Arg0, Arg1)
            Field (F111, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                BTNM,   8, 
                BTTP,   8
            }

            Store (One, BTNM)
            Store (Zero, BTTP)
            Return (Zero)
        }

        Method (ASBR, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x30))
            {
                Return (0x02)
            }

            OperationRegion (\F112, SystemMemory, Arg0, Arg1)
            Field (F112, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                BATN,   8, 
                BATA,   8, 
                REGS,   8, 
                BDAT,   16, 
                BLEN,   8, 
                BREV,   16, 
                BLK1,   32, 
                BLK2,   32, 
                BLK3,   32, 
                BLK4,   32, 
                BLK5,   32, 
                BLK6,   32, 
                BLK7,   32, 
                BLK8,   32
            }

            If (LGreaterEqual (BATN, One))
            {
                Return (0x11)
            }

            If (LEqual (BATA, Zero))
            {
                Store (^^PCI0.SBRG.EC0.SMBR (^^PCI0.SBRG.EC0.RDWD, ^^PCI0.SBRG.EC0.BADR, REGS), Local0)
                Store (DerefOf (Index (Local0, 0x02)), BDAT)
                Store (DerefOf (Index (Local0, Zero)), Local2)
                And (Local2, 0x1F, Local2)
                If (Local2)
                {
                    Add (Local2, 0x10, Local2)
                }

                Return (Local2)
            }

            If (LEqual (BATA, One))
            {
                Store (^^PCI0.SBRG.EC0.SMBW (^^PCI0.SBRG.EC0.WRWD, ^^PCI0.SBRG.EC0.BADR, REGS, 0x02, BDAT), Local0)
                Store (DerefOf (Index (Local0, Zero)), Local2)
                And (Local2, 0x1F, Local2)
                If (Local2)
                {
                    Add (Local2, 0x10, Local2)
                }

                Return (Local2)
            }

            If (LEqual (BATA, 0x02))
            {
                Store (^^PCI0.SBRG.EC0.SMBR (^^PCI0.SBRG.EC0.RDBL, ^^PCI0.SBRG.EC0.BADR, REGS), Local0)
                Name (BKUF, Buffer (0x20) {})
                CreateDWordField (BKUF, Zero, DAT1)
                CreateDWordField (BKUF, 0x04, DAT2)
                CreateDWordField (BKUF, 0x08, DAT3)
                CreateDWordField (BKUF, 0x0C, DAT4)
                CreateDWordField (BKUF, 0x10, DAT5)
                CreateDWordField (BKUF, 0x14, DAT6)
                CreateDWordField (BKUF, 0x18, DAT7)
                CreateDWordField (BKUF, 0x1C, DAT8)
                Store (DerefOf (Index (Local0, 0x02)), BKUF)
                Store (DAT1, BLK1)
                Store (DAT2, BLK2)
                Store (DAT3, BLK3)
                Store (DAT4, BLK4)
                Store (DAT5, BLK5)
                Store (DAT6, BLK6)
                Store (DAT7, BLK7)
                Store (DAT8, BLK8)
                Store (DerefOf (Index (Local0, One)), BLEN)
                Store (DerefOf (Index (Local0, Zero)), Local2)
                And (Local2, 0x1F, Local2)
                If (Local2)
                {
                    Add (Local2, 0x10, Local2)
                }

                Return (Local2)
            }

            Return (0x10)
        }

        Method (ASBE, 2, Serialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F113, SystemMemory, Arg0, Arg1)
            Field (F113, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                BATN,   8, 
                BATA,   8, 
                REGS,   8, 
                BDAT,   8
            }

            If (LGreater (BATN, One))
            {
                Return (0x11)
            }

            If (LEqual (BATA, Zero))
            {
                Store (^^PCI0.SBRG.EC0.RBEP (REGS), Local2)
                And (Local2, 0xFF, Local3)
                Store (Local3, BDAT)
                ShiftRight (Local2, 0x08, Local2)
                And (Local2, 0x1F, Local2)
                If (Local2)
                {
                    Add (Local2, 0x10, Local2)
                }

                Return (Local2)
            }

            If (LEqual (BATA, One))
            {
                Store (^^PCI0.SBRG.EC0.WBEP (REGS, BDAT), Local2)
                And (Local2, 0x1F, Local2)
                If (Local2)
                {
                    Add (Local2, 0x10, Local2)
                }

                Return (Local2)
            }

            Return (0x10)
        }

        Method (BTCR, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x09))
            {
                Return (0x02)
            }

            OperationRegion (\F114, SystemMemory, Arg0, Arg1)
            Field (F114, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                BCDC,   8
            }

            SBTL (BCDC)
            Return (Zero)
        }

        Method (MF12, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G12V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GLDI (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (LDCR (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G12V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F120, SystemMemory, Arg0, Arg1)
            Field (F120, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GLDI, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x10))
            {
                Return (0x02)
            }

            OperationRegion (\F121, SystemMemory, Arg0, Arg1)
            Field (F121, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                LDI0,   32, 
                LDI1,   32
            }

            Store (Zero, Local0)
            Or (Local0, 0x10, Local0)
            Or (Local0, 0x20, Local0)
            Store (Local0, LDI0)
            Return (Zero)
        }

        Method (LDCR, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F122, SystemMemory, Arg0, Arg1)
            Field (F122, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                LDNM,   8, 
                LCRT,   8
            }

            If (LEqual (LDNM, 0x04))
            {
                WLED (LCRT)
                Return (Zero)
            }

            If (LEqual (LDNM, 0x05))
            {
                BLED (LCRT)
                Return (Zero)
            }

            Return (0x10)
        }

        Method (MF13, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G13V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GTSI (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (GTSV (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x03))
            {
                Store (GVSN (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x04))
            {
                Store (GVSV (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x05))
            {
                Store (GFNN (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x06))
            {
                Store (GFNS (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x07))
            {
                Store (SFNS (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G13V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F130, SystemMemory, Arg0, Arg1)
            Field (F130, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GTSI, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F131, SystemMemory, Arg0, Arg1)
            Field (F131, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                THRI,   32
            }

            Store (0x0301, THRI)
            Return (Zero)
        }

        Method (GTSV, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F132, SystemMemory, Arg0, Arg1)
            Field (F132, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                TSNM,   8, 
                TSVL,   8, 
                TSST,   8
            }

            Store (Zero, TSST)
            If (LEqual (TSNM, Zero))
            {
                Store (\_TZ.RTMP (), TSVL)
                Return (Zero)
            }

            If (LEqual (TSNM, 0x08))
            {
                BSMI (Arg0)
                Return (Zero)
            }

            If (LEqual (TSNM, 0x09))
            {
                BSMI (Arg0)
                Return (Zero)
            }

            Return (0x10)
        }

        Method (GVSN, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x09))
            {
                Return (0x02)
            }

            OperationRegion (\F133, SystemMemory, Arg0, Arg1)
            Field (F133, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                NMVS,   8
            }

            Store (Zero, NMVS)
            Return (Zero)
        }

        Method (GVSV, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0B))
            {
                Return (0x02)
            }

            OperationRegion (\F134, SystemMemory, Arg0, Arg1)
            Field (F134, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                VSNM,   8, 
                VSVL,   16
            }

            If (LGreater (VSNM, Zero))
            {
                Return (0x10)
            }

            Return (Zero)
        }

        Method (GFNN, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x09))
            {
                Return (0x02)
            }

            OperationRegion (\F135, SystemMemory, Arg0, Arg1)
            Field (F135, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                NMFN,   32
            }

            Store (One, NMFN)
            Return (Zero)
        }

        Method (GFNS, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0D))
            {
                Return (0x02)
            }

            OperationRegion (\F136, SystemMemory, Arg0, Arg1)
            Field (F136, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                FNNM,   8, 
                GFNS,   32
            }

            If (Or (LEqual (FNNM, Zero), LGreater (FNNM, One)))
            {
                Return (0x10)
            }

            Store (FNNM, Local0)
            Store (\_TZ.RFAN (Decrement (Local0)), GFNS)
            Return (Zero)
        }

        Method (SFNS, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F137, SystemMemory, Arg0, Arg1)
            Field (F137, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                FNNB,   8, 
                FNSP,   8
            }

            If (LGreater (FNNB, One))
            {
                Return (0x10)
            }

            ^^PCI0.SBRG.EC0.SFNV (FNNB, FNSP)
            Return (Zero)
        }

        Method (MF14, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G14V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GNBT (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (GBTS (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G14V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F140, SystemMemory, Arg0, Arg1)
            Field (F140, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GNBT, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x09))
            {
                Return (0x02)
            }

            OperationRegion (\F141, SystemMemory, Arg0, Arg1)
            Field (F141, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                NBBT,   8
            }

            Store (0x05, NBBT)
            Return (Zero)
        }

        Method (GBTS, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F142, SystemMemory, Arg0, Arg1)
            Field (F142, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                BTNM,   8, 
                BTST,   8
            }

            Name (BTTB, Package (0x05)
            {
                Package (0x03)
                {
                    0x0C, 
                    Zero, 
                    Zero
                }, 

                Package (0x03)
                {
                    0x0D, 
                    Zero, 
                    Zero
                }, 

                Package (0x03)
                {
                    0x0E, 
                    Zero, 
                    Zero
                }, 

                Package (0x03)
                {
                    0x0F, 
                    Zero, 
                    Zero
                }, 

                Package (0x03)
                {
                    0x15, 
                    Zero, 
                    Zero
                }
            })
            If (LGreater (BTNM, 0x05))
            {
                Return (0x10)
            }

            Store (BTNM, Local0)
            Decrement (Local0)
            Store (DerefOf (Index (BTTB, Local0)), Local1)
            If (LEqual (DerefOf (Index (Local1, One)), Zero))
            {
                Store (^^PCI0.SBRG.EC0.RPIN (DerefOf (Index (Local1, Zero))), Local2)
            }

            If (LEqual (DerefOf (Index (Local1, One)), One))
            {
                Store (RGPL (DerefOf (Index (Local1, Zero)), One), Local2)
            }

            If (LEqual (DerefOf (Index (Local1, One)), 0x03)) {}
            If (LEqual (DerefOf (Index (Local1, 0x02)), Local2))
            {
                Store (Zero, BTST)
            }
            Else
            {
                Store (One, BTST)
            }

            Return (Zero)
        }

        Method (MF15, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G15V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GLDB (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (SLDB (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x03))
            {
                Store (GDPI (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x04))
            {
                Store (SODP (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G15V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F150, SystemMemory, Arg0, Arg1)
            Field (F150, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GLDB, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F151, SystemMemory, Arg0, Arg1)
            Field (F151, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                LCDB,   8, 
                MLDB,   8
            }

            Store (GPLV (), LCDB)
            Store (0x0F, MLDB)
            Return (Zero)
        }

        Method (SLDB, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F152, SystemMemory, Arg0, Arg1)
            Field (F152, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                LCDL,   8, 
                LTPE,   8
            }

            If (LEqual (LTPE, Zero))
            {
                If (LGreater (LCDL, 0x0F))
                {
                    Return (0x10)
                }

                SPLV (LCDL)
                Return (Zero)
            }

            If (LEqual (LTPE, One))
            {
                ^^PCI0.SBRG.EC0.SBRV (LCDL)
                Return (Zero)
            }

            Return (0x11)
        }

        Method (GDPI, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x10))
            {
                Return (0x02)
            }

            OperationRegion (\F153, SystemMemory, Arg0, Arg1)
            Field (F153, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                ODPI,   32, 
                ODPC,   8
            }

            Store (0x07, ODPI)
            BSMI (Arg0)
            Return (Zero)
        }

        Method (SODP, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F154, SystemMemory, Arg0, Arg1)
            Field (F154, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                ODPM,   32
            }

            And (ODPM, 0x07, Local0)
            If (LEqual (Local0, ODPM))
            {
                SDSP (ODPM)
                Return (Zero)
            }

            Return (0x10)
        }

        Method (MF16, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G16V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (SFBD (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (LCMD (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G16V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F160, SystemMemory, Arg0, Arg1)
            Field (F160, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (SFBD, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F161, SystemMemory, Arg0, Arg1)
            Field (F161, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                NXBD,   8
            }

            If (OFBD (NXBD))
            {
                Store (NXBD, UHDB)
                Return (Zero)
            }
            Else
            {
                Return (0x10)
            }
        }

        Method (LCMD, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            BSMI (Arg0)
            Store (0xAA55, FRPN)
            Return (Zero)
        }

        Method (MF17, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G17V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GMDL (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (GBSI (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x03))
            {
                Store (GECI (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G17V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F170, SystemMemory, Arg0, Arg1)
            Field (F170, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GMDL, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x19))
            {
                Return (0x02)
            }

            OperationRegion (\F171, SystemMemory, Arg0, Arg1)
            Field (F171, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                MLEN,   8, 
                MDL1,   32, 
                MDL2,   32, 
                MDL3,   32, 
                MDL4,   32
            }

            Store (Zero, MDL1)
            Store (Zero, MDL2)
            Store (Zero, MDL3)
            Store (Zero, MDL4)
            BSMI (Arg0)
            Return (Zero)
        }

        Method (GBSI, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x19))
            {
                Return (0x02)
            }

            OperationRegion (\F172, SystemMemory, Arg0, Arg1)
            Field (F172, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                BLEN,   8, 
                BDL1,   32, 
                BDL2,   32, 
                BDL3,   32, 
                BDL4,   32
            }

            Store (Zero, BDL1)
            Store (Zero, BDL2)
            Store (Zero, BDL3)
            Store (Zero, BDL4)
            Name (BBUF, Buffer (0x10) {})
            CreateDWordField (BBUF, Zero, DAT1)
            CreateDWordField (BBUF, 0x04, DAT2)
            CreateDWordField (BBUF, 0x08, DAT3)
            CreateDWordField (BBUF, 0x0C, DAT4)
            Store ("V1.60", Local0)
            Store (SizeOf (Local0), BLEN)
            Store ("V1.60", BBUF)
            Store (DAT1, BDL1)
            Store (DAT2, BDL2)
            Store (DAT3, BDL3)
            Store (DAT4, BDL4)
            Return (Zero)
        }

        Method (GECI, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x19))
            {
                Return (0x02)
            }

            OperationRegion (\F173, SystemMemory, Arg0, Arg1)
            Field (F173, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                ELEN,   8, 
                EDL1,   32, 
                EDL2,   32, 
                EDL3,   32, 
                EDL4,   32
            }

            Store (Zero, EDL1)
            Store (Zero, EDL2)
            Store (Zero, EDL3)
            Store (Zero, EDL4)
            BSMI (Arg0)
            Return (Zero)
        }

        Method (MF18, 3, NotSerialized)
        {
            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G18V (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (GDVI (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x02))
            {
                Store (GDVS (Arg0, Arg1), Local0)
            }

            If (LEqual (Arg2, 0x03))
            {
                Store (SDPW (Arg0, Arg1), Local0)
            }

            Return (Local0)
        }

        Method (G18V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F180, SystemMemory, Arg0, Arg1)
            Field (F180, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (GDVI, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x18))
            {
                Return (0x02)
            }

            OperationRegion (\F181, SystemMemory, Arg0, Arg1)
            Field (F181, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                LDI0,   32, 
                LDI1,   32
            }

            Store (Zero, LDI0)
            Return (Zero)
        }

        Method (GDVS, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F182, SystemMemory, Arg0, Arg1)
            Field (F182, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                DNUM,   8, 
                DSTS,   8
            }

            ShiftLeft (One, DNUM, Local0)
            If (LEqual (And (Local0, Zero), Zero))
            {
                Return (0x10)
            }

            Return (Zero)
        }

        Method (SDPW, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0A))
            {
                Return (0x02)
            }

            OperationRegion (\F183, SystemMemory, Arg0, Arg1)
            Field (F183, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                DNUM,   8, 
                DCTR,   8
            }

            ShiftLeft (One, DNUM, Local0)
            If (LEqual (And (Local0, Zero), Zero))
            {
                Return (0x10)
            }

            If (LGreater (DCTR, One))
            {
                Return (0x11)
            }

            Return (Zero)
        }
    }

    Scope (_SB.ATKD)
    {
        Method (OFBD, 1, NotSerialized)
        {
            Name (FBDT, Package (0x04)
            {
                0xF1, 
                0xF2, 
                0xF3, 
                0xF6
            })
            Store (Match (FBDT, MEQ, Arg0, MTR, Zero, Zero), Local0)
            Increment (Local0)
            Return (Local0)
        }
    }

    Scope (_SB.ATKD)
    {
        Method (AGLN, 4, NotSerialized)
        {
        }
    }

    Scope (_SB.ATKD)
    {
        Method (PRCT, 4, NotSerialized)
        {
            If (LNotEqual (Arg1, 0x31))
            {
                Return (0xFF)
            }

            OperationRegion (FM31, SystemMemory, Arg0, 0x08)
            Field (FM31, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x06), 
                SM31,   8, 
                EM31,   8
            }

            Store (One, Local0)
            If (LEqual (Arg2, Zero))
            {
                Store (G31V (Arg0, Arg3), Local0)
            }

            If (LEqual (Arg2, One))
            {
                Store (PDMK (Arg0, Arg3), Local0)
            }

            If (Local0)
            {
                Store (Local0, EM31)
                Or (SM31, 0x02, SM31)
            }

            Or (SM31, 0x80, SM31)
            Return (Zero)
        }

        Method (G31V, 2, NotSerialized)
        {
            If (LLess (Arg1, 0x0C))
            {
                Return (0x02)
            }

            OperationRegion (\F310, SystemMemory, Arg0, Arg1)
            Field (F310, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x08), 
                SVER,   16, 
                MVER,   16
            }

            Store (Zero, MVER)
            Store (Zero, SVER)
            Return (Zero)
        }

        Method (PDMK, 2, NotSerialized)
        {
            OperationRegion (\F301, SystemMemory, Arg0, Arg1)
            Field (F301, DWordAcc, NoLock, Preserve)
            {
                        Offset (0x06), 
                SF31,   8, 
                EF31,   8
            }

            Store (One, SF31)
            BSMI (Arg0)
            If (LEqual (SF31, One))
            {
                Store (One, EF31)
                Store (0x82, SF31)
            }

            Return (Zero)
        }
    }

    Scope (_SB)
    {
        Device (LID)
        {
            Name (_HID, EisaId ("PNP0C0D"))
            Method (_LID, 0, NotSerialized)
            {
                Store (One, Local0)
                Store (^^PCI0.SBRG.EC0.RPIN (0x06), Local0)
                If (LEqual (Local0, Ones))
                {
                    Store (One, Local0)
                }

                If (And (WAF1, 0x80))
                {
                    If (LGreaterEqual (And (WAF1, 0x0F), 0x02))
                    {
                        Return (One)
                    }
                }

                Return (Local0)
            }
        }
    }

    Scope (_GPE)
    {
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (_Q85, 0, NotSerialized)
        {
            If (LCDT)
            {
                If (LEqual (VGAF, 0x04))
                {
                    Sleep (0x03E8)
                }

                Or (WAF1, 0x40, WAF1)
                ISMI (0xB0)
                Notify (LID, 0x80)
                If (And (VGAF, One))
                {
                    Store (GLID (), Local0)
                    ^^^VGA.LIDE (Local0)
                }
            }
        }
    }

    Scope (\)
    {
        Method (ACPS, 0, Serialized)
        {
            Store (\_SB.PCI0.SBRG.EC0.RPIN (0x03), Local0)
            XOr (Local0, One, Local0)
            Return (Local0)
        }

        Method (DCPS, 1, Serialized)
        {
            Store (\_SB.PCI0.SBRG.EC0.RPIN (0x04), Local0)
            XOr (Local0, One, Local0)
            Return (Local0)
        }

        Name (LCDB, Zero)
        Method (PRJS, 1, Serialized)
        {
        }

        Method (PRJW, 1, Serialized)
        {
            \_SB.PCI0.SBRG.EC0.STBR ()
        }

        Method (GLID, 0, Serialized)
        {
            Return (\_SB.PCI0.SBRG.EC0.RPIN (0x06))
        }

        Method (TLID, 0, Serialized)
        {
        }

        Method (TGAC, 0, Serialized)
        {
        }

        Method (TGDC, 1, Serialized)
        {
        }

        Method (FCTR, 3, Serialized)
        {
        }

        Method (OMLD, 1, Serialized)
        {
            \_SB.PCI0.SBRG.EC0.SPIN (0x1A, Arg0)
        }

        Method (OWLD, 1, Serialized)
        {
            If (Arg0) {}
            Else
            {
            }
        }

        Method (OBTD, 1, Serialized)
        {
            Store (Arg0, BRST)
            If (Arg0) {}
            Else
            {
            }
        }

        Method (OHWR, 0, Serialized)
        {
            Store (Zero, Local0)
            If (\_SB.PCI0.P0P2.WLAN.MPDP ())
            {
                Or (Local0, 0x82, Local0)
            }

            If (RGPL (0x0A, One))
            {
                And (Local0, 0xFFFE, Local0)
            }
            Else
            {
                Or (Local0, One, Local0)
            }

            If (BTDP)
            {
                Or (Local0, 0x0100, Local0)
            }

            Return (Local0)
        }

        Method (ORST, 0, Serialized)
        {
            Store (Zero, Local0)
            If (WRST)
            {
                Or (Local0, One, Local0)
            }

            If (BRST)
            {
                Or (Local0, 0x02, Local0)
            }

            Return (Local0)
        }

        Method (GBTL, 0, Serialized)
        {
            Return (\_SB.PCI0.SBRG.EC0.RPIN (0x02))
        }

        Method (SBTL, 1, Serialized)
        {
            \_SB.PCI0.SBRG.EC0.SPIN (0x02, Arg0)
        }

        Method (BL2C, 0, NotSerialized)
        {
            Return (Zero)
        }

        Method (STCF, 1, Serialized)
        {
            If (LEqual (Arg0, One))
            {
                \_SB.PCI0.SBRG.EC0.FNCT (0x84, Zero)
            }
        }

        Method (OTGB, 0, Serialized)
        {
            Store (One, Local0)
            Return (Local0)
        }

        Method (OTPM, 0, Serialized)
        {
            Store (\_SB.PCI0.SBRG.TPM.ACCS, Local0)
            If (LNotEqual (Local0, 0xFF))
            {
                Store (One, Local0)
            }
            Else
            {
                Store (Zero, Local0)
            }

            Return (Local0)
        }

        Method (OTID, 0, Serialized)
        {
            Store (\_SB.PCI0.SBRG.TPM.ACCS, Local0)
            If (LNotEqual (Local0, 0xFF))
            {
                If (LEqual (\_SB.PCI0.SBRG.TPM.VDID, 0x687119FA))
                {
                    Return (0x0435CF4D)
                }
            }

            Return (0x0201D824)
        }

        Method (ODTS, 0, Serialized)
        {
            Store (DTS1, Local0)
            If (LGreater (DTS2, Local0))
            {
                Store (DTS2, Local0)
            }

            Store (\_TZ.RTMP (), Local1)
            Store (\_SB.PCI0.SBRG.EC0.RRAM (0x0509), Local2)
            Subtract (Local0, Local1, Local3)
            Add (Local2, Local3, Local2)
            And (Local2, 0xFF, Local2)
            \_SB.PCI0.SBRG.EC0.WRAM (0x0509, Local2)
        }
    }

    Scope (_GPE)
    {
        Method (_L03, 0, Serialized)
        {
            Notify (\_SB.PCI0.USB0, 0x02)
            Notify (\_SB.PWRB, 0x02)
        }

        Method (_L04, 0, Serialized)
        {
            Notify (\_SB.PCI0.USB1, 0x02)
            Notify (\_SB.PWRB, 0x02)
        }

        Method (_L0C, 0, Serialized)
        {
            Notify (\_SB.PCI0.USB2, 0x02)
        }

        Method (_L0E, 0, Serialized)
        {
            Notify (\_SB.PCI0.USB3, 0x02)
        }

        Method (_L05, 0, Serialized)
        {
            Notify (\_SB.PCI0.USB4, 0x02)
        }

        Method (_L0D, 0, Serialized)
        {
            Notify (\_SB.PCI0.EUSB, 0x02)
        }

        Method (_L08, 0, Serialized)
        {
            Notify (\_SB.PCI0.HDAC, 0x02)
        }

        Method (_L0B, 0, Serialized)
        {
            If (PMEW)
            {
                Notify (\_SB.PCI0.P0P6, 0x02)
                Notify (\_SB.PCI0.P0P2, 0x02)
                Store (Zero, PMEW)
            }
            Else
            {
                If (\_SB.PCI0.P0P6.CBS0.CBSR ())
                {
                    Notify (\_SB.PCI0.P0P6.CBS0, 0x02)
                }
            }

            If (\_SB.PCI0.P0P6.GLAN.PMES)
            {
                Notify (\_SB.PCI0.P0P6.GLAN, 0x02)
                Store (One, \_SB.PCI0.P0P6.GLAN.PMES)
            }
        }

        Method (_L1A, 0, Serialized)
        {
            If (WLDP)
            {
                If (RGPL (0x0A, One))
                {
                    \_SB.PCI0.SBRG.EC0.SPIN (0x14, One)
                    SGPP (0x0A, One)
                }
                Else
                {
                    \_SB.PCI0.SBRG.EC0.SPIN (0x14, Zero)
                    SGPP (0x0A, Zero)
                }
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (_Q01, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x52)
            }
        }

        Method (_Q02, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x53)
            }
        }

        Method (_Q03, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x54)
            }
        }

        Method (_Q04, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x55)
            }
        }

        Method (_Q05, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x56)
            }
        }

        Method (_Q10, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0xAE)
            }
        }

        Method (_QB1, 0, NotSerialized)
        {
            ISMI (0xB2)
        }

        Method (_Q0D, 0, NotSerialized)
        {
            If (S4ST)
            {
                Store (Zero, S4ST)
                If (ATKP)
                {
                    Notify (ATKD, 0x6D)
                }
            }
        }

        Method (_Q0B, 0, NotSerialized)
        {
            If (WLDP)
            {
                If (RGPL (0x0A, One)) {}
                Else
                {
                    Notify (ATKD, 0x5D)
                }
            }
        }

        Method (_Q0C, 0, NotSerialized)
        {
            Notify (SLPB, 0x80)
        }

        Method (_Q0F, 0, NotSerialized)
        {
            If (LEqual (OSVT, OSVT))
            {
                And (^^^VGA.ARDY, One, Local0)
                If (Local0)
                {
                    And (^^^VGA.CBLV, 0xFF, Local0)
                    Multiply (Local0, 0xFF, Local0)
                    Divide (Local0, 0x64, Local1, Local0)
                    Store (0x07, Local1)
                    Store (^^^VGA.D100, ^^^VGA.BCLP)
                    If (LLessEqual (Local0, ^^^VGA.D090))
                    {
                        Store (0x06, Local1)
                        Store (^^^VGA.D100, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D080))
                    {
                        Store (0x05, Local1)
                        Store (^^^VGA.D090, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D070))
                    {
                        Store (0x04, Local1)
                        Store (^^^VGA.D080, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D060))
                    {
                        Store (0x03, Local1)
                        Store (^^^VGA.D070, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D050))
                    {
                        Store (0x02, Local1)
                        Store (^^^VGA.D060, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D040))
                    {
                        Store (One, Local1)
                        Store (^^^VGA.D050, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D030))
                    {
                        Store (Zero, Local1)
                        Store (^^^VGA.D040, ^^^VGA.BCLP)
                    }

                    If (LLess (Local1, 0x07))
                    {
                        Increment (Local1)
                    }
                    Else
                    {
                        Store (0x07, Local1)
                    }

                    Or (^^^VGA.BCLP, 0x80000000, ^^^VGA.BCLP)
                    Or (^^^VGA.ASLC, 0x02, ^^^VGA.ASLC)
                    STBR ()
                    Notify (ATKD, Add (Local1, 0x10))
                    Notify (^^^VGA.LCDD, 0x86)
                }
                Else
                {
                    If (LLess (LBTN, 0x07))
                    {
                        Increment (LBTN)
                    }
                    Else
                    {
                        Store (0x07, LBTN)
                    }

                    ISMI (0x9A)
                }
            }
            Else
            {
                If (LLess (LBTN, 0x0F))
                {
                    Increment (LBTN)
                }
                Else
                {
                    Store (0x0F, LBTN)
                }

                STBR ()
                If (ATKP)
                {
                    Notify (ATKD, Add (LBTN, 0x10))
                }
            }

            Return (One)
        }

        Method (_Q0E, 0, NotSerialized)
        {
            If (LEqual (OSVT, OSVT))
            {
                And (^^^VGA.ARDY, One, Local0)
                If (Local0)
                {
                    And (^^^VGA.CBLV, 0xFF, Local0)
                    Multiply (Local0, 0xFF, Local0)
                    Divide (Local0, 0x64, Local1, Local0)
                    Store (0x07, Local1)
                    Store (^^^VGA.D090, ^^^VGA.BCLP)
                    If (LLessEqual (Local0, ^^^VGA.D090))
                    {
                        Store (0x06, Local1)
                        Store (^^^VGA.D080, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D080))
                    {
                        Store (0x05, Local1)
                        Store (^^^VGA.D070, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D070))
                    {
                        Store (0x04, Local1)
                        Store (^^^VGA.D060, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D060))
                    {
                        Store (0x03, Local1)
                        Store (^^^VGA.D050, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D050))
                    {
                        Store (0x02, Local1)
                        Store (^^^VGA.D040, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D040))
                    {
                        Store (One, Local1)
                        Store (^^^VGA.D030, ^^^VGA.BCLP)
                    }

                    If (LLessEqual (Local0, ^^^VGA.D030))
                    {
                        Store (Zero, Local1)
                        Store (^^^VGA.D030, ^^^VGA.BCLP)
                    }

                    If (LGreater (Local1, Zero))
                    {
                        Decrement (Local1)
                    }
                    Else
                    {
                        Store (Zero, Local1)
                    }

                    Or (^^^VGA.BCLP, 0x80000000, ^^^VGA.BCLP)
                    Or (^^^VGA.ASLC, 0x02, ^^^VGA.ASLC)
                    STBR ()
                    Notify (ATKD, Add (Local1, 0x20))
                    Notify (^^^VGA.LCDD, 0x87)
                }
                Else
                {
                    If (LGreater (LBTN, Zero))
                    {
                        Decrement (LBTN)
                    }
                    Else
                    {
                        Store (Zero, LBTN)
                    }

                    ISMI (0x9A)
                }
            }
            Else
            {
                If (LGreater (LBTN, Zero))
                {
                    Decrement (LBTN)
                }

                If (LGreater (LBTN, 0x0F))
                {
                    Store (0x0F, LBTN)
                }

                STBR ()
                If (ATKP)
                {
                    Notify (ATKD, Add (LBTN, 0x20))
                }
            }

            Return (One)
        }

        Name (AVNC, Package (0x10)
        {
            Zero, 
            0x61, 
            0x62, 
            0x63, 
            0x64, 
            0x65, 
            0x66, 
            0x67, 
            0x8C, 
            0x8D, 
            0x8E, 
            0x90, 
            0x8F, 
            0x91, 
            0x92, 
            0x93
        })
        Method (_Q11, 0, NotSerialized)
        {
            FHKW ()
            Store (ADVG (), Local0)
            If (NATK ())
            {
                Store (DerefOf (Index (AVNC, Local0)), Local1)
                If (ATKP)
                {
                    Notify (ATKD, Local1)
                }
                Else
                {
                    SWHG (Local0)
                }
            }
            Else
            {
                SWHG (Local0)
            }

            FHKS ()
        }

        Name (FHKM, One)
        Method (FHKW, 0, Serialized)
        {
            While (LNot (FHKM))
            {
                Sleep (0x0A)
            }

            Store (Zero, FHKM)
        }

        Method (FHKS, 0, Serialized)
        {
            Store (One, FHKM)
        }

        Method (_Q13, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x32)
            }
        }

        Method (_Q14, 0, NotSerialized)
        {
            If (LLess (AVOL, 0x0F))
            {
                Increment (AVOL)
            }

            If (ATKP)
            {
                Notify (ATKD, 0x31)
            }
        }

        Method (_Q15, 0, NotSerialized)
        {
            If (LGreater (AVOL, Zero))
            {
                Decrement (AVOL)
            }

            If (ATKP)
            {
                Notify (ATKD, 0x30)
            }
        }

        Method (_Q20, 0, NotSerialized)
        {
            If (CDFG)
            {
                Store (One, SMBF)
                Store (Zero, CDFG)
            }

            If (ALFG)
            {
                ALMH (ALAD)
                Store (Zero, ALFG)
            }
        }

        Method (_Q12, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x6B)
            }
        }

        Method (_Q82, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x5C)
            }
        }

        Method (_QB0, 0, NotSerialized)
        {
            Notify (\_TZ.THRM, 0x80)
        }

        Method (_Q68, 0, NotSerialized)
        {
            DBGR (0x12, 0x34, 0x56, 0x78)
        }

        Method (_Q6C, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x40)
            }
        }

        Method (_Q6D, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x41)
            }
        }

        Method (_Q6E, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x43)
            }
        }

        Method (_Q6F, 0, NotSerialized)
        {
            If (ATKP)
            {
                Notify (ATKD, 0x45)
            }
        }

        Method (_QD0, 0, NotSerialized)
        {
            Store (0xD0, ^^^^ATKD.FNXX)
            Notify (ATKD, 0x4A)
        }

        Method (_QD1, 0, NotSerialized)
        {
            Store (0xD1, ^^^^ATKD.FNXX)
            Notify (ATKD, 0x4B)
            Store (0xCC, DBG8)
        }

        Method (_QD2, 0, NotSerialized)
        {
            Store (0xD2, ^^^^ATKD.FNXX)
            Notify (ATKD, 0x4B)
        }

        Method (B680, 2, NotSerialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (0x80, CDT1)
                    Store (Arg0, CDT2)
                    Store (Arg1, CDT3)
                    Store (0xB6, CMD1)
                    While (CMD1) {}
                    Store (CDT1, Local0)
                    Release (MUEC)
                    Return (Local0)
                }
            }
        }

        Method (B681, 3, NotSerialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (0x81, CDT1)
                    Store (Arg0, CDT2)
                    Store (Arg1, CDT3)
                    Store (Arg2, CDT4)
                    Store (0xB6, CMD1)
                    While (CMD1) {}
                    Release (MUEC)
                }
            }
        }

        Method (ECBA, 2, NotSerialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT2)
                    Store (Arg1, CDT3)
                    Store (0xBA, CMD1)
                    While (CMD1) {}
                    Store (CDT1, Local0)
                    Release (MUEC)
                    Return (Local0)
                }
            }
        }

        Method (ECE2, 1, NotSerialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT1)
                    Store (0xE2, CMD1)
                    While (CMD1) {}
                    Release (MUEC)
                }
            }
        }

        Method (ECBB, 3, NotSerialized)
        {
            If (ECAV ())
            {
                If (LEqual (Acquire (MUEC, 0xFFFF), Zero))
                {
                    Store (Arg0, CDT1)
                    Store (Arg1, CDT2)
                    Store (Arg2, CDT3)
                    Store (0xBB, CMD1)
                    While (CMD1) {}
                    Release (MUEC)
                }
            }
        }
    }

    Scope (_SB.PCI0.P0P3.XCF0)
    {
        Name (_EJD, "\\_SB.PCI0.USB3.RHUB.PRT0")
    }

    Scope (_SB.PCI0.USB3)
    {
        Device (RHUB)
        {
            Name (_ADR, Zero)
            Device (PRT0)
            {
                Name (_ADR, Zero)
                Name (_EJD, "\\_SB.PCI0.P0P3.XCF0")
            }

            Device (PRT1)
            {
                Name (_ADR, One)
            }
        }
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, _Y0D, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y0E, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y0D._MIN, MIN5)
            CreateDWordField (CRS, \_SB.PCI0._Y0D._MAX, MAX5)
            CreateDWordField (CRS, \_SB.PCI0._Y0D._LEN, LEN5)
            CreateDWordField (CRS, \_SB.PCI0._Y0E._MIN, MIN6)
            CreateDWordField (CRS, \_SB.PCI0._Y0E._MAX, MAX6)
            CreateDWordField (CRS, \_SB.PCI0._Y0E._LEN, LEN6)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Return (CRS)
            }
        }
    }

    Name (WAF1, Zero)
    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)
    {
        If (LEqual (Arg0, 0x03))
        {
            Store (Zero, LCDT)
        }

        Store (Zero, WAF1)
        DIAG (Arg0)
        PTS (Arg0)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
    }

    Method (_WAK, 1, NotSerialized)
    {
        If (LEqual (Arg0, 0x03))
        {
            Store (0x83, WAF1)
        }

        ISMI (0xB1)
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        Return (WAKP)
    }

    Scope (_SB.PCI0.SBRG)
    {
        Device (TPM)
        {
            Method (_HID, 0, NotSerialized)
            {
                Return (OTID ())
            }

            Name (_CID, 0x310CD041)
            Name (_CRS, ResourceTemplate ()
            {
                IO (Decode16,
                    0x0254,             // Range Minimum
                    0x0254,             // Range Maximum
                    0x01,               // Alignment
                    0x02,               // Length
                    )
                IO (Decode16,
                    0x4700,             // Range Minimum
                    0x4700,             // Range Maximum
                    0x01,               // Alignment
                    0x0C,               // Length
                    )
                Memory32Fixed (ReadWrite,
                    0xFED40000,         // Address Base
                    0x00005000,         // Address Length
                    )
            })
            OperationRegion (\TCMM, SystemMemory, 0xFED40000, 0x5000)
            Field (TCMM, ByteAcc, NoLock, Preserve)
            {
                ACCS,   8, 
                        Offset (0xF00), 
                VDID,   32
            }

            Method (_STA, 0, NotSerialized)
            {
                Store (OTPM (), Local0)
                If (LEqual (Local0, One))
                {
                    Return (0x0F)
                }
                Else
                {
                    Return (Zero)
                }
            }

            Name (UMOR, Buffer (0x10)
            {
                /* 0000 */    0xED, 0x54, 0x60, 0x37, 0x13, 0xCC, 0x75, 0x46, 
                /* 0008 */    0x90, 0x1C, 0x47, 0x56, 0xD7, 0xF2, 0xD4, 0x5D
            })
            Name (UPPI, Buffer (0x10)
            {
                /* 0000 */    0xA6, 0xFA, 0xDD, 0x3D, 0x1B, 0x36, 0xB4, 0x4E, 
                /* 0008 */    0xA4, 0x24, 0x8D, 0x10, 0x08, 0x9D, 0x16, 0x53
            })
            Method (_DSM, 4, NotSerialized)
            {
                If (LEqual (Arg0, UMOR))
                {
                    If (LEqual (Arg1, One))
                    {
                        Name (_T_0, Zero)
                        Store (Arg2, _T_0)
                        If (LEqual (_T_0, One))
                        {
                            Store (DerefOf (Index (Arg3, Zero)), Local0)
                            If (Local0) {}
                            Else
                            {
                            }

                            Return (Zero)
                        }
                        Else
                        {
                            Return (One)
                        }
                    }

                    Return (One)
                }

                Name (RST3, Package (0x02)
                {
                    Zero, 
                    Zero
                })
                Name (RST4, Package (0x03)
                {
                    Zero, 
                    Zero, 
                    Ones
                })
                If (LEqual (Arg0, UPPI))
                {
                    If (LEqual (Arg1, One))
                    {
                        Name (_T_1, Zero)
                        Store (Arg2, _T_1)
                        If (LEqual (_T_1, One))
                        {
                            Return (Buffer (0x04)
                            {
                                "1.0"
                            })
                        }
                        Else
                        {
                            If (LEqual (_T_1, 0x02))
                            {
                                Store (DerefOf (Index (Arg3, Zero)), Local0)
                                If (LGreater (Local0, 0x0E))
                                {
                                    Return (One)
                                }

                                If (LEqual (Match (Package (0x02)
                                            {
                                                0x0C, 
                                                0x0D
                                            }, MEQ, Local0, MTR, Zero, Zero), Ones))
                                {
                                    And (Local0, 0x0F, Local0)
                                    And (PPIS, 0xF0, PPIS)
                                    Or (PPIS, Local0, PPIS)
                                    Return (Zero)
                                }
                                Else
                                {
                                    Return (One)
                                }
                            }
                            Else
                            {
                                If (LEqual (_T_1, 0x03))
                                {
                                    And (PPIS, 0x0F, Local0)
                                    Store (Local0, Index (RST3, One))
                                    Return (RST3)
                                }
                                Else
                                {
                                    If (LEqual (_T_1, 0x04))
                                    {
                                        Return (0x02)
                                    }
                                    Else
                                    {
                                        If (LEqual (_T_1, 0x05))
                                        {
                                            And (PPIS, 0xF0, Local0)
                                            ShiftRight (Local0, 0x04, Local0)
                                            Store (Local0, Index (RST4, One))
                                            If (LOr (LEqual (PPIR, 0xF0), LEqual (PPIR, 0xF1)))
                                            {
                                                Store (0xFFFFFF00, Local0)
                                                Or (Local0, PPIR, Local0)
                                            }
                                            Else
                                            {
                                                Store (PPIR, Local0)
                                            }

                                            Store (Local0, Index (RST4, 0x02))
                                            Return (RST4)
                                        }
                                        Else
                                        {
                                            If (LEqual (_T_1, 0x06))
                                            {
                                                Return (One)
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    Name (_S0, Package (0x04)
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x06, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.NPTS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
            \_SB.PCI0.VGA.OPTS (Arg0)
            OEMS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        WDTS (Arg0)
        \_SB.PCI0.NWAK (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
        \_SB.PCI0.VGA.OWAK (Arg0)
        OEMW (Arg0)
        \_SB.ATKD.GENW (Arg0)
    }
}

