/*
 * Filename: $Id: CATALOG.CMD,v 1.59 2007/12/13 17:01:39 tjb Exp $
 *  Created: 2003-07-23 AT
 *  Purpose: Create the 'Install Catalog', a list of installation tasks for
 *           the LCU command file (LCUINST.CMD) to run.  This list is used
 *           by LCUINST to generate the 'products_to_install' variable.
 *           The catalogue is written in PRODUCTS.CAT under the response
 *           file directory; it will be read during all phases of the
 *           installation.  (The actual order of items within PRODUCTS.CAT
 *           is not important.)
 * Changes: 20060317: dve added eSchemes
 * Changes: Revision 1.31  2005/11/11 18:00:47  bvl
 * Changes: bart@netage.nl: Update snoop.lst for new snoopers
 * Changes:                 Gather log information before installing
 * Changes:
 * Changes: Revision 1.30  2005/11/08 00:06:51  bvl
 * Changes: bart@netage.nl: Enable SNAP installation
 * Changes:
 * Changes: Revision 1.29  2005/10/07 18:02:13  bvl
 * Changes: bart@netage.nl: Wifistat fix
 * Changes:
 * Changes: Revision 1.28  2005/10/07 15:27:56  bvl
 * Changes: bvl: Install wifistat if there is more then one network adapter: @@fixes 1106
 */

rsp     = 'H:\ECS\INSTALL\RSP'
log     = 'H:\VAR\LOG'
srcdrv  = 'S:'
catalog = rsp'\products.cat'
log1    = log'\CATALOG.L1'
log2    = log'\CATALOG.L2'

IF RxFuncQuery('SysFileSearch') > 0 THEN
    CALL RxFuncAdd 'SysFileSearch', 'REXXUTIL', 'SysFileSearch'

/*
 * Install tasks common to all installations.  These ones do their own
 * condition-checking where needed, so we are safe to always run them.
 */
CALL LINEOUT catalog, 'PATHSED'
CALL LINEOUT catalog, 'DEFRSP'
CALL LINEOUT catalog, 'MIGRATE'
CALL LINEOUT catalog, 'BASEINST'
CALL LINEOUT catalog, 'ACPIWZRD'
CALL LINEOUT catalog, 'HWMERGE'
CALL LINEOUT catalog, 'CONFSED'
CALL LINEOUT catalog, 'PRNDRV'
CALL LINEOUT catalog, 'ECSPROD'
/*CALL LINEOUT catalog, 'ECLOCK'*/
CALL LINEOUT catalog, 'BLDDESK'
CALL LINEOUT catalog, 'MAINTDSK' /* Build maintenance desktop */
CALL LINEOUT catalog, 'PREVIOUS'
CALL LINEOUT catalog, 'FINISH'
CALL LINEOUT catalog, 'INITPH'
CALL LINEOUT catalog, 'CHK4JAVA'
CALL LINEOUT catalog, 'FIINST'
CALL LINEOUT catalog, 'SHUFFLE'
CALL LINEOUT catalog, 'ECSMT'
CALL LINEOUT catalog, 'SGUIDE'
CALL LINEOUT catalog, 'FLOPPYCMD'
CALL LINEOUT catalog, 'MPTS'            /* Always install basic MPTS */
CALL LINEOUT catalog, 'DIAGINFO'
CALL LINEOUT catalog, 'WARPIN'
CALL LINEOUT catalog, 'INNOLIBC'
CALL LINEOUT catalog, 'KLIBC'
CALL LINEOUT catalog, 'KLIBCCFG'
CALL LINEOUT catalog, 'UCLIP'
CALL LINEOUT catalog, 'ECIF'  /* Always install eComStation Installer Framework */
CALL LINEOUT catalog, 'ECORT' /* Always install eComSoft Runtime */

/*
 * Now the conditional product installations.
 */

/* if Dialog Enhancements are selected, add those to the products file */
IF ( CheckKey( rsp'\ECSPROD.RSP', "DLGENH", "1")) THEN DO
    CALL LINEOUT catalog, 'DLGBASE'
/*    CALL LINEOUT catalog, 'DLGPRINT' */
    CALL LINEOUT catalog, 'DLGMPTS'
END

/* EDFS; defaults to enabled unless EDFS=0 */
IF ( CheckKey( rsp'\ECSPROD.RSP', 'EFDS', '0') = 0 ) THEN
    CALL LINEOUT catalog, 'EFDS'

IF CheckKey( rsp'\MPTS.RSP', '* NETGEN_install', '1') = 1 THEN DO
/*    CALL LINEOUT catalog, 'MPTS'      */
/*    CALL LINEOUT catalog, 'DLGMPTS'   */
/* Dependency of ecsconet is on NETGEN_internet, it is not only
 for modem users, but also if you use DSL with PPtP or PPoE */
    IF CheckKey( rsp'\MPTS.RSP', '* NETGEN_modem', '1') = 1 THEN
        CALL LINEOUT catalog, 'ECSCONET'
END

IF CheckKey( rsp'\MPTS.RSP', '* NETGEN_LAN', '1') = 1 THEN
    CALL LINEOUT catalog, 'ESAMBAC' /* this is no longer a configurable option, it will be installed when LAN installation is selected */

/* Check if Netware needs to be installed - if protocol was removed by user, disable Netware install */
IF CheckKey( rsp'\MPTS.RSP', '* NETGEN_NW', '1') = 1 & GetValue( rsp'\MPTS.RSP', 'ODI2NDI') \= '' THEN
        CALL LINEOUT catalog, 'NETWARE'

/* GenMac detection (scan for DriverName = WRND32$) */
/* also scan for SSID (if found - install XWLAN widget) */
keyword = '* NETADPT_NIF'
rspfile = rsp'\MPTS.RSP'
genmac = 0; xwlan = 0

CALL SysFileSearch keyword, rspfile, 'matches.'
    IF matches.0 > 0 THEN DO
        do i = 1 to matches.0
         PARSE VAR matches.i variable'='setting
         variable = STRIP( variable )
         setting  = STRIP( setting )
         IF setting \= '' THEN DO
          NIF_FILE = srcdrv || '\CID\SERVER\MPTS\IBMCOM\MACS\' || setting
          IF (CheckKey(NIF_FILE, 'DriverName', 'WRND32$') = 1 & genmac = 0) THEN DO
           CALL LINEOUT catalog, 'GENMAC'
           genmac = 1
          END
          IF (CheckKey(NIF_FILE, 'WLAN', '?') = 1 & xwlan = 0) THEN DO
           CALL LINEOUT catalog, 'XWLAN'
           xwlan = 1
          END
          IF (genmac = 1 & xwlan = 1) THEN LEAVE i /* skip the rest if both are already detected */
         END /* setting \= '' */
        END /* do i = 1 TO matches.0 */
     END
  CALL STREAM rspfile, 'C', 'CLOSE'

/* end of GenMac detection */

/* disabled: code now obsolete, see above
IF (  CheckKey(rsp'\MPTS.RSP','* NETADPT_NIF','ARLTNDIS.NIF') ) | ( CheckKey(rsp'\MPTS.RSP','* NETADPT_NIF','IBMWIFI2.NIF')) | ( CheckKey(rsp'\MPTS.RSP','* NETADPT_NIF','IBMPRISM.NIF')) THEN DO
     CALL LINEOUT catalog, 'WIFISTAT'
END
*/

IF GetValue( rsp'\NETSCAPE.RSP', 'COMP') \= '' THEN DO
    CALL LINEOUT catalog, 'NETSCAPE'
    CALL LINEOUT catalog, 'WSFI'
END

peer = TRANSLATE( GetValue( rsp'\PEER.RSP', 'InstallRequester'))
IF ( peer = 'INSTALL' ) | ( peer = 'INSTALLIFREQUIRED') THEN DO
    CALL LINEOUT catalog, 'PEER'
    CALL LINEOUT catalog, 'BOOKS'
    IF ( CheckKey( rsp'\ECSPROD.RSP', "DLGENH", "1")) THEN DO
        CALL LINEOUT catalog, 'DLGPEER'
        CALL LINEOUT catalog, 'DLGPEERLK'
        CALL LINEOUT catalog, 'DLGUPM'
        CALL LINEOUT catalog, 'DLGUPMLK'
    END
END

IF CheckKey( rsp'\BROWSER.RSP', 'INSTALL', '1') THEN
DO
    CALL LINEOUT catalog, 'FIREFOX'
END
IF CheckKey( rsp'\BROWSER.RSP', 'THUNDERBIRD', '1') THEN
DO
    CALL LINEOUT catalog, 'THUNDERB'
END

IF CheckKey( rsp'\BROWSER.RSP', 'FT2LIB', '1') THEN
    CALL LINEOUT catalog, 'FT2LIB'

IF CheckKey( rsp'\ECSPROD.RSP', 'DEJAVU', '1') THEN
    CALL LINEOUT catalog, 'DEJAVU'

IF CheckKey( rsp'\ECSPROD.RSP', 'EMXRT', '1') THEN
    CALL LINEOUT catalog, 'EMXRT'

IF CheckKey( rsp'\ECSPROD.RSP', 'COREUTILS', '1') THEN
    CALL LINEOUT catalog, 'COREUTILS'

IF CheckKey( rsp'\ECSPROD.RSP', 'MULTIMEDIA', '1') THEN DO
    CALL LINEOUT catalog, 'MMECS'
    IF ( CheckKey( rsp'\ECSPROD.RSP', "DLGENH", "1")) THEN CALL LINEOUT catalog, 'DLGMMPM'
END

IF CheckKey( rsp'\JAVA131.RSP', 'JV131Runtime.Selection', '1') THEN
    CALL LINEOUT catalog, 'JAVA131'

/* (INNORT keyword is in Java142 response file for historical reasons) */
IF CheckKey( rsp'\JAVA142.RSP', 'INNORT', '1') THEN DO
    innodrv = FILESPEC('DRIVE', GetValue( rsp'\JAVA142.RSP', 'INNORT_DRV'))
    /* If target volume is FAT, deselect this item */
    IF ( SysFileSystemType( innodrv ) = 'FAT') THEN DO
        CALL LINEOUT log1, 'Disabling Innotek Runtime because target volume is FAT.'
        '@CALL CUBE { REPSTRING "1" WITH "0" IN "INNORT"  ( ALL *ID }' rsp'\JAVA142.RSP 2>&1 >>' log2
        /* If INNORT isn't installed, we have to deselect everything that requires it, too */
        CALL LINEOUT log1, 'Disabling Java 1.4.2 which requires Innotek Runtime.'
        '@CALL CUBE { REPSTRING "1" WITH "0" IN "JRE142"  ( ALL *ID }' rsp'\JAVA142.RSP 2>&1 >>' log2
        '@CALL CUBE { REPSTRING "1" WITH "0" IN "SDK142"  ( ALL *ID }' rsp'\JAVA142.RSP 2>&1 >>' log2
    END
    ELSE
        CALL LINEOUT catalog, 'INNORT'
END

/* (JAVA142.CMD will figure out what to install, SDK or JRE) */
IF CheckKey( rsp'\JAVA142.RSP', 'JRE142', '1') THEN DO
    javadrv = FILESPEC('DRIVE', GetValue( rsp'\JAVA142.RSP', 'INSTDIR'))
    /* If target volume is FAT, deselect this item */
    IF ( SysFileSystemType( javadrv ) = 'FAT') THEN DO
        CALL LINEOUT log1, 'Disabling Java 1.4.2 because target volume is FAT.'
        '@CALL CUBE { REPSTRING "1" WITH "0" IN "JRE142"  ( ALL *ID }' rsp'\JAVA142.RSP 2>&1 >>' log2
    END
    ELSE
        CALL LINEOUT catalog, 'JAVA142'
END

IF CheckKey( rsp'\JAVA142.RSP', 'SDK142', '1') THEN DO
    javadrv = FILESPEC('DRIVE', GetValue( rsp'\JAVA142.RSP', 'INSTDIR'))
    /* If target volume is FAT, deselect this item */
    IF ( SysFileSystemType( javadrv ) = 'FAT') THEN DO
        CALL LINEOUT log1, 'Disabling Java 1.4.2 because target volume is FAT.'
        '@CALL CUBE { REPSTRING "1" WITH "0" IN "SDK142"  ( ALL *ID }' rsp'\JAVA142.RSP 2>&1 >>' log2
    END
    ELSE
        CALL LINEOUT catalog, 'JAVA142'
END

IF CheckKey( rsp'\CDWECS.RSP', 'INSTALL', '1') THEN
    CALL LINEOUT catalog, 'CDWECS'

IF CheckKey( rsp'\TCPIP.RSP', 'BASE_APPS', 'Y') THEN DO
    CALL LINEOUT catalog, 'TCPIP'
    IF ( CheckKey( rsp'\ECSPROD.RSP', "DLGENH", "1")) THEN CALL LINEOUT catalog, 'DLGTCPIP'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'DSSAVER', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'CAIRO'
    CALL LINEOUT catalog, 'DSSAVER'
END

/* If eSchemes is selected we do not install ECSGUI */
IF CheckKey( rsp'\ECSPROD.RSP', 'ESCHEMES', '1') THEN
DO
    CALL LINEOUT catalog, 'ESCHEMES'
END

/* eStyler will still be unpacked if eSchemes selected - logic is in eStyler.cmd */
IF CheckKey( rsp'\ECSPROD.RSP', 'ECSGUI', '1' ) THEN
DO
    CALL LINEOUT catalog, 'ESTYLER'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'FAT32', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'FAT32'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'LUCIDE', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'LUCIDE'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'TAME', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'TAME'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', '4OS2', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, '4OS2'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'PSIOS2', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'PSIOS2'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'FAXWORKS', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'FAXWORKS'
END

/* this is no longer a selectable option, but will be installed when network is installed
IF ( CheckKey( rsp'\ECSPROD.RSP', 'ESAMBAC', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'ESAMBAC'
END
*/

IF ( CheckKey( rsp'\ECSPROD.RSP', 'SECURITY', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'SECURITY'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'OPENSSH', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'OPENSSH'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'AMOUSE', '1') = 1 ) THEN
DO
    CALL LINEOUT catalog, 'AMOUSE'
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'PMVNC', '1') = 1 ) THEN
    CALL LINEOUT catalog, 'PMVNC'

IF CheckKey( rsp'\FFST.RSP', 'Install', '1') THEN
    CALL LINEOUT catalog, 'FFST'

SELECT
 WHEN ( CheckKey( rsp'\ECSPROD.RSP', 'SNAP', '1') = 1 ) THEN DO
    CALL LINEOUT catalog, 'SDD'
    CALL LINEOUT catalog, 'SDDVCFG'
    CALL LINEOUT catalog, 'VCFGCID'
    END
 WHEN ( CheckKey( rsp'\ECSPROD.RSP', 'PANORAMA', '1') = 1 ) THEN DO
    CALL LINEOUT catalog, 'PANORAMA'
    CALL LINEOUT catalog, 'VCFGCID'
    END
 WHEN ( CheckKey( rsp'\ECSPROD.RSP', 'NOSDDSE', '1') = 1 ) & ( CheckKey( rsp'\HWOPT.RSP', 'DisplayAdapter', '4') = 0 ) THEN DO
    CALL LINEOUT catalog, 'GENGRADD'
    CALL LINEOUT catalog, 'VCFGCID'
    END
 OTHERWISE NOP
END

IF ( CheckKey( rsp'\ECSPROD.RSP', 'NORESCHANGE', '1') = 0 ) & ( CheckKey( rsp'\HWOPT.RSP', 'DisplayAdapter', '4') = 0 ) THEN
    CALL LINEOUT catalog, 'VIDEORES'

IF ( CheckKey( rsp'\HARDWARE.RSP', 'USBUHCD.SYS', '?') = 1 ) | ( CheckKey( rsp'\HARDWARE.RSP', 'USBEHCD.SYS', '?') = 1 ) | ( CheckKey( rsp'\HARDWARE.RSP', 'USBOHCD.SYS', '?') = 1 ) THEN DO
    CALL LINEOUT catalog, 'USBDOCK'
    USBDOCK = 1
    END

remote = VALUE('ECS_REMOTE_INSTALL',,'OS2ENVIRONMENT')
IF ( remote = '1') | ( remote = 'YES') THEN
    CALL LINEOUT catalog, 'SRVIFS'

CALL STREAM catalog, 'C', 'CLOSE'
CALL STREAM log1,    'C', 'CLOSE'

RETURN
